define([
        "cdes/core/CdesVoc",
        "clazzes/TinyLog",
        "clazzes/util/DOMHelper",
        "clazzes/widgets/layout/InfoDialog",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/string",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		CdesVoc,
    		TinyLog,
    		DOMHelper,
             InfoDialog,
    		domClass,
    		domConstruct,
    		on,
    		string,
    		lang,
    		i18n
    		) {
	
	var className = "at.cdes.web.util.SaveLoadHelper";
	
	var log = new TinyLog(className);
	
    var SaveLoadHelper = {
    		
    		convertToSet : function(a) {
    			var m = new Object();
    			for (var n = 0; n < a.length; n++) {
    				m[a[n]] = true;
    			}
    			return m;
    		},
    		
    		convertDtosForSave : function(params) {
    			var dtos = params.dtos;
    			var fancyDateAttributes = params.fancyDateAttributes != null ? params.fancyDateAttributes : [];
    			var fancyDateAttributesSet = SaveLoadHelper.convertToSet(fancyDateAttributes);
    			
    			var dndCellAttributes = params.dndCellAttributes != null ? params.dndCellAttributes : [];
    			var dndCellAttributesSet = SaveLoadHelper.convertToSet(dndCellAttributes);
    			
    			var attributeMappings = params.attributeMappings;
    			
    			var dtosForSave = [];
    			for (var n = 0; n < dtos.length; n++) {
    				dtosForSave.push(SaveLoadHelper.convertDtoForSave({
    					                   dto : dtos[n], 
    					fancyDateAttributesSet : fancyDateAttributesSet,
    					  dndCellAttributesSet : dndCellAttributesSet,
    					     attributeMappings : attributeMappings
    				}));
    			}
    			return dtosForSave;
    		},
    		
    		convertDtoForSave : function(params) {
    			
    			var dto = params.dto;
    			var fancyDateAttributesSet = params.fancyDateAttributesSet != null ? params.fancyDateAttributesSet : new Object();
    			var dndCellAttributesSet = params.dndCellAttributesSet != null ? params.dndCellAttributesSet : new Object();
    			var attributeMappings = params.attributeMappings != null ? params.attributeMappings : new Object();
    			    			
    			var dtoForSave = new Object();
    			for (var a in dto) {
    				var destAttributeName = (a in attributeMappings ? attributeMappings[a] : a);
    				
    				var value = dto[a];
    				if (a in dndCellAttributesSet) {
    					value = value.value;
    				}
    				
    				if (a in fancyDateAttributesSet) {
    					dtoForSave[destAttributeName] = value != null ? value.getUtcSeconds() : null;
    				} else {
    					dtoForSave[destAttributeName] = value;
    				}
    			}
    			return dtoForSave;
    		},
    		
    		constructResultSummaryDiv : function(resultSummary) {
        		var topDiv = domConstruct.create("div", null, null);
        		domClass.add(topDiv, "resultSummaryTopDiv occupyWholeParent");
        		
        		var header = i18n.resultSummaryContentStart;
        		
        		var operationStrings = [];
        		for (var table in resultSummary.receivedTuples) {
        			operationStrings.push(string.substitute(i18n.resultSummaryReceived, {
        				table : table,
        				count : resultSummary.receivedTuples[table]
        			}));
        		}
        		for (var table in resultSummary.receivedJoinComponentTuples) {
        			operationStrings.push(string.substitute(i18n.resultSummaryReceivedJoin, {
        				table : table,
        				count : resultSummary.receivedJoinComponentTuples[table]
        			}));
        		}        		
        		for (var table in resultSummary.insertedTuples) {
        			operationStrings.push(string.substitute(i18n.resultSummaryInserted, {
        				table : table,
        				count : resultSummary.insertedTuples[table]
        			}));
        		}
        		for (var table in resultSummary.updatedTuples) {
        			operationStrings.push(string.substitute(i18n.resultSummaryUpdated, {
        				table : table,
        				count : resultSummary.updatedTuples[table]
        			}));
        		}
        		for (var table in resultSummary.deletedTuples) {
        			operationStrings.push(string.substitute(i18n.resultSummaryDeleted, {
        				table : table,
        				count : resultSummary.deletedTuples[table]
        			}));
        		}     
        		
        		var	enumerationNode = DOMHelper.constructEnumeration(operationStrings);
        		
        		var captionLineTable = domConstruct.create("table", null, topDiv);
        		var captionLineTableRow = domConstruct.create("tr", null, captionLineTable);

        		var questionTD = domConstruct.create("td", null, captionLineTableRow);
        		var questionIcon = domConstruct.create("div", null, questionTD);
        		domClass.add(questionIcon, "clazzesInfoIcon32");
        		
        		DOMHelper.createTextNode("td", header, captionLineTableRow, "");

        		if (enumerationNode) {
        			domConstruct.place(enumerationNode, topDiv);	
        		}    		
        		
        		return topDiv;        		
    		},
    		
    		constructResultSummaryDialogIfDebug : function(givenLog, resultSummary, callbackFunction) {
	    		if (givenLog.isDebugEnabled()) {
    	    		var infoDialog = new InfoDialog({
    	    			   defaultWidth : 600,
    	    			  defaultHeight : 450, 
			                      title : i18n.resultSummaryCaption,
			                    content : SaveLoadHelper.constructResultSummaryDiv(resultSummary),
			                    buttons : [ { type : InfoDialog.Button.OK }
			                    		  ]    	    			
    	    		});
    	    		on(infoDialog, "confirm", callbackFunction);
    	    		infoDialog.show();    	    			
	    		} else {
	    			callbackFunction();
	    		}     			
    		}
    };
    return SaveLoadHelper;
});
