/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = jobList
////i18n-prefix = jobList


define([ "cdes/core/CdesVoc",
    "cdes/util/ActionHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/json",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
    ActionHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    topic,
    ErrorHelper,
    ContentWidget,
    InfoDialog,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    domClass,
    domConstruct,
    json,
    on,     
    string,
    declare,
    lang,
    Memory,
    Trackable,
    i18n
) {

    var className = "at.cdes.web.admin.job.JobListWidget";

    var log = new TinyLog(className);

    var JobListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "JobListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "jobList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
                    field : "jobType",
                       id : "type",
                formatter : lang.hitch(this, this.jobTypeFormatter),
                 sortable : true,
                    label : i18n.jobListTypeColumn
            });

            columns.push({
                    field : "personId",
                       id : "personId",
                formatter : lang.hitch(this, this.personFormatter),
                 sortable : true,
                    label : i18n.jobListOrganisationPersonColumn
            });

            columns.push({
                    field : "networkId",
                       id : "networkId",
                formatter : lang.hitch(this, this.networkFormatter),
                 sortable : true,
                    label : i18n.jobListNetworkColumn
            });

            columns.push({
                    field : "jobState",
                       id : "state",
                formatter : lang.hitch(this, this.stateFormatter),
                 sortable : true,
                    label : i18n.jobListStateColumn
            });

            columns.push({
                    field : "createTrxToTs",
                       id : "created",
                formatter : lang.hitch(this, this.dateTimeMillisFormatter),
                 sortable : true,
                    label : i18n.jobListCreatedColumn
            });

            columns.push({
                    field : "jobStartTimestamp",
                       id : "startTimestamp",
                formatter : lang.hitch(this, this.dateTimeMillisFormatter),
                 sortable : true,
                    label : i18n.jobListStartTimestampColumn
            });

            columns.push({
                    field : "jobEndTimestamp",
                       id : "endTimestamp",
                formatter : lang.hitch(this, this.dateTimeMillisFormatter),
                 sortable : true,
                    label : i18n.jobListEndTimestampColumn
            });

            columns.push({
                   field : "jobSize",
                      id : "size",
                sortable : true,
                   label : i18n.jobListSizeColumn
            });

            columns.push({
                     field : "jobUuid",
                        id : "actions",
                renderCell : lang.hitch(this, this.renderActionCell),
                  sortable : false,
                     label : i18n.actionColumnCaption
            });

            return columns;
        },

        stateFormatter : function(state, jobJoin) {
            if (state == CdesVoc.JobState.SCHEDULED) {
                return i18n.jobStateScheduled;
            } else if (state == CdesVoc.JobState.STARTED) {
                return i18n.jobStateStarted;
            } else if (state == CdesVoc.JobState.INTERRUPTED) {
                return i18n.jobStateInterrupted;
            } else if (state == CdesVoc.JobState.FINISHED) {
                return i18n.jobStateFinished;
            } else if (state == CdesVoc.JobState.FAILED) {
                return i18n.jobStateFailed;
            } else {
                return i18n.unknown;
            }           
        },      

        jobTypeFormatter : function(jobType, jobJoin) {
            if (jobType == CdesVoc.JobType.EXPORT_PDF_REPORT) {
                return i18n.jobListExportPdfReportType;
            } else if (jobType == CdesVoc.JobType.EXPORT_XLS_REPORT) {
                return i18n.jobListExportXlsReportType;
            } else if (jobType == CdesVoc.JobType.EXPORT_DOCUMENTS_TO_MSP) {
                return i18n.jobListExportDocumentsToMspType;
            } else if (jobType == CdesVoc.JobType.EXPORT_STATUTORY_DUTY_TO_MSP) {
                return i18n.jobListExportStatutoryDutyToMspType;
            } else if (jobType == CdesVoc.JobType.EXPORT_DOCUMENT_ARCHIVE) {
                return i18n.jobListExportDocumentArchive;                
            } else {
                return i18n.unknown;
            }           
        },      

        personFormatter : function(personId, jobJoin) {
            var givenName = jobJoin.personGivenName != null ? jobJoin.personGivenName : "";
            var surName = jobJoin.personSurName != null ? jobJoin.personSurName : "";
            if (givenName.length > 0 && surName.length > 0) {
                return givenName + " " + surName;           
            } else {
                return givenName + surName;
            }           
        },      

        networkFormatter : function(networkId, jobJoin) {
            return (jobJoin.networkName != null ? jobJoin.networkName : "")
                + (jobJoin.projectCode != null && jobJoin.projectName != null ? " / " + jobJoin.projectCode + " " + jobJoin.projectName : "");
        },

        dateTimeMillisFormatter : function(utcMillis, jobJoin) {
            if (utcMillis != null) {
                return DateHelper.formatUtcMillisWithTimeZone(utcMillis, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern); 
            } else {
                return "";
            }
        },


        renderActionCell : function(jobJoin, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);
            /*
            if ("projectParticipationsOverview" in project.allowedActions) {
                var showProjectParticipationsButton = this.constructShowProjectParticipationsButton(project);
                domConstruct.place(showProjectParticipationsButton.domNode, buttonDiv);
            }

            if ("editPlanningNotificationProject" in project.allowedActions) {
                var editButton = this.constructEditButton(project);
                domConstruct.place(editButton.domNode, buttonDiv);
            }

            if (!("editPlanningNotificationProject" in project.allowedActions) && "insertPlanningNotificationProject" in project.allowedActions) {
                var makeProjectAdminButton = this.constructMakeProjectAdministratorButton(project);
                domConstruct.place(makeProjectAdminButton.domNode, buttonDiv);
            }
            */

            if (jobJoin.jobId != null) {
                var showButton = this.constructShowButton(jobJoin);
                domConstruct.place(showButton.domNode, buttonDiv);            
            }                

            if (true) { // TODO privileges
                var destroyButton = this.constructDestroyButton(jobJoin);
                domConstruct.place(destroyButton.domNode, buttonDiv);
            }

//            if (jobJoin.jobType == CdesVoc.JobType.EXPORT_DOCUMENT_ARCHIVE) {
            if (true) {            
                var resultJson = jobJoin.jobResult;
                var archiveResult = resultJson != null ? json.parse(resultJson) : null;
                var fileName = archiveResult != null ? archiveResult.fileName : null;

                if (fileName != null) {
                    // Deliberately don't pass the fileName to the download code, since a senseful
                    // security check at server side can only be performed on the job id, not on
                    // the file name.                    
                    var downloadButton = this.constructDownloadButton(jobJoin);
                    domConstruct.place(downloadButton.domNode, buttonDiv);                
                }
            }                
            return buttonDiv;
        },

        constructShowButton : function(jobJoin) {
            var button = new FancyButton({
                    title : i18n.jobListShowToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 showButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                var jobId = jobJoin.jobId;
		this.applicationContext.setPage("jobResult",
		    { jobId : jobId },
		    { });
            }));
            return button;
        },

        constructDestroyButton : function(jobJoin) {
            var type = jobJoin.jobType;
            var state = jobJoin.jobState;            
            var title;
            if (type == CdesVoc.JobType.EXPORT_PDF_REPORT || type == CdesVoc.JobType.EXPORT_XLS_REPORT) {
                title = i18n.jobListDestroyToolTip;
            } else if (state == CdesVoc.JobState.SCHEDULED) {
                title = i18n.jobListDeletePlannedJob;
            } else if (state == CdesVoc.JobState.FINISHED || state == CdesVoc.JobState.FAILED || state == CdesVoc.JobState.STARTED) {
                title = i18n.jobListDeleteFinishedJob;
            }                

            var button = new FancyButton({
                    title : title,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                if (type == CdesVoc.JobType.EXPORT_PDF_REPORT || type == CdesVoc.JobType.EXPORT_XLS_REPORT) {
                    this.askDestroyJob(jobJoin);
                } else if (state == CdesVoc.JobState.SCHEDULED) {
                    this.askDeletePlannedJob(jobJoin);
                } else if (state == CdesVoc.JobState.FINISHED || state == CdesVoc.JobState.FAILED || state == CdesVoc.JobState.STARTED) {
                    this.askDeleteFinishedJob(jobJoin);
                }                    
            }));
            return button;
        },

        askDestroyJob : function(jobJoin) {
            var startTs = this.dateTimeMillisFormatter(jobJoin.jobStartTimestamp, jobJoin);
            var message = string.substitute(i18n.jobListAskDestroyJobDialogQuestion, {
                  startTs : startTs,
                givenName : jobJoin.personGivenName,
                  surName : jobJoin.personSurName           
            });         

            InfoDialog.showQuestion({
                  title : i18n.jobListAskDestroyJobDialogCaption,
                message : message,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doDestroyJob(jobJoin);
                    })},                           
                    { type : InfoDialog.Button.NO }
                ]
            });         
        },

        askDeletePlannedJob : function(jobJoin) {
            var message = string.substitute(i18n.jobListAskDeletePlannedJobDialogQuestion, {
                givenName : jobJoin.personGivenName,
                  surName : jobJoin.personSurName
            });

            InfoDialog.showQuestion({
                  title : i18n.jobListAskDeletePlannedJobDialogCaption,
                message : message,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doDeleteJob(jobJoin);
                    })},                           
                    { type : InfoDialog.Button.NO }
                ]
            });                     
        },            

        askDeleteFinishedJob : function(jobJoin) {
            var message = string.substitute(i18n.jobListAskDeleteFinishedJobDialogQuestion, {
                givenName : jobJoin.personGivenName,
                  surName : jobJoin.personSurName
            });

            InfoDialog.showQuestion({
                  title : i18n.jobListAskDeleteFinishedJobDialogCaption,
                message : message,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doDeleteJob(jobJoin);
                    })},                           
                    { type : InfoDialog.Button.NO }
                ]
            });                     
        },            

        doDestroyJob : function(jobJoin) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(JobListWidget.AsyncOperation.DESTROY_JOB);
            var networkService = this.applicationContext.getService("networkService");
            networkService.destroyJob(organisationPersonId, jobJoin.jobUuid).then(
                lang.hitch(this, function() {
                    on.emit(this, "jobDestroyed", jobJoin.jobUuid);

                    this.registerAsyncOperationFinished(JobListWidget.AsyncOperation.DESTROY_JOB);

                    topic.publish("message/ok", i18n.jobListDestroySuccessful);
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : JobListWidget.AsyncOperation.DESTROY_JOB,
                                opName : "destroyJob",
                               message : i18n.jobListDestroyFailed
                    });
                })).otherwise(lang.hitch(this, function(err) {
                        log.error("Error while calling function [destroyJob]", err);
                }));
        },      

        doDeleteJob : function(jobJoin) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(JobListWidget.AsyncOperation.DELETE_JOB);
            var networkService = this.applicationContext.getService("networkService");
            networkService.deleteJob(organisationPersonId, jobJoin.jobId).then(
                lang.hitch(this, function() {
                    on.emit(this, "jobDeleted", jobJoin.jobUuid);

                    this.registerAsyncOperationFinished(JobListWidget.AsyncOperation.DELETE_JOB);

                    topic.publish("message/ok", i18n.jobListDeleteSuccessful);
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : JobListWidget.AsyncOperation.DELETE_JOB,
                                opName : "deleteJob",
                               message : i18n.jobListDeleteFailed
                    });
                })).otherwise(lang.hitch(this, function(err) {
                        log.error("Error while calling function [deleteJob]", err);
                }));
        },      

        constructDownloadButton : function(jobJoin) {
            var resultJson = jobJoin.jobResult;
            var archiveResult = json.parse(resultJson);
            var fileName = archiveResult.fileName;  
            var fileNameString = string.substitute(i18n.jobListDownloadToolTip, {
                fileName : fileName});

	    var button = new FancyButton({
		    title : fileNameString,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 saveButton"
	    });
	    domClass.add(button.domNode, "listButton");

	    on(button, "click", lang.hitch(this, function() {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		window.open("/cdes-dojo-impl/repositoryDownload/jobTemp/" + organisationPersonId + "/" + jobJoin.jobId);
	    }));

	    return button;            
        },

        constructTopDiv : function() {
            var grid = this.constructGrid({
                idProperty : "jobUuid", 
                    gridId : "JobListWidgetGrid"
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                /*          
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var networkId = this.applicationContext.getPageContextPnNetworkId();
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort", e.sort);
                */
            }));

            return grid;        
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.jobJoins = params.jobs;
            /*
            this.projects = params.projects;
            var projectIdToAllowedActions = params.projectIdToAllowedActions;
            for (var n = 0; n < this.projects.length; n++) {
                var project = this.projects[n];
                var allowedActionsList = projectIdToAllowedActions[project.id];
                var allowedActionsSet = new Object();
                for (var z = 0; allowedActionsList != null && z < allowedActionsList.length; z++) {
                    allowedActionsSet[allowedActionsList[z]] = true;
                }

                project.allowedActions = allowedActionsSet;
            }
            */
            this.reload();
        },

        reload : function() {

            this.store.setData(this.jobJoins);
            /*
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort");

            if (oldSort == null) {
                this.grid.set("sort", "code", false);
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort", this.grid.get("sort"));
            } else {
                this.grid.set("sort", oldSort);
            }       
            */
            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();

        },

        destroy : function() {
            this.inherited(arguments);

            this.grid.destroy();
        }
    });

    JobListWidget.AsyncOperation = {
        DESTROY_JOB : "DestroyJob",
         DELETE_JOB : "DeleteJob"
    };

    return JobListWidget;
});
