/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = reviewSignList
////i18n-prefix = reviewSignList


define([ "cdes/planning/util/PlanningNotificationListHelper",
	"cdes/widget/base/ListWidget",
	"clazzes/TinyLog",
	"clazzes/form/FancyButton",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojox/html/entities",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(
			PlanningNotificationListHelper,
			ListWidget,
			TinyLog,
			FancyButton,
			DOMHelper,
			ErrorHelper,
			ContentWidget,
			domClass,
			domConstruct,
			domStyle,
			on,
			string,
			declare,
			lang,
			entities,
			i18n) {

	var className = "at.cdes.web.planning.task.ReviewSignListWidget";

	var log = new TinyLog(className);

	var ReviewSignListWidget = declare(className, ListWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "ReviewSignListWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		columnWidthKey : "reviewSignList/columnWidths",

		getLocalStorageContextKeys : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			return [organisationPersonId, networkId];
		},

		constructColumns : function() {
			var columns = [];

			if (this.batch) {
				// task
				PlanningNotificationListHelper.pushTaskColumn(columns);
				PlanningNotificationListHelper.pushOrderTextColumn(columns, this.orderTextFormatter);
				PlanningNotificationListHelper.pushProjectColumn(columns);

				// issued
				columns.push({
					field : "workflowTokenReviewMutTs",
					id : "issued",
					formatter : lang.hitch(this, this.dateTimeFormatterMillis),
					sortable : true,
					label : i18n.reviewSignListIssued
				});
			} else {
				// reviewer
				columns.push({
					field : "personId",
					id : "reviewer",
					formatter : lang.hitch(this, this.reviewerFormatter),
					sortable : true,
					label : i18n.reviewSignListReviewerColumnCaption
				});
			}                

			// comment
			columns.push({
				field : "comment",
				id : "comment",
				renderCell : lang.hitch(this, this.renderComment),
				sortable : true,
				label : i18n.reviewSignListCommentColumnCaption
			});

			// text
			columns.push({
				field : "workflowNodePositionResultOptionTitle",
				id : "result",
				sortable : true,
				label : i18n.reviewSignListResultColumnCaption
			});

			// attachments
			columns.push({
				field : "fileInfos",
				id : "attachments",
				renderCell : lang.hitch(this, this.renderAttachmentCell),
				sortable : true,
				label : i18n.reviewSignListAttachmentsColumnCaption
			});

			return columns;
		},

		orderTextFormatter : function(text, orderJoin) {
			if (text == null) {
				return "";
			} else if (text.length > 200) {
				return text.substr(0, 200) + ".....";
			} else {
				return text;
			}                
		},        

		reviewerFormatter : function(personId, data) {
			var pageContextPerson = this.applicationContext.getPageContextPerson();
			var pageContextOrganisation = this.applicationContext.getPageContextOrganisation();
			
			var prefix = string.substitute(i18n.reviewSignListReviewerPrefix, {
				organisationName : pageContextOrganisation.name,
				personGivenName : pageContextPerson.givenName,
				personSurName : pageContextPerson.surName		
			});

			var postfix;
			var organisationName = data.organisationName;
			var personGivenName = data.personGivenName;
            var personCommonName = data.personSurName;

            if (pageContextOrganisation.name != organisationName) {
				postfix = string.substitute(i18n.reviewSignListReviewerWithOrganisationPostfix, {
					personGivenName : personGivenName,
					personSurName : personCommonName,
					organisationName : organisationName
				});
            }
			else if (pageContextPerson.id != data.personId) {
				postfix = string.substitute(i18n.reviewSignListReviewerPostfix, {
					personGivenName : personGivenName,
					personSurName : personCommonName		    
				});
			} else {
				postfix = "";
			}		

			return prefix + postfix;	    
		},

		renderComment : function(data) {
			// Note: We regard the html here as safe, since we passed it through UtilService.getSafeHtml (based on Jsoup) before.
			var node = domConstruct.create("div", { innerHTML : data.comment });
			return node;
		},

		renderAttachmentCell : function(data) {
			var buttonDiv = domConstruct.create("div", null, null);

			for (var n = 0; data.fileInfos != null && n < data.fileInfos.length; n++) {
				var button = this.constructAttachmentButton(data.fileInfos[n]);
				domConstruct.place(button.domNode, buttonDiv);		
			}		

			return buttonDiv;
		},

		constructAttachmentButton : function(fileInfo) {
			var button = new FancyButton({
				title : fileInfo.label,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 attachmentIcon"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				var url = "/cdes-dojo-impl/repositoryDownload/temp/" + organisationPersonId + "/" + fileInfo.fileName;

				var downloadFrame = this.applicationContext.getFancyIFrame();
				downloadFrame.set("src", url);
			}));
			return button;            
		},

		constructTopDiv : function() {
			return this.constructGrid({
				idProperty : "workflowNodePositionId", 
				gridId : "ReviewSignListWidgetGrid"
			});
		},

		resize : function(newSize) {
			this.grid.resize(newSize);
		},

		setData : function(tokenInfos) {
			// Array of objects with
			// - organisationName
			// - personId
			// - personGivenName
			// - personSurName	    
			// - comment
			// - workflowNodePositionResultOptionId
			// - workflowNodePositionResultOptionTitle	    
			// - fileInfos: Array of objects { label, fileName },
			//   where label is usually the human readable name of the file,
			//   whereas fileName is the file name of or some id pointing
			//   to the	file in the temp repository
			this.data = tokenInfos;

			this.reload();
		},

		reload : function(params) {
			this.store.setData(this.data);

			this.grid.refresh();
		},

		destroy : function() {
			this.inherited(arguments);
		}
	});

	ReviewSignListWidget.AsyncOperation = {

	};

	return ReviewSignListWidget;
});
