define([ 
    "cdes/core/CdesVoc",
//    "cdes/pdc/PlanDeliverColumnWidget",
	"cdes/pdc/PlanDeliverHelper",
	"cdes/pdc/PlanDeliverListWidget",
	"cdes/pdc/PlanDeliverSearchWidget",
	"cdes/util/ActionHelper",
	"cdes/util/CodeHelper",
	"cdes/util/NameHelper",
//	"cdes/widget/ContextBar",
	"clazzes/TinyLog",
	"clazzes/topic",
	"clazzes/LoginGuardXhr",
	"clazzes/dateTime/DateHelper",
	"clazzes/util/DataHelper",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/JoinHelper",
	"clazzes/util/StringHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/DisableButton",
	"dijit/form/Button",
	"dijit/form/Select",
	"dijit/form/TextBox",
	"dojo/Deferred",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/hash",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/promise/all",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"
	],
	function(
            CdesVoc,
            //			PlanDeliverColumnWidget,
			PlanDeliverHelper,
			PlanDeliverListWidget,
			PlanDeliverSearchWidget,
			ActionHelper,
			CodeHelper,
			NameHelper,
//			ContextBar,
			TinyLog,
			topic,
			LoginGuardXhr,
			DateHelper,
			DataHelper,
			DOMHelper,
			ErrorHelper,
			JoinHelper,
			StringHelper,	
			WidgetHelper,
			ContentWidget,
			DisableButton,
			Button,
			Select,
			TextBox,
			Deferred,
			domClass,
			domConstruct,
			domStyle,
			hash,
			on,
			string,
			declare,
			lang,
			promiseAll,
			i18n
	) {

	var className = "at.cdes.web.plan.PlanDeliverCatalogue";

	var log = new TinyLog(className);
	var topicLog = new TinyLog(className + ".Topic");

	var PlanDeliverCatalogue = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this,params);

			this.manualColumns = false;
			this.lastQuickSearch = "";
			this.topDiv = this.constructTopDiv();

			this.mode = !this.mode ? PlanDeliverCatalogue.Mode.DEFAULT : this.mode;

			// The last searched DocumentList or DocumentListRelease id
			this.lastSearchedDocumentListId = null;

			var subProjectId = this.applicationContext.getPageContextSubProjectId();

			var planDeliverService = this.applicationContext.getService("planDeliverService");

			//registerBasePage
			var tabSessionContextService = this.applicationContext.getService("tabSessionContextService");
			var pageName = "planDeliverCatalogue";

			tabSessionContextService.addToPageList(dojoConfig.tabSessionId, pageName, true).then(
					lang.hitch(this, function() {
						if (log.isDebugEnabled()) {
							log.debug("Called UpdatePageContextService");
						}
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : null,
							opName : "UpdatePageContextService",
							message : i18n.updatePageContextServiceFailedMessage
						});     				
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while processing UpdatePageContextService: ", err);
							}));

			this.registerAsyncOperationStarted(PlanDeliverCatalogue.AsyncOperation.GET_DOCUMENT_LISTS);
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			planDeliverService.getPlanDeliverSearchData(organisationPersonId, subProjectId).then(lang.hitch(this, function(planDeliverSearchData) {
				planDeliverSearchData.documentListReleaseVersions.sort(function(v1, v2) {
					return v2.documentListReleaseVersion - v1.documentListReleaseVersion;
				});
				
				this.enableAutoInitSearch = planDeliverSearchData.enableAutoInitSearch;
				this.searchWidget.setPersonJoins(planDeliverSearchData.persons);
				this.searchWidget.setObjects(planDeliverSearchData.objects, planDeliverSearchData.objectTypeIdToObjectType);
			    this.searchWidget.setObjectPlanners(planDeliverSearchData.objectPlanners);
                this.searchWidget.setRoles(planDeliverSearchData.cdesRoles);

				//initialize searchWidget with data from localStorage
	     		if (!this.searchWidget.searchFieldsInitialized) {
	        		this.searchWidget.populateSearchFields();
	     			this.searchWidget.searchFieldsInitialized = true;
	     		}
				
				this.numberOfObjectListReleases = planDeliverSearchData.numberOfObjectListReleases;
				this.documentListReleaseVersions = planDeliverSearchData.documentListReleaseVersions;
			    this.setupVersionSelect(planDeliverSearchData.documentListReleaseVersions);
                this.listWidget.setContentLocales(planDeliverSearchData.contentLocales);
                this.contentLocales = planDeliverSearchData.contentLocales;

                //cameBack is set via this.applicationContext.popLastPageHistoryPage({ cameBack : true});
				if (this.enableAutoInitSearch || this.cameBack)
					this.reload();

				this.registerAsyncOperationFinished(PlanDeliverCatalogue.AsyncOperation.GET_DOCUMENT_LISTS);
			}),
			lang.hitch(this, function(err) {    			
				ErrorHelper.processAsyncError({
					err : err,
					widget : this,
					asyncOperation : PlanDeliverCatalogue.AsyncOperation.GET_DOCUMENT_LISTS,
					opName : "getDocumentListReleaseVersions",
					message : i18n.planDeliverCatalogueGetVersionsFailed
				});     				
			})
			).otherwise(lang.hitch(this, function(err) {
				log.error("Error while processing the results of a call to getDocumentListReleaseVersions: ", err);
			}));    		
			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanDeliverCatalogue";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {    		
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domConstruct.place(this.captionBarDiv, topDiv);

			// Search Widget
			this.searchWidget = new PlanDeliverSearchWidget({
				applicationContext : this.applicationContext
			});
			this.searchWidgetDiv = this.searchWidget.getContainer();
			domConstruct.place(this.searchWidgetDiv, topDiv);
			on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));
			on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));

			// Column Widget
			// NOTE: To reactivate column settings being user-configurable, uncomment this code block and all others that refer to this.columnWidget
			/*
    		this.columnWidget = new PlanDeliverColumnWidget({
    			applicationContext : this.applicationContext
    		});
    		this.columnWidgetDiv = this.columnWidget.getContainer();
    		domConstruct.place(this.columnWidgetDiv, topDiv);
    		on(this.columnWidget, "titlePaneToggled", lang.hitch(this, this.resize));
    		on(this.columnWidget, "columnsChanged", lang.hitch(this, this.processColumnsChanged));
    		this.columnWidget.setData(this.getDefaultColumnSettings());
			 */

			// Status Bar
			/*this.statusBarDiv = this.constructStatusBar();
			domClass.add(this.statusBarDiv, "planDeliverCatalogueStatusBar");
			domConstruct.place(this.statusBarDiv, topDiv);*/

			// List Widget
			this.listWidget = new PlanDeliverListWidget({
				applicationContext : this.applicationContext,
				mode : PlanDeliverListWidget.Mode.DEFAULT
			});
			this.listWidgetDiv = this.listWidget.getContainer();
			domConstruct.place(this.listWidgetDiv, topDiv);

			on(this.listWidget, "validStateChange", lang.hitch(this, this.updateWidgetState));

            this.listWidget.restoreColumnWidths();

			// Legend below List Widget
			this.legendDiv = PlanDeliverHelper.constructPlanDeliverLegend(topDiv);
			domConstruct.place(this.legendDiv, topDiv);

			// Hint Bar
			this.hintBarDiv = this.constructHintBar();
			domClass.add(this.hintBarDiv, "planDeliverCatalogueButtonBar");
			domConstruct.place(this.hintBarDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			// Caption Bar consisting of caption and context bar right of the caption
			var captionBarDiv = domConstruct.create("div", null, null);
			domClass.add(captionBarDiv, "cdesGeneralPageCaptionBar");

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planDeliverCatalogueCaption, captionBarDiv, "planDeliverCatalogueCaption");

			// Version
			var options = [];

			this.versionSelect = new Select({
				label : i18n.planDeliverCatalogueVersionLabel,
				title : i18n.planDeliverCatalogueVersionToolTip,
				options : options
			});
			domClass.add(this.versionSelect.domNode, "planDeliverCatalogueVersionSelect");
			domConstruct.place(this.versionSelect.domNode, captionBarDiv);
			WidgetHelper.handleSelectEvents(this.versionSelect, lang.hitch(this, function() {
				// Trigger new search, if and only if the value in the dropdown has actually changed
				var selectedDocumentListId = this.versionSelect.get("value");
				if (/*this.enableAutoInitSearch &&*/ (!this.lastSearchedDocumentListId || selectedDocumentListId != this.lastSearchedDocumentListId)) {
					this.reload();
				}
			}));

			this.captionButtonDiv = domConstruct.create("div", null, null);
			domClass.add(this.captionButtonDiv, "planDeliverCatalogueCaptionButtonDiv");
			domConstruct.place(this.captionButtonDiv, captionBarDiv);

			// New button
			this.newButton = new Button({
				label : i18n.planDeliverCatalogueNewButtonCaption,
				title : i18n.planDeliverCatalogueNewButtonToolTip,
				onClick : lang.hitch(this, this.startEnterNewEntries) 
			});
			domClass.add(this.newButton.domNode, "planDeliverCatalogueNewButton");
			domConstruct.place(this.newButton.domNode, this.captionButtonDiv);     		

			// Edit button
			this.editButton = new Button({
				label : i18n.planDeliverCatalogueEditButtonCaption,
				title : i18n.planDeliverCatalogueEditButtonToolTip,
				onClick : lang.hitch(this, this.startEditing) 
			});
			domClass.add(this.editButton.domNode, "planDeliverCatalogueEditButton");
			domConstruct.place(this.editButton.domNode, this.captionButtonDiv);    	   

			// Release button
			this.releaseButton = new Button({
				label : i18n.planDeliverCatalogueReleaseButtonCaption,
				title : i18n.planDeliverCatalogueReleaseButtonToolTip,
				onClick : lang.hitch(this, this.release) 
			});
			domClass.add(this.releaseButton.domNode, "planDeliverCatalogueReleaseButton");
			domConstruct.place(this.releaseButton.domNode, this.captionButtonDiv);

			// Save Button
			this.saveButton = new Button({
				label : i18n.planDeliverCatalogueSaveButtonCaption,
				title : i18n.planDeliverCatalogueSaveButtonToolTip,
				onClick : lang.hitch(this, this.saveWithoutAbort) 
			});
			domClass.add(this.saveButton.domNode, "planDeliverCatalogueSaveButton");
			domConstruct.place(this.saveButton.domNode, this.captionButtonDiv);

			// Save and Abort Editing Button
			this.saveAndAbortEditButton = new Button({
				label : i18n.planDeliverCatalogueSaveAndQuitEditButtonCaption,
				title : i18n.planDeliverCatalogueSaveAndQuitEditButtonToolTip,
				onClick : lang.hitch(this, this.saveAndAbortEdit) 
			});
			domClass.add(this.saveAndAbortEditButton.domNode, "planDeliverCatalogueSaveAndQuitEditButton");
			domConstruct.place(this.saveAndAbortEditButton.domNode, this.captionButtonDiv);

			// Save and Release Button
			this.saveAndReleaseButton = new Button({
				label : i18n.planDeliverCatalogueSaveAndReleaseButtonCaption,
				title : i18n.planDeliverCatalogueSaveAndReleaseButtonToolTip,
				onClick : lang.hitch(this, this.saveAndRelease) 
			});
			domClass.add(this.saveAndReleaseButton.domNode, "planDeliverCatalogueSaveAndReleaseButton");
			domConstruct.place(this.saveAndReleaseButton.domNode, this.captionButtonDiv); 

			// Abort Edit Button
			this.abortEditButton = new Button({
				label : i18n.planDeliverCatalogueAbortEditButtonCaption,
				title : i18n.planDeliverCatalogueAbortEditButtonToolTip,
				onClick : lang.hitch(this, function() {
					this.abortEditing(true); 
				})
			});
			domClass.add(this.abortEditButton.domNode, "planDeliverCatalogueAbortEditButton");
			domConstruct.place(this.abortEditButton.domNode, this.captionButtonDiv);
			
			// Export buttons
			this.constructExportToPdfButton();
			this.constructExportToXlsButton();

			return captionBarDiv;
		},

		constructExportToPdfButton : function() {
			var exportToPdfButton = new DisableButton({
				label : i18n.planDeliverCatalogueExportToPdfButtonCaption,
				showLabel : false,
				title : i18n.planDeliverCatalogueExportToPdfButtonToolTip,
				onClick : lang.hitch(this, function() {
					this.exportToPdf();
				}),
				iconClass : "exportToPdfButton",
				"class" : "cdesWebButton17x18 gridButton",
				controllerWidget : this,
				disableEvent : "disableButtons",
				_destroyOnRemove : true
			});    		
			domConstruct.place(exportToPdfButton.domNode, this.captionButtonDiv);    		
		},

		constructExportToXlsButton : function() {
			var exportToXlsButton = new DisableButton({
				label : i18n.planDeliverCatalogueExportToXlsButtonCaption,
				showLabel : false,
				title : i18n.planDeliverCatalogueExportToXlsButtonToolTip,
				onClick : lang.hitch(this, function() {
					this.exportToXls();
				}),
				iconClass : "exportToXlsButton",
				"class" : "cdesWebButton17x18 gridButton",
				controllerWidget : this,
				disableEvent : "disableButtons",
				_destroyOnRemove : true
			});    		
			domConstruct.place(exportToXlsButton.domNode, this.captionButtonDiv);    		
		},

		constructStatusBar : function() {
			var statusBarDiv = domConstruct.create("div", null, null);
			domClass.add(statusBarDiv, "refNodeOfPositionAbsolute");

			this.statusDiv = DOMHelper.createTextNode("div", i18n.notYetSearched, statusBarDiv, "fixedDialogWidget planDeliverCatalogueStatusDiv");

			// Quick Search
			this.quickSearchLabel = DOMHelper.createTextNode("div", i18n.planDeliverCatalogueQuickSearchLabel, statusBarDiv, "propertyLabel planDeliverCatalogueQuickSearchLabel");
			this.quickSearchTextBox = new TextBox({
				label : i18n.planDeliverCatalogueQuickSearchLabel,
				title : i18n.planDeliverCatalogueQuickSearchToolTip
			});
			domClass.add(this.quickSearchTextBox.domNode, "fixedDialogWidget planDeliverCatalogueQuickSearchTextBox");
			domConstruct.place(this.quickSearchTextBox.domNode, statusBarDiv);
			WidgetHelper.handleTextBoxEvents(this.quickSearchTextBox, lang.hitch(this, this.processQuickSearchChange));

			this.quickSearchClearButton = new Button({
				label : i18n.planDeliverCatalogueQuickSearchClearLabel,
				title : i18n.planDeliverCatalogueQuickSearchClearToolTip,
				onClick : lang.hitch(this, this.clearQuickSearch) 
			});
			domClass.add(this.quickSearchClearButton.domNode, "fixedDialogWidget planDeliverCatalogueQuickSearchClearButton");
			domConstruct.place(this.quickSearchClearButton.domNode, statusBarDiv);

			return statusBarDiv;
		},

		constructHintBar : function() {
			// Constructs the status bar for errors
			var hintBarDiv = domConstruct.create("div", null, null);
			domClass.add(hintBarDiv, "refNodeOfPositionAbsolute");
			domClass.add(hintBarDiv, "hidden");

			// Hint Icon
			this.hintIcon = domConstruct.create("div", null, hintBarDiv);
			domClass.add(this.hintIcon, "planDeliverCatalogueHintIcon clazzesWarnIcon32");    		
			// Hint Div
			this.hintSpan = DOMHelper.createTextNode("span", "", hintBarDiv, "planDeliverCatalogueHintSpan");

			return hintBarDiv;    		
		},

		processQuickSearchChange : function() {
			var newSearch = this.quickSearchTextBox.get("value");
			if (newSearch != this.lastQuickSearch) {
				this.listWidget.filter(newSearch);
				this.lastQuickSearch = newSearch;
			}
		},

		clearQuickSearch : function() {
			this.quickSearchTextBox.set("value", "", false);
			this.processQuickSearchChange();
		},

		getDefaultColumnSettings : function() {
			return {
				showPlannerPerson : true,
				showPlannerOrganisation : true,
				showComment : false,
				showObjectNumber : false,
				showObjectName : false,
				showObjectPlannerCode : false,
				showObjectPlannerName : false,
				showDocumentNumber : true,
				showDocumentName : true,
				showStart : true,
				showEnd : true,
				showScale : true,
				showPeriod : true
			};
		},

		resize : function(newSize) {

			// Resize can be called if the mode of the page changes, e.g. when editing the plan deliver catalogue, the widgets have to be re-arranged.
			// In this case, we don´t get a new size for the whole widget from outside, but rely on the previously saved size passed from extern
			// (from the PageChooser to be exactly).
			var totalHeight;
			if (newSize) {
				totalHeight = newSize.h;
				this.lastExternalSize = newSize;	
			} else if (this.lastExternalSize) {
				totalHeight = this.lastExternalSize.h;
			} else {
				totalHeight = window.innerHeight;
			}

			//var statusBarHeight = Math.max(this.statusDiv.offsetHeight, 50);
			//domStyle.set(this.statusBarDiv, "height", statusBarHeight);

			var searchWidgetHeight = (this.mode == PlanDeliverCatalogue.Mode.DEFAULT || this.mode == PlanDeliverCatalogue.Mode.EDITING)
					? (this.searchWidgetDiv.offsetHeight + domStyle.get(this.searchWidgetDiv, "margin-top") + domStyle.get(this.searchWidgetDiv, "margin-bottom")) : 0;
			var hintBarHeight = (this.mode == PlanDeliverCatalogue.Mode.DEFAULT || this.mode == PlanDeliverCatalogue.Mode.EDITING)
					? (this.hintBarDiv.offsetHeight + domStyle.get(this.hintBarDiv, "margin-top") + domStyle.get(this.hintBarDiv, "margin-bottom")) : 0;

			var tableWidth = this.captionBarDiv.offsetWidth - 15;
			var tableHeight = totalHeight
//			- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
			- this.captionBarDiv.offsetHeight
			//- this.captionNode.offsetHeight - domStyle.get(this.captionNode, "margin-top") - domStyle.get(this.captionNode, "margin-bottom") 
			- searchWidgetHeight
//			- this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
//			- statusBarHeight
			- (this.legendDiv.offsetHeight + 5)
			- hintBarHeight
			- 16;

			this.listWidget.resize({ w : tableWidth, h : tableHeight });	

		},

		setData : function() {
			// Search model is fetched automatically from searchWidget, thus nothing is to be done here.
		},

            cloneAndConvertSearchModelForServer : function(searchModel) {
                return {
                          organisationPersonId : searchModel.organisationPersonId,
                                     projectId : searchModel.projectId,
                                  subProjectId : searchModel.subProjectId,
                                documentListId : searchModel.documentListId,
                                    cdesRoleId : searchModel.cdesRoleId != CdesVoc.MagicSelectOption.ALL
                                                                         ? searchModel.cdesRoleId : null,
                                  cdesRoleName : searchModel.cdesRoleName,
                            plannerOrgPersonId : searchModel.plannerOrgPersonId != CdesVoc.MagicSelectOption.ALL
                                                                                 ? searchModel.plannerOrgPersonId : null,
                                   plannerName : searchModel.plannerName,
                                documentNumber : searchModel.documentNumber,
                                  documentName : searchModel.documentName,
                               objectReleaseId : searchModel.objectReleaseId != CdesVoc.MagicSelectOption.ALL
                                                                              ? searchModel.objectReleaseId : null,
                           objectReleaseString : searchModel.objectReleaseString,
                        objectPlannerReleaseId : searchModel.objectPlannerReleaseId != CdesVoc.MagicSelectOption.ALL
                                                                                     ? searchModel.objectPlannerReleaseId : null,
                    objectPlannerReleaseString : searchModel.objectPlannerReleaseString,
                           documentVersionFrom : searchModel.documentVersionFrom,
                             documentVersionTo : searchModel.documentVersionTo
                };
            },

		reload : function(params) {
			var successCallback = (params && params.successCallback) ? params.successCallback : null;

//			this.contextBar.reload();

			if (this.gotoUnreleasedVersion) {
				var options = this.versionSelect.get("options");
				this.versionSelect.set("value", options[0].value, false);
				delete this.gotoUnreleasedVersion;
			} else if (this.gotoFirstReleasedVersion) {
				var options = this.versionSelect.get("options");
				var index = (options.length >= 2 ? 1 : 0);

				this.versionSelect.set("value", options[index].value, false);
				delete this.gotoFirstReleasedVersion;
			}

			if (this.givenNewPlanDeliverJoin) {
				// Display the PlanDeliverJoins injected from outside, instead of a search result computed locally in the PlanDeliverCatalogue 
				this.processLoadedData(this.givenNewPlanDeliverJoin, true, false);

				// Assumption: If we have this.givenPlanDeliverJoin, then it contains the just newly created documents.
				//             (if we would add a second case, then we would have to distinguish it via some extra variable etc.)

				// New documents are inserted into the unreleased version
				this.versionSelect.set("value", this.unreleasedDocumentId, false);
				this.lastSearchedDocumentListId = this.unreleasedDocumentId;

				/*if (this.givenNewPlanDeliverJoin.joinDtos.length == 1) {
					DOMHelper.setInnerText(this.statusDiv, i18n.planDeliverCatalogueOneNewDocumentInserted);
				} else {
					DOMHelper.setInnerText(this.statusDiv, string.substitute(i18n.planDeliverCatalogueNewDocumentsInserted, {
						numberOfDocuments : this.givenNewPlanDeliverJoin.joinDtos.length,
						documentString : this.givenNewPlanDeliverJoin.joinDtos.length == 1 ? i18n.oneDocument : i18n.manyDocuments 
					}));    				
				}*/

				// Finally delete the injected PlanDeliverJoins, the next search should work as usual
				delete this.givenNewPlanDeliverJoin;
			} else if (this.givenOldPlanDeliverJoin) {
				// Display the PlanDeliverJoinDtos that where displayed before some other page (e.g. add new documents) was entered
				// and aborted later.
				this.processLoadedData(this.givenOldPlanDeliverJoin, true, false);

				delete this.givenOldPlanDeliverJoin;
			} else if (this.givenReleasedData) {
				this.processLoadedData(this.givenReleasedData);

				var status = this.constructPlanDeliverReleaseMessage(this.givenReleasedData.resultSummary);
				//DOMHelper.setInnerText(this.statusDiv, status);

				delete this.givenReleasedData;
			} else {
				// Setup searchmodel
				var searchModel = this.searchWidget.getSearchModel();
				searchModel.organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				searchModel.projectId = this.applicationContext.getPageContextProjectId();
				searchModel.subProjectId = this.applicationContext.getPageContextSubProjectId();
				searchModel.documentListId = this.versionSelect.get("value");
				if (typeof searchModel.documentListId == "string" ) {
					searchModel.documentListId = null;
				}

				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				var networkId = this.applicationContext.getPageContextNetworkId();
				this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planDeliver/search", searchModel);

				// Record for which version we have searched last, the versionSelect will only trigger a new search lateron 
				// if the selected version is actually different
				this.lastSearchedDocumentListId = searchModel.documentListId;

				var planDeliverService = this.applicationContext.getService("planDeliverService");
				var project = this.applicationContext.getPageContextProject();

				// If the previous search still runs, cancel it
				if (this.joinDeferred != null) {
					if (log.isDebugEnabled())
						log.info("Previous joinDeferred still runs, will cancel it.");
					this.joinDeferred.cancel();
				}

				if (log.isDebugEnabled()) {
					log.debug("Will execute plan deliver join, documentListId = " + searchModel.documentListId + ", unreleased: " + this.unreleasedDocumentId);	
				}    		

                            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

				// Trigger async search request
				this.joinDeferred = searchModel.documentListId == this.unreleasedDocumentId
								? planDeliverService.getPlanDeliverUnreleasedJoin(searchModel) : planDeliverService.getPlanDeliverReleasedJoin(searchModel);

				// Print out that a search is running, discard the previous data immediately, to avoid disturbing the user
				//DOMHelper.setInnerText(this.statusDiv, i18n.searchRuns);
				this.listWidget.setData({ data : [] });

				var loadMasterDataDeferred = null;
				if (this.mode == PlanDeliverCatalogue.Mode.EDITING) {
					var networkId = this.applicationContext.getPageContextNetworkId();
					loadMasterDataDeferred = this.applicationContext.loadMasterData(networkId);
					this.startEditing();
				} else {
					loadMasterDataDeferred = new Deferred();
					loadMasterDataDeferred.resolve();
				}

                //this.quickSearchTextBox.set("value", "");

				// Update button state etc.
				this.registerAsyncOperationStarted(PlanDeliverCatalogue.AsyncOperation.GET_DATA);
				//this.updateWidgetState();
				promiseAll([this.joinDeferred, loadMasterDataDeferred]).then(lang.hitch(this, function(resultArray) {

					this.processLoadedData(resultArray[0], searchModel.documentListId == this.unreleasedDocumentId, true);
					delete this.joinDeferred;

					this.registerAsyncOperationFinished(PlanDeliverCatalogue.AsyncOperation.GET_DATA);
					this.updateWidgetState();

					if (successCallback) {
						successCallback();
					}
				}),
				lang.hitch(this, function(err) {    
					delete this.joinDeferred;
					ErrorHelper.processAsyncError({
						err : err,
						widget : this,
						asyncOperation : PlanDeliverCatalogue.AsyncOperation.GET_DATA,
						opName : "getPlanDeliver<Released|Unreleased>Join",
						message : i18n.planDeliverCatalogueSearchFailed
					});       				
				})
				).otherwise(lang.hitch(this, function(err) {
					log.error("Error while processing the results of calling getPlanDeliverJoin or getting documentNumberSpec: ", err);
				}));
			}
		},

		processLoadedData : function(planDeliverJoin, unreleased, emitMessage) {
			this.planDeliverJoin = planDeliverJoin;

			// As we LEFT JOIN documents etc. to the document_list, in the case that we have no documents, a joinDto instance with
			// document_list but without document exists.  Filter it out to prevent trouble lateron.
			// (the sense of that LEFT JOIN is always having a document_list instance with version information).
			this.planDeliverJoin.joinDtos = PlanDeliverHelper.filterForNonEmptyDocuments(this.planDeliverJoin.joinDtos);

			this.planDeliverJoinDtos = this.planDeliverJoin.joinDtos;
			var documentIdToHistoryItems = this.planDeliverJoin.documentIdToHistoryItems;
			this.objectPlannerIdToActions = ActionHelper.transformObjectPlannerIdToActions(this.planDeliverJoin.objectPlannerIdToActions);

			if (log.isDebugEnabled())
				log.info("Received objectPlannerIdToActions: ", this.objectPlannerIdToActions);

			var plannerMap = PlanDeliverHelper.getPlannerMap(this.planDeliverJoinDtos);
			var objectMap = PlanDeliverHelper.getObjectMap(this.planDeliverJoinDtos);
			var objectPlannerMap = PlanDeliverHelper.getObjectPlannerMap(this.planDeliverJoinDtos);

			var searchInfoString = PlanDeliverHelper.getSearchInfoString(this.planDeliverJoinDtos, plannerMap, objectMap, objectPlannerMap);
			//DOMHelper.setInnerText(this.statusDiv, searchInfoString);

			if (emitMessage) {
				topic.publish("message/ok", searchInfoString);
			}

			var columnSettings = this.getAutomaticColumnSettings(plannerMap, objectMap, objectPlannerMap);
			this.listWidget.setData({             
				data : this.planDeliverJoinDtos,
				columns : columnSettings,
				documentIdToHistoryItems : documentIdToHistoryItems,
				objectPlannerIdToActions : this.objectPlannerIdToActions,
				unreleased : unreleased,
				actualReleased : this.actualReleasedDocumentId == this.versionSelect.get("value"),
				numberOfObjectListReleases : this.numberOfObjectListReleases
			});    		
		},

		updateWidgetState : function() {
			var operationRunning = this.isAsyncOperationRunning();

			domClass.remove(this.captionButtonDiv, "hidden");
			/*domClass.add(this.searchWidgetDiv, "hidden");

			domClass.add(this.quickSearchLabel, "hidden");
			domClass.add(this.quickSearchTextBox.domNode, "hidden");
			domClass.add(this.quickSearchClearButton.domNode, "hidden");
*/
			domClass.add(this.saveButton.domNode, "hidden");
			domClass.add(this.saveAndAbortEditButton.domNode, "hidden");
			domClass.add(this.saveAndReleaseButton.domNode, "hidden");

			domClass.add(this.abortEditButton.domNode, "hidden");
			domClass.add(this.listWidgetDiv, "hidden");
			var unreleased = this.versionSelect.get("value") == this.unreleasedDocumentId;


			// TODO: VisitHelperImpl.getSigner only accepts role releasePlanDeliverCatalogue given via project context.
			// The privilege system implemented so far also regards that role in network context as sufficient.
			// In such a case, the GUI will display the button as enabled, and things will then fail on the server side because
			// the SQL cannot find a valid signer
			// See: at.cdes.impl.dao.jdbc.JdbcProjectParticipantDAO.getSigner(Long, Long, String)
			// The solution would be refacoring the join in at.cdes.impl.dao.jdbc.JdbcActionDAO.getObjectPlannerActions(Long, List<Long>, String...)
			// such that it is one join with unions, and the component is extracted automatically.
			var releaseDisabled = operationRunning
								|| this.numberOfObjectListReleases == 0
								|| this.planDeliverJoinDtos.length == 0
								|| !unreleased
								|| !this.applicationContext.isActionAllowedForProject("releasePlanDeliverCatalogue", { projectContext : true });
			var newDisabled = operationRunning
							|| this.numberOfObjectListReleases == 0
							|| !ActionHelper.hasAnyObjectPlannerNewPermission(this.objectPlannerIdToActions);
			var editDisabled = operationRunning 
							|| this.numberOfObjectListReleases == 0
							|| !this.planDeliverJoinDtos
							|| (   !ActionHelper.hasAnyObjectPlannerEditPermission(this.objectPlannerIdToActions)
										&& !this.applicationContext.isActionAllowedForProject("editPlanDeliverCatalogueDatesProjCont"));

			if (this.mode == PlanDeliverCatalogue.Mode.DEFAULT) {    			

				DOMHelper.setInnerText(this.captionDiv, i18n.planDeliverCatalogueCaption);
				domClass.add(this.newButton.domNode, "hidden");
				domClass.add(this.releaseButton.domNode, "hidden");
				domClass.remove(this.editButton.domNode, "hidden");
				if (unreleased)
					domClass.remove(this.releaseButton.domNode, "hidden");
				
				domClass.add(this.saveButton.domNode, "hidden");
				domClass.add(this.saveAndAbortEditButton.domNode, "hidden");
				domClass.add(this.saveAndReleaseButton.domNode, "hidden");
				
				domClass.remove(this.searchWidgetDiv, "hidden");
				/*domClass.remove(this.quickSearchLabel, "hidden");
				domClass.remove(this.quickSearchTextBox.domNode, "hidden");
				domClass.remove(this.quickSearchClearButton.domNode, "hidden"); */   			

				domClass.remove(this.listWidgetDiv, "hidden");

				this.editButton.set("disabled", editDisabled);
				this.releaseButton.set("disabled", releaseDisabled);

				this.saveButton.set("disabled", editDisabled);
				this.saveAndAbortEditButton.set("disabled", editDisabled);
				this.saveAndReleaseButton.set("disabled", releaseDisabled);

			} else if (this.mode == PlanDeliverCatalogue.Mode.EDITING) {
				DOMHelper.setInnerText(this.captionDiv, i18n.planDeliverCatalogueEditCaption);
				this.oldSelectedVersion = this.versionSelect.get("value");
				this.versionSelect.set("value", this.unreleasedDocumentId);

				domClass.remove(this.newButton.domNode, "hidden");
				domClass.add(this.releaseButton.domNode, "hidden");
				domClass.add(this.editButton.domNode, "hidden");

				domClass.remove(this.saveButton.domNode, "hidden");
				domClass.remove(this.saveAndAbortEditButton.domNode, "hidden");
				domClass.remove(this.saveAndReleaseButton.domNode, "hidden");
				domClass.remove(this.abortEditButton.domNode, "hidden");

				domClass.remove(this.listWidgetDiv, "hidden");

				var listWidgetValid = this.listWidget.isValid();
				var hint = this.listWidget.getHint();

				if (hint != null) {
					domClass.remove(this.hintBarDiv, "hidden");
					DOMHelper.setInnerText(this.hintSpan, hint);	
				} else {
					domClass.add(this.hintBarDiv, "hidden");
					DOMHelper.setInnerText(this.hintSpan, "");	
				}

				var saveDisabled = !listWidgetValid 
									|| this.listWidget.getData().length == 0;
				
				this.newButton.set("disabled", newDisabled);
				this.saveButton.set("disabled", saveDisabled);
				this.saveAndAbortEditButton.set("disabled", saveDisabled);

				var saveAndReleaseDisabled = operationRunning
									|| this.numberOfObjectListReleases == 0
									|| this.planDeliverJoinDtos.length == 0
									|| !listWidgetValid
									|| !this.applicationContext.isActionAllowedForProject("releasePlanDeliverCatalogue", { projectContext : true });
				this.saveAndReleaseButton.set("disabled", saveAndReleaseDisabled); 

			} else if (this.mode == PlanDeliverCatalogue.Mode.RELEASING) {
				domClass.add(this.captionButtonDiv, "hidden");
			} else {
				throw new Error("UpdateWidgetState received invalid mode: [" + this.mode + "]");
			}

			this.versionSelect.set("disabled", this.mode == PlanDeliverCatalogue.Mode.EDITING);
			this.resize();
		},

		processColumnsChanged : function() {
			/*
			var columnSettings = this.columnWidget.getColumnSettings();
			this.listWidget.setColumns(columnSettings);
			this.manualColumns = true;
			 */			
		},

		getAutomaticColumnSettings : function(plannerMap, objectMap, objectPlannerMap) {
			var columnSettings = {
					showPlannerPerson : false,
					showPlannerOrganisation : false,
					showComment : true,
					showObjectNumber : false,
					showObjectName : false,
					showObjectPlannerCode : false,
					showObjectPlannerName : false,
					showDocumentNumber : true,
					showDocumentName : true,
					showStart : true,
					showEnd : true,
					showScale : true,
					showPeriod : true
			};

			var numberOfPlanners = DataHelper.getMapSize(plannerMap);
			columnSettings.showPlannerPerson = (numberOfPlanners > 1);
			columnSettings.showPlannerOrganisation = (numberOfPlanners > 1);

			var numberOfObjects = DataHelper.getMapSize(objectMap);
			columnSettings.showObjectNumber = (numberOfObjects > 1);
			columnSettings.showObjectName = (numberOfObjects > 1);

			var numberOfObjectPlanners = DataHelper.getMapSize(objectPlannerMap);
			columnSettings.showObjectPlannerCode = (numberOfObjectPlanners > 1);
			columnSettings.showObjectPlannerName = (numberOfObjectPlanners > 1);

			return columnSettings;
		},

		setupVersionSelect : function(documentListReleaseVersions) {
			var versionSelectInfo = PlanDeliverHelper.constructVersionOptions({
				applicationContext : this.applicationContext,
				documentListReleaseVersions : documentListReleaseVersions
			});

			var options = versionSelectInfo.options;
			this.unreleasedDocumentId = versionSelectInfo.unreleasedDocumentId;
			this.actualReleasedDocumentId = versionSelectInfo.actualReleasedDocumentId;

			this.versionSelect.set("options", options);     		

			// Select first released version, if it exists, and otherwise the unreleased version
			if (options.length > 1) {
				this.versionSelect.set("value", options[1].value, false);	
			} else if (options.length > 0) {
				this.versionSelect.set("value", options[0].value, false);	
			}
		},

		startEnterNewEntries : function() {
			var selectedDocumentListId = this.versionSelect.get("value");
			if (this.unreleasedDocumentId != null && selectedDocumentListId != this.unreleasedDocumentId) {     		
				// Trigger a reload of the unreleased plan deliver catalogue
				this.versionSelect.set("value", this.unreleasedDocumentId, false);
			}

			var searchModel = this.searchWidget.getSearchModel();
			var objects = this.searchWidget.objects;
			var objectPlanners = this.searchWidget.objectPlanners;
			var objectId;
			var objectPlannerId;
			
			if (objects && searchModel.objectReleaseId){
				//doesn't work for IE11
//				objectId = objects.find(element => element.id == searchModel.objectReleaseId).objectId;
     			for (var n = 0; n < objects.length; n++) {
     				if (searchModel.objectReleaseId == objects[n].id)
     					objectId = objects[n].objectId;
     			}
				
			}
			if (objectPlanners && searchModel.objectPlannerReleaseId){
//				objectPlannerId = objectPlanners.find(element => element.id == searchModel.objectPlannerReleaseId).objectPlannerId;
     			for (var n = 0; n < objectPlanners.length; n++) {
     				if (searchModel.objectPlannerReleaseId == objectPlanners[n].id)
     					objectPlannerId = objectPlanners[n].objectPlannerId;
     			}
			}
				
			this.applicationContext.setPage("planDeliverNew", {}, {
				documentListReleaseVersions : this.documentListReleaseVersions,
							 presetObjectId : objectId, 
				  	  presetObjectPlannerId : objectPlannerId,
				   objectPlannerIdToActions : this.objectPlannerIdToActions,
				           	 contentLocales : this.contentLocales
			});
		},

		startEditing : function() {
			var selectedDocumentListId = this.versionSelect.get("value");
			if (this.unreleasedDocumentId != null && selectedDocumentListId != this.unreleasedDocumentId) {
				// Trigger a reload of the unreleased plan deliver catalogue, and start editing it.
				this.versionSelect.set("value", this.unreleasedDocumentId, false);

				this.mode = PlanDeliverCatalogue.Mode.EDITING;
				this.reload({ successCallback : lang.hitch(this, function() {
					this.listWidget.startEditing();
					this.updateWidgetState();
				})});
			} else {
				this.mode = PlanDeliverCatalogue.Mode.EDITING;
				this.listWidget.startEditing();
				this.updateWidgetState();
			}
		},

		abortEditing : function(doRestoreOriginalJoinDtos) {
			//this.listWidget.abortEditing(doRestoreOriginalJoinDtos);
			this.listWidget.abortEditing(false);

			this.mode = PlanDeliverCatalogue.Mode.DEFAULT;

			if (doRestoreOriginalJoinDtos) {
				this.versionSelect.set("value", this.oldSelectedVersion);
			}

			this.reload({
				successCallback : lang.hitch(this, function() {
					this.resize();
				})
			});
		},

		constructPlanDeliverReleaseMessage : function(resultSummary) {
			return i18n.planDeliverCatalogueReleaseInfo;
		},

		save : function(successFunction) {
			var newPlanDeliverJoinDtos = this.listWidget.getPlanDeliverJoinDtosForSave();
			if (log.isDebugEnabled())
				log.info("New joinDtos: ", newPlanDeliverJoinDtos);

			var documents = JoinHelper.getJoinDtoComponent(newPlanDeliverJoinDtos, "document");
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

			var subProjectId = this.applicationContext.getPageContextSubProjectId();
			var projectId = this.applicationContext.getPageContextProjectId();
			var networkId = this.applicationContext.getPageContextNetworkId();     		

			this.registerAsyncOperationStarted(PlanDeliverCatalogue.AsyncOperation.SAVE);
			var planDeliverService = this.applicationContext.getService("planDeliverService");
			planDeliverService.savePlanDeliverCatalogue(documents, [], organisationPersonId, subProjectId, projectId, networkId).then(lang.hitch(this, function(saveResult) {

				this.listWidget.mergeSaveResult(saveResult);
				this.listWidget.updateCalendarSpinnerDisabledState();

				topic.publish("message/ok", string.substitute(i18n.planDeliverCatalogueSaveOk, {
					numberOfDocuments : saveResult.updatedDocuments.length.toString()
				}));

				if (successFunction) {
					successFunction();
				}

				this.registerAsyncOperationFinished(PlanDeliverCatalogue.AsyncOperation.SAVE);
			}),
			lang.hitch(this, function(err) {    			
				ErrorHelper.processAsyncError({
					err : err,
					widget : this,
					asyncOperation : PlanDeliverCatalogue.AsyncOperation.SAVE,
					opName : "savePlanDeliverCatalogue",
					message : i18n.planDeliverCatalogueSaveFailed
				});      				
			})
			).otherwise(lang.hitch(this, function(err) {
				log.error("Error while processing the results of a call to savePlanDeliverCatalogue: ", err);
			}));
		},

		saveWithoutAbort : function() {
			this.save();
		},

		saveAndAbortEdit : function() {
			this.save(lang.hitch(this, function() {
				this.abortEditing(false);
			}));
		},

		saveAndRelease : function() {

			// If e.g. the user has deleted the last visible document, then nothing to save remains.
			// Still, releasing the plan deliver catalogue is senseful in that case.
			var anythingToSave = this.listWidget.getData().length > 0;
			if (anythingToSave) {
				this.save(lang.hitch(this, this.release));	
			} else {
				this.release();
			}     		
		},

		release : function() {
			this.applicationContext.setPage("planDeliverRelease", {}, {
				// Pass no data to ensure that always the current data is displayed in the PlanDeliverReleasePage
			});
		},

		exportToXls : function() {
			var documentListId = this.versionSelect.get("value");
			if (documentListId) {
				var page = documentListId == this.unreleasedDocumentId ? "UnreleasedPlanDeliverCatalogueExportOOo" : "PlanDeliverCatalogueExportOOo";

				var searchModel = this.searchWidget.getSearchModel();
				var sortSpecs = this.listWidget.getSortSpecs();

				var url = "/cdes/app?service=OOo2PDFService/1/" + page + "/xls/planDeliverCatalogueOverview/Planlieferkatalog&sp=" + documentListId 
				+ "&sp=S" + searchModel.documentNumber + "&sp=S" + searchModel.documentName 
				+ "&sp=" + (searchModel.documentVersionFrom!=null?searchModel.documentVersionFrom:"-1") 
				+ "&sp=" + (searchModel.documentVersionTo!=null?searchModel.documentVersionTo:"-1")
				+ "&sp=" + (searchModel.plannerOrgPersonId!=null?searchModel.plannerOrgPersonId:"-1") 
    + "&sp=" + (searchModel.objectReleaseId!=null && searchModel.objectReleaseId != CdesVoc.MagicSelectOption.ALL?searchModel.objectReleaseId:"-1") 
    + "&sp=" + (searchModel.objectPlannerReleaseId!=null && searchModel.objectPlannerReleaseId != CdesVoc.MagicSelectOption.ALL?searchModel.objectPlannerReleaseId:"-1")
				+ "&sp=S" + this.searchWidget.objectComboBox.get("value") + "&sp=S" + this.searchWidget.objectPlannerComboBox.get("value") + "&sp=S" + this.searchWidget.plannerComboBox.get("value") 
				+ "&sp=S" + sortSpecs[0].first + "&sp=S" + sortSpecs[0].second 
				+ "&ts=" + dojoConfig.tabSessionId;
				window.open(url);     			
			} else {
				throw new Error("No documentListId available when exporting to xls");
			}
		},

		exportToPdf : function() {
			var documentListId = this.versionSelect.get("value");
			if (documentListId) {
				var page = documentListId == this.unreleasedDocumentId ? "UnreleasedPlanDeliverCatalogueOverviewOOo" : "PlanDeliverCatalogueOverviewOOo";

				var searchModel = this.searchWidget.getSearchModel();
				var sortSpecs = this.listWidget.getSortSpecs();

				var url = "/cdes/app?service=OOo2PDFService/1/" + page + "/pdf/planDeliverCatalogueOverview/Planlieferkatalog&sp=" + documentListId 
				+ "&sp=S" + searchModel.documentNumber + "&sp=S" + searchModel.documentName 
				+ "&sp=" + (searchModel.documentVersionFrom!=null?searchModel.documentVersionFrom:"-1") 
				+ "&sp=" + (searchModel.documentVersionTo!=null?searchModel.documentVersionTo:"-1")
				+ "&sp=" + (searchModel.plannerOrgPersonId!=null?searchModel.plannerOrgPersonId:"-1") 
    			+ "&sp=" + (searchModel.objectReleaseId!=null && searchModel.objectReleaseId != CdesVoc.MagicSelectOption.ALL?searchModel.objectReleaseId:"-1") 
    			+ "&sp=" + (searchModel.objectPlannerReleaseId!=null && searchModel.objectPlannerReleaseId != CdesVoc.MagicSelectOption.ALL?searchModel.objectPlannerReleaseId:"-1")
				+ "&sp=S" + this.searchWidget.objectComboBox.get("value") + "&sp=S" + this.searchWidget.objectPlannerComboBox.get("value") + "&sp=S" + this.searchWidget.plannerComboBox.get("value") 
				+ "&sp=S" + sortSpecs[0].first + "&sp=S" + sortSpecs[0].second 
				+ "&ts=" + dojoConfig.tabSessionId;
				window.open(url);     			
			} else {
				throw new Error("No documentListId available when exporting to pdf");
			}     		
		},

		destroy : function() {
			this.inherited(arguments);
			this.listWidget.destroy();
		}
	});

	PlanDeliverCatalogue.Mode = {
			DEFAULT : "Default",
			EDITING : "Editing",
			RELEASING : "Releasing"
	};

	PlanDeliverCatalogue.AsyncOperation = {
			GET_DOCUMENT_LISTS : "GetDocumentLists",
			GET_DATA : "GetData",
			SAVE : "Save"
	};

	return PlanDeliverCatalogue;
});
