/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = planningNotificationTaskColumn
//// i18n-prefix = planningNotificationTaskColumn


define(["cdes/util/ColumnHelper",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/IconTitlePane",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/CheckBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(ColumnHelper,
    TinyLog,
    DOMHelper,
    WidgetHelper,
    IconTitlePane,
    ContentWidget,
    CheckBox,
    domClass,
    domConstruct,
    on,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.planning.task.PlanningNotificationTaskColumnWidget";

    var log = new TinyLog(className);

    var PlanningNotificationTaskColumnWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationTaskColumnWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute planningNotificationTaskColumnReduced");

            this.titlePane = this.constructTitlePane();
            domConstruct.place(this.titlePane.domNode, topDiv);

            return topDiv;
        },

        postTitleClick : function() {
            var open = this.titlePane.get("open");

            if (open) {
                this.titlePane.set("title", i18n.columnOpenCaption);
                domClass.replace(this.topDiv, "planningNotificationTaskColumnFull", "planningNotificationTaskColumnReduced");
            } else {
                this.titlePane.set("title", i18n.columnClosedCaption);
                domClass.replace(this.topDiv, "planningNotificationTaskColumnReduced", "planningNotificationTaskColumnFull");
            }

            on.emit(this, "titlePaneToggled");
        },

        constructTitlePane : function() {
            var contentDiv = this.constructContentDiv();

            var titlePane = new IconTitlePane({
                       title   : i18n.columnClosedCaption,
                       content : contentDiv,
                    toggleable : true,
                          open : false,
                postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "occupyWholeParent");

            return titlePane;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationTaskColumnContentDiv");

            // TaskCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationTaskTaskLabel, contentDiv, "fixedDialogWidget planningNotificationTaskColumnTaskLabel");
            this.taskCheckBox = new CheckBox({
                label : i18n.planningNotificationTaskTaskLabel,
                title : i18n.planningNotificationTaskColumnTaskToolTip
            });
            domClass.add(this.taskCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnTaskCheckBox");
            domConstruct.place(this.taskCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.taskCheckBox, "task");

            // TokenInitiatorCheckBox
            DOMHelper.createTextNode("div", i18n.workflowActivityResultListTokenInitiator, contentDiv, "fixedDialogWidget planningNotificationTaskColumnTokenInitiatorLabel");
            this.tokenInitiatorCheckBox = new CheckBox({
                label : i18n.workflowActivityResultListTokenInitiator,
                title : i18n.workflowActivityResultListTokenInitiator
            });
            domClass.add(this.tokenInitiatorCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnTokenInitiatorCheckBox");
            domConstruct.place(this.tokenInitiatorCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.tokenInitiatorCheckBox, "tokenInitiator");

            // SerialNumberCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderSerialNumberLabel, contentDiv,
                "fixedDialogWidget planningNotificationTaskColumnSerialNumberLabel");
            this.serialNumberCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderSerialNumberLabel,
                title : i18n.planningNotificationOrderSerialNumberToolTip
            });
            domClass.add(this.serialNumberCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnSerialNumberCheckBox");
            domConstruct.place(this.serialNumberCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.serialNumberCheckBox, "serialNumber");

            // TextCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderTextLabel, contentDiv, "fixedDialogWidget planningNotificationTaskColumnTextLabel");
            this.textCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderTextLabel,
                title : i18n.planningNotificationOrderTextToolTip
            });
            domClass.add(this.textCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnTextCheckBox");
            domConstruct.place(this.textCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.textCheckBox, "text");

            // PlanningNotificationCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderPlanningNotificationLabel, contentDiv,
                "fixedDialogWidget planningNotificationTaskColumnPlanningNotificationLabel");
            this.planningNotificationCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderPlanningNotificationLabel,
                title : i18n.planningNotificationOrderPlanningNotificationToolTip
            });
            domClass.add(this.planningNotificationCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnPlanningNotificationCheckBox");
            domConstruct.place(this.planningNotificationCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.planningNotificationCheckBox, "planningNotification");

            // BaulosCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderBaulosLabel, contentDiv, "fixedDialogWidget planningNotificationTaskColumnBaulosLabel");
            this.baulosCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderBaulosLabel,
                title : i18n.planningNotificationOrderBaulosToolTip
            });
            domClass.add(this.baulosCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnBaulosCheckBox");
            domConstruct.place(this.baulosCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.baulosCheckBox, "baulos");

            // ProjectCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderProjectLabel, contentDiv, "fixedDialogWidget planningNotificationTaskColumnProjectLabel");
            this.projectCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderProjectLabel,
                title : i18n.planningNotificationOrderProjectToolTip
            });
            domClass.add(this.projectCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnProjectCheckBox");
            domConstruct.place(this.projectCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.projectCheckBox, "project");

            // SubjectAreaCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderSubjectAreaLabel, contentDiv, "fixedDialogWidget planningNotificationTaskColumnSubjectAreaLabel");
            this.subjectAreaCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderSubjectAreaLabel,
                title : i18n.planningNotificationOrderSubjectAreaToolTip
            });
            domClass.add(this.subjectAreaCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnSubjectAreaCheckBox");
            domConstruct.place(this.subjectAreaCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.subjectAreaCheckBox, "subjectArea");

            // AuthorizedInspectorCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderAuthorizedInspectorLabel, contentDiv,
                "fixedDialogWidget planningNotificationOrderTaskAuthorizedInspectorLabel");
            this.authorizedInspectorCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderAuthorizedInspectorLabel,
                title : i18n.planningNotificationOrderAuthorizedInspectorToolTip
            });
            domClass.add(this.authorizedInspectorCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnAuthorizedInspectorCheckBox");
            domConstruct.place(this.authorizedInspectorCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.authorizedInspectorCheckBox, "authorizedInspector");

            // ReferenceCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderReferenceLabel, contentDiv,
                "fixedDialogWidget planningNotificationTaskColumnReferenceLabel");
            this.referenceCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderReferenceLabel,
                title : i18n.planningNotificationOrderReferenceLabel
            });
            domClass.add(this.referenceCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnReferenceCheckBox");
            domConstruct.place(this.referenceCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.referenceCheckBox, "reference");

            // StatutoryDutyCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyLabel, contentDiv,
                "fixedDialogWidget planningNotificationTaskColumnStatutoryDutyLabel");
            this.statutoryDutyCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderStatutoryDutyLabel,
                title : i18n.planningNotificationOrderStatutoryDutyToolTip
            });
            domClass.add(this.statutoryDutyCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnStatutoryDutyCheckBox");
            domConstruct.place(this.statutoryDutyCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.statutoryDutyCheckBox, "statutoryDuty");

            // DocumentPageCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPageLabel, contentDiv,
                "fixedDialogWidget planningNotificationTaskColumnDocumentPageLabel");
            this.documentPageCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderDocumentPageLabel,
                title : i18n.planningNotificationOrderDocumentPageToolTip
            });
            domClass.add(this.documentPageCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnDocumentPageCheckBox");
            domConstruct.place(this.documentPageCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.documentPageCheckBox, "documentPage");

            // DocumentPositionCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPositionLabel, contentDiv,
                "fixedDialogWidget planningNotificationTaskColumnDocumentPositionLabel");
            this.documentPositionCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderDocumentPositionLabel,
                title : i18n.planningNotificationOrderDocumentPositionToolTip
            });
            domClass.add(this.documentPositionCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnDocumentPositionCheckBox");
            domConstruct.place(this.documentPositionCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.documentPositionCheckBox, "documentPosition");

            // PersonInChargeCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderPersonInChargeLabel, contentDiv,
                "fixedDialogWidget planningNotificationTaskColumnPersonInChargeLabel");
            this.personInChargeCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderPersonInChargeLabel,
                title : i18n.planningNotificationOrderPersonInChargeToolTip
            });
            domClass.add(this.personInChargeCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnPersonInChargeCheckBox");
            domConstruct.place(this.personInChargeCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.personInChargeCheckBox, "personInCharge");

            // DueDateCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationTaskDueDateLabel, contentDiv, "fixedDialogWidget planningNotificationTaskColumnDueDateLabel");
            this.dueDateCheckBox = new CheckBox({
                label : i18n.planningNotificationTaskDueDateLabel,
                title : i18n.planningNotificationTaskDueDateToolTip
            });
            domClass.add(this.dueDateCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnDueDateCheckBox");
            domConstruct.place(this.dueDateCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.dueDateCheckBox, "dueDate");

            // StateCheckBox
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderStateLabel, contentDiv, "fixedDialogWidget planningNotificationTaskColumnStateLabel");
            this.stateCheckBox = new CheckBox({
                label : i18n.planningNotificationOrderStateLabel,
                title : i18n.planningNotificationOrderStateToolTip
            });
            domClass.add(this.stateCheckBox.domNode, "fixedDialogWidget planningNotificationTaskColumnStateCheckBox");
            domConstruct.place(this.stateCheckBox.domNode, contentDiv);
            this.handleCheckBoxEvents(this.stateCheckBox, "state");

            return contentDiv;
        },

        handleCheckBoxEvents : function(checkBox, columnId) {
            WidgetHelper.handleCheckBoxEvents(checkBox, lang.hitch(this, function() {
                ColumnHelper.emitColumnsChangedPN(this.applicationContext, this, "planningNotificationTask/columns", columnId);
            }));                        
        },

        setData : function(columnSettings) {
            this.columnSettings = columnSettings;
            this.reload();
        },

        reload : function() {
            this.updateWidgetsFromData();
        },

        updateWidgetsFromData : function() {
            this.taskCheckBox.set("checked", this.columnSettings.showTask);
            this.tokenInitiatorCheckBox.set("checked", this.columnSettings.showTokenInitiator);
            this.serialNumberCheckBox.set("checked", this.columnSettings.showSerialNumber);
            this.textCheckBox.set("checked", this.columnSettings.showText);
            this.planningNotificationCheckBox.set("checked", this.columnSettings.showPlanningNotification);
            this.baulosCheckBox.set("checked", this.columnSettings.showBaulos);
            this.projectCheckBox.set("checked", this.columnSettings.showProject);
            this.subjectAreaCheckBox.set("checked", this.columnSettings.showSubjectArea);
            this.authorizedInspectorCheckBox.set("checked", this.columnSettings.showAuthorizedInspector);
            this.referenceCheckBox.set("checked", this.columnSettings.showReference);
            this.statutoryDutyCheckBox.set("checked", this.columnSettings.showStatutoryDuty);
            this.documentPageCheckBox.set("checked", this.columnSettings.showDocumentPage);
            this.documentPositionCheckBox.set("checked", this.columnSettings.showDocumentPosition);
            this.personInChargeCheckBox.set("checked", this.columnSettings.showPersonInCharge);
            this.dueDateCheckBox.set("checked", this.columnSettings.showDueDate);
            this.stateCheckBox.set("checked", this.columnSettings.showState);
        },

        updateDataFromWidgets : function() {
            this.columnSettings.showTask = this.taskCheckBox.get("checked");
            this.columnSettings.showTokenInitiator = this.tokenInitiatorCheckBox.get("checked");
            this.columnSettings.showSerialNumber = this.serialNumberCheckBox.get("checked");
            this.columnSettings.showText = this.textCheckBox.get("checked");
            this.columnSettings.showPlanningNotification = this.planningNotificationCheckBox.get("checked");
            this.columnSettings.showBaulos = this.baulosCheckBox.get("checked");
            this.columnSettings.showProject = this.projectCheckBox.get("checked");
            this.columnSettings.showSubjectArea = this.subjectAreaCheckBox.get("checked");
            this.columnSettings.showAuthorizedInspector = this.authorizedInspectorCheckBox.get("checked");
            this.columnSettings.showReference = this.referenceCheckBox.get("checked");
            this.columnSettings.showStatutoryDuty = this.statutoryDutyCheckBox.get("checked");
            this.columnSettings.showDocumentPage = this.documentPageCheckBox.get("checked");
            this.columnSettings.showDocumentPosition = this.documentPositionCheckBox.get("checked");
            this.columnSettings.showPersonInCharge = this.personInChargeCheckBox.get("checked");
            this.columnSettings.showDueDate = this.dueDateCheckBox.get("checked");
            this.columnSettings.showState = this.stateCheckBox.get("checked");
        },

        getColumnSettings : function() {
            return this.columnSettings;
        },

        updateWidgetState : function() {

        }
    });

    PlanningNotificationTaskColumnWidget.AsyncOperation = {

    };

    return PlanningNotificationTaskColumnWidget;
});
