/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/



define([ "cdes/core/CdesVoc",
        "cdes/planning/util/PlanningNotificationTitleMultiContentWidget",
        "cdes/util/SearchPageHelper",
        "clazzes/ClazzesVoc",
	"clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/form/MultiWidget",
        "clazzes/util/DOMHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/EditDialog",
        "dijit/Tooltip",
        "dijit/_WidgetBase",
        "dijit/form/ComboBox",
        "dijit/form/TextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
        "dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
        "dojo/touch",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],

function(
         CdesVoc,
         PlanningNotificationTitleMultiContentWidget,
         SearchPageHelper,
         ClazzesVoc,
	 TinyLog,
         FancyButton,
         MultiWidget,
         DOMHelper,
         WidgetHelper,
	 EditDialog,
         Tooltip,
         _WidgetBase,
         ComboBox,
         TextBox,
	 domClass,
	 domConstruct,
	 domStyle,
	 on,
         string,
	 declare,
	 lang,
         touch,
	 i18n) {

    var className = "at.cdes.web.clazzes.form.MultiTextBox";

    var log = new TinyLog(className);

    var PlanningNotificationTitleMultiSearchWidget = declare(className, _WidgetBase, {

    	buildRendering: function() {
	    this.inherited(arguments);
	    domClass.add(this.domNode, "planningTitleSearchTopDiv");

            if (this.entries == null) {
                this.entries = [];
            }

            // Alternative: ComboBox
	    this.comboBox = new ComboBox({
					label : i18n.planningTitleSearchComboBoxLabel,
					title : i18n.planningTitleSearchComboBoxTitle,
            selectOnClick : true
	    });
	    if (this.comboBoxClass != null) {
		domClass.add(this.comboBox.domNode, this.comboBoxClass);
	    }

	    this.comboBox._onDropDownMouseDown = function(/*Event*/ e){
		// summary:
		//		Callback when the user mousedown/touchstart on the arrow icon.

		if(this.disabled || this.readOnly){
		    return;
		}

		// Prevent default to stop things like text selection, but don't stop propagation, so that:
		//		1. TimeTextBox etc. can focus the <input> on mousedown
		//		2. dropDownButtonActive class applied by _CssStateMixin (on button depress)
		//		3. user defined onMouseDown handler fires
		//
		// Also, don't call preventDefault() on MSPointerDown event (on IE10) because that prevents the button
		// from getting focus, and then the focus manager doesn't know what's going on (#17262)
		if(e.type != "MSPointerDown") {// && e.type != "pointerdown"){
		    e.preventDefault();
		}

		this.own(on.once(this.ownerDocument, touch.release, lang.hitch(this, "_onDropDownMouseUp")));

		this.toggleDropDown();
	    },

	    domConstruct.place(this.comboBox.domNode, this.domNode);
            WidgetHelper.handleComboBoxEvents(this.comboBox, lang.hitch(this, this.updateTitlesFromComboBox));

            // ... or a read only text box
            this.chooseInfoTextBox = new TextBox({
                   label : i18n.planningTitleSearchInfoTextBoxLabel,
                disabled : true
            });
            domClass.add(this.chooseInfoTextBox.domNode, "fixedDialogWidget " + this.comboBoxClass);
            domConstruct.place(this.chooseInfoTextBox.domNode, this.domNode);

            // ToolTip
    	    this.chooseInfoToolTip = new Tooltip({
    		connectId : [this.chooseInfoTextBox.domNode],
    		label     : ""
    	    });

    	    // DOJOSKETCH-119: It seems that the built-in code for hiding the ToolTip provided by
    	    //                 Dojo (using connectId specified above) does not work reliable on
    	    //                 Firefox.
    	    this.own(
    	    	on(this.chooseInfoToolTip.domNode, "mouseleave", lang.hitch(this, function(event) {
   	    	    this.chooseInfoToolTip._onUnHover();
    	    	}))
    		     );

            // New / edit button
	    this.newButton = this.constructNewButton();
	    domClass.add(this.newButton.domNode, "fixedDialogWidget planningTitleAddButton");
	    domConstruct.place(this.newButton.domNode, this.domNode);

            this.updateWidgetState();
	},

	constructNewButton : function() {
       	    var button = new FancyButton({
		    title : i18n.planningTitleAddLabel,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton"
       	    });

	    on(button, "click", lang.hitch(this, function() {
                var contentWidget = new PlanningNotificationTitleMultiContentWidget({
                    applicationContext : this.applicationContext
                });

		var editDialog = new EditDialog({
		    contentWidget : contentWidget,
		    defaultWidth  : 800,  // Should be in sync with corresponding rules in CSS
		    defaultHeight : 350,
			    title : i18n.planningTitleSearchConfigureTitlesCaption,
    		          buttons : [ { type : ClazzesVoc.Button.OK, label : i18n.planningTitleAlterSearchLabel, title : i18n.planningTitleAlterSearchToolTip },
    				     { type : ClazzesVoc.Button.ABORT, title : i18n.abortButtonCaption } ]
		});
                on(contentWidget, "titlesChosen", lang.hitch(this, function(entries) {
                    this.entries = entries;
                    this.updateWidgetsFromData();
                    this.updateWidgetState();
                }));

		editDialog.setData({
                      store : this.store,
                    entries : this.entries
		});
		editDialog.show();
	    }));

	    domConstruct.place(button.domNode, this.domNode);

	    return button;
	},

        // entry: { id : Long, title : String } where exactly one of both is set
    	_setValueAttr : function(entries) {
            // Compatibility to PlanningNotificationHelper.handleProjectSelectChange, which was
            // originally implemented for a ComboBox widget receiving a string, not an array as
            // our widget here.  The empty string means, reset it.
            /*
            if (typeof titles == "string") {
                if (titles.length == 0) {
                    titles = [];
                } else {
                    log.warn("Widget called with string value, but an array value (or the empty string) is required.");
                    titles = [];
                }
            }
            */

            this.entries = entries != null ? entries : [];

            this.updateWidgetsFromData();
            this.updateWidgetState();
	},

	_getValueAttr : function() {
            return this.entries;
	},

        _setStoreAttr : function(store) {
            this.store = store;
            if (this.entries == null || this.entries.length <= 1) {
                this.comboBox.set("store", store);
            }
        },

        updateWidgetsFromData : function() {
            if (this.entries == null || this.entries.length == 0) {
                SearchPageHelper.setComboBoxValue(this.comboBox, CdesVoc.MagicSelectOption.ALL, !!this.initialized);
            } else if (this.entries.length == 1) {
                var entry = this.entries[0];
                SearchPageHelper.setSearchModelValueToAllableComboBox(entry, this.comboBox, "id", "title");
            } else {
                var chooseInfo = string.substitute(i18n.planningTitleSearchChooseInfo, {
                    count : this.entries.length
                });
                this.chooseInfoTextBox.set("value", chooseInfo);

                var toolTipString = "<ul>";
                for (var n = 0; n < this.entries.length; n++) {
                    var entry = this.entries[n];

                    var currTitle;
                    if (entry.id != null && entry.id != CdesVoc.MagicSelectOption.ALL) {
                        var item = this.store.get(entry.id);
                        currTitle = item != null ? item.name : i18n.unknown;
                    } else if (entry.title != null) {
                        currTitle = entry.title;
                    } else {
                        currTitle = i18n.allOption;
                    }
                    toolTipString += "<li>" + currTitle + "</li>";
                }

                toolTipString += "</ul>";
                this.chooseInfoToolTip.set("label", toolTipString);
            }
        },

        updateTitlesFromComboBox : function() {
            var entry = new Object();
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.comboBox, entry, "id", "title");
            entry.title = this.comboBox.item != null ? this.comboBox.item.name : null;

            var id = entry.id;
            var title = entry.title;
            var idIsNull = (id == null || id == CdesVoc.MagicSelectOption.ALL);
            var titleIsNull = (title == null || title.trim().length == 0);

            if (idIsNull && titleIsNull) {
                this.entries = [];
            } else {
                this.entries = [ entry ];
            }
        },

        updateWidgetState : function() {
            domClass.replace(this.comboBox.domNode, "invisible", "visible");
            domClass.replace(this.chooseInfoTextBox.domNode, "invisible", "visible");

            if (this.entries == null || this.entries.length <= 1) {
                domClass.replace(this.comboBox.domNode, "visible", "invisible");
                this.newButton.set("iconClass", "fancyButtonIcon17x18 fancyButton17x18 addButton");
            } else {
                domClass.replace(this.chooseInfoTextBox.domNode, "visible", "invisible");
                this.newButton.set("iconClass", "fancyButtonIcon17x18 fancyButton17x18 editButton");
            }
        },

	isValid : function(isValidFct) {
	    var allValid = true;
            /*	    for (var n = 0; n < this.lineInfos.length; n++) {
	    allValid &= isValidFct(this.lineInfos[n].widget);
	}*/

	    return allValid;
	}
    });

    return PlanningNotificationTitleMultiSearchWidget;
});
