define([ 
        "cdes/widget/util/DnDCellWidget",
		"clazzes/form/FancySelect",
        "clazzes/TinyLog",
        "clazzes/util/WidgetHelper",
		"clazzes/util/DOMHelper",
        "dijit/_WidgetBase",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-attr",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang"
],
function(
         DnDCellWidget,
		 FancySelect,
         TinyLog,
         WidgetHelper,
		 DOMHelper,
         _WidgetBase,
         domClass,
         domConstruct,
         domAttr,
         on,
         declare,
         lang
         ) {
    
    var className = "at.cdes.widget.util.SelectDnDCellWidget";

    var log = new TinyLog(className);
    
    var SelectDnDCellWidget = declare(className, [_WidgetBase, DnDCellWidget ], {
        
        buildRendering : function() {
            this.inherited(arguments);
            
            this.domNode = domConstruct.create("table", null, null);
            var tr = domConstruct.create("tr", null, this.domNode);
            var td1 = domConstruct.create("td", null, tr);
			
			//textspan for groupLabel
			if (this.showPreLabel){
				this.preLabel = domConstruct.create("div", null, null);
				domConstruct.place(this.preLabel, td1);
			}
            domClass.add(this.preLabel, "selectDndCellSelectBoxPreLabel");
            //domAttr.set(this.showPreLabel, "style", "width: 20px;");
			
            var td2 = domConstruct.create("td", null, tr);
            this.select = new FancySelect({
                label : this.label,
                title : "",
				options : []
            });
            domClass.add(this.select.domNode, "selectDndCellSelectBox");
            domConstruct.place(this.select.domNode, td2);
            
            WidgetHelper.handleSelectEvents(this.select, lang.hitch(this, function(e) {
				//this.cloneDocumentNumberInfo();
				var valueId = this.select.get("value");
				var options = this.select.get("options");
				
				var focusedChild = this.select.get("focusedChild");
				var focusedChildOption = focusedChild?focusedChild.option:null;
				if (!focusedChildOption && valueId){
					for (var n = 0; options && n < options.length; n++) {
						var option = options[n];
						if (option.value == valueId){
							focusedChildOption = option;
							break;							
						}
					}
				}
				var groupId = focusedChildOption?focusedChildOption.groupId:null;
				
				//check, if a group was selected and set to the first children value
				if (!groupId){
					//window.alert("Es kann keine Gruppe gewählt werden!");    			
					for (var n = 0; options && n < options.length; n++) {
						var option = options[n];
						if (option.groupId == valueId){
							this.select.set("value", option.value);
							break;							
						}
					}
				} else if (this.showPreLabel){
					//set preLabel
					DOMHelper.setInnerText(this.preLabel, focusedChildOption.groupLabel ? focusedChildOption.groupLabel+" " : "");
				}			
                on.emit(this, "change", e);
            }));

            if (this.dndStartTopic) {
                var iconTd = domConstruct.create("td", null, tr);
                this.constructDnDButtonCell(iconTd, "pullUpDownIcon");                          
            }
        },

		cloneDocumentNumberInfo : function() {
		    	var newObjectPlannerId = new Object();
		    	newObjectPlannerId = this.select.get("value");
				this.select.set("value", newObjectPlannerId);
		},
        
        _setValueAttr : function(value, priorityChange) {
            this.inherited(arguments);
        },

        constructToolTip : function() {
            
        },        
        
        setEditorValue : function(value, priorityChange) {
            this.select.set("value", value);
        },

		setEditorOptions : function(options, priorityChange) {
		    this.select.set("options", options);
		},
        
        getEditorValue : function() {
			return this.select.get("value");
        },

    });
    
    return SelectDnDCellWidget;
});
