/*  $Id: $
*  Copyright (C) ITEG IT-Engineers GmbH 2013 */
define([
        "cdes/core/Feature",
        "clazzes/FancyIFrame",
        "clazzes/LoginGuardRpcService",
        "clazzes/LoginGuardXhr",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/dateTime/FancyDate",
        "clazzes/dateTime/holiday/AtHolidayCalculator",
        "clazzes/plugin/FeatureDefinition",
        "clazzes/plugin/PluginRegistry",
        "clazzes/util/ErrorHelper",
        "clazzes/util/StringHelper",
        "dojo/Deferred",
        "dojo/dom-construct",
        "dojo/hash",
        "dojo/io-query",
        "dojo/json",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojox/rpc/JsonRPC",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
        "dojo/text!/cdes-dojo-impl/jobStatus?smd",
        "dojo/text!/cdes/svc/certificateServiceWeb?smd",
        "dojo/text!/cdes/svc/challengeLoginServiceWeb?smd",
        "dojo/text!/cdes/svc/contextServiceWeb?smd",
        "dojo/text!/cdes/svc/documentServiceWeb?smd",
        "dojo/text!/cdes/svc/emailServiceWeb?smd",
        "dojo/text!/cdes/svc/mspServiceWeb?smd",
        "dojo/text!/cdes/svc/networkServiceWeb?smd",               
        "dojo/text!/cdes/svc/objectServiceWeb?smd",
        "dojo/text!/cdes/svc/organisationServiceWeb?smd",
        "dojo/text!/cdes/svc/personServiceWeb?smd",
        "dojo/text!/cdes/svc/planDeliverServiceWeb?smd",
        "dojo/text!/cdes/svc/planningNotificationServiceWeb?smd",
        "dojo/text!/cdes/svc/plotServiceWeb?smd",
        "dojo/text!/cdes/svc/pluginServiceWeb?smd",
        "dojo/text!/cdes/svc/projectServiceWeb?smd",
        "dojo/text!/cdes/svc/resetPasswordService?smd",
        "dojo/text!/cdes/svc/tabSessionCreatorServiceWeb?smd",
        "dojo/text!/cdes/svc/tabSessionContextServiceWeb?smd",
        "dojo/text!/cdes/svc/taskServiceWeb?smd",
        "dojo/text!/cdes/svc/utilServiceWeb?smd"   
],
function(
         Feature,
         FancyIFrame,
         LoginGuardRpcService,
         LoginGuardXhr,
         TinyLog,
         DateHelper,
         FancyDate,
         AtHolidayCalculator,
         FeatureDefinition,
         PluginRegistry,
         ErrorHelper,
         StringHelper,
         Deferred,
         domConstruct,
         hash,
         ioQuery,
         json,
         declare,
         lang,
         JsonRPC,
         i18n,
         jobStatusServiceSmd,
         certificateServiceSmd,
         challengeLoginServiceSmd,
         contextServiceSmd,
         documentServiceSmd,
         emailServiceSmd,
         mspServiceSmd,
         networkServiceSmd,
         objectServiceSmd,
         organisationServiceSmd,
         personServiceSmd,
         planDeliverServiceSmd,
         planningNotificationServiceSmd,
         plotServiceSmd,
         pluginServiceSmd,
         projectServiceSmd,
         resetPasswordServiceSmd,
         tabSessionCreatorServiceSmd,
         tabSessionContextServiceSmd,
         taskServiceSmd,
         utilServiceSmd
         ) {

    var className = "at.cdes.core.ApplicationContext";

    var log = new TinyLog(className);
    var storageLog = new TinyLog(className + "_LocalStorage");

    var ApplicationContext = declare(className, null, {

        constructor : function(pageChooser) {
            this.pageChooser = pageChooser;
            this.setupServices();

            /* Probably no good idea
            // Number of calls to storeInLocalStorage, after which local storage will be garbage collected
            this.localStorageGcInterval = 1;

            // Number of calls to storeInLocalStorage since the last call to garbageCollectLocalStorage.  null to garbage collect in the next run.
            this.localStorageCallCounter = null;

            // After this time, measured in seconds, a key/value pair may be garbage collected from local storage
            this.localStorageStoreTime = 10;
                                       */

            this.downloadFrame = new FancyIFrame({hidden : true});
            domConstruct.place(this.downloadFrame.domNode, document.body);

            this.networkIdToIdToMasterData = new Object();
            this.networkIdToMasterDataDeferred = new Object();

            this.holidayCalculator = new AtHolidayCalculator();
            this.clearPageHistory();
        },

        setupServices : function() {
            this.serviceNameToService = new Object();

            var certificateService = new LoginGuardRpcService(json.parse(certificateServiceSmd));
            this.serviceNameToService["certificateService"] = certificateService;

            var challengeLoginService = new LoginGuardRpcService(json.parse(challengeLoginServiceSmd));
            this.serviceNameToService["challengeLoginService"] = challengeLoginService;

            var resetPasswordService = new LoginGuardRpcService(json.parse(resetPasswordServiceSmd));
            this.serviceNameToService["resetPasswordService"] = resetPasswordService;

            var contextService = new LoginGuardRpcService(json.parse(contextServiceSmd));
            this.serviceNameToService["contextService"] = contextService;

            var documentService = new LoginGuardRpcService(json.parse(documentServiceSmd));
            this.serviceNameToService["documentService"] = documentService;

            var emailService = new LoginGuardRpcService(json.parse(emailServiceSmd));
            this.serviceNameToService["emailService"] = emailService;

            var jobStatusService = new LoginGuardRpcService(json.parse(jobStatusServiceSmd));
            this.serviceNameToService["jobStatusService"] = jobStatusService;

            var mspService = new LoginGuardRpcService(json.parse(mspServiceSmd));
            this.serviceNameToService["mspService"] = mspService;

            var networkService = new LoginGuardRpcService(json.parse(networkServiceSmd));
            this.serviceNameToService["networkService"] = networkService;

            var objectService = new LoginGuardRpcService(json.parse(objectServiceSmd));
            this.serviceNameToService["objectService"] = objectService;

            var organisationService = new LoginGuardRpcService(json.parse(organisationServiceSmd));
            this.serviceNameToService["organisationService"] = organisationService;

            var personService = new LoginGuardRpcService(json.parse(personServiceSmd));
            this.serviceNameToService["personService"] = personService;

            var planDeliverService = new LoginGuardRpcService(json.parse(planDeliverServiceSmd));
            this.serviceNameToService["planDeliverService"] = planDeliverService;

            var planningNotificationService = new LoginGuardRpcService(json.parse(planningNotificationServiceSmd));
            this.serviceNameToService["planningNotificationService"] = planningNotificationService;

            var pluginService = new LoginGuardRpcService(json.parse(pluginServiceSmd));
            this.serviceNameToService["pluginService"] = pluginService;

            var plotService = new LoginGuardRpcService(json.parse(plotServiceSmd));
            this.serviceNameToService["plotService"] = plotService;

            var projectService = new LoginGuardRpcService(json.parse(projectServiceSmd));
            this.serviceNameToService["projectService"] = projectService;

            var tabSessionContextService = new LoginGuardRpcService(json.parse(tabSessionContextServiceSmd));
            this.serviceNameToService["tabSessionContextService"] = tabSessionContextService;

            var tabSessionCreatorService = new LoginGuardRpcService(json.parse(tabSessionCreatorServiceSmd));
            this.serviceNameToService["tabSessionCreatorService"] = tabSessionCreatorService;

            var taskService = new LoginGuardRpcService(json.parse(taskServiceSmd));
            this.serviceNameToService["taskService"] = taskService;

            var utilService = new LoginGuardRpcService(json.parse(utilServiceSmd));
            this.serviceNameToService["utilService"] = utilService;

            var features = [new FeatureDefinition({name : Feature.DATA_IMPORTER, defaultDataGetterName : "getDataImporters"}),
            ];

            this.pluginRegistry = new PluginRegistry(pluginService, features);
        },

        getPageChooser : function() {
            return this.pageChooser;
        },

        // ============================== Services =====================================
        // =============================================================================

        getService : function(name) {
            return this.serviceNameToService[name];
        },

        getEmailService : function() {
            return this.serviceNameToService["emailService"];
        },

        getUtilService : function() {
            return this.serviceNameToService["utilService"];
        },

        // ============================== Plugins ======================================
        // =============================================================================

        getPluginRegistry : function() {
            return this.pluginRegistry;
        },

        loadPlugins : function(feature) {
            return this.pluginRegistry.loadPlugins(feature);
        },

        isPluginDataLoaded : function(feature) {
            return this.pluginRegistry.isPluginDataLoaded(feature);
        },

        getAllPluginDataForFeature : function(feature) {
            return this.pluginRegistry.getAllPluginDataForFeature(feature);
        },

        getAllKeysForFeature : function(feature) {
            return this.pluginRegistry.getAllKeysForFeature(feature);
        },

        getPluginData : function(feature, shape) {
            return this.pluginRegistry.getPluginData(feature, shape);
        },

        // ============================== Context ======================================
        // =============================================================================

        setPageContext : function(pageContext) {
            this.pageContext = pageContext;

            var projectHolidays = this.pageContext.projectHolidays;
            for (var n = 0; n < projectHolidays.length; n++) {
                var projectHoliday = projectHolidays[n];
                var startDate = new FancyDate({
                    utcSeconds : projectHoliday.startDate,
                      timeZone : "Europe/Berlin"
                });
    			var startDateInUtc = new FancyDate({
 				          year : startDate.getYear(),
 				         month : startDate.getMonth(),
 				           day : startDate.getDay(),
 			          timeZone : "UTC"
    			});
                projectHoliday.from = startDateInUtc.getUtcSeconds();

                var endDate = new FancyDate({
                    utcSeconds : projectHoliday.endDate,
                      timeZone : "Europe/Berlin"
                });
    			var endDateInUtc = new FancyDate({
			          year : endDate.getYear(),
			         month : endDate.getMonth(),
			           day : endDate.getDay(),
		          timeZone : "UTC"
    			});
                projectHoliday.to = endDateInUtc.getUtcSeconds();
            }
            this.holidayCalculator.setVacations(projectHolidays);

            if (log.isDebugEnabled())
            	log.info("Set page context: ", this.pageContext);
        },

        getPageContext : function() {
            return this.pageContext;
        },

        getPageContextNetwork : function() {
            return this.pageContext.network;
        },

        getPageContextNetworkId : function() {
            return this.pageContext.network ? this.pageContext.network.id : null;
        },

        getPageContextProject : function() {
            return this.pageContext.project;
        },

        getPageContextProjectId : function() {
            return this.pageContext.project ? this.pageContext.project.id : null;
        },

        getPageContextSubProject : function() {
            return this.pageContext.subProject;
        },

        getPageContextSubProjectId : function() {
            return this.pageContext.subProject ? this.pageContext.subProject.id : null;
        },

        getPageContextSubProjectType : function() {
            return this.pageContext.subProjectType;
        },

        getPageContextPnNetwork : function() {
            return this.pageContext.planningNotificationNetwork;
        },

        getPageContextPnNetworkId : function() {
            return this.pageContext.planningNotificationNetwork ? this.pageContext.planningNotificationNetwork.id : null;
        },

        getPageContextPnProject : function() {
            return this.pageContext.planningNotificationProject;
        },

        getPageContextPnProjectId : function() {
            return this.pageContext.planningNotificationProject ? this.pageContext.planningNotificationProject.id : null;
        },

        getPageContextPerson : function() {
            return this.pageContext.person;
        },

        getPageContextPersonId : function() {
            return this.pageContext.person != null ? this.pageContext.person.id : null;
        },

        getPageContextOrganisation : function() {
            return this.pageContext.organisation;
        },

        getPageContextOrganisationPersonId : function() {
            return this.pageContext.organisationPerson ? this.pageContext.organisationPerson.id : null;
        },

        getPageContextPersonVariablesUserLocale : function() {
            return this.pageContext.personVariablesUserLocale;
        },

        getPageContextProjectHolidays : function() {
            return this.pageContext.projectHolidays;
        },

        getGridCellLimit : function() {
            return this.pageContext.gridCellLimit;
        },

        isActionAllowedForProject : function(actionName, recognizedContexts) {
            if (recognizedContexts == null) {
                return (actionName in this.pageContext.actionsAllowedForProject);
            } else if (actionName in this.pageContext.actionsAllowedForProject) {
                var actionInfo = this.pageContext.actionsAllowedForProject[actionName];
                return    (recognizedContexts.globalContext && actionInfo.globalContext)
                || (recognizedContexts.networkContext && actionInfo.networkContext)
                || (recognizedContexts.projectContext && actionInfo.projectContext);
            } else {
                return false;
            }
        },

        getHolidayCalculator : function() {
            return this.holidayCalculator;
        },

        // ====================== Document Number Specification ========================
        // =============================================================================

        loadMasterData : function(networkId) {
            // summary:
            //    Loads the documentNumberParts for the given group id, if not yet loaded, or
            //    returns a Deferred returning the version cached in the applicationContext
            //    by a previous call to this function.
            // returns: dojo/Deferred
            //    Deferred returning the documentNumberParts corresponding to the given groupId

            if (networkId in this.networkIdToIdToMasterData) {
                var deferred = new Deferred();
                deferred.resolve(this.networkIdToIdToMasterData[networkId]);
                return deferred;
            } else if (this.networkIdToMasterDataDeferred[networkId] != null) {
                return this.networkIdToMasterDataDeferred[networkId];
            } else {
                var contextService = this.getService("contextService");
                this.networkIdToMasterDataDeferred[networkId] = contextService.getMasterData(networkId);
                this.networkIdToMasterDataDeferred[networkId].then(lang.hitch(this, function(idToMasterData) {
                    // Add a transient documentType._children attribute.
                    for (var id in idToMasterData) {
                        var masterData = idToMasterData[id];
                        var idToDocumentType = masterData.idToDocumentType;
                        for (var documentTypeId in idToDocumentType) {
                            var documentType = idToDocumentType[documentTypeId];
                            if (documentType.documentTypeGroupId != null) {
                                var parentId = documentType.documentTypeGroupId;
                                if (idToDocumentType[parentId]._children == null) {
                                    idToDocumentType[parentId]._children = [];
                                }
                                idToDocumentType[parentId]._children.push(documentType);
                            }
                        }
                    }

                    this.networkIdToIdToMasterData[networkId] = idToMasterData;

                    delete this.networkIdToMasterDataDeferred[networkId];
                }),
                    lang.hitch(this, function(err) {
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : null,
                                    opName : "getMasterData",
                                   message : i18n.applicationContextLoadMasterDataFailed
                        });


                        log.error("Error calling getMasterData: ", err);
                        delete this.networkIdToMasterDataDeferred[networkId];
                    })
                    ).otherwise(lang.hitch(this, function(err) {
                        log.error("Error while processing the results of a call to getMasterData: ", err);
                    }));
                return this.networkIdToMasterDataDeferred[networkId];
            }
        },

        getDocumentNumberGroup : function(documentNumberPartGroupId, networkId) {
            if (networkId == null) {
                networkId = this.getPageContextNetworkId();
            }
            var idToMasterData = this.networkIdToIdToMasterData[networkId];
            for (var id in idToMasterData) {
                var masterData = idToMasterData[id];
                if (documentNumberPartGroupId in masterData.groupIdToDocumentNumberParts) {
                    return masterData.groupIdToDocumentNumberGroup[documentNumberPartGroupId];
                }
            }
            return null;
        },

        getDocumentNumberParts : function(documentNumberPartGroupId, networkId) {
            if (networkId == null) {
                networkId = this.getPageContextNetworkId();
            }
            var idToMasterData = this.networkIdToIdToMasterData[networkId];
            for (var id in idToMasterData) {
                var masterData = idToMasterData[id];
                if (documentNumberPartGroupId in masterData.groupIdToDocumentNumberParts) {
                    return masterData.groupIdToDocumentNumberParts[documentNumberPartGroupId];
                }
            }
            return null;
        },

        getMasterData : function(masterDataId, networkId) {
            if (networkId == null) {
                networkId = this.getPageContextNetworkId();
            }

            if (networkId in this.networkIdToIdToMasterData && masterDataId in this.networkIdToIdToMasterData[networkId]) {
                return this.networkIdToIdToMasterData[networkId][masterDataId];
            } else {
                return null;
            }
        },

        getNumberPartsForProject : function(project) {
            var documentNumberPartGroupId = project.documentNumberPartGroupId;
            var documentNumberPartGroup = this.getDocumentNumberGroup(documentNumberPartGroupId, project.networkId);
            var masterDataSetId = documentNumberPartGroup.masterDataSetId;
            var masterDataSet = this.getMasterData(masterDataSetId, project.networkId);

            if (documentNumberPartGroupId in masterDataSet.groupIdToDocumentNumberParts) {
                return masterDataSet.groupIdToDocumentNumberParts[documentNumberPartGroupId];
            } else {
                return null;
            }
        },

        getDocumentTypesForProject : function(project) {
            var documentNumberPartGroupId = project.documentNumberPartGroupId;
            var documentNumberPartGroup = this.getDocumentNumberGroup(documentNumberPartGroupId, project.networkId);
            var masterDataSetId = documentNumberPartGroup.masterDataSetId;
            var masterDataSet = this.getMasterData(masterDataSetId, project.networkId);
            return masterDataSet.idToDocumentType;
        },

		getObjectTypesForProject : function(project) {
		    var documentNumberPartGroupId = project.documentNumberPartGroupId;
		    var documentNumberPartGroup = this.getDocumentNumberGroup(documentNumberPartGroupId, project.networkId);
		    var masterDataSetId = documentNumberPartGroup.masterDataSetId;
		    var masterDataSet = this.getMasterData(masterDataSetId, project.networkId);
		    return masterDataSet.idToObjectType;
		},

        clearPageHistory : function() {
            this.pageHistory = [];
        },

        addPageHistoryEntry : function(pageName, params) {
            this.pageHistory.push({ page : pageName, params : params });
        },

        getLastPageHistoryPage : function() {
        	var lastPageInfo;
            if (this.pageHistory.length > 0) {
                lastPageInfo = this.pageHistory[this.pageHistory.length - 1];
            }
            return lastPageInfo;
        },

        popLastPageHistoryPage : function(additionalParams) {
            if (this.pageHistory.length > 0) {
                var lastPageInfo = this.pageHistory[this.pageHistory.length - 1];
                this.pageHistory.splice(this.pageHistory.length - 1, 1);
                if (additionalParams != null)
                	lang.mixin(lastPageInfo.params, additionalParams);
                this.setPage(lastPageInfo.page, null, lastPageInfo.params);
            }
        },

        setPage : function(hashName, hashParams, extraParams, backPageName, backPageParams) {
            if (backPageName != null) {
                this.addPageHistoryEntry(backPageName, backPageParams);
            }

            var paramsForHashString = {
                page : hashName
            };
            lang.mixin(paramsForHashString, hashParams);

            var hashString = ioQuery.objectToQuery(paramsForHashString);

            lang.mixin(paramsForHashString, extraParams);

            this.pageChooser.constructPageFromHash(paramsForHashString);

            // The pageChooser listens for dojo/hashchange triggered by user changes to the url.  But in this case, we already called
            // constructPageFromHash ourselves (maybe with extra parameters not passed via the url).  Thus we must avoid a second call
            // to constructPageFromHash.
            //
            // Unfortunately, the dojo/hashchange event arrives in an asynchronous manner.  Our strategy is, lock the pageChooser here,
            // and the very next time a dojo/hashchange event is reveived, unlock it instead of executing constructPageFromHash.
            this.pageChooser.setLocked();
            hash(hashString);
        },

        // ============================= Countries =====================================
        // =============================================================================

        setCountries : function(countries) {
            this.countries = countries;
        },

        getCountries : function() {
            return this.countries;
        },

        // ================================ Time =======================================
        // =============================================================================

        getTimeZone : function() {
            return "Europe/Vienna";
        },

        // ============================== FancyIFrame ==================================
        // =============================================================================

        getFancyIFrame : function() {
            return this.downloadFrame;
        },

        // =========================== Local Storage ===================================
        // =============================================================================

        getContextKeyString : function(contextKeys) {
            var contextKeyString = "/cdes/";
            for (var n = 0; n < contextKeys.length; n++) {
                contextKeyString += contextKeys[n] != null ? contextKeys[n].toString() : "";
                contextKeyString += (n < contextKeys.length - 1 ? "/" : "");
            }
            if (contextKeyString == "") {
                // Global
                contextKeyString = "G";
            }
            return contextKeyString;
        },
        /*
        garbageCollectLocalStorage : function() {
        var currentTime = DateHelper.getCurrentTimeSeconds();
        var keysToBeDeleted = new Object();
        var givenKeys = [];
        for (var n = 0; n < window.localStorage.length; n++) {
        var key = window.localStorage.key(n);
        if (key.indexOf("T/") == 0) {
        var subKey = key.substring(2);
        var time = parseFloat(window.localStorage[key]);
        if (typeof time == "number" && currentTime - time > this.localStorageStoreTime) {
        if (storageLog.isDebugEnabled()) {
        storageLog.debug(".... For subKey " + subKey + ", timestamp " + time + " was recorded.  Now = " + currentTime + "; " + this.localStorageStoreTime + " ==> Schedule for delete.");
    }
        keysToBeDeleted[subKey] = true;
    } else {
        if (storageLog.isDebugEnabled()) {
        storageLog.debug(".... For subKey " + subKey + ", timestamp " + time + " was recorded.  Now = " + currentTime + "; " + this.localStorageStoreTime + " ==> Keep it.");
    }
    }
    } else {
        givenKeys.push(key);
    }
    }
        for (var n = 0; n < givenKeys.length; n++) {
        var tokens = givenKeys[n].split("/");
        var currKey = "";
        for (var z = 0; z < tokens.length; z++) {
        currKey += (z > 0 ? "/" : "") + tokens[z];
        if (storageLog.isDebugEnabled()) {
        storageLog.debug("currKey = " + currKey);
    }

        if (currKey in keysToBeDeleted) {
        if (storageLog.isDebugEnabled()) {
        storageLog.debug(".... Key " + givenKeys[n] + " matches currKey " + currKey + " scheduled for delete => Will remove it.");
    }

        window.localStorage.removeItem(givenKeys[n]);
        window.localStorage.removeItem("T/" + currKey);
    }
        if (storageLog.isDebugEnabled()) {
        storageLog.debug(".... Key " + givenKeys[n] + " does not match any scheduled to delete; will do nothing.");
    }
    }
    }
    },
        */
        storeInLocalStorage : function(contextKeys, key, obj) {
            var contextKeyString = this.getContextKeyString(contextKeys);
            if (window.localStorage != null) {
                var js = json.stringify(obj);
                try {
                    if (!StringHelper.endsWith(contextKeyString, "/")) {
                        contextKeyString += "/";
                    }
                    if (key != null && key.length > 0 && key[0] == "/") {
                        key = key.substring(1);
                    }
                    var fullKey = contextKeyString + key;
                    window.localStorage[fullKey] = js;
                    return true;
                } catch (e) {
                    if (e == QUOTA_EXCEEDED_ERR) {
                        log.warn("Could not store object under key " + key + " in local storage: Quota exceeded.");
                    } else {
                        throw e;
                    }

                    return false;
                }
            } else {
                return false;
            }

            /*
            var contextKeyString = this.getContextKeyString(contextKeys);

            if (storageLog.isDebugEnabled) {
            storageLog.debug("Calling storeInLocalStorage: contextKey = " + contextKeyString + ", key = " + key + ", object = ", obj);
        }

            if (window.localStorage != null) {
            this.printLocalStorageToDebug();

            this.localStorageCallCounter++;
            if (this.localStorageCallCounter == null || this.localStorageCallCounter >= this.localStorageGcInterval) {
            if (storageLog.isDebugEnabled()) {
            storageLog.debug("Will garbage collect local storage, counter = " + this.localStorageCallCounter + ", interval = " + this.localStorageGcInterval);
        }
            this.garbageCollectLocalStorage();
            this.localStorageCallCounter = 0;
        }


            var js = json.stringify(obj);

            try {
            var timeKey = "T/" + contextKeyString;
            window.localStorage[timeKey] = DateHelper.getCurrentTimeSeconds();
            if (storageLog.isDebugEnabled()) {
            storageLog.debug("Stored " + timeKey + " = " + window.localStorage[timeKey]);
        }

            var fullKey = contextKeyString + key;
            window.localStorage[fullKey] = js;

            if (storageLog.isDebugEnabled()) {
            storageLog.debug("Stored " + fullKey + " = " + window.localStorage[fullKey]);
        }

            this.printLocalStorageToDebug();
            return true;
        } catch (e) {
            if (e == QUOTA_EXCEEDED_ERR) {
            log.warn("Could not store object under key " + key + " in local storage: Quota exceeded.");
        } else {
            throw e;
        }

            return false;
        }
        } else {
            return false;
        }*/
        },

        printLocalStorageToDebug : function() {
            if (storageLog.isDebugEnabled()) {
                storageLog.debug("========================");
                storageLog.debug("Contents of localStorage");
                storageLog.debug("========================");
                storageLog.debug("========================");
                for (var n = 0; n < window.localStorage.length; n++) {
                    var key = window.localStorage.key(n);
                    storageLog.debug("Key " + key + " = ", window.localStorage[key]);
                }
                storageLog.debug("(end of contents of localStorage)");
            }
        },

        getFromLocalStorage : function(contextKeys, key) {
            if (window.localStorage != null) {
                this.printLocalStorageToDebug();

                var contextKeyString = this.getContextKeyString(contextKeys);

                if (!StringHelper.endsWith(contextKeyString, "/")) {
                    contextKeyString += "/";
                }
                if (key != null && key.length > 0 && key[0] == "/") {
                    key = key.substring(1);
                }

                var s = window.localStorage[contextKeyString + key];
                if (s == null) {
                    return null;
                } else {
                    return json.parse(s);
                }
            } else {
                return null;
            }
        }

    });

    return ApplicationContext;
});
