/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationOrderChoose
////i18n-prefix = planningNotificationOrderChoose


define([ "cdes/planning/order/PlanningNotificationOrderListWidget",
	"clazzes/TinyLog",
	"clazzes/util/DOMHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ChooseDialog",
	"dijit/form/TextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",	 
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"
	],
	function(PlanningNotificationOrderListWidget,
			TinyLog,
			DOMHelper,
			WidgetHelper,
			ChooseDialog,                
			TextBox,
			domClass,
			domConstruct,
			domStyle,
			on,
			declare,
			lang,		
			i18n) {

	var className = "at.cdes.web.planning.order.PlanningNotificationOrderChooseDialog";

	var log = new TinyLog(className);

	var PlanningNotificationOrderChooseDialog = declare(className, ChooseDialog, {

		constructChooseWidget : function() {
			// summary:
			//     Constructs the widget in which the user chooses some piece of data.
			// description:
			//     That widget must be saved in the variable this.content, and will 
			//     subsequently be placed in the dialog by superclass code.
			//     If some value is chosen by the user in that widget (e.g. a choosable 
			//     tree node is clicked), the subclass must call setChosenValue.  
			//     Optionally, after doing so, the subclass may emit the valueChosen 
			//     event, and close the dialog (e.g. on a double click into the tree).

			this.content = domConstruct.create("div", null, null);
			domClass.add(this.content, "refNodeOfPositionAbsolute");

			// Serial number
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderSerialNumberLabel, this.content,
			"propertyLabel planningNotificationOrderChooseSerialNumberLabel");

			this.serialNumberTextBox = new TextBox({
				label : i18n.planningNotificationOrderSerialNumberLabel
			});
			domClass.add(this.serialNumberTextBox.domNode, "fixedDialogWidget planningNotificationOrderChooseSerialNumberTextBox");
			domConstruct.place(this.serialNumberTextBox.domNode, this.content);
			WidgetHelper.handleTextBoxEvents(this.serialNumberTextBox, lang.hitch(this, function() {
				this.processSerialNumberChange(this.serialNumberTextBox.get("value"));
			}));		    

			// Free text
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderChooseQuickSearchLabel, this.content,
			"propertyLabel planningNotificationOrderChooseQuickSearchLabel");

			this.quickSearchTextBox = new TextBox({
				label : i18n.planningNotificationOrderChooseQuickSearchLabel,
				title : i18n.planningNotificationOrderChooseQuickSearchToolTip
			});
			domClass.add(this.quickSearchTextBox.domNode, "fixedDialogWidget planningNotificationOrderChooseQuickSearchTextBox");
			domConstruct.place(this.quickSearchTextBox.domNode, this.content);
			WidgetHelper.handleTextBoxEvents(this.quickSearchTextBox, lang.hitch(this, function() {
				this.processQuickSearchChange(this.quickSearchTextBox.get("value"));
			}));		    

			this.referenceListWidget = new PlanningNotificationOrderListWidget({
				applicationContext : this.applicationContext,
				showActions : false,
				sortStorageKey : "/planningNotificationOrderChoose/sort",
				gridId : "PlanningNotificationOrderChooseGrid",
				selectionMode : "extended",
				documentCaption : i18n.planningNotificationOrderEditReferenceDocumentCaption		
			});
			var listWidgetDiv = this.referenceListWidget.getContainer();
			domClass.add(listWidgetDiv, "fixedDialogWidget planningNotificationOrderChooseListDiv");
			domConstruct.place(listWidgetDiv, this.content);	    
			this.referenceListWidget.resize({ w : this.defaultWidth, h : this.defaultHeight - 35 });

			on(this.referenceListWidget, "selectionChanged", lang.hitch(this, function(selectedPlanningNotificationOrderInfo) {
				this.selectedPlanningNotificationOrderInfo = selectedPlanningNotificationOrderInfo;
				this.updateWidgetState();		
			}));	    

			var columnSettings = {
					showSerialNumber : true,
					showText : true,
					showPlanningNotification : true,
					showProject : true		
			};


			this.referenceListWidget.setData({
				columnSettings : columnSettings,
				planningNotificationOrderInfos : this.planningNotificationOrderInfos
			});

		},	

		processSerialNumberChange : function(newSerialNumber) {
			if (newSerialNumber != this.lastSerialNumber) {
				this.lastSerialNumber = newSerialNumber;
				this.quickSearchFilter();		
			}
		},

		processQuickSearchChange : function(newSearch) {
			if (newSearch != this.lastQuickSearch) {
				this.lastQuickSearch = newSearch;
				this.quickSearchFilter();		
			}
		},

		quickSearchFilter : function() {
			this.referenceListWidget.filter([{
				searchString : this.lastSerialNumber,
				tokenGetter : lang.hitch(this.referenceListWidget, this.referenceListWidget.getSerialNumberQuickSearchTokensForRow),
				equalMatchRequired : true		
			}, {
				searchString : this.lastQuickSearch,
				tokenGetter : lang.hitch(this.referenceListWidget, this.referenceListWidget.getTextDocumentProjectQuickSearchTokensForRow),
				equalMatchRequired : false	
			}]);					  
		},	

		updateWidgetState : function() {
			var buttonEnabled = this.selectedPlanningNotificationOrderInfo != null;
			this.selectButton.set("disabled", !buttonEnabled);
		},	    

		emitValueChosen : function(buttonName) {
			on.emit(this, "valueChosen", {
				selectedPlanningNotificationOrderInfo : this.selectedPlanningNotificationOrderInfo
			});		    
		},

		destroy : function() {
			this.inherited(arguments);
			this.referenceListWidget.destroy();
		}
	});

	return PlanningNotificationOrderChooseDialog;
});
