define([
        "clazzes/TinyLog",
        "clazzes/topic"
       ],
    function(
    		TinyLog,
    		topic
    		) {
	
	var className = "at.cdes.web.util.JobHelper";
	
	var log = new TinyLog(className);
	
    var JobHelper = {
    		
    		
    		registerJobStatusQueryForDownload : function(applicationContext, jobId, downloadUrlGetter) {
    			
    			var jobStatusService = applicationContext.getService("jobStatusService");
    			
				jobStatusService.waitForJob(jobId,1000).then(
						function(status) {
							
							if (status.lastLogMessages) {
								for (var i = 0; i < status.lastLogMessages.length; i++) {
									topic.publish("message/message",status.lastLogMessages[i]);
								}
							} 
							
							if (status.done) {
								if (status.exceptionMessage) {
									
									if (log.isDebugEnabled()) {
										log.debug("Print job [", jobId, "] failed :", status.exceptionMessage);	
									}
									
									topic.publish("message/error",status.exceptionMessage);
//									deferred.reject();
								} else {
									var url = downloadUrlGetter(jobId);

									if (status.result.disposition == "inline") {
										if (log.isDebugEnabled()) {
											log.debug("Print job [",jobId,"] finished, opening result in new window.");	
										}
										window.open(url);
									}
									else {
										if (log.isDebugEnabled()) {
											log.debug("Print job [",jobId,"] finished, downloading result in iframe.");	
										}
										var downloadFrame = applicationContext.getFancyIFrame();
										downloadFrame.set("src", url);
									}
//									deferred.resolve();
								}
							} else {
								if (log.isDebugEnabled()) {
									log.debug("Print job [",jobId,"] not finished yet, waiting another 3000ms...");	
								}
								JobHelper.registerJobStatusQueryForDownload(applicationContext, jobId, downloadUrlGetter);
							}
						},
						function(err) {
							log.error("waitForJob failed", err);
//							deferred.reject();
						}
				).otherwise(function(err) {
					log.error("Handler of waitForJob failed", err);
//					deferred.reject();
				});    			
    		}
    };
    
    return JobHelper;
});