/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = searchEdit
//// i18n-prefix = searchEdit


define([ "clazzes/TinyLog",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/TextBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/json",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(TinyLog,
    topic,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    TextBox,
    domClass,
    domConstruct,
    domStyle,
    json,
    on,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.widget.search.SearchEditWidget";

    var log = new TinyLog(className);

    var SearchEditWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
            this.changed = true;
        },

        getWidgetId : function() {
            return "SearchEditWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "searchEditTopDiv");

            DOMHelper.createTextNode("div", this.nameLabel, topDiv, "propertyLabel searchEditNameLabel");
            this.nameTextBox = new TextBox({
                    label : this.nameLabel,
                    title : this.nameLabel,
                maxLength : 50          
            });
            domClass.add(this.nameTextBox.domNode, "fixedDialogWidget searchEditNameTextBox");
            domConstruct.place(this.nameTextBox.domNode, topDiv);
            WidgetHelper.setMustField(this.nameTextBox, true);      
            WidgetHelper.handleTextBoxEvents(this.nameTextBox, lang.hitch(this, this.updateWidgetState));

            return topDiv;
        },

        setData : function(data) {
            this.serializedConfig = data.serializedConfig;

            if (this.mode == ContentWidget.Mode.CREATE) {
                this.search = {
                         name : "",
                      content : null,
                    networkId : this.applicationContext.getPageContextPnNetworkId()
                    
                };                  
            } else {
                this.search = data.search;
            }           
            this.reload();          
        },

        reload : function() {
            this.updateWidgetsFromData();
            this.updateWidgetState();
        },

        updateWidgetState : function() {
            WidgetHelper.updateEmptyTextBoxState(this.nameTextBox);

            var allFieldsValid = WidgetHelper.isTextBoxValid(this.nameTextBox);
            if (this.allFieldsValid != allFieldsValid) {
                this.allFieldsValid = allFieldsValid;
                on.emit(this, "validStateChange");              
            }
        },

        updateWidgetsFromData : function() {
            this.nameTextBox.set("value", this.search.name);
        },

        updateDataFromWidgets : function() {
            this.search.name = this.nameTextBox.get("value");
        },

        save : function() {
            this.updateDataFromWidgets();
            this.search.content = this.serializedConfig;

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            
            var utilService = this.applicationContext.getService("utilService");
            this.registerAsyncOperationStarted(SearchEditWidget.AsyncOperation.SAVE);
            return utilService.saveOrUpdateSearch(organisationPersonId, this.searchPageName, this.projectId, this.search).then(
                lang.hitch(this, function(result) {
                    this.registerAsyncOperationFinished(SearchEditWidget.AsyncOperation.SAVE);

                    if (!result) {
                        topic.publish("message/error", this.searchCreateRefusedMessage, true);
                    }                        
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : SearchEditWidget.AsyncOperation.SAVE,
                                opName : "saveOrUpdateSearch",
                               message : i18n.searchEditSaveOrUpdateFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [saveOrUpdateSearch]", err);
                    }));                            
        },          

        destroy : function() {
            this.inherited(arguments);
        }
    });

    SearchEditWidget.AsyncOperation = {
        SAVE : "Save"
    };

    return SearchEditWidget;
});
