define([ 
        "cdes/core/CdesVoc",
        "cdes/pdc/DocumentDateHistoryWidget",
        "cdes/pdc/PlanDeliverHelper",
        "cdes/util/ActionHelper",
        "cdes/util/CodeHelper",
        "cdes/util/FancyColumnResizer",
        "cdes/util/I18nHelper",
        "cdes/util/NameHelper",
        "cdes/util/SaveLoadHelper",
        "cdes/widget/CalendarSpinner",
        "cdes/widget/document/DocumentNumberEditor",
        "cdes/widget/util/DnDCellWidget",
        "cdes/widget/util/TextAreaDnDCellWidget",         
        "cdes/widget/base/ListWidget",
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/dateTime/DateHelper",
        "clazzes/dateTime/DateTimeSpinBox",
        "clazzes/dateTime/FancyDate",
        "clazzes/util/DataHelper",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/JoinHelper",
        "clazzes/util/StringHelper",
        "clazzes/widgets/DisableButton",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/Textarea",
        "dgrid/Editor",
        "dgrid/Grid",
        "dgrid/OnDemandGrid",
        "dgrid/_StoreMixin",
        "dgrid/extensions/ColumnHider",
        "dgrid/extensions/ColumnResizer",
        "dgrid/extensions/DijitRegistry",
        "dgrid/util/misc",
        "dojo/aspect",
        "dojo/dom-attr",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/has",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/promise/all",
        "dstore/Memory",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         CdesVoc,
         DocumentDateHistoryWidget,
         PlanDeliverHelper,
         ActionHelper,
         CodeHelper,
         FancyColumnResizer,
         I18nHelper,
         NameHelper,
         SaveLoadHelper,
         CalendarSpinner,
         DocumentNumberEditor,
         DnDCellWidget,
         TextAreaDnDCellWidget,
         ListWidget,
         TinyLog,
         topic,
         DateHelper,
         DateTimeSpinBox,
         FancyDate,
         DataHelper,
         DOMHelper,
         ErrorHelper,
         JoinHelper,
         StringHelper,
         DisableButton,
         ContentWidget,
         InfoDialog,
         Textarea,
         Editor,
         Grid,
         OnDemandGrid,
         _StoreMixin,
         ColumnHider,
         ColumnResizer,
         DijitRegistry,
         dgridMiscUtil,
         aspect,
         domAttr,
         domClass,
         domConstruct,
         has,
         on,
         string,
         declare,
         lang,
         promiseAll,
         Memory,
         i18n
         ) {
    
    var className = "at.cdes.web.plan.PlanDeliverListWidget";

    var log = new TinyLog(className);
    
    /*  How the Date Drag&Drop feature works
    *  ====================================
    *  
    *  When in editing mode, each editable to-date cell contains an extra 
    *  Drag&Drop button right of the date spinner.  When pressing the left
    *  mouse button on such a button, and moving the mouse with still
    *  pressed mouse button upwards or downwards, the date in that editor
    *  will be copied to the respective rows.
    *  
    *  Implementing this is a bit tricky, thus here an explanation how it
    *  works:
    *  
    *  - The to-date cells don´t use clazzes/dateTime/DateTimeSpinBox, but 
    *    cdes/widget/CalendarSpinner as editor; it basically assembles
    *    a DateTimeSpinBox with a calendar, and the button mentioned above.
    *  - set("value", ...) of CalendarSpinner receives not just the to-date,
    *    but an object { value, rowId }, where
    *      - value is the FancyDate to set
    *      - rowId identifies the row where the editor is located, in terms
    *        of the data
    *  - that objects are generated by the endDateFormatter, in case 
    *    canEditEndDate declares the cell to be editable
    *  
    *  This way, the CalendarSpinners have knowledge about which data item
    *  they edit; something which they usually wouldn´t have.  Furthermore,
    *  set("value", ...) each time called emits a topic (name decided
    *  by the PlanDeliverListWidget via the editorArgs) with the following
    *  arguments:
    *  
    *  - The domNode of the CalendarSpinner
    *  - The valueInfo it received.
    *  - The CalendarSpinner instance
    *  
    *  PlanDeliverListWidget subscribes to that topic, and records the 
    *  valueInfo in domNodeIdToValueInfo, and the reference to the
    *  CalendarSpinner instance in documentIdToEditors.
    *  
    *  The idea here is that the PlanDeliverListWidget must be able to 
    *  gain all the data (both Editor and valueInfo) solely based on the 
    *  domNode of a mouse event (as event processing doesn´t give as more
    *  information, unfortunately).
    *  
    *  Event processing now works as follows:
    *  
    *  - The CalendarSpinner handles the mousedown event on the DnD button
    *      - It immediately publishes a corresponding topic
    *          - The name of the topic is decided by the PlanDeliverListWidget,
    *            and passed using the editorArgs in the column definition.
    *      - Its arguments are:
    *          - The rowId as passed via set("value", ...) as described above
    *          - The FancyDate currently set in the DateTimeSpinBox
    *          - The mouse down event
    *      - That topic is subscribed by the PlanDeliverListWidget.
    *          - It records document id, e.clientY and date in instance
    *            variables
    *          - It sets up handlers for mouseup, mouseout and mouseover. 
    *  - The mouseover event is registered on the dgrid, with a restriction to
    *          .dgrid-cell.dgrid-column-documentEndDate:mouseover
    *    Its handler first searches the document id corresponding to the srcElement
    *    of the mouse event.  This is done by trying to find both the srcElement
    *    and its direct child nodes in the domNodeIdToValueInfo map filled above.
    *    (the case "direct child" is needed, as otherwise a mouseover on the cell,
    *     but not the editor itself wouldn´t trigger this code).
    *    
    *    If that search is successful, it next determines wether the row matching
    *    the event is above or below the row where the mouse was originally pressed.
    *    This is done by comparing e.clientY with the value safed before.
    *    
    *    Then, it steps upwards or downwards, and sets the to-be-copied date as
    *    value of all CalendarSpinners its finds on its way.   It additionally
    *    records the original dates and the information, which rows it touched 
    *    in this call to the event processor.
    *    
    *    Finally, if a CalendarSpinner was touched since the last mousedown, but
    *    not in this particular mouse over event, its value will be resetted to
    *    the original value stored before.  This takes care of the case the user
    *    moves the mouse back towards the origin of the DnD operation.
    *  
    *  - mouseup, when emitted anywhere on the document, deregisters the mouseup,
    *    mouseover and mouseout handlers; the CalendarSpinner will not be altered
    *    in any way further.
    *  - mouseout does the same, but only when the mouse leaves the grid.
    *  
    *  The reason why we have to implement this this way is that the dgrid offers
    *  methods for going up() or down() in the grid relative to some specified row,
    *  returning the respective neighbor rows, but has no means to find out which
    *  row matches the dom node of some particular event directly.
    *  
    *  Instead, we have to establish that mapping ourselves, using the event 
    *  processing scheme described above. 
    *  
    *  In particular, finding out where the mouseover event originated relative
    *  to the original mousedown event, and finding all rows between those two
    *  events turned out to be quite complicated.  
    */
    
    var PlanDeliverListWidget = declare(className, ListWidget, {
        
        constructor : function(params) {
            lang.mixin(this,params);
            
            this.columnSettings = new Object();
            
            /* Dynamic column hiding based on the ColumnHider plugin of dgrid, but with own CheckBoxes outside the table */ 
            this.columnVisibility = new Object();
            this.columnHiderRules = new Object();
            
            // The map reads like: (key ---> (documentNumber ---> document))
            // ... where key is either an objectPlannerId, or an objectId (depending on the document number uniqueness 
            //     enforced by the master data)
            this.keyToDocumentNumberToDocuments = new Object();
            
            this.lastNumberOfFound = 0;
            this.planDeliverJoinDtos = [];
            this.dndInfo = DnDCellWidget.constructDnDInfo();
            
            this.topDiv = this.constructTopDiv();
            
            this.allFieldsValid = true;
        },
        
        getWidgetId : function() {
            return "PlanDeliverListWidget";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        columnWidthKey : "planDeliver/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            /* Removed - not necessary - see CDES-1312
            if (this.mode == PlanDeliverListWidget.Mode.DEFAULT) {
            columns.push({
            field : "documentNumber",
            id : "documentNumber",
            sortable : true,
            label : i18n.planDeliverShortDocumentNumberColumnCaption
        });
        }*/

            columns.push({
                     field : "_documentNameRowObject",
                        id : "documentName",
                //                                  get : lang.hitch(this, this.documentNumberGetter),                               
                  sortable : true,
                     label : i18n.planDeliverDocumentNumberColumnCaption,
                    editor : DocumentNumberEditor,
                editorArgs : {       applicationContext : this.applicationContext,
                          objectPlannerGetter : null,
                    documentNumberToDocuments : this.documentNumberToDocuments,
                                dndStartTopic : null,
                                 setDataTopic : PlanDeliverListWidget.documentNameSetDataTopic,
                            rowObjectToString : PlanDeliverHelper.documentNameToString
                },
                   canEdit : lang.hitch(this, this.canEditDocumentName),
                 formatter : lang.hitch(this, this.documentNameFormatter),
                supportDnD : false
            });                     

            columns.push({
                     field : "_documentContentRowObject",
                        id : "documentContent",
                //                                  get : lang.hitch(this, this.contentGetter),
                renderCell : lang.hitch(this, this.renderContent),
                //                  formatter : lang.hitch(this, this.contentFormatter),
                  sortable : true,
                     label : i18n.planDeliverDocumentNameColumnCaption,
                    editor : TextAreaDnDCellWidget,                                  
                editorArgs : {        label : i18n.planDeliverListContentTextBoxLabel, 
                                  title : i18n.planDeliverListContentTextBoxToolTip,
                          dndStartTopic : null,
                           setDataTopic : PlanDeliverListWidget.documentContentSetDataTopic,
                      rowObjectToString : PlanDeliverHelper.contentToString,
                                 locale : this.applicationContext.getPageContextPersonVariablesUserLocale(),
                    contentLocaleGetter : lang.hitch(this, this.getContentLocales)
                },
                   canEdit : lang.hitch(this, this.canEditDocumentContent),
                supportDnD : false
            });                     

            columns.push({
                     field : "_documentScaleRowObject",
                        id : "documentScale",
                 formatter : lang.hitch(this, this.scaleFormatter),                                    
                  sortable : true,
                     label : i18n.planDeliverScaleColumnCaption,
                    editor : TextAreaDnDCellWidget,
                editorArgs : {        label : i18n.planDeliverListScaleTextBoxLabel, 
                                title : i18n.planDeliverListScaleTextBoxToolTip,
                        dndStartTopic : null,
                         setDataTopic : PlanDeliverListWidget.documentScaleSetDataTopic,
                    rowObjectToString : PlanDeliverHelper.scaleToString
                },
                   canEdit : lang.hitch(this, this.canEditDocumentScale),
                supportDnD : false
            });                     

            columns.push({
                    field : "_object",
                       id : "objectId",
                formatter : lang.hitch(this, this.objectFormatter),
                 sortable : true,
                    label : i18n.planDeliverObjectColumnCaption
            });                     

            columns.push({
                    field : "_objectPlanner",
                       id : "objectPlannerId",
                formatter : lang.hitch(this, this.objectPlannerFormatter),
                 sortable : true,
                    label : i18n.planDeliverObjectPlannerColumnCaption
            });                     
            
            columns.push({
                    field : "_planner",
                       id : "projectParticipationId",
                formatter : lang.hitch(this, this.plannerFormatter),
                 sortable : true,
                    label : i18n.planDeliverPlannerColumnCaption
            });                     

            var fromLabel = null;
            var toLabel = null;
            if (this.mode == PlanDeliverListWidget.Mode.DEFAULT) {
                fromLabel = i18n.planDeliverFromColumnCaption;
                toLabel = i18n.planDeliverToColumnCaption;
            } else if (this.mode == PlanDeliverListWidget.Mode.RELEASE) {
                fromLabel = i18n.planDeliverFromReleaseColumnCaption;
                toLabel = i18n.planDeliverToReleaseColumnCaption;
            }
            columns.push({
                     field : "_documentStartDateRowObject",
                        id : "documentStartDate",
                  sortable : true,
                     label : fromLabel,
                    editor : CalendarSpinner,
                editorArgs : {       
                             timeZone : this.applicationContext.getTimeZone(),
                              pattern : i18n.datePattern, 
                                label : i18n.planDeliverListStartTextBoxLabel, 
                                title : i18n.planDeliverListStartTextBoxToolTip,
                           dndEnabled : true,
                        dndStartTopic : PlanDeliverListWidget.documentStartDateDnDStartTopic,                                              
                         setDataTopic : PlanDeliverListWidget.documentStartDateDataTopic,
                           tableClass : "refNodeOfPositionAbsolute",
                    rowObjectToString : PlanDeliverHelper.startDateToString 
                },
                   canEdit : lang.hitch(this, this.canEditDatesAtAll),
                 formatter : lang.hitch(this, this.startDateFormatter)
            });                     

            columns.push({
                     field : "_documentEndDateRowObject",
                        id : "documentEndDate",
                  sortable : true,
                     label : toLabel,
                    editor : CalendarSpinner,
                editorArgs : {         
                             timeZone : this.applicationContext.getTimeZone(),
                              pattern : i18n.datePattern, 
                                label : i18n.planDeliverListEndTextBoxLabel, 
                                title : i18n.planDeliverListEndTextBoxToolTip,
                           dndEnabled : true,                                              
                        dndStartTopic : PlanDeliverListWidget.documentEndDateDnDStartTopic,
                        setDataTopic  : PlanDeliverListWidget.documentEndDateSetDataTopic,
                           tableClass : "refNodeOfPositionAbsolute",
                    rowObjectToString : PlanDeliverHelper.endDateToString
                },
                   canEdit : lang.hitch(this, this.canEditDatesAtAll),
                 formatter : lang.hitch(this, this.endDateFormatter)
            });

            columns.push({
                   field : "_duration",
                      id : "documentDuration",
                sortable : true,
                   label : /*this.unreleased || this.editing ?*/ i18n.planDeliverPeriodColumnCaption /*: i18n.planDeliverPeriodColumnLabel*/
            });                     

            columns.push({
                     field : "_documentCommentRowObject",
                        id : "documentComment",
                //                                  get : lang.hitch(this, this.commentGetter),
                 formatter : lang.hitch(this, this.commentFormatter),
                  sortable : true,
                     label : i18n.planDeliverCommentColumnCaption,
                    editor : TextAreaDnDCellWidget,
                editorArgs : {        label : i18n.planDeliverListCommentTextBoxLabel, 
                                title : i18n.planDeliverListCommentTextBoxToolTip,
                        dndStartTopic : null,
                         setDataTopic : PlanDeliverListWidget.documentCommentSetDataTopic,
                           supportDnD : false,
                    rowObjectToString : PlanDeliverHelper.commentToString 
                },
                   canEdit : lang.hitch(this, this.canEditDocumentComment)
                
            });                     
            
            if (this.mode == PlanDeliverListWidget.Mode.DEFAULT) {
                columns.push({
                         field : "documentId",
                            id : "actions",
                    renderCell : lang.hitch(this, this.renderActionCell),                                   
                      sortable : false,
                         label : i18n.actionColumnCaption 
                });                             
            }
            
            return columns;
        },
        
        constructTopDiv : function() {

            var columns = this.constructColumns();
            this.store = new Memory({data : [], idProperty : "documentId"});
            
            var MyGrid = declare([OnDemandGrid, FancyColumnResizer, DijitRegistry, Editor]);
            this.grid = new MyGrid({
                collection : this.store,
                   columns : columns,
                        id : "PlanDeliverListGrid"
            });
            
            this.grid.afterResizeMouseUp = lang.hitch(this, this.handleColumnResize);
            
            on(this.grid, "dgrid-columnstatechange", function(evt){
                //                              log.info("Column for field " + evt.column.field + " is now " + (evt.hidden ? "hidden" : "shown"));
            });             
            
            on(this.grid, "dgrid-datachange", lang.hitch(this, function(e) {
                var column = e.cell && e.cell.column ? e.cell.column.id : null;
                var rowId = e.cell && e.cell.row ? e.cell.row.id : null;                                                
                
                // DnDCellWidget uses values { value, rowId }.
                var oldValue = e.oldValue.value;
                var newValue = e.value.value;

                if (column == "documentName") {
                    // Keep document number map up to date
                    
                    if (oldValue.documentTypeId != newValue.documentTypeId || oldValue.number != newValue.number || oldValue.part != newValue.part) {
                        var projectParticipation = JoinHelper.getJoinDtoComponent(oldValue, "projectParticipation");
                        var oldKey = this.getDocumentKeyByUniqueness(oldValue);
                        var somethingRemoved = this.deregisterFromDocumentNumberMap(oldKey, oldValue, projectParticipation);
                        
                        // TODO: Comment from PlanDeliverNewWidget - still valid here?
                        // This code can especially be triggered from setDocumentNumber above.  In that case, the bookkeeping tasks done in
                        // (de)registerInDocumentNumberMap are already done at this point.  Unfortunately, we receive the old value here.  Without
                        // the extra condition "has anything been removed?", we would register the new number for the second time here.
                        if (somethingRemoved) {
                            var newKey = this.getDocumentKeyByUniqueness(newValue);
                            
                            var project = this.applicationContext.getPageContextProject();
                            var network = this.applicationContext.getPageContextNetwork();
                            var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
                            var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);                                             
                            var document = newValue;

                            var documentKey = CodeHelper.getUniqueKeyForDocument(document, documentNumberParts, idToDocumentType, projectParticipation); 
                            this.registerInDocumentNumberMap({
                                                           key : newKey,
                                                   documentKey : documentKey,
                                                      document : document,
                                doUpdateDocumentNumberFeedback : true
                            });                                             
                        }                                       
                    }
                    this.updateDataFromWidgets({ documentName : true });
                } else if (column == "documentStartDate") {
                    var joinDto = this.store.getSync(rowId);
                    if (newValue != null) {                                 
                        var endDateRowObject = this.getEndDateByStartDate(newValue, joinDto.reviewCycleInstanceDuration, rowId);

                        var editors = this.dndInfo.rowIdToEditors[rowId];
                        var startDateSpinner = editors.startDateCalendarSpinner;
                        var endDateSpinner = editors.endDateCalendarSpinner;

                        var holidayCalculator = this.applicationContext.getHolidayCalculator();
                        this.dndInfo.rowIdToHolidayError[rowId] = holidayCalculator.isWeekendOrHoliday(newValue) && this.hasNoReleasedLastVersion(joinDto);
                        if (this.dndInfo.rowIdToHolidayError[rowId]) {
                            domClass.add(startDateSpinner.dateTimeSpinBox.textbox, "errorField");
                            this.dndInfo.rowIdToHolidayMessage[rowId] = string.substitute(i18n.planDeliverHolidayError, {
                                documentName : CodeHelper.getDocumentName(joinDto._documentNameRowObject.value)//joinDto.documentName
                            });
                        } else {
                            domClass.remove(startDateSpinner.dateTimeSpinBox.textbox, "errorField");
                            delete this.dndInfo.rowIdToHolidayMessage[rowId];
                        }       
                        if (endDateSpinner)
                        endDateSpinner.set("value", endDateRowObject, false);
                    }                               
                } else if (column == "documentEndDate") {
                    var joinDto = this.store.getSync(rowId);
                    if (newValue != null) {
                        var startDateRowObject = this.getStartDateByEndDate(newValue, joinDto.reviewCycleInstanceDuration, rowId);

                        var editors = this.dndInfo.rowIdToEditors[rowId];
                        var startDateSpinner = editors.startDateCalendarSpinner;
                        var endDateSpinner = editors.endDateCalendarSpinner;

                        var holidayCalculator = this.applicationContext.getHolidayCalculator();
                        this.dndInfo.rowIdToHolidayError[rowId] = holidayCalculator.isWeekendOrHoliday(newValue) && this.hasNoReleasedLastVersion(joinDto);
                        if (this.dndInfo.rowIdToHolidayError[rowId]) {
                            domClass.add(endDateSpinner.dateTimeSpinBox.textbox, "errorField");
                            this.dndInfo.rowIdToHolidayMessage[rowId] = string.substitute(i18n.planDeliverHolidayError, {
                                documentName : CodeHelper.getDocumentName(joinDto._documentNameRowObject.value)//joinDto.documentName
                            });
                        } else {
                            domClass.remove(endDateSpinner.dateTimeSpinBox.textbox, "errorField");
                            delete this.dndInfo.rowIdToHolidayMessage[rowId];
                        }                                               
                        
                        if (startDateSpinner)
                        startDateSpinner.set("value", startDateRowObject, false);
                    }                               
                }
                
                this.updateWidgetState();
            }));
            
            on(this.grid, "dgrid-sort", lang.hitch(this, function() {
                this.updateDataFromWidgets();
                
                // Unfortunately, dgrid 
                // (1) first emits the dgrid-sort event
                // (2) then recreates the widgets inside the grid
                // Thus, we need setTimeout to make the updateCalendarSpinnerDisabledState 
                // function being executed *after* the widgets were recreated.
                setTimeout(lang.hitch(this, this.updateCalendarSpinnerDisabledState), 0);
            }));
            
            aspect.after(this.grid, "renderArray", lang.hitch(this, function(retValue) {
                this.updateCalendarSpinnerDisabledState();
                return retValue;
            }));
            
            aspect.after(this.grid, "renderRow", lang.hitch(this, function(row, args) {
                var joinDto = args[0];
                this.updateRowClass(row, joinDto);
                return row;
            }));
            
            domClass.add(this.grid.domNode, "planDeliverGrid");
            
            on(this.grid, "columnResizeMouseUp", lang.hitch(this, this.handleColumnResize));

            this.grid.startup();
            
            /*
            var MyGrid = declare([Grid, ColumnHider, ColumnResizer, DijitRegistry]);
            this.grid = new MyGrid({ columns : columns, 
            id : "planDeliverGrid",
            store : this.store
        });
            */
            //this.grid.renderArray(this.store);
            
            this.gridRuleSelectorPrefix = "#" + dgridMiscUtil.escapeCssIdentifier(this.grid.domNode.id) + " .dgrid-column-";

            DnDCellWidget.setupDnD({
                destroyableOwner : this,                          
                    setDataTopic : PlanDeliverListWidget.documentNameSetDataTopic,
                        columnId : "documentName",
                      editorName : "documentNumberEditor",
                         dndInfo : this.dndInfo,
                            grid : this.grid,
                          setter : lang.hitch(this, this.setDocumentNumber),
                     onlySetData : true                            
            });                     
            
            DnDCellWidget.setupDnD({
                destroyableOwner : this,
                    setDataTopic : PlanDeliverListWidget.documentStartDateDataTopic,
                   startDnDTopic : PlanDeliverListWidget.documentStartDateDnDStartTopic,                   
                        columnId : "documentStartDate",
                      editorName : "startDateCalendarSpinner",
                         dndInfo : this.dndInfo,
                            grid : this.grid
            });                     
            
            DnDCellWidget.setupDnD({
                destroyableOwner : this,
                    setDataTopic : PlanDeliverListWidget.documentEndDateSetDataTopic,
                   startDnDTopic : PlanDeliverListWidget.documentEndDateDnDStartTopic,
                      editorName : "endDateCalendarSpinner",
                         dndInfo : this.dndInfo,
                            grid : this.grid,
                        columnId : "documentEndDate"
            });
            
            DnDCellWidget.setupDnD({
                destroyableOwner : this,                          
                    setDataTopic : PlanDeliverListWidget.documentContentSetDataTopic,
                        columnId : "content",
                      editorName : "contentTextArea",
                         dndInfo : this.dndInfo,
                            grid : this.grid,
                          setter : lang.hitch(this, this.setDocumentContent),
                     onlySetData : true                                                                   
            });             
            DnDCellWidget.setupDnD({
                destroyableOwner : this,                          
                    setDataTopic : PlanDeliverListWidget.documentScaleSetDataTopic,
                        columnId : "scale", 
                      editorName : "scaleTextArea",
                         dndInfo : this.dndInfo,
                            grid : this.grid,
                     onlySetData : true                                                                     
            }); 
            DnDCellWidget.setupDnD({
                destroyableOwner : this,                          
                    setDataTopic : PlanDeliverListWidget.documentCommentSetDataTopic,
                        columnId : "comment", 
                      editorName : "commentTextArea",
                         dndInfo : this.dndInfo,
                            grid : this.grid,
                     onlySetData : true                                                             
            });             
            
            this.own(
                topic.subscribe(PlanDeliverListWidget.documentStartDateDataTopic, lang.hitch(this, function(domNode, rowObject, src, kindOfChange) {
                    var documentId = rowObject.rowId;
                    var joinDto = this.grid.row(documentId).data;

                    if (rowObject != null && rowObject.value != null) {
                        var holidayCalculator = this.applicationContext.getHolidayCalculator();
                        var editors = this.dndInfo.rowIdToEditors[documentId];

                        if (rowObject.value != null) {                                  
                            if (this.unreleased) {
                                this.dndInfo.rowIdToHolidayError[rowObject.rowId] = holidayCalculator.isWeekendOrHoliday(rowObject.value) && this.hasNoReleasedLastVersion(joinDto);
                                if (this.dndInfo.rowIdToHolidayError[rowObject.rowId]) {
                                    domClass.add(editors.startDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                                    this.dndInfo.rowIdToHolidayMessage[rowObject.rowId] = string.substitute(i18n.planDeliverHolidayError, {
                                        documentName : CodeHelper.getDocumentName(joinDto._documentNameRowObject.value)//joinDto.documentName
                                    });
                                } else {
                                    domClass.remove(editors.startDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                                    if (editors.endDateCalendarSpinner != null && editors.endDateCalendarSpinner.dateTimeSpinBox != null && editors.endDateCalendarSpinner.dateTimeSpinBox.textbox != null) {
                                        domClass.remove(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");  
                                    }                                                                       
                                    delete this.dndInfo.rowIdToHolidayMessage[rowObject.rowId];
                                }
                            }
                        }
                    }                               

                    if (this.hasNoReleasedLastVersion(joinDto)) {
                        var endDateRowObject = this.getEndDateByStartDate(rowObject != null ? rowObject.value : null, joinDto.reviewCycleInstanceDuration, documentId);

                        var editors = this.dndInfo.rowIdToEditors[documentId];
                        var calendarSpinner = editors.endDateCalendarSpinner;

                        if (calendarSpinner) {
                            calendarSpinner.set("value", endDateRowObject, false);
                        }
                    }
                }), this),                              
                topic.subscribe(PlanDeliverListWidget.documentEndDateSetDataTopic, lang.hitch(this, function(domNode, rowObject, src, kindOfChange) {
                    var documentId = rowObject.rowId;
                    var joinDto = this.grid.row(documentId).data;

                    if (rowObject != null && rowObject.value != null) {
                        var holidayCalculator = this.applicationContext.getHolidayCalculator();
                        var editors = this.dndInfo.rowIdToEditors[documentId];

                        if (rowObject.value != null) {                                  
                            if (CdesVoc.doCorrectDates()) {
                                if (kindOfChange == "set" || kindOfChange == "increment") {
                                    holidayCalculator.proceedToNextWorkingDay(rowObject.value);     
                                } else if (kindOfChange == "decrement") {
                                    holidayCalculator.proceedToPreviousWorkingDay(rowObject.value);
                                }                                               
                                editors.endDateCalendarSpinner.set("value", rowObject, false);                                          
                            } else if (this.unreleased) {
                                this.dndInfo.rowIdToHolidayError[rowObject.rowId] = holidayCalculator.isWeekendOrHoliday(rowObject.value) && this.hasNoReleasedLastVersion(joinDto);
                                if (this.dndInfo.rowIdToHolidayError[rowObject.rowId]) {
                                    domClass.add(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                                    this.dndInfo.rowIdToHolidayMessage[rowObject.rowId] = string.substitute(i18n.planDeliverHolidayError, {
                                        documentName : CodeHelper.getDocumentName(joinDto._documentNameRowObject.value)//joinDto.documentName
                                    });
                                } else {
                                    if (editors.startDateCalendarSpinner != null && editors.startDateCalendarSpinner.dateTimeSpinBox != null
                                        && editors.startDateCalendarSpinner.dateTimeSpinBox.textbox != null) {
                                        domClass.remove(editors.startDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");                                                                                
                                    }                                                                       
                                    domClass.remove(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                                    delete this.dndInfo.rowIdToHolidayMessage[rowObject.rowId];
                                }
                            }
                        }
                    }                               

                    if (this.hasNoReleasedLastVersion(joinDto)) {
                        var startDateRowObject = this.getStartDateByEndDate(rowObject != null ? rowObject.value : null, joinDto.reviewCycleInstanceDuration, documentId);

                        var editors = this.dndInfo.rowIdToEditors[documentId];
                        var calendarSpinner = editors.startDateCalendarSpinner;

                        if (calendarSpinner) {
                            calendarSpinner.set("value", startDateRowObject, false);
                        }
                    }
                }), this)
                     );
            
            return this.grid.domNode;
        },
        
        getStartDateByEndDate : function(endDate, reviewCycleInstanceDuration, documentId) {
            var holidayCalculator = this.applicationContext.getHolidayCalculator();                                                 

            if (endDate) {
                var duration = reviewCycleInstanceDuration; 
                var newStartDate = holidayCalculator.addWorkingDays(endDate, -duration);
                return { value : newStartDate, rowId : documentId, toString : PlanDeliverHelper.startDateToString };
            } else {
                return { value : null, rowId : documentId, toString : PlanDeliverHelper.startDateToString };
            }                       
        },
        
        getEndDateByStartDate : function(startDate, reviewCycleInstanceDuration, documentId) {                                  
            var holidayCalculator = this.applicationContext.getHolidayCalculator();                                                 

            if (startDate) {
                var duration = reviewCycleInstanceDuration; 
                var newEndDate = holidayCalculator.addWorkingDays(startDate, duration);
                return { value : newEndDate, rowId : documentId, toString : PlanDeliverHelper.endDateToString };
            } else {
                return { value : null, rowId : documentId, toString : PlanDeliverHelper.endDateToString };
            }                       
        },      
        
        setDocumentNumber : function(creationIndex, editor, baseValue, offset) {
            /*
            var documentNumberInfo = baseValue;             
            var baseNumber = documentNumberInfo.number;
            var document = this.store.getSync(creationIndex);
            
            if (document == null) {
            throw new Error("No document registered for baseNumber", baseValue);
        }
            
            this.deregisterFromDocumentNumberMap(document);
            
            var newNumber = this.getFirstUnusedDocumentNumber(document, baseNumber + offset);
            document.number = newNumber;
            document.documentTypeId = documentNumberInfo.documentTypeId;
            
            DocumentNumberEditor.extractEditorInfo(document);
            
            this.registerInDocumentNumberMap(document, true);
            
            this.updateWidgetsFromData({ documentName : true });
            this.updateDocumentNumberFeedback();
            */              
        },      
        
        setContentLocales : function(contentLocales) {
            this.contentLocales = contentLocales;
        },

        getContentLocales : function() {
            return this.contentLocales;
        },        

        resize : function(newSize) {
            this.grid.resize(newSize);
        },
        
        setData : function(dataAndColumns) {
            
            this.planDeliverJoinDtos = dataAndColumns.data;
            /*
            var l = this.planDeliverJoinDtos.length;
            for (var n = 0; n < 10; n++) {
            for (var z = 0; z < l; z++) {
            this.planDeliverJoinDtos.push({ documentId : z + 1000, documentName : (z + 1000).toString()});
        }
        }*/
            
            this.documentIdToHistoryItems = dataAndColumns.documentIdToHistoryItems;
            this.unreleased = dataAndColumns.unreleased;
            this.actualReleased = dataAndColumns.actualReleased;
            this.numberOfObjectListReleases = dataAndColumns.numberOfObjectListReleases;
            this.updateAuxiliaryData(false);
            
            if (dataAndColumns.columns) {
                this.setColumnSettings(dataAndColumns.columns); 
            }               
            this.objectPlannerIdToActions = dataAndColumns.objectPlannerIdToActions;
            
            this.reload();
        },
        
        getData : function() {
            return this.planDeliverJoinDtos;
        },
        
        updateAuxiliaryData : function(onlyDateStrings) {
            for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
                var joinDto = this.planDeliverJoinDtos[n];
                
                var numberParts = CodeHelper.getDocumentNumberParts(this.applicationContext);
                DocumentNumberEditor.extractEditorInfoFromJoinDto(this.applicationContext, numberParts, joinDto);
                
                if (!onlyDateStrings) {
                    // Offer id and endDate in a combined object, in order to be able to inject it into the CalendarSpinner
                    joinDto._planner = this.plannerFormatter(null, joinDto);
                    joinDto._object = this.objectFormatter(null, joinDto);
                    joinDto._objectPlanner = this.objectPlannerFormatter(null, joinDto);
                    
                    joinDto._documentNameRowObject = {
                           value : joinDto._documentNumberInfo,
                           rowId : joinDto.documentId,
                        toString : PlanDeliverHelper.documentNameToString
                    };
                    joinDto._documentNameRowObject.value._clientCalculatedName = CodeHelper.getDocumentName(joinDto._documentNameRowObject.value);                          
                    
                    joinDto._documentCommentRowObject = {
                           value : joinDto.documentComment,
                           rowId : joinDto.documentId,
                        toString : PlanDeliverHelper.commentToString
                    };

                    var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                    joinDto._documentContentRowObject = {
                        // value : I18nHelper.getCurrentLocaleString(joinDto.documentContent, locale),
                           value : joinDto.documentContent,
                           rowId : joinDto.documentId,
                        toString : PlanDeliverHelper.contentToString
                    };
                    
                    joinDto._documentScaleRowObject = {
                           value : joinDto.documentScale,
                           rowId : joinDto.documentId,
                        toString : PlanDeliverHelper.scaleToString
                    };
                }                       
                
                var startDate = joinDto.documentStartDate != null 
                              ? new FancyDate({ utcSeconds : joinDto.documentStartDate, timeZone : this.applicationContext.getTimeZone() }) : null;
                var endDate = joinDto.documentEndDate != null 
                            ? new FancyDate({ utcSeconds : joinDto.documentEndDate, timeZone : this.applicationContext.getTimeZone() }) : null;                                                     
                joinDto._documentStartDateRowObject = {
                       value : startDate,
                       rowId : joinDto.documentId,
                    toString : PlanDeliverHelper.startDateToString  // Delibarately without lang.hitch
                };
                joinDto._documentEndDateRowObject = {
                       value : endDate,
                       rowId : joinDto.documentId,
                    toString : PlanDeliverHelper.endDateToString
                };      
                
                //reviewCycleInstanceDuration and documents actual duration in brackets in case of non released version or editing mode
                //else documents duration
                var docDurationString = (joinDto.documentDuration != null /*&& joinDto.documentDuration != joinDto.reviewCycleInstanceDuration*/)? ' ['+joinDto.documentDuration.toString()+ ']' : '';
                //if (this.unreleased || this.editing)
                	joinDto._duration = (joinDto.reviewCycleInstanceDuration != null ? joinDto.reviewCycleInstanceDuration.toString() + docDurationString : '-');
                //else
                	//joinDto._duration = joinDto.documentDuration != null ? joinDto.documentDuration.toString() : '-';
                
                if (endDate != null) {
                    var holidayCalculator = this.applicationContext.getHolidayCalculator();
                    if (this.unreleased) {
                        this.dndInfo.rowIdToHolidayError[joinDto.documentId] = holidayCalculator.isWeekendOrHoliday(endDate) && this.hasNoReleasedLastVersion(joinDto);
                        if (this.dndInfo.rowIdToHolidayError[joinDto.documentId]) {
                            this.dndInfo.rowIdToHolidayMessage[joinDto.documentId] = string.substitute(i18n.planDeliverHolidayError, {
                                documentName : CodeHelper.getDocumentName(joinDto._documentNameRowObject.value)//joinDto.documentName 
                            });                                             
                        } else {
                            delete this.dndInfo.rowIdToHolidayMessage[joinDto.documentId];
                        }                                               
                    } else {
                        delete this.dndInfo.rowIdToHolidayMessage[joinDto.documentId];
                    }
                }

                /*
                if (this.dndInfo.rowIdToHolidayError[rowId]) {
                domClass.add(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
            } else {
                domClass.remove(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
            }*/                             
                
                this.calculateStartDateStrings(joinDto);
                this.calculateEndDateStrings(joinDto);
            }               
        },
        
        PLAN_DELIVER_SORT_PROPERTIES : [{ attribute : "_documentNameRowObject", descending : false}],
        
        setColumns : function(columnSettings) {
            // summary:
            //     This is the PUBLIC function for changing the column settings from outside.
            
            this.updateColumns(columnSettings);
        },
        
        reload : function() {
            DnDCellWidget.clearDnDInfo(this.dndInfo);
            
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            var project = this.applicationContext.getPageContextProject();
            var subProjectId = this.applicationContext.getPageContextSubProjectId();                
            
            this.registerAsyncOperationStarted(PlanDeliverListWidget.AsyncOperation.RELOAD);
            var objectService = this.applicationContext.getService("objectService");
            if (this.loadObjectsDeferred != null) {
                if (this.loadObjectsLastOrganisationPersonId == null || this.loadObjectsLastOrganisationPersonId != organisationPersonId
                    || this.loadObjectsLastSubProjectId == null || this.loadObjectsLastSubProjectId != subProjectId) {
                    this.loadObjectsDeferred.cancel();
                    this.loadObjectsDeferred = objectService.getEditableObjectPlannersForSubProject(organisationPersonId, subProjectId);
                }
            } else {
                this.loadObjectsDeferred = objectService.getEditableObjectPlannersForSubProject(organisationPersonId, subProjectId);
            }
            // An already running loadMasterDataDeferred is handled inside applicationContext
            
            
            this.loadObjectsLastOrganisationPersonId = organisationPersonId;
            this.loadObjectsLastSubProjectId = subProjectId;
            
            var loadMasterDataDeferred = this.applicationContext.loadMasterData(networkId);
            
            promiseAll([this.loadObjectsDeferred, loadMasterDataDeferred]).then(lang.hitch(this, function(results) {
                // TODO: Dialog needs to be disabled until these Deferreds come back
                var objectPlannerNewDocumentInfo = results[0];                          

                var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, networkId);
                this.documentNumberUniqueness = CodeHelper.getDocumentNumberUniqueness(documentNumberParts);  
                
                this.objectIdToDocumentKeys = objectPlannerNewDocumentInfo.objectIdToDocumentKeys;
                this.objectPlannerIdToDocumentKeys = objectPlannerNewDocumentInfo.objectPlannerIdToDocumentKeys;
                
                this.resetDocumentNumberMap();                          
                
                this.registerAsyncOperationFinished(PlanDeliverListWidget.AsyncOperation.RELOAD);
                
                this.updateColumns();
                
                this.store.setData(this.planDeliverJoinDtos);
                //this.grid.set("sort", this.PLAN_DELIVER_SORT_PROPERTIES);
                this.grid.set("sort", "_documentNameRowObject", false);
                this.grid.updateSortArrow(this.grid.sort);
                this.grid.refresh();
                this.updateCalendarSpinnerDisabledState();
                
                this.lastNumberOfFound = this.planDeliverJoinDtos.length;
                
                delete this.loadObjectsDeferred;                        
            }),
                lang.hitch(this, function(err) { 
                    if (this.loadObjectsDeferred != null) {
                        // A promiseAll most probably fails if one of its Deferred fails - thus cancel() this one, as it might
                        // still be running.  The loadMasterDataDeferred is handled inside the 
                        // applicationContext, and no harm here.
                        this.loadObjectsDeferred.cancel();
                        delete this.loadObjectsDeferred;        
                    }                               
                    
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanDeliverListWidget.AsyncOperation.RELOAD,
                                opName : "loadMasterData",
                               message : i18n.planDeliverListLoadMetaDataFailedMessage
                    });                             
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of a call to loadMasterData: ", err);
                }));                    
        },
        
        updateRowClass : function(domNode, joinDto) {
            domClass.remove(domNode, "documentModifiedNew");
            domClass.remove(domNode, "documentModifiedDate");
            domClass.remove(domNode, "documentModifiedGeneral");
            
            if (joinDto.documentModified == CdesVoc.DocumentModifiedState.NEW) {
                domClass.add(domNode, "documentModifiedNew");
            } else if (joinDto.documentModified == CdesVoc.DocumentModifiedState.DATE_MODIFIED) {
                domClass.add(domNode, "documentModifiedDate");
            } else if (joinDto.documentModified == CdesVoc.DocumentModifiedState.CONTENT_MODIFIED) {
                domClass.add(domNode, "documentModifiedGeneral");
            }
        },
        
        setColumnSettings : function(columnSettings) {
            // summary:
            //     This is the PRIVATE function for actually setting the columnSettings map, by making a copy of it
            //     (updateColumns rely on the fact that this.columnSettings and columnSettings are not the same object)
            
            this.columnSettings = new Object();
            for (var column in columnSettings) {
                this.columnSettings[column] = columnSettings[column];
            }
        },

        updateColumns : function(columnSettings) {
            // summary:
            //     Updates the visible columns of the grid, while causing as little work for the browser as possible.
            // columnSettings:
            //     If null, this function assumes that the grid has been resetted with new data just now anyway,
            //     if not null, this object contains the new columnSettings that are set into this.columnSettings and
            //     processed by this function.
            
            // Record which of the columns corresponding to multiple CheckBoxes has changed data; the request to invalidate that
            // data has to be issued separately in case that the visibility of the column doesn´t change (e.g. switch from person + organisation to person)
            var plannerChange =    columnSettings && (     columnSettings.showPlannerPerson != this.columnSettings.showPlannerPerson 
                                                      || columnSettings.showPlannerOrganisation != this.columnSettings.showPlannerOrganisation);
            var objectChange =     columnSettings && (     columnSettings.showObjectNumber != this.columnSettings.showObjectNumber
                                                      || columnSettings.showObjectName != this.columnSettings.showObjectName);
            var objectPlannerChange = columnSettings && (columnSettings.showObjectPlannerCode != this.columnSettings.showObjectPlannerCode
                                                         || columnSettings.showObjectPlannerName != this.columnSettings.showObjectPlannerName);
            
            if (columnSettings) {
                // The case where this function is responsible for processing the new settings
                this.setColumnSettings(columnSettings);
            }               
            
            // Update the individual columns
            this.updateColumn("projectParticipationId", this.columnSettings.showPlannerPerson || this.columnSettings.showPlannerOrganisation, plannerChange);
            this.updateColumn("objectId", this.columnSettings.showObjectNumber || this.columnSettings.showObjectName, objectChange);
            this.updateColumn("objectPlannerId", this.columnSettings.showObjectPlannerCode || this.columnSettings.showObjectPlannerName, objectPlannerChange);
            this.updateColumn("documentName", this.columnSettings.showDocumentNumber);
            this.updateColumn("documentContent", this.columnSettings.showDocumentName);
            this.updateColumn("documentScale", this.columnSettings.showScale);
            this.updateColumn("documentStartDate", this.columnSettings.showStart);
            this.updateColumn("documentEndDate", this.columnSettings.showEnd);
            this.updateColumn("documentDuration", this.columnSettings.showPeriod);
            this.updateColumn("documentComment", this.columnSettings.showComment);
        },
        
        updateColumn : function(id, show, triggerStateChangeAlways) {
            if (this.columnVisibility[id] == null || this.columnVisibility[id] != show) {
                // (Start) Code based on ColumnHider plugin for dgrid, dgrid/extensions/ColumnHider.js, _hideColumn, _showColumn, around line 300 (Start)
                
                if (show) {
                    if(this.columnHiderRules[id]){
                        this.columnHiderRules[id].remove();
                        delete this.columnHiderRules[id];
                    }                               
                } else if (!this.columnHiderRules[id]){
                    this.columnHiderRules[id] = dgridMiscUtil.addCssRule(this.gridRuleSelectorPrefix + dgridMiscUtil.escapeCssIdentifier(id, "-"), "display: none;");

                    if((has("ie") === 8 || has("ie") === 10) && !has("quirks")){
                        var tableRule = dgridMiscUtil.addCssRule(".dgrid-row-table", "display: inline-table;");

                        window.setTimeout(lang.hitch(this, function(){
                            tableRule.remove();
                            this.grid.resize();
                        }), 0);
                    }                               
                }
                
                this.columnVisibility[id] = show;
                
                // Update hidden state in actual column definition,
                // in case columns are re-rendered.                     
                this.grid.columns[id].hidden = !show;
                
                // Emit event to notify of column state change.
                on.emit(this.grid.domNode, "dgrid-columnstatechange", {
                       grid : this.grid,
                     column : this.grid.columns[id],
                     hidden : !show,
                    bubbles : true
                });
                
                // Adjust the size of the header.
                this.grid.resize();     
                
                // ((End) Code based on ColumnHider plugin (End))
            } else if (show && triggerStateChangeAlways) {
                on.emit(this.grid.domNode, "dgrid-columnstatechange", {
                       grid : this.grid,
                     column : this.grid.columns[id],
                     hidden : !show,
                    bubbles : true
                });                     
            }
        },
        
        startEditing : function() {
            this.editing = true;
            this.backupOriginalJoinDtos();
            

            
            // TODO: Maybe hide all non-editable rows here
            
            this.migrateDates();
            //              this.updateAuxiliaryData(true);
            
            this.grid.refresh();
            this.updateCalendarSpinnerDisabledState();              

            this.keyToDocumentNumberToDocuments = new Object();
            this.resetDocumentNumberMap();
            
            this.checkAllToDatesForHoliday();
            
            this.updateWidgetState();
        },
        
        updateCalendarSpinnerDisabledState : function() {
            if (this.dndInfo != null && this.dndInfo.rowIdToEditors != null) {
                for (var rowId in this.dndInfo.rowIdToEditors) {
                    this.updateCalendarSpinnerDisabledStateForDocument(rowId);
                }                       
            }               
        },
        
        updateCalendarSpinnerDisabledStateForDocument : function(documentId) {
            var editors = this.dndInfo.rowIdToEditors[documentId];
            if (editors != null) {
                var joinDto = this.store.getSync(documentId);
                if (editors.startDateCalendarSpinner != null && editors.startDateCalendarSpinner.domNode != null) {
                    editors.startDateCalendarSpinner.set("disabled", !(this.canEditStartDate(joinDto)));
                    editors.startDateCalendarSpinner.set("dndEnabled", this.canEditStartDate(joinDto));
                    editors.startDateCalendarSpinner.updateWidgetsState();
                }
                if (editors.endDateCalendarSpinner != null && editors.endDateCalendarSpinner.domNode != null) {
                    editors.endDateCalendarSpinner.set("disabled", !(this.canEditEndDate(joinDto)));    
                    editors.endDateCalendarSpinner.set("dndEnabled", this.canEditEndDate(joinDto));
                    editors.endDateCalendarSpinner.updateWidgetsState();
                }
            }
        },            

        checkAllToDatesForHoliday : function() {
            if (!CdesVoc.doCorrectDates() && this.unreleased) {
                var holidayCalculator = this.applicationContext.getHolidayCalculator();
                for (var rowId in this.dndInfo.rowIdToEditors) {
                    var editors = this.dndInfo.rowIdToEditors[rowId];
                    // Cases where the endDateCalendarSpinner isn't actually visible for security reasons
                    if (editors.endDateCalendarSpinner != null) {
                        var date = editors.endDateCalendarSpinner.get("value").value;
                        if (date != null) {
                            var joinDto = this.grid.row(rowId).data;                                                
                            this.dndInfo.rowIdToHolidayError[rowId] = holidayCalculator.isWeekendOrHoliday(date) && this.hasNoReleasedLastVersion(joinDto);
                            if (this.dndInfo.rowIdToHolidayError[rowId]) {
                                domClass.add(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                                
                                this.dndInfo.rowIdToHolidayMessage[rowId] = string.substitute(i18n.planDeliverHolidayError, {
                                    documentName : CodeHelper.getDocumentName(joinDto._documentNameRowObject.value)//joinDto.documentName
                                });                                             
                            } else {
                                domClass.remove(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                                delete this.dndInfo.rowIdToHolidayMessage[rowId];
                            }                                       
                        }                                       
                    }                       
                }                       
            }               
        },
        
        backupOriginalJoinDtos : function() {
            this.originalJoinDtos = [];
            for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
                this.originalJoinDtos.push(DataHelper.clone(this.planDeliverJoinDtos[n]));
            }
        },
        
        resetDocumentNumberMap : function() {
            this.keyToDocumentNumberToDocuments = new Object();
            
            // The DocumentNumberParts decide which notion of document number uniqueness we need.
            var existingDocumentNumbers = null;
            if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT) {
                for (var objectId in this.objectIdToDocumentKeys) {
                    for (var documentId in this.objectIdToDocumentKeys[objectId]) {
                        var uniqueDocumentInfo = this.objectIdToDocumentKeys[objectId][documentId];
                        var fakeDocument = this.constructFakeDocument(documentId, uniqueDocumentInfo.documentNumber);
                        this.registerInDocumentNumberMap({
                                                       key : objectId,
                                               documentKey : uniqueDocumentInfo.documentKey,
                                                  document : fakeDocument,
                            doUpdateDocumentNumberFeedback : true
                            
                        });
                    }
                }
            } else if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT_PLANNER) {
                for (var objectPlannerId in this.objectPlannerIdToDocumentKeys) {
                    for (var documentId in this.objectPlannerIdToDocumentKeys[objectPlannerId]) {
                        var uniqueDocumentInfo = this.objectPlannerIdToDocumentKeys[objectPlannerId][documentId];
                        var fakeDocument = this.constructFakeDocument(documentId, uniqueDocumentInfo.documentNumber);

                        this.registerInDocumentNumberMap({
                                                       key : objectPlannerId,
                                               documentKey : uniqueDocumentInfo.documentKey,
                                                  document : fakeDocument,
                            doUpdateDocumentNumberFeedback : true
                        });                                     
                    }
                }                       
            }
            
            var project = this.applicationContext.getPageContextProject();
            var network = this.applicationContext.getPageContextNetwork();
            var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
            var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);
            
            // Finally register all documents that are currently in the grid.
            for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
                var planDeliverJoin = this.planDeliverJoinDtos[n];
                
                var key = null;
                if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT) {
                    key = planDeliverJoin.objectId;
                } else if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT_PLANNER) {
                    key = planDeliverJoin.objectPlannerId;
                }
                
                // TODO: Although this should be no harm, this function might insert attributes not belonging to the entity Document into the
                // returned object.  Example: Attributes documentId, documentHistoryPartId would result in attributes id, historyPartId being returned.
                var document = JoinHelper.getJoinDtoComponent(planDeliverJoin, "document");
                var projectParticipation = JoinHelper.getJoinDtoComponent(planDeliverJoin, "projectParticipation");
                var documentKey = CodeHelper.getUniqueKeyForDocument(document, documentNumberParts, idToDocumentType, projectParticipation); 
                this.registerInDocumentNumberMap({
                                               key : key,
                                       documentKey : documentKey,
                                          document : document,
                    doUpdateDocumentNumberFeedback : true
                });
            }
            
            if (log.isDebugEnabled()) {
                log.debug("After calling resetDocumentNumberMap: keyToDocumentNumberToDocuments = ", this.keyToDocumentNumberToDocuments);
            }
        },      
        
        constructFakeDocument : function(documentId, documentNumber) {
            var fakeDocument = new Object();
            fakeDocument.id = documentId;
            fakeDocument.number = documentNumber; 
            return fakeDocument;
        },
        
        getDocumentKeyByUniqueness : function(documentNumberInfo) {
            if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT) {
                return documentNumberInfo.objectId;
            } else if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT_PLANNER) {
                return documentNumberInfo.objectPlannerId;
            } else {
                return null;
            }
        },
        
        registerInDocumentNumberMap : function(params) {
            var key = params.key;                 // Object or ObjectPlanner id
            var documentKey = params.documentKey; // DocumentKey already calculated at the server (for fake documents)
            var document = params.document;       // Document
            var projectParticipation = params.projectParticipation;
            var doUpdateDocumentNumberFeedback = params.doUpdateDocumentNumberFeedback;
            
            if (doUpdateDocumentNumberFeedback == null) {
                doUpdateDocumentNumberFeedback = true;
            }

            if (documentKey == null) {
                var project = this.applicationContext.getPageContextProject();
                var numberParts = this.applicationContext.getNumberPartsForProject(project);
                var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);
                documentKey = CodeHelper.getUniqueKeyForDocument(document, numberParts, idToDocumentType, projectParticipation);                        
            }
            
            if (!(key in this.keyToDocumentNumberToDocuments)) {
                this.keyToDocumentNumberToDocuments[key] = new Object();
            }
            if (!(documentKey in this.keyToDocumentNumberToDocuments[key])) {
                this.keyToDocumentNumberToDocuments[key][documentKey] = [];
            }
            
            var alreadyThere = false;
            var documents = this.keyToDocumentNumberToDocuments[key][documentKey];
            for (var n = 0; n < documents.length; n++) {
                if (       (document.id != null && document.id == documents[n].id)
                    || (document._creationIndex != null && document._creationIndex == documents[n]._creationIndex)) {
                        alreadyThere = true;
                    }
            }
            
            if (!alreadyThere) {
                documents.push(document);
            }
            
            if (documents.length > 1) {
                log.warn("Duplicate document number for key = [" + key + "]: ", document.number, documents);
            }
            
            if (doUpdateDocumentNumberFeedback) {
                this.updateDocumentNumberFeedback();    
            }               
            
            if (log.isDebugEnabled()) {
                log.debug("After calling registerInDocumentNumberMap", key, document, this.keyToDocumentNumberToDocuments);
            }                       
        },
        
        deregisterFromDocumentNumberMap : function(key, document, projectParticipation) {
            var project = this.applicationContext.getPageContextProject();
            var numberParts = this.applicationContext.getNumberPartsForProject(project);
            var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);
            documentKey = CodeHelper.getUniqueKeyForDocument(document, numberParts, idToDocumentType, projectParticipation);                
            
            // Caution: Since DocumentNumberEditors have to return a copy of the document (and not the document itself) as value,
            //          we may not assume reference-equality here.  In other words: The document-instance we get here might not be
            //          the same as we inserted before into datastructures like documentNumberToDocuments.
            
            if (document.number != null && (key in this.keyToDocumentNumberToDocuments) && (documentKey in this.keyToDocumentNumberToDocuments[key])) {
                
                var oldDocuments = this.keyToDocumentNumberToDocuments[key][documentKey];
                var newDocuments = [];
                for (var n = 0; n < oldDocuments.length; n++) {
                    if (!((document.id != null && document.id == oldDocuments[n].id)
                          || (document._creationIndex != null && document._creationIndex == oldDocuments[n]._creationIndex))) {

                              newDocuments.push(oldDocuments[n]);
                          }
                }
                
                if (newDocuments.length > 0) {
                    this.keyToDocumentNumberToDocuments[key][documentKey] = newDocuments;   
                } else {
                    delete this.keyToDocumentNumberToDocuments[key][documentKey];
                }
                
                var remainingForKey = 0;
                for (var documentNumber in this.keyToDocumentNumberToDocuments[key]) {
                    remainingForKey++;
                }
                if (remainingForKey == 0) {
                    delete this.keyToDocumentNumberToDocuments[key];
                }
                
                this.updateDocumentNumberFeedback();
                
                if (log.isDebugEnabled()) {
                    log.debug("After calling deregisterInDocumentNumberMap", key, document, this.keyToDocumentNumberToDocuments);
                }                       
                
                return newDocuments.length < oldDocuments.length; 
            }
        },   
        
        updateWidgetState : function() {
            var valid = true;
            var holidayError = false;

            if (this.unreleased) {
                for (var rowId in this.dndInfo.rowIdToHolidayError) {
                    holidayError |= this.dndInfo.rowIdToHolidayError[rowId];
                    //                              valid &= !this.dndInfo.rowIdToHolidayError[rowId];
                }                       
            } 
            
            if (this.editing) {
                for (var rowId in this.dndInfo.rowIdToEditors) {
                    var editor = this.dndInfo.rowIdToEditors[rowId].documentNumberEditor;
                    
                    if (editor) {
                        var hasDocumentNumberError = editor.hasDocumentNumberError();                           
                        valid &= !hasDocumentNumberError;
                    }
                }    
                for (var rowId in this.dndInfo.rowIdToHolidayError)
                valid &= !this.dndInfo.rowIdToHolidayError[rowId];
                
            }
            
            var hint = (!valid || (this.unreleased && holidayError) ? this.calculateHint() : null);
            
            if (this.allFieldsValid != valid || this.hint != hint) {
                this.allFieldsValid = valid;
                this.hint = hint;
                on.emit(this, "validStateChange");
            }
        },
        
        isValid : function() {
            return this.allFieldsValid;
        },
        
        calculateHint : function() {
            if (this.editing) {
                for (var rowId in this.dndInfo.rowIdToEditors) {
                    var editor = this.dndInfo.rowIdToEditors[rowId].documentNumberEditor;
                    
                    if (editor) {
                        if (editor.hasDocumentNumberError()) {
                            var joinDto = this.store.getSync(rowId);
                            var message = string.substitute(i18n.planDeliverDocumentNumberError, {
                                 documentName : CodeHelper.getDocumentName(joinDto._documentNameRowObject.value),//joinDto.documentName,
                                detailMessage : editor.getDocumentNumberErrorMessage()   
                            });
                            return message;
                        }                       
                    }
                }
                for (var rowId in this.dndInfo.rowIdToHolidayMessage) {
                    if (this.dndInfo.rowIdToHolidayMessage[rowId]) {
                        return this.dndInfo.rowIdToHolidayMessage[rowId];
                    }
                }
            }
            return null;
        },
        
        getHint : function() {
            return this.hint;
        },
        
        updateDocumentNumberFeedback : function() {
            var project = this.applicationContext.getPageContextProject();
            var network = this.applicationContext.getPageContextNetwork();
            var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
            var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);             
            
            for (var rowId in this.dndInfo.rowIdToEditors) {
                var editor = this.dndInfo.rowIdToEditors[rowId].documentNumberEditor;
                
                if (editor) {
                    var hasDocumentNumberError = editor.hasDocumentNumberError();
                    
                    var documentNumberInfo = editor.get("value").value;
                    
                    var key = null;
                    if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT) { 
                        key = documentNumberInfo.objectId;
                    } else if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT_PLANNER) {
                        key = documentNumberInfo.objectPlannerId;
                    }                       
                    
                    if (key in this.keyToDocumentNumberToDocuments) {
                        // documentNumberInfo is supposed to contain the document attributes we need here (e.g. number, depends on the concept of uniqueness 
                        // as defined by the documentNumberParts).  It contains more attributes not being part of document, which is no harm for us here.
                        var document = documentNumberInfo; 
                        var projectParticipation = JoinHelper.getJoinDtoComponent(documentNumberInfo, "projectParticipation");
                        var documentKey = CodeHelper.getUniqueKeyForDocument(document, documentNumberParts, idToDocumentType, projectParticipation);                                    
                        
                        var documentNumberToDocuments = this.keyToDocumentNumberToDocuments[key];
                        if (documentKey in documentNumberToDocuments) {
                            var documents = documentNumberToDocuments[documentKey];
                            
                            if (documents != null && documents.length > 1) {
                                if (!hasDocumentNumberError) {
                                    var message = string.substitute(i18n.planDeliverNewNotUniqueNumberError, {
                                        freeNumber : this.getFirstUnusedDocumentNumber({
                                                             key : key, 
                                                        document : documents[0], 
                                            projectParticipation : projectParticipation,
                                             documentNumberParts : documentNumberParts,
                                                idToDocumentType : idToDocumentType,
                                                       minNumber : null
                                        })
                                    });
                                    
                                    editor.setDocumentNumberError(message);                                 
                                }
                            } else if (hasDocumentNumberError) {
                                editor.dropDocumentNumberError();
                            }                                       
                        } else {
                            editor.dropDocumentNumberError();
                        }                               
                    } else {
                        editor.dropDocumentNumberError();
                    }                               
                }
            }
        },      
        
        getFirstUnusedDocumentNumber : function(params) {
            var key = params.key;
            var document = params.document; 
            var projectParticipation = params.projectParticipation;
            var documentNumberParts = params.documentNumberParts;
            var idToDocumentType = params.idToDocumentType;
            var minNumber = params.minNumber;
            
            // Document number 0 seems to be forbidden
            var n = (minNumber == null ? 1 : minNumber);
            if (key in this.keyToDocumentNumberToDocuments) {
                while (true) {
                    var candidateDocument = DataHelper.clone(document);
                    candidateDocument.number = n;
                    var candidateKey = CodeHelper.getUniqueKeyForDocument(candidateDocument, documentNumberParts, idToDocumentType, projectParticipation);
                    
                    if (candidateKey in this.keyToDocumentNumberToDocuments[key] 
                        && (this.keyToDocumentNumberToDocuments[key][candidateKey].length > 1 || this.keyToDocumentNumberToDocuments[key][candidateKey][0] != document)) {
                            n++;    
                        } else {
                            break;
                        }                               
                }                       
            }
            
            return n;
        },        
        
        migrateDates : function() {
            var holidayCalculator = this.applicationContext.getHolidayCalculator();
            
            for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
                var joinDto = this.planDeliverJoinDtos[n];
                
                var oldStart = joinDto._documentStartDateRowObject.value;
                var oldEnd = joinDto._documentEndDateRowObject.value;
                var oldDuration = joinDto.documentDuration;
                
                var newDuration = joinDto.reviewCycleInstanceDuration;
                var newStart = null;
                var newEnd = null;
                
                //if no date can be changed or last document_version is released no change of date is allowed
                if (!this.canEditDatesAtAll(joinDto)) {
                    newStart = oldStart;
                    newEnd = oldEnd;
                    //most common case, only endDate can be edited
                } else if (this.canEditOnlyEndDate(joinDto)) {
                    if (oldEnd != null) {
                        newStart = holidayCalculator.addWorkingDays(oldEnd, -newDuration);
                        newEnd = oldEnd;
                    } else if (oldStart != null){
                        newStart = oldStart;
                        newEnd = holidayCalculator.addWorkingDays(oldStart, newDuration);
                    }
                    // startDate or both dates can be edited
                } else {
                    if (oldStart != null){
                        newStart = oldStart;
                        newEnd = holidayCalculator.addWorkingDays(oldStart, newDuration);
                    } else if (oldEnd != null) {
                        newStart = holidayCalculator.addWorkingDays(oldEnd, -newDuration);
                        newEnd = oldEnd;                                        
                    }
                }
                
                joinDto._documentStartDateRowObject = {
                       value : newStart,
                       rowId : joinDto.documentId,
                    toString : PlanDeliverHelper.startDateToString  // Delibarately without lang.hitch
                    
                };
                joinDto._documentEndDateRowObject = {
                       value : newEnd,
                       rowId : joinDto.documentId,
                    toString : PlanDeliverHelper.endDateToString
                };                      
                
                joinDto.documentDuration = newDuration;
            }
        },
        
        abortEditing : function(doRestoreOriginalJoinDtos) {
            this.editing = false;
            /*
            if (doRestoreOriginalJoinDtos) {
            this.restoreOriginalJoinDtos();
        }
            */
            this.updateAuxiliaryData(true);
            
            this.grid.revert();
            
            this.updateWidgetState();
        },
        
        restoreOriginalJoinDtos : function() {
            this.planDeliverJoinDtos = this.originalJoinDtos;
            this.store.setData(this.planDeliverJoinDtos);
        },
        
        getPlanDeliverJoinDtosForSave : function() {
            this.updateDataFromWidgets();
            //this.grid.save();
            
            var documentsToSave = SaveLoadHelper.convertDtosForSave({
                               dtos : this.planDeliverJoinDtos, 
                  dndCellAttributes : ["_documentStartDateRowObject", "_documentEndDateRowObject",
                                       "_documentScaleRowObject", "_documentCommentRowObject"],
                fancyDateAttributes : ["_documentStartDateRowObject", "_documentEndDateRowObject"],
                  attributeMappings : {"_documentStartDateRowObject" : "documentStartDate",
                      "_documentEndDateRowObject" : "documentEndDate",
                      "_documentScaleRowObject" : "documentScale",
                      "_documentCommentRowObject" : "documentComment"}
            });
            
            for (var n = 0; n < documentsToSave.length; n++) {
                /*
                var documentToSave = documentsToSave[n];
                var rowObject = documentToSave._documentContentRowObject;
                var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                if (this.contentLocales != null) {
	                var newDocumentContent = I18nHelper.updateCurrentLocaleString(documentToSave.documentContent,
	                rowObject.value, locale);
	                documentToSave.documentContent = newDocumentContent;
	            } else {
	
	            }
	            */
                var documentToSave = documentsToSave[n];
                var rowObject = documentToSave._documentContentRowObject;
                documentToSave.documentContent = rowObject.value;
            }

            return documentsToSave;
        },
        
        updateDataFromWidgets : function(columns) {
            if (columns == null) {
                columns = {
                       documentName : true,
                    documentContent : true,
                      documentScale : true,
                    documentEndDate : true,
                    documentComment : true
                };
            }
            
            var editors = this.dndInfo.rowIdToEditors[rowId];
            
            var documentNumberParts = CodeHelper.getDocumentNumberParts(this.applicationContext);
            
            for (var rowId in this.dndInfo.rowIdToEditors) {
                var joinDto = this.store.getSync(rowId);
                var editors = this.dndInfo.rowIdToEditors[rowId];
                
                if (columns.documentName && editors.documentNumberEditor) {
                    var value = editors.documentNumberEditor.get("value");
                    joinDto._documentNameRowObject = value;
                    var documentNumberInfo = value.value;
                    documentNumberInfo._clientCalculatedName = CodeHelper.getDocumentName(documentNumberInfo);                              
                    
                    joinDto.documentNumber = documentNumberInfo.number;
					joinDto.documentPart = documentNumberInfo.part;
                    joinDto.documentDocumentTypeId = documentNumberInfo.documentTypeId;
                    DocumentNumberEditor.extractEditorInfoFromJoinDto(this.applicationContext, documentNumberParts, joinDto);
                }                       
                
                if (columns.documentContent && editors.contentTextArea && editors.contentTextArea.textArea && editors.contentTextArea.textArea.domNode) {
                    var contentRowObject = editors.contentTextArea.get("value");
                    joinDto._documentContentRowObject = contentRowObject;
                }
                if (columns.documentScale && editors.scaleTextArea && editors.scaleTextArea.textArea && editors.scaleTextArea.textArea.domNode) {
                    joinDto._documentScaleRowObject = editors.scaleTextArea.get("value");
                }
                
                var endDateCorrected = false;
                if (columns.documentStartDate && editors.startDateCalendarSpinner && editors.startDateCalendarSpinner.dateTimeSpinBox 
                    && editors.startDateCalendarSpinner.dateTimeSpinBox.domNode) {
                    joinDto._documentStartDateRowObject = editors.startDateCalendarSpinner.get("value");

                    if (joinDto._documentStartDateRowObject.value != null) {
                        var holidayCalculator = this.applicationContext.getHolidayCalculator();
                        if (this.unreleased) {
                            this.dndInfo.rowIdToHolidayError[rowId] = holidayCalculator.isWeekendOrHoliday(joinDto._documentStartDateRowObject.value) && this.hasNoReleasedLastVersion(joinDto);
                            if (this.dndInfo.rowIdToHolidayError[rowId]) {
                                domClass.add(editors.startDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                            } else {
                                domClass.remove(editors.startDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                                domClass.remove(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                            }
                        }                                       
                    } 
                    
                    if (this.hasNoReleasedLastVersion(joinDto)) {
                        joinDto._documentEndDateRowObject = this.getEndDateByStartDate(joinDto._documentStartDateRowObject != null ? joinDto._documentStartDateRowObject.value : null, joinDto.reviewCycleInstanceDuration, rowId);
                        endDateCorrected = true;
                    }
                } 
                
                if (columns.documentEndDate && editors.endDateCalendarSpinner && editors.endDateCalendarSpinner.dateTimeSpinBox 
                    && editors.endDateCalendarSpinner.dateTimeSpinBox.domNode) {
                    joinDto._documentEndDateRowObject = editors.endDateCalendarSpinner.get("value");

                    if (joinDto._documentEndDateRowObject.value != null) {
                        var holidayCalculator = this.applicationContext.getHolidayCalculator();
                        if (this.unreleased) {
                            this.dndInfo.rowIdToHolidayError[rowId] = holidayCalculator.isWeekendOrHoliday(joinDto._documentEndDateRowObject.value) && this.hasNoReleasedLastVersion(joinDto);
                            if (this.dndInfo.rowIdToHolidayError[rowId]) {
                                domClass.add(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                            } else {
                                domClass.remove(editors.startDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                                domClass.remove(editors.endDateCalendarSpinner.dateTimeSpinBox.textbox, "errorField");
                            }
                        }                                       
                    } 
                    
                    if (this.hasNoReleasedLastVersion(joinDto) && !endDateCorrected) {
                        joinDto._documentStartDateRowObject = this.getStartDateByEndDate(joinDto._documentEndDateRowObject != null ? joinDto._documentEndDateRowObject.value : null, joinDto.reviewCycleInstanceDuration, rowId);
                    }
                }
                if (columns.documentComment && editors.commentTextArea && editors.commentTextArea.textArea && editors.commentTextArea.textArea.domNode) {
                    joinDto._documentCommentRowObject = editors.commentTextArea.get("value");
                }
            }
        },
        
        mergeSaveResult : function(saveResult) {
            
            var documentIdToJoinDto = DataHelper.getAsMap(this.planDeliverJoinDtos, "documentId");
            
            for (var n = 0; n < saveResult.updatedDocuments.length; n++) {
                var documentId = saveResult.updatedDocuments[n].id;
                var joinDto = documentIdToJoinDto[documentId];
                JoinHelper.setJoinDtoComponent(joinDto, saveResult.updatedDocuments[n], "document");
            }
            
            for (var n = 0; n < saveResult.savedHistoryParts.length; n++) {
                var historyPart = saveResult.savedHistoryParts[n];                      
                DataHelper.appendIntoMultiMap(this.documentIdToHistoryItems, historyPart.documentDateHistoryPartDocumentId, historyPart);
            }
            
            this.store.setData(this.planDeliverJoinDtos);
            this.backupOriginalJoinDtos();
            this.grid.revert();
        },
        
        /***************************************** Filter *******************************************/
        
        filter : function(searchString) {

            // Don´t filter too often.  If filtering starts while one is typing, and the list is big,
            // then the textbox freezes while one types until filtering has finished.
            if (this.filterHandle) {
                window.clearInterval(this.filterHandle);
                delete this.filterHandle;
            }
            
            this.filterHandle = window.setInterval(lang.hitch(this, function() {
                this.startFilterUtcMillis = (new Date()).getTime();
                
                var searchStrings = StringHelper.isEmpty(searchString) ? [] : searchString.split(",");
                var trimmedSearchStrings = [];
                for (var n = 0; n < searchStrings.length; n++) {
                    if (searchStrings[n] && searchStrings[n].trim().length > 0) {
                        trimmedSearchStrings.push(searchStrings[n].trim().toLowerCase());
                    }
                }
                
                var middleMillis = (new Date()).getTime();
                
                var newNumberOfFound = 0;
                
                var rowIdToFound = new Object();
                var filteredDtos = [];
                for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
                    var rowId = this.planDeliverJoinDtos[n].documentId;
                    var row = this.grid.row(rowId);

                    if (log.isDebugEnabled()) {
                        log.debug("Check: rowId = " + rowId + ", documentName = " + (row.data && row.data.documentName ? row.data.documentName : "---"), row);  
                    }                               
                    
                    rowIdToFound[rowId] = this.filterRow(this.planDeliverJoinDtos[n], row.element, trimmedSearchStrings);
                    if (rowIdToFound[rowId]) {
                        newNumberOfFound++;
                        filteredDtos.push(this.planDeliverJoinDtos[n]);
                    }
                }
                
                if (this.lastNumberOfFound != newNumberOfFound) {
                    this.lastNumberOfFound = newNumberOfFound;
                    
                    // The OnDemandGrid doesn´t add all rows to the grid, if its data contain too many of them.
                    // This can lead to the situation that filter makes nearly all rows invisible, but the 
                    // rows that match the filter aren´t visible still, because making a non-existing row visible
                    // doesn´t work that good.
                    // Thus: Solve that problem by exchanging the contents of the grid.
                    this.store.setData(filteredDtos);       
                    this.grid.refresh();
                    
                    /*
                    for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
                    var rowId = this.planDeliverJoinDtos[n].documentId;
                    var row = this.grid.row(rowId);
                    if (row.element) {
                    if (rowIdToFound[rowId]) {
                    domClass.remove(row.element, "hiddenRow");
                } else {
                    domClass.add(row.element, "hiddenRow");
                }
                }
                }
                    */
                }
                
                var endMillis = (new Date()).getTime();
                
                if (log.isDebugEnabled()) {
                    log.debug("Finished filtering after " + (endMillis - this.startFilterUtcMillis) + "ms");        
                }                               
                
                window.clearInterval(this.filterHandle);
                delete this.filterHandle;
            }), 0);                 
        },
        
        filterRow : function(joinDto, rowNode, searchStrings) {
            if (searchStrings.length == 0) {
                //domClass.remove(rowNode, "hiddenRow");
                return true;
            } else {
                var tokens = [];
                
                if (this.columnSettings.showPlannerPerson && this.columnSettings.showPlannerOrganisation) {
                    tokens.push(this.plannerFormatter(null, joinDto));
                }
                if (this.columnSettings.showObjectNumber && this.columnSettings.showObjectName) {
                    tokens.push(this.objectFormatter(null, joinDto));
                }
                if (this.columnSettings.showObjectPlannerCode && this.columnSettings.showObjectPlannerName) {
                    tokens.push(this.objectPlannerFormatter(null, joinDto));
                }
                if (this.columnSettings.showDocumentNumber) {  // No bug, just the number is stored in field "name", and the name in "content"...
                    tokens.push(joinDto.documentName);      
                }
                if (this.columnSettings.showDocumentName) {
                    tokens.push(joinDto.documentContent);   
                }
                if (this.columnSettings.showScale) {
                    tokens.push(joinDto.documentScale);                             
                }
                if (this.columnSettings.showStart) {
                    tokens.push(joinDto.startDateFormatted);
                }
                if (this.columnSettings.showEnd) {
                    tokens.push(joinDto.endDateFormatted);
                }
                if (this.columnSettings.showPeriod) {
                    tokens.push(joinDto.documentDuration);
                }
                if (this.columnSettings.showComment) {
                    tokens.push(joinDto.documentComment);
                }
                
                var allFound = true;

                for (var z = 0; z < searchStrings.length; z++) {
                    
                    var found = false;
                    for (var n = 0; n < tokens.length; n++) {
                        if (tokens[n] != null) {
                            if (!(typeof tokens[n] == "string")) {
                                tokens[n] = tokens[n].toString();
                            }       
                            
                            tokens[n] = tokens[n].toLowerCase();
                            if (tokens[n].indexOf(searchStrings[z]) != -1) {
                                found = true;
                                break;
                            }                                               
                        }                                       
                    }
                    
                    if (!found) {
                        allFound = false;
                        break;
                    }
                }
                /*
                if (rowNode) {
                if (allFound) {
                domClass.remove(rowNode, "hiddenRow");
            } else {
                domClass.add(rowNode, "hiddenRow");
            }                                       
            }
                */
                return allFound;
            }
        },
        
        /****************************************** CanEdit ******************************************/
        
        canEditDocumentName : function(joinDto) {
            var actionSet = (joinDto.objectPlannerId in this.objectPlannerIdToActions ? this.objectPlannerIdToActions[joinDto.objectPlannerId] : new Object());
            // in case of superAdminRight, you can edit number or documentType even if hasDocumentVersions is true
            return this.editing && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogue")
            && (!joinDto.documentHasDocumentVersions || "superAdminRight" in actionSet);
        },
        
        canEditDocumentContent : function(joinDto) {
            return this.editing && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogue");
        },
        
        canEditDocumentScale : function(joinDto) {
            return this.editing && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogue");
        },
        
        canEditDocumentComment : function(joinDto) {
            return this.editing && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogue");
        },  
        
        hasNoReleasedLastVersion : function(joinDto) {
            return (   (joinDto.reactivatedVersionId != null && joinDto.reactivatedVersionStatus != CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV)
                    || (joinDto.reactivatedVersionId == null && joinDto.lastVersionId != null && joinDto.lastVersionStatus != CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV)
                    || (joinDto.reactivatedVersionId == null && joinDto.lastVersionId == null));                    
        },
        
        canEditStartDate : function(joinDto) {
            return this.editing
            && this.hasNoReleasedLastVersion(joinDto)
            && (   ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogueDates")
                || ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogueStartDate")
                || this.applicationContext.isActionAllowedForProject("editPlanDeliverCatalogueDatesProjCont"));             
        },
        
        canEditEndDate : function(joinDto) {
            return this.editing
            && this.hasNoReleasedLastVersion(joinDto)
            && (   ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogueDates")
                || ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogueEndDate")
                || this.applicationContext.isActionAllowedForProject("editPlanDeliverCatalogueDatesProjCont"));
        },
        
        canEditOnlyStartDate : function(joinDto) {
            return this.editing
            && this.hasNoReleasedLastVersion(joinDto)
            && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogueStartDate");                
        },
        
        canEditOnlyEndDate : function(joinDto) {
            return this.editing
            && this.hasNoReleasedLastVersion(joinDto)
            && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogueEndDate");                  
        },
        
        canEditDatesAtAll : function(joinDto) {
            return this.editing
            && (this.canEditEndDate(joinDto) || this.canEditStartDate(joinDto));                    
        },
        
        /**************************************** Formatters *****************************************/
        
        plannerFormatter : function(projectParticipationId, planDeliverJoinDto) {
            if (this.columnSettings.showPlannerPerson && this.columnSettings.showPlannerOrganisation) {
                return string.substitute(i18n.planDeliverPlannerString, {
                    organisation : planDeliverJoinDto.organisationName != null ? planDeliverJoinDto.organisationName : "",
                          person : NameHelper.getPersonCommonName(planDeliverJoinDto, "person")
                });                             
            } else if (this.columnSettings.showPlannerPerson) {
                return NameHelper.getPersonCommonName(planDeliverJoinDto, "person");
            } else if (this.columnSettings.showPlannerOrganisation) {
                return planDeliverJoinDto.organisationName;
            } else {
                return "";
            }               
        },
        
        documentNumberGetter : function(dto) {
            return {
                value : dto._documentNumberInfo,
                rowId : dto.documentId
            };
        },      
        
        documentNameFormatter : function(documentNumberRowObject, joinDto) {
            if (this.canEditDocumentName(joinDto)) {
                return joinDto._documentNumberInfo;
            } else {
                return joinDto.documentName;
            }
        },
        
        contentGetter : function(joinDto) {
            return {
                value : joinDto.documentContent,
                rowId : joinDto.documentId
            };
        },


        renderContent : function(joinDto, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            
            if (this.canEditDocumentContent(joinDto)) {
                return cellDiv;
            } else if (this.contentLocales != null) {
                var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                var localeToTranslation = I18nHelper.getLocaleMap(data.value, locale);
                for (var n = 0; n < this.contentLocales.length; n++) {
                    var contentLocale = this.contentLocales[n];
                    var translation = localeToTranslation[contentLocale];
                    if (translation != null && translation.length > 0) {
                        DOMHelper.createTextNode("div", translation, cellDiv, "");                    
                    }
                }
                return cellDiv;
            } else {
                var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                var localeToTranslation = I18nHelper.getLocaleMap(data.value, locale);
                var translation = localeToTranslation[locale];

                DOMHelper.createTextNode("div", translation, cellDiv, "");
                return cellDiv;
            }
        },
        
        scaleGetter : function(joinDto) {
            return {
                value : joinDto.documentScale,
                rowId : joinDto.documentId
            };
        },
        
        scaleFormatter : function(scaleRowObject, joinDto) {
            if (this.canEditDocumentScale(joinDto)) {
                return scaleRowObject;
            } else {
                return scaleRowObject.value;
            }
        },      
        
        commentGetter : function(joinDto) {
            return {
                value : joinDto.documentComment,
                rowId : joinDto.documentId
            };
        },
        
        commentFormatter : function(commentRowObject, joinDto) {
            if (this.canEditDocumentComment(joinDto)) {
                return commentRowObject;
            } else {
                return commentRowObject.value;
            }
        },      
        
        objectFormatter : function(objectId, planDeliverJoinDto) {
            if (this.columnSettings.showObjectNumber && this.columnSettings.showObjectName) {
                var objectCode = CodeHelper.getObjectCodeFromCodes(planDeliverJoinDto.objectReleaseCode, planDeliverJoinDto.objectTypeCode);
                return objectCode + " - " + planDeliverJoinDto.objectReleaseName;
            } else if (this.columnSettings.showObjectNumber) {
                return CodeHelper.getObjectCodeFromCodes(joinDto.objectReleaseCode, joinDto.objectTypeCode);
            } else if (this.columnSettings.showObjectName) {
                return planDeliverJoinDto.objectReleaseName;
            } else {
                return "";
            }
        },
        
        objectPlannerFormatter : function(objectPlannerId, planDeliverJoinDto) {
            if (this.columnSettings.showObjectPlannerCode && this.columnSettings.showObjectPlannerName) {
                return planDeliverJoinDto.objectPlannerReleaseCode + " - " + planDeliverJoinDto.objectPlannerReleaseArea;
            } else if (this.columnSettings.showObjectPlannerCode) {
                return planDeliverJoinDto.objectPlannerReleaseCode;
            } else if (this.columnSettings.showObjectPlannerName) {
                return planDeliverJoinDto.objectPlannerReleaseArea;
            } else {
                return "";
            }
        },
        
        // TODO startDateFormatter and endDateFormatter are probably not needed any longer, thanks to startDateRowObject and endDateRowObject
        startDateFormatter : function(startDateRowObject, joinDto) {
            if (this.canEditStartDate(joinDto)) {
                return joinDto.startDateRowObject;
            } else {
                return joinDto.startDateFormatted;
            }
            /*
            if (joinDto.documentStartDate != null) {
            return { value : joinDto.documentStartDate,
            rowId : joinDto.documentId
        };
        } else {
            return {
            value : null,
            rowId : joinDto.documentId
        };
        }                       
        } else {
            return joinDto.startDateFormatted;
        }*/
        },
        
        endDateFormatter : function(endDateRowObject, joinDto) {
            if (this.canEditEndDate(joinDto)) {
                return joinDto.endDateRowObject;
            } else {
                return joinDto.endDateFormatted;
            }
            /*
            if (joinDto.documentEndDate != null) {
            return { value : new FancyDate({utcSeconds : joinDto.documentEndDate, timeZone : this.applicationContext.getTimeZone() }),
            rowId : joinDto.documentId
        };      
        } else {
            return { value : null,
            rowId : joinDto.documentId 
        };
        }                       
        } else {
            return joinDto.endDateFormatted;
        }*/
        },
        
        calculateStartDateStrings : function(joinDto) {
            var timeZone = this.applicationContext.getTimeZone();
            
            var startDate = joinDto._documentStartDateRowObject.value;
            joinDto.startDateString = startDate ? DateHelper.formatDate(startDate, i18n.datePattern) : null;

            var realStartDateString;
            if (joinDto.firstVersionId != null) {
                var versionPartA = joinDto.firstVersionVersionParta;
                var versionSeparator = joinDto.firstVersionVersionPartSeperator;
                var versionPartB = joinDto.firstVersionVersionPartb;
                var firstVersionDateString = DateHelper.formatUtcSecondsWithTimeZone(joinDto.firstVersionUploaded, timeZone, i18n.datePattern);
                
                joinDto.realStartDateString = string.substitute(i18n.planDeliverVersionString, {
                        versionPartA : versionPartA ? versionPartA : "",
                    versionSeparator : versionSeparator ? versionSeparator : "",
                        versionPartB : versionPartB ? versionPartB : "",
                          dateString : firstVersionDateString
                });
            } else {
                joinDto.realStartDateString = null;
            }
            
            if (joinDto.startDateString && joinDto.realStartDateString) {
                joinDto.startDateFormatted = joinDto.startDateString + "<br>" + joinDto.realStartDateString;
            } else if (joinDto.startDateString) {
                joinDto.startDateFormatted = joinDto.startDateString;
            } else if (joinDto.realStartDateString) {
                joinDto.startDateFormatted = joinDto.realStartDateString;
            } else {
                joinDto.startDateFormatted = "";
            }
        },
        
        calculateEndDateStrings : function(joinDto) {
            var timeZone = this.applicationContext.getTimeZone();
            
            var endDate = joinDto._documentEndDateRowObject.value;
            joinDto.endDateString = endDate ? DateHelper.formatDate(endDate, i18n.datePattern) : null;
            
            // lastVersion sometimes delegates to lastVersion.reactivatedVersion.
            // To avoid solving this in the Join, we always fetch both (if available).  If reactivatedVersion is available, it takes precedence.
            var lastVersionPrefix;
            if (joinDto.reactivatedVersionId != null) {
                lastVersionPrefix = "reactivatedVersion";
            } else if (joinDto.lastVersionId != null) {
                lastVersionPrefix = "lastVersion";
            } else {
                lastVersionPrefix = null;
            }

            joinDto.realEndDateString = null;
            if (lastVersionPrefix != null) {
                var versionPartA = joinDto[lastVersionPrefix + "VersionParta"];
                var versionSeparator = joinDto[lastVersionPrefix + "VersionPartSeperator"];
                var versionPartB = joinDto[lastVersionPrefix + "VersionPartb"];
                
                var realEndDate = null;
                if (joinDto.nodeResultId != null) {
                    if (joinDto.positionResultId == null) {
                        realEndDate = joinDto.nodeResultArrivalDate
                    } else {
                        realEndDate = joinDto.positionResultResultDate;
                    }
                }
                var realEndDateAsString = realEndDate != null ? DateHelper.formatUtcSecondsWithTimeZone(realEndDate, timeZone, i18n.datePattern) : "";
                joinDto.realEndDateString = string.substitute(i18n.planDeliverVersionString, {
                        versionPartA : versionPartA ? versionPartA : "",
                    versionSeparator : versionSeparator ? versionSeparator : "",
                        versionPartB : versionPartB ? versionPartB : "",
                          dateString : realEndDateAsString
                });
            } else {
                joinDto.realEndDateString = null;
            }
            
            if (joinDto.endDateString && joinDto.realEndDateString) {
                joinDto.endDateFormatted = joinDto.endDateString + "<br>" + joinDto.realEndDateString;
            } else if (joinDto.endDateString) {
                joinDto.endDateFormatted = joinDto.endDateString;
            } else if (joinDto.realEndDateString) {
                joinDto.endDateFormatted = joinDto.realEndDateString;
            } else {
                joinDto.endDateFormatted = "";
            }
        },
        
        renderActionCell : function(joinDto, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);
            
            if (!this.editing && this.applicationContext.isActionAllowedForProject("showObjectPlanner")) {
                var showObjectPlannerButton = this.constructShowObjectPlannerButton(joinDto, "showObjectPlanner");
                domConstruct.place(showObjectPlannerButton.domNode, buttonDiv);
            } else if (!this.editing && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "showObjectPlannerOPContext")) {
                var showObjectPlannerButton = this.constructShowObjectPlannerButton(joinDto, "showObjectPlannerOPContext");
                domConstruct.place(showObjectPlannerButton.domNode, buttonDiv);                         
            }
/*
            if (!this.editing && this.applicationContext.isActionAllowedForProject("showObjectPlanner")) {
                var showObjectPlannerButton = this.constructShowObjectPlannerButtonOld(joinDto, "showObjectPlanner");
                domConstruct.place(showObjectPlannerButton.domNode, buttonDiv);
            } else if (!this.editing && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "showObjectPlannerOPContext")) {
                var showObjectPlannerButton = this.constructShowObjectPlannerButtonOld(joinDto, "showObjectPlannerOPContext");
                domConstruct.place(showObjectPlannerButton.domNode, buttonDiv);                         
            }            
*/            
            if (this.unreleased || this.editing) {
                var dateHistoryButton = this.constructDateHistoryButton(joinDto);
                domConstruct.place(dateHistoryButton.domNode, buttonDiv);                       
            }
            
            // Condition for delete button.  Note: If released documents exist, the server call lateron invalidates the document, but doesn´t delete it.
            // We don´t need to care here about that difference.
            if (this.editing && !joinDto.documentHasDocumentVersions
                && this.numberOfObjectListReleases > 0
                && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogue")) {
                    var deleteButton = this.constructDeleteButton(joinDto);
                    domConstruct.place(deleteButton.domNode, buttonDiv);
                }
            
            // TODO condition
            var actionSet = (joinDto.objectPlannerId in this.objectPlannerIdToActions ? this.objectPlannerIdToActions[joinDto.objectPlannerId] : new Object());

            //also check if joinDto.documentDocumentListId equals actualReleasedDocumentId or if unreleased
            if (joinDto.derivedInfoOwnObjectPlanner  && (this.unreleased || this.actualReleased)
                && (((!joinDto.documentHasDocumentVersions) || joinDto.derivedInfoLastVersionDeleted) && !joinDto.derivedInfoLastVersionStatusU)
                && ("uploadDocument" in actionSet)) {  // TODO further conditions as of UnreleasedPlanDeliverCatalogueOverview.page, component hasnoDocVersions
                    var uploadButton = this.constructUploadButton(joinDto);
                    domConstruct.place(uploadButton.domNode, buttonDiv);
            }
            
            return buttonDiv;
        },
        
        constructShowObjectPlannerButton : function(joinDto, actionName) {
            return new DisableButton({
                           label : i18n.planDeliverListShowObjectPlannerButtonLabel,
                       showLabel : false,
                           title : i18n.planDeliverListShowObjectPlannerButtonToolTip,
                         onClick : lang.hitch(this, function() {
                             this.doShowObjectPlanner(joinDto, actionName);
                         }),
                       iconClass : "showObjectPlanner",
                "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });             
        },
/*
        constructShowObjectPlannerButtonOld : function(joinDto, actionName) {
            return new DisableButton({
                           label : i18n.planDeliverListShowObjectPlannerButtonLabel,
                       showLabel : false,
                           title : i18n.planDeliverListShowObjectPlannerButtonToolTip,
                         onClick : lang.hitch(this, function() {
                             this.doShowObjectPlannerOld(joinDto, actionName);
                         }),
                       iconClass : "showObjectPlanner",
                "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });             
        },        
*/        
        doShowObjectPlanner : function(joinDto, actionName) {
            window.parent.postMessage({
                action : "routerPush",
                routerObj : {
                    name : "objectPlannerReleaseShowDocument",
                    params : {
                        documentId : joinDto.documentId
                    }
                }
            });
            /*
            window.parent.postMessage({
                action : "routerPush",
                routerObj : {
                    name : "objectPlannerReleaseShow",
                    params : {
                        objectId : joinDto.objectId,
                        version : "v" + joinDto.objectListReleaseVersion,
                        objectPlannerReleaseId : joinDto.objectPlannerReleaseId
                    }
                }
            });*/
        },
/* 
        doShowObjectPlannerOld : function(joinDto, actionName) {
Commented out until final release, to have a comparison with old code
            window.parent.postMessage({
                action : "routerPush",
                routerObj : {
                    name : "objectPlannerReleaseShow",
                    params : {
                        objectId : joinDto.objectId,
                        version : "v" + joinDto.objectListReleaseVersion,
                        objectPlannerReleaseId : joinDto.objectPlannerReleaseId
                    }
                }
            });
            document.location.href = "/cdes/app?service=SecureDirectService/1/PlanDeliverCatalogueOverview/" + actionName + "/openObjectPlanner&sp=" 
                                   + joinDto.objectPlannerReleaseId + "&ts=" + dojoConfig.tabSessionId;
        },
*/            
        
        constructDateHistoryButton : function(joinDto) {
            return new DisableButton({
                           label : i18n.planDeliverListDateHistoryButtonLabel,
                       showLabel : false,
                           title : i18n.planDeliverListDateHistoryButtonToolTip,
                         onClick : lang.hitch(this, function() {
                             this.doShowDateHistory(joinDto);
                         }),
                       iconClass : "infoIcon",
                "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });             
        },
        
        doShowDateHistory : function(joinDto) {
            var documentDateHistoryWidget = new DocumentDateHistoryWidget({
                applicationContext : this.applicationContext
            });
            
            var historyItems = joinDto.documentId in this.documentIdToHistoryItems ? this.documentIdToHistoryItems[joinDto.documentId] : [];
            
            documentDateHistoryWidget.setData(historyItems);
            
            var caption = string.substitute(i18n.planDeliverListDateHistoryDialogCaption, {
                document : joinDto.documentName
            });
            
            var dateHistoryDialog = new InfoDialog({
                        title : caption,
                      content : documentDateHistoryWidget.getContainer(),
                 defaultWidth : 500,
                defaultHeight : 210,
                      buttons : [ { type : InfoDialog.Button.CLOSE }
                      ]                                 
            });
            
            on(dateHistoryDialog, "hide", lang.hitch(this, function() {
                documentDateHistoryWidget.destroy();
            }));
            
            dateHistoryDialog.show();
        },
        
        constructDeleteButton : function(joinDto) {
            return new DisableButton({
                           label : i18n.planDeliverListDeleteButtonLabel,
                       showLabel : false,
                           title : i18n.planDeliverListDeleteButtonToolTip,
                         onClick : lang.hitch(this, function() {
                             this.deleteDocument(joinDto);
                         }),
                       iconClass : "deleteButton",
                "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },
        
        constructUploadButton : function(joinDto) {
            return new DisableButton({
                           label : i18n.planDeliverListUploadButtonLabel,
                       showLabel : false,
                           title : i18n.planDeliverListUploadButtonToolTip,
                         onClick : lang.hitch(this, function() {
                             this.uploadDocument(joinDto);
                         }),
                       iconClass : "uploadButton",
                "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });             
        },
        
        uploadDocument : function(joinDto) {
            var originWithoutPort = window.location.protocol + '//' + window.location.hostname;
            // something like originWithoutPort + ":xxxx"

            var msgObj = {
                action : "routerPush",
                page : "uploadFile",
                documentId : joinDto.documentId
            };

            window.parent.postMessage(msgObj, window.origin);
//            document.location.href = "/cdes/app?service=SecureDirectService/1/TasksOverview/tasksOverview/openTask&sp=123&sp=" + joinDto.documentId + "&ts=" + dojoConfig.tabSessionId;
        },
        
        deleteDocument : function(joinDto) {
            InfoDialog.showQuestion({
                  title : i18n.planDeliverListReallyDeleteDocumentCaption,
                message : string.substitute(i18n.planDeliverListReallyDeleteDocumentText, {
                    documentContent : joinDto.documentContent,
                     documentNumber : joinDto.documentName
                }),
                buttons : [
                           { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                               this.doDeleteDocument(joinDto);
                           })},                                    
                           { type : InfoDialog.Button.NO }
                ]
            });                     
        },
        
        doDeleteDocument : function(joinDto) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            
            
            var planDeliverService = this.applicationContext.getService("planDeliverService");
            
            this.registerAsyncOperationStarted(PlanDeliverListWidget.AsyncOperation.DELETE_DOCUMENT);
            planDeliverService.deleteDocument(organisationPersonId, joinDto.documentId).then(lang.hitch(this, function() {
                
                topic.publish("message/ok", string.substitute(i18n.planDeliverListDeleteDocumentOk, {
                       documentName : joinDto.documentName,
                    documentContent : joinDto.documentContent
                }));

                // Remove the deleted document from the grid, and update its contents without reloading data from the server
                // Note: As the query in JdbcDocumentDAO.getPlanDeliverJoinWhereClause excludes invalidated documents, we
                // remove the document from the list, regardless of the question wether the server call invalidated, or deleted
                // the document.
                var newJoinDtos = [];
                for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
                    if (this.planDeliverJoinDtos[n].documentId != joinDto.documentId) {
                        newJoinDtos.push(this.planDeliverJoinDtos[n]);
                    }
                }
                this.planDeliverJoinDtos = newJoinDtos;
                
                // Do the same with the original join dtos:
                var newOriginalJoinDtos = [];
                for (var n = 0; n < this.originalJoinDtos.length; n++) {
                    if (this.originalJoinDtos[n].documentId != joinDto.documentId) {
                        newOriginalJoinDtos.push(this.originalJoinDtos[n]);
                    }
                }
                this.originalJoinDtos = newOriginalJoinDtos;
                
                this.reload();
                
                on.emit(this, "validStateChange");
                
                this.registerAsyncOperationFinished(PlanDeliverListWidget.AsyncOperation.DELETE_DOCUMENT);
            }),
                lang.hitch(this, function(err) {    
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanDeliverListWidget.AsyncOperation.DELETE_DOCUMENT,
                                opName : "deleteDocument",
                               message : i18n.planDeliverListDeleteDocumentFailed
                    });                                     
                    this.registerAsyncOperationFinished(PlanDeliverListWidget.AsyncOperation.DELETE_DOCUMENT);
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of a call to getDocumentListReleaseVersions: ", err);
                }));                    
        },
        
        destroy : function() {
            this.inherited(arguments);

            // Remove columnHider CSS rules, to avoid that they get active again when such a grid is constructed again at a later time.
            for (id in this.columnHiderRules) {
                this.columnHiderRules[id].remove();
            }
        }
    });
    
    PlanDeliverListWidget.documentContentSetDataTopic = "planDeliver/documentContentSetData";
    PlanDeliverListWidget.documentScaleSetDataTopic = "planDeliver/documentScaleSetData";
    PlanDeliverListWidget.documentCommentSetDataTopic = "planDeliver/documentCommentSetData";
    
    PlanDeliverListWidget.documentNameSetDataTopic = "planDeliver/documentNameSetData";
    
    PlanDeliverListWidget.documentStartDateDnDStartTopic = "planDeliver/documentStartDatemDnDStart";
    PlanDeliverListWidget.documentStartDateDataTopic = "planDeliver/documentStartDateSetData";
    
    PlanDeliverListWidget.documentEndDateDnDStartTopic = "planDeliver/documentEndDateDnDStart";
    PlanDeliverListWidget.documentEndDateSetDataTopic = "planDeliver/documentEndDateSetData";
    
    PlanDeliverListWidget.AsyncOperation = {
        RELOAD : "Reload",
        DELETE_DOCUMENT : "DeleteDocument"      
    };
    
    PlanDeliverListWidget.Mode = {
        DEFAULT         : "Default",
        RELEASE         : "Release"
    };
    
    return PlanDeliverListWidget;
});
