/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = planningNotificationTaskList
//// i18n-prefix = planningNotificationTaskList


define([ "cdes/core/CdesVoc",
    "cdes/planning/util/PlanningNotificationHelper",
    "cdes/planning/util/PlanningNotificationListHelper",
    "cdes/planning/workflow/WorkflowNodeParticipantChooseDialog",
    "cdes/util/ActionHelper",
    "cdes/util/CodeHelper",
    "cdes/util/NameHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ChooseDialog",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dgrid/Editor",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dijit/form/CheckBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/io-query",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    CdesVoc,
    PlanningNotificationHelper,
    PlanningNotificationListHelper,
    WorkflowNodeParticipantChooseDialog,
    ActionHelper,
    CodeHelper,
    NameHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    topic,
    DOMHelper,
    ErrorHelper,
    ChooseDialog,
    ContentWidget,
    InfoDialog,
    Editor,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    CheckBox,
    domClass,
    domConstruct,
    ioQuery,
    on,
    string,
    declare,
    lang,
    Memory,
    Trackable,
    i18n) {

    var className = "at.cdes.web.planning.task.PlanningNotificationTaskListWidget";

    var log = new TinyLog(className);

    var PlanningNotificationTaskListWidget = declare(className, ListWidget, {

        dataAttributeName : "taskJoins",

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationTaskListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        maxGridItems : 1000, // only valid for gridClass Grid
        columnWidthKey : "planningNotificationTask/columnWidths",
        defaultColumnWidth : 130,

        columnIdToDefaultWidth : {
                            task : 130,
                    serialNumber : 70,
                            text : 350,
            planningNotification : 200,
                          baulos : 130,
                         project : 120,
                     subjectArea : 130,
             authorizedInspector : 160,
                       reference : 120,
                   statutoryDuty : 130,
                documentPosition : 200,
                    documentPage : 80,
                  personInCharge : 280,
                         dueDate : 120,
                           state : 120,            
                         actions : 110,
                       selection : 90            
        },            

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            return [organisationPersonId, networkId];
        },        

        constructColumns : function() {
            var columns = [];

            // task
            PlanningNotificationListHelper.pushTaskColumn(columns);

			// initiator
            PlanningNotificationListHelper.pushTokenInitiatorColumn(columns);

            // serialNumber
            columns.push({
                   field : "planningNotificationOrderSerialNumber",
                      id : "serialNumber",
                sortable : true,
                   label : i18n.planningNotificationOrderListSerialNumberLabel
            });

            // text         
            columns.push({
                   field : "planningNotificationOrderText",
                      id : "text",
              renderCell : PlanningNotificationListHelper.renderLineBreak,
                sortable : true,
                   label : i18n.planningNotificationOrderTextLabel
            });

            // planningNotification
            columns.push({
                    field : "_planningNotification",
                       id : "planningNotification",
                formatter : lang.hitch(this, this.planningNotificationFormatter),
              renderCell : PlanningNotificationListHelper.renderLineBreak,
                 sortable : true,
                    label : i18n.planningNotificationOrderPlanningNotificationLabel
            });

            // baulos
            columns.push({
                    field : "_baulos",
                       id : "baulos",
                formatter : lang.hitch(this, this.baulosFormatter),
                 sortable : true,
                    label : i18n.planningNotificationOrderListBaulosLabel
            });

            // project
            columns.push({
                    field : "_projectString",
                       id : "project",
                formatter : lang.hitch(this, this.projectFormatter),
                 sortable : true,
                    label : i18n.planningNotificationOrderProjectLabel
            });

            // subjectArea
            columns.push({
                   field : "subjectAreaName",
                      id : "subjectArea",
                sortable : true,
                   label : i18n.planningNotificationOrderSubjectAreaLabel
            });

            // authorizedInspector
            columns.push({
                   field : "planningNotificationOrderAuthorizedInspector",
                      id : "authorizedInspector",
                sortable : true,
                   label : i18n.planningNotificationOrderAuthorizedInspectorLabel
            });

            // reference
            columns.push({
                     field : "_reference",
                        id : "reference",
                renderCell : lang.hitch(this, this.renderReferenceCell),
                  sortable : true,
                     label : i18n.planningNotificationOrderReferenceLabel
            });

            // statutoryDuty
            columns.push({
                   field : "statutoryDutyName",
                      id : "statutoryDuty",
                sortable : true,
                   label : i18n.planningNotificationOrderListStatutoryDutyLabel
            });

            // documentPosition
            columns.push({
                   field : "planningNotificationOrderDocumentPosition",
                      id : "documentPosition",
                sortable : true,
                   label : i18n.planningNotificationOrderDocumentPositionLabel
            });

            // documentPage
            columns.push({
                   field : "planningNotificationOrderDocumentPage",
                      id : "documentPage",
                sortable : true,
                   label : i18n.planningNotificationOrderDocumentPageLabel
            });

            // personInCharge
            columns.push({
                   field : "personInChargeName",
                      id : "personInCharge",
                sortable : true,
                   label : i18n.planningNotificationOrderPersonInChargeLabel
            });

            // dueDate
            columns.push({
                    field : "_dueDateString",
                       id : "dueDate",
                formatter : lang.hitch(this, this.dueDateFormatter),
                 sortable : true,
                    label : i18n.taskListDueDateColumnCaption
            });

            // state
            columns.push({
                   field : "workflowEntityStatusName",
                      id : "state",
                sortable : true,
                   label : i18n.planningNotificationOrderStateLabel
            });            

            if (this.showActions) {
                columns.push({
                         field : "TODO",// TODO
                            id : "actions",
                    renderCell : lang.hitch(this, this.renderActionCell),
                      sortable : false,
                         label : i18n.actionColumnCaption
                });

                columns.push({
                       field : "_selection",
                          id : "selection",
                    sortable : false,
                       label : i18n.planningNotificationTaskSelectionColumnLabel,
                      editor : CheckBox                    
                });
            }

            return columns;
        },

        planningNotificationFormatter : function(planningNotificationId, orderJoin) {
            return orderJoin.planningNotificationTitle;
        },

        baulosFormatter : function(planningNotificationId, orderJoin) {
            var baulosString = "";
            var baulosMetaInformations = orderJoin.baulosMetaInformations;
            if (baulosMetaInformations && baulosMetaInformations.length > 0)
                var baulosString = PlanningNotificationListHelper.maybeMultipleTextFormatter(baulosMetaInformations, null);
            
            return baulosString;            
        },

        projectFormatter : function(_projectString, taskJoin, omitMarkup) {
            var projectString = "";
            if (taskJoin.projects != null) {
                var projects = taskJoin.projects;
                for (var n = 0; n < projects.length; n++) {
                    if (omitMarkup) {
                        projectString += "(" + projects[n].code + ") " + projects[n].name + (n < projects.length - 1 ? ", " : "");
                    } else {
                        projectString += "<b>(" + projects[n].code + ")</b> " + projects[n].name + (n < projects.length - 1 ? ", " : "");             
                    }                   
                }
            } else if (taskJoin.projectJoins != null) {
                var projectJoins = taskJoin.projectJoins;
                for (var n = 0; n < projectJoins.length; n++) {
                    if (omitMarkup) {
                        projectString += "(" + projectJoins[n].projectCode + ") " + projectJoins[n].projectName + (n < projectJoins.length - 1 ? ", " : "");
                    } else {
                        projectString += "<b>(" + projectJoins[n].projectCode + ")</b> " + projectJoins[n].projectName + (n < projectJoins.length - 1 ? ", " : "");             
                    }                   
                }
            }                


            return projectString;               
        },

        dueDateFormatter : function(_dueDateString, taskJoin, omitMarkup) {
            var optionalDueDate = taskJoin.initiatorWorkflowNodePositionOptionalDueDate;

            if (optionalDueDate != null) {
                var optionalDueDateString = DateHelper.formatUtcSecondsWithTimeZone(optionalDueDate, this.applicationContext.getTimeZone(), i18n.datePattern);
                if (omitMarkup) {
                    return optionalDueDateString;
                } else {
                    return "<span style='color:red;font-weight: bold;'>" + optionalDueDateString + "</span>";
                }                   
            } else {
                var dueDate = taskJoin.initiatorWorkflowNodePositionDueDate;
                if (dueDate != null) {
                    return DateHelper.formatUtcSecondsWithTimeZone(dueDate, this.applicationContext.getTimeZone(), i18n.datePattern);
                } else {
                    var dueDateRemark = CodeHelper.getI18nDueDateRemark(taskJoin.initiatorWorkflowNodePositionDueDateRemark);
                    return dueDateRemark != null ? dueDateRemark : i18n.withoutDueDate;
                }
            }           
        },

        renderReferenceCell : function(taskJoin, data, cell) {
            return PlanningNotificationHelper.renderReferenceCell(taskJoin.referenceInfos, this, "ReviewProtocol");         
        },          

        isSelected : function(workflowTokenId) {
            var taskJoin = this.idToTaskJoin[workflowTokenId];
            return taskJoin != null && !!taskJoin._selected;            
/*
            var row = this.grid.row(workflowTokenId);
            return !!row.data._selected;            
*/
        },

        isAnyTokenSelected : function() {
            for (var n = 0; this.taskJoins && n < this.taskJoins.length; n++) {
                var taskJoin = this.taskJoins[n];
                if (taskJoin._selected) {
                    return true;
                }     
            }
            return false;            
        },            

        renderActionCell : function(taskJoin, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);

            if ("planningNotificationOverview" in taskJoin.allowedProjectActions) {
                var reviewProtocolButton = this.constructReviewProtocolButton(taskJoin);
                domConstruct.place(reviewProtocolButton.domNode, buttonDiv);
            }

            var reviewButton = this.constructReviewButton(taskJoin);
            domConstruct.place(reviewButton.domNode, buttonDiv);
            
            if (taskJoin.workflowTokenReviewId == null && this.mode != CdesVoc.TaskSearchMode.OWN) {
                if ("assignOpenReviewsPlanningNotification" in taskJoin.allowedProjectActions) {
                    var assignReviewButton = this.constructAssignReviewButton(taskJoin);
                    domConstruct.place(assignReviewButton.domNode, buttonDiv);
                }                    
            }
            // If removing items from Signaturmappe is desired, add this code.            
            /* else {
                var removeBatchButton = this.constructRemoveBatchButton(taskJoin);
                domConstruct.place(removeBatchButton.domNode, buttonDiv);
            }*/              

            return buttonDiv;
        },

        constructReviewProtocolButton : function(taskJoin) {
            var button = new FancyButton({
                    title : i18n.planningNotificationTaskListReviewProtocolToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 reviewProtocolButton"
            });
            
            domClass.add(button.domNode, "listButton");
            
            on(button, "click", lang.hitch(this, function(e) {
                var sortedData = [];
                var rowNodes = this.grid.contentNode.childNodes;
                for (var n = 0; n < rowNodes.length; n++) {
                    var row = this.grid.row(rowNodes[n]);
                    if (row != null && row.data != null) {
                        sortedData.push(row.data);
                    }
                }

                if (e.ctrlKey) {
                    var workflowEntityIds = this.getWorkflowEntityIds(sortedData);
                    var workflowEntityIdString = "";
                    for (var n = 0; n < workflowEntityIds.length; n++) {
                        workflowEntityIdString += (n > 0 ? "," : "") + workflowEntityIds[n].toString();
                    }

                    var paramsObject = {
                        ts : dojoConfig.tabSessionId
                    };
                    var hashObject = {                            
                        page : "workflowReviewProtocol",
                          id : taskJoin.planningNotificationOrderWorkflowEntityId
                    };
                    var paramsString = ioQuery.objectToQuery(paramsObject);
                    var hashString = ioQuery.objectToQuery(hashObject);                            
                    var newWindow = window.open("/cdes/frame.html?" + paramsString + "#" + hashString);
                    newWindow.addEventListener("load", lang.hitch(this, function() {
                        var hiddenField = newWindow.document.createElement("input");
                        hiddenField.setAttribute("type", "hidden");
                        hiddenField.setAttribute("name", "workflowEntityIds");
                        hiddenField.setAttribute("value", workflowEntityIdString);
                        newWindow.document.body.appendChild(hiddenField);
                    }));                        
                } else {
                    var workflowEntityIds = this.getWorkflowEntityIds(sortedData);
                    this.applicationContext.setPage("workflowReviewProtocol",
			                            { id : taskJoin.planningNotificationOrderWorkflowEntityId },
			                            {            backPage : this.backPage,
                                                               backParams : this.backParams,
                                                        workflowEntityIds : workflowEntityIds
                                                    });
                }
            }));
            return button;
        },

        getWorkflowEntityIds : function(sortedData) {
            var workflowEntityIdsAlreadyFound = new Object();
            
            var workflowEntityIds = [];
            for (var n = 0; n < sortedData.length; n++) {
                var workflowEntityId = sortedData[n].planningNotificationOrderWorkflowEntityId;
                if (!(workflowEntityId in workflowEntityIdsAlreadyFound)) {
                    workflowEntityIds.push(workflowEntityId);
                    workflowEntityIdsAlreadyFound[workflowEntityId] = true;
                }
            }
            return workflowEntityIds;
        },

        constructAssignReviewButton : function(taskJoin) {
            var button = new FancyButton({
                    title : i18n.planningNotificationTaskListAssignReviewToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 assignReviewButton"
            });
            
            domClass.add(button.domNode, "listButton");
            on(button, "click", lang.hitch(this, function() {
                this.askReassignReview(taskJoin);
            }));

            return button;
        },            

		askReassignReview : function(taskJoin) {
		    var participant = this.projectParticipantFormatter(null, taskJoin);
		    var question = string.substitute(i18n.workflowNodePositionListAskReplaceDialogQuestion, {
			participant : participant		
		    });		
	            
		    InfoDialog.showQuestion({
			  title : i18n.workflowNodePositionListAskReplaceDialogCaption,
			message : question,
			buttons : [
			    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
	                        this.chooseParticipantForReassignReview(taskJoin);
			    })},    			           
			    { type : InfoDialog.Button.NO }
			]
		    });    		            
		},
	
		projectParticipantFormatter : function(_projectParticipant, taskJoin) {
		    return string.substitute(i18n.projectParticipantNameOrganisationFirst, {
			organisationName : taskJoin.organisationName,
			 personGivenName : taskJoin.personGivenName,
			   personSurName : taskJoin.personSurName       
		    });     
		},

        constructReviewButton : function(taskJoin) {
            var button = new FancyButton({
                    title : i18n.planningNotificationTaskListDoReviewToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 reviewButton"
            });
            
            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.registerAsyncOperationStarted(PlanningNotificationTaskListWidget.AsyncOperation.FETCH_SORTED_DATA);
                var sortedData = this.getSortedData().then(
                    lang.hitch(this, function(sortedData) {
                        this.registerAsyncOperationFinished(PlanningNotificationTaskListWidget.AsyncOperation.FETCH_SORTED_DATA);

                        var backParams = this.backParams;
                        backParams.initialMode = this.mode;

                        this.applicationContext.setPage("workflowReview",
                            { id : taskJoin.workflowTokenId },
                            {
                                  backPage : this.backPage,
                                backParams : backParams,
                                 taskJoins : sortedData
                            });
                    }), lang.hitch(this, function(err) {
                        log.error("Error while fetching sorted data.", err);                    
                    })).otherwise(
                        lang.hitch(this, function(err) {
                            log.error("Error while fetching sorted data.", err);
                        }));
            }));
            return button;
        },

        constructRemoveBatchButton : function(taskJoin) {
            var button = new FancyButton({
                    title : i18n.planningNotificationTaskListRemoveBatchToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });
            
            domClass.add(button.domNode, "listButton");
            on(button, "click", lang.hitch(this, function() {
                var text = taskJoin.planningNotificationOrderText;
                if (text == null) {
                    text = "";
                }
                if (text.length > 50) {
                    text = text.substr(0, 50) + "...";
                }                    
                var message = string.substitute(i18n.planningNotificationTaskListAskRemoveBatchDialogQuestion, {
                    serialNumber : taskJoin.planningNotificationOrderSerialNumber,
                            text : text
                });

                InfoDialog.showQuestion({
                      title : i18n.planningNotificationTaskListAskRemoveBatchDialogCaption,
                    message : message,
                    buttons : [
                        { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                            this.doRemoveBatch(taskJoin);
                        })},                           
                        { type : InfoDialog.Button.NO }
                    ]
                }); 
            }));

            return button;
        },            

        doRemoveBatch : function(taskJoin) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(PlanningNotificationTaskListWidget.AsyncOperation.REMOVE_BATCH);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.dropWorkflowTokenFromBatchSignature(organisationPersonId, taskJoin.workflowTokenId).then(
                lang.hitch(this, function() {
                    this.registerAsyncOperationFinished(PlanningNotificationTaskListWidget.AsyncOperation.REMOVE_BATCH);

                    topic.publish("message/ok", i18n.planningNotificationTaskListDropWorkflowTokenFromBatchSuccessful);
                    on.emit(this, "doSearch");
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanningNotificationTaskListWidget.AsyncOperation.REMOVE_BATCH,
                                opName : "dropWorkflowTokenFromBatchSignature",
                               message : i18n.planningNotificationTaskListDropWorkflowTokenFromBatchFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [dropWorkflowTokenFromBatchSignature]", err);
                    }));                        
        },

        updateIndividualColumns : function() {
            this.updateColumn("task", this.columnSettings.showTask);
            this.updateColumn("tokenInitiator", this.columnSettings.showTokenInitiator);
            this.updateColumn("serialNumber", this.columnSettings.showSerialNumber);
            this.updateColumn("text", this.columnSettings.showText);
            this.updateColumn("planningNotification", this.columnSettings.showPlanningNotification);
            this.updateColumn("baulos", this.columnSettings.showBaulos);
            this.updateColumn("project", this.columnSettings.showProject);
            this.updateColumn("subjectArea", this.columnSettings.showSubjectArea);
            this.updateColumn("authorizedInspector", this.columnSettings.showAuthorizedInspector);
            this.updateColumn("reference", this.columnSettings.showReference);
            this.updateColumn("statutoryDuty", this.columnSettings.showStatutoryDuty);
            this.updateColumn("documentPage", this.columnSettings.showDocumentPage);
            this.updateColumn("documentPosition", this.columnSettings.showDocumentPosition);
            this.updateColumn("personInCharge", this.columnSettings.showPersonInCharge);
            this.updateColumn("dueDate", this.columnSettings.showDueDate);
            this.updateColumn("state", this.columnSettings.showState);
            if (this.showActions) {
                this.updateColumn("selection", this.showSelection);
            }
        },

        constructTopDiv : function() {
            var grid = this.constructGrid({
                idProperty : "workflowTokenId", 
                    gridId : this.gridId != null ? this.gridId : "PlanningNotificationTaskListWidgetGrid",
                   modules : [ Editor ],
                 gridClass : "Grid" //"OnDemandGrid"
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var networkId = this.applicationContext.getPageContextPnNetworkId();
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationTask/sort", e.sort);
            }));

    	    on(grid, "dgrid-datachange", lang.hitch(this, function(e) {
	    		var column = e.cell && e.cell.column ? e.cell.column.id : null;
	    		var rowId = e.cell && e.cell.row ? e.cell.row.id : null;    			    			
	    			
	    		// DnDCellWidget uses values { value, rowId }.
	    		var newValue = !!e.value;
                if (e.cell.row.data._selected != newValue) {
                    e.cell.row.data._selected = !!newValue;
                    on.emit(this, "selectionChanged");
                }
            }));                

            return grid;            
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        selectAll : function(selected) {
            var nodes = this.grid.contentNode.children;
            for (var n = 0; n < nodes.length; n++) {
                var node = nodes[n];
                var row = this.grid.row(node);

                var cell = row != null ? this.grid.cell(row, "selection") : null;
                var cellElement = cell != null ? cell.element : null;                
                var checkBox = cellElement != null ? cellElement.widget : null;
                if (checkBox != null)
                    checkBox.set("value", selected);                         
            }
/*            
            for (var n = 0; n < this.taskJoins.length; n++) {
                var taskJoin = this.taskJoins[n];
                var workflowTokenId = taskJoin.workflowTokenId;
                var row = this.grid.row(workflowTokenId);

                var cell = row != null ? this.grid.cell(row, "selection") : null;
                var cellElement = cell != null ? cell.element : null;                
                var checkBox = cellElement != null ? cellElement.widget : null;

                checkBox.set("value", selected);                
            }                
*/
        },            

        chooseParticipantForReassignReview : function(taskJoin) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var roleTypeId = taskJoin.workflowNodeTemplateRoleTypeId;
            var projects = taskJoin.projects;
	    var projectIds = [];
	    for (var n = 0; n < projects.length; n++) {
		projectIds.push(projects[n].id);
	    }

	    var projectService = this.applicationContext.getService("projectService");
	    this.registerAsyncOperationStarted(PlanningNotificationTaskListWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS);
	    projectService.getParticipationJoins(organisationPersonId, roleTypeId, projectIds).then(
		lang.hitch(this, function(participationJoins) {
		    this.registerAsyncOperationFinished(PlanningNotificationTaskListWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS);
		    this.possibleParticipationJoins = participationJoins;
		    this.openParticipantChooseDialog(participationJoins, taskJoin.participantParticipationId, taskJoin.workflowTokenOwnerPositionId);
		}),
		lang.hitch(this, function(err) {
		    ErrorHelper.processAsyncError({
				   err : err,
				widget : this,
			asyncOperation : PlanningNotificationTaskListWidget.AsyncOperation.GET_PROJECT_PARTICIPATIONS,
				opName : "getParticipationJoins",
			       message : i18n.workflowNodeEditGetParticipationJoinsFailed
		    });
		})).otherwise(
		    lang.hitch(this, function(err) {
			log.error("Error while calling function [getParticipationJoins]", err);
		    }));            
        },            

		openParticipantChooseDialog : function(participationJoins, oldProjectParticipationId, workflowNodePositionId) {
			var dueDateHeight = 80;
			var participantGridWidth = 500;
			var baulosGridWidth = 150;
			var gridHeight = 320;

			var defaultWidth = participantGridWidth + 15;
			var defaultHeight = gridHeight + 15;

			var chooseDialog = new WorkflowNodeParticipantChooseDialog({
			    applicationContext : this.applicationContext,
				         title : i18n.planningNotificationTaskListChooseParticipantDialogCaption,
				       buttons : [ 
				    { type : ChooseDialog.Button.CHOOSE,
					     name : "selectButton"		
					},
				    { type : InfoDialog.Button.ABORT,
					    title : i18n.abortToolTip }
				],
				  defaultWidth : defaultWidth,
				 defaultHeight : defaultHeight,
				 dueDateHeight : dueDateHeight,
			  participantGridWidth : participantGridWidth,
			       baulosGridWidth : baulosGridWidth,
				    gridHeight : gridHeight,		
				  enterDueDate : false,
		    participationSelectionMode : "single",
				   enterBaulos : false,
			baulosMetaInformations : null,
			    participationJoins : participationJoins		
			});

		    on(chooseDialog, "valueChosen", lang.hitch(this, function(params) {
                        var selectedParticipationJoins = params.selectedParticipationJoins;
                        var participationJoin = selectedParticipationJoins != null && selectedParticipationJoins.length > 0 ? selectedParticipationJoins[0] : null;
                        var participationId = participationJoin != null ? participationJoin.projectParticipationId : null;
                        if (participationId != null) {
                            if (oldProjectParticipationId == participationId) {
			        var topDiv = domConstruct.create("div", null, null);
			        domClass.add(topDiv, "workflowNodeEditAlreadyExistingDialogTopDiv occupyWholeParent");
			        var captionLineTable = domConstruct.create("table", null, topDiv);
			        var captionLineTableRow = domConstruct.create("tr", null, captionLineTable);

			        var warnTD = domConstruct.create("td", null, captionLineTableRow);
			        var warnIcon = domConstruct.create("div", null, warnTD);
			        domClass.add(warnIcon, "clazzesWarnIcon32");

			        DOMHelper.createTextNode("td", i18n.planningTaskListSameChosenDialogText, captionLineTableRow, "");

			        var infoDialog = new InfoDialog({
				     defaultWidth : 400,
				    defaultHeight : 350, 
				            title : i18n.planningTaskListSameChosenDialogCaption,
				          content : topDiv,
				          buttons : [ { type : InfoDialog.Button.OK }
				          ]    	    			
			        });
			        infoDialog.show();
                            } else {
                                this.reassignWorkflowNodePosition(workflowNodePositionId, participationId);
                            }
                        }                            
		    }));		

		    chooseDialog.show(null);
		},	                        

        reassignWorkflowNodePosition : function(workflowNodePositionId, participationId) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(PlanningNotificationTaskListWidget.AsyncOperation.REASSIGN);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.reassignWorkflowNodePosition(organisationPersonId, workflowNodePositionId, participationId).then(
                lang.hitch(this, function() {
                    this.registerAsyncOperationFinished(PlanningNotificationTaskListWidget.AsyncOperation.REASSIGN);

                    topic.publish("message/ok", i18n.planningNotificationTaskListReassignSuccessful);
                    on.emit(this, "doSearch");
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanningNotificationTaskListWidget.AsyncOperation.REASSIGN,
                                opName : "reassignWorkflowNodePosition",
                               message : i18n.planningNotificationTaskListReassignFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [reassignWorkflowNodePosition]", err);
                    }));            
        },

        setData : function(params) {
            this.showSelection = !!params.showSelection;        
            this.mode = params.mode;
            var columnSettings = params.columnSettings;

            var planningNotificationTaskInfos = params.planningNotificationTaskInfos;
            this.idToTaskJoin = new Object();
            this.taskJoins = [];
            for (var n = 0; n < planningNotificationTaskInfos.length; n++) {
                var taskInfo = planningNotificationTaskInfos[n];
                var taskJoin = taskInfo.taskJoin;               
                taskJoin.projects = taskInfo.projects ? taskInfo.projects : [];
                //                taskJoin.planningNotificationBaulose = taskInfo.planningNotificationBaulose ? taskInfo.planningNotificationBaulose : [];
                taskJoin.baulosMetaInformations = taskInfo.planningNotificationBaulose ? taskInfo.planningNotificationBaulose : [];
                taskJoin.workflowNodePositionBaulose = taskInfo.workflowNodePositionBaulose ? taskInfo.workflowNodePositionBaulose : [];
                taskJoin.workflowNodeInitiatorPositionBaulose = taskInfo.workflowNodeInitiatorPositionBaulose ? taskInfo.workflowNodeInitiatorPositionBaulose : [];
                taskJoin.allowedProjectActions = taskInfo.allowedProjectActions;
                taskJoin.referenceInfos = taskInfo.referenceInfos;
                this.taskJoins.push(taskJoin);
                this.idToTaskJoin[taskJoin.workflowTokenId] = taskJoin;
            }           

            this.updateAuxiliaryData();

            if (columnSettings) {
                this.setColumnSettings(params.columnSettings);
            }

            this.reload();
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.taskJoins.length; n++) {
                var joinDto = this.taskJoins[n];
                this.updateAuxiliaryDataForJoinDto(joinDto);
            }
        },

        updateAuxiliaryDataForJoinDto : function(joinDto) {
            joinDto._taskString = PlanningNotificationListHelper.taskFormatter(null, joinDto, true);
            joinDto._tokenInitiatorString = PlanningNotificationListHelper.tokenInitiatorFormatter(null, joinDto, true);
            joinDto._planningNotification = this.planningNotificationFormatter(null, joinDto, true);
            joinDto._projectString = this.projectFormatter(null, joinDto, true);
            joinDto._dueDateString = this.dueDateFormatter(null, joinDto, true);            
        },

        reload : function(params) {
            this.updateColumns(this.columnSettings);

            this.setStoreData(this.taskJoins);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationTask/sort");

            if (oldSort == null) {
                this.grid.set("sort", "_dueDateString", false);
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationTask/sort", this.grid.get("sort"));
            } else {
                this.grid.set("sort", oldSort);
            }           

            this.grid.updateSortArrow(this.grid.sort);

			// Necessary only if OnDemandGrid is used; however we use Grid
			if (this.grid.gridClass == "OnDemandGrid")
            	this.grid.refresh();
        },

        getRowId : function(joinDto) {
            return joinDto.workflowTokenId;
        },

        getQuickSearchTokensForRow : function(taskJoin) {
            var tokens = [];

            if (this.columnSettings.showTask) {
                tokens.push(taskJoin._taskString);
            }
            if (this.columnSettings.showTokenInitiator) {
                tokens.push(taskJoin._tokenInitiatorString);
            }
            if (this.columnSettings.showSerialNumber) {
                tokens.push(taskJoin.planningNotificationOrderSerialNumber != null ? taskJoin.planningNotificationOrderSerialNumber.toString() : "");
            }
            if (this.columnSettings.showText) {
                tokens.push(taskJoin.planningNotificationOrderText);
            }
            if (this.columnSettings.showPlanningNotification) {
                tokens.push(this.planningNotificationFormatter(null, taskJoin));
            }
            if (this.columnSettings.showBaulos) {
                tokens.push(this.baulosFormatter(null, taskJoin));
            }
            if (this.columnSettings.showProject) {
                tokens.push(taskJoin._projectString);
            }
            if (this.columnSettings.showSubjectArea) {
                tokens.push(taskJoin.subjectAreaName);
            }
            if (this.columnSettings.showAuthorizedInspector) {
                tokens.push(taskJoin.planningNotificationOrderAuthorizedInspector);
            }
            if (this.columnSettings.showStatutoryDuty) {
                tokens.push(taskJoin.statutoryDutyName);
            }
            if (this.columnSettings.showDocumentPage) {
                tokens.push(taskJoin.planningNotificationOrderDocumentPage);
            }
            if (this.columnSettings.showDocumentPosition) {
                tokens.push(taskJoin.planningNotificationOrderDocumentPosition);
            }
            if (this.columnSettings.showPersonInCharge) {
                tokens.push(taskJoin.personInChargeName);
            }
            if (this.columnSettings.showDueDate) {
                tokens.push(taskJoin._dueDateString);
            }
            if (this.columnSettings.showState) {
                tokens.push(taskJoin.workflowEntityStatusName);
            }           

            return tokens;          
        },          

        destroy : function() {
            this.inherited(arguments);

            this.grid.destroy();
        }
    });

    PlanningNotificationTaskListWidget.AsyncOperation = {
        GET_PROJECT_PARTICIPATIONS : "GetProjectParticipations",
        FETCH_SORTED_DATA : "FetchSortedData",
        REASSIGN : "Reassign", 
        REMOVE_BATCH : "RemoveBatch"
    };

    return PlanningNotificationTaskListWidget;
});
