define([ 
         "clazzes/TinyLog",
         "clazzes/dateTime/DateHelper",
         "cdes/widget/CalendarSpinner",
         "clazzes/util/WidgetHelper",
         "cdes/core/CdesVoc",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/util/StringHelper",
         "clazzes/widgets/IconTitlePane",
         "clazzes/widgets/layout/ContentWidget",
         "dijit/form/Button",
         "dijit/form/CheckBox",
         "dijit/form/Select",
         "dijit/form/TextBox",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/keys",
         "dojo/on",
         "dojox/uuid/generateTimeBasedUuid",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 DateHelper,
    		 CalendarSpinner,
             WidgetHelper,
             CdesVoc,
    		 DOMHelper,
             ErrorHelper,
    		 StringHelper,
    		 IconTitlePane,
    		 ContentWidget,
    		 Button,
    		 CheckBox,
    		 Select,
    		 TextBox,
    		 domClass,
    		 domConstruct,
    		 Keys,
    		 on,
    		 generateTimeBasedUuid,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.certificate.CertificateSearchWidget";

	var log = new TinyLog(className);
	
    var CertificateSearchWidget = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
    		this.showValidCheckBox.set("checked", true);
    		
    		this.allFieldsValid = true;
    		this.initialized = false;
    		
    		this.populateSearchFields();


        },

        initialize : function() {
    	    // Fetch networks for network dropdown
    	    var prevSeconds = DateHelper.getCurrentTimeSeconds();
    	    this.registerAsyncOperationStarted(CertificateSearchWidget.AsyncOperation.GET_NETWORKS);

    	    var networkService = this.applicationContext.getService("networkService");
    	    this.getNetworksDeferred = networkService.getAllNetworks();
    	    this.getNetworksDeferred.then(lang.hitch(this, function(networks) {
	    		this.networks = networks;
	    		this.updateNetworkSelect();
	
	    		var postSeconds = DateHelper.getCurrentTimeSeconds();
	    		
	    		if (log.isDebugEnabled()) {
	    		    log.debug("Queried networks after " + (postSeconds - prevSeconds) + "s");	
	    		}				
			
				this.doSearch();
			
		    	this.registerAsyncOperationFinished(CertificateSearchWidget.AsyncOperation.GET_NETWORKS);
    	    }),
   			lang.hitch(this, function(err) {			
			    delete this.getNetworksDeferred;
			    ErrorHelper.processAsyncError({
	                                   err : err,
	                                widget : this,
	                        asyncOperation : CertificateSearchWidget.AsyncOperation.GET_NETWORKS,
	                                opName : "getAllNetworks",
	                               message : i18n.certificateSearchFetchNetworksFailed
			    });				
			})
    	    ).otherwise(lang.hitch(this, function(err) {
    		log.error("Error while processing the results of calling getNetworks ", err);
    	    }));    		
        },    	    

    	getWidgetId : function() {
    		return "CertificateSearchWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		domClass.add(topDiv, "refNodeOfPositionAbsolute certificateSearchTopDivFull");
    		
    		this.titlePane = this.constructTitlePane();
    		domConstruct.place(this.titlePane.domNode, topDiv);
    		
    		return topDiv;
    	},
    	
    	postTitleClick : function() {
    		var open = this.titlePane.get("open");
    		if (open) {
    			this.titlePane.set("title", i18n.searchOpenCaption);
    			domClass.replace(this.topDiv, "certificateSearchTopDivFull", "certificateSearchTopDivReduced");
    		} else {
    			this.titlePane.set("title", i18n.searchClosedCaption);
    			domClass.replace(this.topDiv, "certificateSearchTopDivReduced", "certificateSearchTopDivFull");
    		}
    		on.emit(this, "titlePaneToggled");
    	},
    	
     	constructTitlePane : function() {
     		var searchDiv = this.constructSearchDiv();
     		
			var titlePane = new IconTitlePane({
				         title   : i18n.searchOpenCaption,
    				     content : searchDiv,
				      toggleable : true,
				            open : true,
				  postTitleClick : lang.hitch(this, this.postTitleClick)
			});
			domClass.add(titlePane.domNode, "occupyWholeParent");
			
			return titlePane;
     	},
     	
     	constructSearchDiv : function() {
     		var searchDiv = domConstruct.create("div", null, null);
     		domClass.add(searchDiv, "refNodeOfPositionAbsolute certificateSearchDiv");
     		
     		// First Column
     		
     		// Person name
     		DOMHelper.createTextNode("div", i18n.certificateSearchPersonNameLabel, searchDiv, "propertyLabel certificateSearchPersonNameLabel");
     		this.personNameTextBox = new TextBox({
		     			label : i18n.certificateSearchPersonNameLabel,
		     			title : i18n.certificateSearchPersonNameToolTip,
                selectOnClick : true
     		});
     		domClass.add(this.personNameTextBox.domNode, "fixedDialogWidget certificateSearchPersonNameTextBox");     		
     		domConstruct.place(this.personNameTextBox.domNode, searchDiv);
     		on(this.personNameTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
     		
     		// Organisation name
     		DOMHelper.createTextNode("div", i18n.certificateSearchOrganisationNameLabel, searchDiv, "propertyLabel certificateSearchOrganisationNameLabel");
     		this.organisationNameTextBox = new TextBox({
		     			label : i18n.certificateSearchOrganisationNameLabel,
		     			title : i18n.certificateSearchOrganisationNameToolTip,
                selectOnClick : true
     		});
     		domClass.add(this.organisationNameTextBox.domNode, "fixedDialogWidget certificateSearchOrganisationNameTextBox");     		
     		domConstruct.place(this.organisationNameTextBox.domNode, searchDiv);
     		on(this.organisationNameTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));      		
     		
     		// Issuer
     		DOMHelper.createTextNode("div", i18n.certificateSearchIssuerLabel, searchDiv, "propertyLabel certificateSearchIssuerLabel");
     		this.issuerNameTextBox = new TextBox({
		     			label : i18n.certificateSearchIssuerLabel,
		     			title : i18n.certificateSearchIssuerToolTip,
                selectOnClick : true
     		});
     		domClass.add(this.issuerNameTextBox.domNode, "fixedDialogWidget certificateSearchIssuerTextBox");     		
     		domConstruct.place(this.issuerNameTextBox.domNode, searchDiv);      		
     		on(this.issuerNameTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     		
     		// Second Column
     		
     		// Network
     		DOMHelper.createTextNode("div", i18n.certificateSearchNetworkLabel, searchDiv, "propertyLabel certificateSearchNetworkLabel");
     		
     		var networkOptions = [];
     		this.networkSelect = new Select({
     			  label : i18n.certificateSearchNetworkLabel,
     			  title : i18n.certificateSearchNetworkToolTip,
     			options : networkOptions
     		});
     		domClass.add(this.networkSelect.domNode, "fixedDialogWidget certificateSearchNetworkSelect");
     		domConstruct.place(this.networkSelect.domNode, searchDiv);    		
     		
     		// From
     		DOMHelper.createTextNode("div", i18n.certificateSearchFromLabel, searchDiv, "propertyLabel certificateSearchFromLabel");
     		this.fromSpinner = new CalendarSpinner({
     			     label : i18n.certificateSearchFromLabel,
     			     title : i18n.certificateSearchFromToolTip,
        		   pattern : i18n.datePattern,
        	    dndEnabled : false,
         rowObjectToString : null
     		});
     		domClass.add(this.fromSpinner.domNode, "fixedDialogWidget certificateSearchFromSpinner");
     		domConstruct.place(this.fromSpinner.domNode, searchDiv);
     		on(this.fromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     		
     		// To
     		DOMHelper.createTextNode("div", i18n.certificateSearchToLabel, searchDiv, "propertyLabel certificateSearchToLabel");
     		this.toSpinner = new CalendarSpinner({
     			     label : i18n.certificateSearchToLabel,
     			     title : i18n.certificateSearchToToolTip,
        		   pattern : i18n.datePattern,
           	    dndEnabled : false,
         rowObjectToString : null
     		});
     		domClass.add(this.toSpinner.domNode, "fixedDialogWidget certificateSearchToSpinner");
     		domConstruct.place(this.toSpinner.domNode, searchDiv); 
     		on(this.toSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     		
     		// Third Column
     		
    		// Show Valid CheckBox
			this.showValidCheckBox = new CheckBox({
				label : i18n.certificateSearchShowValidLabel,
				title : i18n.certificateSearchShowValidToolTip
			});
			domClass.add(this.showValidCheckBox.domNode, "fixedDialogWidget certificateSearchShowValidCheckBox");
			domConstruct.place(this.showValidCheckBox.domNode, searchDiv);
     		on(this.showValidCheckBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
			
			DOMHelper.createTextNode("div", i18n.certificateSearchShowValidLabel, searchDiv, "fixedDialogWidget certificateSearchShowValidLabel");
			
    		// Show Invitations CheckBox
			this.showInvitationsCheckBox = new CheckBox({
				label : i18n.certificateSearchShowInvitationsLabel,
				title : i18n.certificateSearchShowInvitationsToolTip
			});
			domClass.add(this.showInvitationsCheckBox.domNode, "fixedDialogWidget certificateSearchShowInvitationsCheckBox");
			domConstruct.place(this.showInvitationsCheckBox.domNode, searchDiv);
     		on(this.showInvitationsCheckBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
			
			DOMHelper.createTextNode("div", i18n.certificateSearchShowInvitationsLabel, searchDiv, "fixedDialogWidget certificateSearchShowInvitationsLabel");
			
    		// Show Expired CheckBox
			this.showExpiredCheckBox = new CheckBox({
				label : i18n.certificateSearchShowExpiredLabel,
				title : i18n.certificateSearchShowExpiredToolTip
			});
			domClass.add(this.showExpiredCheckBox.domNode, "fixedDialogWidget certificateSearchShowExpiredCheckBox");
			domConstruct.place(this.showExpiredCheckBox.domNode, searchDiv);
     		on(this.showExpiredCheckBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
			
			DOMHelper.createTextNode("div", i18n.certificateSearchShowExpiredLabel, searchDiv, "fixedDialogWidget certificateSearchShowExpiredLabel");			
     		
     		// Fourth Column
			
    		// Show Valid Expired Soon CheckBox
			this.showValidExpiredSoonCheckBox = new CheckBox({
				label : i18n.certificateSearchShowValidExpiredSoonLabel,
				title : i18n.certificateSearchShowValidExpiredSoonToolTip
			});
			domClass.add(this.showValidExpiredSoonCheckBox.domNode, "fixedDialogWidget certificateSearchShowValidExpiredSoonCheckBox");
			domConstruct.place(this.showValidExpiredSoonCheckBox.domNode, searchDiv);
     		on(this.showValidExpiredSoonCheckBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
			
			DOMHelper.createTextNode("div", i18n.certificateSearchShowValidExpiredSoonLabel, searchDiv, "fixedDialogWidget certificateSearchShowValidExpiredSoonLabel");
			
    		// Show Requested CheckBox
			this.showRequestedCheckBox = new CheckBox({
				label : i18n.certificateSearchShowRequestedLabel,
				title : i18n.certificateSearchShowRequestedToolTip
			});
			domClass.add(this.showRequestedCheckBox.domNode, "fixedDialogWidget certificateSearchShowRequestedCheckBox");
			domConstruct.place(this.showRequestedCheckBox.domNode, searchDiv);
     		on(this.showRequestedCheckBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
			
			DOMHelper.createTextNode("div", i18n.certificateSearchShowRequestedLabel, searchDiv, "fixedDialogWidget certificateSearchShowRequestedLabel");
			
    		// Show Persons without certificate CheckBox
			this.showPersonsWithoutCertificateCheckBox = new CheckBox({
				label : i18n.certificateSearchShowPersonsWithoutCertificateLabel,
				title : i18n.certificateSearchShowPersonsWithoutCertificateToolTip
			});
			domClass.add(this.showPersonsWithoutCertificateCheckBox.domNode, "fixedDialogWidget certificateSearchShowPersonsWithoutCertificateCheckBox");
			domConstruct.place(this.showPersonsWithoutCertificateCheckBox.domNode, searchDiv);
     		on(this.showPersonsWithoutCertificateCheckBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
			
			DOMHelper.createTextNode("div", i18n.certificateSearchShowPersonsWithoutCertificateLabel, searchDiv, "fixedDialogWidget certificateSearchShowPersonsWithoutCertificateLabel");				

            // Buttons
            this.buttonDiv = domConstruct.create("div", null, null);
            domClass.add(this.buttonDiv, "fixedDialogWidget certificateSearchButtonDiv");
            domConstruct.place(this.buttonDiv, searchDiv);            

            // ClearSearchFieldsButton
            this.clearSearchFieldsButton = new Button({ 
                label : i18n.clearSearchFieldsButtonCaption,
                title : i18n.clearSearchFieldsButtonToolTip
            });
            domClass.add(this.clearSearchFieldsButton.domNode, "textButton certificateSearchClearSearchFieldsButton");
            domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);

            on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));            

			// Search Button
			this.searchButton = new Button({
     			label : i18n.searchButtonCaption,
     			title : i18n.certificateSearchSearchButtonToolTip
     		});
     		domClass.add(this.searchButton.domNode, "fixedDialogWidget certificateSearchSearchButton");
     		domConstruct.place(this.searchButton.domNode, this.buttonDiv);
     		
     		on(this.searchButton, "click", lang.hitch(this, this.doSearch));			
			
     		return searchDiv;
     	},
    	
     	getSearchModel : function() {

     		var networkId = this.networkSelect.get("value");
 			var searchModel = {
 							        networkId : networkId == "ALL" ? null : networkId,
 					               personName : this.personNameTextBox.get("value"),
          					 organisationName : this.organisationNameTextBox.get("value"),
 					               issuerName : this.issuerNameTextBox.get("value"),
		                                 from : this.fromSpinner.getUtcSeconds(),
		                                   to : this.toSpinner.getUtcSeconds(),
		                            showValid : this.showValidCheckBox.get("checked"),
		                      showInvitations : this.showInvitationsCheckBox.get("checked"),
		                          showExpired : this.showExpiredCheckBox.get("checked"),
		                 showValidExpiredSoon : this.showValidExpiredSoonCheckBox.get("checked"),
		                        showRequested : this.showRequestedCheckBox.get("checked"),
		        showPersonsWithoutCertificate : this.showPersonsWithoutCertificateCheckBox.get("checked")
			};
			
			return searchModel;
     	},
     	
     	populateSearchFields : function() {
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId], "/certificate/search");
    		
    		if (oldSearchModel != null) {
        		var networkString = (oldSearchModel.networkId == null ? "ALL" : oldSearchModel.networkId.toString());
        		this.networkSelect.set("value", networkString);
        		
        		var from = !StringHelper.isEmpty(oldSearchModel.from) ? oldSearchModel.from : null;
        		var to = !StringHelper.isEmpty(oldSearchModel.to) ? oldSearchModel.to : null;
        		
        		this.personNameTextBox.set("value", oldSearchModel.personName);
        		this.organisationNameTextBox.set("value", oldSearchModel.organisationName);
        		this.issuerNameTextBox.set("value", oldSearchModel.issuerName);
        		if (from != null) {
        			this.fromSpinner.setUtcSeconds(oldSearchModel.from);	
        		}
        		if (to != null) {
        			this.toSpinner.setUtcSeconds(oldSearchModel.to);	
        		}        		
        		this.showValidCheckBox.set("checked", oldSearchModel.showValid);
        		this.showInvitationsCheckBox.set("checked", oldSearchModel.showInvitations);
        		this.showExpiredCheckBox.set("checked", oldSearchModel.showExpired);
        		this.showValidExpiredSoonCheckBox.set("checked", oldSearchModel.showValidExpiredSoon);
        		this.showRequestedCheckBox.set("checked", oldSearchModel.showRequested);
        		this.showPersonsWithoutCertificateCheckBox.set("checked", oldSearchModel.showPersonsWithoutCertificate);    			
    		}
     	},
     	
     	updateNetworkSelect : function() {
     		var networkOptions = [{ value : "ALL", label : i18n.allOption }];
     		
     		for (var n = 0; n < this.networks.length; n++) {
     			var network = this.networks[n];
     			networkOptions.push({ value : network.id.toString(), label : network.name });
     		}
     		
			networkOptions.sort(lang.hitch(this, function(optionOne, optionTwo) {
				if (optionOne.value == "ALL") {
					return -1;
				} else if (optionTwo.value == "ALL") {
					return 1;
				} else {
					return optionOne.label.localeCompare(optionTwo.label);
				}
			}));     		
     		
     		this.networkSelect.set("options", networkOptions);
     		
    		//var contextNetworkId = this.applicationContext.getPageContextNetworkId();
    		this.networkSelect.set("value", "ALL");
    		
    		this.initialized = true;
     	},
     	
     	isAlreadyInitialized : function() {
     		return this.initialized;
     	},
     	
     	updateWidgetState : function() {
     		
     	},
     	
     	searchIfEnter : function(e) {
 			if (e.keyCode == Keys.ENTER) {
 				this.doSearch();
 			}
     	},     	
     	
     	doSearch : function() {
	    	on.emit(this, "doSearch");
     	},

        clearSearchFields : function() {
            var network = this.applicationContext.getPageContextNetwork();
            var networkName = (network != null ? network.name : null);

            this.personNameTextBox.set("value", null);
            this.organisationNameTextBox.set("value", null);
            this.issuerNameTextBox.set("value", null);
            WidgetHelper.setSelectValue(this.networkSelect, CdesVoc.WHATEVER);
            this.fromSpinner.setUtcSeconds(null);
            this.toSpinner.setUtcSeconds(null);
        }
    });
    
    CertificateSearchWidget.AsyncOperation = {
    		GET_NETWORKS : "GetNetworks"
    };    
    
    return CertificateSearchWidget;
});
