/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

//// css-prefix = metaInformationChoose
//// i18n-prefix = metaInformationChoose

define([ "cdes/widget/base/ListWidget",
	 "clazzes/TinyLog",
	 "dojo/dom-class",
	 "dojo/dom-construct",
	 "dojo/on",
	 "dojo/string",
	 "dojo/_base/declare",
	 "dojo/_base/lang",
	 "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
       function(ListWidget,
		TinyLog,
		domClass,
		domConstruct,
		on,
		string,
		declare,
		lang,
		i18n) {

    var className = "at.cdes.web.planning.util.MetaInformationChooseWidget";

    var log = new TinyLog(className);

    var MetaInformationChooseWidget = declare(className, ListWidget, {

	constructor : function(params) {
	    lang.mixin(this, params);

	    this.topDiv = this.constructTopDiv();

	    this.allFieldsValid = true;
	},

	getWidgetId : function() {
	    return "MetaInformationChooseWidget";
	},

	getDataId : function() {
	    return null;
	},

	getContainer : function() {
	    return this.topDiv;
	},

	constructColumns : function() {
	    var columns = [];

            // ProjectParticipant
            columns.push({
                     field : "value",
                        id : "value",
                  sortable : true,
                     label : this.columnCaption
             });     

	    return columns;
	},

	constructTopDiv : function() {
	    // See https://github.com/SitePen/dgrid/blob/master/doc/components/mixins/Selection.md for selection modes

            var grid = this.constructGrid({
		   idProperty : "metaInformationId", 
            	       gridId : "MetaInformationChooseGrid",
		selectionMode : "extended"
            });

    	    on(grid, "dgrid-select", lang.hitch(this, this.emitSelectionChanged));
    	    on(grid, "dgrid-deselect", lang.hitch(this, this.emitSelectionChanged));

	    return grid;	    
	},

        emitSelectionChanged : function() {
            on.emit(this, "selectionChanged", this.getSelectedItems());
        },

	resize : function(newSize) {
	    this.grid.resize(newSize);
	},

	setData : function(params) {
	    this.metaInformations = params.metaInformations;
	    
	    this.reload();
	},

	reload : function(params) {
	    this.store.setData(this.metaInformations);

	    this.grid.set("sort", "value", false);
	    this.grid.updateSortArrow(this.grid.sort);
	    this.grid.refresh();
	},

	destroy : function() {
	    this.inherited(arguments);

	    this.grid.destroy();
	}
    });

    MetaInformationChooseWidget.AsyncOperation = {

    };

    return MetaInformationChooseWidget;
});
