/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = plotOrderTemplateChoose
//// i18n-prefix = plotOrderTemplateChoose

define([ 
    "cdes/plot/PlotOrderTemplateAddressListWidget",
    "cdes/plot/PlotOrderTemplateItemListWidget",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/SplitContainer",
    "dijit/form/Button",
    "dojo/_base/declare",
    "dojo/_base/lang",    
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/string",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"    
], function(
    PlotOrderTemplateAddressListWidget,
    PlotOrderTemplateItemListWidget,
    TinyLog,
    DOMHelper,
    ContentWidget,
    SplitContainer,
    Button,    
    declare,
    lang,
    domClass,
    domConstruct,
    domStyle,
    string,    
    i18n    
) {

    var className = "at.cdes.web.plot.PlotOrderTemplateChooseWidget";

    var log = new TinyLog(className);

    var PlotOrderTemplateChooseWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;            
        },

        getWidgetId : function() {
            return "PlotOrderTemplateChooseWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute");            

            var captionBar = this.constructCaptionBar();
            domConstruct.place(captionBar, topDiv);            

            this.splitContainerDiv = this.constructSplitContainer();
            domClass.add(this.splitContainerDiv, "fixedDialogWidget plotOrderTemplateChooseSplitContainer");
            domConstruct.place(this.splitContainerDiv, topDiv);

            this.addressListWidget.restoreColumnWidths();
            this.itemListWidget.restoreColumnWidths();            
                            
            return topDiv;
        },

        constructCaptionBar : function() {
            this.captionBarDiv = domConstruct.create("div", null, null);
            domClass.add(this.captionBarDiv, "fixedDialogWidget plotOrderTemplateChooseCaptionBar");

            // Caption
            this.captionDiv = DOMHelper.createTextNode("span", "", this.captionBarDiv, "plotOrderTemplateChooseCaption");

    	    this.chooseButton = new Button({
    		  label : i18n.plotOrderTemplateChooseCreateButtonCaption,
    		  title : i18n.plotOrderTemplateChooseCreateButtonCaption,
    		onClick : lang.hitch(this, this.createPlotOrder) 
    	    });
    	    domClass.add(this.chooseButton.domNode, "plotOrderTemplateChooseButton");
    	    domConstruct.place(this.chooseButton.domNode, this.captionBarDiv);

            return this.captionBarDiv;
        },

        constructSplitContainer : function() {
            this.addressListWidget = new PlotOrderTemplateAddressListWidget({
                applicationContext : this.applicationContext
            });

            this.itemListWidget = new PlotOrderTemplateItemListWidget({
                applicationContext : this.applicationContext
            });                

            this.splitContainer = new SplitContainer({
                  widgets : [ this.addressListWidget, this.itemListWidget ],
                direction : SplitContainer.Direction.HORIZONTAL
            });   

            return this.splitContainer.getContainer();
        },

        resize : function(newSize) {
            // We need to perform the resize in two steps.
            // First set the desired width, and some arbitrary height.
            var width = newSize.w;
            this.splitContainer.resize({ w : width, h : 300 });

            // After we did that, the layout algorithm determined the height of the rows.
            // And now we can calculate the needed height.
            // (if we would try to calculate the height in the first step, calculation
            //  would be based on an invalid width).            
            var addressListHeight = this.addressListWidget.getActualHeight();
            var itemListHeight = this.itemListWidget.getActualHeight();
            var height = Math.max(addressListHeight, itemListHeight);
            this.splitContainer.resize({ w : width, h : height });

            var topDivHeight = this.captionBarDiv.offsetHeight + this.splitContainerDiv.offsetHeight + 30;
            domStyle.set(this.topDiv, "width", width + "px");
            domStyle.set(this.topDiv, "height", topDivHeight + "px");

        },

        setData : function(params) {
            this.documentVersionId = params.documentVersionId;
            this.templateJoin = params.templateJoin;
            this.itemJoins = params.itemJoins;
            this.reload();
        },

        reload : function() {
            this.updateWidgetsFromData();            
        },

        updateWidgetsFromData : function() {
            var captionString = string.substitute(i18n.plotOrderTemplateWidgetChooseCaption, {
                   plotOrderTemplateName : this.templateJoin.plottOrderTemplateName
            });

            DOMHelper.setInnerText(this.captionDiv, captionString);

            this.addressListWidget.setData({ templateJoins : [ this.templateJoin ] });
            this.itemListWidget.setData({ itemJoins : this.itemJoins });
        },

        updateWidgetState : function() {

        },

        createPlotOrder : function() {
            var pageParams = {
                  documentVersionId : this.documentVersionId,
                plotOrderTemplateId : this.templateJoin.plottOrderTemplateId
            };
            var extraParams = {
                  backPage : "plotOrderTemplateChoose",
                backParams : new Object()
            };                

            this.applicationContext.setPage("plotOrderSign", pageParams, extraParams);
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    return PlotOrderTemplateChooseWidget;
});
