/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = mspTreeUrlChoose
//// i18n-prefix = mspTreeUrlChoose



define([ 
    "cdes/planning/notification/SharepointTreeModel",
    "clazzes/ClazzesTree",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/dateTime/FancyDate",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ChooseDialog",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/TextBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",  
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
    SharepointTreeModel,
    ClazzesTree,
    TinyLog,
    DateHelper,
    FancyDate,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ChooseDialog,                
    ContentWidget,
    TextBox,
    domClass,
    domConstruct,
    domStyle,
    on,
    declare,
    lang,       
    i18n) {

        var className = "at.cdes.web.widget.msp.MspTreeUrlChooseDialog";

        var log = new TinyLog(className);

        var MspTreeUrlChooseDialog = declare(className, ChooseDialog, {

            constructChooseWidget : function() {
                // summary:
                //     Constructs the widget in which the user chooses some piece of data.
                // description:
                //     That widget must be saved in the variable this.content, and will 
                //     subsequently be placed in the dialog by superclass code.
                //     If some value is chosen by the user in that widget (e.g. a choosable 
                //     tree node is clicked), the subclass must call setChosenValue.  
                //     Optionally, after doing so, the subclass may emit the valueChosen 
                //     event, and close the dialog (e.g. on a double click into the tree).

                var topDiv = domConstruct.create("div", null, null);
                domClass.add(topDiv, "refNodeOfPositionAbsolute mspTreeUrlChooseTopDiv");

                // UrlTextBox
                DOMHelper.createTextNode("div", i18n.urlLabel, topDiv, "propertyLabel mspTreeUrlChooseUrlLabel");
                this.urlTextBox = new TextBox({
                    label : i18n.mspTreeUrlChooseUrlLabel,
                    title : i18n.mspTreeUrlChooseUrlToolTip
                });
                domClass.add(this.urlTextBox.domNode, "fixedDialogWidget mspTreeUrlChooseUrlTextBox");
                domConstruct.place(this.urlTextBox.domNode, topDiv);
                WidgetHelper.handleTextBoxEvents(this.urlTextBox, lang.hitch(this, this.updateWidgetState));
                WidgetHelper.handleTextBoxEvents(this.urlTextBox, lang.hitch(this, function() {
                    this.mspItem = null;
                    this.updateWidgetState();
                }));                    

                var treeDiv = domConstruct.create("div", null, null);
                domClass.add(treeDiv, "fixedDialogWidget mspTreeUrlChooseTreeDiv");
                domConstruct.place(treeDiv, topDiv);                

                // Tree
                this.treeModel = new SharepointTreeModel({
                    applicationContext : this.applicationContext,
                              metaTags : this.metaTags      
                });

                this.tree = new ClazzesTree({
                      showRoot : false,
                         model : this.treeModel,
                       persist : false,
                    autoExpand : false
                    //          dndController : myDnDSource
                });
                domClass.add(this.tree.domNode, "fixedDialogWidget mspTreeUrlChooseTree");
                domConstruct.place(this.tree.domNode, treeDiv);

                this.onTreeClickHandle = dojo.connect(this.tree, "onClick", lang.hitch(this, this.handleTreeClick));

                this.content = topDiv;
            },

                  handleTreeClick : function(item, node, event) {
                      this.mspItem = item;
                      this.urlTextBox.set("value", item.url, false);
                      this.updateWidgetState();                      
                  },

                updateWidgetState : function() {
                    if (this.selectButton != null) {
                        var selectedUrl = this.getTrimmedUrl();
                        this.selectButton.set("disabled", selectedUrl == null || selectedUrl.length == 0);
                    }
                },      

                  emitValueChosen : function(buttonName) {
                      on.emit(this, "valueChosen", {
                              url : this.getTrimmedUrl(),
                          mspItem : this.mspItem
                      });                          
                  },

        getTrimmedUrl : function() {
            var selectedUrl = this.urlTextBox.get("value");
            if (selectedUrl != null) {
                selectedUrl = selectedUrl.trim();
            }
            return selectedUrl;            
        },

                          destroy : function() {
                              this.inherited(arguments);
                          }
        });

        MspTreeUrlChooseDialog.AsyncOperation = {
        };                        

        return MspTreeUrlChooseDialog;
    });

