/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([
    "cdes/core/CdesVoc",
    "cdes/document/DocumentHelper",
    "cdes/util/ActionHelper",
    "cdes/util/CodeHelper",
    "cdes/util/FancyColumnResizer",
    "cdes/util/I18nHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "clazzes/widgets/DisableButton",
    "dgrid/Editor",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dijit/Tooltip",
    "dijit/form/CheckBox",
    "dojo/aspect",
    "dojo/dom-attr",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    CdesVoc,
    DocumentHelper,
    ActionHelper,
    CodeHelper,
    FancyColumnResizer,
    I18nHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    InfoDialog,
    DisableButton,
    Editor,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    Tooltip,
    CheckBox,
    aspect,
    domAttr,
    domClass,
    domConstruct,
    domStyle,
    ioQuery,
    on,
    string,
    declare,
    lang,
    Memory,
    Trackable,
    i18n
) {

    var className = "at.cdes.web.document.DocumentListWidget";

    var log = new TinyLog(className);

    var DocumentListWidget = declare(className, ListWidget, {

        dataAttributeName : "documentListRows",

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "DocumentListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "documentList/columnWidths",
        minWidth : 50,

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
//                     field : "documentNumber",
                     field : "_documentNumber",
                        id : "documentNumber",
                 formatter : lang.hitch(this, this.documentNumberFormatter),
                  sortable : true,
                     label : i18n.documentListNumberColumnCaption
            });

            columns.push({
                     field : "_documentVersionName",
                        id : "documentName",
                renderCell : lang.hitch(this, this.renderDocumentVersionName),
                  sortable : true,
                     label : i18n.documentListNameColumnCaption
            });

            columns.push({
                     field : "_documentContent",
                        id : "documentContent",
                renderCell : lang.hitch(this, this.renderDocumentContent),
                  sortable : true,
                     label : i18n.documentListTitleColumnCaption
            });

            columns.push({
                     field : "_objectPlanner",
                        id : "documentObjectPlannerId",
                renderCell : lang.hitch(this, this.renderObjectPlanner),
                  sortable : true,
                     label : i18n.documentObjectPlannerColumnCaption
            });

            columns.push({
//                     field : "documentId",
                     field : "key",
                        id : "file",
                renderCell : lang.hitch(this, this.renderFile),
                  sortable : false,
                     label : i18n.documentListFileColumnCaption
            });

            columns.push({
                    field : "_documentVersionUploaded",
                       id : "uploaded",
                formatter : lang.hitch(this, this.uploadedFormatter),
                 sortable : true,
                    label : i18n.documentListUploadedColumnCaption
            });

            columns.push({
                     field : "_statusString",
                        id : "status",
                renderCell : lang.hitch(this, this.renderStatus),
                  sortable : true,
                     label : i18n.documentListStatusColumnCaption
            });
            			
			if (this.mode != "asBuiltMode") {
	            columns.push({
	//                     field : "documentVersionId",
	                     field : "_delay",
	                        id : "reviewStatus",
	                renderCell : lang.hitch(this, this.renderReviewStatus),
	                  sortable : true,
	                     label : i18n.documentListReviewStatusColumnCaption
	            });
	
	            columns.push({
	//                     field : "documentId",
	                     field : "key",
	                        id : "actions",
	                renderCell : lang.hitch(this, this.renderActionCell),
	                  sortable : false,
	                     label : i18n.actionColumnCaption
	            });
			}
            
			if (this.mode === "asBuiltMode") {
	            columns.push({
	                   field : "_selection",
	                      id : "selection",
	                sortable : false,
	                   label : i18n.planningNotificationTaskSelectionColumnLabel,
	                  editor : CheckBox,
      				 canEdit : lang.hitch(this, this.selectionEnabled)
	            });
			}

            return columns;
        },

     	documentNumberFormatter : function(key, documentListRow) {
            return documentListRow.document.number;
    	},

        selectionEnabled : function(documentListRow) {
			if (this.mode === "asBuiltMode" && (documentListRow.documentVersion != null && (documentListRow.alreadyCopied 
            				|| documentListRow.duplicatedName || !documentListRow.hasValidLabel))){
            	return false;
			} else {
            	return true;
        	}
		},
			
        renderDocumentVersionName : function(documentListRow, data, cell) {

            if (documentListRow.documentVersion.id == null) {
                var name = (documentListRow.documentRelease.id != null
                            ? documentListRow.documentRelease.name
                            : documentListRow.document.name);
                var cellDiv = domConstruct.create("div", null, null);
                DOMHelper.setInnerText(cellDiv, name);
                return cellDiv;
            } else {
                var cellDiv = domConstruct.create("div", null, null);
                var documentVersionName = documentListRow.documentVersion.name;

                var documentVersionNameSpan = DOMHelper.createTextNode("div", documentVersionName, cellDiv, "documentListDocumentVersionNameSpan");
                if (documentListRow._showAllVersions) {
                    domAttr.set(documentVersionNameSpan, "title", i18n.documentListDocumentVersionNameShowHideAllVersionsToolTip);
                } else {
                    domAttr.set(documentVersionNameSpan, "title", i18n.documentListDocumentVersionNameShowAllVersionsToolTip);
                }
                on(documentVersionNameSpan, "click", lang.hitch(this, function() {
                    if (documentListRow.documentVersion != null && documentListRow.documentVersion.id != null) {
                        documentListRow._showAllVersions = !documentListRow._showAllVersions;
                        if (documentListRow._showAllVersions && documentListRow._formerVersions == null) {
                            this.loadFormerVersions(documentListRow.key, documentListRow.documentVersion.id);
                        } else {
                            this.grid.refresh();
                        }
                    }
                }));

                var alternativeName = documentListRow.documentVersion.alternativeName;
                if (alternativeName != null && alternativeName.length > 0) {
                     DOMHelper.createTextNode("div", alternativeName, cellDiv, "documentListDocumentVersionAlternativeNameSpan");
                }

                if (documentListRow._showAllVersions) {
                    var formerVersions = documentListRow._formerVersions;
                    for (var n = 0; n < formerVersions.length; n++) {
                        var formerVersion = formerVersions[n];
                        var versionParta = formerVersion.versionParta != null ? formerVersion.versionParta : "";
                        var versionPartSeparator = formerVersion.versionPartSeperator != null ? formerVersion.versionPartSeperator : "";
                        var versionPartb = formerVersion.versionPartb != null ? formerVersion.versionPartb : "";
                        var versionString = string.substitute(i18n.documentListFormerDocumentVersionLabel, {
                            version : versionParta + versionPartSeparator + versionPartb
                        });

                        var formerVersionClass = "";
                        var formerVersionStatus = formerVersion.status;
                        if (formerVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
                             || formerVersionStatus == CdesVoc.DocumentVersionStatus.DELETED
                             || formerVersionStatus == CdesVoc.DocumentVersionStatus.REPLACED) {
                                formerVersionClass = "documentListFormerVersionInvalidated";
                        } else if (formerVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDALL) {
                            formerVersionClass = "documentListFormerVersionInvalidatedAll";
                        }

                        DOMHelper.createTextNode("div", versionString, cellDiv, "documentListFormerVersionVersion " + formerVersionClass);

                        if (formerVersion.alternativeName != null) {
                            DOMHelper.createTextNode("div", formerVersion.alternativeName, cellDiv, "documentListFormerVersionAlternativeName " + formerVersionClass);
                        }
                    }
                }
            }

// style="ognl:(formerVersion.invalidated||formerVersion.deleted||formerVersion.status==12)?'text-align:right; text-decoration:line-through;':formerVersion.invalidatedAll?'text-align:right; text-decoration:line-through;  color: maroon;':'text-align:right'">Version <span jwcid="@Insert" value="ognl:formerVersion.versionPart"/>

            return cellDiv;
        },

        renderDocumentContent : function(documentListRow, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);

            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            if (this.contentLocales == null) {
                var defaultTranslation = I18nHelper.getCurrentLocaleString(data, locale);
                DOMHelper.createTextNode("div", defaultTranslation, cellDiv, "");
            } else {
                var localeToTranslation = I18nHelper.getLocaleMap(data, locale);

                var s = "";

                for (var n = 0; n < this.contentLocales.length; n++) {
                    var contentLocale = this.contentLocales[n];
                    var translation = localeToTranslation[contentLocale];
                    if (translation != null && translation.length > 0) {
                        DOMHelper.createTextNode("div", translation, cellDiv, "");
                    }
                }
            }
            return cellDiv;
        },

        loadFormerVersions : function(key, documentVersionId) {
            this.registerAsyncOperationStarted(DocumentListWidget.AsyncOperation.LOAD_FORMER_VERSIONS);

            // TODO: Can, in future, probably be done based on documentListRow

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var documentService = this.applicationContext.getService("documentService");
            documentService.getFormerVersions(organisationPersonId, documentVersionId).then(
                lang.hitch(this, function(formerVersions) {
                    this.registerAsyncOperationFinished(DocumentListWidget.AsyncOperation.LOAD_FORMER_VERSIONS);

                    formerVersions.sort(function(versionOne, versionTwo) {
                        return versionTwo.uploaded - versionOne.uploaded;
                    });

                    var documentListRow = this.keyToListRow[key];
                    documentListRow._formerVersions = formerVersions;
                    this.grid.refresh();
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DocumentListWidget.AsyncOperation.LOAD_FORMER_VERSIONS,
                                opName : "getFormerVersions",
                               message : i18n.documentListWidgetGetFormerVersionsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getFormerVersions]", err);
                    }));
        },

        renderObject : function(documentListRow, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);

            var label = this.getObjectLabel(documentListRow);
            DOMHelper.createTextNode("span", label, buttonDiv, "");

            return buttonDiv;
        },

        renderObjectPlanner : function(documentListRow, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);

            var objectLabel = this.getObjectLabel(documentListRow);
            DOMHelper.createTextNode("span", objectLabel + " ", buttonDiv, "");

            var objectPlannerLabel = this.getObjectPlannerLabel(documentListRow);
            DOMHelper.createTextNode("span", objectPlannerLabel, buttonDiv, "");


    	    if (this.applicationContext.isActionAllowedForProject("showObjectPlanner")) {
	    		var showObjectPlannerButton = this.constructShowObjectPlannerButton(documentListRow, "showObjectPlanner");
	    		domConstruct.place(showObjectPlannerButton.domNode, buttonDiv);
    	    } else if (ActionHelper.hasObjectPlannerPermission(documentListRow._objectPlannerIdToActions, documentListRow.objectPlanner.id, "showObjectPlannerOPContext")) {
	    		var showObjectPlannerButton = this.constructShowObjectPlannerButton(documentListRow, "showObjectPlannerOPContext");
	    		domConstruct.place(showObjectPlannerButton.domNode, buttonDiv);
    	    }

            return buttonDiv;
        },

        getObjectLabel : function(documentListRow) {
            if (documentListRow.objectRelease != null) {
                return documentListRow.objectRelease.code + (documentListRow.objectReleaseObjectType!=null?documentListRow.objectReleaseObjectType.code:"");
            } else {
                return documentListRow.object.code;
            }
        },

        getObjectPlannerLabel : function(documentListRow) {
            if (documentListRow.objectPlannerRelease.code != null
                && documentListRow.instanceReleasedInfo.instanceReleased.name != null) {
                return string.substitute(i18n.documentListObjectPlannerLabel, {
                           objectPlannerReleaseCode : documentListRow.objectPlannerRelease.code,
                    reviewCycleInstanceReleasedName : documentListRow.instanceReleasedInfo.instanceReleased.name
                });
            } else {
                return documentListRow.objectPlanner.code;
            }
        },

    	constructShowObjectPlannerButton : function(documentListRow, actionName) {
            var button = new FancyButton({
                    title : i18n.planDeliverListShowObjectPlannerButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 showObjectPlanner"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
    	        this.doShowObjectPlanner(documentListRow, actionName);
            }));

            return button;
    	},

    	doShowObjectPlanner : function(documentListRow, actionName) {
            var documentVersionId = documentListRow.documentVersion != null && documentListRow.documentVersion.id != null
                ? documentListRow.documentVersion.id : null;
            var documentId = documentListRow.documentVersion != null && documentListRow.documentVersion.id != null
                ? null : documentListRow.document.id;

            if (documentVersionId != null) {
                window.parent.postMessage({
                    action : "routerPush",
                 routerObj : {
		                name : "objectPlannerReleaseShowDocumentVersion",
		              params : {
		                   documentVersionId : documentVersionId,
	                    			fromPage : "DocumentListWidget"
		                }
                    }
                });
            } else {
                window.parent.postMessage({
                    action : "routerPush",
                    routerObj : {
                        name : "objectPlannerReleaseShowDocument",
                        params : {
                            documentId : documentId,
                            fromPage : "DocumentListWidget"
                        }
                    }
                });
            }

            /*
    		document.location.href = "/cdes/app?service=SecureDirectService/1/DocumentList/" + actionName + "/$SecureDirectLink&sp="
    			+ documentListRow.objectPlannerRelease.id + "&ts=" + dojoConfig.tabSessionId;
            */

    	},

        renderFile : function(documentListRow, data, cell) {
            // description:
            //     Needed fields in documentListJoin:
            //       - documentVersionFiletype
            //       - documentVersionStatus
            //       - documentObjectPlannerId
            //       - subProjectInvalidated
            //       - previewSupportDocumentVersionId (if null, the comparison button just won't be shown)
            //       - _objectPlannerIdToActions

            if (documentListRow.documentVersion.id != null) {
                return DocumentHelper.renderFileButtons({
                                           documentListRow : documentListRow,
                                        applicationContext : this.applicationContext,
                     checkForInvalidDocumentVersionPreview : false,
                    checkForInvalidDocumentVersionDownload : true
                });
            } else {
                var cellDiv = domConstruct.create("div", null, null);
                return cellDiv;
            }
        },

     	uploadedFormatter : function(uploaded, documentListRow) {
    	    if (uploaded != null) {
    		return DateHelper.formatUtcSecondsWithTimeZone(uploaded, this.applicationContext.getTimeZone(), i18n.datePattern);
    	    } else {
    		return "";
    	    }
    	},

        getDocumentVersionNameString : function(documentListRow) {
	    if (documentListRow.documentVersion != null && documentListRow.documentVersion.id == null) {
                var name = (documentListRow.documentRelease != null && documentListRow.documentRelease.id != null
                            ? documentListRow.documentRelease.name
                            : documentListRow.document.name);
                return name;
            } else {
	        return documentListRow.documentVersion.name;
            }
        },

        getNodeResultInfoWithMaxArrivalDate : function(documentListRow) {
            var nodeId = documentListRow.reviewCycleNodeInstance.reviewCycleNodeId;
            var idToCellResultInfo = documentListRow.idToCellResultInfo;
            var chosenNodeResultInfo = null;
            for (var id in idToCellResultInfo) {
                var cellResultInfo = idToCellResultInfo[id];
                for (var n = 0; n < cellResultInfo.nodeResultInfos.length; n++) {
                    var nodeResultInfo = cellResultInfo.nodeResultInfos[n];
                    if (nodeResultInfo.node.id == nodeId &&
                        (chosenNodeResultInfo == null
                         || nodeResultInfo.nodeResult.arrivalDate > chosenNodeResultInfo.nodeResult.arrivalDate)) {
                        chosenNodeResultInfo = nodeResultInfo;
                    }
                }
            }
            return chosenNodeResultInfo;
        },

        getPositionResultInfoWithMaxResultDate : function(nodeResultInfo) {
            var chosenPositionResultInfo = null;
            for (var n = 0; n < nodeResultInfo.positionResultInfos.length; n++) {
                var positionResultInfo = nodeResultInfo.positionResultInfos[n];
                if (chosenPositionResultInfo == null
                    || positionResultInfo.positionResult.resultDate > chosenPositionResultInfo.positionResult.resultDate) {
                    chosenPositionResultInfo = positionResultInfo;
                }
            }
            return chosenPositionResultInfo;
        },

        getResultOptionById : function(resultOptionId) {
			if (this.resultOptions == null)
				return null;
            for (var n = 0; n < this.resultOptions.length; n++) {
                if (this.resultOptions[n].id == resultOptionId) {
                    return this.resultOptions[n];
                }
            }
            return null;
        },

        getCellById : function(cellId) {
            return this.cycleInfo.idToCell[cellId];
        },

		getStatusSortString : function(documentListRow) {
		    var sortString = "";
	        if (documentListRow.documentVersion == null || documentListRow.documentVersion.id == null) {
				sortString += i18n.documentVersionStatusNotUploaded;
				return sortString;
	        }

            var statusString = CodeHelper.getDocumentVersionStatusString(documentListRow.documentVersion.status);
	    	sortString += statusString;

            var effectiveEndDate = null;
            var latestNodeResult = documentListRow.latestNodeResult;
            var latestPositionResult = documentListRow.latestPositionResult;
            if (documentListRow.documentVersion != null
                && documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV) {

                if (latestPositionResult == null || latestPositionResult.reviewCycleResultOptionId == null) {
                    if (latestNodeResult != null) {
                        effectiveEndDate = latestNodeResult.arrivalDate;
                    }
                } else {
                    var resultOptionId = latestPositionResult.reviewCycleResultOptionId;
                    var resultOption = this.getResultOptionById(resultOptionId);
                    if (resultOption != null && resultOption.documentVersionStatus == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV) {
                        effectiveEndDate = latestPositionResult.resultDate;
                    }
                }
            }

            if (effectiveEndDate != null) {
				sortString += "_" + effectiveEndDate;	
            }

            if (latestNodeResult != null && documentListRow.documentVersion != null && documentListRow.documentVersion.id != null
                && documentListRow.documentVersion.status != CdesVoc.DocumentVersionStatus.INVALIDATEDALL) {
                var nodeId = latestNodeResult.reviewCycleNodeId;
                var node = this.cycleInfo.idToNode[nodeId];
                var positionTypeId = node.reviewCyclePositionTypeId;
                var isEndNode = true;
                for (var n = 0; n < this.resultOptions.length; n++) {
                    if (this.resultOptions[n].reviewCyclePositionTypeId == positionTypeId) {
                        isEndNode = false;
                    }
                }

                var cell = this.getCellById(node.reviewCycleCellId);
                var endOfReviewCycle = cell.isEndCell && isEndNode;
                var inAction = CodeHelper.isDocumentVersionStatusInAction(documentListRow.documentVersion.status);

                if (!endOfReviewCycle
                    || (endOfReviewCycle && inAction)
                    || (documentListRow.documentVersion.uploaded == null
                        && documentListRow.documentRelease.id != null
                        && documentListRow.documentRelease.startDate != null)) {

                    var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                    var reviewCycleCellName = I18nHelper.getCurrentLocaleString(cell.name, locale);
                    var reviewCycleNodeName = I18nHelper.getCurrentLocaleString(node.name, locale);
		    		sortString += "_" + reviewCycleCellName + "-" + reviewCycleNodeName;
                }
            }

            if (documentListRow.revisedDocumentVersion != null
                && documentListRow.revisedDocumentVersion.status == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV
                && documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.INREVIEW) {
				sortString += "_" + i18n.documentListReleasedVersionStillValidLabel;
            }

		    return sortString;			
		},

        renderStatus : function(documentListRow, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            if (documentListRow.documentVersion.id == null) {
                DOMHelper.setInnerText(cellDiv, i18n.documentVersionStatusNotUploaded);
                return cellDiv;
            }

            var statusString = CodeHelper.getDocumentVersionStatusString(documentListRow.documentVersion.status);
            DOMHelper.createTextNode("div", statusString, cellDiv, "");

            var latestNodeResult = documentListRow.latestNodeResult;
            var latestPositionResult = documentListRow.latestPositionResult;

            var effectiveEndDate = null;
            if (documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV) {
                if (latestPositionResult == null || latestPositionResult.reviewCycleResultOptionId == null) {
                    if (latestNodeResult != null) {
                        effectiveEndDate = latestNodeResult.arrivalDate;
                    }
                } else {
                    var resultOptionId = latestPositionResult.reviewCycleResultOptionId;
                    var resultOption = this.getResultOptionById(resultOptionId);
                    if (resultOption != null && resultOption.documentVersionStatus == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV) {
                        effectiveEndDate = latestPositionResult.resultDate;
                    }
                }
            }

            if (effectiveEndDate != null) {
                var effectiveEndDateString = "[" + DateHelper.formatUtcSecondsWithTimeZone(effectiveEndDate, this.applicationContext.getTimeZone(), i18n.datePattern) + "]";
                DOMHelper.createTextNode("div", effectiveEndDateString, cellDiv, "");
            }

            if (documentListRow.latestNodeResult != null && documentListRow.documentVersion != null && documentListRow.documentVersion.id != null
                	&& this.cycleInfo != null && this.resultOptions != null && documentListRow.documentVersion.status != CdesVoc.DocumentVersionStatus.INVALIDATEDALL) {
                var nodeId = documentListRow.latestNodeResult.reviewCycleNodeId;
                var node = this.cycleInfo.idToNode[nodeId];
                var positionTypeId = node.reviewCyclePositionTypeId;
                var isEndNode = true;
                for (var n = 0; n < this.resultOptions.length; n++) {
                    if (this.resultOptions[n].reviewCyclePositionTypeId == positionTypeId) {
                        isEndNode = false;
                    }
                }

                var cell = this.getCellById(node.reviewCycleCellId);
                var endOfReviewCycle = cell.isEndCell && isEndNode;
                var inAction = CodeHelper.isDocumentVersionStatusInAction(documentListRow.documentVersion.status);

                if (!endOfReviewCycle
                    || (endOfReviewCycle && inAction)
                    || (documentListRow.documentVersion.uploaded == null
                        && documentListRow.documentRelease.id != null
                        && documentListRow.documentRelease.startDate != null)) {

                    var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                    var reviewCycleCellName = I18nHelper.getCurrentLocaleString(cell.name, locale);
                    var reviewCycleNodeName = I18nHelper.getCurrentLocaleString(node.name, locale);
                    DOMHelper.createTextNode("div", reviewCycleCellName + " \u2015 " + reviewCycleNodeName, cellDiv, "");
                }
            }

            if (documentListRow.revisedDocumentVersion != null
                && documentListRow.revisedDocumentVersion.status == CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV
                && documentListRow.documentVersion != null
                && documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.INREVIEW) {
                    DOMHelper.createTextNode("div", i18n.documentListReleasedVersionStillValidLabel, cellDiv, "");
            }

            return cellDiv;
        },

        renderReviewStatus : function(documentListRow, data, cell) {
            var documentId = documentListRow.document.id;

            var cellDiv = domConstruct.create("div", null, null);
            if (this.documentIdToReviewStatusSvg != null && documentId in this.documentIdToReviewStatusSvg) {
                cellDiv.innerHTML = this.documentIdToReviewStatusSvg[documentId];

                var toolTipString = (this.documentIdToReviewStatusToolTip != null
                                     && documentId in this.documentIdToReviewStatusToolTip)
                    ? this.documentIdToReviewStatusToolTip[documentId] : null;
                if (toolTipString != null) {
    	            var toolTip = new Tooltip({
    		        connectId : [cellDiv],
    		        label     : toolTipString
    	            });
    	    	    on(toolTip.domNode, "mouseleave", lang.hitch(this, function(event) {
   	    	        toolTip._onUnHover();	
    	    	    }))                
                }
            }

            return cellDiv;
        },

        renderActionCell : function(documentListRow, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);
            var objectPlannerId = documentListRow.objectPlanner.id;
            var actions = objectPlannerId in this.objectPlannerIdToActions
                ? this.objectPlannerIdToActions[objectPlannerId] : new Object();

            if (this.mode === "select") {
                domConstruct.place(this.constructSelectButton(documentListRow).domNode, buttonDiv)
                return buttonDiv;
            }


/*
<span jwcid="@Conditional" condition="ognl:directPlotPossible && !(documentVersion.document.objectPlanner.inactive && documentVersion.invalidatedAll) && !subProject.readOnly && !documentVersion.document.objectPlanner.object.readOnly">
*/
            if (this.directPlotPossible
                && !(documentListRow.objectPlanner.inactive
                     && documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.INVALIDATEDALL)
                && !documentListRow.subProject.readOnly
                && !documentListRow.object.readOnly && documentListRow.documentVersion.id != null
                && actions != null
                && ("requestManualPlotOwnRecipient" in actions
                    || "requestManualPlotAllRecipients" in actions
                    || "requestManualPlotAllRights" in actions
                    || "requestManualPlotOwnRecipientOPContext" in actions
                    || "requestManualPlotAllRecipientsOPContext" in actions
                    || "requestManualPlotAllRightsOPContext" in actions)) {
                    var requestManualPlotButton = this.constructRequestManualPlotButton(documentListRow);
                    domConstruct.place(requestManualPlotButton.domNode, buttonDiv);
            }
/*
<span jwcid="@Conditional" condition="ognl:!(documentVersion.document.objectPlanner.inactive && documentVersion.invalidatedAll) && !subProject.readOnly && !documentVersion.document.objectPlanner.object.readOnly">
*/
            if (!(documentListRow.objectPlanner.inactive
                  && documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.INVALIDATEDALL)
                && !documentListRow.subProject.readOnly
                && !documentListRow.object.readOnly && documentListRow.documentVersion.id != null
                && actions != null
                && ("requestOriginalDocument" in actions || "requestOriginalDocumentOPContext" in actions)) {
	                var requestOriginalButton = this.constructRequestOriginalButton(documentListRow);
	                domConstruct.place(requestOriginalButton.domNode, buttonDiv);
            }

            if (!(documentListRow.objectPlanner.inactive
                  && documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.INVALIDATEDALL)
                && !documentListRow.subProject.readOnly
                && !documentListRow.object.readOnly && documentListRow.documentVersion.id != null
                && actions != null
                && ("reviewProtocoll" in actions || "reviewProtocollOPContext" in actions)) {

                //new version
	            var reviewProtocolButton = this.constructOpenReviewProtocolButton(documentListRow);
	            domConstruct.place(reviewProtocolButton.domNode, buttonDiv);
		        //old version
		        if ("deleteTask" in actions){
				    var reviewProtocolOldButton = this.constructOpenReviewProtocolOldButton(documentListRow);
				    domConstruct.place(reviewProtocolOldButton.domNode, buttonDiv);
	        	}
            }

            // The conditions for the Status U and Status X buttons in old code overlap.
            // For clarity, we calculate both separately, and then make the OR.
            // Background: The two buttons have been joined in new code.
            var documentVersionStatus = documentListRow.documentVersion != null ? documentListRow.documentVersion.status : null;
            var statusUAllowed = documentListRow.documentVersion != null && documentListRow.documentVersion.id != null
                && !documentListRow.subProject.readOnly
                && !documentListRow.object.readOnly
                && documentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDALL
                /*&& "invalidateDocument" in this.projectActions*/
                && !this.isReleasedVersionOfRevision(documentListRow)
                && ("invalidateDocument" in actions || "invalidateDocumentOPContext" in actions);

            var statusXAllowed = documentListRow.documentVersion != null && documentListRow.documentVersion.id != null
                && !documentListRow.subProject.readOnly
                && !documentListRow.object.readOnly
                && ("invalidateDocumentVersion" in actions || "deleteDocumentVersion" in actions)
                /*&& "invalidateDocument" in this.projectActions*/
                && documentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDALL
                && documentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
                && documentVersionStatus != CdesVoc.DocumentVersionStatus.DELETED
                && documentVersionStatus != CdesVoc.DocumentVersionStatus.RELEASEDNEGATIV;

        
            if (statusUAllowed || statusXAllowed) {
                var invalidateDocumentButton = this.constructInvalidateDocumentButton(documentListRow);
                domConstruct.place(invalidateDocumentButton.domNode, buttonDiv);
            }
            
            //upload Button
            if (((!documentListRow.document.hasDocumentVersions || documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.DELETED) 
                || (!documentListRow.document.hasDocumentVersions && documentListRow.documentVersion.status != CdesVoc.DocumentVersionStatus.INVALIDATEDALL))
                && "uploadDocument" in actions) {  
                    var uploadButton = this.constructUploadButton(documentListRow);
                    domConstruct.place(uploadButton.domNode, buttonDiv);
            }

            return buttonDiv;
        },

        isReleasedVersionOfRevision : function(documentListRow) {
            // Replacement for at.cdes.tapestry.pages.review.ReviewCycleStatusOverview.createEntry(Integer)

            // TODO: Check wether we implemented this correctly (compare with old code).
            //       Especially, the id<0-condition in old code is unclear to me.
            // See at.cdes.impl.service.DocumentServiceImpl.constructDocumentListRows
            // at server side for this TODO
            return documentListRow.isReleasedVersionOfRevision;
        },

        constructRequestManualPlotButton : function(documentListRow) {
	    var button = new FancyButton({
		    title : i18n.documentListRequestManualPlotToolTip,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 plotOrderManualButton"
	    });

	    domClass.add(button.domNode, "listButton");

	    on(button, "click", lang.hitch(this, function() {
     		this.applicationContext.setPage("plotOrderTemplateChoose", {
     		    documentVersionId : documentListRow.documentVersion.id
                }, {
		      backPage : this.backPage,
		    backParams : this.backParams
     		});
	    }));

	    return button;
        },

        constructRequestOriginalButton : function(documentListRow) {
	    var button = new FancyButton({
		    title : i18n.documentListRequestOriginalToolTip,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 requestOriginalButton"
	    });

	    domClass.add(button.domNode, "listButton");

	    on(button, "click", lang.hitch(this, function() {
     		this.applicationContext.setPage("requestOriginalDocument", {
     		    documentVersionId : documentListRow.documentVersion.id
                }, {
		      backPage : this.backPage,
		    backParams : this.backParams
     		});
	    }));

	    return button;
        },

        constructOpenReviewProtocolButton : function(documentListRow) {
	    var button = new FancyButton({
		    title : i18n.openReviewProtocolToolTip,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 reviewProtocolButton"
	    });

	    domClass.add(button.domNode, "listButton");

	    on(button, "click", lang.hitch(this, function(e) {
            if (e.ctrlKey) {
                var paramsObject = {
                    ts : dojoConfig.tabSessionId
                };
                var hashObject = {
                    page : "reviewProtocol",
                    documentVersionId : documentListRow.documentVersion.id
                };
                var paramsString = ioQuery.objectToQuery(paramsObject);
                var hashString = ioQuery.objectToQuery(hashObject);
                window.open("/cdes/frame.html?" + paramsString + "#" + hashString);
            } else {
	 			this.applicationContext.setPage("reviewProtocol", {
	     	    documentVersionId : documentListRow.documentVersion.id
	        }, {
			    backPage : this.backPage,
			    backParams : this.backParams
	     	});
            }
	    }));
	    return button;
        },

	    //old version of ReviewProtocol
        constructOpenReviewProtocolOldButton : function(documentListRow) {
		    var button = new FancyButton({
			    title : i18n.openReviewProtocolOldToolTip,
			iconClass : "fancyButtonIcon17x18 fancyButton17x18 reviewProtocolOldButton"
		    });

		    domClass.add(button.domNode, "listButton");

		    on(button, "click", lang.hitch(this, function() {
	    		document.location.href = "/cdes/app?service=SecureDirectService/1/DocumentList/reviewProtocoll/openReviewProtocoll&sp="
	    			+ documentListRow.documentVersion.id + "&ts=" + dojoConfig.tabSessionId;
		    }));
		    return button;
        },

        constructSelectButton : function(documentListRow) {
		    var button = new FancyButton({
			    title : i18n.documentListChooseToolTip,
			iconClass : "fancyButtonIcon17x18 fancyButton17x18 showButton"
		    });

		    domClass.add(button.domNode, "listButton");

		    on(button, "click", lang.hitch(this, function() {
                        document.dispatchEvent(new CustomEvent("select", {
                    detail: {
                        documentVersionId: documentListRow.documentVersion.id,
                        title: documentListRow.documentVersion.name + " " + documentListRow.document.content + " (Projekt " + documentListRow.project.code + ")",
                    },
                }));
		    }));
		    return button;
        },

        constructInvalidateDocumentButton : function(documentListRow) {
            var button = new FancyButton({
                    title : i18n.documentListInvalidateDocumentToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 planInvalidStatusUButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
     		this.applicationContext.setPage("documentInvalidatePage", {
     		    	documentVersionId : documentListRow.documentVersion.id
                }, {
		      		backPage : this.backPage,
		    		backParams : this.backParams
     			});
            }));
            return button;
        },
        
        constructUploadButton : function(documentListRow) {
            return new DisableButton({
                           label : i18n.planDeliverListUploadButtonLabel,
                       showLabel : false,
                           title : i18n.planDeliverListUploadButtonToolTip,
                         onClick : lang.hitch(this, function() {
                             		this.uploadDocument(documentListRow);
                         }),
                       iconClass : "uploadButton",
                		 "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });             
        },
        
        uploadDocument : function(documentListRow) {
            var originWithoutPort = window.location.protocol + '//' + window.location.hostname;
            var msgObj = {
                action : "routerPush",
                page : "uploadFile",
                documentId : documentListRow.document.id
            };

            window.parent.postMessage(msgObj, window.origin);
        },

        updateIndividualColumns : function() {
			
            //this.updateColumn("selection", (this.mode === "asBuiltMode" || this.mode === "asBuiltModeSave")? true : false);
        },

        constructTopDiv : function() {
            var grid = this.constructGrid({
//		                idProperty : "document.id", 
		                idProperty : "key", 
		                    gridId : this.gridId != null ? this.gridId : "DocumentListGrid",
		                   modules : [ Editor ],
		                 gridClass : "OnDemandGrid" //"Grid"
            });

			on(this.grid, "dgrid-sort", lang.hitch(this, function(e) {
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				var networkId = this.applicationContext.getPageContextNetworkId();
				this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/documentList/sort", e.sort);
			}));

    	    on(this.grid, "dgrid-datachange", lang.hitch(this, function(e) {
	    		var column = e.cell && e.cell.column ? e.cell.column.id : null;
	    		var rowId = e.cell && e.cell.row ? e.cell.row.id : null;    			    			
	    			
	    		// DnDCellWidget uses values { value, rowId }.
	    		var newValue = !!e.value;
                if (e.cell.row.data._selected != newValue) {
                    e.cell.row.data._selected = !!newValue;
                    on.emit(this, "selectionChanged");
                }
            }));                

    	    aspect.after(this.grid, "renderRow", lang.hitch(this, function(row, args) {
	    		var documentListRow = args[0];
	    		this.updateRowClass(row, documentListRow);
	    		return row;
    	    }));

            return grid;
        },

        setContentLocales : function(contentLocales) {
            this.contentLocales = contentLocales;
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            var documentListRows = params.documentListRows;
            this.documentIdToReviewStatusSvg = params.documentIdToReviewStatusSvg;
            this.documentIdToReviewStatusToolTip = params.documentIdToReviewStatusToolTip;
            this.documentIdToDelay = params.documentIdToDelay;
            this.resultOptions = params.resultOptions;
            this.cycleInfo = params.cycleInfo;
            this.objectPlannerIdToActions = params.objectPlannerIdToActions;

            this.projectActions = new Object();
            if (params.projectActions != null) {
                for (var n = 0; n < params.projectActions.length; n++) {
                    this.projectActions[params.projectActions[n]] = true;
                }
            }
            
            this.directPlotPossible = params.directPlotPossible;
            this.enableCustomerLogo = params.enableCustomerLogo;
            this.isSubProjectAsBuiltType = params.isSubProjectAsBuiltType;

            this.documentListRows = [];
            this.keyToListRow = new Object();
            for (var n = 0; n < documentListRows.length; n++) {
                var documentListRow = documentListRows[n];
                var documentVersionId = documentListRow.documentVersion.id;
                documentListRow._documentNumber = documentListRow.document.number;
				documentListRow._documentVersionName = this.getDocumentVersionNameString(documentListRow);
                documentListRow._objectPlannerIdToActions = this.objectPlannerIdToActions;
				documentListRow._statusString = (this.cycleInfo != null && this.resultOptions != null) ? this.getStatusSortString(documentListRow) : null;
                documentListRow._delay = documentListRow.document.id != null && this.documentIdToDelay != null
                    && documentListRow.document.id in this.documentIdToDelay
                    ? this.documentIdToDelay[documentListRow.document.id] : 999999999; // TODO
                this.documentListRows.push(documentListRow);
                var key = documentListRow.key;
                this.keyToListRow[key] = documentListRow;
            }

            this.updateAuxiliaryData();

            this.reload();
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.documentListRows.length; n++) {
                var documentListRow = this.documentListRows[n];
                this.updateAuxiliaryDataForJoinDto(documentListRow);
            }
        },

        updateAuxiliaryDataForJoinDto : function(documentListRow) {
	    	documentListRow.id = this.getRowId(documentListRow);
            documentListRow._documentContent = documentListRow.documentRelease.id != null
                ? documentListRow.documentRelease.content : documentListRow.document.content;
            documentListRow._objectPlanner = this.getObjectPlannerLabel(documentListRow);
            documentListRow._documentVersionUploaded = documentListRow.documentVersion != null ? documentListRow.documentVersion.uploaded : null;
        },

        reload : function(params) {
            this.store.setData(this.documentListRows);
		    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		    var networkId = this.applicationContext.getPageContextNetworkId();
		    var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/documentList/sort");
	
		    if (oldSort == null) {
				this.grid.set("sort", "documentVersionName", false);
				this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/documentList/sort", this.grid.get("sort"));
		    } else {
				this.grid.set("sort", oldSort);
		    }
            
            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
        },
        
    	updateRowClass : function(domNode, documentListRow) {
    	    domClass.remove(domNode, "documentVersionStatusU");
    	    domClass.remove(domNode, "documentVersionStatusX");
    	    domClass.remove(domNode, "documentVersionStatusUObjectPlannerDeleted");

            if (documentListRow.objectPlanner.inactive && documentListRow.documentVersion != null
                && documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.INVALIDATEDALL) {
                domClass.add(domNode, "documentVersionStatusUObjectPlannerDeleted");
            } else if (documentListRow.documentVersion != null
                       && (documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
                           || documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.DELETED)) {
                domClass.add(domNode, "documentVersionStatusX");
            } else if (documentListRow.documentVersion != null
                       && documentListRow.documentVersion.status == CdesVoc.DocumentVersionStatus.INVALIDATEDALL) {
                domClass.add(domNode, "documentVersionStatusU");
            } else if (this.mode === "asBuiltMode" && (documentListRow.documentVersion != null && (documentListRow.alreadyCopied 
            				|| documentListRow.duplicatedName || !documentListRow.hasValidLabel))) {
                domClass.add(domNode, "documentVersionAlreadyCopied");
                var cellId = this.getCellById(documentListRow.reviewCycleNodeInstance.reviewCycleNodeId);
                
        		var nodes = this.grid.contentNode.children;
	            for (var n = 0; n < nodes.length; n++) {
	                var node = nodes[n];
	                var row = this.grid.row(node);
	
	                var cell = row != null ? this.grid.cell(row, "selection") : null;
	                var cellElement = cell != null ? cell.element : null;                
	                var checkBox = cellElement != null ? cellElement.widget : null;
	                if (checkBox != null)
	                    checkBox.set("disabled", true);                         
				}
            }
    	},

        isSelected : function(key) {
            var documentListRow = this.keyToListRow[key];
            return documentListRow != null && !!documentListRow._selected;            
        },
    	
        isAnyTokenSelected : function() {
            for (var n = 0; this.documentListRows && n < this.documentListRows.length; n++) {
                var documentListRow = this.documentListRows[n];
                if (documentListRow._selected) {
                    return true;
                }     
            }
            return false;            
        },            

        selectAll : function(selected) {
            var nodes = this.grid.contentNode.children;
            for (var n = 0; n < nodes.length; n++) {
                var node = nodes[n];
                var row = this.grid.row(node);

                var cell = row != null ? this.grid.cell(row, "selection") : null;
                var cellElement = cell != null ? cell.element : null;                
                var checkBox = cellElement != null ? cellElement.widget : null;
                if (checkBox != null)
                    checkBox.set("value", selected);                         
            }
        },            
    	
        getRowId : function(documentListRow) {
            return documentListRow.key;
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    DocumentListWidget.AsyncOperation = {
        LOAD_FORMER_VERSIONS : "LoadFormerVersions"
    };

    return DocumentListWidget;
});
