/*
 * $Id: cdes-web-i18n.js 1449 2014-08-14 15:44:45Z mda $
 *
 * Copyright (C) 2016 ev-i IT GmbH
 */
define({
    root: ({
	//// General
    	datePattern : [ {component : 'year', style : 'decimal', minLength : 4}, "-",
    	                {component : 'month', style : 'decimal', minLength : 2}, '-',
    	                {component : 'date', style : 'decimal', minLength : 2}
	    ],

	    dateWithTimePattern : [ {component : 'year', style : 'decimal', minLength : 4}, "-",
	        	                {component : 'month', style : 'decimal', minLength : 2}, '-',
	        	                {component : 'date', style : 'decimal', minLength : 2}, " ",
        	                	{component : "hour", style : "decimal", length : 2}, ":",
        	                	{component : "minute", style : "decimal", length : 2}
      	],

      	dateWithSecondsPattern : [ {component : 'year', style : 'decimal', minLength : 4}, "-",
	        	                   {component : 'month', style : 'decimal', minLength : 2}, '-',
	        	                   {component : 'date', style : 'decimal', minLength : 2}, " ",
        	                	   {component : "hour", style : "decimal", length : 2}, ":",
        	                	   {component : "minute", style : "decimal", length : 2}, ":",
        	                	   {component : "second", style : "decimal", length : 2}
      	],
    	datePatternDE : [ {component : 'date', style : 'decimal', minLength : 2}, '.',
    	                {component : 'month', style : 'decimal', minLength : 2}, '.',
    	                {component : 'year', style : 'decimal', minLength : 2}
	    ],

        nameLabel : "Name",
        saveAndExitButtonCaption : "Speichern und Beenden",
        saveButtonCaption : "Speichern",
      	searchButtonCaption : "Suchen",
      	searchOpenCaption : "Suchfelder verbergen",
      	searchClosedCaption : "Suchfelder zeigen",

      	showAdditionalSearchFieldsButtonCaption : "Zusätzliche Suchfelder zeigen",
      	showNumberedAdditionalSearchFieldsButtonCaption : "Zusätzliche Suchfelder (${countActive} davon aktiv) zeigen",
      	hideAdditionalSearchFieldsButtonCaption : "Zusätzliche Suchfelder verbergen",
      	clearSearchFieldsButtonCaption : "Suchfelder leeren",
      	clearSearchFieldsButtonToolTip : "Alle Suchfelder leeren",

        searchBeingInitialized : "Die Suche wird initiiert...",
      	notYetSearched : "Noch nichts gesucht.",
      	searchRuns : "Neue Suche läuft...",
      	searchCancelled : "Suche abgebrochen.",

      	quickSearchLabel : "Filtern",
      	quickSearchToolTip : "Die Liste filtern, ohne erneut zu suchen.  Es werden nur noch die Zeilen angezeigt, die den hier eingegebenen Text enthalten.",
      	quickSearchClearLabel : "X",
      	quickSearchClearToolTip : "Den Filter verwerfen",

      	columnOpenCaption : "Spalteneinstellungen verbergen",
      	columnClosedCaption : "Spalteneinstellungen zeigen",

      	actionColumnCaption : "Aktionen",

      	editButtonCaption : "Bearbeiten",
      	showButtonCaption : "Ansehen",
      	deleteButtonCaption : "Löschen",
      	previewButtonCaption : "Vorschau",
      	abortButtonCaption : "Abbrechen",
      	abortToolTip : "Abbrechen, und nichts speichern.",
      	skipButtonCaption : "Überspringen",
      	closeButtonCaption : "Schliessen",
      	signButtonCaption : "Signieren",
      	batchSignButtonCaption : "Signaturmappe",
      	importButtonCaption : "Import",
      	pleaseChoose : "--- Bitte auswählen ---",
        allOption : "--- Alle ---",
      	chooseFile : "Datei auswählen",
      	chooseFileShort : "Auswählen",
      	replaceFile : "Datei ersetzen",
      	replaceFileShort : "Ersetzen",
      	back : "Zurück",
      	backToolTip : "Zurück zur vorherigen Seite",
      	saveButtonCaption : "Speichern",
      	saveAndExitButtonCaption : "Speichern und Beenden",
      	createButtonCaption : "Hinzufügen",
      	exportToPdfButtonCaption : "Pdf-Export",
      	inMonths : "in Monaten",
      	comment : "Kommentar",

        german : "Deutsch",
        slovene : "Slowenisch",
        english : "Englisch",
        italian : "Italienisch",

      	goLeftButtonCaption : "<",
      	goRightButtonCaption : ">",

      	unused : "Derzeit ohne Funktion.",
      	forward : "Weiter",
      	error : "Fehler",

      	uploadStatusNoFileChosen : "Keine Datei ausgewählt.",
      	uploadStatusUploadRunning : "Datei ${fileName} wird verarbeitet...",
      	workflowStatusNotInitialized : "nicht initiiert",
      	workflowStatusInvalidated : "Auflage entfallen",

      	urlLabel : "Url",
      	oneDocument : "Plan",
      	manyDocuments : "Pläne",
      	manyDocuments2 : "Pläne",

        networkLabel : "Netzwerk",
        organisationLabel : "Organisation",
        consortiumLabel : "ARGE",
      	commonName : "${givenName} ${surName}",
      	organisationCommonName : "${organisationName} (${personCommonName})",
      	deputyPerson : "stv. für ${person}",
      	deputyPersonWithOrganisation : "stv. für ${person} (${organisation})",
      	ownUser : "Ich",
      	allUsers : "---",

        addressLabel : "Adresse",
        postalCodeLabel : "Postleitzahl",
        localityNameLabel : "Ort",
        countryLabel : "Staat",
        phoneLabel : "Telefon",
        mobileLabel : "Telefon mobil",
        faxLabel : "Fax",
        mailLabel : "E-Mail",
        noValidMailLabel : "Das ist keine gültige E-Mail Adresse",

      	nothing : "\u2015",
      	unknown : "Unbekannt",
      	withoutDueDate : "Ohne Termin",

      	yes : "Ja",
      	no : "Nein",
      	whatever : "...",
      	and : "und",
      	all : "Alle",
      	ok : "ok",
      	notOk : "nicht ok",
      	privilegeMissingDialogCaption : "Berechtigung fehlt",

      	searchFrom : "${label} von",
      	searchTo : "bis",

      	accepted : "angenommen",
      	declined : "abgelehnt",

      	maleGender : "männlich",
      	femaleGender : "weiblich",
      	unknownGender : "nicht angegeben",

      	deliverDirectly : "z.Hd. ${destination}",
      	passwordLabel : "Passwort",
      	signButtonLabel : "Signieren",

      	project : "Projekt",
        subProject : "Projektstatus",
      	planner : "Planer",
      	object : "Objekt",
      	objectPlanner : "Objektblatt",

        reviewCycleCell : "Prüfphase",
        reviewCycleNode : "Prüfknoten",

      	attachmentFileLabel : "Dateianhang",

      	pdfLabel : "pdf",
      	xlsLabel : "xls",
      	portraitLabel : "hoch",
      	landscapeLabel : "quer",

      	timeDifferencePast : "vor ${difference}",
      	timeDifferenceFuture : "in ${difference}",
      	timeDifferenceToday : "Heute",
      	timeDifferenceOneYear : "einem Jahr",
      	timeDifferenceYears : "${years} Jahren",
      	timeDifferenceOneMonth : "einem Monat",
      	timeDifferenceMonths : "${months} Monaten",
      	timeDifferenceOneWeek : "einer Woche",
      	timeDifferenceWeeks : "${weeks} Wochen",
      	timeDifferenceYesterday : "Gestern",
      	timeDifferenceTomorrow : "Morgen",
      	timeDifferenceDayBeforeYesterday : "Vorgestern",
      	timeDifferenceDayAfterTomorrow : "Übermorgen",
      	timeDifferenceDays : "${days} Tagen",

        emailSendModeNever : "Nie",
        emailSendModeBrief : "Täglich zusammengefasst",
        emailSendModeAlways : "Sofort",

      	projectParticipantNameOrganisationFirst : "${organisationName} (${personSurName} ${personGivenName})",
      	projectParticipantNameOrganisationFirstwComment : "${organisationName} (${personSurName} ${personGivenName})${projectParticipationComment}",

      	gridLinesSuppressedWarningCaption : "Anzeigelimit überschritten",
      	gridLinesSuppressedWarningText : "Von den insgesamt ${totalNumberOfTuples} gefundenen Datensätzen werden aus Performancegründen ${numberOfMissingTuples} Datensätze nicht angezeigt, da das Darstellungslimit von ${gridCellLimit} Zellen (Spalten mal Zeilen) überschritten ist.  Sie können die Suche mit schärferen Suchkriterien, oder weniger angezeigten Spalten wiederholen.  Ein PDF-Export wird immer alle gefundenen Datensätze enthalten.",

      	resultSummaryCaption : "Durchgeführte Datenbankoperationen",
      	resultSummaryContentStart : "(Dialog wird nur zu Debug-Zwecken gezeigt)",
      	resultSummaryReceived : "Geladen aus Tabelle ${table}: ${count}",
      	resultSummaryReceivedJoin : "Geladene als Join / Join-Komponente ${table}: ${count}",
      	resultSummaryInserted : "Eingefügt in ${table}: ${count}",
      	resultSummaryUpdated : "Geändert in ${table}: ${count}",
      	resultSummaryDeleted : "Gelöscht in ${table}: ${count}",

      	entries : "Einträge",
      	dueDateRemarkNoEntries : "Keine Einträge",
      	dueDateRemarkBeforeConstruction : "vor Baubeginn",
      	dueDateRemarkWhileConstruction : "während Bau",
      	dueDateRemarkDuringConstruction : "während der gesamten Bauzeit",
      	dueDateRemarkBeforeStarting : "vor Inbetriebnahme",
      	dueDateRemarkAfterConstruction : "nach Bau",
      	dueDateRemarkInOperation : "Betriebsphase",
      	dueDateRemarkTillOperationApproval : "bis zur Betriebsbewilligung",

      	topicLogButtonLabel : "Topic-Log schreiben",
      	topicLogButtonToolTip : "Zu Debugzwecken die aktuell registrierten clazzes/topic-Listener-Beziehungen schreiben.",

      	wrongPasswordOrMissingPrivilegesMessage : "Mögliche Gründe sind ein falsches Passwort, oder fehlende Berechtigungen.",

      	fileUploadNoFileSelected : "Keine Datei ausgewählt.",
      	fileUploadFileSelected : "${fileName} ausgewählt (Größe ${fileSize})",
      	fileUploadUploadingFile : "Übertrage ${fileName} (Größe ${fileSize})...",
      	uploadFailed : "Das Hochladen der Datei ist fehlgeschlagen.",
      	uploadFailedWrongType : "Das Hochladen der Datei ist fehlgeschlagen. Der gewählte Dateityp wird nicht unterstützt. Es sind nur pdf- Dokumente ohne eingebettete Anhänge erlaubt.",

      	networkColumnCaption : "Netzwerk",



      	//// DocumentVersion legend
      	documentVersionStatusULegendExample : "AF-BR01KI-02-0002-E00",
      	documentVersionStatusULegendLabel : "Entfällt ersatzlos - Status U",
      	documentVersionStatusUObjectPlannerDeletedLegendLabel : "Objektblatt gelöscht - Status U",
      	documentVersionStatusXLegendExample : "AF-BR01KI-02-0002-E00",
      	documentVersionStatusXLegendLabel : "Ungültig und erneut im Prüflauf - Status X",

      	//// PlanDeliver legend
      	planDeliverLegendChangedDates : "Eintrag mit Terminänderungen",
      	planDeliverLegendChangedGeneral : "Eintrag mit allgemeinen Änderungen",
      	planDeliverLegendExample : "70-BR01-02-0002",
      	planDeliverLegendNew : "neuer Eintrag",

      	//// cdes/admin/db/DBAdminPage
      	dbAdminCertificateCaButtonCaption : "Fremdschlüssel von Certificate zu Ca ergänzen",
      	dbAdminLogViewerButtonCaption : "Log ansehen",
      	dbAdminLogViewerTitle : "Log",
      	dbAdminPageCaption : "Datenbank-Schema-Administration",

      	//// cdes/admin/import/ImportAdminPage
      	importAdminImporterLabel : "Plugin",
      	importAdminImporterToolTip : "Ein Plugin auswählen, das eine bestimmte Art, Daten zu importieren bzw. automatisiert anzupassen bereitstellt.",
      	importAdminLogViewerTitle : "Log",
      	importAdminPageCaption : "Datenimport und -anpassungen",
      	importAdminSBTNImportButtonCaption : "SBTN Access-Datenbank importieren",
      	importAdminSBTNLogViewerButtonCaption : "Log ansehen",

      	//// cdes/admin/job/JobListWidget
      	jobListAskDeleteFinishedJobDialogCaption : "Job aus Liste löschen?",
      	jobListAskDeleteFinishedJobDialogQuestion : "Wollen Sie den von ${givenName} ${surName} ausgeführten Job wirklich aus der Liste löschen?  Dies hat KEINE Auswirkungen auf seine Ergebnisse, sondern dient lediglich der Bereinigung der Liste.",
      	jobListAskDeletePlannedJobDialogCaption : "Geplanten Job wirklich löschen?",
      	jobListAskDeletePlannedJobDialogQuestion : "Wollen Sie den von ${givenName} ${surName} eingeplanten Job wirklich löschen?  Die Folge davon wird sein, dass er NICHT ausgeführt wird.",
      	jobListAskDestroyJobDialogCaption : "Job wirklich abbrechen?",
      	jobListAskDestroyJobDialogQuestion : "Wollen Sie den um ${startTs} von ${givenName} ${surName} gestarteten Job wirklich abbrechen?",
      	jobListCreatedColumn : "Erstellt",
      	jobListDeleteFailed : "Das Löschen des Jobs ist fehlgeschlagen.",
      	jobListDeleteFinishedJob : "Den bereits durchgeführten Job löschen.  Dies hat KEINE Auswirkungen auf seine Ergebnisse, und dient lediglich der Bereinigung dieser Liste",
      	jobListDeletePlannedJob : "Den geplanten Job löschen, sodass er nicht ausgeführt wird.",
      	jobListDeleteSuccessful : "Der Job wurde erfolgreich gelöscht.",
      	jobListDestroyFailed : "Beim Abbrechen des Jobs ist ein Fehler aufgetreten.  Es ist unklar, ob er noch läuft.",
      	jobListDestroySuccessful : "Der Job wird abgebrochen.",
      	jobListDestroyToolTip : "Diesen Job abbrechen",
      	jobListDownloadToolTip : "Datei ${fileName} herunterladen",
      	jobListEndTimestampColumn : "Beendet um",
      	jobListExportDocumentArchive : "Erzeugung Planarchiv",
      	jobListExportDocumentsToMspType : "Export Pläne nach MSP",
      	jobListExportPdfReportType : "Erzeugung PDF-Report",
      	jobListExportStatutoryDutyToMspType : "Export Rechtspflicht nach MSP",
      	jobListExportXlsReportType : "Erzeugung XLS-Report",
      	jobListNetworkColumn : "Netzwerk / Projekt",
      	jobListOrganisationPersonColumn : "Gestartet von",
      	jobListShowToolTip : "Details zum Job anzeigen",
      	jobListSizeColumn : "Anzahl Datensätze",
      	jobListStartTimestampColumn : "Gestartet um",
      	jobListStateColumn : "Status",
      	jobListTypeColumn : "Job",
      	jobStateFailed : "Fehlgeschlagen",
      	jobStateFinished : "Beendet",
      	jobStateInterrupted : "Unterbrochen",
      	jobStateScheduled : "Geplant",
      	jobStateStarted : "Läuft",

      	//// cdes/admin/job/JobPagen
      	jobListReloadButtonCaption : "Neu laden",
      	jobListReloadButtonToolTip : "Den aktuellen Zustand der Jobs laden.",
      	jobPageCaption : "Jobs",
      	jobPageSearchSuccessful : "Das Laden von ${count} Jobs wurde erfolgreich abgeschlossen.",

      	//// cdes/admin/job/JobResultPage
      	jobResultPageCaption : "Job-Ergebnisse",
      	jobResultPageLoadFailed : "Das Laden der Detailinformationen zum Job ist fehlgeschlagen.",
      	jobResultPageSearchSuccessful : "Die Detailinformationen zum Job konnten erfolgreich geladen werden.",

      	//// cdes/admin/job/JobResultListPage
      	jobResultListCategoryColumn : "Ergebnis",
      	jobResultListDocumentVersionIdColumn : "Interne Datenbank-ID",
      	jobResultListDocumentVersionNameColumn : "Plannummer",
      	jobResultListMessageColumn : "Details",

      	//// cdes/certificate/CertificateColumnWidget
      	certificateInvitationColumnLabel : "Einladung am",
      	certificateInvitationColumnToolTip : "Den Termin an dem die Einladung zum Zertifikat verschickt wurde anzeigen",
      	certificateInvitatorNameColumnLabel : "Einladung durch",
      	certificateInvitatorNameColumnToolTip : "Die Person die die Einladung zum Zertifikat verschickt hat anzeigen",
      	certificateIssuerColumnLabel : "Ausgestellt durch",
      	certificateIssuerColumnToolTip : "Die Person die das Zertifikat ausgestellt hat anzeigen",
      	certificateNameColumnLabel : "Name",
      	certificateNameColumnToolTip : "Den Namen der Person anzeigen",
      	certificateNetworkColumnLabel : "Netzwerk",
      	certificateNetworkColumnToolTip : "Das Netzwerk anzeigen",
      	certificateOrganisationColumnLabel : "für Organisation",
      	certificateOrganisationColumnToolTip : "Die Organisation zur Person anzeigen",
      	certificateRequestedNameColumnLabel : "Anforderung",
      	certificateRequestedNameColumnToolTip : "Den Zeitpunkt an dem die Anforderung durch Anklicken des Links bestätigt wurde anzeigen.",
      	certificateSerialNumberColumnLabel : "Seriennummer",
      	certificateSerialNumberColumnToolTip : "Die Seriennummer des Zertifikats anzeigen",
      	certificateStatusColumnLabel : "Status",
      	certificateStatusColumnToolTip : "Informationen zu Gültigkeit und Berechtigungen des Zertifikats anzeigen",
      	certificateValidColumnLabel : "Gültig",
      	certificateValidColumnToolTip : "Den Zeitraum in dem das Zertifikat gültig ist anzeigen",

      	//// cdes/certificate/CertificateCreateWidget
      	certificateCreateInvalidCertificate : "Die Verlängerung / Ausstellung des Zertifikats ist nicht möglich, da dem zugrundeliegenden Datensatz relevante Attribute fehlen.",
      	certificateCreatePersonLabel : "Zertifikat für",
      	certificateCreatePersonToolTip : "Person, für die das Zertifikat ausgestellt werden soll",
      	certificateCreateSignFailed : "Fehler beim Signieren des Zertifikats.  Eventuell wurde ein falsches Passwort eingegeben oder es existiert bereits ein gültiges für dieselbe Organisation.",
      	certificateCreateSignOk : "Das Zertifikat für ${givenName} ${surName} wurde erfolgreich signiert und kann jetzt verwendet werden.",
      	certificateCreateUploadLabel : "Benutzerrichtlinie",
      	certificateCreateUserCaLabel : "Verwendete UserCA",
      	certificateCreateUserCaPasswordLabel : "Passwort UserCA",
      	certificateCreateUserCaPasswordToolTip : "Passwort für die UserCA",
      	certificateCreateUserCaToolTip : "UserCA, auf deren Basis das neue Zertifikat ausgestellt wird",

      	//// cdes/certificate/CertificateInviteChooseDialog
      	certificateInviteFetchNetworksFailed : "Beim Ermitteln der Netzwerke für die Netzwerkauswahl ist ein Fehler aufgetreten.",
      	certificateInviteNetworkColumnCaption : "Netzwerk für das Sie einladen wollen",

      	////== CertificateList related status
      	certificateExpiredStatus : "Abgelaufen",
      	certificateInconsistentStatus : "Inkonsistent",
      	certificateListInvitationStatus : "Einladung",
      	certificateListLockedStatus : "Gesperrt",
      	certificateListNoCertificateStatus : "Kein Zertifikat",
      	certificateListRequestStatus : "Anforderung",
      	certificateListValidExpiresSoonStatus : "Noch gültig",
      	certificateListValidStatus : "Gültig",
      	certificateMayLoginStatus : "Login",
      	certificateMaySignStatus : "Signieren",
      	certificateInvalidUserPolicy : "BRL ungültig",
      	certificateValidUserPolicy : "BRL gültig",
      	certificateNoUserPolicy : "BRL fehlt",
      	certificatePasswordExpired : "Passwort abgelaufen",
      	certificatePasswordWillExpire : "Passwort läuft ab",

      	//// cdes/certificate/CertificateListWidget
      	certificateListAskSendConfirmationLetterDialogCaption : "Bestätigungsformular Zertifikatsanforderung senden?",
      	certificateListAskSendConfirmationLetterDialogQueston : "Durch Klicken auf 'OK' wird eine E-Mail mit der Anleitung zum Download des Bestätigungsformulars der Zertifikatsanforderung für die gewählte Organisation versendet. Es wird empfohlen, die Rücksendung dieses Formulars abzuwarten, bevor Sie die Zertifikatsaustellung dieses Teilnehmers mit der Aktion 'Zertifikat mit vorhandener Anforderung neu ausstellen' fortsetzen.",
      	certificateListConfirmCertificateButtonCaption : "Bestätigungsformular Zertifikatsanforderung erstellen",
      	certificateListConfirmCertificateButtonToolTip : "Bestätigungsformular Zertifikatsanforderung erstellen",
      	certificateListCreateDialogCaption : "Neues Benutzer-Zertifikat ausstellen und signieren",
      	certificateListCreateSignButtonToolTip : "Das neue Benutzer-Zertifikat ausstellen und signieren.",
      	certificateListDeleteAccessButtonCaption : "Zugang löschen",
      	certificateListDeleteAccessButtonToolTip : "Den Zugang der zum Zertifikat gehörigen Person löschen",
      	certificateListDeleteInvitationButtonCaption : "Einladung löschen",
      	certificateListDeleteInvitationButtonToolTip : "Einladung löschen",
      	certificateListDeleteInvitationFailed : "Die Löschung der Einladung für ${givenName} ${surName} ist fehlgeschlagen.",
      	certificateListDeleteInvitationOk : "Die Einladung für ${givenName} ${surName} wurde erfolgreich gelöscht.",
      	certificateListDeleteRequestButtonCaption : "Anforderung löschen",
      	certificateListDeleteRequestButtonToolTip : "Anforderung löschen",
      	certificateListDeleteRequestFailed : "Die Löschung der Anforderung für ${givenName} ${surName} ist fehlgeschlagen.",
      	certificateListDeleteRequestOk : "Die Anforderung für ${givenName} ${surName} wurde erfolgreich gelöscht.",
      	certificateListDownloadRequestButtonCaption : "Anforderungsdokument herunterladen",
      	certificateListDownloadRequestButtonToolTip : "Das vom Benutzer im Zuge der Anforderung ausgefüllte Anforderungs-PDF herunterladen",
      	certificateListEditPersonButtonCaption : "Personendaten bearbeiten",
      	certificateListEditPersonButtonToolTip : "Die Personendaten der zum Zertifikat gehörigen Person anzeigen und ggf. bearbeiten",
      	certificateListGetOtherCertificateFailed : "Das Ermitteln eines eventuell bereits vorhandenen Zertifikats der Person ist fehlgeschlagen.",
      	certificateListInvalidateButtonCaption : "Sperren",
      	certificateListInvalidateButtonToolTip : "Das Zertifikat sperren",
      	certificateListInvalidateCertificateFailed : "Fehler beim Sperren des Zertifikats.  Es ist möglicherweise immer noch gültig.",
      	certificateListInvalidateCertificateOk : "Das für ${organisationName} ausgestellte Zertifikat von ${givenName} ${surName} wurde erfolgreich gesperrt.",
      	certificateListInvalidateLoginFailed : "Fehler beim Löschen des Zugangs von Person ${givenName} ${surName}.  Die Person ist möglicherweise immer noch anmeldeberechtigt.",
      	certificateListInvalidateLoginOk : "Der Zugang der Person ${givenName} ${surName} wurde erfolgreich gelöscht.",
      	certificateListInvitationColumnCaption : "Einladung am",
      	certificateListInvitationSendAllFailed : "Fehler beim Versuch, Einladung und Sicherheitscode für ${givenName} ${surName} an die Adresse ${mail} zu versenden.",
      	certificateListInvitationSendAllOk : "Einladung und Sicherheitscode für ${givenName} ${surName} wurden erfolgreich an die Adresse ${mail} verschickt.",
      	certificateListInvitationSendInvitationFailed : "Fehler beim Versuch, die Einladung für ${givenName} ${surName} an die Adresse ${mail} zu versenden.",
      	certificateListInvitationSendInvitationOk : "Die Einladung für ${givenName} ${surName} wurde erfolgreich an die Adresse ${mail} verschickt.",
      	certificateListInvitatorColumnCaption : "Einladung durch",
      	certificateListInviteForCertificateButtonCaption : "Zur Zertifikatsanforderung einladen",
      	certificateListInviteForCertificateButtonToolTip : "Zur Zertifikatsanforderung einladen",
      	certificateListIssueCertificateButtonCaption : "Zertifikat ausstellen",
      	certificateListIssueCertificateButtonToolTip : "Zertifikat ausstellen",
      	certificateListIssuerColumnCaption : "Ausgestellt durch",
      	certificateListMayInvalidateLoginDialogCaption : "Berechtigung fehlt",
      	certificateListMayInvalidateLoginDialogMessage : "Sie haben keine Berechtigung, den Zugang der Person zu löschen.  Bitte prüfen Sie ihre Rollen.",
      	certificateListMayInvalidateLoginFailed : "Bei der Prüfung, ob die Person berechtigt ist den Zugang zu löschen, ist ein Fehler aufgetreten.",
      	certificateListNameColumnCaption : "Name",
      	certificateListNetworkColumnCaption : "Netzwerk",
      	certificateListNewCertificateButtonCaption : "Zertifikat mit vorhandener Anforderung neu ausstellen",
      	certificateListNewCertificateButtonToolTip : "Zertifikat mit vorhandener Anforderung neu ausstellen",
      	certificateListNoOtherCertificateCaption : "Kein Zertifikat gefunden",
      	certificateListNoOtherCertificateMessage : "Es konnte kein gültiges Zertifikat für eine andere Organisationszugehörigkeit dieser Person gefunden werden.  Daher ist die Ausstellung eines neuen Zertifikats auf Basis einer vorhandenen Anforderung nicht möglich.",
      	certificateListOrganisationColumnCaption : "für Organisation",
      	certificateListRenewButtonCaption : "Verlängern",
      	certificateListRenewButtonToolTip : "Das Zertifikat verlängern",
      	certificateListRequestedColumnCaption : "Anforderung am",
      	certificateListSendConformationLetterOk : "Das Bestätigungsformular für die Zertifikatsanforderung wurde erfolgreich versendet.",
      	certificateListSendConfirmationLetterFailed : "Das Versenden des Betätigungsformulars für die Zertifikatsanforderung ist fehlgeschlagen.",
      	certificateListSerialNumberColumnCaption : "Seriennummer",
      	certificateListShowDetailsButtonCaption : "Details anzeigen",
      	certificateListShowDetailsButtonToolTip : "Details anzeigen",
      	certificateListStatusColumnCaption : "Status",
      	certificateListUnlockButtonCaption : "Entsperren",
      	certificateListUnlockButtonToolTip : "Das vom Zeitraum her noch gültige Zertifikat wieder entsperren.",
      	certificateListUnlockCertificateFailed : "Fehler beim Entsperren des Zertifikats.  Es ist derzeit vermutlich nicht verwendbar.",
      	certificateListUnlockCertificateOk : "Das für ${organisationName} ausgestellte Zertifikat von ${givenName} ${surName} wurde erfolgreich entsperrt.",
      	certificateListValidColumnCaption : "Gültig",
      	certificateListValidPeriod : "${from} bis ${to}",
      	invalidateCertificateReallyDoDialogCaption : "Zertifikat wirklich sperren?",
      	invalidateCertificateReallyDoQuestion : "Wollen Sie das Zertifikat wirklich sperren?",
      	invalidateUserLoginReallyDoDialogCaption : "Zugang wirklich löschen?",
      	invalidateUserLoginReallyDoQuestion : "Wollen Sie den Zugang der Person ${givenName} ${surName} wirklich löschen?",
      	unlockCertificateReallyDoDialogCaption : "Zertifikat entsperren",
      	unlockCertificateReallyDoQuestion : "Wollen Sie das Zertifikat wirklich entsperren?",

      	extendChangePasswordButtonCaption : "Frist verlängern",
      	extendChangePasswordButtonToolTip : "Die Frist zum Ändern des abgelaufenen Passwortes um ${amount} Tage verlängern",
      	extendChangePasswordOK : "Die Frist zum Ändern des abgelaufenen Passwortes für ${givenName} ${surName} wurde um ${amount} Tage verlängert.",
      	extendChangePasswordFailed : "Beim der Verlängerung der Frist zum Ändern des abgelaufenen Passwortes für ${givenName} ${surName} ist ein Fehler aufgetreten.",
      	extendChangePasswordAskCaption : "Frist verlängern",
      	extendChangePasswordAskQuestion : "Wollen Sie die Frist zum Ändern des abgelaufenen Passwortes für ${givenName} ${surName} wirklich um ${amount} Tage verlängern?",

      	////== Confirmation dialogs
      	certificateInvitationAskDeleteCaption : "Einladung wirklich löschen?",
      	certificateInvitationAskDeleteQuestion : "Wollen Sie die Einladung wirklich löschen?",
      	certificateListAskForInvitationDialogCaption : "Einladung zur Zertifikatsanforderung verschicken",
      	certificateListAskForInvitationDialogQuestion : "Hiermit wird an die Person ${givenName} ${surName} eine E-Mail mit der Einladung zur Zertifikatsanforderung gesendet. Für die Durchführung der Zertifikatsanforderung ist weiters ein Sicherheitscode erforderlich. Dieser kann entweder gleich jetzt in einer separaten E-Mail übermittelt werden, oder später z.B. per Post versendet werden.",
      	certificateListAskForInvitationAllPerMailButtonCaption : "Einladung und Sicherheitscode per Mail verschicken",
      	certificateListAskForInvitationAllPerMailButtonToolTip : "Einladung und Sicherheitscode in zwei separaten Mails verschicken",
      	certificateListAskForInvitationOnlyInvitationButtonCaption : "Einladung per Mail verschicken",
      	certificateListAskForInvitationOnlyInvitationButtonToolTip : "Nur die Einladung per Mail verschicken.  Der Sicherheitscode muss später separat, z.B. per Post, versendet werden.",
      	certificateRequestAskDeleteCaption : "Anforderung wirklich löschen?",
      	certificateRequestAskDeleteQuestion : "Wollen Sie die Anforderung wirklich löschen?",

      	//// cdes/certificate/CertificatePage
      	certificatePageCertificates : "${certificateInfo} Zertifikate",
      	certificatePageExpiredSearchInfo : "${numberOfExpired} abgelaufene",
      	certificatePageGetDataFailed : "Das Laden der Zertifikate ist fehlgeschlagen.",
      	certificatePageInconsistentSearchInfo : "${numberOfInconsistent} inkonsistente Zertifikate",
      	certificatePageInvitationsSearchInfo : "${numberOfInvitations} Einladungen",
      	certificatePageNoneFoundSearchInfo : "Keine Zertifikate gefunden.  Bitte passen Sie ggf. die Suchfelder an.",
      	certificatePagePersonsWithoutCertificateSearchInfo : "${numberOfPersons} Personen ohne Zertifikat",
      	certificatePageRequestsSearchInfo : "${numberOfRequests} Anforderungen",
      	certificatePageSearchInfo : "${tokens} gefunden",
      	certificatePageValidSearchInfo : "${numberOfValid} gültige",

        broadcastUserPolicyLabel : "Benutzerrichtlinie versenden",
        broadcastUserPolicyToolTip : "Benutzerrichtlinie an alle aktiven Benutzer versenden und zur unterschriebenen Retournierung auffordern.",
        broadcastUserPolicyConfirmationTitle : "Benutzerrichtlinie versenden",
        broadcastUserPolicyConfirmationMessage : "Mit dieser Aktion wird an ALLE aktiven Benutzer von c.des eine e-mail mit der aktuell gültigen Benutzerrichtlinie als Anhang, sowie der Aufforderung diese unterschrieben zurückzusenden, versendet. Fortfahren?",

      	//// cdes/certificate/CertificateRequestShowWidget
      	certificateRequestAskSendInvitationCaption : "Einladung erneut versenden?",
      	certificateRequestAskSendInvitationQuestion : "Wollen Sie die Einladung erneut versenden?",
      	certificateRequestChallengeOneLabel : "Challenge 1 (ID)",
      	certificateRequestChallengeOneToolTip : "Der Sicherheitscode zur Einladung, der Teil des an den Benutzer verschickten Links ist.",
      	certificateRequestChallengeTwoLabel : "Challenge 2 (Sicherheitscode)",
      	certificateRequestChallengeTwoToolTip : "Der Sicherheitscode, der dem Benutzer in einer separaten Mail geschickt wird, und auf der Bestätigungsseite eingegeben werden muss.",
      	certificateRequestDateLabel : "Datum",
      	certificateRequestDateToolTip : "Zeitstempel, an dem die Zertifikatseinladung erstellt wurde",
      	certificateRequestMailLabel : "Einladung wurde versandt an",
      	certificateRequestMailToolTip : "Mailadresse, an die die Einladung versandt wurde.",
      	certificateRequestPdfToolTip : "Einladungsbrief als PDF herunterladen",
      	certificateRequestSecurityCodeLabel : "Sicherheitscode",
      	certificateRequestSendInvitationMailFailed : "Das Versenden der Einladung ist fehlgeschlagen.",
      	certificateRequestSendInvitationMailOk : "Die Einladung wurde erfolgreich versendet.",
      	certificateRequestSendMailAgainToolTip : "E-Mail mit Einladung erneut senden",
      	certificateRequestShowDialogCaption : "Zertifikatseinladung für ${givenName} ${surName}",

      	certificateRequestUserPolicyMailLabel : "Benutzerrichtlinie wurde versandt an",
      	certificateRequestUserPolicyMailToolTip : "Mailadresse, an die die Benutzerrichtlinie versandt wurde.",
      	certificateRequestSendUserPolicyMailAgainToolTip : "E-Mail mit Benutzerrichtlinie erneut senden",
      	certificateRequestAskSendUserPolicyCaption : "Benutzerrichtlinie erneut versenden?",
      	certificateRequestAskSendUserPolicyQuestion : "Wollen Sie die Benutzerrichtlinie erneut versenden?",
      	certificateRequestSendUserPolicyMailOk : "Die Benutzerrichtlinie wurde erfolgreich versendet.",

      	//// cdes/certificate/CertificateSearchWidget
      	certificatePageCaption : "Zertifikate",

      	/*

    	Name                 Von      Gültige                Gültige, in 30 Tagen ablaufend
    	Ausgestellt für      Bis      Einladungen            Anforderungen
    	Ausgestellt durch             Abgelaufene            Personen ohne Zertifikat
    	Suchen
      	 */

      	////== First Column
      	certificateSearchIssuerLabel : "Ausgestellt durch",
      	certificateSearchIssuerToolTip : "Name der Person, die das Zertifikat ausgestellt hat.",
      	certificateSearchOrganisationNameLabel : "für Organisation",
      	certificateSearchOrganisationNameToolTip : "Name der Organisation, für die das Zertifikat ausgestellt ist.",
      	certificateSearchPersonNameLabel : "Name",
      	certificateSearchPersonNameToolTip : "Name der Person, auf die das Zertifikat ausgestellt ist.",
      	certificateSearchSearchButtonToolTip : "Zertifikate bzw. Personen im Zusammenhang mit Zertifikaten suchen",

      	////== Second Column
      	certificateSearchFromLabel : "gültig von",
      	certificateSearchFromToolTip : "Nur Zertifikate deren Gültigkeit bei diesem Datum oder später endet finden",
      	certificateSearchNetworkLabel : "Netzwerk",
      	certificateSearchNetworkToolTip : "Netzwerk",
      	certificateSearchToLabel : "bis",
      	certificateSearchToToolTip : "Nur Zertifikate deren Gültigkeit bei diesem Datum oder früher endet finden",

      	////== Third Column
      	certificateSearchShowExpiredLabel : "Abgelaufene",
      	certificateSearchShowExpiredToolTip : "Abgelaufene Zertifikate finden",
      	certificateSearchShowInvitationsLabel : "Einladungen",
      	certificateSearchShowInvitationsToolTip : "Einladungen finden, die noch nicht zu Anforderung / Zertifikatserteilung geführt haben",
      	certificateSearchShowValidLabel : "Gültige",
      	certificateSearchShowValidToolTip : "Gültige Zertifikate finden",

      	////== Fourth Column
      	certificateSearchFetchNetworksFailed : "Das Laden der Liste aller Netzwerke (für die Netzwerkauswahl bei den Suchfeldern) ist fehlgeschlagen.",
      	certificateSearchShowPersonsWithoutCertificateLabel : "Personen ohne Zertifikat",
      	certificateSearchShowPersonsWithoutCertificateToolTip : "Personen finden, für die weder ein gültiges oder abgelaufenes Zertifikat, noch eine Einladung oder Anforderung existieren.",
      	certificateSearchShowRequestedLabel : "Anforderungen",
      	certificateSearchShowRequestedToolTip : "Anforderungen, die noch nicht zur Zertifikatserteilung geführt haben, finden.",
      	certificateSearchShowValidExpiredSoonLabel : "Gültige, innerhalb 30 Tagen ablaufend",
      	certificateSearchShowValidExpiredSoonToolTip : "Gültige Zertifikate, die aber innerhalb der nächsten 30 Tage ablaufen, finden.",

      	/*
    	certificateSearchViewLabel : "Ansicht",
    	certificateSearchCertificateViewLabel : "Zertifikate",
    	certificateSearchCertificateViewToolTip : "TODO",
    	certificateSearchRequestViewLabel : "Anforderungen",
    	certificateSearchRequestViewToolTip : "TODO",
    	certificateSearchInvitationsViewLabel : "Einladungen",
    	certificateSearchInvitationsViewToolTip : "TODO",
    	certificateSearchPersonsWithoutCertificateViewLabel : "Personen ohne Zertifikat",
    	certificateSearchPersonsWithoutCertificateViewToolTip : "TODO",
      	 */

      	//// cdes/certificate/RenewCertificateDialog
      	renewCertificateCAPasswordLabel : "Passwort UserCA",
      	renewCertificateCAPasswordToolTip : "Das zu der User-CA gehörige Passwort",
      	renewCertificateDialogCaption : "Zertifikat verlängern",
      	renewCertificateOrganisationLabel : "bei Organisation",
      	renewCertificateOrganisationToolTip : "Organisation der Person, für die das Zertifikat ausgestellt wurde.",
      	renewCertificatePersonLabel : "Zertifikat für",
      	renewCertificatePersonToolTip : "Person, für die das Zertifikat ausgestellt wurde.",
      	renewCertificateSignButtonCaption : "Zertifikat signieren",
      	renewCertificateSignButtonToolTip : "Die Zertifikatsverlängerung signieren.",
      	renewCertificateUserCALabel : "Verwendete UserCA",
      	renewCertificateUserCAToolTip : "Die User-CA mit deren Hilfe das Zertifikat verlängert wird.",

      	////== Result messages
      	renewCertificateOk : "Das für ${organisationName} ausgestellte Zertifikat von ${givenName} ${surName} wurde erfolgreich verlängert.",
      	renewCertificateGetUserCasFailedMessage : "Das Laden der Liste aller gültigen UserCAs ist fehlgeschlagen.",
      	renewCertificateFailedMessage : "Ergebnis: Die Verlängerung des Zertifikats ist fehlgeschlagen.  Bitte überprüfen Sie ihr Passwort.",

      	//// cdes/challengeLogin/ChallengeLoginPage
      	challengeLoginFacsimileLabel : "Fax: ${facsimile}",
      	challengeLoginFetchPersonDataFailed : "Das Laden der Personendaten ist fehlgeschlagen.",
      	challengeLoginJustFinishedState : "Die Zertifikatsanforderung wurde erfolgreich übermittelt.",
      	challengeLoginGeneratePdfFailed : "Die Generierung des Pdf-Formulars ist fehlgeschlagen.",
      	challengeLoginLoginLabel : "Nachdem das Zertifikat eingerichtet ist, können Sie sich auf der Planprüfplattform c.des einloggen.  Sie werden darüber per e-mail automatisch informiert.",
      	challengeLoginLoginSectionLabel : "Folgende Daten werden für die zukünftige Anmeldung an der Planprüfplattform c.des benötigt und können von Ihnen frei gewählt werden.",
      	challengeLoginMailLabel : "E-Mail: ${mail}",
      	challengeLoginPageCaption : "Zertifikatsanforderung ${givenName} ${surName}",
      	challengeLoginPageNoDataFound : "Die Zertifikatsanforderung konnte nicht gefunden werden.  Wurde sie bereits gelöscht?",
      	challengeLoginPasswordLabel : "Passwort",
      	challengeLoginPasswordAnswerLabel : "Antwort auf Sicherheitsfrage",
      	challengeLoginPasswordAnswerToolTip : "Die richtige Antwort auf die von Ihnen gewählte Sicherheitsfrage",
      	challengeLoginPasswordQuestionLabel : "Sicherheitsfrage",
      	challengeLoginPasswordQuestionToolTip : "Falls Sie ihr Passwort vergessen sollten, müssen Sie beim Neuanfordern die hier von Ihnen gewählte Sicherheitsfrage beantworten.",
      	challengeLoginPasswordToolTip : "Bitte legen Sie hier ihr Passwort fest.",
      	challengeLoginPasswordTwoLabel : "Passwort bestätigen",
      	challengeLoginPasswordTwoToolTip : "Bitte wiederholen Sie hier ihr Passwort.",
      	challengeLoginPdfLabel : "Pdf-Formular",
      	challengeLoginPleasePrintPdfLabel : "Bitte schicken Sie folgendes Pdf-Formular unterschrieben an eine der beiden folgenden Adressen:",
      	challengeLoginHasUserPolicyPathPleasePrintPdfLabel : "Bitte schicken Sie die Benutzerrichtlinie, die Sie im Zuge der Zertifikatseinladung erhalten haben, unterschrieben an die im Dokument genannte Adresse zurück.",
      	challengeLoginReceiveLabel : "Sobald diese Bestätigung der Zertifikatsanforderung beim Administrator eingetroffen ist, wird Ihr Zertifikat eingerichtet.",
      	challengeLoginHasUserPolicyPathReceiveLabel : "Sobald diese Bestätigung der Zertifikatsanforderung und die unterschriebene Benutzerrichtlinie beim Administrator eingetroffen ist, wird Ihr Zertifikat eingerichtet.",
      	challengeLoginRequestCertificateButtonLabel : "Zertifikat anfordern",
      	challengeLoginRequestCertificateButtonToolTip : "Das Zertifikat anfordern",
      	challengeLoginRequestFailed : "Das Erzeugen des Zertifikats ist fehlgeschlagen.",
      	challengeLoginSecurityQuestionSectionLabel : "Folgende Daten werden benötigt, um ein vergessenes Passwort wieder anzufordern",
      	challengeLoginUserNameLabel : "Benutzername",
      	challengeLoginUserNameToolTip : "Bitte wählen Sie hier Ihren Benutzernamen.",

      	////== Warnings
      	challengeLoginNoUserNameWarning : "Bitte geben Sie einen Benutzernamen an.",
      	challengeLoginRootWarning : "Der Benutzername 'root' ist nicht erlaubt.",
      	challengeLoginIllegalUserNameWarning : "Der Benutzername enthält nicht erlaubte Zeichen.  Er muss mit den Zeichen [A-Z] oder [a-z] anfangen, und darf im weiteren Verlauf die Zeichen [A-Z], [a-z], [0-9] sowie Unterstriche, Bindestriche und Punkte enthalten.",
      	challengeLoginPasswordMissingWarning : "Bitte geben Sie ein Passwort ein.",
      	challengeLoginPasswordTooShortWarning : "Das Passwort muss mindestens ${passwordMinLength} Zeichen lang sein.",
      	challengeLoginPasswordLackingDiversityWarning : "Das Passwort muss Zeichen aus mindestens drei der nachfolgenden Kategorien enthalten: Kleinbuchstaben, Großbuchstaben, Sonderzeichen, Zahlen.",
      	challengeLoginPasswordOldPwWarning : "Alte passwörter dürfen nicht wiederverwendet werden.",
      	challengeLoginPasswordsDontMatchWarning : "Die beiden Passworteingaben sind nicht identisch.",
      	challengeLoginNoQuestionWarning : "Bitte geben Sie eine Sicherheitsfrage an.",
      	challengeLoginNoAnswerWarning : "Bitte geben Sie die Antwort auf die Sicherheitsfrage an.",
      	challengeLoginIllegalAnswerWarning : "Die Antwort auf die Sicherheitsfrage enthält nicht erlaubte Zeichen.  Erlaubt sind [A-Z] und Umlaute in Groß- und Kleinschreibung, Ziffern, Leerzeichen, Unterstriche, Bindestriche und Punkte enthalten.",
      	challengeLoginUserNameAlreadyExistsWarning : "Sie besitzen bereits einen gültigen Benutzernamen. Wenn Sie fortfahren, werden die Logindaten neu gesetzt. Wenn Sie weitere Organisationszugehörigkeiten besitzen, werden auch deren Signaturpasswörter neu gesetzt. Fortfahren?",

      	//// cdes/newPassword/NewPasswordpage
        newPasswordIntroText: "Die maximale Gültigkeitsdauer Ihres Passwortes beträgt ${passwordMaxAge} Tage und wird in ${passwordRemainingDays} Tagen ablaufen. Sie müssen einen neues Passwort wählen, um sich nach dieser Frist weiter anmelden zu können. Im Zuge dessen müssen auch die Sicherheitsfrage/-antwort neu gewählt werden.",
        newPasswordAdditionalInfoText: "Hinweis: Sie können das Passwort auch unter 'Einstellungen|Zugangsdaten' ändern.",
        newPasswordOldPassword: "Passwort alt",
        newPasswordNewPassword: "Passwort neu",
        newPasswordNewPassword2: "Passwort neu bestätigen",
        newPasswordSubmitLabel: "Passwort ändern",
        newPasswordWrongPassword: "Falsches altes Passwort",
        newPasswordInvalidPassword: "Ungültiges Passwort",
        newPasswordError: "Ein Fehler ist aufgetreten. Bitte versuchen Sie die Änderung des Passworts unter 'Einstellungen|Zugangsdaten'",
        newPasswordSuccess: "Das Passwort wurde erfolgreich geändert.",
        newPasswordNoOldPassword: "Bitte geben sie ihr altes Passwort ein",
        newPasswordNoNewPassword: "Bitte geben sie ein neues Passwort ein",
        newPasswordNoRepeatPassword: "Bitte wiederholen sie das neue Passwort.",
        newPasswordPasswordMismatch: "Die beiden Passworteingaben sind nicht identisch.",

      	//// cdes/requestUserPolicy/NewPasswordpage
        requestUserPolicyWarning: "Neue Benutzerrichtlinie vorhanden.",
        requestUserPolicyText: "Sie sollten vor kurzem ein mail mit der neuen Benutzerrichtlinie als Anhang erhalten haben. Bitte senden Sie diese unterschrieben bis zum ${userPolicyDeadline} an die im Dokument angegebene e-mail Adresse zurück. Andernfalls wird nach Ablauf dieser Frist der Zugang gesperrt.",
        requestUserPolicyLinkLabel: "Sie können die Benutzerrichtlinie mit folgendem link jetzt herunterladen",
        requestUserPolicyMultipleLinkLabel: "Sie können ${count} Benutzerrichtlinien für Ihre Organisationszugehörigkeiten mit folgendem link jetzt herunterladen",
        requestUserPolicyUserPolicyLink: "Benutzerrichtlinie herunterladen",

        //// cdes/certificate/SetUserPolicyWidget
        setUserPolicyUploadText: "Hier können Sie die angeforderte unterschriebene Benutzerrichtlinie des Benutzers hochladen, um seinen Zugang freizuschalten.",
        setUserPolicyReplaceText: "Es ist bereits eine Benutzerrichtlinie vorhanden. Diese wird hiermit überschrieben!",
      	setUserPolicyUploadLabel : "Benutzerrichtlinie",
        setUserPolicySubmit: "Benutzerrichtlinie hochladen",
      	setUserPolicyUploadError : "Es konnte keine Zertifikatsanforderung gefunden werden.",

      	certificateListSetUserPolicyCaption : "Benutzerrichtlinie für ${givenName} ${surName}",
      	certificateListSetUserPolicyCaption : "Benutzerrichtlinie für ${givenName} ${surName}",
		certificateListSetUserPolicyButtonCaption : "Benutzerrichtlinie",
		certificateListSetUserPolicyButtonToolTip : "Unterschriebene Benutzerrichtlinie hochladen",

      	//// cdes/core/ApplicationContext
      	applicationContextLoadMasterDataFailed : "Das Laden der globalen Metadaten ist fehlgeschlagen.",

      	//// cdes/core/CdesVoc
      	pdfListLabel : "pdf in Listenform",

      	//// cdes/document/ArchiveOptionWidget
      	archiveOptionContentLabel : "Dokumentversion",
      	archiveOptionContentToolTip : "Dokumentversion",
      	archiveOptionCountLabel : "Ausgewählte Dokumente:",
      	archiveOptionDocumentsLabel : "${numberOfDocuments} Dokumente",
      	archiveOptionEstimatedLabel : "Geschätzte Archivgröße:",
      	archiveOptionEstimatedSizeLabel : "${estimatedSize} MB",
      	archiveOptionFormatLabel : "Dateiformat",
      	archiveOptionFormatToolTip : "Dateiformat",
      	archiveOptionFreeSpaceLabel : "Verfügbarer Speicherplatz:",
      	archiveOptionFreeSpaceSizeLabel : "${freeSpace} MB",
      	archiveOptionReviewHistoryCheckBoxLabel : "mit Prüfhistorie",
      	archiveOptionReviewHistoryCheckBoxToolTip : "Prüfhistorie in das Archiv einschließen",
      	archiveScopeAll : "alle",
      	archiveScopeAllWithHistory : "gesamte Prüfhistorie",
      	archiveScopeRecent : "nur aktuelle",
      	archiveTypeBoth : "beide",
      	archiveTypeOriginal : "original",

      	//// cdes/document/DocumentCompareOverviewWidget
      	documentCompareOverviewHideToolTip : "Übersicht verbergen",
      	documentCompareOverviewRotateLeftToolTip : "Plan um 90 Grad gegen den Uhrzeigersinn rotieren",
      	documentCompareOverviewRotateRightToolTip : "Plan um 90 Grad im Uhrzeigersinn rotieren",
      	documentCompareOverviewShowToolTip : "Übersicht zeigen",
      	documentCompareThumbImageDisplayFailed : "Die Darstellung der Vorschau ist leider fehlgeschlagen.",
      	documentCompareThumbImageEditImageLoading : "Lade die Vorschau...",
      	documentCompareThumbImageEditNoImageLoaded : "Die Vorschau konnte nicht geladen werden.",

      	//// cdes/document/DocumentComparePage
      	documentComparePageCaption : "Vergleich Plan \"${baseDocumentName}\" mit Plan",
      	documentVersionCompareGetDocumentCompareDataFailed : "Das Laden der Daten zu den Plänen ist fehlgeschlagen.",
      	documentVersionCompareVersionLabel : "Planauswahl",
      	documentVersionCompareVersionToolTip : "Wählen Sie einen Plan aus",

      	//// cdes/document/DocumentHelper
      	documentHelperOpenPreviewFailed : "Das Öffnen der Planvorschau ist fehlgeschlagen.",
      	documentReferenceAttachmentToolTip : "Dateianhang öffnen: ${originalFileName}${fileType}",

      	//// cdes/document/DocumentInvalidatePage
        documentInvalidateCaption : "Plan ungültig erklären",
        documentInvalidateLoadDataFailed : "Das Laden der Daten zum Plan ist fehlgeschlagen",
        documentInvalidateSignFailed : "Das Signieren ist fehlgeschlagen.  Der Plan konnte nicht für ungültig erklärt werden.  Bitte stellen Sie sicher dass Sie das richtige Passwort eingegeben haben, und kontaktieren falls nötig den Administrator.",
        documentInvalidateChooseAction : "Bitte wählen Sie eine der folgenden Aktionen aus",
        documentInvalidateDocumentNotAvailableHint : "Diese Option kann NICHT ausgewählt werden, da entweder bereits Prüfungen vorhanden sind, der Plan sich im Status 'freigegeben' befindet oder seit dem Uploadzeitpunkt mehr als 1 Arbeitstag (24h) vergangen ist.",
        documentInvalidateAsBuiltHint : "Die Option 'Upload widerrufen' bzw. 'Status X' kann NICHT ausgewählt werden, da Referenzen auf diese Version (z.B. Bestandsplanung) existieren.",
        documentInvalidateNoOptionsHint : "Es konnten keine Optionen ermittelt werden.",
        documentInvalidateAuthorizationLabel : "Die Aktion wurde mit dem Auftraggeber abgesprochen.",
        documentInvalidateReactivateLabel : "Letzte Freigabeversion wieder herstellen",
        documentInvalidateReactivateToolTip : "Diese Version löschen und letzte freigegebene Version wieder aktiv setzen.",

      	//// cdes/document/DocumentListWidget
      	documentListDocumentComparisonToolTip : "Planvergleich mit vorhergehender Version",
      	documentListDocumentVersionNameShowAllVersionsToolTip : "Alle Versionen zu diesem Dokument zeigen",
      	documentListDocumentVersionNameShowHideAllVersionsToolTip : "Andere Versionen zu diesem Dokument ausblenden",
      	documentListDownloadToolTip : "Datei lokal speichern",
      	documentListFileColumnCaption : "Datei",
      	documentListFormerDocumentVersionLabel : "Version ${version}",
      	documentListNameColumnCaption : "Plannummer",
      	documentListNumberColumnCaption : "#",
      	documentListObjectPlannerLabel : "${objectPlannerReleaseCode} [${reviewCycleInstanceReleasedName}]",
      	documentListPreviewPdfToolTip : "PDF-Planvorschau",
      	documentListPreviewPngToolTip : "PNG-Planvorschau",
      	documentListReleasedVersionStillValidLabel : "(freigegebene Version weiterhin gültig)",
      	documentListRequestManualPlotToolTip : "Plotauftrag erstellen",
      	documentListRequestOriginalToolTip : "Originaldatei anfordern",
      	documentListStatusColumnCaption : "Planfreigabe [Freigabedatum]",
      	documentListReviewStatusColumnCaption : "Prüfstatus",
      	documentListTitleColumnCaption : "Titel / Inhalt",
      	documentListUploadedColumnCaption : "Datum Upload",
      	documentListWidgetGetFormerVersionsFailed : "Das Nachladen der früheren Versionen ist fehlgeschlagen.",
      	documentObjectPlannerColumnCaption : "Objekt/-blatt [Prüfblatt]",
      	openReviewProtocolOldToolTip : "Prüfprotokoll alt aufrufen",
      	openReviewProtocolToolTip : "Prüfprotokoll aufrufen",
        documentListChooseToolTip : "Auswählen",
        documentListInvalidateDocumentToolTip : "Plan ungültig erklären (Status U bzw. Status X)",

      	//// cdes/document/DocumentPage
      	documentPageAnlagentypImportDialogCaption : "Anlagentypen angeben",
      	documentPageAnlagentypXlsHasErrorsCaption : "Bitte passen Sie folgende Punkte im Anlagentyp-Xls an:",
      	documentPageAnlagentypXlsProblemCaption : "Rückmeldungen zum Anlagentyp-Xls",
      	documentPageAskDeleteDialogCaption : "Suche wirklich löschen?",
      	documentPageAskDeleteDialogQuestion : "Wollen Sie die Suche ${name} wirklich löschen?",
      	documentPageAskExportToMspCaption : "Wirklich nach Msp exportieren?",
      	documentPageAskExportToMspMessage : "Wollen Sie wirklich die ${count} ausgewählten Pläne zeitverzögert in die MSP-Bibliothek ${mspTitle} exportieren?  Der Export wird um 22 Uhr gestartet.  Sollten Sie ihn früher ausführen wollen, können Sie dies im Register Netzwerke / Jobs tun.",
      	documentPageCaption : "Planverzeichnis",
      	documentPageCreateArchiveButtonCaption : "Planarchiv erzeugen",
      	documentPageCreateArchiveDialogCaption : "Optionen für Planarchiv-Erzeugung",
      	documentPageCreateButtonToolTip : "Den Inhalt der Suchfelder als neue Suche speichern",
      	documentPageCreateRefusedMessage : "Die Suche konnte leider nicht gespeichert werden.  Bitte geben Sie ihr einen noch nicht vergebenen Namen.",
      	documentPageCreateSearchCaption : "Suche unter neuem Namen speichern",
      	documentPageDeleteButtonToolTip : "Die Suche löschen.",
      	documentPageEditButtonToolTip : "Den Inhalt der Suchfelder in die aktuell ausgewählte Suche übernehmen.",
      	documentPageEditSearchCaption : "Suche umbenennen",
      	documentPageExportArchiveFailed : "Die Erzeugung des Planarchivs ist fehlgeschlagen.",
      	documentPageExportArchiveFinished : "Das Planarchiv wurde in ${duration}s erfolgreich erzeugt",
      	documentPageExportArchiveStarted : "Die Erzeugung des Planarchivs läuft...",
      	documentPageExportFailed : "Der Export des Planverzeichnisses ist fehlgeschlagen.",
      	documentPageExportToMspButtonCaption : "Nach Msp exportieren",
      	documentPageExportToMspButtonToolTip : "Die im aktuellen Suchergebnis enthaltenen Pläne zeitverzögert während der Nachtstunden nach Msp exportieren.",
      	documentPageExportToPdfButtonToolTip : "Planverzeichnis nach PDF exportieren",
      	documentPageExportToPdfStarted : "Der Export des Planverzeichnisses läuft...",
      	documentPageExportToPdfFinished : "Der Export des Planverzeichnisses wurde erfolgreich abgeschlossen",
		documentPageExportToXlsButtonToolTip : "Planprüfungsstatus nach XLS exportieren",
      	documentPageExportToXlsStarted : "Der Export des Planprüfungsstatus nach XLS läuft...",
      	documentPageExportToXlsFinished : "Der Export des Planprüfungsstatus nach XLS wurde erfolgreich abgeschlossen",
      	documentPageGetArchiveCreateDataFailed : "Das Ermitteln des benötigten bzw. freien Speicherplatzes für die Planarchiverzeugung ist fehlgeschlagen.",
      	documentPageGetInfoFailed : "Das Initialisieren der Planverzeichnis-Suchmaske ist fehlgeschlagen.",
      	documentPageLegendSampleNumber : "AF-BR01KI-02-0002-E00",
      	documentPageLoadDataFailed : "Das Laden der Pläne ist fehlgeschlagen.",
      	documentPageLoadDataRunning : "Die Suche nach Plänen läuft...",
      	documentPageLoadDataSuccess : "Es wurden ${count} Pläne in ${time}s gefunden",
      	// documentPageNewSearchButtonToolTip : "TODO",
      	documentPageReadAndCheckAnlagentypFileFailed : "Beim Lesen der Anlagentyp-XLS-Datei ist ein Fehler aufgetreten.",
      	documentPageRegisterMspExportFailed : "Die Registrierung des nächtlichen Exports von Dokumenten nach Msp ist fehlgeschlagen.",
      	documentPageRegisterMspExportSuccess : "Der Export der ausgewählten Dokumente nach MSP wurde erfolgreich für den nächstmöglichen Termin eingeplant.",
      	documentPageRenameButtonToolTip : "Die Suche umbenennen",
      	documentPageRunMspExportNowCaption : "Msp-Export jetzt ausführen",
      	documentPageRunMspExportNowFailed : "Das Abarbeiten der Msp-Exporte ist fehlgeschlagen.",
      	documentPageRunMspExportNowSuccess : "Das Abarbeiten der Msp-Exporte wurde abgeschlossen.  Bitte prüfen Sie die Ergebnisse unter Netzwerke / Jobs.",
      	documentPageRunMspExportNowToolTip : "Im Normalbetrieb wird der Msp-Export nachts ausgeführt.  Auf Testinstallationen ist zusätzlich die Möglichkeit vorhanden, die sofortige Ausführung aller entsprechenden Aufträge auszulösen.",
      	documentPageJumpToBPDocListButtonCaption : "Pläne aus ${status} übernehmen",
      	documentPageJumpToBPDocListButtonToolTip : "Pläne für die Bestandsplanung aus dem referenzierten Projektstatus laden.",
      	documentPageJumpToBPDocListSaveButtonCaption : "Pläne aus ${status} speichern",
      	// documentPageSaveSearchButtonToolTip : "TODO",
      	documentPageSearchLabel : "Suche",
      	documentPageSearchToolTip : "Eine Suche auswählen.",
      	//AsBuiltSignWidget
      	documentPageAsBuiltCaption : "Pläne aus ${status} übernehmen",
      	documentPageAsBuiltSaveLabel : "Unverändert übernehmen",
      	documentPageAsBuiltSaveToolTip : "Ausgewählte Pläne unverändert übernehmen",
      	documentPageAsBuiltSaveOnlyDocumentReferenceLabel : "Übernehmen später hochladen",
      	documentPageAsBuiltSaveOnlyDocumentReferenceToolTip : "Ausgewählte Pläne übernehmen und später hochladen",
      	documentPageAsBuiltAbortLabelToolTip : "Abbrechen und zum Planverzeichnis zurückkehren",
      	documentPageAsBuiltSignFailed : "Beim Signieren der Übernahme ist ein Fehler aufgetreten.",

      	//// cdes/document/DocumentSearchWidget
      	documentSearchContentLabel : "Titel/Inhalt",
      	documentSearchContentToolTip : "Titel/Inhalt",
      	documentSearchDateFilterReleaseType : "Freigabe",
      	documentSearchDateFilterSelectLabel : "Typ des Datumsfilters",
      	documentSearchDateFilterUploadType : "Upload",
      	documentSearchDelayOptionLabel : "Termin",
      	documentSearchDelayOptionToolTip : "Termin",
      	documentSearchDocumentTypeLabel : "Plantyp",
      	documentSearchDocumentTypeToolTip : "Plantyp",
      	documentSearchFromLabel : "Datum von",
      	documentSearchNameLabel : "Plannummer",
      	documentSearchNameToolTip : "Plannummer",
      	documentSearchObjectLabel : "Objekt/-blatt",
      	documentSearchObjectPlannerLabel : "Objekt",
      	documentSearchIncludeObjectPlannersCheckBoxToolTip : "Objekte inkl. Objektblätter auswählen",
      	documentSearchObjectToolTip : "Objekt",
      	documentSearchProjectParticipationLabel : "... zuständig",
      	documentSearchProjectParticipationToolTip : "Zuständig",
        documentSearchReviewCycleInstanceLabel : "Prüfblatt",
        documentSearchReviewCycleInstanceToolTip : "Prüfblatt",
      	documentSearchReviewCycleLabel : "Prüfphase",
      	documentSearchReviewCycleToolTip : "Prüfphase",
        documentSearchRoleLabel : "Mit Rolle...",
        documentSearchRoleToolTip : "Rolle mit der der Zuständige für den Plan verantwortlich ist",
      	documentSearchShowDeletedLabel : "Pläne gelöschter Objektblätter anzeigen",
      	documentSearchShowDeletedToolTip : "Pläne gelöschter Objektblätter anzeigen ein-/ausschalten",
      	documentSearchStatusLabel : "Status",
      	documentSearchStatusToolTip : "Status des Plans",
      	documentSearchToLabel : "Datum bis",

		//// cdes/document/AsBuiltSignWidget
		asBuiltSignSelectAllCheckBoxLabel : "Alle selektieren",
      	asBuiltSignSelectAllCheckBoxToolTip : "Alle Pläne selektieren ein-/ausschalten",

      	//// cdes/document/RequestOriginalDocumentPage
      	requestOriginalAdditionalOrganisationsHeader : "Zusätzliche Organisationen",
      	requestOriginalCommentLabel : "Anfrage",
      	requestOriginalCommentToolTip : "Anfrage",
      	requestOriginalDocumentGetDataFailed : "Das Laden der für das Anzeigen der Seite notwendigen Informationen (Plantitel, Organisationen) ist fehlgeschlagen.",
      	requestOriginalDocumentPageCaption : "Original anfordern",
      	requestOriginalNameLabel : "Plan",
      	requestOriginalOwnOrganisationHeader : "Eigene Organisation",
      	requestOriginalRequestButtonCaption : "Anfordern",
      	requestOriginalRequestFailed : "Das Anfordern der Originaldatei ist fehlgeschlagen",
      	requestOriginalRequestForLabel : "Anfordern für",
      	requestOriginalOrganisationsLabel : "ausgewählte Organisationen",
      	requestOriginalOrganisationsToolTip : "ausgewählte Organisationen",
      	requestOriginalPersonalLabel : "mich persönlich",
      	requestOriginalPersonalToolTip : "mich persönlich",

      	//// cdes/document/ReviewProtocolVersionWidget
      	reviewProtocolVersionAskDeleteDialogCaption : "Dokumentversion wirklich löschen?",
      	reviewProtocolVersionAskDeleteDialogQuestion : "Wollen Sie die Dokumentversion ${name} inklusive aller Prüfungen wirklich permanent und unwiderbringlich löschen?",
      	reviewProtocolVersionCommentCaption : "Änderungsvermerke und Uploadkommentar",
      	reviewProtocolVersionDateCaption : "Datum",
      	reviewProtocolVersionDeleteButtonToolTip : "Dokumentversion unwiderbringlich löschen.",
      	reviewProtocolVersionDeleteFailed : "Das Löschen der Dokumentversion ist fehlgeschlagen.",
      	reviewProtocolVersionDeleteNotPossible : "Die Dokumentversion ${name} kann nicht gelöscht werden.  Mögliche Gründe: Es existiert eine nachfolgende Version oder der Plan wird von einem anderen Plan referenziert.",
      	reviewProtocolVersionDeleteSuccessful : "Die Dokumentversion ${name} wurde unwiderbringlich gelöscht.",
      	reviewProtocolVersionDocumentContent : "Titel / Inhalt",
      	reviewProtocolVersionDocumentName : "Plannummer",
      	reviewProtocolVersionDocumentScale : "Maßstab",
      	reviewProtocolVersionFileCaption : "Datei",
      	reviewProtocolVersionFileUnchangedLabel : "(unverändert übernommen)",
      	reviewProcotolVersionStatusCurrentlyReleasedVersion : "(aktuell freigegebene Version)",
      	reviewProcotolVersionStatusDeleted : "(gelöscht)",
      	reviewProcotolVersionStatusInReviewStillValid : "(in Prüfung \u2015 freigegebene Version weiterhin gültig)",
      	reviewProcotolVersionStatusInvalidNewVersionInReview : "(ungültig \u2015 neue freizugebende Version in Prüfung)",
      	reviewProcotolVersionStatusInvalidPreviousVersionReactivated : "(ungültig \u2015 vorhergehende Version reaktiviert)",
      	reviewProcotolVersionStatusInvalidReplaced : "(ungültig \u2015 durch neue freigegebene Version ersetzt)",
      	reviewProtocolVersionUploadPersonCaption : "Upload durch",
      	reviewProtocolVersionVersionCaption : "Version und alternative Plannummer",
      	reviewProtocolVersionVersionInfo : "Version ${version}",

      	//// cdes/help/AboutPage
      	aboutPageCaption : "Informationen zu diesem Programm",
      	aboutPageDateLabel : "Datum",
      	aboutPageDateToolTip : "Zeitpunkt, an dem das vorliegende Release der Software erstellt wurde.",
      	aboutPageImplementationContent : "ev-i Informationstechnologie GmbH, 6020 Innsbruck",
      	aboutPageImplementationLabel : "Konzept und Entwicklung",
      	aboutPageImplementationToolTip : "Konzept und Entwicklung",
      	aboutPageLoadFailed : "Das Laden der Versionsinformationen ist fehlgeschlagen.",
      	aboutPageLoadOk : "Die Versionsinformationen wurden erfolgreich geladen.",
      	aboutPageNameContent : "Planprüfung | Planmanagement",
      	aboutPageNameLabel : "Name",
      	aboutPageNameToolTip : "Name der Applikation",
      	aboutPageRevisionLabel : "Revision",
      	aboutPageRevisionToolTip : "Version (im Sinne des Versionsverwaltungssystems) mit der das vorliegende Release der Software erstellt wurde.",
      	aboutPageVersionLabel : "Version",
      	aboutPageVersionToolTip : "Release-Version",
      	aboutPageWebDesignLabel : "Webdesign",
      	aboutPageWebDesignToolTip : "Webdesign",
      	aboutPageWebDesignContent : "stufe2.at und mediaT",

      	//// cdes/pages/PageChooser
      	pageChooserFetchPageContextDataFailedMessage : "Das Laden von Zusatzdaten zum Applikations-Kontext ist fehlgeschlagen.",
      	pageChooserFetchPageContextFailedMessage : "Das Abholen des Applikations-Kontexts ist fehlgeschlagen.",
      	pageChooserOpenTabSessionFailedMessage : "Das Anlegen einer Cdes-Sitzung für den aktuellen Browserreiter ist fehlgeschlagen.",

      	//// cdes/pdc/DocumentDateHistoryWidget
      	documentDateHistoryChangedColumnCaption : "geändert von (am)",
      	documentDateHistoryEndDateColumnCaption : "End-Datum",
      	documentDateHistoryNumberColumnCaption : "Nr.",
      	documentDateHistoryStartDateColumnCaption : "Start-Datum",

      	//// cdes/pdc/PlanDeliverCatalogue
      	planDeliverCatalogueCaption : "Planlieferkatalog",
      	planDeliverCatalogueGetVersionsFailed : "Das Ermitteln der bereits freigegebenen Planlieferkatalog-Versionen ist fehlgeschlagen.",
      	planDeliverCatalogueMissingPermissions : "Der Planlieferkatalog kann aufgrund fehlender Berechtigungen leider nicht angezeigt werden.",
      	planDeliverCatalogueNewEntriesCaption : "Planlieferkatalog - Neue Einträge hinzufügen",
      	planDeliverCatalogueQuickSearchClearLabel : "X",
      	planDeliverCatalogueQuickSearchClearToolTip : "Den Filter verwerfen",
      	planDeliverCatalogueQuickSearchLabel : "Filtern",
      	planDeliverCatalogueQuickSearchToolTip : "Die gemäß obiger Suchkriterien ermittelte Liste im Stil einer Schnellsuche filtern, ohne erneut zu suchen.",
      	planDeliverCatalogueVersionLabel : "Version",
      	planDeliverCatalogueVersionToolTip : "Wählen Sie hier eine bereits freigegebene Version des Planlieferkatalogs zur Ansicht aus, oder wechseln Sie zur aktuellen, in Bearbeitung befindlichen Version.",
      	updatePageContextServiceFailedMessage : "Das Update des Pagekontexts ist fehlgeschlagen.",

      	////== Buttons
      	planDeliverCatalogueAbortEditButtonCaption : "Abbrechen",
      	planDeliverCatalogueAbortEditButtonToolTip : "Die Bearbeitung abbrechen, und etwaige Änderungen verwerfen.",
      	planDeliverCatalogueEditButtonCaption : "Bearbeiten",
      	planDeliverCatalogueEditButtonToolTip : "Soll-Enddatum, Titel, Maßstab und Kommentar der aktuell (als Suchergebnis) in der Tabelle angezeigten Pläne bearbeiten (soweit geeignete Berechtigungen vorliegen)",
      	planDeliverCatalogueExportToPdfButtonCaption : "PDF",
      	planDeliverCatalogueExportToPdfButtonToolTip : "Die gesamte, derzeit ausgewählte, Version des Planlieferkatalogs als PDF exportieren.  Eventuell vorhandene Filtereinstellungen können hier leider nicht berücksichtigt werden, es wird immer die gesamte Planlieferkatalog-Version exportiert.",
      	planDeliverCatalogueExportToXlsButtonCaption : "XLS",
      	planDeliverCatalogueExportToXlsButtonToolTip : "Die gesamte, derzeit ausgewählte, Version des Planlieferkatalogs als XLS exportieren.  Eventuell vorhandene Filtereinstellungen können hier leider nicht berücksichtigt werden, es wird immer die gesamte Planlieferkatalog-Version exportiert.",
      	planDeliverCatalogueNewButtonCaption : "Neu",
      	planDeliverCatalogueNewButtonToolTip : "Neue Einträge hinzufügen",

      	planDeliverCatalogueReleaseButtonCaption : "Freigeben",
      	planDeliverCatalogueReleaseButtonToolTip : "Die aktuelle Version des Planlieferkatalogs samt eventuell getätigter Änderungen freigeben.",
      	planDeliverCatalogueSaveAndQuitEditButtonCaption : "Speichern und Beenden",
      	planDeliverCatalogueSaveAndQuitEditButtonToolTip : "Speichern, und dann sofort die Bearbeitung beenden.",
      	planDeliverCatalogueSaveAndReleaseButtonCaption : "Speichern und Freigeben",
      	planDeliverCatalogueSaveAndReleaseButtonToolTip : "Speichern, und dann sofort zur Freigabe wechseln",
      	planDeliverCatalogueSaveButtonCaption : "Speichern",
      	planDeliverCatalogueSaveButtonToolTip : "Speichern, aber weiter bearbeiten",

      	////== Feedback messages
      	planDeliverCatalogueManyObjectPlannersString : "Objektblätter ${numberOfObjectPlanners}",
      	planDeliverCatalogueManyObjectsString : "Objekte ${numberOfObjects}",
      	planDeliverCatalogueManyPlannersString : "Planer ${numberOfPlanners}",
      	planDeliverCatalogueNewDocumentsInserted : "${numberOfDocuments} neue Pläne wurden erfolgreich angelegt.",
      	planDeliverCatalogueOneNewDocumentInserted : "Ein neuer Plan wurde erfolgreich angelegt.",
      	planDeliverCatalogueOneObjectPlannerString : "Objektblatt ${objectPlanner}",
      	planDeliverCatalogueOneObjectString : "Objekt ${object}",
      	planDeliverCatalogueOnePlannerString : "Planer ${organisationName} (${personCommonName})",
      	planDeliverCatalogueReleaseInfo : "Der Planlieferkatalog wurde erfolgreich freigegeben.",
      	planDeliverCatalogueSaveFailed : "Das Speichern der Planlieferkatalog-Einträge ist fehlgeschlagen.",
      	planDeliverCatalogueSaveOk : "Änderungen an ${numberOfDocuments} Plänen wurden erfolgreich gespeichert.  Aufgrund automatischer Konvertierungen kann die Zahl höher sein als erwartet.",
      	planDeliverCatalogueSearchFailed : "Fehler beim Suchen der Planlieferkatalog-Einträge",
//      	planDeliverCatalogueSearchInfo : "${numberOfDocuments} ${documentString} von ${plannerString} zu ${objectString} und ${objectPlannerString} gefunden",
      	planDeliverCatalogueSearchInfo : "Anzahl gefundene ${documentString}: ${numberOfDocuments} - ${plannerString}, ${objectString}, ${objectPlannerString}",
      	planDeliverDocumentNumberError: "Dokument ${documentName}: ${detailMessage}",
      	planDeliverHolidayError : "Dokument ${documentName}: Bitte wählen Sie einen Tag, der weder Feiertag noch Wochenende ist.",

      	//// cdes/pdc/PlanDeliverColumnWidget
      	// Widget currently unused, but might be re-introduced without much work, if needed
      	planDeliverCommentColumnLabel : "Kommentar",
      	planDeliverCommentColumnToolTip : "",
      	planDeliverDocumentNameColumnLabel : "Plantitel",
      	planDeliverDocumentNameColumnToolTip : "",
      	planDeliverDocumentNumberColumnLabel : "Plannummer",
      	planDeliverDocumentNumberColumnToolTip : "",
      	planDeliverFromColumnLabel : "Start",
      	planDeliverFromColumnToolTip : "",
      	planDeliverObjectCodeColumnLabel : "Objekt",
      	planDeliverObjectCodeColumnToolTip : "",
      	planDeliverObjectNameColumnLabel : "Objektname",
      	planDeliverObjectNameColumnToolTip : "",
      	planDeliverObjectPlannerCodeColumnLabel : "Objektblatt",
      	planDeliverObjectPlannerCodeColumnToolTip : "",
      	planDeliverObjectPlannerNameColumnLabel : "Objektblattname",
      	planDeliverObjectPlannerNameColumnToolTip : "",
      	planDeliverPeriodColumnLabel : "Dauer",
      	planDeliverPeriodColumnToolTip : "",
      	planDeliverPlannerOrganisationColumnLabel : "Planer (Organisation)",
      	planDeliverPlannerOrganisationColumnToolTip : "",
      	planDeliverPlannerPersonColumnLabel : "Planer (Person)",
      	planDeliverPlannerPersonColumnToolTip : "",
      	planDeliverScaleColumnLabel : "Maßstab",
      	planDeliverScaleColumnToolTip : "",
      	planDeliverToColumnLabel : "Ende",
      	planDeliverToColumnToolTip : "",

      	//// cdes/pdc/PlanDeliverListWidget
      	planDeliverCommentColumnCaption : "Kommentar",
      	planDeliverFromColumnCaption : "Start Soll [Ist]",
      	planDeliverFromReleaseColumnCaption : "Start Soll",
      	planDeliverDocumentNumberColumnCaption : "Plannummer",
      	planDeliverDocumentNameColumnCaption : "Titel / Inhalt",
      	planDeliverListDateHistoryButtonLabel : "Terminhistorie",
      	planDeliverListDateHistoryButtonToolTip : "Terminhistorie anzeigen",
      	planDeliverListDateHistoryDialogCaption : "Datumshistorie zu Dokument ${document}",
      	planDeliverListDeleteButtonLabel : "Löschen",
      	planDeliverListDeleteButtonToolTip : "Den Plan löschen.  Nur möglich solange keine Datei hochgeladen wurde.",
      	planDeliverListDeleteDocumentFailed : "Die Löschung des Dokuments ist fehlgeschlagen.",
      	planDeliverListDeleteDocumentOk : "Der Plan mit der Nummer ${documentName} und dem Titel ${documentContent} wurde erfolgreich gelöscht.",
      	planDeliverListLoadMetaDataFailedMessage : "Das Laden der Metadaten für das Bearbeiten von Planlieferkatalogeinträgen ist fehlgeschlagen.",
      	planDeliverListReallyDeleteDocumentCaption : "Dokument wirklich löschen?",
      	planDeliverListReallyDeleteDocumentText : "Wollen Sie das Dokument ${documentContent} mit der Nummer ${documentNumber} wirklich löschen?",
      	planDeliverListShowObjectPlannerButtonLabel : "Objektblatt",
      	planDeliverListShowObjectPlannerButtonToolTip : "Details zum Objektblatt anzeigen",
      	planDeliverListUploadButtonLabel : "Plan hochladen",
      	planDeliverListUploadButtonToolTip : "Den Plan als pdf- oder hpgl- Datei hochladen und den Prüflauf initiieren.",
      	planDeliverObjectColumnCaption : "Objekt",
      	planDeliverObjectPlannerColumnCaption : "Objektblatt",
      	planDeliverPeriodColumnCaption : "Dauer [Ist]",
      	planDeliverPlannerColumnCaption : "Planer",
      	planDeliverPlannerString : "${organisation} (${person})",
      	planDeliverScaleColumnCaption : "Maßstab",
      	planDeliverShortDocumentNumberColumnCaption : "#",
      	planDeliverToColumnCaption : "Ende Soll [Ist]",
      	planDeliverToReleaseColumnCaption : "Ende Soll",
      	planDeliverVersionString : "[Version ${versionPartA}${versionSeparator}${versionPartB} ${dateString}]",

      	////== Inline editing fields in grid
      	planDeliverListCommentTextBoxLabel : "Kommentar",
      	planDeliverListCommentTextBoxToolTip : "Ein beliebiger Kommentar zum Plan",
      	planDeliverListContentTextBoxLabel : "Titel/Inhalt",
      	planDeliverListContentTextBoxToolTip : "Der Titel des Plans",
      	planDeliverListEndTextBoxLabel : "Ende-Soll",
      	planDeliverListEndTextBoxToolTip : "Geplante Freigabe des Plans",
      	planDeliverListScaleTextBoxLabel : "Maßstab",
      	planDeliverListScaleTextBoxToolTip : "Der Maßstab des Plans",
      	planDeliverListStartTextBoxLabel : "Start-Soll",
      	planDeliverListStartTextBoxToolTip : "Geplanter Zeitpunkt des Uploads (geplanter Beginn des Prüflaufs)",

      	//// cdes/pdc/PlanDeliverNewWidgetn
      	planDeliverNewAbortButtonCaption : "Abbrechen",
      	planDeliverNewAbortButtonToolTip : "Das Hinzufügen neuer Pläne abbrechen, bereits in die Felder eingegebene Daten werden verworfen.",
      	planDeliverNewAddButtonCaption : "Hinzufügen",
      	planDeliverNewAddButtonToolTip : "Eine Eingabezeile für einen neuen Plan unter dieser ergänzen.",
      	planDeliverNewAddFiveButtonCaption : "Fünf hinzufügen",
      	planDeliverNewAddFiveButtonToolTip : "Fünf neue Eingabezeilen für neue Pläne unter dieser ergänzen.",
      	planDeliverNewCsvImportError : "Zeile ${lineNumber}: ${message}",
      	planDeliverNewDefaultStatusMessage : "",
      	planDeliverNewDurationLabel : "Dauer",
      	planDeliverNewDurationString : "${duration} Arbeitstage",
      	planDeliverNewDurationToolTip : "Die vom Prüfblatt vorgegebene Dauer des Prüflaufs.",
      	planDeliverNewImportButtonCaption : "CSV-Import",
      	planDeliverNewImportToolTip : "TODO",
      	planDeliverNewObjectPlannerSelectToolTip : "Nachdem ein Objekt für den neuen Plan ausgewählt wurde, kann hier eines seiner Objektblätter ausgewählt werden.",
      	planDeliverNewObjectSelectToolTip : "Wählen Sie hier das Objekt, dem der neue Plan zugeordnet werden soll.",
      	planDeliverNewPlannerSelectToolTip : "Als Planer des neuen Plans wird automatisch die eigene Person eingetragen.",
      	planDeliverNewRemoveButtonCaption : "Entfernen",
      	planDeliverNewRemoveButtonToolTip : "Diese Eingabezeile für einen neuen Plan verwerfen.",
      	planDeliverNewSaveButtonCaption : "Speichern und Beenden",
      	planDeliverNewSaveButtonToolTip : "Für alle Eingabezeilen mit ausgefülltem Titel entsprechende neue Pläne hinzufügen, und zurück zur Listenansicht des Planlieferkatalogs wechseln.",
      	planDeliverNewUploadFinishedStatus : "Die Datei ${fileName} wurde erfolgreich verarbeitet, es wurden ${numberOfDocuments} Einträge importiert.",
      	planDeliverNewUploadFinishedWithErrorStatus : "Die Verarbeitung der Datei ${fileName} ist abgeschlossen.  Es wurden ${numberOfDocuments} Einträge importiert, bei ${numberOfErrors} sind Fehler aufgetreten (siehe vorherige Meldungen in der Statuszeile).",

      	////== Columns
      	planDeliverNewCommentColumnCaption : "Kommentar",
      	planDeliverNewContentColumnCaption : "Titel / Inhalt",
      	planDeliverNewEndDateColumnCaption : "Enddatum",
      	planDeliverNewNumberColumnCaption : "Nummer",
      	planDeliverNewScaleColumnCaption : "Maßstab",
      	planDeliverNewStartDateColumnCaption : "Startdatum",

      	////== Messages
      	planDeliverNewLoadMetaDataFailedMessage : "Das Laden der Metadaten für die Neuanlage von Planlieferkatalogeinträgen ist fehlgeschlagen.",
      	planDeliverNewNoObjectMessage : "Kein Objekt für Subprojekt ${subProjectName} gefunden.  Bitte legen Sie zunächst eines an.",
      	planDeliverNewNoObjectPlannerMessage : "Kein Objektblatt für das ausgewählte Objekt gefunden.  Bitte legen Sie zunächst eines an.",
      	planDeliverNewNotUniqueNumberError : "Diese Plannummer ist bereits vergeben.  Bitte wählen Sie eine andere.  Frei ist beispielsweise die ${freeNumber}",
      	planDeliverNewUploadFailedMessage : "Die Verarbeitung der Datei ist fehlgeschlagen.  Möglicherweise hat sie nicht das korrekte Format.",
      	planDeliverNewSaveFailedMessage : "Das Speichern der neuen Planlieferkatalogeinträge ist fehlgeschlagen.",
      	planDeliverNewSaveOk : "${numberOfDocuments} neue Pläne wurden erfolgreich gespeichert.",
      	planDeliverNewSaveFailedDublicateNumberMessage : "Das Speichern der neuen Planlieferkatalogeinträge ist fehlgeschlagen. Die Plannumer ${documentNumber} ist bereits im Objekt vorhanden!",
      	planDeliverNewSaveFailedDublicateOtherNumberMessage : "Das Speichern der neuen Planlieferkatalogeinträge ist fehlgeschlagen. Die bereits vorhandene Plannumer ${documentNumber} ist nicht eindeutig. Bitte wenden Sie sich an den Support.",

      	//// cdes/pdc/PlanDeliverReleasePage
      	planDeliverReleaseAbortButtonLabel : "Abbrechen",
      	planDeliverReleaseAbortButtonToolTip : "Die Freigabe einer neuen Planlieferkatalog-Version abbrechen.",
      	planDeliverReleaseGetDataFailed : "Das Abholen der für die Freigabe notwendigen Daten ist fehlgeschlagen.",
        planDeliverReleaseGetReleaseDataFailed : "Das Laden der für Inhalte konfigurierten Sprachen ist fehlgeschlagen.",
      	planDeliverReleasePageCaption : "Freigabe Planlieferkatalog Version ${version}",
      	planDeliverReleasePasswordLabel : "Passwort",
      	planDeliverReleasePasswordToolTip : "Das Passwort fürs Signieren der neuen Planlieferkatalog-Version",
      	planDeliverReleaseUpdateAllDocumentsCheckBoxLabel : "alle Dokumente aktualisieren",
      	planDeliverReleaseUpdateAllDocumentsCheckBoxToolTip : "Mit der Freigabe werden alle Dokumente aktualisiert",
      	planDeliverReleaseSignButtonLabel : "Signieren",
      	planDeliverReleaseSignButtonToolTip : "Die neue Planlieferkatalog-Version mit einem gültigen eigenen Zertifikat signieren.",
      	planDeliverReleaseSignFailed : "Bei der Freigabe des Planlieferkatalogs ist ein Fehler aufgetreten.  Er wurde nicht freigegeben.",
      	planDeliverReleaseSignOk : "Der Planlieferkatalog wurde erfolgreich freigegeben.",

      	//// cdes/pdc/PlanDeliverSearchWidget
      	planDeliverSearchCommentLabel : "Kommentar",
      	planDeliverSearchCommentToolTip : "Nur Pläne mit diesem Kommentar werden gefunden.  Eine Platzhaltersuche mit * ist möglich, Groß/Kleinschreibung ist egal.",
      	planDeliverSearchDocumentNameLabel : "Plantitel",
      	planDeliverSearchDocumentNameToolTip : "Titel des Plans",
      	planDeliverSearchDocumentNumberLabel : "Plannummer",
      	planDeliverSearchDocumentNumberToolTip : "Nach der Plannummer, oder Teilen davon, suchen.  Die Eingabe 'TU03' könnte beispielsweise die Ergebnisse '30-TU03-01-001' und '30-TU03-01-002' liefern.",
      	planDeliverSearchFromLabel : "Termin von",
      	planDeliverSearchFromToolTip : "Beginn des Zeitraums, in dem Pläne gefunden werden.  Bezieht sich auf die Soll-Termine.",
        planDeliverSearchRoleLabel : "Mit Rolle",
        planDeliverSearchRoleToolTip : "Zuständig mit dieser Rolle",
      	planDeliverSearchSearchButtonToolTip : "Nach Plänen suchen, die den angegebenen Suchkriterien entsprechen.  Die Ergebnisliste kann anschließend mit dem Sofortfilter rechts noch weiter eingeschränkt werden.",
      	planDeliverSearchToLabel : "bis",
      	planDeliverSearchToToolTip : "Ende des Zeitraums, in dem Pläne gefunden werden.  Bezieht sich auf die Soll-Termine.",
      	planDeliverSearchObjectLabel : "Objekt",
      	planDeliverSearchObjectPlannerLabel : "Objektblatt",
      	planDeliverSearchObjectPlannerToolTip : "Wahlweise Auswahl eines Objektblatts, oder Suche mit Freitextstring.  Ersteres nur wenn ein Objekt ausgewählt ist.  Eine Platzhaltersuche mit * ist möglich.",
      	planDeliverSearchObjectToolTip : "Wahlweise Auswahl eines Objekts, oder Suche mit Freitextstring.  Eine Platzhaltersuche mit * ist möglich.",
      	planDeliverSearchPlannerLabel : "Zuständig",
      	planDeliverSearchPlannerToolTip : "Name der mit einer passenden Rolle zuständigen Person, bzw. Name ihrer Organisation.  Nach einem Teil dieser Namen zu suchen ist möglich.  Die Eingabe von 'Ich' schränkt das Ergebnis auf Pläne ein für die man selbst zuständig ist.",
      	planDeliverSearchUnreleasedVersionString : "Nicht freigegebene Version ${version}",
      	planDeliverSearchVersionString : "Version ${version} vom ${date} (${person})",

      	//// cdes/planning/notification/PlanningNotificationColumnWidget
      	planningNotificationColumnCommentLabel : "Kommentar",
      	planningNotificationColumnCommentToolTip : "Den Kommentar als Tabellenspalte einblenden",
      	planningNotificationColumnFullCaption : "Spalteneinstellungen verbergen",
      	planningNotificationColumnProjectLabel : "Projekt",
      	planningNotificationColumnProjectToolTip : "Das Projekt als Tabellenspalte einblenden",
      	planningNotificationColumnReducedCaption : "Spalteneinstellungen zeigen",
      	planningNotificationColumnTitleLabel : "Bescheid",
      	planningNotificationColumnTitleToolTip : "Die Bescheidbezeichnung als Tabellenspalte einblenden",

      	//// cdes/planning/notification/PlanningNotificationEditPage
      	planningNotificationEditAbortSharepointToolTip : "Abbrechen, keinen neuen Bescheid speichern, und zum Sharepoint-Baum zurückkehren",
      	planningNotificationEditAddMultiLabel : "${name} hinzufügen",
      	planningNotificationEditAlreadyUploaded : "Datei ${fileName} wurde bereits hochgeladen.",
      	planningNotificationEditCommentToolTip : "Beliebiger Kommentar zum Bescheid bzw. Dokument",
        planningNotificationEditCopySharepointFileFailed : "Das Kopieren der Datei von Sharepoint nach c.des ist fehlgeschlagen.",
      	planningNotificationEditCreateCaption : "Bescheid hinzufügen",
      	planningNotificationEditCreateSharepointToolTip : "Den neuen Bescheid speichern, und zur Bescheidliste zurückkehren.",
      	planningNotificationEditCreateToolTip : "Den neuen Bescheid hinzufügen.  Der Dateianhang wird (erst) hier gespeichert.",
      	planningNotificationEditDeleteFileToolTip : "Die angehängte Datei löschen.  Die Löschung wird erst beim Speichern des Dialogs wirklich ausgeführt.",
      	planningNotificationEditDeleteMultiLabel : "${name} löschen.",
        planningNotificationEditDuplicateBaulosError : "Das Baulos mit dem Namen ${baulos} ist mehrfach vorhanden (Groß- und Kleinschreibung wird als identisch behandelt).  Bitte wählen Sie einen anderen Namen.",
      	planningNotificationEditEditCaption : "Bescheid bearbeiten",
      	planningNotificationEditFilePathLabel : "Datei",
      	planningNotificationEditFilePathToolTip : "Url zur üblicherweise in Sharepoint abgelegten Datei",
      	planningNotificationEditFileUploadLabel : "Pfad im MSP",
      	planningNotificationEditGetJoinFailed : "Das Laden des Bescheids ist fehlgeschlagen.",
      	planningNotificationEditNameToolTip : "Bescheid- bzw. Dokumenttitel.  Achtung: Eintrag maximal 110 Zeichen.",
      	planningNotificationEditNoTemplateError : "Es konnte keine Vorlage gefunden werden.  Es können deshalb keinerlei dynamisch konfigurierte Zusatzfelder verwendet werden.",
      	planningNotificationEditPageGetEditInfoFailed : "Das Laden der zusätzlichen Daten (etwa der dynamisch konfigurierten Felder) ist fehlgeschlagen.",
      	planningNotificationEditProjectToolTip : "Das Projekt, in dem der Bescheid angelegt wird.",
        planningNotificationEditReplaceByMspButtonCaption : "Aus MSP laden",
        planningNotificationEditReplaceByMspButtonToolTip : "Die Datei aus MSP laden und in c.des ablegen",
      	planningNotificationEditSaveFailed : "Das Hinzufügen bzw. Speichern des Bescheids ist fehlgeschlagen.",
      	planningNotificationEditSaveSharepointToolTip : "Den neuen Bescheid hinzufügen, und zum Sharepoint-Baum zurückkehren.",
      	planningNotificationEditSaveSuccessful : "Bescheid erfolgreich gespeichert",
      	planningNotificationEditSaveToolTip : "Die Änderungen am Bescheid speichern.  Falls der Dateianhang ersetzt wurde, wird die Änderung (erst) hier gespeichert.",
      	planningNotificationEditTitleLabel : "Bescheid",
      	planningNotificationEditUploadFinishedPrefix : "Die Datei",
      	planningNotificationEditUploadFinishedPostfix : "wurde erfolgreich hochgeladen.  Wirklich verwendet wird sie aber erst nach Betätigung des Speichern und Beenden-Buttons.",

      	//// cdes/planning/notification/PlanningNotificationListWidget
      	planningNotificationFileColumnCaption : "Datei",
      	planningNotificationListAskDeleteDialogCaption : "Bescheid wirklich löschen?",
      	planningNotificationListAskDeleteDialogQuestion : "Wollen Sie den Bescheid ${title} wirklich löschen? Bitte beachten Sie, dass ein Bescheid nur dann gelöscht werden kann, wenn zu diesem keine Auflagen vorhanden sind.",
      	planningNotificationListCsvImportToolTip : "Auflagen aus einer CSV-Datei importieren",
      	planningNotificationListDeleteFailed : "Das Löschen des Bescheids ist fehlgeschlagen.",
      	planningNotificationListDeleteOrderToolTip : "Bescheid bzw. Dokument löschen.",
      	planningNotificationListDeleteSuccess : "Der Bescheid wurde erfolgreich gelöscht.",
      	planningNotificationListDownloadFromSharePointToolTip : "Dateivorschau aus Sharepoint",
      	planningNotificationListDownloadToolTip : "Dateivorschau aus c.des",
      	planningNotificationListEditToolTip : "Bescheid bearbeiten.",
      	planningNotificationListExtractToolTip : "Auflagen direkt aus Bescheid automatisiert übernehmen.",
      	planningNotificationListImportButtonToolTip : "Eine beliebige Anzahl Auflagen aus einer CSV-Datei importieren.",
      	planningNotificationListImportCsvCaption : "Auflagen aus CSV importieren",
      	planningNotificationListImportFromSharepointToolTip : "Bescheid aus Sharepoint importieren",
      	planningNotificationListNewOrderToolTip : "Auflagen manuell erstellen",
      	planningNotificationListShowFromSharepointToolTip : "Bescheid aus Sharepoint anzeigen",

      	//// cdes/planning/notification/PlanningNotificationPage
      	planningNotificationExportListFailed : "Der Export der Bescheidliste ist fehlgeschlagen.",
      	planningNotificationExportToPdfButtonToolTip : "Die Bescheidliste nach pdf exportieren",
      	planningNotificationNewButtonCaption : "Bescheid hinzufügen",
      	planningNotificationNewButtonToolTip : "Hier können alle Bescheide, Dokumente, etc. hochgeladen werden, in welchen Auflagen für das ausgewählte Projekt enthalten sind.",
      	planningNotificationNewSharepointButtonCaption : "Bescheid aus MSP importieren",
      	planningNotificationNewSharepointButtonToolTip : "Hier können alle Bescheide, Dokumente, etc. aus MSP importiert werden, in welchen Auflagen für das ausgewählte Projekt enthalten sind.",
      	planningNotificationPageCaption : "Bescheide",
      	planningNotificationPageGetPlanningNotificationSearchInfoFailed : "Das Laden der zusätzlichen Spalten- und Projektinformationen ist fehlgeschlagen.",
      	planningNotificationPdfExportFinished : "Der Export der Bescheidliste wurde erfolgreich abgeschlossen.",
      	planningNotificationPdfExportStarted : "Der Export der Bescheidliste läuft...",
      	planningNotificationSearchSuccessful : "${count} Bescheide erfolgreich geladen",

      	//// cdes/planning/notification/PlanningNotificationSearchWidget
      	planningNotificationSearchCommentToolTip : "Bescheid Kommentar",
      	planningNotificationSearchGetPlanningNotificationJoinsFailed : "Das Laden der Bescheide ist fehlgeschlagen.",
      	planningNotificationSearchSearchButtonToolTip : "Bitte Status Tabellenspalten beachten, Spalteneinstellungen verbergen oder zeigen",
      	planningNotificationSearchTitleLabel : "Bescheid",
      	planningNotificationSearchTitleToolTip : "Titel des Bescheids bzw. des Dokuments",
      	planningNotificationSearchMetasToolTip : "Sie können Teile oder mehrere durch Leerzeichen getrennte Suchbegriffe eingeben.",
      	// planningNotificationSearchToToolTip : "TODO",

      	//// cdes/planning/notification/PlanningNotificationSharepointImportPage
      	planningNotificationSharepointImportGetMetaTagsFailed : "Das Laden der verfügbaren Meta-Attribute ist fehlgeschlagen.",
      	planningNotificationSharepointImportPageCaption : "Bescheid aus MSP importieren",
      	sharePointLoadFolderDocumentsFinished : "${count} Bescheide erfolgreich geladen. ",
      	sharePointLoadFolderDocumentsStarted : "Lade Bescheide...",

      	//// cdes/planning/notification/SharepointTreeModel
      	sharePointTreeModelGetFolderDocumentsFailed : "Das Laden der untergeordneten Dokumente und Ordner im Sharepoint-Baum ist fehlgeschlagen.",
      	sharePointTreeModelGetProjectFoldersFailed : "Das Laden der Sharepoint-Ordner (eine Baumebene unterhalb der Projekte) ist fehlgeschlagen.",
      	sharePointTreeModelGetProjectsFailed : "Das Laden der Sharepoint-Projekte ist fehlgeschlagen.",

      	//// cdes/planning/order/PlanningNotificationOrderChooseDialog
      	planningNotificationOrderChooseQuickSearchLabel : "Auflagentext, Bescheid, Projekt",
      	planningNotificationOrderChooseQuickSearchToolTip : "Auflagentext, Bescheid und Projekt nach einem beliebigen Text durchsuchen.  Verschiedene Suchbegriffe können durch Komma getrennt aneinandergehängt werden, wie z.B. 'Auftanken,Semmering'",

      	//// cdes/planning/order/PlanningNotificationOrderColumnWidget
      	// planningNotificationOrderColumnFullCaption : "TODO",
      	planningNotificationOrderColumnLeadTimeLabel : "Vorlaufzeit",
      	planningNotificationOrderColumnLeadTimeToolTip : "Vorlaufzeit",
      	// planningNotificationOrderColumnReducedCaption : "TODO",
      	planningNotificationOrderColumnSiteTypeLabel : "Anlagentyp",
      	planningNotificationOrderColumnStatutoryDutyFromLabel : "Beginn Rechtspflicht",
      	planningNotificationOrderColumnStatutoryDutyFromToolTip : "Beginn der Rechtspflicht",
      	planningNotificationOrderColumnStatutoryDutyIntervalLabel : "Intervall Rechtspflicht",
      	planningNotificationOrderColumnStatutoryDutyIntervalToolTip : "Intervall der Rechtspflicht",
      	planningNotificationOrderColumnStatutoryDutyToLabel : "Ende Rechtspflicht",
      	planningNotificationOrderColumnStatutoryDutyToToolTip : "Ende der Rechtspflicht",
      	planningNotificationOrderColumnTagLabel : "Schlagworte",
      	planningNotificationOrderColumnTagToolTip : "Schlagworte",
      	planningNotificationOrderColumnWorkflowNodeLabel : "Prüfdefinition",
      	planningNotificationOrderColumnWorkflowNodeToolTip : "Wer in welcher Phase des Prüflaufs für was zuständig ist",

      	//// cdes/planning/order/PlanningNotificationOrderEditPage
      	planningNotificationOrderEditAddTagLabel : "Dieser Auflage ein weiteres Schlagwort zuordnen",
      	planningNotificationOrderEditGetJoinFailed : "Das Laden der Auflage ist fehlgeschlagen.",
      	planningNotificationOrderEditPageGetEditInfoFailed : "Das Laden der auf der Seite vorhandenen Auswahlmöglichkeiten (z.B. Rechtspflichten) ist fehlgeschlagen.",
      	planningNotificationOrderEditProjectToolTip : "Das Projekt in dem sich der Bescheid befindet, dem die Auflage zugeordnet ist.",
      	planningNotificationOrderEditReferenceLabel : "Referenz",
      	planningNotificationOrderEditRemoveTagLabel : "Dieses Schlagwort entfernen",
      	planningNotificationOrderEditSaveFailed : "Das Speichern der Auflage ist fehlgeschlagen.  Ihre Änderungen wurden nicht gespeichert.",
      	planningNotificationOrderEditAskSaveDialogCaption : "Auflage speichern - Bescheid geändert",
      	planningNotificationOrderEditAskSaveDialogQuestion : "Sie haben für die Auflage einen neuen Bescheid ausgewählt. Wenn Sie fortfahren, werden vorhandene Prüferzuteilungen im Erfüllungsprozess, sowie bereits durchgeführte Prüfungen den namensgleichen Baulosen des neuen Bescheides zugeordnet. Fehlende Baulose im neuen Bescheid werden aut. ergänzt. Fortfahren?",
      	planningNotificationOrderEditSaveSuccessful : "Die Auflage wurde erfolgreich gespeichert.",
      	planningNotificationOrderEditSaveToolTip : "Die Änderungen an der Auflage speichern und zur Liste zurückkehren",
      	planningNotificationOrderEditTagLabel : "Schlagwort",
      	planningNotificationOrderCreateDefineWorkflowButtonCaption : "Hinzufügen und Erfüllungsprozess festlegen",
      	planningNotificationOrderCreateDefineWorkflowToolTip : "Die Auflage hinzufügen, und Projektbeteiligte für die Prüfung nominieren.",
      	planningNotificationOrderSaveDefineWorkflowButtonCaption : "Speichern und Erfüllungsprozess festlegen",
      	planningNotificationOrderSaveDefineWorkflowToolTip : "Die Änderungen an der Auflage speichern, und Projektbeteiligte für die Prüfung nominieren.",

      	//// cdes/planning/order/PlanningNotificationOrderEditWidget
      	planningNotificationOrderEditAddReferenceButtonCaption : "Referenz hinzufügen",
      	planningNotificationOrderEditAddReferenceCaption : "Neue Referenz hinzufügen",
      	planningNotificationOrderEditCreateCaption : "Auflage hinzufügen",
      	planningNotificationOrderEditCreateToolTip : "Die neue Auflage hinzufügen",
      	planningNotificationOrderEditEditCaption : "Auflage bearbeiten",
      	planningNotificationOrderEditExportedToMspLabel : "Auflage an MSP übergeben",
      	planningNotificationOrderEditExportedToMspToolTip : "Auflage an MSP übergeben",
      	planningNotificationOrderEditLoadReferenceCandidatesFailed : "Das Laden der möglichen Referenz-Ziele ist fehlgeschlagen.",
      	planningNotificationOrderEditPlanningNotificationLabel : "Bescheid",
      	planningNotificationOrderEditReferenceDocumentCaption : "Bescheid",
      	planningNotificationOrderEditSaveToolTip : "Die Änderungen an der Auflage abspeichern",
      	planningNotificationOrderEnvironmentallyRelevantLabel : "Umweltrelevant",
      	planningNotificationOrderExtractAuthorizedInspectorTooltip : "Kann manuell eingetragen werden",
      	planningNotificationOrderExtractDocumentPageToolTip : "Die ausgewählte Seite wird automatisch übernommen",
      	planningNotificationOrderExtractDocumentPositionTooltip : "Kann manuell eingetragen werden.",
      	planningNotificationOrderInvalidateWarningCaption : "Hinweis",
      	planningNotificationOrderInvalidateWarningMessage : "Sie sind gerade dabei, diese Auflage in den Status 'Auflage entfallen' zu überführen.  Bitte beachten Sie: Sobald Sie diese Änderung gespeichert haben, kann Sie nicht mehr rückgängig gemacht werden.",
      	planningNotificationOrderPageNumber : "Seite ${page}",
      	planningNotificationOrderSiteTypeLabel : "Anlagentyp",
      	planningNotificationOrderSiteTypeAddLabel : "Einen Anlagentyp hinzufügen.  Nur möglich, falls eine Rechtspflicht gewählt ist.",

      	//// cdes/planning/order/PlanningNotificationOrderExtractPage
      	planningNotificationOrderExtractChooseAndAppendButtonCaption : "Gewählten Text anhängen",
      	planningNotificationOrderExtractChooseAndAppendToolTip : "Ergänzt bereits gewählten Text bei Seitenumbruch.",
      	planningNotificationOrderExtractChooseAndReplaceButtonCaption : "Gewählten Text übernehmen",
      	planningNotificationOrderExtractChooseAndReplaceToolTip : "Dafür den gewünschten Text mit der Maus im Bescheid markieren.",
      	planningNotificationOrderExtractGoLeftToolTip : "Zur vorherigen Seite wechseln",
      	planningNotificationOrderExtractGoRightToolTip : "Zur nächsten Seite wechseln",
      	planningNotificationOrderExtractPageCaption : "Auflagen automatisiert aus Bescheid übernehmen",
      	planningNotificationOrderExtractPageGetBoundingBoxesFailed : "Die Extraktion der Seiten des PDF-Bescheids ist fehlgeschlagen.",
      	planningNotificationOrderExtractPageLabel : "Seite",
      	planningNotificationOrderExtractPageSelectLabel : "Seite ${pageNumber}/${numberOfPages}",
      	planningNotificationOrderExtractPageToolTip : "Seitenauswahl im Bescheid",
      	planningNotificationOrderExtractSaveAndExitButtonCaption : "Speichern und Beenden",
      	planningNotificationOrderExtractSaveAndExitToolTip : "Speichern und zur Hauptseite zurückkehren",
      	planningNotificationOrderExtractSaveAndNextButtonCaption : "Speichern und nächste Auflage übernehmen",
      	planningNotificationOrderExtractSaveAndNextToolTip : "Speichern, und gleich noch eine Auflage erfassen",
      	planningNotificationOrderExtractTextFailed : "Die Extraktion des ausgewählten Texts ist fehlgeschlagen.",

      	//// cdes/planning/order/PlanningNotificationOrderExtractWidget
      	// planningNotificationOrderExtractWidgetCaption : "TODO",

      	//// cdes/planning/order/PlanningNotificationOrderImportPage
      	planningNotificationOrderImportPageCaption : "CSV-Import von Auflagen",

      	//// cdes/planning/order/PlanningNotificationOrderImportWidget
      	planningNotificationOrderImportFailed : "Der Import der CSV-Datei ist fehlgeschlagen.",
      	planningNotificationOrderImportFailedSummaryCaption : "Import fehlgeschlagen",
      	planningNotificationOrderImportLabel : "Bitte wählen Sie eine Datei für den CSV-Import aus",
      	planningNotificationOrderImportResult : "Der Import wurde erfolgreich abgeschlossen.  Es wurden folgende laufende Nummern erzeugt: ${serialNumbers}.",
      	planningNotificationOrderImportResultSummaryCaption : "Import erfolgreich abgeschlossen",

      	//// cdes/planning/order/PlanningNotificationOrderListWidget
      	planningNotificationOrderListAskDeleteDialogCaption : "Auflage wirklich löschen?",
      	planningNotificationOrderListAskDeleteDialogQuestion : "Wollen Sie die Auflage mit der laufenden Nummer ${serialNumber} wirklich löschen? Bitte beachten Sie, dass eine Auflage nur dann gelöscht werden kann, wenn zu deren Erfüllungsprozess keine Prüfer zugeteilt sind!",
      	planningNotificationOrderListAskRemoveDialogCaption : "Referenz wirklich entfernen?",
      	planningNotificationOrderListAskRemoveDialogQuestion : "Wollen Sie die Referenz mit der laufenden Nummer ${serialNumber} wirklich entfernen?  Das Entfernen wird erst beim Speichern der Auflage wirksam.",
      	planningNotificationOrderListBaulosLabel : "Baulose",
      	planningNotificationOrderListDefineWorkflowToolTip : "Projektbeteiligte für die Prüfung nominieren.",
      	planningNotificationOrderListDeleteFailed : "Das Löschen der Auflage ist fehlgeschlagen.",
      	planningNotificationOrderListDeleteSuccess : "Die Auflage wurde erfolgreich gelöscht.",
      	planningNotificationOrderListDeleteToolTip : "Auflage löschen",
      	planningNotificationOrderListEditToolTip : "Auflage bearbeiten",
      	planningNotificationOrderListNoPersonsInWorkflow : "Keine Person zugeteilt",
      	planningNotificationOrderListPlanningNotificationLabel : "Bescheid / Baulose",
      	planningNotificationOrderListSerialNumberLabel : "Nummer",
      	planningNotificationOrderListStatutoryDutyLabel : "Rechtspflicht",

      	//// cdes/planning/order/PlanningNotificationOrderPage
      	planningNotificationOrderAskExportToMspCaption : "Auflagen wirklich nach MSP übertragen?",
      	planningNotificationOrderAskExportToMspQuestionIgnoredClause : "${alreadyExportedCount} weitere haben zwar ebenfalls eine Rechtspflicht, wurden aber bereits exportiert und werden daher ignoriert. ",
      	planningNotificationOrderAskExportToMspQuestionInvalidatedClause : "${orderInvalidatedCount} Auflagen entfallen und werden ebenfalls ignoriert. ",
      	planningNotificationOrderAskExportToMspQuestionQuestion : "Wollen Sie fortfahren?",
      	planningNotificationOrderAskExportToMspQuestionSummary : "Es sind aktuell ${totalCount} Auflagen ausgewählt.  Falls Sie fortfahren, werden ${exportCount} dieser Auflagen aufgrund eingetragener Rechtspflicht nach MSP übertragen. ",
      	planningNotificationOrderChooseMspProjectForExportCaption : "Zielprojekt in MSP auswählen",
      	planningNotificationOrderExportListFailed : "Der Export der Auflagenliste ist fehlgeschlagen.",
      	planningNotificationOrderExportToMspButtonCaption : "Nach MSP exportieren",
      	planningNotificationOrderExportToMspButtonToolTip : "Nach MSP exportieren.  Nur möglich, wenn alle Auflagen im Suchergebnis demselben Projekt zugeordnet sind.",
      	planningNotificationOrderExportToPdfButtonToolTip : "Die Auflagenliste nach pdf exportieren",
      	planningNotificationOrderMspExportNoneFoundCaption : "Keine passenden Rechtspflicht-Auflagen",
      	planningNotificationOrderMspExportNoneFoundText : "Keine der ausgewählten Auflagen erfüllt die Bedingungen für einen Export nach MSP!  Die vorhandenen Rechte und Pflichten wurden schon an MSP übertragen oder entfallen.",
      	planningNotificationOrderMspExportFailed : "Bei der Übertragung der Auflagen nach MSP ist ein Fehler aufgetreten.",
      	planningNotificationOrderMspExportFinished : "Die Übertragung der Auflagen nach MSP wurde erfolgreich abgeschlossen.",
      	planningNotificationOrderNewButtonCaption : "Neue Auflage erstellen",
      	planningNotificationOrderNewButtonToolTip : "Auflage manuell erstellen",
      	planningNotificationOrderPageCaption : "Auflagen",
      	planningNotificationOrderPageGetJoinsFailed : "Die Suche ist aus technischen Gründen fehlgeschlagen.",
      	planningNotificationOrderPageGetPlanningNotificationOrderSearchInfoFailed : "Das Laden der für die Suchmaske benötigten Metadaten ist fehlgeschlagen.",
      	planningNotificationOrderPdfExportFinished : "Der Export der Auflagenliste wurde erfolgreich abgeschlossen.",
      	planningNotificationOrderPdfExportStarted : "Der Export der Auflagenliste läuft...",
      	planningNotificationOrderSearchSuccessful : "${count} Auflagen erfolgreich geladen",
      	planningNotificationOrderTriggerExportToMspFailed : "Beim Versuch, die Übertragung der Auflagen nach MSP anzustossen ist ein Fehler aufgetreten.",
      	planningNotificationOrderTriggerMspExportFinished : "Die Übertragung der Auflagen nach MSP läuft...",

      	//// cdes/planning/order/PlanningNotificationOrderSearchWidget
        planningNotificationOrderSearchAllStatutoryDuties : "Alle Rechtspflichten",
      	planningNotificationOrderAuthorizedInspectorLabel : "Sachverständiger",
      	planningNotificationOrderAuthorizedInspectorToolTip : "Der Sachverständige",
      	planningNotificationOrderBaulosLabel : "Baulose",
      	planningNotificationOrderBaulosToolTip : "Baulose",
      	planningNotificationOrderCommentLabel : "Kommentar",
      	planningNotificationOrderCommentToolTip : "Kommentar zur Auflage",
      	planningNotificationOrderDocumentPageLabel : "Seite",
      	planningNotificationOrderDocumentPageToolTip : "Seite",
      	planningNotificationOrderDocumentPositionLabel : "Vorschreibungspunkt",
      	planningNotificationOrderDocumentPositionToolTip : "Vorschreibungspunkt",
      	planningNotificationOrderEditStatutoryDutyToolTip : "Wird eine Art der Rechtspflicht ausgewählt, müssen die abhängigen Felder befüllt werden.",
      	planningNotificationOrderInvalidatedLabel : "Auflage entfällt",
      	planningNotificationOrderInvalidatedToolTip : "Gibt an, ob die Auflage entfallen ist",
      	planningNotificationOrderPersonInChargeLabel : "Durchführungsverantwortlicher",
      	planningNotificationOrderPersonInChargeToolTip : "Zuständiger der Rechtspflicht nach Übergabe / Inbetriebnahme",
      	planningNotificationOrderPlanningNotificationLabel : "Bescheid",
      	planningNotificationOrderPlanningNotificationToolTip : "Der Bescheid dem die Auflage zugeordnet ist.",
      	planningNotificationOrderProjectLabel : "Projekt",
      	planningNotificationOrderProjectToolTip : "Das Projekt dem der Bescheid und die Auflage zugeordnet ist.",
      	planningNotificationOrderReferenceLabel : "Referenz",
      	// planningNotificationOrderSearchFullCaption : "TODO",
      	planningNotificationOrderSearchIntervalLabel : "Intervall Rechtspflicht",
      	planningNotificationOrderSearchIntervalToolTip : "Intervall der Rechtspflicht, gemessen in Monaten",
      	planningNotificationOrderSearchLeadTimeLabel : "Vorlaufzeit",
      	planningNotificationOrderSearchLeadTimeToolTip : "Vorlaufzeit, gemessen in Monaten",
      	// planningNotificationOrderSearchReducedCaption : "TODO",
      	planningNotificationOrderSearchReferenceToolTip : "Kommaseparierte Liste von laufenden Nummern von Auflagen, die mit dieser Auflage verknüpft sind",
      	planningNotificationOrderSearchSearchButtonToolTip : "Bitte Status Tabellenspalten beachten, Spalteneinstellungen verbergen oder zeigen",
      	planningNotificationOrderSerialNumberLabel : "Lfd. Nummer",
      	planningNotificationOrderSerialNumberToolTip : "Die innerhalb ihres Projekts eindeutige laufende Nummer der Auflage.  Wird beim erstmaligen Speichern automatisch generiert.",
      	planningNotificationOrderSearchStatutoryDutyFromFromLabel : "Beginn Rechtspflicht",
      	planningNotificationOrderSearchStatutoryDutyFromFromToolTip : "Auflagen finden, deren Beginn der Rechtspflicht an oder nach diesem Termin liegt",
      	planningNotificationOrderSearchStatutoryDutyFromToToolTip : "Auflagen finden, deren Beginn der Rechtspflicht an oder vor diesem Termin liegt",
      	planningNotificationOrderSearchStatutoryDutyToFromLabel : "Ende Rechtspflicht",
      	planningNotificationOrderSearchStatutoryDutyToFromToolTip : "Auflagen finden, deren Ende der Rechtspflicht an oder nach diesem Termin liegt",
      	planningNotificationOrderSearchStatutoryDutyToToToolTip : "Auflagen finden, deren Ende der Rechtspflicht an oder vor diesem Termin liegt",
      	planningNotificationOrderSearchTagLabel : "Schlagworte",
      	planningNotificationOrderSearchTagToolTip : "Nach einem oder (kommasepariert) mehreren Schlagwörtern suchen",
      	planningNotificationOrderSourceLabel : "Verweis",
      	planningNotificationOrderSourceToolTip : "Textfeld zum Verweis auf andere Bescheide bzw. Texte",
      	planningNotificationOrderStateLabel : "Status",
      	planningNotificationOrderStateToolTip : "Der Prüfstatus der Auflage",
      	planningNotificationOrderStatutoryDutyExpiredLabel : "Rechtspflicht erloschen",
      	planningNotificationOrderStatutoryDutyExpiredToolTip : "Rechtspflicht erloschen",
      	planningNotificationOrderStatutoryDutyLabel : "Art der Rechtspflicht",
      	planningNotificationOrderStatutoryDutyToolTip : "Art der Rechtspflicht",
      	planningNotificationOrderSubjectAreaLabel : "Fachgebiet",
      	planningNotificationOrderSubjectAreaToolTip : "Das Fachgebiet, dem die Auflage zugeordnet ist.",
      	planningNotificationOrderSubmitAuthorityLabel : "Ist der Behörde vorzulegen",
      	planningNotificationOrderSubmitAuthorityToolTip : "Ist der Behörde vorzulegen",
      	planningNotificationOrderTextLabel : "Auflagentext",
      	planningNotificationOrderTextToolTip : "Der (möglicherweise recht ausführliche) Inhalt der Auflage.",

      	//// cdes/planning/project/PlanningNotificationProjectListWidget
      	planningNotificationProjectListAskDeleteProjectDialogCaption : "Projekt wirklich löschen?",
      	planningNotificationProjectListAskDeleteProjectDialogQuestion : "Soll das Projekt inklusive seiner Daten wirklich gelöscht werden?  Bitte überlegen Sie nochmals, diese Entscheidung kann nicht rückgängig gemacht werden. Derzeit kann ein Projekt nur gelöscht werden, wenn Sie vorher nach Möglichkeit alle Bescheide löschen.",
      	planningNotificationProjectListAskMakeProjectAdministratorDialogCaption : "Als Projektadministrator einteilen?",
      	planningNotificationProjectListAskMakeProjectAdministratorDialogQuestion : "Wollen Sie sich für dieses Projekt als Projektadministrator einteilen, um Rechte im Projektkontext zu erhalten?",
      	planningNotificationProjectListCodeColumn : "Kürzel",
      	planningNotificationProjectListCommentColumn : "Kommentar",
      	planningNotificationProjectListDeleteProjectFailed : "Das Löschen des Projekts ist fehlgeschlagen.",
      	planningNotificationProjectListDeleteProjectFailedCaption : "Fehler Projekt löschen",
      	planningNotificationProjectListDeleteProjectFailedToolTip : "Das Projekt konnte nicht gelöscht werden. Löschen Sie noch vorhandene Bescheide und versuchen Sie es erneut.",
      	planningNotificationProjectListDeleteProjectToolTip : "Das Projekt inklusive all seiner Daten (Bescheide usw.) löschen",
      	planningNotificationProjectListEditToolTip : "Projekt bearbeiten",
      	planningNotificationProjectListMakeProjectAdminFailed : "Beim Versuch, sich als Projektadministrator einzuteilen ist ein technischer Fehler aufgetreten.",
      	planningNotificationProjectListMakeProjectAdminToolTip : "Für dieses Projekt als Projektadministrator einteilen",
      	planningNotificationProjectListNameColumn : "Name",
      	planningNotificationProjectListShowProjectParticipationsToolTip : "Die Liste der dem Projekt zugeordneten Projektteilnehmer anzeigen",

      	//// cdes/planning/project/PlanningNotificationProjectPage
      	planningNotificationProjectPageCaption : "Projekte - Auflagenmanagement",
      	planningNotificationProjectPageGetProjectsFailed : "Das Laden der Projekte ist fehlgeschlagen.",
      	planningNotificationProjectPageNewToolTip : "Ein neues Projekt erstellen",
      	planningNotificationProjectSearchSuccessful : "${count} Projekte erfolgreich geladen",
      	projectPageNewLabel : "Neues Projekt erstellen",

      	//// cdes/planning/report/PlanningNotificationReportCoverWidget
      	planningNotificationReportCoverCommentLabel : "Kommentar Deckblatt",
      	planningNotificationReportCoverCommentTwoLabel : "Zusatzkommentar Deckblatt",
      	planningNotificationReportCoverCommentToolTip : "Ein beliebiger Berichtskommentar, der auf dem Deckblatt des Berichts erscheint.",
      	planningNotificationReportCoverPageCaption : "Deckblatt Report",

      	//// cdes/planning/report/PlanningNotificationReportDataWidget
      	planningNotificationReportDataMspButtonCaption : "Für MSP erstellen",
      	planningNotificationReportDataMspButtonToolTip : "Einen Bericht für den Export nach MSP erstellen.  Nach Erstellung und Kontrolle des Berichts können Sie entscheiden, ob der Bericht wirklich in dieser Form nach MSP übertragen werden soll.",
      	planningNotificationReportDataPageCaption : "Individueller Report",
      	planningNotificationReportExportStarted : "Die Erstellung des Berichts läuft...",
      	planningNotificationReportExportToMspRuns : "Der Export des Berichts nach MSP läuft...",

      	//// cdes/planning/report/PlanningNotificationReportOptionsWidget
      	planningNotificationReportDoGenerateCaption : "Erstellen",
      	planningNotificationReportDoGenerateToolTip : "Den Report erzeugen",
      	planningNotificationReportLoadProjectsFailed : "Das Laden der Projekte ist fehlgeschlagen.",
      	planningNotificationReportGotoCoverCaption : "Kommentar Deckblatt",
      	planningNotificationReportGotoCoverToolTip : "Das Deckblatt konfigurieren",
      	planningNotificationReportGotoDataCaption : "Weiter zur Datenauswahl",
      	planningNotificationReportGotoDataToolTip : "Die Daten für den individuellen Bericht auswählen",
      	planningNotificationReportOptionsDataFontSizeLabel : "Schriftgröße Tabelleninhalt",
      	planningNotificationReportOptionsFileFormatLabel : "Dateiformat",
      	planningNotificationReportOptionsFileFormatToolTip : "Dateiformat",
      	planningNotificationReportOptionsFileNameLabel : "Dateiname",
      	planningNotificationReportOptionsFileNameToolTip : "Optionaler Dateiname anstelle des automatisch generierten Dateinamens",
      	planningNotificationReportOptionsHeaderFontSizeLabel : "Schriftgröße Tabellenüberschriften",
      	planningNotificationReportOptionsLayoutFormatLabel : "Layoutformat",
      	planningNotificationReportOptionsLayoutFormatToolTip : "Layoutformat des Berichts",
      	planningNotificationReportOptionsOrderStatusLabel : "Status-Grafiken je Auflage erzeugen",
      	planningNotificationReportOptionsOrderStatusToolTip : "Status-Grafiken je Auflage erzeugen",
      	planningNotificationReportOptionsOverallStatusLabel : "Grafik für Gesamtstatus erzeugen",
      	planningNotificationReportOptionsOverallStatusToolTip : "Grafik für Gesamtstatus erzeugen",
      	planningNotificationReportOptionsPageCaption : "Report Optionen",
      	planningNotificationReportOptionsProjectLabel : "Projekt",
      	planningNotificationReportOptionsProjectTitle : "Der erzeugte Gesamtbericht enthält alle Auflagen in diesem Projekt",
      	planningNotificationReportOptionsTypeLabel : "Berichtsart",
      	planningNotificationReportOptionsTypeTitle : "Berichtsart",
      	planningNotificationReportTypeAll : "Gesamtbericht",
      	planningNotificationReportTypeIndividual : "individueller Bericht",

      	//// cdes/planning/report/PlanningNotificationReportPage
      	planningNotificationReportBackButtonCaption : "Zurück",
      	planningNotificationReportBackButtonToolTip : "Zurück",
      	planningNotificationReportConfigPageCaption : "Erstellung Bericht",
      	planningNotificationReportCreateRefusedMessage : "Der Report konnte leider nicht gespeichert werden.  Bitte geben Sie ihm einen noch nicht vergebenen Namen.",
      	planningNotificationReportDeleteFailed : "Das Löschen des Reports ist fehlgeschlagen.",
      	planningNotificationReportDeleteLocalStorageCaption : "Browserdaten löschen",
      	planningNotificationReportDeleteLocalStorageSuccess : "Die Browserdaten zum Reporting (u.a. Optionen, Kommentar, Suchfelder wie Bescheid oder Projekt, Spalteneinstellungen) wurden für dieses Netzwerk gelöscht.",
      	planningNotificationReportDeleteLocalStorageToolTip : "Löscht einige der im Browser zwischengespeicherten Daten (z.B. welches Projekt zuletzt gewählt wurde).  Dieser Button ist NUR in Testversionen verfügbar.",
      	planningNotificationReportDeleteSearchButtonToolTip : "Den Report löschen",
      	planningNotificationReportEditSearchButtonToolTip : "Den Report umbenennen",
      	planningNotificationReportForwardButtonCaption : "Weiter",
      	planningNotificationReportForwardButtonCaption : "Weiter",
      	planningNotificationReportGetSearchFailed : "Das Laden der Reports ist fehlgeschlagen.",
      	planningNotificationReportNewSearchButtonToolTip : "Einen neuen Report hinzufügen. Deckblattkommentar, Suchfelder und Optionen werden abgespeichert.",
      	planningNotificationReportOutputLocalStorageToLogCaption : "Browserdaten ins Log",
      	planningNotificationReportOutputLocalStorageToLogFailed : "Fehler beim Versuch, die Browserdaten ins Log zu schreiben.",
      	planningNotificationReportOutputLocalStorageToLogSuccess : "Die Browserdaten wurden erfolgreich ins Log geschrieben.",
      	planningNotificationReportOutputLocalStorageToLogToolTip : "Schreibt einige der im Browser zwischengespeicherten Daten (z.B. welches Projekt zuletzt gewählt wurde) für Fehleranalysezwecke ins Serverlog.  Dieser Button ist NUR in Testversionen verfügbar.",
      	planningNotificationReportSaveSearchButtonToolTip : "Änderungen an Deckblattkommentar, Suchfelder und Optionen des aktuell ausgewählten Reports abspeichern",
      	planningNotificationReportSaveSuccessful : "Der Report ${name} wurde erfolgreich abgespeichert.",
      	planningNotificationReportSearchLabel : "Report",
      	planningNotificationReportSearchToolTip : "Einen Report auswählen.  Deckblattkommentar, Suchfelder und Optionen werden daraus übernommen.",
        planningNotificationReportShowAllLabel : "Reports anderer Benutzer zeigen",
        planningNotificationReportShowAllToolTip : "Alle Reports anderer Benutzer zeigen, die sich im selben Netzwerk befinden und auf die Zugriff besteht.",
      	planningReportCreateSearchCaption : "Neuen Report hinzufügen",
      	planningReportEditSearchCaption : "Report umbenennen",
      	planningReportSearchAskDeleteDialogCaption : "Report wirklich löschen?",
      	planningReportSearchAskDeleteDialogQueston : "Wollen Sie den Report ${name} wirklich löschen?",

      	//// cdes/planning/report/PlanningNotificationReportSearchEditWidget
      	planningReportSearchEditNameLabel : "Name",

      	//// cdes/planning/report/PlanningNotificationReportSearchWidget
      	planningNotificationReportSearchDueDateFromLabel : "Erfüllungstermin von",
      	planningNotificationReportSearchDueDateFromToolTip : "Auflagen finden, die mindestens einen Erfüllungstermin an oder nach diesem Termin haben",
      	planningNotificationReportSearchDueDateRemarkLabel : "oder",
      	planningNotificationReportSearchDueDateRemarkToolTip : "Auflagen finden, für die mindestens einmal diese vom Projektfortschritt abhängige Umschreibung definiert ist",
      	planningNotificationReportSearchDueDateToLabel : "bis",
      	planningNotificationReportSearchDueDateToToolTip : "Auflagen finden, die mindestens einen Erfüllungstermin an oder vor diesem Termin haben",
      	planningNotificationReportSearchPositionPersonLabel : "durch",
      	planningNotificationReportSearchPositionPersonToolTip : "Auflagen finden, für die in mindestens einer Phase einer der hier angegebenen Prüfer eingetragen ist.",
      	planningNotificationReportSearchShowWorkflowLabel : "Prüfdefinition anzeigen",
      	planningNotificationReportSearchShowAttachmentLabel : "Anhang",
      	planningNotificationReportSearchShowBaulosLabel : "Baulos",
      	planningNotificationReportSearchShowBaulosToolTip : "Nach Baulosen suchen, die einem Erfüllungsprozess zugeordnet sind. Sie können Teile oder mehrere durch Leerzeichen getrennte Suchbegriffe eingeben.",
      	planningNotificationReportSearchShowIssuedLabel : "Datum",
      	planningNotificationReportSearchShowResultLabel : "Ergebnis",
      	planningNotificationReportSearchShowReviewColumnsLabel : "Spalten zu Prüfungen (nur pdf/xls):",
      	planningNotificationReportSearchShowReviewCommentLabel : "Kommentar",
      	planningNotificationReportSearchShowReviewerLabel : "Prüfer",
      	planningNotificationReportSearchShowTokenInitiatorLabel : "zu Durchführendem",
      	planningNotificationReportSearchShowWorkflowNodeNameLabel : "Knoten",
      	planningNotificationReportSearchShowReviewerBaulosToolTip : "Nach Baulosen suchen, die einer Prüfung zugeordnet sind. Sie können Teile oder mehrere durch Leerzeichen getrennte Suchbegriffe eingeben.",
      	planningNotificationSearchReviewSectionCaption : "Prüfungen",
      	planningNotificationSearchOrderSectionCaption : "Auflage",

      	//// cdes/planning/task/PlanningNotificationTaskColumnWidget
      	planningNotificationTaskColumnTaskToolTip : "Aufgabe",
      	planningNotificationTaskDueDateLabel : "Termin",
      	planningNotificationTaskDueDateToolTip : "Termin",
      	planningNotificationTaskTaskLabel : "Aufgabe",

      	//// cdes/planning/task/PlanningNotificationTaskListWidget
      	planningNotificationTaskListAskRemoveBatchDialogCaption : "Prüfung wirklich aus Signaturmappe entfernen?",
      	planningNotificationTaskListAskRemoveBatchDialogQuestion : "Wollen Sie die Prüfung der Auflage ${serialNumber} \"${text}\" wirklich aus der Signaturmappe entfernen?  Dies führt dazu, dass die Prüfung zu einem späteren Zeitpunkt komplett neu durchgeführt werden muss.  Eventuell hochgeladene Anhänge gehen verloren.",
      	planningNotificationTaskListAssignReviewToolTip : "Prüfung übertragen",
      	planningNotificationTaskListChooseParticipantDialogCaption : "Projektteilnehmer wählen",
      	planningNotificationTaskListDoReviewToolTip : "Die Prüfung durchführen",
      	planningNotificationTaskListDropWorkflowTokenFromBatchFailed : "Das Entfernen der Prüfung aus der Signaturmappe ist fehlgeschlagen.",
      	planningNotificationTaskListDropWorkflowTokenFromBatchSuccessful : "Die Prüfung wurde aus der Signaturmappe entfernt.  Sie muss zu einem späteren Zeitpunkt erneut durchgeführt werden.",
      	planningNotificationTaskListReassignFailed : "Beim Versuch, die Aufgabe zu übertragen ist ein Fehler aufgetreten.",
      	planningNotificationTaskListReassignSuccessful : "Die Aufgabe wurde erfolgreich übertragen.",
      	planningNotificationTaskListRemoveBatchToolTip : "Aus Signaturmappe entfernen, sodass die Prüfung anschließend wieder als Aufgabe zur Verfügung steht.",
      	planningNotificationTaskListReviewProtocolToolTip : "Prüfprotokoll öffnen",
      	planningNotificationTaskSelectionColumnLabel : "Selektiert",
      	planningTaskListSameChosenDialogCaption : "Prüferauswahl",
      	planningTaskListSameChosenDialogText : "Durch diese Aktion ergibt sich keinerlei Änderung in der Prüferzuteilung (da diesselbe Person ausgewählt wurde, die bereits bisher zugeteilt ist)",

      	//// cdes/planning/task/PlanningNotificationTaskPage
      	planningNotificationTaskExportListFailed : "Der Export der Aufgabenliste ist fehlgeschlagen.",
      	planningNotificationTaskExportToPdfButtonToolTip : "Die Aufgabenliste nach PDF exportieren",
      	planningNotificationTaskPageCaption : "Aufgaben",
      	planningNotificationTaskPageGetJoinsFailed : "Das Laden der Aufgaben ist fehlgeschlagen.",
      	planningNotificationTaskPdfExportFinished : "Der Export der Aufgabenliste wurde erfolgreich abgeschlossen, das PDF kann jetzt heruntergeladen werden.",
      	planningNotificationTaskPdfExportStarted : "Der Export der Aufgabenliste läuft...",
      	planningNotificationTaskSearchSuccessful : "${count} Aufgaben erfolgreich geladen",
      	planningNotificationTaskSearchSuccessfulMaxItems : "${count} Aufgaben erfolgreich geladen, aus Effizienzgründen werden nur ${maxItems} angezeigt, Sofortfilter etc. berücksichtigt aber alle",
      	planningNotificationTaskSelectAllCaption : "Alle",
      	planningNotificationTaskSelectLabel : "Alle Selektieren",
      	planningNotificationTaskSelectNoneCaption : "Keine",
      	planningNotificationTaskSignBatchCaption : "Signaturmappe signieren",
      	planningNotificationTaskSignBatchToolTip : "Alle Aufgaben in der Signaturmappe selektieren.",

      	//// cdes/planning/task/PlanningNotificationTaskSearchWidget

      	//// cdes/planning/task/ReviewPage
      	reviewPageCaption : "Prüfung Auflage ${serialNumber}",

      	//// cdes/planning/task/ReviewProtocolPage
      	reviewProtocolExportFailed : "Der Export des Prüfprotokolls ist fehlgeschlagen.",
      	reviewProtocolExportToPdfToolTip : "Das Prüfprotokoll nach Pdf exportieren.",
      	reviewProtocolGetTaskResultInfoFailed : "Das Abholen der Informationen zu Aufgabe und Prüfungen ist fehlgeschlagen.",
      	reviewProtocolHistoryCaption : "Bisherige Prüfungen",
      	reviewProtocolHistoryShowAllLabel : "Alle Baulose zeigen",
      	reviewProtocolOpenReviewsCaption : "Offene Prüfungen",
      	reviewProtocolPdfExportFinished : "Der Export des Prüfprotokolls wurde erfolgreich abgeschlossen.",
      	reviewProtocolPdfExportStarted : "Der Export des Prüfprotokolls läuft...",
        reviewProtocolPreviousOrderCaption : "Vorherige Auflage",
        reviewProtocolNextOrderCaption : "Nächste Auflage",
      	workflowReviewProtocolPageCaption : "Auflage \u2015 Prüfprotokoll",

      	//// cdes/planning/task/ReviewSignListWidget
      	reviewSignListAttachmentsColumnCaption : "Anhänge",
      	reviewSignListCommentColumnCaption : "Kommentar",
      	reviewSignListIssued : "geprüft am",
      	reviewSignListResultColumnCaption : "Ergebnis",
      	reviewSignListReviewerColumnCaption : "Prüfer",
      	reviewSignListReviewerPostfix : " stv. für ${personSurName} ${personGivenName}",
      	reviewSignListReviewerWithOrganisationPostfix : " stv. für ${personSurName} ${personGivenName} (${organisationName})",
      	reviewSignListReviewerPrefix : "${organisationName} (${personSurName} ${personGivenName})",

      	//// cdes/planning/task/ReviewSignWidget
      	reviewSignBatchSignFailed : "Beim Signieren der Prüfergebnisse ist ein Fehler aufgetreten.",
      	reviewSignBatchNoSuchFileException : "Bei zumindest einer Prüfung konnte der Dateianhang nicht gefunden werden. Bitte versuchen Sie die Datei nocheinmal hochzuladen.",
      	reviewSignPasswordToolTip : "Bitte hier das zum Signieren notwendige Passwort eingeben.",
      	reviewSignSignButtonToolTip : "Das obenstehende Prüfergebnis mit dem eingegebenen Passwort signieren.",
      	reviewSignSignFailed : "Beim Signieren des Prüfergebnisses ist ein Fehler aufgetreten. Ihre Daten konnten leider nicht gespeichert werden, und die Aufgabe bleibt offen.",
      	reviewSignNoSuchFileException : "Der Dateianhang konnte nicht gefunden werden. Bitte versuchen Sie die Datei nocheinmal hochzuladen.",
      	reviewSignWidgetCaption : "Prüfung bestätigen",

      	//// cdes/planning/task/WorkflowReviewResultWidget
      	workflowReviewResultAbortButtonToolTip : "Abbrechen und zur Eingabe des Prüfergebnisses zurückkehren.",
      	workflowReviewResultAddForLaterSignatureFailed : "Fehler beim Versuch, die Prüfung in die Signaturmappe zu geben.",
      	workflowReviewResultBatchButtonToolTip : "Die Prüfung in die Signaturmappe geben, um sie später gesammelt zu signieren.",
      	workflowReviewResultCaption : "Meine Prüfung \u2015 ${workflowNodeName}${baulos}",
      	workflowReviewResultCheckFileSizeFailed : "Die Prüfung der Dateigröße ist fehlgeschlagen.",
      	workflowReviewResultDeleteButton : "Die soeben hochgeladene Datei wieder entfernen.",
      	workflowReviewResultGetSafeHtmlFailed : "Fehler beim Validieren des als html eingegebenen Kommentars",
      	workflowReviewResultInitiatorLabel : "zu Durchführendem",
      	workflowReviewResultInitiatorToolTip : "Prüfer Knoten Durchführung",
      	workflowReviewResultMainParticipantLabel : "Verantwortlich",
      	workflowReviewResultMainParticipantToolTip : "Verantwortlicher dieser Prüfung",
      	workflowReviewResultNoResultChosenCaption : "Bitte Prüfergebnis wählen",
      	workflowReviewResultNoResultChosenText : "Bitte wählen Sie eine der über dem Signieren-Button angebotenen Optionen für das Prüfergebnis.",
      	workflowReviewResultSignButtonToolTip : "Die Prüfung sofort signieren",
      	workflowReviewResultSkipToolTip : "Diese Aufgabe überspringen, und die nächste prüfen",
      	workflowReviewResultTaskNumberLabel : "${taskNumber} / ${count}",
      	workflowReviewResultToNextLabel : "direkt zur nächsten",

      	//// cdes/planning/template/MetaTagEditPage
      	metaTagEditCreatePageCaption : "Meta-Tag hinzufügen",
      	metaTagEditCreationFailed : "Das Hinzufügen des Meta-Tags ist fehlgeschlagen.",
      	metaTagEditCssClassToolTip : "Auf Basis dieses Präfixes werden CSS-Klassen für die einzelnen Masken wo das MetaTag vorkommt generiert (z.B. Suchmasken, oder Editierdialoge).  Durch Hochladen einer Datei von CSS-Regeln können somit diese Masken rein durch Einsatz von CSS und ohne Codeänderungen relativ frei zusammengestellt werden.",
      	metaTagEditCssRulesLabel : "CSS-Regeln",
      	metaTagEditCssRulesToolTip : "Hier kann ein frei wählbarer Satz von CSS-Regeln hochgeladen werden, der zweckmäßigerweise auf das ebenfalls anzugebende CSS-Regel-Präfix abgestimmt werden sollte.",
      	metaTagEditEditPageCaption : "Meta-Tag bearbeiten",
      	metaTagEditLoadFailed : "Das Laden des Metatags ist fehlgeschlagen.",
      	metaTagListMandatoryColumn : "Pflichtfeld",
      	metaTagEditMandatoryToolTip : "Dem Metatag muss immer ein Wert zugewiesen werden.",
      	metaTagEditMultipleToolTip : "Gibt an, ob mehrere Zusatzinformationen dieser Art eingegeben werden können",
      	metaTagEditNameToolTip : "Der Name des Meta-Tags.  Wird in für breitere Benutzerkreise sichtbaren GUI-Elementen angezeigt.",
      	metaTagEditPositionToolTip : "Steuert die Reihenfolge der Attribute in der Tabelle",
      	metaTagEditShowAlwaysPriority : "Immer",
      	metaTagEditShowOnRequestPriority : "Optional",
      	metaTagEditPriorityLabel : "Sichtbarkeit",
      	metaTagEditPriorityToolTip : "Steuert die Sichtbarkeit in Suchmasken und dergleichen",
      	metaTagEditSharepointReferenceToolTip : "optionaler key (z.B. ows_-Baulose) der Sharepoint Referenz",
      	metaTagEditTagFormatToolTip : "Format des Metatags",
      	metaTagEditTypeToolTip : "Typ des Metatags",
      	metaTagEditUpdateFailed : "Das Speichern des Meta-Tags ist fehlgeschlagen.",

      	//// cdes/planning/template/MetaTagListWidget
      	metaTagDateTagFormat : "Datum",
      	metaTagDateTimeTagFormat : "Datum mit Zeit",
      	metaTagListAskDeleteCaption : "Meta-Tag wirklich löschen?",
      	metaTagListAskDeleteQuestion : "Wollen Sie das Meta-Tag wirklich löschen?",
      	metaTagListCssClassColumn : "Präfix für Css-Klassen",
      	metaTagListDeleteMetaTagFailed : "Das Löschen des Meta-Tags ist fehlgeschlagen.",
      	metaTagListDeleteNotPossible : "Das Meta-Tag konnte nicht gelöscht werden.  Es kann nur gelöscht werden, wenn es in keinem Bescheid verwendet wird.",
      	metaTagListDeleteToolTip : "Das Meta-Tag löschen.  Nur möglich, falls es noch nicht im Rahmen eines Bescheids verwendet wurde.",
      	metaTagListEditToolTip : "Das Meta-Tag bearbeiten",
      	metaTagListMultipleColumn : "Mehrfach",
      	metaTagListNameColumn : "Meta-Tag",
      	metaTagListPositionColumn : "Position",
      	metaTagListSharepointReferenceNameColumn : "Sharepoint Referenz",
      	metaTagListShowAlwaysPriority : "Immer",
      	metaTagListShowOnRequestPriority : "Optional",
      	metaTagListTagFormatColumn : "Format",
      	metaTagListTypeColumn : "Typ",
      	metaTagPlanningNotificationType : "Bescheid",
      	metaTagTextTagFormat : "Text",
      	metaTagWorkflowNodePositionOptionalType : "Erfüllungstermin optional",
      	metaTagWorkflowNodePositionType : "Erfüllungstermin",

      	//// cdes/planning/template/PlanningNotificationTemplateEditPage
      	planningNotificationTemplateEditAbortToolTip : "Abbrechen, und Änderungen an der Vorlage verwerfen.  Änderungen an den Meta-Tags bleiben gespeichert.",
      	planningNotificationTemplateEditCommentToolTip : "Ein beliebiger Kommentar zur Metadaten-Vorlage",
      	planningNotificationTemplateEditCreatePageCaption : "Metadaten-Vorlage hinzufügen",
      	planningNotificationTemplateEditCreateTemplateFailed : "Das Hinzufügen der Vorlage ist fehlgeschlagen.",
      	planningNotificationTemplateEditCreateToolTip : "Die neue Vorlage hinzufügen.  Meta-Tags können später hinzugefügt werden.",
      	planningNotificationTemplateEditEditPageCaption : "Metadaten-Vorlage bearbeiten",
      	planningNotificationTemplateEditGetTemplateInfoFailed : "Das Laden der Vorlage ist fehlgeschlagen.",
      	// planningNotificationTemplateEditGlobalToolTip : "TODO",
      	planningNotificationTemplateEditMetaTagSaveHint : "Hinweis: Meta-Tags können erst angelegt werden, nachdem die Vorlage mit Hilfe des Hinzufügen-Buttons angelegt worden ist.",
      	planningNotificationTemplateEditNameToolTip : "Name der Vorlage",
      	planningNotificationTemplateEditNewMetaTagButtonCaption : "Neues Meta-Tag hinzufügen",
      	planningNotificationTemplateEditNewMetaTagButtonToolTip : "Ein neues Meta-Tag zur Liste hinzufügen.  Es wird sofort gespeichert.",
      	planningNotificationTemplateEditSaveToolTip : "Änderungen an den Eigenschaften der Vorlage speichern.  Änderungen an den Meta-Tags werden unabhängig von diesem Button sofort gespeichert.",
      	planningNotificationTemplateEditUpdateTemplateFailed : "Das Speichern der Vorlage ist fehlgeschlagen.",

      	//// cdes/planning/template/PlanningNotificationTemplateListWidget
      	planningNotificationTemplateListAskDeleteCaption : "Vorlage wirklich löschen?",
      	planningNotificationTemplateListAskDeleteQuestion : "Wollen Sie die Vorlage wirklich löschen?",
      	planningNotificationTemplateListCommentColumn : "Kommentar",
      	planningNotificationTemplateListDeleteFailed : "Das Löschen der Vorlage ist aus technischen Gründen fehlgeschlagen.",
      	planningNotificationTemplateListDeleteNotPossible : "Die Vorlage konnte nicht gelöscht werden.  Möglicherweise enthält sie noch Meta-Tags, oder wird bereits im Rahmen von Bescheiden verwendet.",
      	planningNotificationTemplateListDeleteToolTip : "Die Vorlage löschen.  Nur möglich, falls sie keine Meta-Tags enthält, und in keinem Bescheid in Verwendung ist.",
      	planningNotificationTemplateListEditToolTip : "Die Vorlage und die ihr zugeordneten Meta-Tags bearbeiten",
      	planningNotificationTemplateListGlobalTemplateColumn : "Global",
      	planningNotificationTemplateListNameColumn : "Name",

      	//// cdes/planning/template/PlanningNotificationTemplatePage
      	planningNotificationTemplatePageCaption : "Metadaten-Vorlagen für Bescheide",
      	planningNotificationTemplatePageGetAllFailed : "Das Laden der Metadaten-Vorlagen ist fehlgeschlagen.",
      	planningNotificationTemplatePageNewLabel : "Neue Vorlage erstellen",
      	planningNotificationTemplatePageNewToolTip : "Neue Vorlage erstellen, und ihr Meta-Tags zuweisen.",

      	//// cdes/planning/util/PlanningNotificationHelper
      	planningNotificationHelperAskExportToMspCaption : "Report wirklich nach MSP exportieren?",
      	planningNotificationHelperAskExportToMspMessage : "Wollen Sie den soeben erstellten Report wirklich nach MSP exportieren?",
      	planningNotificationHelperChooseMspItemForExportCaption : "Bibliothek auswählen",
      	planningNotificationOrderReferenceLinkToolTip : "Die referenzierte Auflage öffnen",
      	planningNotificationOrderReferenceNoFollowPrivilege : "Aufgrund fehlender Berechtigungen im betreffenden Projekt ist eine Anzeige der Auflage nicht möglich.",
      	planningNotificationReportExportFailed : "Der Export des Berichts ist fehlgeschlagen.",
      	planningNotificationReportExportFinished : "Der Export des Berichts wurde erfolgreich abgeschlossen.",
      	planningNotificationReportExportToMspFinished : "Der Export des Berichts nach Msp wurde erfolgreich abgeschlossen.",
      	planningNotificationReportMspExportFailed : "Der Export des Berichts nach Msp ist fehlgeschlagen.",

      	//// cdes/planning/util/PlanningNotificationTitleMultiSearchWidget
      	planningTitleAddLabel : "Weitere Bescheide in die Suche aufnehmen",
      	planningTitleAddTitleLabel : "Weiteren Bescheid hinzufügen",
      	planningTitleAlterSearchLabel : "Ok",
      	planningTitleAlterSearchToolTip : "Die ausgewählten Bescheide bzw. Suchbegriffe in die Suche übernehmen",
      	planningTitleRemoveTitleLabel : "Den Bescheid aus der Suche entfernen",
      	planningTitleSearchChooseInfo : "${count} Bescheide/Suchbegriffe gewählt, Details siehe Tooltip",
      	planningTitleSearchComboBoxLabel : "Bescheid",
      	planningTitleSearchComboBoxTitle : "Bescheidtitel, oder Suchbegriff für Bescheide, nach dem gesucht wird",
      	planningTitleSearchConfigureTitlesCaption : "Mehrere Bescheide/Suchbegriffe zur Suche hinzufügen",
      	planningTitleSearchInfoTextBoxLabel : "Gesuchte Bescheide",
      	planningTitleSearchInfoTextBoxToolTip : "Gesuchte Bescheide und Suchbegriffe; zum Ändern der Liste bitte rechts klicken",

      	//// cdes/planning/util/PlanningTitleSearchTitleMultiContentWidget
      	// planningTitleSearchTitleMultiContentWidgetCaption : "TODO",

      	//// cdes/planning/workflow/DefineWorkflowPage
      	defineWorkflowCloseButtonToolTip : "Zur Hauptseite zurückkehren.  Eventuelle Änderungen wurden bereits beim Bestätigen der Unterdialoge gespeichert.",
      	defineWorkflowGetJoinFailed : "Das Laden des Erfüllungsprozesses ist fehlgeschlagen.",
      	defineWorkflowInitWorkflowButtonCaption : "Erfüllungsprozess initiieren",
      	defineWorkflowInitWorkflowQuestionCaption : "Erfüllungsprozess wirklich initiieren?",
      	defineWorkflowInitWorkflowQuestionText : "Wollen Sie den Erfüllungsprozess wirklich initiieren?",
      	defineWorkflowInitWorkflowToolTip : "Die Initiierung erfordert die Nominierung der Benutzer in den Rollen Durchführung und Freigabe.  Die Rolle Zustimmung der Durchführung ist optional.",
      	defineWorkflowInitializeWorkflowFailed : "Die Initiierung des Erfüllungsprozesses ist aus technischen Gründen fehlgeschlagen.",
      	defineWorkflowInitializeWorkflowNotPossibleText : "Der Prüflauf konnte nicht initiiert werden.  Bitte prüfen Sie, ob die Phasen Durchführung bzw. Freigabe besetzt sind, insbesondere ggf. auch in Hinblick auf korrespondierende Zuteilung von Baulosen.",
      	defineWorkflowInitializeWorkflowNotPossibleTitle : "Prüflauf konnte nicht initiiert werden",
      	defineWorkflowLongPageCaption : "Erfüllungsprozess \u2015 Auflage ${serialNumber}",
      	defineWorkflowReInitWorkflowButtonCaption : "Erfüllungsprozess erneut initiieren",
      	defineWorkflowShortPageCaption : "Erfüllungsprozess",
      	defineWorkflowResetWorkflowToolTip : "Erfüllungsprozess zurücksetzen und alle Prüfungen und Prüfer löschen",
      	defineWorkflowResetWorkflowTitle : "Erfüllungsprozess zurücksetzen",
      	defineWorkflowResetWorkflowText : "Wollen Sie den Erfüllungsprozess zurücksetzen und alle Prüfungen und Prüfer löschen?",
      	defineWorkflowResetWorkflowFailed : "Erfüllungsprozess zurücksetzen ist fehlgeschlagen.",
      	defineWorkflowResetResultWithPositions : "Prüfungen und Prüfer wurden erfolgreich gelöscht",
      	defineWorkflowResetResultWithoutPositions : "Prüfungen wurden erfolgreich gelöscht",
      	defineWorkflowResetButtonWithPositions : "Prüfungen und Prüfer löschen",
      	defineWorkflowResetButtonWithPositionsToolTip : "Erfüllungsprozess zurücksetzen: Prüfungen und Prüfer löschen",
      	defineWorkflowResetButtonWithoutPositions : "Prüfungen löschen",
      	defineWorkflowResetButtonWithoutPositionsToolTip : "Erfüllungsprozess zurücksetzen: Prüfungen löschen",

      	//// cdes/planning/workflow/DueDateEditWidget
      	dueDateEditAsDateLabel : "als Datum",
      	dueDateEditAsRemarkLabel : "abhängig vom Projektfortschritt",
      	dueDateEditDueDateLabel : "Erfüllungstermin",
      	dueDateEditExplicitDueDateLabel : "Konkretes Datum",
      	dueDateEditExplicitDueDateToolTip : "Ein konkretes Datum als Erfüllungstermin wählen",
      	dueDateEditRemarkDueDateLabel : "Relativer Termin",
      	dueDateEditRemarkDueDateToolTip : "Einen Termin relativ zum Baugeschehen (z.B. 'vor Inbetriebnahme') wählen",
      	dueDateEditUpdateDueDateFailed : "Das Abspeichern des geänderten Termins ist fehlgeschlagen.",

      	//// cdes/planning/workflow/OptionalDueDateEditWidget
      	optionalDueDateEditOptionalDueDateLabel : "Zwischentermin",
      	optionalDueDateEditOptionalDueDateToolTip : "",

      	//// cdes/planning/workflow/WorkflowActivityResultListWidget
      	workflowActivityResultListAttachment : "Anhang",
      	workflowActivityResultListBaulos : "Baulos",
      	workflowActivityResultListComment : "Kommentar",
      	workflowActivityResultListIssued : "Datum",
      	workflowActivityResultListResult : "Ergebnis",
      	workflowActivityResultListReviewer : "Prüfer",
      	workflowActivityResultListTokenInitiator : "zu Durchführendem",
      	workflowActivityResultListWorkflowNodeName : "Knoten",
      	workflowActivityResultListDeleteActivityResult : "Prüfung löschen",
      	workflowActivityResultListDeleteActivityResultAskDeleteDialogQuestion : "Wollen Sie die Prüfung wirklich löschen? ACHTUNG: Es werden auch vorhandene Aufgaben gelöscht.",
      	workflowActivityResultListDeleteActivityResultFailed : "Das Löschen der Prüfung ist fehlgeschlagen.",
      	workflowActivityResultListDeleteActivityResultSuccess : "Die Prüfung wurde erfolgreich gelöscht.",

      	//// cdes/planning/workflow/WorkflowNodeEditWidget
      	workflowNodeEditForbiddenCombinationCaption : "Fehler Prüfer-/Bauloszuordnung",
        workflowNodeEditForbiddenCombinationMessage : "Das Abspeichern dieser Prüferzuordnung ist fehlgeschlagen. Möglicherweise wird die gewählte Kombination von Prüfer-/Bauloszuordnungen aus technischen Gründen nicht unterstützt. Bitte überprüfen Sie zulässige Kombinationen gemäß Manual.",
        workflowNodeEditMissingValidEndNodeConfigMessage : "Das Abspeichern dieser Prüferzuordnung ist fehlgeschlagen. Zur gewählten Prüfer-/Bauloszuordnung fehlt ein gültiger Eintrag im Freigabeknoten. Bitte überprüfen Sie zulässige Kombinationen gemäß Manual.",
      	workflowNodeEditAlreadyExistingDialogCaption : "Prüfer bereits zugeteilt",
      	workflowNodeEditAlreadyExistingDialogContentStart : "Folgende Prüfer waren bereits vor Aufruf des Dialogs für die jeweiligen Baulose zugeteilt.  Die jeweiligen Eintragungen wurden weder ergänzt noch ersetzt, insbesondere wurden die bereits vorhandenen Termine nicht durch die soeben neu eingegebenen ersetzt.",
      	workflowNodeEditAlreadyExistingDialogContent : "Ein Baulos kann in den Phasen 'Zustimmung Durchführung' sowie 'Freigabe' nicht von mehreren Prüfern geprüft werden.  Ebensowenig kann ein Prüfer mehrfach für dieselbe Aufgabe eingeteilt werden.  Der Eintrag wurde weder ergänzt noch ersetzt, da bereits ein Eintrag für den folgenden Prüfer vorhanden ist:",
      	workflowNodeEditAlreadyExistingEntry : "Prüfer ${participation}, Baulos ${baulos}",
      	workflowNodeEditAlreadyExistingEntryWithoutMeta : "Prüfer ${participation}",
      	workflowNodeEditCaption : "${position}. Phase \u2015 ${name}",
      	workflowNodeEditAddParticipantButtonCaption : "Prüfer hinzufügen",
      	workflowNodeEditAddParticipantButtonToolTip : "Die ausgewählte Person als Prüfer hinzufügen.  Diese Änderung wird sofort gespeichert.",
      	workflowNodeEditAddParticipantDialogCaption : "Prüfer Hinzufügen",
      	workflowNodeEditAddWorkflowNodePositionsFailed : "Das Abspeichern der neuen Prüferzuordnung ist fehlgeschlagen.  Ihre Eingaben konnten leider nicht gespeichert werden.",
      	workflowNodeEditGetParticipationJoinsFailed : "Das Laden der möglichen Projektteilnehmer ist fehlgeschlagen.",
      	workflowNodeEditMultipleMandatoryTitle : "Hier können beliebig viele, mindestens jedoch ein Prüfer nominiert werden.",
      	workflowNodeEditMultipleTitle : "Hier können beliebig viele Prüfer nominiert werden.",
      	workflowNodeEditNewButtonToolTip : "Prüfer hinzufügen",
      	workflowNodeEditSingleMandatoryTitle : "Hier muss genau ein Prüfer nominiert werden.",
      	workflowNodeEditSingleTitle : "Hier kann maximal ein Prüfer nominiert werden.",

      	//// cdes/planning/workflow/WorkflowNodeParticipantChooseDialog
      	workflowNodeParticipantChooseBaulosColumnCaption : "Baulos",
      	workflowNodeParticipantChooseParticipantColumnCaption : "Projektteilnehmer",

      	//// cdes/planning/workflow/WorkflowNodePositionListWidget
      	workflowNodePositionListAskDeleteDialogCaption : "Prüfer entfernen?",
      	workflowNodePositionListAskDeleteDialogQuestion : "Wollen Sie wirklich den Prüfer ${participant} entfernen?",
      	workflowNodePositionListAskDeleteWithTaskDialogQuestion : "Achtung: Die vorhandene Aufgabe wird gelöscht!",
      	workflowNodePositionListAskDeleteWithTaskMoveDialogQuestion : "Achtung: Die vorhandene Aufgabe wird gelöscht und an den nächsten Knoten weitergereicht!",
        workflowNodePositionListAskReinitDialogCaption : "Prüfung reinitiieren?",
        workflowNodePositionListAskReinitDialogQuestion : "Wollen Sie wirklich die durch ${participant} durchgeführte und bereits abgeschlossene Prüfung erneut starten?",
      	workflowNodePositionListAskReplaceDialogCaption : "Prüfer ersetzen?",
      	workflowNodePositionListAskReplaceDialogQuestion : "Wollen Sie wirklich den Prüfer ${participant} ersetzen? Wenn Sie fortfahren, können Sie einen neue Person auswählen, die die Aufgabe dieses Prüfers übernimmt.",
      	workflowNodePositionListBaulosColumn : "Baulos",
      	workflowNodePositionListDeleteBlockedCaption : "Entfernen nicht erlaubt",

      	workflowNodePositionListDeleteBlockedText : "Der Prüfer darf nicht entfernt werden, da die Prüfung bereits zu weit fortgeschritten ist.",
      	workflowNodePositionListDeleteNoReleasePosition : "Freigabeknoten nicht besetzt.",
      	workflowNodePositionListDeleteNoReleasePositionForBaulos : "Prüfer kann nicht gelöscht werden, da in vorhergehenden Knoten bereits Prüfer zu diesem Baulos vorhanden sind oder der Prüfer dieses Knotens für alle Baulose zuständig ist.",
      	workflowNodePositionListDeleteTokenAtReleasePosition : "Prüfer kann nicht gelöscht werden, da eine Aufgabe vorhanden ist.",
      	workflowNodePositionListDeleteTokenCouldNotBeMoved : "Aufgabe konnte nicht an den nächsten Knoten weitergereicht werden.",
      	workflowNodePositionListDeleteHasAllreadyResult : "Löschen nicht möglich, da bereits Prüfergebnisse vorhanden sind.",

      	workflowNodePositionListDeletePositionFailed : "Das Entfernen des Prüfers ist aus technischen Gründen fehlgeschlagen.",
      	workflowNodePositionListDeleteProjectToolTip : "Projektteilnehmer löschen",
      	workflowNodePositionListDueDateColumn : "Erfüllungstermin",
        workflowNodePositionListReinitBlockedCaption : "Reinitiierung der Prüfung nicht möglich",
        workflowNodePositionListReinitBlockedText : "Die Reinitiierung der Prüfung ist nicht möglich.  Sie ist nur möglich, sie bereits einmal abgeschlossen wurde, und derzeit in keiner Phase des Prüfstrangs eine offene Prüfung existiert.",
        workflowNodePositionListReinitFailed : "Die Reinitiierung der Prüfung ist aus unbekannten technischen Gründen fehlgeschlagen.",
        workflowNodePositionListReinitToolTip : "Den Prüfstrang (von der Durchführung bis zur Freigabe) zu diesem Prüfer nochmals starten",
        workflowNodePositionListRestoreToolTip : "Fehlenden Prüfstrang zu diesem Prüfer wieder herstellen",
      	workflowNodePositionListReplaceParticipantDialogCaption : "Prüfer Ersetzen",
      	workflowNodePositionListReplaceParticipantButtonCaption : "Prüfer ersetzen",
      	workflowNodePositionListReplaceParticipantButtonToolTip : "Den alten Prüfer durch die ausgewählte Person ersetzen.  Diese Änderung wird sofort gespeichert.",
      	workflowNodePositionListReplaceProjectToolTip : "Projektteilnehmer durch anderen ersetzen",
      	workflowNodePositionListReplaceWorkflowNodePositionsFailed : "Das Abspeichern der neuen Prüferzuordnung ist fehlgeschlagen.  Ihre Eingaben konnten leider nicht gespeichert werden.",
      	workflowNodePositionListDeleteOptionalDueDateToolTip : "Zwischentermin löschen",
      	workflowNodePositionListEditDueDateCaption : "Erfüllungstermin bearbeiten",
      	workflowNodePositionListEditDueDateToolTip : "Erfüllungstermin bearbeiten",
      	workflowNodePositionListEditOptionalDueDateCaption : "Zwischentermin bearbeiten",
      	workflowNodePositionListEditOptionalDueDateToolTip : "Zwischentermin bearbeiten",
      	workflowNodePositionListNewDueDateCaption : "Erfüllungstermin hinzufügen",
      	workflowNodePositionListNewDueDateToolTip : "Mit dieser Funktion kann ein Termin für eine Prüfung definiert werden. Der Prüfer wird per mail dazu aufgefordert.",
      	workflowNodePositionListNewOptionalDueDateCaption : "Zwischentermin hinzufügen",
      	workflowNodePositionListNewOptionalDueDateToolTip : "Mit dieser Funktion kann ein Zwischentermin für eine laufende Prüfung definiert werden. Der Prüfer wird per mail dazu aufgefordert.",
      	workflowNodePositionListOptionalDueDateColumn : "Zwischentermin",
      	workflowNodePositionListProjectParticipantColumn : "Projektteilnehmer",

      	//// cdes/plot/PlotHelper
      	plotColorInColor : "Farbe",
      	plotColorLikeTemplate : "wie dargestellt",
      	plotColorMonochrome : "s/w",
      	plotMarginFoldWithEdge : "Falten mit 20mm Heftrand",
      	plotMarginFoldWithoutEdge : "Falten ohne Heftrand",
      	plotMarginNotFold : "Nicht falten",
      	plotPaperQualityInkjet80 : "Tintenstrahlplot 80g/m²",
      	plotPaperQualityInkjet90 : "Tintenstrahlplot 90g/m²",
      	plotPaperQualityLaser80 : "Laserplot 80g/m²",
      	plotPaperQualityLaser90 : "Laserplot 90g/m²",
      	plotScaleA0 : "A0",
      	plotScaleA1 : "A1",
      	plotScaleA2 : "A2",
      	plotScaleA3 : "A3",
      	plotScaleA4 : "A4",
      	plotScaleNone : "Keine",

      	//// cdes/plot/PlotOrderChargePage
      	plotOrderChargeAbortButtonToolTip : "Das Verrechnen der Plotaufträge abbrechen.",
      	plotOrderChargeGetDataFailed : "Das Laden der zu verrechnenden Plotaufträge ist fehlgeschlagen.",
      	plotOrderChargeGetDataOk : "Daten für ${numberOfPlotOrders} zu verrechnende Plotaufträge wurden erfolgreich geladen.",
      	plotOrderChargePageCaption : "Verrechnung von Plotaufträgen",
      	plotOrderChargePasswordToolTip : "Passwort, um die Plotaufträge als verrechnet zu markieren",
      	plotOrderChargeSignButtonToolTip : "Die Plotaufträge als verrechnet markieren, und dies mit einem eigenen gültigen Zertifikat signieren.",
      	plotOrderChargeSignFailed : "Der Versuch, die Plotaufträge für verrechnet zu erklären ist fehlgeschlagen.",
      	plotOrderChargeSignOk : "${numberOfPlotOrders} Plotaufträge wurden erfolgreich für verrechnet erklärt.",
      	plotOrderChargeSubCaption : "Die untenstehenden Plotaufträge für verrechnet erklären",

      	//// cdes/plot/PlotOrderEditPage
      	plotOrderEditMultipleReceiptsCaption : "Lieferscheine",
      	plotOrderEditMultipleReceiptsQuestionCaption : "Sammeldownload",
      	plotOrderEditMultipleReceiptsQuestionContent : "Dieser Plotauftrag enthält mehrere Lieferadressen für die separate Lieferscheine erzeugt werden müssen. Diese können Sie in Form eines komprimierten ZIP-Archivs herunterladen. Wenn Sie fortfahren werden Sie auf eine Übersichtsseite für Sammeldownloads navigiert, auf der Sie \'Datei Speichern\' beim entsprechenden Plotauftrag auswählen müssen.  Wollen Sie fortfahren?",
      	plotOrderEditOneReceiptCaption : "Lieferschein",
      	plotOrderEditPageCaption : "Plotauftrag",
      	plotOrderEditPageExportReceiptButtonCaption : "Lieferschein",
      	plotOrderEditPageExportReceiptButtonToolTip : "Den Lieferschein herunterladen.",
      	plotOrderEditPageExportToPdfButtonCaption : "Nach PDF exportieren",
      	plotOrderEditPageExportToPdfButtonToolTip : "Diesen Plotauftrag als PDF-Datei exportieren.",

      	//// cdes/plot/PlotOrderEditWidget
      	plotOrderEditBillingAddressLabel : "Rechnungsadresse: siehe Auftraggeber",
      	plotOrderEditClientCodeLabel : "Kundennummer: ",
      	plotOrderEditCommentLabel : "Zusätzliche Informationen: ",
      	plotOrderEditCompletionComment : "Bemerkung: ${comment}",
      	plotOrderEditCompletionDecision : "Entscheidung: ${decision}",
      	plotOrderEditCompletionPerson : "am ${date} durch ${person}",
      	plotOrderEditDeliveryDateLabel : "Liefertermin:",
      	plotOrderEditGetDataFailed : "Das Laden der Daten zum Plotauftrag ist fehlgeschlagen.",
      	plotOrderEditGetDataOk : "Detailinformationen zum Plotauftrag mit ${numberOfItems} Plotpositionen wurden erfolgreich geladen.",
      	plotOrderEditItemCaption : "Bestellte Positionen",
      	plotOrderEditJobNumberLabel : "Auftragsnummer: ",
      	plotOrderEditKindOfDeliveryLabel : "Art der Lieferung: ",
      	plotOrderEditNetworkLabel : "Netzwerk: ${networkName}",
      	plotOrderEditOrderCompletionCaption : "Auftragserledigung",
      	plotOrderEditOrderConfirmationCaption : "Auftragsbestätigung",
      	plotOrderEditOrderReceiptCaption : "Auftragseingang",
      	plotOrderEditProjectLabel : "Projekt: ${projectCode} ${projectName}",
      	plotOrderEditReceiptPerson : "am ${date} durch ${person}",
      	plotOrderEditReceiptDecision : "Entscheidung: ${decision}",
      	plotOrderEditReceiptComment : "Bemerkung: ${comment}",
      	plotOrderEditRequestCreatedLabel : "Datum: ",

      	//// cdes/plot/PlotOrderItemListWidget
      	plotOrderItemListAreaColumnCaption : "Fläche",
      	plotOrderItemListAreaLabel : "${area} m²",
      	plotOrderItemListAreaSum : "Flächensummen",
      	plotOrderItemListPagesColumnCaption : "Seiten",
      	plotOrderItemListAsDisplayedLabel : "Wie dargestellt",
      	plotOrderItemListAutomaticallyGeneratedLabel : "Automatisch generiert durch Prüfknoten \"${reviewCycleNodeName}\"",
      	plotOrderItemListBlackWhiteLabel : "S/W",
      	plotOrderItemListBlackWhiteSumLabel : "S/W ${area} m²",
      	plotOrderItemListColorColumnCaption : "Farbe",
      	plotOrderItemListColorLabel : "Farbe",
      	plotOrderItemListColorSumLabel : "Farbe ${area} m²",
      	plotOrderItemListCountColumnCaption : "Anzahl",
      	plotOrderItemListCountLabel : "${count} Stk",
      	plotOrderItemListDeleteButtonToolTip : "Diese Position des Plotauftrags löschen.  Nur möglich solange der Plotauftrag nicht entgegengenommen wurde.",
      	plotOrderItemListDeleteItemFailed : "Das Löschen der Plotposition ist fehlgeschlagen.",
      	plotOrderItemListDeleteItemOk : "Die Plotposition für den Plan mit der Nummer ${documentName} und dem Titel ${documentContent} wurde erfolgreich gelöscht.",
      	plotOrderItemListDeliveryColumnCaption : "Lieferung an",
      	plotOrderItemListDocumentNumberColumnCaption : "Plannummer",
      	plotOrderItemListItemLabel : "${item}: ${area} m²",
      	plotOrderItemListLikeTemplateSumLabel : "wie dargestellt ${area} m²",
      	plotOrderItemListManuallyGeneratedLabel : "Manuell generiert durch ${personName}",
      	plotOrderItemListMarginColumnCaption : "Falten",
      	plotOrderItemListMirrorColumnCaption : "Spiegeln",
      	plotOrderItemListPaperColumnCaption : "Papier",
      	plotOrderItemListPreviewButtonToolTip : "Vorschau öffnen",
      	plotOrderItemListPreviewTitle : "Plan ${documentName}",
      	plotOrderItemListReallyDeleteCaption : "Plotposition wirklich löschen?",
      	plotOrderItemListReallyDeleteText : "Wollen Sie die Plotposition für den Plan ${documentName} mit der Nummer ${documentNumber} wirklich löschen?",
      	plotOrderItemListReceivedColumnCaption : "entgegengenommen",
      	plotOrderItemListReceiverAddress : "${organisationName}<br>z.Hd. ${personCommonName}<br>${organisationPostalAddress}<br>${organisationPostalCode} ${organisationLocalityName}<br>${opCountryDescDe}",
      	plotOrderItemListScaleColumnCaption : "Skalieren",
      	plotOrderItemListTotalSumLabel : "Gesamtfläche ${area} m²",
      	plotOrderItemListTypeColumnCaption : "Typ",
      	plotOrderItemListPagesSumLabel : "Seiten ${pages}",

      	//// cdes/plot/PlotOrderPage
      	plotOrderPageCaption : "Plotaufträge",
      	plotOrderPageDeclareSelectedChargedButtonCaption : "Für verrechnet erklären",
      	plotOrderPageDeclareSelectedChargedButtonToolTip : "Alle unten selektierten, komplett entgegengenommenen Plotaufträge für verrechnet erklären",
      	plotOrderPageExportToPdfButtonCaption : "Nach PDF exportieren",
      	plotOrderPageExportToPdfButtonToolTip : "Die unten angezeigte Liste von Plotaufträgen als PDF exportieren.",
      	plotOrderPageLoadFailed : "Das Laden der Plotaufträge ist fehlgeschlagen.",
      	plotOrderPageLoadOk : "Es wurden ${numberOfPlotOrders} Plotaufträge erfolgreich geladen.",

      	//// cdes/plot/PlotOrderListWidget
      	plotOrderListAllOk : "alle ok",
      	plotOrderListChargedColumnCaption : "Verrechnet",
      	plotOrderListChargeNothingSelectedCaption : "Kein Plotauftrag ausgewählt",
      	plotOrderListChargeNothingSelectedMessage : "Bitte wählen Sie die Plotaufträge durch Selektion in der untenstehenden Liste aus.",
      	plotOrderListContractorColumnCaption : "Auftragnehmer",
      	plotOrderListCreationColumnCaption : "Erstellt",
      	plotOrderListCustomerColumnCaption : "Auftraggeber",
      	plotOrderListDeclinedState : "abgelehnt",
      	plotOrderListDeleteFailed : "Das Löschen des Plotauftrags ist fehlgeschlagen.",
      	plotOrderListDeleteOk : "Der Plotauftrag mit der Auftragsnummer ${jobNumber} wurde erfolgreich gelöscht.",
      	plotOrderListDeliveredAmountColumnCaption : "Lieferung",
      	plotOrderListDeliveryColumnCaption : "Abgeschlossen",
      	plotOrderListExportStarted : "Der Export der Plotauftragsliste läuft...",
      	plotOrderListExportFinished : "Der Export der Plotauftragsliste wurde erfolgreich abgeschlossen.",
      	plotOrderListExportFailed : "Der Export der Plotauftragsliste ist fehlgeschlagen.",
      	plotOrderListExportPlotOrderStarted : "Der Export des Plotauftrags als ZIP-Archiv läuft...",
      	plotOrderListExportPlotOrderFinished : "Der Export des Plotauftrags als ZIP-Archiv wurde erfolgreich abgeschlossen.",
      	plotOrderListExportPlotOrderFailed : "Der Export des Plotauftrags als ZIP-Archiv ist fehlgeschlagen.",
      	plotOrderListNotOk : "nicht ok",
      	plotOrderListNotOkState : "nicht ok",
      	plotOrderListOkState : "ok",
      	plotOrderListOrderNumberColumnCaption : "Auftragsnummer",
      	plotOrderListReceiptColumnCaption : "Angenommen",
      	plotOrderListReceivedState : "angenommen",
      	plotOrderListSomeOk : "${ok}/${notOk}",

      	////== Buttons
      	plotOrderListChargeButtonCaption : "Für verrechnet erklären",
      	plotOrderListChargeButtonToolTip : "Diesen Plotauftrag für verrechnet erklären",
      	plotOrderListDeleteButtonToolTip : "Diesen Plotauftrag löschen.  Nur möglich solange er nicht entgegengenommen wurde.",
      	plotOrderListDeliveryButtonCaption : "Lieferung bestätigen",
      	plotOrderListDeliveryButtonToolTip : "Bestätigung des Adressaten, dass er die Lieferung erhalten hat.",
      	plotOrderListEditButtonToolTip : "Die Einzelpositionen mit Papier, Farbe, Anzahl, etc. samt weiterer Informationen zum Plotauftrag anzeigen.  Hier können Einzelpositionen entfernt werden solange der Plotauftrag nicht entgegengenommen wurde.",
      	plotOrderListReallyDeleteCaption : "Plotauftrag wirklich löschen?",
      	plotOrderListReallyDeleteText : "Wollen Sie den Plotauftrag mit der Nummer ${plotOrderNumber} von ${customer} für ${contractor}, erstellt am ${creationDate} wirklich löschen?",
      	plotOrderListShowButtonToolTip : "Details des Plotauftrags anzeigen.",
      	plotOrderListZipExportButtonCaption : "Sammeldownload",
      	plotOrderListZipExportButtonToolTip : "Ein Zip-Archiv mit den Dokumenten zu den Einzelpositionen, sowie einer Gesamtübersicht herunterladen.",

      	checkAndCreatePlotTaskCaption : "Plotaufgabe prüfen und wieder herstellen",
      	checkAndCreatePlotTaskCaptionToolTip : "Wollen Sie wirklich für diesen Plotauftrag die Plotaufgabe prüfen und wieder herstellen.",

      	//// cdes/plot/PlotOrderSearchWidget
      	plotOrderSearchFromLabel : "Von",
      	plotOrderSearchFromToolTip : "Der frühestmögliche Zeitpunkt nach dem gesucht wird.  Bezieht sich auf Erstellungs-, Eingangs- und Lieferdatum gleichermassen.",
      	plotOrderSearchJobNumberLabel : "Auftragsnummer",
      	plotOrderSearchJobNumberToolTip : "Nach Auftragsnummern oder Teilen davon suchen.",
      	plotOrderSearchOrderAddressLabel : "Auftraggeber",
      	plotOrderSearchOrderAddressToolTip : "Nach dem Namen des Auftraggebers suchen.",
      	plotOrderSearchOrganisationLabel : "Auftragnehmer",
      	plotOrderSearchOrganisationToolTip : "Nach dem Namen des Auftragnehmers suchen.",
      	plotOrderSearchSearchButtonToolTip : "Plotaufträge gemäß obiger Suchkriterien suchen.",
      	plotOrderSearchShowCompleteLabel : "Abgeschlossene anzeigen",
      	plotOrderSearchShowCompleteToolTip : "Erledigte Aufträge werden vom Plotstudio als abgeschlossen markiert - auch solche hier anzeigen.",
      	plotOrderSearchToLabel : "Bis",
      	plotOrderSearchToToolTip : "Der spätestmögliche Zeitpunkt nach dem gesucht wird.  ",

      	//// cdes/plot/PlotOrderSignPage
      	plotOrderSignAdditionalInformationLabel : "Zusätzliche Informationen zum Plotauftrag",
      	plotOrderSignAdditionalInfoTextArea : "",
      	plotOrderSignDeliveryAddressLabel : "Rechnungsadresse: siehe Auftraggeber",
      	plotOrderSignDeliveryDateLabel : "Liefertermin: ",
      	plotOrderSignDeliveryKindOfDeliveryLabel : "Art der Lieferung: ${kindOfDelivery}",
      	plotOrderSignPageCaption : "Manuellen Plotauftrag bearbeiten und signieren (für Dokument ${documentName} ${documentContent})",
      	plotOrderSignSignFailed : "Das Hinzufügen bzw. Signieren des manuellen Plotauftrags ist fehlgeschlagen.  Möglicherweise wurde ein falsches Passwort eingegeben.",
      	plotOrderSignSignSuccessful : "Der Plotauftrag wurde erfolgreich erstellt und signiert.",

      	//// cdes/plot/PlotOrderTemplateAddressListWidget
      	plotOrderTemplateAddressListBillingColumnCaption : "Rechnungsadresse",
      	plotOrderTemplateAddressListPlotterColumnCaption : "Reproanstalt",

      	//// cdes/plot/PlotOrderTemplateChoosePage
      	plotOrderTemplateChooseCaption : "Manueller Plotauftrag für ${documentName} ${documentContent}",
      	plotOrderTemplateChooseLoadFailed : "Das Laden der Plotvorlagen ist fehlgeschlagen.",
      	plotOrderTemplateChoosePleaseChooseLabel : "Bitte wählen Sie eine der folgenden Vorlagen aus",

      	//// cdes/plot/PlotOrderTemplateChooseWidget
      	plotOrderTemplateChooseCreateButtonCaption : "Plotauftrag erstellen",
      	plotOrderTemplateWidgetChooseCaption : "Vorlage ${plotOrderTemplateName}",

      	//// cdes/plot/PlotOrderTemplateItemListWidget
      	plotOrderItemAreaCaption : "Fläche",
      	plotOrderItemColorCaption : "Farbe",
      	plotOrderItemCountCaption : "Anzahl",
      	plotOrderItemMarginCaption : "Falten",
      	plotOrderItemMirrorCaption : "Spiegeln",
      	plotOrderItemPaperQualityCaption : "Papier",
      	plotOrderItemScaleCaption : "Skalieren",

      	//// cdes/plot/PlotOrderTemplateWidget

      	//// cdes/project/ProjectEditPage
        projectEditBaulosForAllNodesLabel : "Erfüllungsprozess: Baulos in allen Phasen pflegen",
        projectEditBaulosForAllNodesToolTip : "Bei der Konfiguration des Erfüllungsprozesses in allen Phasen (nicht nur in der ersten Phase 'Durchführung') baulosspezifische Einträge hinzufügen können.",
      	projectEditCodeLabel : "Kürzel",
      	projectEditCodeToolTip : "Ein aus üblicherweise wenigen Buchstaben bestehendes Kürzel, mit dem das Projekt an verschiedenen Stellen bezeichnet wird.",
      	projectEditCommentLabel : "Kommentar",
      	projectEditCommentToolTip : "Ein beliebiger Kommentar zum Projekt",
      	projectEditCreateToolTip : "Das neue Projekt hinzufügen",
      	projectEditGetProjectFailed : "Das Laden der Projektdaten ist fehlgeschlagen.",
      	projectEditNameLabel : "Name",
      	projectEditNameToolTip : "Name des Projekts",
      	projectEditOrdinaryCreateCaption : "Neues Projekt hinzufügen",
      	projectEditOrdinaryEditCaption : "Projekt bearbeiten",
      	projectEditPlanningNotificationCreateCaption : "Neues Projekt Auflagenmanagement hinzufügen",
      	projectEditPlanningNotificationEditCaption : "Projekt Auflagenmanagement bearbeiten",
      	projectEditSaveFailed : "Das Abspeichern des Projekts ist fehlgeschlagen.  Ihre Änderungen konnten leider nicht gespeichert werden.",
      	projectEditSaveToolTip : "Die Änderungen am bestehenden Projekt speichern",

        //// cdes/project/ProjectParticipationSearchWidget
        participationSearchObjectPlannerPositionDefinitionLabel : "Objektblattposition",
        participationSearchObjectPlannerPositionDefinitionToolTip : "Objektblattposition",
        participationSearchPersonLabel : "Hauptverantwortlich",
        participationSearchPersonToolTip : "Hauptverantwortlich",
        participationSearchMainParticipantLabel : "Person beteiligt als",
        participationSearchMainParticipantItem : "Hauptverantwortlicher",
        participationSearchDeputyItem : "Stellvertreter",
        participationSearchOrganisationLabel : "Organisation",
        participationSearchOrganisationToolTip : "Organisation",
        participationSearchReviewCycleInstanceReleased : "Prüfblatt",
        participationSearchReviewCycleInstanceReleasedLabel : "Prüfblatt",
        participationSearchReviewCycleInstanceReleasedToolTip : "Prüfblatt",
        participationSearchReviewCycleLabel : "Prüflauf",
        participationSearchRoleLabel : "Rolle",
        participationSearchRoleToolTip : "Rolle",
        realm : "Fachbereich",

      	//// cdes/review/ReviewProtocol
      	reviewProtocolCaption : "Prüfprotokoll",
      	reviewProtocolExportFailed : "Der Export des Prüfprotokolls nach PDF ist fehlgeschlagen.",
      	reviewProtocolExportToPdfButtonToolTip : "Nach PDF exportieren",
      	reviewProtocolExportToPdfFinished : "Der Export des Prüfprotokolls nach PDF wurde erfolgreich abgeschlossen, Laufzeit ${duration}s",
      	reviewProtocolExportToPdfStarted : "Der Export des Prüfprotokolls nach PDF läuft...",
      	reviewProtocolLoadFailed : "Das Laden der für das Prüfprotokoll notwendigen Daten ist fehlgeschlagen.",
      	reviewProtocolObjectHeaderTitle : "Plan ${documentVersion} /// Projekt ${project} /// Objekt ${object} /// Objektblatt ${objectPlanner} /// km ${km}",
      	reviewProtocolReferenceCaption : "Verwendete Unterlagen",
      	reviewProtocolShowAllLabel : "Alle Knoten anzeigen",
      	reviewProtocolSvgStatusCaption : "Prüfstatus",
      	reviewProtocolVersionCaption : "Dokument und Versionen",
      	reviewProtocolVersionTitlePaneTitle : "${reviewCycleCellName} - Version ${versionPart}${suffix}",
      	reviewProtocolTitleReactivedSuffix : " (ungültig \u2015 vorhergehende Version reaktiviert) ",
      	reviewProtocolTitleReplacedSuffix : " (ungültig \u2015 freigegebene Version vorhanden) ",
      	reviewProtocolTitleRevisionSuffix : " (Revision zu freigegebenem Plan) ",

      	//// cdes/review/ReviewProtocolCrossCommentListWidget
      	reviewProtocolCrossCommentCaption : "Kommentare zu vorhergehenden Prüfungen \u2015 ${nodeName}",
      	reviewProtocolCrossCommentCommentCaption : "Kommentar zur Prüfung",
      	reviewProtocolCrossCommentNodeCaption : "Knoten",
      	reviewProtocolCrossCommentRealmCaption : "FB",
      	reviewProtocolCrossCommentResultCaption : "Ergebnis",
      	reviewProtocolCrossCommentResultDateCaption : "Datum",
      	reviewProtocolCrossCommentReviewCaption : "Prüfung",
      	reviewProtocolCrossCommentReviewerCaption : "Prüfer (Verantwortlicher)",

      	//// cdes/review/ReviewProtocolInvalidationListWidget
      	reviewCyclePositionResultAuthorized : "Die Aktion wurde mit dem AG abgesprochen.",
      	reviewProtocolAskDeletePositionResultDialogCaption : "Prüfung wirklich löschen?",
      	reviewProtocolDeletePositionResultButtonToolTip : "Prüfung löschen",
      	reviewProtocolDeletePositionResultDialogQuestion : "Wollen Sie die ausgewählte Prüfung vom ${resultDate} zur Version ${documentVersionName} wirklich löschen?  Dies kann nicht rückgängig gemacht werden.",
      	reviewProtocolDeletePositionResultNotPossible : "Die Prüfung vom ${resultDate} zur Version ${documentVersion} konnte leider nicht gelöscht werden.",
      	reviewProtocolDeletePositionResultSuccessful : "Die Prüfung vom ${resultDate} zur Version ${documentVersionName} wurde erfolgreich gelöscht.",
      	reviewProtocolInvalidationCommentCaption : "Kommentar",
      	reviewProtocolInvalidationPersonCaption : "Wer (Verantwortlich)",
      	reviewProtocolInvalidationResultDateCaption : "Datum",
      	reviewProtocolInvalidationResultOptionCaption : "Typ",
      	reviewProtocolPositionResultDeleteFailed : "Beim Löschen der Prüfung ist leider ein Fehler aufgetreten.",

      	//// cdes/review/ReviewProtocolNodeWidget
      	reviewProtocolNodeArrivalDate : "Start: ${arrivalDate}",
      	reviewProtocolNodeDeleteNodeResultButtonToolTip : "Knoten löschen, zurück zum vorhergehenden Knoten und Aufgaben generieren.",
      	reviewProtocolNodeDeleteNodeResultFailed : "Das Löschen des Knotens ist fehlgeschlagen.",
      	reviewProtocolNodeDeleteNodeResultNotPossible : "Das Löschen des Knotens ${name} ist nicht möglich.",
      	reviewProtocolNodeDeleteNodeResultSuccessful : "Der Knoten ${name} wurde erfolgreich gelöscht.",
      	reviewProtocolNodeDeletePositionResultDialogCaption : "Wirklich löschen?",
      	reviewProtocolNodeDeletePositionResultDialogQuestion : "Diese Funktion löscht den Knoten inklusive aller Prüfungen, und setzt den vorhergehenden Knoten wieder aktiv. Die entsprechenden Aufgaben werden generiert.  Voraussetzung für das Ausführen dieser Funktion ist, dass der zu löschende Knoten aktiv ist.  Wollen Sie wirklich fortfahren?",
      	reviewProtocolNodeDepartureDate : "Ende: ${departureDate}",
      	reviewProtocolNodeEndNodeGenerateMissingTasksToolTip : "Fehlende Prüferaufgaben erzeugen und obsolete löschen.",
      	reviewProtocolNodeGenerateMissingTasksDialogCaption : "Fehlende Aufgaben erzeugen?",
      	reviewProtocolNodeGenerateMissingTasksDialogQuestion : "Wollen Sie wirklich für diesen Knoten fehlende Aufgaben erzeugen sowie obsolete löschen?",
      	reviewProtocolNodeGenerateMissingTasksFailed : "Die Erzeugung der fehlenden Aufgaben ist fehlgeschlagen.",
      	reviewProtocolNodeGenerateMissingTasksNotPossible : "Die Erzeugung der fehlenden Aufgaben ist nicht möglich.",
      	reviewProtocolNodeGenerateMissingTasksSuccessful : "Die fehlenden Aufgaben wurden erfolgreich erzeugt.",
      	reviewProtocolNodeGenerateMissingTasksToolTip : "Fehlende Planeraufgabe erzeugen",
      	reviewProtocolNodeMoveToNextNodeButtonToolTip : "Den nächsten Knoten inklusive der entsprechenden Aufgaben erzeugen",
      	reviewProtocolNodeMoveToNextNodeDialogCaption : "Nächsten Knoten erzeugen?",
      	reviewProtocolNodeMoveToNextNodeDialogQuestion : "Wollen Sie wirklich den nächsten Knoten erzeugen?",
      	reviewProtocolNodeMoveToNextNodeFailed : "Die Erzeugung des nächsten Knoten ist fehlgeschlagen.",
      	reviewProtocolNodeMoveToNextNodeNotPossible : "Die Erzeugung des nächsten Knotens ist nicht möglich.",
      	reviewProtocolNodeMoveToNextNodeSuccessful : "Die Erzeugung des nächsten Knotens wurde erfolgreich abgeschlossen.",

      	//// cdes/review/ReviewProtocolOebbCommentListWidget
      	reviewProtocolOebbCommentCaption : "${nodeName} \u2015 Kommentare zu vorhergehenden Prüfungen",
      	reviewProtocolOebbCommentCommentCaption : "Kommentar zur Prüfung",
      	reviewProtocolOebbCommentNegativeResultLabel : "nicht zugestimmt",
      	reviewProtocolOebbCommentNoResultLabel : "\u2015",
      	reviewProtocolOebbCommentPositiveResultLabel : "zugestimmt",
      	reviewProtocolOebbCommentRealmCaption : "FB",
      	reviewProtocolOebbCommentResultCaption : "Ergebnis",
      	reviewProtocolOebbCommentReviewerCaption : "ad Prüfer (Verantwortlicher)",

      	//// cdes/review/ReviewProtocolPositionListWidget
      	reviewProtocolNoPositionsLabel : "Keine Einträge vorhanden",
      	reviewProtocolPositionAttachedReviewLabel : "[optionale Prüfung]",
      	reviewProtocolPositionAttachedPositionLabel : "[optionale Prüfung]",
      	reviewProtocolPositionDateCaption : "Datum",
      	reviewProtocolPositionNotReviewedLabel : "Aufgabe durchgewunken \u2015 Kommentar:",
      	reviewProtocolPositionOpenFile : "Dateianhang öffnen: ${fileName}",
      	reviewProtocolPositionOpenGraphicalReview : "Grafische Planprüfung öffnen",
      	reviewProtocolPositionOverridingLabel : "Verspätete Aufgabe übernommen von ${personCommonName} \u2015 Kommentar:",
      	reviewProtocolPositionRealmCaption : "FB",
      	reviewProtocolPositionResultCaption : "Ergebnis",
      	reviewProtocolPositionReviewCaption : "Prüfung",
      	reviewProtocolPositionReviewerCaption : "Prüfer (Verantwortlicher)",

      	//// cdes/review/ReviewProtocolReferenceWidget
      	reviewProtocolNoReferencesLabel : "Keine verwendeten Unterlagen vorhanden",
      	reviewProtocolReferenceCreatedCaption : "Datum",
      	reviewProtocolReferenceGzCaption : "Geschäftszahl",
      	reviewProtocolReferenceRealmCaption : "FB",
      	reviewProtocolReferenceReferenceCaption : "Verwendete Unterlagen für den gegenständlichen Plan",
      	reviewProtocolReferenceValidFor : "${sinceVersionPartA}${sinceVersionPartSeparator}${sinceVersionPartB} bis ${untilVersionPartA}${untilVersionPartSeparator}${untilVersionPartB}",
      	reviewProtocolReferenceValidForCaption : "gültig für Version",

      	//// cdes/review/ReviewProtocolResultListWidget
      	reviewProtocolResultDateCaption : "Datum",
      	reviewProtocolResultRealmCaption : "Stellungnahme zu",
      	reviewProtocolResultResultCaption : "Ergebnis",
      	reviewProtocolResultReviewCaption : "Kommentar",
      	reviewProtocolResultReviewerCaption : "Planer (verantwortlich)",

      	//// cdes/review/ReviewProtocolVersionWidget
      	reviewProtocolVersionDocumentDeletedCaption : "Dokument wurde gelöscht",
      	reviewProtocolVersionInvalidDocumentCaption : "Dokument wurde für ungültig erklärt",
      	reviewProtocolVersionResultCaption : "Stellungnahmen zu diesem Upload",
      	reviewProtocolVersionReviewAbortedCaption : "Prüfung abgebrochen",

      	//// cdes/task/TaskSearchWidget
      	taskSearchDateLabel : "Termin",
      	taskSearchExplicitDateLabel : "Explizite Datumsangabe",
      	taskSearchExplicitDateToolTip : "",
      	taskSearchFromLabel : "Von",
      	taskSearchGetCountsFailed : "Die Ermittlung der Anzahl der Aufgaben ist fehlgeschlagen.",
      	taskSearchGetTaskInfoFailed : "Das Laden der Projekte ist fehlgeschlagen.",
      	taskSearchModeBatchSignatures : "Signaturmappe",
      	taskSearchModeBelatedTasks : "Säumige Aufgaben",
      	taskSearchModeOpenTasks : "Offene Aufgaben",
      	taskSearchModeOwnTasks : "Meine Aufgaben",
      	taskSearchModeSelectLabel : "Aufgabenart",
      	taskSearchModeSearchTitle : "Legt fest, welche Aufgaben gefunden werden",
      	taskSearchQuickSearchLabel : "Sofortfilter",
        taskSearchQuickSearchStatus : "schränkt ein auf ${count} Aufgaben",
      	taskSearchRemarkDateLabel : "Datumsangabe durch Umschreibung",
      	taskSearchRemarkDateToolTip : "",
      	taskSearchToLabel : "bis",

      	//// cdes/task/TaskListWidget
      	taskListDueDateColumnCaption : "Termin",
      	taskListTaskColumnCaption : "Aufgabe",

      	//// cdes/util/CodeHelper
      	documentVersionStateActive : "Aktiv",
      	documentVersionStateAsBuilt : "Bestand",
      	documentVersionStateDeleted : "Upload widerrufen",
      	documentVersionStateInReview : "In Prüfung",
      	documentVersionStateInvalidatedAll : "Ungültig - Status U",
      	documentVersionStateInvalidatedVersion : "Ungültig - Status X",
      	documentVersionStateNotInReview : "Nicht freigegeben",
      	documentVersionStatePrereviewed : "Ohne Prüflauf",
      	documentVersionStateReleasedPositiv : "Freigegeben",
      	documentVersionStateReleasedNegativ : "Freigabe abgelehnt",
      	documentVersionStatusAborted : "Prüfung abgebrochen",
      	documentVersionStatusNoStatus : "Kein Status",
      	documentVersionStatusNotUploaded : "Nicht upgeloadet",
      	documentVersionStatusReplaced : "Durch Bestandsplan ersetzt",
      	reviewCycleStatusSearchDelay : "Verspätet",
      	reviewCycleStatusSearchLongDelay : "Verspätet (> 3 Tage)",
      	reviewCycleStatusSearchNoDelay : "Keine Verspätung",

      	//// cdes/util/MspHelper
      	mspHelperTriggerExportDocumentsNowFailure : "Bei der Verarbeitung der Exportaufträge ist ein Problem aufgetreten.  Bitte prüfen Sie den Status der Aufträge unter Netzwerke/Jobs",
      	mspHelperTriggerExportDocumentsNowRunning : "Die Verarbeitung der Exportaufträge läuft...",
      	mspHelperTriggerExportDocumentsNowSuccess : "Die Verarbeitung der Exportaufträge ist abgeschlossen.  Bitte prüfen Sie die Ergebnisse unter Netzwerke/Jobs.",

      	//// cdes/widget/CalendarSpinner
      	calendarSpinnerOpenCalendarLabel : "Kalender",
      	calendarSpinnerOpenCalendarToolTip : "Datum aus einem Kalender auswählen",

      	//// cdes/widget/ContextBar
      	contextBarGetAllNetworksFailed : "Das Laden der Liste aller Netzwerke ist fehlgeschlagen.",
      	contextBarNetworkCaption : "Netzwerk:",
      	contextBarNoNetworkSet : "(Kein Netzwerk gesetzt)",
      	contextBarNoNetworkSetWarning : "Bitte wählen Sie ein Netzwerk.  Ohne Netzwerk kann diese Maske nicht sinnvoll verwendet werden.",
      	contextBarProjectCaption : "Projekt:",
      	contextBarSetPlanningNotificationNetworkToTabSessionFailed : "Das Abspeichern des geänderten Netzwerks in den Kontext ist fehlgeschlagen.",
      	contextBarSubProjectCaption : "Subprojekt:",

        //// cdes/widget/base/SearchControllingWidget
        searchControllingPersonToolTip : "Angelegt von ${givenName} ${surName}",

      	//// cdes/widget/document/DocumentNumberEditor
      	documentNumberEditorNumberGroupSelectedCaption : "Plannummer Plantyp",
      	documentNumberEditorNumberGroupSelectedMessage : "Ungültige Auswahl einer Plantypgruppe. Bitte wählen Sie einen Plantyp innerhalb der Plantypgruppe aus.",
      	documentNumberEditorNumberSpinnerLabel : "Plannummer",
      	documentNumberEditorNumberSpinnerToolTip : "Legen Sie hier den Teil der Plannummer, der eindeutig pro Objektblatt bzw. Objekt ist (je nach konfiguriertem Plannummernschema) fest.",
      	documentNumberEditorTypeSelectLabel : "Plantyp",
      	documentNumberEditorTypeSelectToolTip : "Wählen Sie einen der Plantypen aus der Liste",
		documentNumberEditorPartSelectLabel : "Teil",
		documentNumberEditorPartSelectToolTip : "Wählen Sie einen Planteil aus der Liste",

      	//// cdes/widget/msp/AnlagentypImportDialog
      	anlagentypImportFileInfoLabel : "Datei ${name} hochgeladen (${size} KB)",
      	anlagentypImportFileLabel : "XLS-Datei",
      	anlagentypImportPleaseUploadLabel : "Bitte laden Sie eine XLS-Datei mit der Zuordnung von Anlagentypen zu Objektblättern hoch. Erzeugen Sie dazu die Datei zuerst mit Hilfe der Funktion 'Export der Objektliste nach Excel' auf der Seite 'Objekte' und ergänzen Sie anschließend in der letzten Spalte die Anlagentypen (einen pro Zelle).",

      	//// cdes/widget/msp/MspProjectChooseDialog
      	mspProjectChooseGetProjectsFailed : "Das Laden der MSP-Projekte ist fehlgeschlagen.",
      	mspProjectChooseProjectCaption : "Projekt",

      	//// cdes/widget/object/ObjectHeaderWidget
      	objectHeaderKmFromToLabel : "km von-bis",
      	objectHeaderNoPlannerDefined : "kein Planer definiert",
      	objectHeaderPlannerLabel : "Planer \u2015 ${organisationName} (${personCommonName}) ${plannerComment}",
      	objectHeaderReviewCycleInstanceLabel : "Prüfblatt \u2015 ${reviewCycleInstanceName}",

      	//// cdes/widget/project/ProjectParticipationMultiContentWidget
      	projectParticipationMultiAddParticipationLabel : "Weiteren Eintrag hinzufügen",
      	projectParticipationMultiRemoveParticipationLabel : "Eintrag löschen",

      	//// cdes/widget/project/ProjectParticipationMultiSelect
      	projectParticipationMultiSelectChooseInfo : "${count} Prüfer gewählt, Details siehe Tooltip",
      	projectParticipationMultiSelectConfigureTitlesCaption : "Prüfer zur Suche hinzufügen",
      	projectParticipationMultiSelectSelectLabel : "Prüfer",
      	projectParticipationMultiSelectSelectToolTip : "Prüfer, nach dem gesucht wird",
		projectParticipationMultiSelectAddLabel : "Prüfer zur Suche hinzufügen",
		projectParticipationMultiSelectEditLabel : "Prüfer bearbeiten",
		projectParticipationMultiSelectAlterSearchLabel : "Speichern",
		projectParticipationMultiSelectAlterSearchToolTip : "Liste der Prüfer speichern",

      	//// cdes/widget/search/SearchEditWidget
      	searchEditSaveRefusedMessage : "",
      	searchEditSaveOrUpdateFailed : "Das Abspeichern ist fehlgeschlagen.",

        //// cdes/widget/util/TextAreaDnDCellWidget
        textAreaDnDEditTranslationsCaption : "Übersetzungen",
        textAreaDnDEditTranslationsCaptionToolTip : "Weitere Übersetzungen verwalten",

        //// cdes/widget/util/MultiI18nTextAreaDialog
        multiI18nTextAreaTranslationLabel : "Übersetzung",
        multiI18nTextAreaTranslationToolTip : "Die Übersetzung in der entsprechenden Sprache.",


        //// cdes/project/ProjectParticipationColumnWidget
        participationColumnMainParticipantLabel : "Stellvertreter",
        participationColumnObjectPlannerPositionDefinitionLabel : "Objektblattposition",
        participationColumnParticipantLabel : "Verantwortlicher",
        participationColumnRealmLabel : "Fachbereiche",
        participationColumnReviewCycleInstanceLabel : "Prüfblatt",
        participationColumnReviewCycleLabel : "Basiert auf Prüflauf",

		//// metaTagNames
		planningNotificationMetaTag_Baulos : "Baulos",
		planningNotificationMetaTag_GZ : "GZ",
		planningNotificationMetaTag_Behörde : "Behörde",
		planningNotificationMetaTag_Verfahren : "Verfahren",
		planningNotificationMetaTag_Dokumentendatum : "Dokumentendatum",
		planningNotificationMetaTag_Gültigkeit : "Gültigkeit",
		planningNotificationMetaTag_Abschnitt : "Abschnitt",
		planningNotificationMetaTag_Strecke : "Strecke",
		planningNotificationMetaTag_kmvon : "km von",
		planningNotificationMetaTag_kmbis : "km bis",
		planningNotificationMetaTag_Schlagwort : "Schlagwort",
        participationColumnRoleLabel : "Rolle",

        //// cdes/person/OrganisationPersonEditWidget
        organisationPersonEditOrganisationLabel : "Organisation",
        organisationPersonEditOrganisationLabelToolTip : "Name der Organisation\nBeim Tippen wird eine Liste übereinstimmender bereits vorhandener Einträge angezeigt.",
        organisationPersonEditCertificateLabel : "Zertifikate: ",
        organisationPersonEditCertificateNoneLabel : "Keine Zertifikate, Einladungen oder Anforderungen vorhanden",
        organisationPersonEditCertificatePleaseCorrectFields : "'Speichern und Zertifizieren' ist erst verfügbar, wenn alle benötigten (gelben) Felder korrekt gefüllt sind.",
        organisationPersonEditValidCertificates : "${count} gültig",
        organisationPersonEditValidExpiresSoonCertificates : "${count} gültig aber bald ablaufend",
        organisationPersonEditExpiredCertificates : "${count} abgelaufen",
        organisationPersonEditInvitations : "${count} Einladungen",
        organisationPersonEditRequests : "${count} Anforderungen",

        organisationPersonEditCertificateCreateLabel : "Zertifikat nicht vorhanden",
        organisationPersonEditCertificateExistsLabel : "Zertifikat vorhanden (gültig bis ${certValidTo})",
        organisationPersonEditMultipleCertificatesExistsLabel : "Mehrere Zertifikate vorhanden",
        organisationPersonEditCertificateNotPossibleLabel : "Zertifikatsausstellung nicht möglich (kein geeignetes Basiszertifikat gefunden)",
        organisationPersonEditInactiveLabel : "Organisationszugehörigkeit inaktiv mit folgendem Kommentar",
        organisationPersonEditInactiveToolTip : "Organisationszugehörigkeit inaktiv",
        organisationPersonEditOrganisationalUnitLabel : "Abteilung",
        organisationPersonEditOrganisationalUnitToolTip : "",
        organisationPersonEditRetiredCommentLabel : "Kommentar zur inaktiven Organisationszugehörigkeit",
        organisationPersonEditMailSendModeLabel : "E-Mail Zustellung",
        organisationPersonEditMailSendModeToolTip : "Art der E-Mail-Zustellung.  Nur von der Person selbst änderbar.",
        organisationPersonEditMailSendTimeLabel : "um",
        organisationPersonEditMailSendTimeToolTip : "Zeitpunkt der E-Mail-Zustellung",
        organisationPersonEditSaveAndCertifyLabel : "Die neue Organisationszugehörigkeit speichern, und dann auf folgende Weise zertifizieren:",
        organisationPersonEditSaveAndInviteFailed : "Das Speichern und darauf folgende Einladen der neuen Organisationszugehörigkeit ist fehlgeschlagen.",
        organisationPersonEditUseAddressButtonLabel : "Adresse übernehmen",
        organisationPersonEditUseAddressButtonToolTip : "Die Adressdaten der Organisation übernehmen.",
        organisationPersonEditWidgetGetNetworkOrganisationNamesFailed : "Das Laden der möglichen Organisationen ist fehlgeschlagen.",

        //// cdes/person/PersonEditPage
        personEditPageAddOrganisationPersonLabel : "Organisationszugehörigkeit hinzufügen",
        personEditPageAddOrganisationPersonToolTip : "Der Person eine weitere Organisationszugehörigkeit hinzufügen",
        personEditPageAddTrainingButton : "Hinzufügen",
        personEditPageAddTrainingToolTip : "",
    	personEditPageCaption : "Person ${surName} ${givenName} bearbeiten",
      	personEditPageFetchPersonWithTrainingsFailedMessage : "Das Laden der Personendaten ist fehlgeschlagen.",
        personEditPageCreateCaption : "Person ${surName} ${givenName} hinzufügen",
        personEditPageEditCaption : "Person ${surName} ${givenName} bearbeiten",
        personEditPageShowCaption : "Person ${surName} ${givenName}",
        personEditPageDeleteOrganisationPersonToolTip : "Die Organisationszugehörigkeit löschen.  Nur möglich, wenn die Organisationszugehörigkeit noch nicht wirklich aktiv war, also beispielsweise irrtümlich angelegt wurde und sofort wieder gelöscht werden soll.",
        personEditPageFetchPersonsFailedMessage : "Das Laden der Personendaten ist fehlgeschlagen.",
        personEditPageOrganisationPersonClosedCaption : "Organisationszugehörigkeit ${organisationName} zeigen",
        personEditPageOrganisationPersonNewClosedCaption : "Neue Organisationszugehörigkeit ${organisationName} zeigen",
        personEditPageOrganisationPersonNewOpenCaption : "Neue Organisationszugehörigkeit ${organisationName} verbergen",
        personEditPageOrganisationPersonNewPleaseChoose : "Bitte Organisation für neue Organisationszugehörigkeit wählen",
        personEditPageOrganisationPersonOpenCaption : "Organisationszugehörigkeit ${organisationName} verbergen",
        personEditPageOrganisationPleaseChooseCaption : "Bitte Organisation auswählen",
        personEditPagePersonDataClosedCaption : "Personendaten", // " zeigen" entfernt wg. CDES-2635, Pkt. 2
        personEditPagePersonDataOpenCaption : "Personendaten", // " verbergen" entfernt wg. CDES-2635, Pkt. 2
        personEditSaveSucccessful : "Die Personendaten wurden erfolgreich gespeichert.",
        personEditPageSaveContinueEditingLabel : "Weiter Bearbeiten",
        personEditPageSaveContinueEditingToolTip : "Diese Warnung schließen, nicht speichern, und die Person weiter bearbeiten",
        personEditPageSaveIgnoreWarningAndSave : "Warnung ignorieren und speichern",
        personEditPageSaveIgnoreWarningAndSaveNewOrgPerson : "Person mit neuer Organisation speichern",
        personEditPageSaveOrUpdatePersonAndOrganisationPersonsFailed : "Das Speichern der Personendaten ist fehlgeschlagen.",
        personEditPageSaveSimilarPersonFound : "Ähnliche Personen gefunden",
        personEditPageTrainingCaption : "Schulungen",
        personEditPageTrainingToolTip : "",


        //// cdes/person/PersonEditWidget
        personEditFemaleLabel : "Frau",
        personEditFemaleToolTip : "",
        personEditGenderLabel : "Anrede",
        personEditGenderToolTip : "",
        personEditGivenNameLabel : "Vorname",
        personEditGivenNameToolTip : "\nBeim Tippen wird eine Liste übereinstimmender bereits vorhandener Einträge angezeigt.\nWenn Sie einen Eintrag der Liste auswählen, wird aut. auch der Nachname befüllt.",
        personEditLoginLabel : "Benutzername",
        personEditLoginToolTip : "",
        personEditMaleLabel : "Herr",
        personEditMaleToolTip : "",
        personEditRoleLabel : "Rolle",
        personEditRoleToolTip : "Die Basisrolle des Benutzers",
        personEditSurNameLabel : "Nachname",
        personEditSurNameToolTip : "\nBeim Tippen wird eine Liste übereinstimmender bereits vorhandener Einträge angezeigt.\nWenn Sie einen Eintrag der Liste auswählen, wird aut. auch der Vorname befüllt.",
        personEditTitleLabel : "Titel",
        personEditTitleToolTip : "",
        personEditUserLocaleLabel : "Benutzersprache",
        personEditUserLocaleToolTip : "Jene Sprache in der das Benutzerinterface angezeigt wird.",
        personEditZTPermissionLabel : "ZT-Befugnis",
        personEditZTPermissionToolTip : "",

        //// cdes/person/PersonListWidget
        personEditPageShowProjectParticipationsToolTip : "Projektbeteiligungen suchen und anzeigen",
        personListAskDeleteInvalidateDialogCaption : "Löschen?",
        personListAskDeleteInvalidateDialogText : "Wollen Sie die Person ${givenName} ${surName} wirklich löschen?",
        personListAskInvalidateDialogCaption : "Person löschen?",
        personListAskDeleteInvalidateDeleteItem : "unwiederbringlich gelöscht werden",
        personListAskDeleteInvalidateInvalidateItem : "lediglich inaktiv gesetzt werden",
        personListAskUndeleteDialogCaption : "Löschmarkierung entfernen?",
        personListAskUndeleteDialogText : "Soll die Löschmarkierung von der Person ${givenName} ${surName} entfernt werden?",
        personListDeleteButtonToolTip : "Die Person unwiderbringlich löschen.  Diese Option steht nur dann zur Verfügung, wenn die Person noch nicht im größeren Umfang aktiv war.",
        personListDeletePersonFailed : "Das Löschen der Person ist fehlgeschlagen.",
        personListDeleteInvalidateNotPossibleDialogCaption : "Löschen nicht möglich",
        personListDeleteInvalidateNotPossibleDialogText : "Die Person ${givenName} ${surName} kann nicht gelöscht werden.  Gründe:",
        personListDeleteNotPossibleDialogCaption : "Löschen nicht möglich",
        personListDeleteNotPossibleDialogText : "Die Person ${givenName} ${surName} kann nicht gelöscht werden, da für folgende Organisationszugehörigkeiten keine entsprechenden Berechtigungen vorhanden sind:",
        personListDeleteSuccessfulMessage : "Die Person ${givenName} ${surName} wurde erfolgreich gelöscht.",
        personListInvalidateButtonCaption : "Löschen",
        personListInvalidateButtonToolTip : "Die Person löschen.",
        personListInvalidatePersonFailed : "Das Löschen der Person ist fehlgeschlagen.",
        personListInvalidateSuccessfulMessage : "Die Person ${givenName} ${surName} wurde erfolgreich gelöscht.",
        personListOrganisationPersonColumnCaption : "Tel./Fax",
        personListOrganisationProjectRoleCaption : "Organisationen, Projektbeteiligungen und Rollen",
        personListProjectParticipationColumnCaption : "Projektbeteiligungen / Rollen",
        personListRoleColumnCaption : "Rolle (Verantwortlicher)",
        personListDeleteToolTip : "Die Person löschen.",
        personListUnit : "Abteilung",
        personListEmailPrefix : "e",
        personListPhonePrefix : "t",
        personListMobilePrefix : "m",
        personListFaxPrefix : "f",
        personListRoleLabel : "${role} (${surName} ${givenName})",
        personListEditToolTip : "Daten und Organisationszugehörigkeiten bearbeiten",
        personListGetUndeletableOrganisationPersonJoinsByPersonFailed : "Die Überprüfung, inwieweit die Organisation und ihre Organisationszugehörigkeiten gelöscht werden können, ist fehlgeschlagen.",
        personListInvalidateDialogText : "Die Person ${givenName} ${surName} kann nicht gelöscht werden, weil die folgenden Organisationszugehörigkeiten in Verwendung sind.",
        personListInvalidateDialogTextTwo : "Hinweis: Projektbeteiligungen in Verantwortung werden nach Möglichkeit an einen Stellvertreter übertragen, ansonsten gelöscht.\nProjektbeteiligungen in Vertretung werden gelöscht.",
        personListUndeleteSuccessful : "Die Löschmarkierung von Person ${givenName} ${surName} wurde erfolgreich entfernt.",
        personListUndeleteToolTip : "Löschmarkierung entfernen",
        personListWidgetUndeletePersonFailed : "Das Entfernen der Löschmarkierung ist fehlgeschlagen",
        personListPersonLoginCaption : "Login der Person anzeigen",

        //// cdes/person/PersonPage
        consortiumListFailed : "Der Export der ARGEnliste ist fehlgeschlagen.",
        consortiumPagePdfExportFinished : "Der Export der ARGEnliste wurde erfolgreich abgeschlossen.  Sie wird jetzt zum Download angeboten.",
        organisationListFailed : "Der Export der Organisationenliste ist fehlgeschlagen.",
        organisationPagePdfExportFinished : "Der Export der Organisationenliste wurde erfolgreich abgeschlossen.  Sie wird jetzt zum Download angeboten.",
        personPageCaption : "Personen",
        personPageNewButtonCaption : "Person hinzufügen",
        personPageNewButtonToolTip : "Eine neue Person hinzufügen",
        personPageGetSearchInfoFailed : "Das Laden der Zusatzinformationen für die Suchmaske ist fehlgeschlagen.",
        personPageLoadDataFailed : "Die Suche nach Personen ist fehlgeschlagen.",
        personPagePdfExportFailed : "Der Export der Personenliste ist fehlgeschlagen.",
        personPagePdfExportFinished : "Der Export der Personenliste wurde erfolgreich abgeschlossen.  Sie wird jetzt zum Download angeboten.",
        personPagePdfExportStarted : "Der Export der Personenliste läuft...",
        personPageSearchResult : "${count} Personen gefunden.",

        //// cdes/person/PersonSearchWidget
        personSearchNameLabel : "Name",
        personSearchNameToolTip : "Name der gesuchten Person, in der Abfolge 'Nachname Vorname' eingeben.\nBeim Tippen wird eine Liste übereinstimmender Einträge angezeigt.\nWenn Sie einen Eintrag der Liste auswählen, wird nach dessen ID gesucht!",
        personSearchOrganisationLabel : "Organisation",
        personSearchOrganisationToolTip : "Name der Organisation eingeben.\nBeim Tippen wird eine Liste übereinstimmender Einträge angezeigt.\nWenn Sie einen Eintrag der Liste auswählen, wird nach dessen ID gesucht!",
        personSearchNetworkLabel : "Netzwerk",
        personSearchNetworkToolTip : "Name des Netzwerkes eingeben.\nBeim Tippen wird eine Liste übereinstimmender Einträge angezeigt.\nWenn Sie einen Eintrag der Liste auswählen, wird nach dessen ID gesucht!",
        personSearchProjectLabel : "Beteiligt am Projekt",
        personSearchProjectToolTip : "Personen mit Beteiligung am gewählten Projekt anzeigen.\nBeim Tippen wird eine Liste übereinstimmender Einträge angezeigt.\nWenn Sie einen Eintrag der Liste auswählen, wird nach dessen ID gesucht!",
        personSearchRoleLabel : "in der Rolle",
        personSearchRoleToolTip : "Personen mit gewählter Rolle anzeigen.\nBeim Tippen wird eine Liste übereinstimmender Einträge angezeigt.\nWenn Sie einen Eintrag der Liste auswählen, wird nach dessen ID gesucht!",
        personSearchShowDetailsLabel : "Projektbeteiligungen und Rollen zeigen mit Filter",
        personSearchShowDetailsToolTip : "Die Projektbeteiligungen und Rollen als zusätzliche Spalte anzeigen, und optional den Inhalt der Zellen in dieser Spalte auf bestimmte Projekte bzw. Rollen einschränken",
		personSearchShowInvalidLabel : "Inaktive Personen anzeigen",
		personSearchShowInvalidToolTip : "",

        //// cdes/person/PersonTrainingListWidget
        personTrainingListCommentColumnCaption : "Kommentar",
        personTrainingListCommentToolTip : "",
        personTrainingListDateColumnCaption : "Datum",
        personTrainingListDateToolTip : "",
        personTrainingListTypeColumnCaption : "Schulungsart",
        personTrainingListTypeToolTip : "",

        //// cdes/person/SimilarPersonChooseDialog
        similarPersonChooseHeader : "Folgende Personen mit ähnlichem oder gleichem Namen existieren bereits im aktiven, oder in anderen Netzwerken:",
        similarPersonChooseHintOne : "Falls dieser Hinweis für Sie nicht relevant ist können Sie Ihre Eingaben trotzdem speichern.",
        similarPersonChooseHintTwo : "Alternativ können Sie das Speichern abbrechen, und beispielsweise Ihre Eingaben weiter bearbeiten, oder eine der angezeigten Personen mit einer weiteren Organisation verknüpfen.",
        similarPersonChooseHintThree : "Hinweis: Sie können ggf. auf den Übersichtsseiten der verschiedenen Netzwerke überprüfen, ob es sich um dieselbe Person wie in Ihrer Eingabe handelt.",
        similarPersonChooseOrganisationsColumnCaption : "Organisationszugehörigkeiten",

        //// cdes/project/ProjectParticipationPage
        participationPageCaption : "Projektbeteiligungen",
        participationPageLoadDataFailed : "Das Laden der Projektbeteiligungen ist fehlgeschlagen.",
        participationPageSearchInfoFailed : "Das Laden der für die Suchmaske nötigen Informationen ist fehlgeschlagen.",
        participationPageSearchResult : "Suche erfolgreich, es wurden [${count}] Projektbeteiligungen in [${duration}s] geladen.",

        //// cdes/organisation/ConsortiumListWidget
        consortiumListAskAddToNetworkCaption : "ARGE wirklich zum Netzwerk hinzufügen?",
        consortiumListAskAddToNetworkQuestion : "Wollen Sie die ARGE ${organisationName} wirklich mit dem eigenen Netzwerk ${networkName} verknüpfen?",
        consortiumListAskDeleteCaption : "ARGE ${organisationName} wirklich löschen?",
        consortiumListAskDeleteQuestion : "Wollen Sie die ARGE ${organisationName} wirklich unwiederbringlich löschen?",
        consortiumListDeleteNotPossibleDialogCaption : "Löschung nicht möglich",
        consortiumListDeleteNotPossibleDialogText : "Die ARGE ${organisationName} kann nicht gelöscht werden.  Gründe:",
        consortiumListEditToolTip : "Die ARGE und ihre Mitglieder bearbeiten",
        consortiumListReferenceToolTip : "Mit Netzwerk verknüpfen",
        consortiumListShowToolTip : "Die ARGE und ihre Mitglieder ansehen",
        consortiumListWidgetAddOrganisationToNetworkFailed : "Das Hinzufügen der ARGE zum aktiven Netzwerk ist fehlgeschlagen.",
        consortiumListWidgetAddOrganisationToNetworkSuccess : "Die ARGE ${organisationName} wurde erfolgreich zu folgenden Netzwerken hinzugefügt: ${networkNames}",
        consortiumListWidgetDeleteOrganisationFailed : "Das Löschen der ARGE ${organisationName} ist fehlgeschlagen.",
        consortiumListWidgetDeleteOrganisationSuccess : "Die ARGE ${organisationName} wurde erfolgreich gelöscht.",
        consortiumListWidgetGetOrganisationInUseHintsFailed : "Die Prüfung, ob die ARGE gelöscht werden kann ist fehlgeschlagen.",
        consortiumPageOrganisationsColumnCaption : "Organisationen",

        //// cdes/organisation/ConsortiumPage
        consortiumPageCaption : "ARGEN",
        consortiumPageGetAllNetworksFailed : "Das Laden der Netzwerke ist fehlgeschlagen.",
        consortiumPageLoadDataFailed : "Die Suche nach ARGEn ist fehlgeschlagen.",
        consortiumPageNewButtonCaption : "ARGE hinzufügen",
        consortiumPageNewButtonToolTip : "Eine neue ARGE hinzufügen",
        consortiumPagePdfExportFailed : "Der Export der ARGEnliste ist fehlgeschlagen.",
        consortiumPagePdfExportStarted : "Der Export der ARGEnliste läuft...",
        consortiumPageSearchResult : "${count} ARGEn gefunden.",

        //// cdes/organisation/ConsortiumSearchWidget
        consortiumSearchNameLabel : "ARGE",
        consortiumSearchNameToolTip : "Name der Arge eingeben.\nBeim Tippen wird eine Liste übereinstimmender Einträge angezeigt.\nWenn Sie einen Eintrag der Liste auswählen, wird nach dessen ID gesucht!",

        //// cdes/organisation/OrganisationListWidget
        organisationListAddressColumnCaption : "Kontakt",
        organisationListAskAddToNetworkCaption : "Organisation zum Netzwerk hinzufügen?",
        organisationListAskAddToNetworkQuestion : "Wollen Sie die Organisation ${organisationName} wirklich mit dem eigenen Netzwerk ${networkName} verknüpfen?",
        organisationListAskDeleteCaption : "Organisation ${organisationName} wirklich löschen?",
        organisationListAskDeleteQuestion : "Wollen Sie die Organisation ${organisationName} wirklich unwiederbringlich löschen?",
        organisationListAskRemoveCaption : "Organisation ${organisationName} wirklich entfernen?",
        organisationListAskRemoveQuestion : "Wollen Sie die Mitgliedschaft der Organisation ${organisationName} in der ARGE wirklich aufheben?  Falls Sie mit Ja antworten, wird die Änderung erst beim Speichern aktiv.",
        organisationListDeleteNotPossibleDialogCaption : "Löschung nicht möglich",
        organisationListDeleteNotPossibleDialogText : "Die Organisation ${organisationName} kann nicht gelöscht werden.  Gründe:",
        organisationListDeleteToolTip : "Die Organisation löschen",
        organisationListEditToolTip : "Die Organisation und ihre Mitarbeiter bearbeiten",
        organisationListPhoneColumnCaption : "Tel./Fax",
        organisationListNetwoksColumnCaption : "Netzwerke",
        organisationListReferenceToolTip : "Mit Netzwerk verknüpfen.",
        organisationListReferenceToolTipExt : "Derzeit verknüpft mit",
        organisationListRemoveToolTip : "Die Organisation entfernen",
        organisationListShowToolTip : "Die Organisation und ihre Mitarbeiter ansehen",
        organisationListWidgetAddOrganisationToNetworkFailed : "Das Hinzufügen der Organisation zum aktiven Netzwerk ist fehlgeschlagen.",
        organisationListWidgetAddOrganisationToNetworkSuccess : "Die Organisation ${organisationName} wurde erfolgreich zu folgenden Netzwerken hinzugefügt: ${networkNames}",
        organisationListWidgetDeleteOrganisationFailed : "Das Löschen der Organisation ${organisationName} ist fehlgeschlagen.",
        organisationListWidgetDeleteOrganisationSuccess : "Die Organisation ${organisationName} wurde erfolgreich gelöscht.",
        organisationListWidgetGetOrganisationInUseHintsFailed : "Die Prüfung, ob die Organisation gelöscht werden kann ist fehlgeschlagen.",

        //// cdes/organisation/OrganisationPage
        organisationPageCaption : "Organisationen",
        organisationPageChooseNetworkCaption : "Netzwerk für die Verknüpfung auswählen",
        organisationPageGetSearchInfoFailed : "Das Laden der Zusatzinformationen für die Suchmaske ist fehlgeschlagen.",
        organisationPageLoadDataFailed : "Die Suche nach Organisationen ist fehlgeschlagen.",
        organisationPageNewButtonCaption : "Organisation hinzufügen",
        organisationPageNewButtonToolTip : "Neue Organisation hinzufügen",
        organisationPagePdfExportFailed : "Der Export der Organisationenliste ist fehlgeschlagen.",
        organisationPagePdfExportStarted : "Der Export der Organisationenliste läuft...",
        organisationPageSearchResult : "${count} Organisationen gefunden.",

        //// cdes/organisation/OrganisationEditPage
        organisationEditGetOrganisationCreateInfoFailed : "Das Laden der Daten für die Hinzufügen-Maske ist fehlgeschlagen.",
        organisationEditGetOrganisationEditInfoFailed : "Das Laden der Organisationsdaten ist fehlgeschlagen",
        organisationEditGetOrganisationEditInfoSuccess : "Die Daten zur Organisation ${organisationName} wurden erfolgreich geladen.",
        organisationEditMemberClosedCaption : "Mitarbeiter zeigen",
        organisationEditMemberOpenCaption : "Mitarbeiter verbergen",
        organisationEditOrganisationDataClosedCaption : "Organisationsdaten", //Organisation zeigen
        organisationEditOrganisationDataOpenCaption : "Organisationsdaten", //Organisation verbergen
        organisationEditPageCreateCaption : "Organisation ${organisationName} hinzufügen",
        organisationEditPageEditCaption : "Organisation ${organisationName} bearbeiten",
        organisationEditPageGetSimilarOrganisationsFailed : "Das Ermitteln möglicher bereits vorhandener Organisationen ist fehlgeschlagen.",
        organisationEditPageSaveContinueEditingToolTip : "Diese Warnung ignorieren, nicht speichern, und die Organisation weiter bearbeiten.",
        organisationEditPageSaveOrUpdateOrganisationFailed : "Das Speichern der Organisation ${organisationName} ist fehlgeschlagen.",
        organisationEditPageShowCaption : "Organisation ${organisationName}",
        organisationEditSaveSuccessful : "Die Organisation ${organisationName} wurde erfolgreich gespeichert.",
        organisationEditPageSaveSimilarPersonFound : "Ähnliche Organisationen gefunden",
        organisationalUnitLabel : "Abteilung",

        //// cdes/organisation/OrganisationEditWidget
        organisationEditWidgetNameLabelToolTip : "Name der Organisation\nBeim Tippen wird eine Liste übereinstimmender bereits vorhandener Einträge angezeigt.",

        //// cdes/organisation/OrganisationMemberListWidget
        organisationMemberListEditToolTip : "Die Daten des Mitarbeiters ändern",
        organisationMemberListMailToolTip : "Eine Email an den Mitarbeiter schreiben",
        organisationMemberListShowToolTip : "Die Daten des Mitarbeiters ansehen",


        //// cdes/widget/mail/SendEmailPage
        sendEmailBodyLabel : "Inhalt",
        sendEmailFromLabel : "Von",
        sendEmailPageCaption : "Email an ${name} senden",
        sendEmailPageGetOrganisationPersonJoinsFailed : "Das Laden der für das Senden der Email nötigen Informationen ist fehlgeschlagen.",
        sendEmailPageSendEmailFailed : "Das Versenden der Email ist fehlgeschlagen.",
        sendEmailPageSendEmailSuccess : "Das Versenden der Email an ${receiver} wurde in die Wege geleitet.",
        sendEmailReceiverLabel : "An",
        sendEmailSendButtonCaption : "Senden",
        sendEmailSendButtonToolTip : "Die Email an den angegebenen Empfänger senden.  Der Absender erhält automatisch eine Kopie.",
        sendEmailSubjectLabel : "Betreff",
        sendEmailToContent : "${receiver} <${email}>",


        //// cdes/organisation/ConsortiumEditPage
        consortiumEditGetOrganisationEditInfoSuccess : "Die Daten zur ARGE ${organisationName} wurden erfolgreich geladen.",
        consortiumEditMemberClosedCaption : "Beteiligte Organisationen zeigen",
        consortiumEditMemberOpenCaption : "Beteiligte Organisationen verbergen",
        consortiumEditPageAddMemberToolTip : "Ein neues Mitglied hinzufügen",
        consortiumEditPageChooseMembersCaption : "Organisationen auswählen",
        consortiumEditPageCreateCaption : "ARGE ${organisationName} hinzufügen",
        consortiumEditPageEditCaption : "ARGE ${organisationName} bearbeiten",
        consortiumEditPageShowCaption : "ARGE ${organisationName}",
        consortiumEditPageGetNetworkOrganisationInfosFailed : "Das Laden der zur Auswahl stehenden Organisationen ist fehlgeschlagen.",
        consortiumEditPageGetSimilarConsortiumsFailed : "Das Ermitteln bereits vorhandener ähnlicher ARGEn ist fehlgeschlagen.",
        consortiumEditPageSaveContinueEditingToolTip : "Diese Warnung ignorieren, nicht speichern, und die ARGE weiter bearbeiten.",
        consortiumEditPageSaveOrUpdateOrganisationFailed : "Das Speichern der ARGE ${organisationName} ist fehlgeschlagen.",
        consortiumEditPageSaveSimilarConsortiumFound : "Ähnliche ARGE gefunden",
        consortiumEditSaveSucccessful : "Die ARGE ${organisationName} wurde erfolgreich gespeichert.",


        //// cdes/organisation/SimilarOrganisationChooseDialog
        similarOrganisationChooseHeader : "Folgende Organisationen mit gleichem oder ähnlichem Namen existieren bereits:",
        similarOrganisationChooseHintOne : "Organisationen, die noch nicht mit dem aktuellen Netzwerk verknüpft sind, werden grau dargestellt.  Sie haben rechts unter Aktionen die Möglichkeit, sie jetzt mit dem aktuellen Netzwerk zu verknüpfen (passende Berechtigungen vorausgesetzt).",
        similarOrganisationChooseHintTwo : "Sie haben jetzt die Möglichkeit, diesen Hinweis zu ignorieren und Ihre Eingaben trotzdem zu speichern, oder alternativ das Speichern abzubrechen und mit einer bereits vorhandenen Organisation weiterzuarbeiten.",

        passwordIllegalCharsWarning : "Das Passwort enthält nicht erlaubte Zeichen.  Erlaubt sind: Groß- und Kleinbuchstaben (inklusive Umlaute und ß), Ziffern, übliche Satz- und Sonderzeichen (d.h. .-_/\!?,:<>§$%&€), Klammern (d.h. ()[]\\{\\}).  Nicht erlaubt sind insbesondere Leerzeichen.",

        securityQuestionAnswerMissing: "Es wurde keine Antwort zur Sicherheitsfrage angegeben.",
        securityQuestionAnswerTooShort: "Die Antwort auf die Sicherheitsfrage muss mindestens ${minLength} Zeichen haben.",
        securityQuestionAnswerInvalidCharacters: "Die Antwort auf die Sicherheitsfrage enthält nicht zulässige Zeichen. Erlaubt sind: Groß- und Kleinbuchstaben (inklusive Umlaute und ß), Ziffern, übliche Satz- und Sonderzeichen (d.h. .-_/\!?,:<>§$%&€), Klammern (d.h. ()[]\\{\\}).  Nicht erlaubt sind insbesondere Leerzeichen."


    }),
    "it" : true,
    "en" : true,
    "sl" : true
});

// Local Variables:
// ispell-local-dictionary: "de_AT"
// End:
