/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
        "clazzes/TinyLog",
        "clazzes/dgrid/ItemChooseWidget",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/ContentWidget",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",       
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         TinyLog,
         ItemChooseWidget,
         ChooseDialog,                
         ContentWidget,
         domClass,
         domConstruct,
         domStyle,
         on,
         declare,
         lang,           
         i18n) {

    var className = "at.cdes.web.widget.choose.ItemChooseDialog";

    var log = new TinyLog(className);

    var ItemChooseDialog = declare(className, [ChooseDialog, ContentWidget], {

        // applicationContext
        // columns
        // selectionMode
        // idProperty

        constructChooseWidget : function() {
            // summary:
            //     Constructs the widget in which the user chooses some piece of data.
            // description:
            //     That widget must be saved in the variable this.content, and will 
            //     subsequently be placed in the dialog by superclass code.
            //     If some value is chosen by the user in that widget (e.g. a choosable 
            //     tree node is clicked), the subclass must call setChosenValue.  
            //     Optionally, after doing so, the subclass may emit the valueChosen 
            //     event, and close the dialog (e.g. on a double click into the tree).

            this.itemChooseWidget = new ItemChooseWidget({
                applicationContext : this.applicationContext,
                     selectionMode : this.selectionMode,
                        idProperty : this.idProperty,
                           columns : this.columns
            });         
            on(this.itemChooseWidget, "selectionChanged", lang.hitch(this, function(selectedItems) {
                this.selectedItems = selectedItems;
                this.updateWidgetState();               
            }));                
            this.content = this.itemChooseWidget.getContainer();

            this.itemChooseWidget.setData(this.items);
        },

        updateWidgetState : function() {
            // Button is constructed in ChooseDialog.show, call to constructWidgets,
            // however updateWidgetState might be called from ChooseDialog.show, call
            // to constructChooseWidget in the line above the constructWidgets call...            
            if (this.selectButton != null) {
                this.selectButton.set("disabled", this.asyncOperationRunning || this.selectedItems == null || this.selectedItems.length == 0);
            }
        },          

        emitValueChosen : function(buttonName) {
            on.emit(this, "valueChosen", this.selectedItems);
        },

        destroy : function() {
            this.inherited(arguments);
            this.itemChooseWidget.destroy();
        }
    });

    return ItemChooseDialog;
});
