define([
        "clazzes/TinyLog",
        "clazzes/util/DOMHelper",
        "dojo/dom-construct",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"  
],
function(
         TinyLog,
         DOMHelper,
         domConstruct,
         i18n) {
    
    var className = "at.cdes.web.util.DialogHelper";
    
    var log = new TinyLog(className);
    
    var DialogHelper = {


        addHint : function(topUlNode, tokens) {
            var levelNodes = [ topUlNode ];
            var prevToken = null;
            for (var n = 0; n < tokens.length; n++) {
                var token = tokens[n];
                if (token == "<ul>") {
                    levelNodes.push(domConstruct.create("ul", null, levelNodes[levelNodes.length - 1]));
                } else if (token == "</ul>" || token == "</table>" || token == "</tr>") {
                    levelNodes.splice(levelNodes.length - 1, 1);
                } else if (token == "<table>") {
                    levelNodes.push(domConstruct.create("table", null, levelNodes[levelNodes.length - 1]));
                } else if (token == "<tr>") {
                    levelNodes.push(domConstruct.create("tr", null, levelNodes[levelNodes.length - 1]));
                } else {
                    var parentTag = levelNodes[levelNodes.length - 1];
                    var parentTagName = parentTag.tagName.toLowerCase();
                    var tag;
                    var className;
                    if (parentTagName == "ul" && n == 0) {
                        tag = "li";
                        className = null;
                    } else if (parentTagName == "tr") {
                        tag = "td";
                        if (prevToken == "<tr>") {
                            className = "contextHintLeftColumn";
                        } else {
                            className = null;
                        }
                    } else {
                        tag = "div";
                        className = null;
                    }
                    DOMHelper.createTextNode(tag, token, levelNodes[levelNodes.length - 1], className);
                }
                prevToken = token;
            }
        }
    };

    return DialogHelper;
});
