define([ "clazzes/TinyLog",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/Select",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"
	],
	function(TinyLog,
			topic,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			Select,
			domClass,
			domConstruct,
			declare,
			lang,
			i18n
	) {

	var className = "at.cdes.widget.ContextBar";

	var log = new TinyLog(className);

	var ContextBar = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this,params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanDeliverCatalogue";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			//    		this.contextCaptionSpan = DOMHelper.createTextNode("span", i18n.contextBarContextCaption, topDiv, "contextBarContextCaption");
			this.networkCaptionSpan = DOMHelper.createTextNode("span", "", topDiv, "cdesContextBarCaption");
			if (this.editable) {
				this.networkSelect = new Select({
					label : i18n.contextBarNetworkCaption,
					title : i18n.contextBarNetworkCaption		    
				});
				domClass.add(this.networkSelect.domNode, "cdesContextBarNetworkSelect");		
				domConstruct.place(this.networkSelect.domNode, topDiv);

				WidgetHelper.handleSelectEvents(this.networkSelect, lang.hitch(this, this.propagateNetworkChange));
			} else {
				this.networkSpan = DOMHelper.createTextNode("span", "", topDiv, "cdesContextBarContent");
			}

			this.projectCaptionSpan = DOMHelper.createTextNode("span", "", topDiv, "cdesContextBarCaption");
			this.projectSpan = DOMHelper.createTextNode("span", "", topDiv, "cdesContextBarContent");    		
			this.subProjectCaptionSpan = DOMHelper.createTextNode("span", "", topDiv, "cdesContextBarCaption");
			this.subProjectSpan = DOMHelper.createTextNode("span", "", topDiv, "cdesContextBarContent");    		
			this.depth = ContextBar.Depth.SUB_PROJECT; //default depth

			return topDiv;
		},

		propagateNetworkChange : function() {
			var networkId = WidgetHelper.getSelectValue(this.networkSelect);

			if (networkId != this.networkId) {
				this.networkId = networkId;

				if (log.isDebugEnabled()) {
					log.debug("About to call setPlanningNotificationNetworkToTabSession with networkId = [" + this.networkId + "]");
				}

				this.registerAsyncOperationStarted(ContextBar.AsyncOperation.UPDATE_NETWORK);
				var tabSessionContextService = this.applicationContext.getService("tabSessionContextService");
				var setPnViewActive = true;
				if (this.mode == ContextBar.Mode.GENERAL)
					setPnViewActive = false;
				
				tabSessionContextService.setPlanningNotificationNetworkToTabSession(dojoConfig.tabSessionId, this.networkId, setPnViewActive).then(			
						lang.hitch(this, function(pageContext) {
							if (log.isDebugEnabled()) {
								log.debug("Completed setPlanningNotificationNetworkToTabSession with networkId = [" + this.networkId + "]");
							}

							this.applicationContext.setPageContext(pageContext);
							topic.publish("context/change");				
							this.registerAsyncOperationFinished(ContextBar.AsyncOperation.UPDATE_NETWORK);
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : ContextBar.AsyncOperation.UPDATE_NETWORK,
								opName : "setPlanningNotificationNetworkToTabSession",
								message : i18n.contextBarSetPlanningNotificationNetworkToTabSessionFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [setPlanningNotificationNetworkToTabSession]", err);
								}));
			}			
		},	    

		setData : function(params) {
			//depth 0 nothing, 1 network, 2 network+project, 3 network+project+subproject
			this.depth = params.depth;
			this.reload();    		
		},

		reload : function() {
			if (this.networks == null && this.editable) {
				var networkService = this.applicationContext.getService("networkService");
				this.registerAsyncOperationStarted(ContextBar.AsyncOperation.LOAD);
				networkService.getAllNetworks().then(
						lang.hitch(this, function(networks) {
							this.networks = networks;
							this.registerAsyncOperationFinished(ContextBar.AsyncOperation.LOAD);
							this.setupSelects();
							this.updateWidgetsFromData();
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : ContextBar.AsyncOperation.LOAD,
								opName : "getAllNetworks",
								message : i18n.contextBarGetAllNetworksFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [getAllNetworks]", err);
								}));
			} else {
				this.updateWidgetsFromData();		
			}		
		},

		setupSelects : function() {
			if (this.editable && this.networks != null) {
				var options = [];
				for (var n = 0; n < this.networks.length; n++) {
					var network = this.networks[n];
					options.push({ value : network.id, label : network.name });		    
				}

				options.sort(function(optionOne, optionTwo) {
					if (optionOne.label == null) {
						return 1;
					} else if (optionTwo.label == null) {
						return -1;
					} else {
						return optionOne.label.localeCompare(optionTwo.label);
					}			
				});		    

				this.networkSelect.set("options", options);		    
			}		
		},	    

		updateWidgetsFromData : function() {
			var contextService = this.applicationContext.getService("contextService");

			var pageContext = this.applicationContext.getPageContext();

			var network;
			var project;
			var subProject;
			if (this.mode == ContextBar.Mode.DEFAULT || this.mode == ContextBar.Mode.GENERAL) {
				network = this.applicationContext.getPageContextNetwork();
				project = this.applicationContext.getPageContextProject();
				subProject = this.applicationContext.getPageContextSubProject();		
			} else {
				network = this.applicationContext.getPageContextPnNetwork();
				project = this.applicationContext.getPageContextPnProject();
				subProject = null;		
			}		

			var networkName;
			var projectCode;
			var projectName;
			var subProjectCode;
			var subProjectName;	    
			if (network == null) {
				networkName = null;
			} else {
				networkName = network.name;
			}		

			if (project == null) {
				projectCode = null;
				projectName = null;		
			} else {
				projectCode = project.code;
				projectName = project.name;		
			}

			if (subProject == null) {
				subProjectCode = null;
				subProjectName = null;		
			} else {
				subProjectCode = pageContext.subProject.code + (pageContext.subProject.number != null ? pageContext.subProject.number : '');
				subProjectName = subProject.name;
			}		

			if (this.depth > 0){
				DOMHelper.setInnerText(this.networkCaptionSpan, i18n.contextBarNetworkCaption);
				if (this.editable) {
					var chosenHere = (network == null);		    
					var networkId;	    
					if (network == null) {
						var options = this.networkSelect.get("options");
						for (var n = 0; n < options.length; n++) {
							networkId = options[n].value;
							break;			    
						}			    
					} else {
						networkId = network.id;			
					}			

					this.networkSelect.set("value", networkId);

					if (chosenHere) {
						this.propagateNetworkChange();
					}			
				} else {
					DOMHelper.setInnerText(this.networkSpan, networkName ? networkName : "----");
				}		    

			}

			if (this.depth > 1){
				DOMHelper.setInnerText(this.projectCaptionSpan, i18n.contextBarProjectCaption);
				DOMHelper.setInnerText(this.projectSpan, projectCode && projectName ? projectCode + " " + projectName : "----");
			}

			if (this.depth > 2){
				DOMHelper.setInnerText(this.subProjectCaptionSpan, i18n.contextBarSubProjectCaption);
				DOMHelper.setInnerText(this.subProjectSpan, subProjectCode && subProjectName ? subProjectCode + " " + subProjectName : "----");
			}
		}
	});

	ContextBar.AsyncOperation = {
			LOAD: "Load",
			UPDATE_NETWORK : "UpdateNetwork"	
	};	

	ContextBar.Depth = {
			NOTHING : 0,
			NETWORK : 1,
			PROJECT : 2,
			SUB_PROJECT : 3
	};

	ContextBar.Mode = {
			DEFAULT : "Default",
			PLANNING_NOTIFICATION : "PlanningNotification",
			GENERAL : "General"	
	};

	return ContextBar;
});
