/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([
        "cdes/core/CdesVoc",
        "cdes/document/DocumentHelper",
        "cdes/review/ReviewProtocolReferenceWidget",
        "cdes/util/I18nHelper",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/Button",
        "dijit/form/CheckBox",
        "dijit/form/RadioButton",
        "dijit/form/Textarea",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/io-query",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
            CdesVoc,
            DocumentHelper,
            ReviewProtocolReferenceWidget,
            I18nHelper,
            TinyLog,
            DateHelper,
            FancyButton,
            topic,
            DOMHelper,
            ErrorHelper,
            WidgetHelper,
            ContentWidget,
            Button,
            CheckBox,
            RadioButton,
            Textarea,
            TextBox,
            domClass,
            domConstruct,
            domStyle,
            ioQuery,
            on,
            string,
            declare,
            lang,
            i18n
            ) {

    var className = "at.cdes.web.document.DocumentInvalidatePage";

    var log = new TinyLog(className);

    var DocumentInvalidatePage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);
            this.params = params;

            this.allFieldsValid = true;

            this.topDiv = this.constructTopDiv();

            this.reload();
        },

        getWidgetId : function() {
            return "DocumentInvalidatePage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "documentInvalidateTopDiv");

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            this.documentSectionDiv = this.constructDocumentSection();
            domConstruct.place(this.documentSectionDiv, topDiv);

            this.referenceDiv = this.constructReferenceSection();
            domConstruct.place(this.referenceDiv, topDiv);

            this.actionDiv = this.constructActionSection();
            domConstruct.place(this.actionDiv, topDiv);

            this.commentDiv = this.constructCommentSection();
            domConstruct.place(this.commentDiv, topDiv);

            this.buttonDiv = this.constructButtonSection();
            domConstruct.place(this.buttonDiv, topDiv);            

            // Search Widget
            /*
            this.searchWidget = new DocumentSearchWidget({
                applicationContext : this.applicationContext,
                		  cameBack : this.cameBack
            });
            this.searchWidgetDiv = this.searchWidget.getContainer();
            domConstruct.place(this.searchWidgetDiv, topDiv);
            on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));
            on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));
            */

            this.initialize();

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.documentInvalidateCaption, captionBarDiv, "cdesGeneralPageCaption");

            return captionBarDiv;
        },

        constructDocumentSection : function() {
            var sectionDiv = domConstruct.create("div", null, null);
            domClass.add(sectionDiv, "refNodeOfPositionAbsolute documentInvalidateSectionDiv");
            this.documentSectionCaptionDiv = DOMHelper.createTextNode("h3", "", sectionDiv,
                                                                      "fixedDialogWidget documentInvalidateNodeCaption");

            // DocumentVersion.name                                                                      
            DOMHelper.createTextNode("div", i18n.reviewProtocolVersionDocumentName, sectionDiv,
                                     "propertyLabel documentInvalidateDocumentNameLabel");

            this.nameTextBox = new TextBox({
                label : i18n.reviewProtocolVersionDocumentName,
                title : i18n.reviewProtocolVersionDocumentName,
                disabled : true
            });
            domClass.add(this.nameTextBox.domNode, "fixedDialogWidget documentInvalidateDocumentNameTextBox");
            domConstruct.place(this.nameTextBox.domNode, sectionDiv);

            // Document(Release).scale
            DOMHelper.createTextNode("div", i18n.reviewProtocolVersionDocumentScale, sectionDiv,
                                     "propertyLabel documentInvalidateDocumentScaleLabel");

            this.scaleTextBox = new TextBox({
                label : i18n.reviewProtocolVersionDocumentScale,
                title : i18n.reviewProtocolVersionDocumentScale,
                disabled : true
            });
            domClass.add(this.scaleTextBox.domNode, "fixedDialogWidget documentInvalidateDocumentScaleTextBox");
            domConstruct.place(this.scaleTextBox.domNode, sectionDiv);

            // Document(Release).content
            DOMHelper.createTextNode("div", i18n.reviewProtocolVersionDocumentContent, sectionDiv,
                                     "propertyLabel documentInvalidateDocumentContentLabel");

            this.contentTextBox = new TextBox({
                label : i18n.reviewProtocolVersionDocumentContent,
                title : i18n.reviewProtocolVersionDocumentContent,
                disabled : true
            });
            domClass.add(this.contentTextBox.domNode, "fixedDialogWidget documentInvalidateDocumentContentTextBox");
            domConstruct.place(this.contentTextBox.domNode, sectionDiv);

            return sectionDiv;
        },

        constructReferenceSection : function() {
            var sectionDiv = domConstruct.create("div", null, null);
            domClass.add(sectionDiv, "refNodeOfPositionAbsolute documentReferenceSectionDiv");
            this.referenceSectionCaptionDiv = DOMHelper.createTextNode("h3", i18n.reviewProtocolReferenceCaption, sectionDiv,
                                                                       "documentReferenceCaption");

            this.referenceWidget = new ReviewProtocolReferenceWidget({
                applicationContext : this.applicationContext
            });

            this.referenceTopDiv = this.referenceWidget.getContainer();
            domConstruct.place(this.referenceTopDiv, sectionDiv);

            return sectionDiv;
        },

        constructActionSection : function() {
            var actionDiv = domConstruct.create("div", null, null);

            DOMHelper.createTextNode("h4", i18n.documentInvalidateChooseAction, actionDiv, "");

            this.actionRow = domConstruct.create("div", null, null);
            domClass.add(this.actionRow, "documentInvalidateActionRow");
            domConstruct.place(this.actionRow, actionDiv);           

            return actionDiv;
        },

        constructCommentSection : function() {
            var commentDiv = domConstruct.create("div", null, null);
            domClass.add(commentDiv, "documentInvalidateCommentDiv refNodeOfPositionAbsolute");
            DOMHelper.createTextNode("div", i18n.comment, commentDiv, "propertyLabel documentInvalidateCommentLabel");

            this.commentTextArea = new Textarea({
                label : i18n.comment,
                title : i18n.comment
            });
            domClass.add(this.commentTextArea.domNode, "fixedDialogWidget documentInvalidateCommentTextArea");
            domConstruct.place(this.commentTextArea.domNode, commentDiv);
            WidgetHelper.handleTextBoxEvents(this.commentTextArea, lang.hitch(this, this.updateWidgetState));

            return commentDiv;
        },

        constructButtonSection : function() {
            var buttonDiv = domConstruct.create("div", null, null);
            domClass.add(buttonDiv, "documentInvalidateButtonDiv");

            // Back button
            this.backButton = new Button({
                label : i18n.back,
                title : i18n.backToolTip
            });
            domClass.add(this.backButton.domNode, "documentInvalidateBackButton");
            domConstruct.place(this.backButton.domNode, buttonDiv);
            on(this.backButton, "click", lang.hitch(this, this.goBack));

            // Password
            DOMHelper.createTextNode("div", i18n.passwordLabel, buttonDiv,
                                     "documentInvalidatePasswordLabel");

            this.passwordTextBox = new TextBox({
                label : i18n.passwordLabel,
                title : i18n.passwordLabel,
                type : "password"
            });
            domClass.add(this.passwordTextBox.domNode, "documentInvalidatePasswordTextBox");
            domConstruct.place(this.passwordTextBox.domNode, buttonDiv);
            WidgetHelper.handleTextBoxEvents(this.passwordTextBox, lang.hitch(this, this.updateWidgetState));
            WidgetHelper.setMustField(this.passwordTextBox, true);

            // Sign button
            this.signButton = new Button({
                label : i18n.signButtonLabel,
                title : i18n.signButtonLabel
            });
            domClass.add(this.signButton.domNode, "documentInvalidateSignButton");
            domConstruct.place(this.signButton.domNode, buttonDiv);
            on(this.signButton, "click", lang.hitch(this, this.sign));
            
            return buttonDiv;
        },

        goBack : function() {
            this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
        },

        sign : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var documentVersionId = this.documentListRow.documentVersion.id;
            var selectedOptionId = null;
            var selectedIdx = null;
            for (var n = 0; n < this.selectedOptions.length; n++) {
                if (this.selectedOptions[n]) {
                    selectedOptionId = this.documentListRow.invalidateOptions[n].id;
                    selectedIdx = n;
                }
            }
            var reactivate = selectedIdx != null
                && this.reactivateCheckBoxes != null && this.reactivateCheckBoxes[selectedIdx] != null
                && this.reactivateCheckBoxes[selectedIdx].get("checked");

            var authorizationCheckBox = this.authorizationCheckBoxes != null
                ? this.authorizationCheckBoxes[selectedIdx] : null;
            var authorized = authorizationCheckBox != null ? authorizationCheckBox.get("checked") : false;
            
            this.registerAsyncOperationStarted(DocumentInvalidatePage.AsyncOperation.SIGN);

	    var documentService = this.applicationContext.getService("documentService");
	    documentService.invalidateDocumentVersion(organisationPersonId, documentVersionId,
                                                      this.password, this.comment, selectedOptionId, reactivate, authorized).then(
		lang.hitch(this, function(documentPageInfo) {
		    this.registerAsyncOperationFinished(DocumentInvalidatePage.AsyncOperation.SIGN);
                    this.goBack();
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DocumentInvalidatePage.AsyncOperation.SIGN,
                                opName : "invalidateDocumentVersion",
                               message : i18n.documentInvalidateSignFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [invalidateDocumentVersion]", err);
                    }));                                
        },

        initialize : function() {
        /*
            this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.LOAD_INFO);
			var documentService = this.applicationContext.getService("documentService");
			documentService.getDocumentPageInfo(organisationPersonId, subProjectId).then(
					lang.hitch(this, function(documentPageInfo) {
						this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.LOAD_INFO);
						this.searchWidget.initialize(documentPageInfo);
                        this.listWidget.setContentLocales(documentPageInfo.contentLocales);

						this.enableCustomerLogo = documentPageInfo.enableCustomerLogo;

						this.globalActions = new Object();
						for (var n = 0; n < documentPageInfo.globalActions.length; n++) {
							this.globalActions[documentPageInfo.globalActions[n]] = true;
						}

                    var searchButtonClass = ("editPersonalData" in this.globalActions ? "" : "invisible");
                    domClass.replace(this.newSearchButton.domNode, searchButtonClass, "invisible");
                    domClass.replace(this.saveButton.domNode, searchButtonClass, "invisible");
                    domClass.replace(this.editSearchButton.domNode, searchButtonClass, "invisible");
                    domClass.replace(this.deleteSearchButton.domNode, searchButtonClass, "invisible");

                    var projectActions = documentPageInfo.projectActions;
                    var mspActionFound = false;
                    for (var n = 0; n < projectActions.length; n++) {
                        mspActionFound |= (projectActions[n] == "exportDocumentsMSP");
                    }
                    if (mspActionFound) {
                        domClass.remove(this.exportToMspButton.domNode, "hidden");
                        domClass.remove(this.runMspNowButton.domNode, "hidden");
                    } else {
                        domClass.add(this.exportToMspButton.domNode, "hidden");
                        domClass.add(this.runMspNowButton.domNode, "hidden");
                    }
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DocumentPage.AsyncOperation.LOAD_INFO,
                                opName : "getDocumentPageInfo",
                               message : i18n.documentPageGetInfoFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getDocumentPageInfo]", err);
                    }));
                    */
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var width = this.buttonDiv.offsetWidth - 15;
            var totalHeight = this.lastNewSize.h - 15;

            /*
            var totalHeight = this.lastNewSize.h;

            var width = this.buttonDiv.offsetWidth - 15;
            var contentHeight = totalHeight
                - this.captionBarDiv.offsetHeight
                - domStyle.get(this.captionBarDiv, "margin-top") - domStyle.get(this.captionBarDiv, "margin-bottom")
                - this.documentSectionDiv.offsetHeight
                - domStyle.get(this.documentSectionDiv, "margin-top") - domStyle.get(this.documentSectionDiv, "margin-bottom")
                - this.referenceSectionCaptionDiv.offsetHeight
                - domStyle.get(this.referenceSectionCaptionDiv, "margin-top")
                - domStyle.get(this.referenceSectionCaptionDiv, "margin-bottom")            
                - this.actionDiv.offsetHeight
                - domStyle.get(this.actionDiv, "margin-top") - domStyle.get(this.actionDiv, "margin-bottom")
                - this.buttonDiv.offsetHeight
                - domStyle.get(this.buttonDiv, "margin-top") - domStyle.get(this.buttonDiv, "margin-bottom")            
                - 40;

            domStyle.set(this.referenceTopDiv, "width", width + "px");
            domStyle.set(this.referenceTopDiv, "height", contentHeight + "px");
            */
            this.referenceWidget.resize({ w : width });

            domStyle.set(this.topDiv, "width", width + "px");
            domStyle.set(this.topDiv, "height", totalHeight + "px");
        },

        setData : function() {

        },

        reload : function() {
            var documentService = this.applicationContext.getService("documentService");

            this.registerAsyncOperationStarted(DocumentInvalidatePage.AsyncOperation.LOAD_DATA);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            documentService.getDocumentListJoinForVersionId(organisationPersonId, this.documentVersionId).then(
                lang.hitch(this, function(documentListData) {
                    this.registerAsyncOperationFinished(DocumentInvalidatePage.AsyncOperation.LOAD_DATA);

                    if (documentListData.documentListRows.length != 1) {
                        log.warn("Loaded [" + documentListData.documentListRows.length + "] rows for documentVersionId ["
                                   + this.documentVersionId + "], expected exactly one.");
                        //return;
                    }

                    this.projectActions = new Object();
                    if (documentListData.projectActions != null) {
                        for (var n = 0; n < documentListData.projectActions.length; n++) {
                            this.projectActions[documentListData.projectActions[n]] = true;
                        }
                    }

                    this.documentListRow = documentListData.documentListRows[documentListData.documentListRows.length-1];
                    this.documentListRow._objectPlannerIdToActions = documentListData.objectPlannerIdToActions;
                    this.cycleInfo = documentListData.cycleInfo;

                    this.updateWidgetsFromData();
                    this.resize();
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                        err : err,
                        widget : this,
                        asyncOperation : DocumentInvalidatePage.AsyncOperation.LOAD_DATA,
                                opName : "getDocumentListJoinForVersionId",
                               message : i18n.documentInvalidateLoadDataFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getDocumentListJoinForVersionId]", err);
                    }));
        },

        updateWidgetState : function() {
            this.updateDataFromWidgets();

            WidgetHelper.updateEmptyTextBoxState(this.passwordTextBox);

            var operationRunning = this.isAsyncOperationRunning();
            var anyOptionSelected = false;
            var selectedOptionIndex = null;
            if (this.selectedOptions != null) {
                for (var n = 0; n < this.selectedOptions.length; n++) {
                    anyOptionSelected |= this.selectedOptions[n];
                    if (this.selectedOptions[n]) {
                        selectedOptionIndex = n;
                    }
                }
            }

/*            var authorizationCheckBox = this.authorizationCheckBoxes != null
                ? this.authorizationCheckBoxes[selectedOptionIndex] : null;
                var allCheckBoxesChecked = authorizationCheckBox == null || authorizationCheckBox.get("checked");*/            

            var commentFilled = this.comment != null && this.comment.length > 0;
            var passwordFilled = this.password != null && this.password.length > 0;

            this.signButton.set("disabled", operationRunning || !anyOptionSelected || !passwordFilled);// || !allCheckBoxesChecked);
        },

        updateWidgetsFromData : function() {
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();

            var nodeId = this.documentListRow.reviewCycleNodeInstance.reviewCycleNodeId;
            var node = this.getNodeFromCycleInfo(nodeId);
            var nodeName = I18nHelper.getCurrentLocaleString(node.name, locale);
            DOMHelper.setInnerText(this.documentSectionCaptionDiv, nodeName);            

            var documentVersionName = this.documentListRow.documentVersion.name;
            this.nameTextBox.set("value", documentVersionName);

            var scale = this.documentListRow.documentRelease != null && this.documentListRow.documentRelease.id != null
                           ? this.documentListRow.documentRelease.scale : this.documentListRow.document.scale;
            this.scaleTextBox.set("value", scale);

            var rawContent = this.documentListRow.documentRelease != null && this.documentListRow.documentRelease.id != null
                           ? this.documentListRow.documentRelease.content : this.documentListRow.document.content;
            var content = I18nHelper.getCurrentLocaleString(rawContent, locale);
            this.contentTextBox.set("value", content);

            domConstruct.empty(this.actionRow);
            var invalidateOptions = this.documentListRow.invalidateOptions;
            this.radioButtons = [];
            this.authorizationCheckBoxes = [];
            this.reactivateCheckBoxes = [];
            for (var n = 0; n < invalidateOptions.length; n++) {
                var invalidateOption = invalidateOptions[n];
                var optionName = I18nHelper.getCurrentLocaleString(invalidateOption.name, locale);
                
                var optionDiv = domConstruct.create("div", null, null);
                domClass.add(optionDiv, "documentInvalidateOptionDiv");
                domConstruct.place(optionDiv, this.actionRow);

                var radioParent = domConstruct.create("div", null, null);
                domClass.add(radioParent, "documentInvalidateRadioParent");
                domConstruct.place(radioParent, optionDiv);

				var radioButton = new RadioButton({
				    label : optionName,
				    title : invalidateOption.description,
				    name : "actions",
				    dojoClick : false                     
				});
                domClass.add(radioButton.domNode, "documentInvalidateRadioButton");
                domConstruct.place(radioButton.domNode, radioParent);
                WidgetHelper.handleRadioButtonEvents(radioButton, lang.hitch(this, this.updateWidgetState));
                this.radioButtons.push(radioButton);

                DOMHelper.createTextNode("div", optionName, radioParent, "documentInvalidateRadioLabel");

                DOMHelper.createTextNode("div", invalidateOption.description, optionDiv, "documentInvalidateRadioDescription");

                if (invalidateOption.needsAuthorization) {
                    var authorizationDiv = domConstruct.create("div", null, null);
                    domClass.add(authorizationDiv, "documentInvalidateAuthorizationDiv");
                    domConstruct.place(authorizationDiv, optionDiv);

                    var authorizationCheckBox = new CheckBox({
                        label : i18n.documentInvalidateAuthorizationLabel,
                        title : i18n.documentInvalidateAuthorizationLabel
                    });
                    domClass.add(authorizationCheckBox.domNode, "documentInvalidateAuthorizationCheckBox");
                    domConstruct.place(authorizationCheckBox.domNode, authorizationDiv);
                    WidgetHelper.handleCheckBoxEvents(authorizationCheckBox, lang.hitch(this, this.updateWidgetState));

                    DOMHelper.createTextNode("div", i18n.documentInvalidateAuthorizationLabel,
                                             authorizationDiv, "documentInvalidateAuthorizationLabel");
                    this.authorizationCheckBoxes.push(authorizationCheckBox);
                } else {
                    this.authorizationCheckBoxes.push(null);
                }

                var withReactivateOption = false;
                var added = false;
                
                if (this.documentListRow.invalidateOptionIdsWithReactivationOption != null
                   && "reactivatePreviousDocumentVersion" in this.projectActions) {
                    for (var z = 0; z < this.documentListRow.invalidateOptionIdsWithReactivationOption.length; z++) {
                        if (this.documentListRow.invalidateOptionIdsWithReactivationOption[z] == invalidateOption.id) {
                            var reactivateDiv = domConstruct.create("div", null, null);
                            domClass.add(reactivateDiv, "documentInvalidateReactivateDiv");
                            domConstruct.place(reactivateDiv, optionDiv);

                            var reactivateCheckBox = new CheckBox({
                                label : i18n.documentInvalidateReactivateLabel,
                                title : i18n.documentInvalidateReactivateToolTip
                            });
                            domClass.add(reactivateCheckBox.domNode, "documentInvalidateReactivateCheckBox");
                            domConstruct.place(reactivateCheckBox.domNode, reactivateDiv);
                            WidgetHelper.handleCheckBoxEvents(reactivateCheckBox, lang.hitch(this, this.updateWidgetState));

                            DOMHelper.createTextNode("div", i18n.documentInvalidateReactivateLabel,
                                                     reactivateDiv, "documentInvalidateReactivateLabel");
                            this.reactivateCheckBoxes.push(reactivateCheckBox);
                            added = true;
                        }
                    }
                }
                if (!added) {
                    this.reactivateCheckBoxes.push(null);
                }

            }
			//if option 'delete' is not available
            if (this.documentListRow.showDeleteNotAvailableHint) {
                var optionDiv = domConstruct.create("div", null, null);
                domClass.add(optionDiv, "documentInvalidateOptionDiv");
                domConstruct.place(optionDiv, this.actionRow);

                var radioParent = domConstruct.create("div", null, null);
                domClass.add(radioParent, "documentInvalidateRadioParent");
                domConstruct.place(radioParent, optionDiv);

				var radioButton = new RadioButton({
				    label : i18n.documentVersionStateDeleted,
				    title : i18n.documentInvalidateDocumentNotAvailableHint,
				    name : "actions",
				    dojoClick : false
				});
				radioButton.set("disabled", true);
                domClass.add(radioButton.domNode, "documentInvalidateRadioButton");
                domConstruct.place(radioButton.domNode, radioParent);
                DOMHelper.createTextNode("div", i18n.documentVersionStateDeleted, radioParent, "documentInvalidateRadioLabel");
                DOMHelper.createTextNode("div", i18n.documentInvalidateDocumentNotAvailableHint, optionDiv, "documentInvalidateRadioDescription");
            }
            if (this.documentListRow.showAsBuiltHint) {
                DOMHelper.createTextNode("div", i18n.documentInvalidateAsBuiltHint, this.actionRow, "");
            }
            if (this.documentListRow.showNoneHint) {
                DOMHelper.createTextNode("div", i18n.documentInvalidateNoOptionsHint, this.actionRow, "");
            }

            if (this.buttonDiv == null) {
                this.buttonDiv = DocumentHelper.renderFileButtons({
                    documentListRow : this.documentListRow,
                    applicationContext : this.applicationContext
                });
                domClass.add(this.buttonDiv, "fixedDialogWidget documentInvalidateButtonDiv");
                domConstruct.place(this.buttonDiv, this.documentSectionDiv);

                var reviewProtocolButton = this.constructOpenReviewProtocolButton(this.documentListRow);
                domClass.add(reviewProtocolButton.domNode, "listButton");
                domConstruct.place(reviewProtocolButton.domNode, this.buttonDiv);
            }

            var documentReferences = this.documentListRow.documentReferences;
            var transformedReferences = [];
            for (var n = 0; n < documentReferences.length; n++) {
                var reference = documentReferences[n];

                var sinceDocumentVersionVersionParta = "";
                var sinceDocumentVersionVersionPartb = "";
                var sinceDocumentVersionVersionPartSeperator = "";
                var untilDocumentVersionVersionParta = "";
                var untilDocumentVersionVersionPartb = "";
                var untilDocumentVersionVersionPartSeperator = "";

                var sinceVersionId = reference.sinceDocversionId;
                var untilVersionId = reference.untilDocversionId;

                for (var z = 0; z < this.documentListRow.otherVersionInfos.length; z++) {
                    var otherVersionInfo = this.documentListRow.otherVersionInfos[z];
                    var otherVersionId = otherVersionInfo.documentVersion.id;
                    if (otherVersionId == sinceVersionId) {
                        sinceDocumentVersionVersionParta = otherVersionInfo.documentVersion.versionParta;
                        sinceDocumentVersionVersionPartb = otherVersionInfo.documentVersion.versionPartb;
                        sinceDocumentVersionVersionPartSeperator = otherVersionInfo.documentVersion.versionPartSeperator;
                    }
                    if (otherVersionId == untilVersionId) {
                        untilDocumentVersionVersionParta = otherVersionInfo.documentVersion.versionParta;
                        untilDocumentVersionVersionPartb = otherVersionInfo.documentVersion.versionPartb;
                        untilDocumentVersionVersionPartSeperator = otherVersionInfo.documentVersion.versionPartSeperator;
                    }
                }
                
                transformedReferences.push({
                    documentReferenceRealm : reference.realm,
                    documentReferenceGz : reference.gz,
                    documentReferenceReference : reference.reference,
                    documentReferenceUrl : reference.url,
                    documentReferenceComment : reference.comment,
                    documentReferenceCreated : reference.created,
                    documentReferenceDocumentId : reference.documentId,
                    documentReferenceSinceDocversionId : reference.sinceDocversionId,
                    documentReferenceUntilDocversionId : reference.untilDocversionId,
                    documentReferenceReferencedVersionId : reference.referencedVersionId,
                    documentReferenceAttachmentFilename : reference.attachmentFilename,
                    documentReferenceAttachmentOriginalFilename : reference.attachmentOriginalFilename,
                    documentReferenceAttachmentFiletype : reference.attachmentFiletype,
                    _objectPlannerIdToActions : this.documentListRow._objectPlannerIdToActions,
                    documentObjectPlannerId : this.documentListRow.objectPlanner.id,
                    sinceDocumentVersionVersionParta : sinceDocumentVersionVersionParta,
                    sinceDocumentVersionVersionPartb : sinceDocumentVersionVersionPartb,
                    sinceDocumentVersionVersionPartSeperator : sinceDocumentVersionVersionPartSeperator,
                    untilDocumentVersionVersionParta : untilDocumentVersionVersionParta,
                    untilDocumentVersionVersionPartb : untilDocumentVersionVersionPartb,
                    untilDocumentVersionVersionPartSeperator : untilDocumentVersionVersionPartSeperator
                });
            }
            this.referenceWidget.setData({
                referenceJoins : transformedReferences
            });
        },

        getNodeFromCycleInfo : function(nodeId) {
            return this.cycleInfo.idToNode[nodeId];
        },

        updateDataFromWidgets : function() {
            this.selectedOptions = [];
            if (this.radioButtons != null) {
                for (var n = 0; n < this.radioButtons.length; n++) {
                    this.selectedOptions.push(this.radioButtons[n].get("checked"));
                    
                    if (this.authorizationCheckBoxes != null && this.authorizationCheckBoxes[n] != null){
						if (this.radioButtons[n].get("checked"))
							this.authorizationCheckBoxes[n].set("disabled", false);
                		else
							this.authorizationCheckBoxes[n].set("disabled", true);
                	}
                }
            }

            this.comment = this.commentTextArea.get("value");
            this.password = this.passwordTextBox.get("value");
        },

        constructOpenReviewProtocolButton : function(documentListRow) {
	    var button = new FancyButton({
		    title : i18n.openReviewProtocolToolTip,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 reviewProtocolButton"
	    });

	    domClass.add(button.domNode, "listButton");

	    on(button, "click", lang.hitch(this, function(e) {
            if (e.ctrlKey) {
                var paramsObject = {
                    ts : dojoConfig.tabSessionId
                };
                var hashObject = {
                    page : "reviewProtocol",
                    documentVersionId : documentListRow.documentVersion.id
                };
                var paramsString = ioQuery.objectToQuery(paramsObject);
                var hashString = ioQuery.objectToQuery(hashObject);
                window.open("/cdes/frame.html?" + paramsString + "#" + hashString);
            } else {
	 			this.applicationContext.setPage("reviewProtocol", {
	     	    	documentVersionId : documentListRow.documentVersion.id
		        }, {
				    backPage : "documentInvalidatePage",
				    backParams : this.params
		     	});
            }
	    }));
	    return button;
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    DocumentInvalidatePage.AsyncOperation = {
        LOAD_DATA : "LoadData",
        SIGN : "Sign"
    };

    return DocumentInvalidatePage;
});
