define([ 
         "clazzes/TinyLog",
         "clazzes/dateTime/DateHelper",
         "clazzes/dateTime/DateTimeSpinBox",
         "clazzes/util/DOMHelper",
         "clazzes/widgets/DisableButton",
         "clazzes/widgets/layout/ContentWidget",
         "dijit/form/Select",
         "dijit/form/Textarea",
         "dgrid/Editor",
         "dgrid/OnDemandGrid",
         "dgrid/extensions/ColumnResizer",
         "dgrid/extensions/DijitRegistry",
         "dgrid/util/misc",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/on",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dstore/Memory",
         "dstore/Trackable",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 DateHelper,
    		 DateTimeSpinBox,
    		 DOMHelper,
    		 DisableButton,
    		 ContentWidget,
    		 Select,
    		 Textarea,
    		 Editor,
    		 OnDemandGrid,
    		 ColumnResizer,
    		 DijitRegistry,
    		 dgridMiscUtil,
    		 domClass,
    		 domConstruct,
    		 on,
    		 declare,
    		 lang,
    		 Memory,
    		 Trackable,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.person.PersonTrainingListWidget";

	var log = new TinyLog(className);
	
    var PersonTrainingListWidget = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.columnSettings = new Object();
    		
    		this.topDiv = this.constructTopDiv();
    		
    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PersonTrainingListWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructColumns : function() {
    		var columns = [];
    		
    		columns.push({
				     field : "date",
				        id : "date",
 		          sortable : true,
		             label : i18n.personTrainingListDateColumnCaption,
		            editor : DateTimeSpinBox,
		        editorArgs : { pattern : i18n.datePattern, label : i18n.personTrainingListDateColumnCaption, title : i18n.personTrainingListDateToolTip },
    			   canEdit : lang.hitch(this, this.canEditDate),
  	                   get : lang.hitch(this, this.dateFormatter)		        
    		});
    		
    		columns.push({
    			     field : "type",
    			        id : "type",
    			  sortable : true,
    			     label : i18n.personTrainingListTypeColumnCaption,
    			    editor : Select,
    			editorArgs : { label : i18n.personTrainingListTypeColumnCaption, title : i18n.personTrainingListTypeToolTip },
    			   canEdit : lang.hitch(this, this.canEditType),
    			       get : lang.hitch(this, this.typeFormatter)
    		});
    		
    		columns.push({
    			     field : "comment",
    			        id : "comment",
    			  sortable : true,
    			     label : i18n.personTrainingListCommentColumnCaption,
    			    editor : Textarea,
    			editorArgs : { label : i18n.personTrainingListCommentColumnCaption, title : i18n.personTrainingListCommentToolTip },
    			   canEdit : lang.hitch(this, this.canEditComment)
    		});
    		
			columns.push({
		         field : "id",
		            id : "actions",
		    renderCell : lang.hitch(this, this.renderActionCell),
		      sortable : true,
		         label : i18n.actionColumnCaption 
			});       		
 		
    		return columns;
    	},
    	
    	canEditStartDate : function(personTraining) {
    		
    	},
    	
    	dateFormatter : function(personTraining) {
    		
    	},
    	
    	canEditType : function(personTraining) {
    		
    	},
    	
    	typeFormatter : function(personTraining) {
    		
    	},
    	
    	canEditComment : function(personTraining) {
    		
    	},
    	
    	renderActionCell : function(joinDto, data, cell) {
    		var buttonDiv = domConstruct.create("div", null, null);
    		/*
    		
    		if (joinDto.certificateId && joinDto.certificateMaySign && joinDto.certificateCertValidTo != null && joinDto.certificateCertValidTo <= DateHelper.getCurrentTimeSeconds() + 30 * 24 * 3600) {
        		var renewButton = this.constructRenewButton(joinDto);
        		domConstruct.place(renewButton.domNode, buttonDiv);    			
    		}
    		
    		if (joinDto.certificateMaySign) {
        		var invalidateButton = this.constructInvalidateButton(joinDto);
        		domConstruct.place(invalidateButton.domNode, buttonDiv);    			
    		}
    		
    		var editButton = this.constructEditButton();
    		domConstruct.place(editButton.domNode, buttonDiv);
    		
    		if (joinDto.personLogin != null && joinDto.personLogin.length > 0) {
    			var deleteButton = this.constructDeleteButton(joinDto);
    			domConstruct.place(deleteButton.domNode, buttonDiv);
    		}
    		*/
    		return buttonDiv;
    	},
    	
    	constructTopDiv : function() {

    		var columns = this.constructColumns();
    		var TrackableMemory = declare([Memory, Trackable]);
    		this.store = new TrackableMemory({data : [], idProperty : "id"}); // TODO
    		
    		var MyGrid = declare([OnDemandGrid, ColumnResizer, DijitRegistry, Editor]);
    		this.grid = new MyGrid({
    			collection : this.store,
    			   columns : columns,
    			   		id : "PersonTrainingListGrid"
    		});
    		
    		this.grid.startup();
            this.grid.afterResizeMouseUp = lang.hitch(this, this.handleColumnResize);
    		
    		this.gridRuleSelectorPrefix = "#" + dgridMiscUtil.escapeCssIdentifier(this.grid.domNode.id) + " .dgrid-column-";
    		
    		return this.grid.domNode;
    	},
    	
    	resize : function(newSize) {
    		this.grid.resize(newSize);
    	},
    	
    	setData : function(personTrainings) {

    		this.personTrainings = personTrainings;
    		
    		this.reload();
    	},
    	
    	reload : function(params) {    	    		
    		log.info("====> Start: Reload");

    		if (this.personTrainings) {
        		this.store.setData(this.personTrainings);
        		this.grid.refresh();    			
    		}
    		
    		log.info("End: reload");
    	}
    });
    
    PersonTrainingListWidget.Status = {
    		
    };    
    
    return PersonTrainingListWidget;
});