define([ 
         "cdes/core/CdesVoc",
         "cdes/pdc/PlanDeliverHelper",
         "cdes/util/CodeHelper",
    	"cdes/util/FancyColumnResizer",
        "cdes/util/I18nHelper",
        "cdes/util/NameHelper",
         "cdes/util/SaveLoadHelper",
         "cdes/widget/CalendarSpinner",
    	"cdes/widget/base/ListWidget",
         "cdes/widget/document/DocumentNumberEditor",
         "cdes/widget/util/DnDCellWidget",
         "cdes/widget/util/TextAreaDnDCellWidget",
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/dateTime/DateHelper",
         "clazzes/dateTime/FancyDate",
         "clazzes/util/DataHelper",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/util/JoinHelper",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/DisableButton",
         "clazzes/widgets/layout/ContentWidget",
         "dijit/form/Button",
         "dijit/form/Form",
         "dijit/form/Select",
         "dijit/form/Textarea",
         "dijit/form/TextBox",
         "dgrid/Editor",
         "dgrid/OnDemandGrid",
         "dgrid/extensions/DijitRegistry",
         "dgrid/util/misc",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/dom-style",
         "dojo/io-query",
         "dojo/on",
         "dojo/string",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/promise/all",
         "dojox/form/Uploader",
         "dstore/Memory",
         "dstore/Trackable",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 CdesVoc,
    		 PlanDeliverHelper,
    		 CodeHelper,
    		FancyColumnResizer,
             I18nHelper,
	     	NameHelper,
    		 SaveLoadHelper,
    		 CalendarSpinner,
        	ListWidget,
    		 DocumentNumberEditor,
    		 DnDCellWidget,
    		 TextAreaDnDCellWidget,
    		 TinyLog,
    		 topic,
    		 DateHelper,
    		 FancyDate,
    		 DataHelper,
    		 DOMHelper,
    		 ErrorHelper,
             JoinHelper,
    		 WidgetHelper,
    		 DisableButton,
    		 ContentWidget,
    		 Button,
    		 Form,
    		 Select,
    		 Textarea,
    		 TextBox,
    		 Editor,
    		 OnDemandGrid,
    		 DijitRegistry,
    		 dgridMiscUtil,
    		 domClass,
    		 domConstruct,
    		 domStyle,
    		 ioQuery,
    		 on,
    		 string,
    		 declare,
    		 lang,
    		 promiseAll,
    		 Uploader,
    		 Memory,
    		 Trackable,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.pdc.PlanDeliverNewWidget";

	var log = new TinyLog(className);
	
    var PlanDeliverNewWidget = declare(className, ListWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		

    		
			this.objectIdToJoinDto = new Object();
			this.objectPlannerIdToJoinDto = new Object();
			
    		this.domNodeIdToValueInfo = new Object();
    		this.dndInfo = DnDCellWidget.constructDnDInfo();
    		this.documentNumberToDocuments = new Object();
    		
    		this.topDiv = this.constructTopDiv();
    		
    		// Initially most probably empty, but for completeness...
    		this.populateObjectSelect();
    		//this.updateObjectPlannerSelect();
    		this.nextFreeCreationIndex = 0;
    		this.nextFreeFakeDocumentId = -1;
    		
    		this.allFieldsValid = true;
    		
    		
    	},
    	
    	getWidgetId : function() {
    		return "PlanDeliverNewWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	getStatusMessage : function() {
    		return i18n.planDeliverNewDefaultStatusMessage;
    	},
    	
        columnWidthKey : "planDeliverNew/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

    	constructColumns : function() {
    		var columns = [];
 		
       		columns.push({
        			  field : "documentName",
        			     id : "documentName",
        			    get : lang.hitch(this, this.documentNumberFormatter),
        	       sortable : false,
        			  label : i18n.planDeliverDocumentNumberColumnCaption,
        		     editor : DocumentNumberEditor,
        		 editorArgs : {       applicationContext : this.applicationContext,
        			 				 objectPlannerGetter : lang.hitch(this, function() {
        			 					 		var objectPlannerId = this.objectPlannerSelect.get("value");
        			 					 		return objectPlannerId != null ? this.objectPlannerIdToJoinDto[objectPlannerId] : null;
        			 				 		}),
        			 		   documentNumberToDocuments : this.documentNumberToDocuments, // TODO: Unused?
          			              			  dndEnabled : true,
        			 				       dndStartTopic : PlanDeliverNewWidget.documentNameDnDStartTopic,
        			 				        setDataTopic : PlanDeliverNewWidget.documentNameSetDataTopic,
        			 			       rowObjectToString : null
        			 		}
       		});    			

       		columns.push({
        			  field : "content",
        			     id : "content",
         			    get : lang.hitch(this, this.contentFormatter),        			     
        	       sortable : false,
        			  label : i18n.planDeliverDocumentNameColumnCaption,
        			 editor : TextAreaDnDCellWidget,
        		 editorArgs : { 
        			           label : i18n.planDeliverListContentTextBoxLabel, 
        			           title : i18n.planDeliverListContentTextBoxToolTip,
       	                   	      dndEnabled : true,
        			   dndStartTopic : PlanDeliverNewWidget.contentDnDStartTopic,
        			    setDataTopic : PlanDeliverNewWidget.contentSetDataTopic,
        		       rowObjectToString : null,
                                          locale : this.applicationContext.getPageContextPersonVariablesUserLocale(),
                             contentLocaleGetter : lang.hitch(this, this.getContentLocales)                             
        		 }
       		});    			

       		columns.push({
        			  field : "scale",
        			     id : "scale",
         			    get : lang.hitch(this, this.scaleFormatter),        			     
        	       sortable : false,
        			  label : i18n.planDeliverScaleColumnCaption,
        			 editor : TextAreaDnDCellWidget,
        		 editorArgs : { 
        			                               label : i18n.planDeliverListScaleTextBoxLabel, 
        			                               title : i18n.planDeliverListScaleTextBoxToolTip,
       	                   			          dndEnabled : true,
        			                       dndStartTopic : PlanDeliverNewWidget.scaleDnDStartTopic,
        			                        setDataTopic : PlanDeliverNewWidget.scaleSetDataTopic,
        			                   rowObjectToString : null
        			          }
       		});
       		
       		columns.push({
  			          field : "comment",
  			             id : "comment",
         			    get : lang.hitch(this, this.commentFormatter),  			             
  	               sortable : false,
  			          label : i18n.planDeliverCommentColumnCaption,
  			         editor : TextAreaDnDCellWidget,
  		         editorArgs : { 
  		        	 							   label : i18n.planDeliverListCommentTextBoxLabel, 
  		        	 							   title : i18n.planDeliverListCommentTextBoxToolTip,
  	                   			              dndEnabled : true,
  		        	 				       dndStartTopic : PlanDeliverNewWidget.commentDnDStartTopic,
  		        	 				        setDataTopic : PlanDeliverNewWidget.commentSetDataTopic,
  		        	 				   rowObjectToString : null
  		        	          }
       		});       		

       		columns.push({
        			  field : "startDate",
        			     id : "startDate",
        			    get : lang.hitch(this, this.startDateFormatter),
        	       sortable : false,
        			  label : i18n.planDeliverFromColumnCaption,
        			 editor : CalendarSpinner,
        	     editorArgs : {
        	    	 				   timeZone : this.applicationContext.getTimeZone(),
        	    	 				 tableClass : "planDeliverNewStartDateSpinner",
        	    	 				    pattern : i18n.datePattern,
        	    	 				      label : i18n.planDeliverListStartTextBoxLabel,
        	    	 				      title : i18n.planDeliverListStartTextBoxToolTip,
              			             dndEnabled : true,
              			          dndStartTopic : PlanDeliverNewWidget.documentFromDnDStartTopic,              			             
        	    	 		      setDataTopic  : PlanDeliverNewWidget.documentFromSetDataTopic,
         	    	 		         tableClass : "refNodeOfPositionAbsolute",
         	    	 		  rowObjectToString : null         	    	 		        	 
        	     			  }
       		});    			

       		columns.push({
        			  field : "endDate",
        			     id : "endDate",
         			    get : lang.hitch(this, this.endDateFormatter),        			     
        	       sortable : false,
        			  label : i18n.planDeliverToColumnCaption,
        			 editor : CalendarSpinner,
          		 editorArgs : {         
          			                   timeZone : this.applicationContext.getTimeZone(),
          			 				 tableClass : "planDeliverNewEndDateSpinner",
          			 					pattern : i18n.datePattern, 
        	    	                      label : i18n.planDeliverListEndTextBoxLabel, 
        	    	                      title : i18n.planDeliverListEndTextBoxToolTip,
              			             dndEnabled : true,        	    	              
        	    	              dndStartTopic : PlanDeliverNewWidget.documentToDnDStartTopic,
        	    	              setDataTopic  : PlanDeliverNewWidget.documentToSetDataTopic,
         	    	 		         tableClass : "refNodeOfPositionAbsolute",
         	    	 		  rowObjectToString : null
        	    	           }
       		});
       		
			columns.push({
		              field : "_creationIndex",
		                 id : "actions",
		         renderCell : lang.hitch(this, this.renderActionCell),				        
		           sortable : false,
		              label : i18n.actionColumnCaption 
			});       		

    		return columns;
    	},
    	
        getContentLocales : function() {
            return this.contentLocales;
        },        

    	canEditStartDate : function(document) {
    		return (   ("editPlanDeliverCatalogueDates" in document._allowedActions)
    				|| ("editPlanDeliverCatalogueStartDate" in document._allowedActions)
    				|| this.applicationContext.isActionAllowedForProject("editPlanDeliverCatalogueDatesProjCont"));    		
    	},
    	
    	canEditEndDate : function(document) {
    		return (   ("editPlanDeliverCatalogueDates" in document._allowedActions)
    				|| ("editPlanDeliverCatalogueEndDate" in document._allowedActions)
    				|| this.applicationContext.isActionAllowedForProject("editPlanDeliverCatalogueDatesProjCont"));    		
    	},
    	
    	documentNumberFormatter : function(dto) {
    		return {
    		  _creationIndex : dto._creationIndex,
  			  value : dto._documentNumberInfo,
  			  rowId : dto._creationIndex 
    		};
    	},
    	
    	contentFormatter : function(dto) {
    		return {
    			value : dto.content,
    			rowId : dto._creationIndex
    		};
    	},
    	
    	scaleFormatter : function(dto) {
    		return {
    			value : dto.scale,
    			rowId : dto._creationIndex
    		};
    	},
    	
    	commentFormatter : function(dto) {
    		return {
    			value : dto.comment,
    			rowId : dto._creationIndex
    		};
    	},
    	
    	startDateFormatter : function(dto) {

    		return {
    			value : dto.startDate ? dto.startDate : null,
    			rowId : dto._creationIndex
    		};    		
    	},    	
    	
    	endDateFormatter : function(dto) {

    		return {
    			value : dto.endDate ? dto.endDate : null,
    			rowId : dto._creationIndex
    		};
    	},
    	
    	renderActionCell : function(document, data, cell) {
    		var buttonDiv = domConstruct.create("div", null, null);
    		
   			var addDocumentButton = this.constructAddDocumentButton(document);
   			domConstruct.place(addDocumentButton.domNode, buttonDiv);    			
    		
   			var addMultipleDocumentsButton = this.constructAddMultipleDocumentsButton(document);
   			domConstruct.place(addMultipleDocumentsButton.domNode, buttonDiv);
   			
   			var removeDocumentButton = this.constructRemoveDocumentButton(document);
   			domConstruct.place(removeDocumentButton.domNode, buttonDiv);
    		
    		return buttonDiv;
    	},
    	
    	constructAddDocumentButton : function(document) {
       	 	return new DisableButton({
	 		               label : i18n.planDeliverNewAddButtonCaption,
	 		           showLabel : false,
	 		               title : i18n.planDeliverNewAddButtonToolTip,
		                 onClick : lang.hitch(this, function() {
		                	 this.add(document);
		                 }),
                       iconClass : "insertButton",
                         "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
       	 	});    		
    	},
    	
    	constructAddMultipleDocumentsButton : function(document) {
       	 	return new DisableButton({
	                       label : i18n.planDeliverNewAddFiveButtonCaption,
	                   showLabel : false,
	                       title : i18n.planDeliverNewAddFiveButtonToolTip,
                         onClick : lang.hitch(this, function() {
                        	 this.addFive(document);
                         }),
                       iconClass : "insertMultipleButton",
                         "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
       	 	});    		
    	},
    	
    	constructRemoveDocumentButton : function(document) {
       	 	return new DisableButton({
	                       label : i18n.planDeliverNewRemoveButtonCaption,
	                   showLabel : false,
	                       title : i18n.planDeliverNewRemoveButtonToolTip,
	                     onClick : lang.hitch(this, function() {
	                    	 this.remove(document);
	                     }),
	                   iconClass : "deleteButton",
	                     "class" : "cdesWebButton17x18 gridButton",
	            controllerWidget : this,
	                disableEvent : "disableButtons",
	            _destroyOnRemove : true
       	 	});      		
    	},
    	
    	add : function(refDocument, newDocument) {
    		var row = refDocument != null && refDocument._creationIndex != null ? this.grid.row(refDocument._creationIndex) : null;
    		var nextRow = row != null ? this.grid.down(row) : null;
    		
    		// Two cases: (1) Button in last row clicked => create new last row (beforeId = null), or (2) not (beforeId = <id of next row>
    		var beforeId = (nextRow == null || row.id == nextRow.id ? null : nextRow.id);
    		
    		if (newDocument == null) {
    			newDocument = this.constructNewDocument();	
    		} else {
                newDocument._creationIndex = this.nextFreeCreationIndex;
    			this.nextFreeCreationIndex++;    			
    			
        		DocumentNumberEditor.extractEditorInfo(newDocument);
        		
        		if (newDocument.startDate != null) {
            		newDocument.startDate = new FancyDate({
            			utcSeconds : newDocument.startDate,
            			  timeZone : this.applicationContext.getTimeZone() 
            		});        			
        		}

        		if (newDocument.endDate != null) {
            		newDocument.endDate = new FancyDate({
            			utcSeconds : newDocument.endDate,
            			  timeZone : this.applicationContext.getTimeZone() 
            		});        			
        		}    	
        		//calculate missing dates
        		if (newDocument.endDate != null && newDocument.startDate == null)
        			newDocument.startDate = this.getStartDateFromEndDate(newDocument.endDate);
        		if (newDocument.startDate != null && newDocument.endDate == null)
        			newDocument.endDate = this.getEndDateFromStartDate(newDocument.startDate);
    		}
    		
    		var objectPlannerId = newDocument.objectPlannerId;
    		var allowedActions = objectPlannerId != null && (objectPlannerId in this.objectPlannerIdToAllowedActions)
    			? this.objectPlannerIdToAllowedActions[objectPlannerId] : [];
    	    newDocument._allowedActions = new Object();
    	    for (var n = 0; allowedActions != null && n < allowedActions.length; n++) {
    	    	newDocument._allowedActions[allowedActions[n]] = true;
    	    }
    		
			this.store.addSync(newDocument, { beforeId : beforeId });
			
			var editors = this.dndInfo.rowIdToEditors[newDocument._creationIndex];
			editors.startDateSpinner.set("disabled", !this.canEditStartDate(newDocument));
			editors.startDateSpinner.set("dndEnabled", this.canEditStartDate(newDocument));
			editors.startDateSpinner.updateWidgetsState();
			editors.endDateSpinner.set("disabled", !this.canEditEndDate(newDocument));
			editors.endDateSpinner.set("dndEnabled", this.canEditEndDate(newDocument));
			editors.endDateSpinner.updateWidgetsState();
    		
			var holidayCalculator = this.applicationContext.getHolidayCalculator();
			if (this.canEditEndDate(newDocument) && newDocument.endDate != null)
				this.dndInfo.rowIdToHolidayError[newDocument._creationIndex] = holidayCalculator.isWeekendOrHoliday(newDocument.endDate);
			if (this.canEditStartDate(newDocument) && newDocument.startDate != null)
				this.dndInfo.rowIdToHolidayError[newDocument._creationIndex] = holidayCalculator.isWeekendOrHoliday(newDocument.startDate);
			
			if (log.isDebugEnabled()) {
				log.debug("add: After addSync: ", this.documents.length, this.documents);	
			}			
			
    		var project = this.applicationContext.getPageContextProject();
    		var network = this.applicationContext.getPageContextNetwork();
    		var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
    		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);
    		
    		var objectPlannerId = this.objectPlannerSelect.get("value");
			var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");    	
			var documentKey = CodeHelper.getUniqueKeyForDocument(newDocument, documentNumberParts, idToDocumentType, projectParticipation);			
			
			this.registerInDocumentNumberMap({
				                   documentKey : documentKey,
				                      document : newDocument,
				doUpdateDocumentNumberFeedback : true       
			});
			this.updateWidgetState();
			return newDocument;
    	},
    	
    	addFive : function(document) {
    		for (var n = 0; n < 5; n++) {
    			document = this.add(document);
    		}
    	},
    	
    	remove : function(document) {
    		if (this.documents.length > 1) {
    			this.store.removeSync(document._creationIndex);
    			log.info("remove: ", this.documents.length, this.documents);
    			this.deregisterFromDocumentNumberMap(document);
    			
    			var editors = this.dndInfo.rowIdToEditors[document._creationIndex];
    			if (editors) {
    				for (var editor in editors) {
    					delete this.domNodeIdToValueInfo[editor.domNode];
    				}
    			}
    			
    			delete this.dndInfo.rowIdToEditors[document._creationIndex];
    			this.updateWidgetState();
    		}    		
    	},
    	
    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		
    		this.contextDiv = this.constructContextWidget();
    		domConstruct.place(this.contextDiv, topDiv);
    		
    		this.buttonDiv = this.constructButtonBar();
    		domConstruct.place(this.buttonDiv, topDiv);
    		
    		var gridNode = this.constructGrid();
    		domConstruct.place(gridNode, topDiv);
    		
    		DnDCellWidget.setupDnD({
			      destroyableOwner : this,
			          setDataTopic : PlanDeliverNewWidget.documentNameSetDataTopic,
			         startDnDTopic : PlanDeliverNewWidget.documentNameDnDStartTopic,
			              columnId : "documentName", 
			            editorName : "documentNumberEditor",			              
			               dndInfo : this.dndInfo,
			                  grid : this.grid,
		                    setter : lang.hitch(this, this.setDocumentNumber),
		              offsetFilter : this.filterDocumentNumberOffset
    		});    		
    		DnDCellWidget.setupDnD({
			      destroyableOwner : this,    			
   			          setDataTopic : PlanDeliverNewWidget.contentSetDataTopic,
   			         startDnDTopic : PlanDeliverNewWidget.contentDnDStartTopic,
   			              columnId : "content",
   			            editorName : "contentTextArea",
   			               dndInfo : this.dndInfo,
   			                  grid : this.grid,
   			                setter : lang.hitch(this, this.setDocumentContent)
    		});    		
    		DnDCellWidget.setupDnD({
			      destroyableOwner : this,    			
			          setDataTopic : PlanDeliverNewWidget.scaleSetDataTopic,
			         startDnDTopic : PlanDeliverNewWidget.scaleDnDStartTopic,
			              columnId : "scale", 
			            editorName : "scaleTextArea",
			               dndInfo : this.dndInfo,
			                  grid : this.grid
    		}); 
    		DnDCellWidget.setupDnD({
			      destroyableOwner : this,    			
		              setDataTopic : PlanDeliverNewWidget.commentSetDataTopic,
		             startDnDTopic : PlanDeliverNewWidget.commentDnDStartTopic,
		                  columnId : "comment", 
		                editorName : "commentTextArea",
		                   dndInfo : this.dndInfo,
		                      grid : this.grid
    		});
    		DnDCellWidget.setupDnD({
			      destroyableOwner : this,    			
                      setDataTopic : PlanDeliverNewWidget.documentFromSetDataTopic,
                     startDnDTopic : PlanDeliverNewWidget.documentFromDnDStartTopic,                      
                          columnId : "startDate",
                        editorName : "startDateSpinner",
                           dndInfo : this.dndInfo,
                              grid : this.grid
    		});    		
    		DnDCellWidget.setupDnD({
			      destroyableOwner : this,    			
	                  setDataTopic : PlanDeliverNewWidget.documentToSetDataTopic,
	                 startDnDTopic : PlanDeliverNewWidget.documentToDnDStartTopic,
	                      columnId : "endDate",
	                    editorName : "endDateSpinner",
	                       dndInfo : this.dndInfo,
	                          grid : this.grid
    		});     		

    		return topDiv;
    	},
    	
    	setDocumentNumber : function(creationIndex, editor, baseValue, offset) {
    		
    		var project = this.applicationContext.getPageContextProject();
    		var network = this.applicationContext.getPageContextNetwork();
    		var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
    		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);    		
    		
    		var documentNumberInfo = baseValue;    		
    		var baseNumber = documentNumberInfo.number;
    		var document = this.store.getSync(creationIndex);
    		
    		var objectPlannerId = this.objectPlannerSelect.get("value");
    		var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");
    						
    	    if (document == null) {
    	    	throw new Error("No document registered for baseNumber", baseValue);
    	    }
    		
    		this.deregisterFromDocumentNumberMap(document);
    		
    		var newNumber = this.getFirstUnusedDocumentNumber({
    			                 document : document,
    			     projectParticipation : projectParticipation, 
    			      documentNumberParts : documentNumberParts,
    			         idToDocumentType : idToDocumentType,
    			                minNumber : baseNumber + offset
    		});
    		document._creationIndex = creationIndex;
    		document.number = newNumber;
    		document.documentTypeId = documentNumberInfo.documentTypeId;
    		
    		DocumentNumberEditor.extractEditorInfo(document);
    		
			var documentKey = CodeHelper.getUniqueKeyForDocument(document, documentNumberParts, idToDocumentType, projectParticipation);    		
    		this.registerInDocumentNumberMap({
    			                    documentKey : documentKey,
    			                       document : document, 
    			 doUpdateDocumentNumberFeedback : true
    		});
    		
    		this.updateWidgetsFromData({ documentName : true });
    		this.updateDocumentNumberFeedback();
    	},
    	
    	filterDocumentNumberOffset : function(totalOffset) {
    		return totalOffset > 0;
    	},
    	
    	setDocumentContent : function(creationIndex, editor, baseValueRaw, offset) {
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var baseValue = I18nHelper.getCurrentLocaleString(baseValueRaw, locale);

    		var startIndex = baseValue.length;
    		
    		// Find out wether the baseValue has a number as postfix, and if yes, where it starts.

    		while (startIndex > 0 && /^\d+$/.test(baseValue.substr(startIndex - 1))) {
    			startIndex--;
    		}
    		
    		if (startIndex < baseValue.length) {
    			var prefix = baseValue.substr(0, startIndex);
    			var valueAsString = baseValue.substr(startIndex);
    			var value = parseInt(valueAsString);
    			editor.set("value", { value : prefix + (value + offset).toString()});
    		} else {
    			editor.set("value", { value : baseValue });
    		}
    		
    		log.info("baseValue = " + baseValue + ", startIndex = " + startIndex + ", prefix = " + prefix + ", value = " + value);
    	},
    	
    	constructContextWidget : function() {
    		var contextDiv = domConstruct.create("div", null, null);
    		domClass.add(contextDiv, "refNodeOfPositionAbsolute planDeliverNewContextDiv");
    		
    		var person = this.applicationContext.getPageContextPerson();
    		var organisation = this.applicationContext.getPageContextOrganisation();
    		var options = [{
				value : this.applicationContext.getPageContextOrganisationPersonId(),
				label : NameHelper.getOrganisationPersonName({ person : person, organisation : organisation })
    		}];
    		
    		// Planner
     		DOMHelper.createTextNode("div", i18n.planner, contextDiv, "propertyLabel planDeliverNewPlannerLabel");
     		this.plannerSelect = new Select({
  			      label : i18n.planner,
  			      title : i18n.planDeliverNewPlannerSelectToolTip,
  			    options : options,
  			   disabled : true
    		});
    		domClass.add(this.plannerSelect.domNode, "fixedDialogWidget planDeliverNewPlannerSelect");
    		domConstruct.place(this.plannerSelect.domNode, contextDiv);
    		
    		// Duration
     		DOMHelper.createTextNode("div", i18n.planDeliverNewDurationLabel, contextDiv, "propertyLabel planDeliverNewDurationLabel");
     		this.durationTextBox = new TextBox({
  			      label : i18n.planDeliverNewDurationLabel,
  			      title : i18n.planDeliverNewDurationToolTip,
  			   disabled : true
    		});
    		domClass.add(this.durationTextBox.domNode, "fixedDialogWidget planDeliverNewDurationTextBox");
    		domConstruct.place(this.durationTextBox.domNode, contextDiv);    		
    		
     		// Object
     		DOMHelper.createTextNode("div", i18n.object, contextDiv, "propertyLabel planDeliverNewObjectLabel");
     		this.objectSelect = new Select({
     			  label : i18n.object,
     			  title : i18n.planDeliverNewObjectSelectToolTip,
     			options : []
     		});
     		domClass.add(this.objectSelect.domNode, "fixedDialogWidget planDeliverNewObjectSelect");
     		domConstruct.place(this.objectSelect.domNode, contextDiv);
     		WidgetHelper.handleSelectEvents(this.objectSelect, lang.hitch(this, this.updateObjectPlannerSelect));
     		
     		// Objectplanner
     		DOMHelper.createTextNode("div", i18n.objectPlanner, contextDiv, "propertyLabel planDeliverNewObjectPlannerLabel");
     		this.objectPlannerSelect = new Select({
   			     label : i18n.objectPlanner,
   			     title : i18n.planDeliverNewObjectPlannerSelectToolTip,
   			   options : []
     		});
     		domClass.add(this.objectPlannerSelect.domNode, "fixedDialogWidget planDeliverNewObjectPlannerSelect");
     		domConstruct.place(this.objectPlannerSelect.domNode, contextDiv);
     		WidgetHelper.handleSelectEvents(this.objectPlannerSelect, lang.hitch(this, this.onObjectPlannerSelected));
     		
     		// Import form etc.
    		var importFrame = this.applicationContext.getFancyIFrame();
    		
    	    this.importForm = new Form({method : "post", encType : "multipart/form-data"});
    	    domClass.add(this.importForm.domNode, "planDeliverNewForm");
    	    domConstruct.place(this.importForm.domNode, contextDiv);
    	    
    	    this.importForm.set("target", importFrame.id);
     		
			on(importFrame, "documentLoad", lang.hitch(this, function(event) {
				var jobId = event.document ? event.document.body.innerHTML : null;
				
				if (jobId != null) {
		    		var jobStatusService = this.applicationContext.getService("jobStatusService");
					jobStatusService.waitForJob(jobId,60000).then(lang.hitch(this, function(result) {
						var message;
						
						var numberOfOk = 0;
						var numberOfErrors = 0;
						
						var importDocumentArray = result.result;
						if (importDocumentArray != null) {
							for (var n = 0; n < importDocumentArray.length; n++) {
								var importDocument = importDocumentArray[n];
								if (importDocument.error) {
									topic.publish("message/error", string.substitute(i18n.planDeliverNewCsvImportError, {
										lineNumber : importDocument.lineNumber,
										   message : importDocument.message
									}));
									numberOfErrors++;
								} else {
						        	var objectPlannerId = this.objectPlannerSelect.get("value");
						        	importDocument.document.objectPlannerId = objectPlannerId;
									this.add(null, importDocument.document);
									numberOfOk++;
								}								
							}
						}
						
						if (this.uploadedFileName != null) {
							if (numberOfErrors == 0) {
								message = string.substitute(i18n.planDeliverNewUploadFinishedStatus, {
									fileName : this.uploadedFileName,
									numberOfDocuments : numberOfOk
								});								
							} else {
								message = string.substitute(i18n.planDeliverNewUploadFinishedWithErrorStatus, {
									fileName : this.uploadedFileName,
									numberOfDocuments : numberOfOk,
									numberOfErrors : numberOfErrors
								});								
							}
						} else {
							message = "";
						}
						
						DOMHelper.setInnerText(this.uploadStatusNode, message);
						topic.publish("message/ok", message);						
						
						this.updateWidgetsFromData();
						this.updateDocumentNumberFeedback();
			    		this.updateHolidayErrorFeedback();
						this.uploader.reset();
					}), lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
                                        err : err,
                                     widget : this,
                             asyncOperation : null,
                                     opName : "waitForJob",
                                    message : i18n.planDeliverNewUploadFailedMessage
						});						
						DOMHelper.setInnerText(i18n.uploaderStatusNode, i18n.planDeliverNewUploadFailedMessage);
					})).otherwise(lang.hitch(this, function(err) {
		    			log.error("Error while processing the results of a call to waitForJob: ", err);
					}));
				}
			}));    		
     		
     		// Import
     		DOMHelper.createTextNode("div", i18n.planDeliverNewImportButtonCaption, contextDiv, "propertyLabel planDeliverNewImportLabel");
    		this.uploader = new dojox.form.Uploader({name : "uploadedFile",
				 multiple : false,
				 type : "file",
				 label : i18n.chooseFile
    		});
    		domClass.add(this.uploader.domNode, "planDeliverNewImportUpload");
    		domConstruct.place(this.uploader.domNode, this.importForm.domNode);  
    		this.uploader.startup();

    		on(this.uploader, "change", lang.hitch(this, function(fileInfos) {
    			var message;
    			if (fileInfos.length > 0 && fileInfos[0].name != null) {
        			this.uploadedFileName = fileInfos[0].name;
    				var message = string.substitute(i18n.uploadStatusUploadRunning, {
        				fileName : fileInfos[0].name
        			});    			
    			} else {
    				this.uploadedFileName = null;
    				message = "";
    			}
    			DOMHelper.setInnerText(this.uploadStatusNode, message);    				

    			this.importForm.submit();
    		}));
    		
    		this.uploadStatusNode = DOMHelper.createTextNode("div", i18n.uploadStatusNoFileChosen, contextDiv, "fixedDialogWidget planDeliverNewUploadStatusLabel");
    		
    		var projectId = this.applicationContext.getPageContextProjectId();
    		if (projectId != null) {
    			var parameterString = ioQuery.objectToQuery({
    				projectId : projectId
    			});
    			
          		var url = "/cdes-dojo-impl/newDocumentImport?" + parameterString;       		
    			this.uploader.set("url", url);
    			this.importForm.set("action", url);    			
    		}
    		
    		return contextDiv;
    	},
    	
    	constructButtonBar : function() {
    		var buttonDiv = domConstruct.create("div", null, null);
    		domClass.add(buttonDiv, "planDeliverNewButtonBar");
    		
    		this.saveButton = this.constructSaveButton();
    		domConstruct.place(this.saveButton.domNode, buttonDiv);
    		
    		this.abortButton = this.constructAbortButton();
    		domConstruct.place(this.abortButton.domNode, buttonDiv);
    		
    		// Hint Icon
    		this.hintIcon = domConstruct.create("div", null, buttonDiv);
    		domClass.add(this.hintIcon, "planDeliverCatalogueHintIcon clazzesWarnIcon32");    		
    		
    		// Hint Div
    		this.hintSpan = DOMHelper.createTextNode("span", "Test", buttonDiv, "planDeliverCatalogueHintSpan");    		
    		
    		return buttonDiv;
    	},
    	
    	constructSaveButton : function() {
    		var saveButton = new Button({
				     label : i18n.planDeliverNewSaveButtonCaption,
			         title : i18n.planDeliverNewSaveButtonToolTip,
			       onClick : lang.hitch(this, this.save) 
    		});
    		return saveButton;
    	},
    	
    	constructAbortButton : function() {
    		var abortButton = new Button({
				     label : i18n.planDeliverNewAbortButtonCaption,
			         title : i18n.planDeliverNewAbortButtonToolTip,
			       onClick : lang.hitch(this, this.abort) 
    		});
    		return abortButton;
    	},    	
    	
    	constructGrid : function() {
    		
    		this.documents = [];
    		
    		var columns = this.constructColumns();
    		var TrackableMemory = declare([Memory, Trackable]);
    		this.store = new TrackableMemory({data : this.documents, idProperty : "_creationIndex"});
    		
    		var MyGrid = declare([OnDemandGrid, FancyColumnResizer, DijitRegistry, Editor ]);
    		this.grid = new MyGrid({
    			collection : this.store,
    			   columns : columns,
    			   		id : "PlanDeliverNewGrid"
    		});

            this.grid.afterResizeMouseUp = lang.hitch(this, this.handleColumnResize);
    		on(this.grid, "dgrid-datachange", lang.hitch(this, function(e) {

    			var column = e.cell && e.cell.column ? e.cell.column.id : null;
    			var rowId = e.cell && e.cell.row ? e.cell.row.id : null;    			    			
    			
    			// DnDCellWidget uses values { value, rowId }.
    			var oldValue = e.oldValue.value;
    			var newValue = e.value.value;

    			if (column == "documentName") {
    				// Keep document number map up to date
    				
    				if (oldValue.documentTypeId != newValue.documentTypeId || oldValue.number != newValue.number || oldValue.part != newValue.part) {
    					var somethingRemoved = this.deregisterFromDocumentNumberMap(oldValue);
    					
    					// This code can especially be triggered from setDocumentNumber above.  In that case, the bookkeeping tasks done in
    					// (de)registerInDocumentNumberMap are already done at this point.  Unfortunately, we receive the old value here.  Without
    					// the extra condition "has anything been removed?", we would register the new number for the second time here.
    					if (somethingRemoved) {
    			    		var project = this.applicationContext.getPageContextProject();
    			    		var network = this.applicationContext.getPageContextNetwork();
    			    		var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
    			    		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);
    			    		
    			    		var objectPlannerId = this.objectPlannerSelect.get("value");
    			    		var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");
    			    		
    			    		var documentKey = CodeHelper.getUniqueKeyForDocument(newValue, documentNumberParts, idToDocumentType, projectParticipation);
    						
    						this.registerInDocumentNumberMap({
    							                     documentKey : documentKey,
    							                        document : newValue,
    							  doUpdateDocumentNumberFeedback : true    							     
    						});
    					}    					
    				}
    				this.updateDataFromWidgets({ documentName : true });
    				this.updateWidgetState();
    			} else if (column == "startDate") {
        			// Propagate startDate changes directly into the document.  This way, the endDateFormatter
        			// can do its job right now (after we worked around a Dojo bug described below).
    				
    				var document = this.store.getSync(rowId);
    				document.startDate = newValue;
    				
    				if (document.startDate != null) {
        				var holidayCalculator = this.applicationContext.getHolidayCalculator();

        				var editors = this.dndInfo.rowIdToEditors[rowId];
            			this.dndInfo.rowIdToHolidayError[rowId] = holidayCalculator.isWeekendOrHoliday(document.startDate);
            			if (this.dndInfo.rowIdToHolidayError[rowId]) {
            				domClass.add(editors.startDateSpinner.dateTimeSpinBox.textbox, "errorField");
    						this.dndInfo.rowIdToHolidayMessage[rowId] = string.substitute(i18n.planDeliverHolidayError, {
    							documentName : document.number
    						});            					
            			} else {
            				domClass.remove(editors.startDateSpinner.dateTimeSpinBox.textbox, "errorField");
            				delete this.dndInfo.rowIdToHolidayMessage[editors.documentNumberEditor.get("value").value];
            			}
    				}
    				
    				document.endDate = this.getEndDateFromStartDate(document.startDate);

    				this.updateWidgetsFromData({
    					startDate : true,
    					  endDate : true
    				});
    				this.updateWidgetState();
    			} else if (column == "endDate") {
        			// Propagate endDate changes directly into the document.  This way, the startDateFormatter
        			// can do its job right now (after we worked around a Dojo bug described below).
    				
    				var document = this.store.getSync(rowId);
    				document.endDate = newValue;
    				
    				if (document.endDate != null) {
        				var holidayCalculator = this.applicationContext.getHolidayCalculator();
        				if (CdesVoc.doCorrectDates()) {
            				if (document.endDate != null) {
                				if (oldValue != null && newValue.getUtcSeconds() < oldValue.getUtcSeconds()) {
                					holidayCalculator.proceedToPreviousWorkingDay(document.endDate);    						
                				} else {
                					holidayCalculator.proceedToNextWorkingDay(document.endDate);    						
                				}        				
            				}    					
        				} else {
        					var editors = this.dndInfo.rowIdToEditors[rowId];
            				this.dndInfo.rowIdToHolidayError[rowId] = holidayCalculator.isWeekendOrHoliday(document.endDate);
            				if (this.dndInfo.rowIdToHolidayError[rowId]) {
            					domClass.add(editors.endDateSpinner.dateTimeSpinBox.textbox, "errorField");
    							this.dndInfo.rowIdToHolidayMessage[rowId] = string.substitute(i18n.planDeliverHolidayError, {
    								documentName : document.number
    							});            					
            				} else {
            					domClass.remove(editors.endDateSpinner.dateTimeSpinBox.textbox, "errorField");
            					delete this.dndInfo.rowIdToHolidayMessage[editors.documentNumberEditor.get("value").value];
            				}
            			}    					
    				}

    				
    				document.startDate = this.getStartDateFromEndDate(document.endDate);

    				//this.store.putSync(document);   
    				
    				// Work around a crazy Dojo bug: The putSync above triggers _showEditor in Editor.js, but unfortunately with the *old*
    				// value.  Result: The old value is preserved in the _editorsPendingStartup array, some time later, _startupPendingEditors
    				// is executed, and in the end, the new value is overwritten by the old value in _editorsPendingStartup.
    				/*
    				var toCalendarSpinner = this.dndInfo.rowIdToEditors[rowId].toCalendarSpinner;
    				
    				log.info("Setting toCalendarSpinner to value ", toCalendarSpinner, document.endDate);
    				toCalendarSpinner.set("value", {
    					value : document.endDate,
    					rowId : rowId
    				}, false);
    				*/
    				this.updateWidgetsFromData({
    					startDate : true,
    					  endDate : true
    				});
    				this.updateWidgetState();
    			}
    			
    			var lastRowId = (rowId == this.documents[this.documents.length - 1]._creationIndex);
    			if (lastRowId && !this.noNewDocuments) {
    				this.add();
    			}
    		}));
    		
    		on(this.grid, ".dgrid-row .dgrid-cell:click", lang.hitch(this, this.onDgridRowEvent));
    		
    		domClass.add(this.grid.domNode, "planDeliverNewGrid");
    		
            on(this.grid, "columnResizeMouseUp", lang.hitch(this, this.handleColumnResize));

    		this.grid.startup();

    		return this.grid.domNode;
    	},
    	
    	getStartDateFromEndDate : function(endDate) {
			var holidayCalculator = this.applicationContext.getHolidayCalculator();
			var duration = this.getReviewCycleInstanceDuration();
			duration = duration != null ? -duration : 0;
			return endDate != null ? holidayCalculator.addWorkingDays(endDate, duration) : null;    		
    	},
    	
    	getEndDateFromStartDate : function(startDate) {
			var holidayCalculator = this.applicationContext.getHolidayCalculator();
			var duration = this.getReviewCycleInstanceDuration();
			duration = duration != null ? duration : 0;
			return startDate != null ? holidayCalculator.addWorkingDays(startDate, duration) : null;    		
    	},    	
    	
    	resize : function(newSize) {
    		
    		newSize.h -= (this.contextDiv.offsetHeight + domStyle.get(this.contextDiv, "margin-top") + domStyle.get(this.contextDiv, "margin-bottom"));
    		newSize.h -= (this.buttonDiv.offsetHeight + domStyle.get(this.buttonDiv, "margin-top") + domStyle.get(this.buttonDiv, "margin-bottom"));
    		
    		this.grid.resize(newSize);
    		/*
    		domStyle.set(this.topDiv, "width", newSize.w);
    		domStyle.set(this.topDiv, "height", newSize.h);
    		*/
    	},
    	
    	reload : function() {
    		if (this.loadObjectsDeferred != null) {
    			this.loadObjectsDeferred.cancel();
    		}
    		// An already running loadMasterDataDeferred is handled inside applicationContext
    		
    		var objectService = this.applicationContext.getService("objectService");
    		
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var networkId = this.applicationContext.getPageContextNetworkId();
    		var project = this.applicationContext.getPageContextProject();
    		var subProjectId = this.applicationContext.getPageContextSubProjectId();
    		
    		
    		this.registerAsyncOperationStarted(PlanDeliverNewWidget.AsyncOperation.LOAD_OBJECTS);
    		this.loadObjectsDeferred = objectService.getEditableObjectPlannersForSubProject(organisationPersonId, subProjectId);
    		var loadMasterDataDeferred = this.applicationContext.loadMasterData(networkId);
    		promiseAll([this.loadObjectsDeferred, loadMasterDataDeferred]).then(lang.hitch(this, function(results) {
    			
					this.documents = [];
					this.store.setData(this.documents);					
    			
    				if (this.store.data == null || this.store.data.length == 0) {
						
					}

    				// TODO: Dialog needs to be disabled until these Deferreds come back
    				var objectPlannerNewDocumentInfo = results[0];
    				
    				var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, networkId);
    				this.documentNumberUniqueness = CodeHelper.getDocumentNumberUniqueness(documentNumberParts);
    				
    				for (var id in this.objectIdToJoinDto) {
    					delete this.objectIdToJoinDto[id];
    				}
    				for (var id in this.objectPlannerIdToJoinDto) {
    					delete this.objectPlannerIdToJoinDto[id];
    				}
    				for (var n = 0; n < objectPlannerNewDocumentInfo.objectPlannersWithObjects.length; n++) {
    					var joinDto = objectPlannerNewDocumentInfo.objectPlannersWithObjects[n];
    					
    					joinDto._objectCaption = joinDto.objectReleaseCode + (joinDto.objectTypeCode != null ? joinDto.objectTypeCode : "") + " " + joinDto.objectReleaseName;
    					joinDto._objectPlannerCaption = joinDto.objectPlannerReleaseCode + " " + joinDto.objectPlannerReleaseArea;    					
    					
    					this.objectIdToJoinDto[joinDto.objectId] = joinDto; // Called multiple times for the same object, but is no harm
    					this.objectPlannerIdToJoinDto[joinDto.objectPlannerId] = joinDto;
    				}
    				
    				this.objectIdToDocumentKeys = objectPlannerNewDocumentInfo.objectIdToDocumentKeys;
    				this.objectPlannerIdToDocumentKeys = objectPlannerNewDocumentInfo.objectPlannerIdToDocumentKeys;
    				this.objectPlannerIdToAllowedActions = objectPlannerNewDocumentInfo.objectPlannerIdToAllowedActions;
    				
    				this.populateObjectSelect();
    				
    				delete this.loadObjectsDeferred;

    				this.registerAsyncOperationFinished(PlanDeliverNewWidget.AsyncOperation.LOAD_OBJECTS);
    			}),
    			lang.hitch(this, function(err) {    			
    				if (this.loadObjectsDeferred != null) {
    					// A promiseAll most probably fails if one of its Deferred fails - thus cancel() this one, as it might
    					// still be running.  The loadMasterDataDeferred is handled inside the 
    					// applicationContext, and no harm here.
    					this.loadObjectsDeferred.cancel();
    					delete this.loadObjectsDeferred;	
    				}
    				
       				ErrorHelper.processAsyncError({
                                  err : err,
                               widget : this,
                       asyncOperation : PlanDeliverNewWidget.AsyncOperation.LOAD_OBJECTS,
                               opName : "load(Objects|MasterData)",
                              message : i18n.planDeliverNewLoadMetaDataFailedMessage
       				});    				
				})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of a call to getEditableObjectPlannersForSubProject: ", err);
    		}));  
    		
    		this.documents = [];
    		this.grid.refresh();
    	},
    	
    	updateDataFromWidgets : function(columns) {
    		if (columns == null) {
    			columns = {
    				documentName : true,
    				     content : true,
    				       scale : true,
    				     comment : true,
    				   startDate : true,
    				     endDate : true
    			};
    		}
    		    		
    		for (var rowId in this.dndInfo.rowIdToEditors) {
    			var document = this.store.getSync(rowId);
    			
    			var editors = this.dndInfo.rowIdToEditors[rowId];
    			
    			if (columns.documentName) {
    				var value = editors.documentNumberEditor.get("value");
    				var documentNumberInfo = value.value;
    				document._creationIndex = documentNumberInfo._creationIndex;
    				document.number = documentNumberInfo.number;
    				document.part = documentNumberInfo.part;
    				document.documentTypeId = documentNumberInfo.documentTypeId;
    				DocumentNumberEditor.extractEditorInfo(document);
    			}
    			if (columns.content) {
    				document.content = editors.contentTextArea.get("value");	
    			}
    			if (columns.scale) {
    				document.scale = editors.scaleTextArea.get("value");	
    			}
    			if (columns.comment) {
    				document.comment = editors.commentTextArea.get("value");    				
    			}
    			if (columns.endDate) {
        			document.endDate = editors.endDateSpinner.get("value").value;    	

        			if (document.endDate != null) {
        				var holidayCalculator = this.applicationContext.getHolidayCalculator();
            			if (CdesVoc.doCorrectDates()) {
                			if (document.endDate != null) {
                				holidayCalculator.proceedToNextWorkingDay(document.endDate);        				
                			}        				
            			} else {
            				this.dndInfo.rowIdToHolidayError[rowId] = holidayCalculator.isWeekendOrHoliday(document.endDate);
            				if (this.dndInfo.rowIdToHolidayError[rowId]) {
            					domClass.add(editors.endDateSpinner.dateTimeSpinBox.textbox, "errorField");
    							this.dndInfo.rowIdToHolidayMessage[rowId] = string.substitute(i18n.planDeliverHolidayError, {
    								documentName : document.number
//    								documentName : CodeHelper.getDocumentName(editors.documentNumberEditor.get("value").value)
    							});            					
            				} else {
            					domClass.remove(editors.endDateSpinner.dateTimeSpinBox.textbox, "errorField");
            					delete this.dndInfo.rowIdToHolidayMessage[editors.documentNumberEditor.get("value").value];
            				}
            			}        				
        			}
        			
        			document.startDate = this.getStartDateFromEndDate(document.endDate);        			    				    				
    			}
    		}
    	},
    	
    	updateWidgetsFromData : function(columns) {
    		if (columns == null) {
    			columns = {
    				documentName : true,
    				     content : true,
    				       scale : true,
    				     comment : true,
    				   startDate : true,
    				     endDate : true
    			};
    		}
    		
    		for (var rowId in this.dndInfo.rowIdToEditors) {
    			var document = this.store.getSync(rowId);
    			
    			var editors = this.dndInfo.rowIdToEditors[rowId];
    			
    			if (columns.documentName) {
    				editors.documentNumberEditor.set("value", { _creationIndex : document._creationIndex, value : document._documentNumberInfo, rowId : document._creationIndex }, false);
    			}
    			if (columns.content) {
    				editors.contentTextArea.set("value", { value : document.content, rowId : document._creationIndex }, false);	
    			}
    			if (columns.scale) {
    				editors.scaleTextArea.set("value", { value : document.scale, rowId : document._creationIndex }, false);	
    			}
    			if (columns.comment) {
    				editors.commentTextArea.set("value", { value : document.comment, rowId : document._creationIndex}, false);	
    			}
    			if (columns.startDate) {
    				editors.startDateSpinner.set("disabled", !this.canEditStartDate(document));
    				editors.startDateSpinner.set("dndEnabled", this.canEditStartDate(document));
    				editors.startDateSpinner.set("value", { value : document.startDate, rowId : document._creationIndex }, false);    				
    			}
    			if (columns.endDate) {
    				editors.endDateSpinner.set("disabled", !this.canEditEndDate(document));
    				editors.endDateSpinner.set("dndEnabled", this.canEditEndDate(document));
    				editors.endDateSpinner.set("value", { value : document.endDate, rowId : document._creationIndex }, false);		
    			}
    		}
    	},
    	
    	updateWidgetState : function() {
    		var allFieldsOk = true;
    		
    		for (var rowId in this.dndInfo.rowIdToHolidayError) {
    			allFieldsOk &= !this.dndInfo.rowIdToHolidayError[rowId];
    		}
    		
    		var objectSelectDisabled;
    		var objectPlannerSelectDisabled;
    		
    		if (this.objectSelectPopulated && this.objectSelect.get("options").length == 0) {
    			var subProject = this.applicationContext.getPageContextSubProject();
    			on.emit(this, "warnMessage", string.substitute(i18n.planDeliverNewNoObjectMessage, {    				
    				subProjectName : subProject != null ? subProject.name : "---"
    			}));
    			objectSelectDisabled = true;
    			objectPlannerSelectDisabled = true;    			
    					
    			allFieldsOk = false;
    		} else if (this.objectPlannerSelectPopulated && this.objectPlannerSelect.get("options").length == 0) {
    			on.emit(this, "warnMessage", i18n.planDeliverNewNoObjectPlannerMessage);
    			
    			objectSelectDisabled = false;
    			objectPlannerSelectDisabled = true;    			
    			
    			allFieldsOk = false;
    		} else {
    			on.emit(this, "infoMessage", "");
    			
    			objectSelectDisabled = false;
    			objectPlannerSelectDisabled = false;
    		}
    		
    		this.objectSelect.set("disabled", objectSelectDisabled);
    		this.objectPlannerSelect.set("disabled", objectPlannerSelectDisabled);
    		
    		for (var rowId in this.dndInfo.rowIdToEditors) {
    			var document = this.store.getSync(rowId);
    			
    			var editors = this.dndInfo.rowIdToEditors[rowId];
    			if (   editors.documentNumberEditor.hasDocumentNumberError()
    				|| !editors.endDateSpinner.isValid()) {
    				allFieldsOk = false;
    			} 
    		}
    		
    		this.saveButton.set("disabled", !allFieldsOk);
    		this.hint = allFieldsOk ? null : this.calculateHint();

    		if (this.hint == null) {
        		domClass.add(this.hintIcon, "hidden");
        		domClass.add(this.hintSpan, "hidden");    		
        		
        		DOMHelper.setInnerText(this.hintSpan, "");
    		} else {
        		domClass.remove(this.hintIcon, "hidden");
        		domClass.remove(this.hintSpan, "hidden");
        		
        		DOMHelper.setInnerText(this.hintSpan, this.hint);
    		}
    	},
    	
    	calculateHint : function() {
       		for (var rowId in this.dndInfo.rowIdToEditors) {
           		var editor = this.dndInfo.rowIdToEditors[rowId].documentNumberEditor;
            		
           		if (editor) {
               		if (editor.hasDocumentNumberError()) {
               			var joinDto = this.store.getSync(rowId);
               			var numberParts = CodeHelper.getDocumentNumberParts(this.applicationContext);
               			var message = string.substitute(i18n.planDeliverDocumentNumberError, {
               				  documentName : joinDto.number,//joinDto.documentName,
               			     detailMessage : editor.getDocumentNumberErrorMessage()   
               			});
               			return message;
               		}    			
           		}
       		}
       		for (var rowId in this.dndInfo.rowIdToHolidayMessage) {
       			if (this.dndInfo.rowIdToHolidayError[rowId] && this.dndInfo.rowIdToHolidayMessage[rowId]) {
       				return this.dndInfo.rowIdToHolidayMessage[rowId];
       			}
       		}
    		return null;
    	},
    	
    	getHint : function() {
    		return this.hint;
    	},    	
    	
    	populateObjectSelect : function() {
    		
    		if (this.objectIdToJoinDto != null) {
    			var alreadySeenObjectIds = new Object();
    			var objectJoinDtos = [];
    			for (var objectId in this.objectIdToJoinDto) {
    				objectJoinDtos.push(this.objectIdToJoinDto[objectId]);
    			}    			

    			DataHelper.sortByStrings(objectJoinDtos, "_objectCaption");
    		
    			var options = [];
    			for (var n = 0; n < objectJoinDtos.length; n++) {
    				options.push({
    					label : objectJoinDtos[n]._objectCaption,
    					value : objectJoinDtos[n].objectId
    				});
    			}
    			this.objectSelect.set("options", options);
    			
    			if (this.presetObjectId != null && this.presetObjectId in this.objectIdToJoinDto) {
    				this.objectSelect.set("value", this.presetObjectId);
    			} else if (options.length > 0) {
    				this.objectSelect.set("value", options[0].value);
    			} else {
    				this.objectSelect.set("value", null);
    			}
    			this.objectSelectPopulated = true;
    		} else {
    			this.objectSelect.set("options", []);
    		}
    	},
    	
    	updateObjectPlannerSelect : function() {
    		var selectedObjectId = this.objectSelect.get("value");
    		if (selectedObjectId != null && this.objectPlannerIdToJoinDto != null) {
    			var objectPlannerJoinDtos = [];
    			for (var objectPlannerId in this.objectPlannerIdToJoinDto) {
    				var joinDto = this.objectPlannerIdToJoinDto[objectPlannerId];
    				if (joinDto.objectId == selectedObjectId) {
    					objectPlannerJoinDtos.push(joinDto);
    				}
    			}
    			
    			DataHelper.sortByStrings(objectPlannerJoinDtos, "_objectPlannerCaption");
    			
    			var options = [];
    			for (var n = 0; n < objectPlannerJoinDtos.length; n++) {
    				options.push({
    					label : objectPlannerJoinDtos[n]._objectPlannerCaption,
    					value : objectPlannerJoinDtos[n].objectPlannerId
    				});
    			}
    			this.objectPlannerSelect.set("options", options);
    			
    			if (this.presetObjectPlannerId != null && this.presetObjectPlannerId in this.objectPlannerIdToJoinDto) {
    				this.objectPlannerSelect.set("value", this.presetObjectPlannerId);
    			} else 
    				this.objectPlannerSelect.set("value", options.length > 0 ? options[0].value : null, false);
    			this.objectPlannerSelectPopulated = true;
    		} else {
    			this.objectPlannerSelect.set("options", []);
    			this.objectPlannerSelect.set("value", null, false);
    		}
    		
    		this.onObjectPlannerSelected();
    		
			this.updateDocumentNumberFeedback();
    	},
    	
    	getReviewCycleInstanceDuration : function() {
    		var selectedObjectPlannerId = this.objectPlannerSelect.get("value");
    		if (selectedObjectPlannerId != null && selectedObjectPlannerId in this.objectPlannerIdToJoinDto) {
    			var joinDto = this.objectPlannerIdToJoinDto[selectedObjectPlannerId];
    			return joinDto.reviewCycleInstanceDuration;
    		} else {
    			return null;
    		}    		
    	},
    	
    	onObjectPlannerSelected : function() {    		    		
    		var duration = this.getReviewCycleInstanceDuration();
    		if (duration != null) {
    			this.durationTextBox.set("value", string.substitute(i18n.planDeliverNewDurationString, {
					duration : duration
				}));
    		} else {
    			this.durationTextBox.set("value", "");
    		}
    		    		
    		this.resetDocumentNumberMap();
    		
    		if (this.documents.length == 0) {
    			this.add();
				//this.store.addSync(this.constructNewDocument());
				log.info("onObjectPlannerSelected: ", this.documents.length, this.documents);
    		}
    		
    		this.resetNewDocumentNumbers();
    		this.resetObjectPlannerIds();
    		
    		this.updateWidgetsFromData({
    			documentName : true
    		});
    	},
    	
    	resetDocumentNumberMap : function() {
    		this.documentNumberToDocuments = new Object();
    		
    		// The DocumentNumberParts decide which notion of document number uniqueness we need.
    		var existingDocumentNumbers = [];
    		if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT) {
    			var objectId = this.objectSelect.get("value");
    			if (objectId != null) {
    				for (var documentId in this.objectIdToDocumentKeys[objectId]) {
    		    		// Register fake documents for all existing document numbers (we don´t pass the document instances itself to the client
    		    		// for security reasons, as this might affect documents the user doesn´t have privileges to even see them).    					
    					
    					var uniqueDocumentInfo = this.objectIdToDocumentKeys[objectId][documentId];
    					var fakeDocument = this.constructFakeDocument(documentId, uniqueDocumentInfo.documentNumber);
    					this.registerInDocumentNumberMap({
    						                      documentKey : uniqueDocumentInfo.documentKey,
    						                         document : fakeDocument,
    						   doUpdateDocumentNumberFeedback : true
    						   
    					});    					
    				}
    			}    			
    		} else if (this.documentNumberUniqueness == CdesVoc.DocumentNumberUniqueness.OBJECT_PLANNER) {
    			var objectPlannerId = this.objectPlannerSelect.get("value");
    			if (objectPlannerId != null) {
    				for (var documentId in this.objectPlannerIdToDocumentNumbers[objectPlannerId]) {
    					var uniqueDocumentInfo = this.objectPlannerIdToDocumentKeys[objectId][documentId];
    					var fakeDocument = this.constructFakeDocument(documentId, uniqueDocumentInfo.documentNumber);
    					this.registerInDocumentNumberMap({
    						                      documentKey : uniqueDocumentInfo.documentKey,
    						                         document : fakeDocument,
    						   doUpdateDocumentNumberFeedback : true
    						   
    					});    					
    				}
    			}
			} else {
				if (this.objectIdToDocumentKeys != null) {
					for (var objectId in this.objectIdToDocumentKeys) {
						var documentIdToUniqueDocumentInfos = this.objectIdToDocumentKeys[objectId];
						for (var documentId in documentIdToUniqueDocumentInfos) {
							var uniqueDocumentInfo = documentIdToUniqueDocumentInfos[documentId];
							if (uniqueDocumentInfo.documentKey == "null")
								continue;
							var fakeDocument = this.constructFakeDocument(documentId, uniqueDocumentInfo.documentNumber);
							this.registerInDocumentNumberMap({
								                      documentKey : uniqueDocumentInfo.documentKey,
								                         document : fakeDocument,
								   doUpdateDocumentNumberFeedback : true
								   
							});    					
						}
					}
				}
			} 
    	},   
    	
    	resetNewDocumentNumbers : function() {
    		var project = this.applicationContext.getPageContextProject();
    		var network = this.applicationContext.getPageContextNetwork();
    		var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
    		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);    		
    		
    		for (var n = 0; n < this.documents.length; n++) {
    			var document = this.documents[n];
    			this.deregisterFromDocumentNumberMap(document);
    		}
    		
    		for (var n = 0; n < this.documents.length; n++) {
    			var document = this.documents[n];
        		var objectPlannerId = this.objectPlannerSelect.get("value");
    			var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");
    			
    			document.number = this.getFirstUnusedDocumentNumber({
    					            documentTypeId : null,
    					                  document : document,
    					      projectParticipation : projectParticipation,
    					       documentNumberParts : documentNumberParts,
    					          idToDocumentType : idToDocumentType,
    					                 minNumber : null
    			});
    			
        		var documentKey = CodeHelper.getUniqueKeyForDocument(document, documentNumberParts, idToDocumentType, projectParticipation);    			
    			
    			DocumentNumberEditor.extractEditorInfo(document);
    			this.registerInDocumentNumberMap({
    				                         documentKey : documentKey,
    				                            document : document,
    				      doUpdateDocumentNumberFeedback : true
    			});
    			
    			var editors = this.dndInfo.rowIdToEditors[document._creationIndex];
    			
    			// Prevent that the change handler creates a new document at the end of on(dgrid-datachange)
    			this.noNewDocuments = true;
    			
    			editors.documentNumberEditor.set("value", {
    				value : document._documentNumberInfo,
    				rowId : document._creationIndex
    			});
    			
    			this.noNewDocuments = false;
    		}
    	},
    	
    	constructFakeDocument : function(documentId, documentNumber) {
			var fakeDocument = new Object();
			fakeDocument._creationIndex = this.nextFreeCreationIndex;
			fakeDocument.id = this.nextFreeFakeDocumentId;
			fakeDocument.number = documentNumber;
			
			this.nextFreeFakeDocumentId--;
			this.nextFreeCreationIndex++;    		
 
			return fakeDocument;
    	},    	
    	
    	registerInDocumentNumberMap : function(params) {
    		var documentKey = params.documentKey; // DocumentKey already calculated at the server (for fake documents)
    		var document = params.document;       // Document
    		var doUpdateDocumentNumberFeedback = params.doUpdateDocumentNumberFeedback;    		
    		
    		if (doUpdateDocumentNumberFeedback == null) {
    			doUpdateDocumentNumberFeedback = true;
    		}

    		var objectPlannerId = this.objectPlannerSelect.get("value");
    		var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");
    		
    		if (documentKey == null) {
        		var project = this.applicationContext.getPageContextProject();
        		var numberParts = this.applicationContext.getNumberPartsForProject(project);
        		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);
        		documentKey = CodeHelper.getUniqueKeyForDocument(document, numberParts, idToDocumentType, projectParticipation);    			
    		}    		
    		
   			if (!(documentKey in this.documentNumberToDocuments)) {
   				this.documentNumberToDocuments[documentKey] = [];
   			}
    			
   			var alreadyThere = false;
   			var documents = this.documentNumberToDocuments[documentKey];
   			for (var n = 0; n < documents.length; n++) {
   				if (       (document.id != null && document.id == documents[n].id)
   						|| (document._creationIndex != null && document._creationIndex == documents[n]._creationIndex)) {
   					alreadyThere = true;
   				}
   			}
    			
   			if (!alreadyThere) {
   				documents.push(document);
   			}
    			
   			if (documents.length > 1) {
   				log.warn("Duplicate document number: ", document);
   			}
    			
   			if (doUpdateDocumentNumberFeedback) {
   				this.updateDocumentNumberFeedback();	
   			}    			
    	},
    	
    	deregisterFromDocumentNumberMap : function(document) {
    		// Caution: Since DocumentNumberEditors have to return a copy of the document (and not the document itself) as value,
    		//          we may not assume reference-equality here.  In other words: The document-instance we get here might not be
    		//          the same as we inserted before into datastructures like documentNumberToDocuments.
    		
			var project = this.applicationContext.getPageContextProject();
    		var numberParts = this.applicationContext.getNumberPartsForProject(project);
    		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);
    		
    		var objectPlannerId = this.objectPlannerSelect.get("value");
			var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");        		
    		
    		var documentKey = CodeHelper.getUniqueKeyForDocument(document, numberParts, idToDocumentType, projectParticipation);    		
    		
    		if (documentKey in this.documentNumberToDocuments) {
    			var oldDocuments = this.documentNumberToDocuments[documentKey];
    			var newDocuments = [];
    			for (var n = 0; n < oldDocuments.length; n++) {
    				if (!((document.id != null && document.id == oldDocuments[n].id)
    						|| (document._creationIndex != null && document._creationIndex == oldDocuments[n]._creationIndex))) {

    					newDocuments.push(oldDocuments[n]);
    				}
    			}
    			
    			if (newDocuments.length > 0) {
    				this.documentNumberToDocuments[documentKey] = newDocuments;	
    			} else {
    				delete this.documentNumberToDocuments[documentKey];
    			}
    			
    			this.updateDocumentNumberFeedback();
    			
    			return newDocuments.length < oldDocuments.length; 
    		}
    	},
    	
        updateDocumentNumberFeedback : function() {
    		var project = this.applicationContext.getPageContextProject();
    		var network = this.applicationContext.getPageContextNetwork();
    		var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
    		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project); 
    		
    		var objectPlannerId = this.objectPlannerSelect.get("value");
			var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");    		
        	
        	for (var rowId in this.dndInfo.rowIdToEditors) {
        		var editor = this.dndInfo.rowIdToEditors[rowId].documentNumberEditor;
        		var hasDocumentNumberError = editor.hasDocumentNumberError();
        		
        		var documentNumberInfo = editor.get("value").value;  // Supposed to contain the attributes relevant for uniqueness check (e.g. number, documentTypeId)
        		var documentKey = CodeHelper.getUniqueKeyForDocument(documentNumberInfo, documentNumberParts, idToDocumentType, projectParticipation);
        		
        		var documents = this.documentNumberToDocuments[documentKey];
        		if (documents != null && documents.length > 1) {
        			if (!hasDocumentNumberError) {
        	    		var objectPlannerId = this.objectPlannerSelect.get("value");
            			var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");
        				
            			var message = string.substitute(i18n.planDeliverNewNotUniqueNumberError, {
            				freeNumber : this.getFirstUnusedDocumentNumber({
            						    documentTypeId : null,
            					              document : documents[0],
            					  projectParticipation : projectParticipation,
            					   documentNumberParts : documentNumberParts,
            					      idToDocumentType : idToDocumentType,
            					             minNumber : null
            				
            				})
            			});
            			
            			
            			editor.setDocumentNumberError(message);        				
        			}
        		} else if (hasDocumentNumberError) {
        			editor.dropDocumentNumberError();
        		}
        	}
        },
        		
        //updateHolidayErrorFeedback	
        updateHolidayErrorFeedback : function() {
        	for (var rowId in this.dndInfo.rowIdToHolidayError) {
				var documentName = null;
	    		for (var n = 0; n < this.documents.length; n++) {
	    			if (this.documents[n]._creationIndex == rowId)
	    				documentName = this.documents[n].number;
	    		}
        		var editor = this.dndInfo.rowIdToEditors[rowId];
				if (this.dndInfo.rowIdToHolidayError[rowId]) {
					domClass.add(editor.endDateSpinner.dateTimeSpinBox.textbox, "errorField");
					this.dndInfo.rowIdToHolidayMessage[rowId] = string.substitute(i18n.planDeliverHolidayError, {
						documentName : documentName
					});            					
				} else {
					domClass.remove(editor.startDateSpinner.dateTimeSpinBox.textbox, "errorField");
					delete this.dndInfo.rowIdToHolidayMessage[rowId];
				}
        	}
			this.updateWidgetState();      	
        },
        
        resetObjectPlannerIds : function() {
        	var objectPlannerId = this.objectPlannerSelect.get("value");
        	for (var n = 0; n < this.documents.length; n++) {
        		this.documents[n].objectPlannerId = objectPlannerId;
        	}
        },
    	
    	updateNewDocuments : function() {
    		// summary:
    		//      This function adapts the grid with new documents to a maybe changed
    		//      object planner selection.    	     	

    		var objectPlannerId = this.objectPlannerSelect.get("value");
    		
    		var project = this.applicationContext.getPageContextProject();
    		var network = this.applicationContext.getPageContextNetwork();
    		var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
    		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);
    		var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");
    		
    		if (objectPlannerId == null || objectPlannerId == "") {
    			// No object planner selected.  Can e.g. happen if an object without
    			// any existing object planner is selected. 
    			// We want to preserve maybe already entered data, but don´t want to show it any longer.
    			this.documentsVisible = false;
    			this.store.setData([]);
    			this.grid.refresh();
    		} else {
    			// An object planner is selected.  Adapt the shown data to the (maybe) new object planner if necessary.
    			if (this.documents.length == 0) {
    				// Assure that the grid always contains at least one entry.
    				var newEntry = this.constructNewDocument();
    				var documentKey = CodeHelper.getUniqueKeyForDocument(newEntry, documentNumberParts, idToDocumentType, projectParticipation);
    				
    				this.registerInDocumentNumberMap({
    					                        documentKey : documentKey,
    					                           newEntry : newEntry, 
    					     doUpdateDocumentNumberFeedback : false
    				});
    				this.documents.push(newEntry);
    				//log.info("UpdateNewDocuments, documents.push: Now ", this.documents.length, this.documents);
    			} else if (objectPlannerId != this.oldSelectedObjectPlannerId) {
    				// Only if the value of the grid has actually changed, update all already entered documents.  They
    				// e.g. have to be linked to the newly selected object planner.
    				for (var n = 0; n < this.documents.length; n++) {
    					var joinDto = this.documents[n];
    					joinDto.objectPlannerId = objectPlannerId;
    				}
    			}
    			
    			// If the documents weren´t visible before (since there was no object planner selected), make them
    			// visible again.
    			if (!this.documentsVisible) {
    				this.store.setData(this.documents);
    				this.documentsVisible = true;
    			}
    			
    			// And finally make the grid adapt itself to the new situation.
    			this.grid.refresh();
    		}
    		
    		this.oldSelectedObjectPlannerId = objectPlannerId;
    	},
    	
    	onDgridRowEvent : function(e) {
    		
			var rowId = DnDCellWidget.getRowIdForEvent(this.domNodeIdToValueInfo, e);
    		
			if (rowId != null) {
	    		var row = this.grid.row(rowId);
	    		var nextRow = this.grid.down(row);
	    		
	    		if (nextRow == null || row.id == nextRow.id) {
	    			var newDocument = this.constructNewDocument();
	    			this.store.addSync(newDocument);
	    			log.info("onDgridRowEvent: ", this.documents.length, this.documents);
	    		}				
			}
    	},
    	
    	getFirstUnusedDocumentNumber : function(params) {
    		var documentTypeId = params.documentTypeId;
            var document = params.document; 
            var projectParticipation = params.projectParticipation;
            var documentNumberParts = params.documentNumberParts;
            var idToDocumentType = params.idToDocumentType;
            var minNumber = params.minNumber;
            
    		// document == null: n++
    		// document != null:
    		//     length == 1: 
    		//         == document: break
    		//         != document: n++
    		//     length != 1: n++            
    		
    		// Document number 0 seems to be forbidden
    		var n = (minNumber == null ? 1 : minNumber);
       		while (true) {
       			var candidateDocument;
       			if (document == null) {
       				candidateDocument = {
       					        number : n,
								part : null,
       					documentTypeId : documentTypeId
       				};
       			} else {
       				candidateDocument = DataHelper.clone(document);
           			candidateDocument.number = n;
					candidateDocument.part = null;
       			}

       			var candidateKey = CodeHelper.getUniqueKeyForDocument(candidateDocument, documentNumberParts, idToDocumentType, projectParticipation);
        			
       			if (candidateKey != null && candidateKey in this.documentNumberToDocuments
       					&& (document == null || this.documentNumberToDocuments[candidateKey].length > 1 || this.documentNumberToDocuments[candidateKey][0] != document)) {
       				n++;	
       			} else {
       				break;
       			}        			
       		}    			
    		
    		return n;
    	},            	

    	/*
    	getFirstUnusedDocumentNumber : function(document, minNumber) {
    		// Document number 0 seems to be forbidden
    		var n = (minNumber == null ? 1 : minNumber);
    		
    		while (n in this.documentNumberToDocuments) {
    			if (document == null || this.documentNumberToDocuments[n].length != 1 || this.documentNumberToDocuments[n][0] != document) {
    				n++;	
    			} else {
    				break;
    			}
    		}
    		
    		return n;
    	},*/
    	
    	getDefaultDocumentTypeId : function() {

    		var project = this.applicationContext.getPageContextProject();
    		var documentNumberPartGroupId = project ? project.documentNumberPartGroupId : null;
    		var documentNumberGroup = documentNumberPartGroupId ? this.applicationContext.getDocumentNumberGroup(documentNumberPartGroupId) : null;
    		var masterData = documentNumberGroup ? this.applicationContext.getMasterData(documentNumberGroup.masterDataSetId) : null;
    		
    		if (masterData) {
    			// Return a documentType without children, if such a documentType exists
    			for (var documentTypeId in masterData.idToDocumentType) {
    				if (!(documentTypeId in masterData.idToDocumentTypeChildren)) {
    					return documentTypeId;
    				}
    			}

    			// Else return an arbitrary documentType
    			for (var id in masterData.idToDocumentType) {
            		return id;
    			}
    		}

    		return null;
    	},
    	
    	constructNewDocument : function() {
    		var objectPlannerId = this.objectPlannerSelect.get("value");
    		
    		var projectParticipation = JoinHelper.getJoinDtoComponent(this.objectPlannerIdToJoinDto[objectPlannerId], "projectParticipation");

    		var project = this.applicationContext.getPageContextProject();
    		var network = this.applicationContext.getPageContextNetwork();
    		var documentNumberParts = this.applicationContext.getDocumentNumberParts(project.documentNumberPartGroupId, network.id);
    		var idToDocumentType = this.applicationContext.getDocumentTypesForProject(project);    		
    		
    		var documentTypeId = this.getDefaultDocumentTypeId();
    		var number = this.getFirstUnusedDocumentNumber({
    					   documentTypeId : documentTypeId,
    			                 document : null,
    			     projectParticipation : projectParticipation,
    			      documentNumberParts : documentNumberParts,
    			         idToDocumentType : idToDocumentType,
    			                minNumber : null
    		});
    		
    		var newDocument = {
	                              number : number,
								    part : null,
	                                name : "",
	                               scale : "",
	                             content : "",
	                 hasDocumentVersions : null,             // Server side
	                      documentListId : null,             // Server side
	                     objectPlannerId : objectPlannerId,
	                      documentTypeId : documentTypeId,
	                           startDate : null,             // TODO
	                             endDate : null,             // TODO
	                            duration : null,             // TODO
	                            modified : null,             // Server side
	                         invalidated : null,             // Server side
	                    asBuiltReference : null,   			 // Server side,
	                      _creationIndex : this.nextFreeCreationIndex
    		};
    		DocumentNumberEditor.extractEditorInfo(newDocument);
    		
			this.nextFreeCreationIndex++;
			return newDocument;
    	},
    	
    	save : function() {
    		this.updateDataFromWidgets();
    		
    		var documentsToSave = SaveLoadHelper.convertDtosForSave({
    			               dtos : this.documents, 
    			  dndCellAttributes : ["comment", "content", "scale"],
    			fancyDateAttributes : ["startDate", "endDate"],
    		});
    		
    		if (this.saveDeferred) {
    			this.saveDeferred.cancel();
    			delete this.saveDeferred;
    		}
    		    		
    		var objectPlannerId = this.objectPlannerSelect.get("value");
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var networkId = this.applicationContext.getPageContextNetworkId();
    		var projectId = this.applicationContext.getPageContextProjectId();
    		var subProjectId = this.applicationContext.getPageContextSubProjectId();
    		
    		this.registerAsyncOperationStarted(PlanDeliverNewWidget.AsyncOperation.SAVE);
    		
    		var planDeliverService = this.applicationContext.getService("planDeliverService");
    		this.saveDeferred = planDeliverService.insertDocuments(documentsToSave, objectPlannerId, organisationPersonId, subProjectId, projectId, networkId);
    		    		
    		this.saveDeferred.then(lang.hitch(this, function(planDeliverJoin) {
    				delete this.saveDeferred;
    				
    				topic.publish("message/ok", string.substitute(i18n.planDeliverNewSaveOk, {
    					numberOfDocuments : planDeliverJoin.joinDtos.length.toString()
    				}));
    				    				
    				this.registerAsyncOperationFinished(PlanDeliverNewWidget.AsyncOperation.SAVE);
    				
    	     		this.applicationContext.setPage("planDeliverCatalogue", {}, {
    	     			gotoUnreleasedVersion : true,
    	     						 cameBack : true

    	     			// Uncomment this line to jump to the just added documents, instead of initiating a new query:
    	     			// givenNewPlanDeliverJoin : planDeliverJoin
    	     		});    				
    			}),
    			lang.hitch(this, function(err) {    			
    				delete this.saveDeferred;
    				var addString = "";
    				var errorMessage = i18n.planDeliverNewSaveFailedMessage;
    				if (err.message != null && err.message.indexOf("Trying to add duplicate document number for objectPlanner")>0){
							var numberString = err.message.substring(err.message.indexOf("documentNumber ["));
							var number = numberString.substring(numberString.indexOf("[")+1,numberString.indexOf("]"));
							errorMessage = string.substitute(i18n.planDeliverNewSaveFailedDublicateNumberMessage, {
    								documentNumber : number
    						});
					}
    				if (err.message != null && err.message.indexOf("While adding new documents: Already the existing document")>0){
							var numberString = err.message.substring(err.message.indexOf("documentNumber ["));
							var number = numberString.substring(numberString.indexOf("[")+1,numberString.indexOf("]"));
							errorMessage = string.substitute(i18n.planDeliverNewSaveFailedDublicateOtherNumberMessage, {
    								documentNumber : number
    						});
					}
    				ErrorHelper.processAsyncError({
					                  err : err,
                                   widget : this,
                           asyncOperation : PlanDeliverNewWidget.AsyncOperation.SAVE,
                                   opName : "insertDocuments",
                                  message : errorMessage
    				});     				
				})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of a call to insertDocuments: ", err);
    		}));    		
    	},
    	
    	abort : function() {
    		this.applicationContext.setPage("planDeliverCatalogue", {}, {
     			gotoUnreleasedVersion : true,
 						 	 cameBack : true
    		});
    	},
    	
    	destroy : function() {
    		this.inherited(arguments);
    		this.grid.destroy();
    	}    	
    });
    
    PlanDeliverNewWidget.documentNameDnDStartTopic = "planDeliverNew/documentNameDnDStart";
    PlanDeliverNewWidget.documentNameSetDataTopic = "planDeliverNew/documentNameSetData";    
    
    PlanDeliverNewWidget.contentDnDStartTopic = "planDeliverNew/contentDnDStart";
    PlanDeliverNewWidget.contentSetDataTopic = "planDeliverNew/contentSetData";
    
    PlanDeliverNewWidget.scaleDnDStartTopic = "planDeliverNew/scaleDnDStart";
    PlanDeliverNewWidget.scaleSetDataTopic = "planDeliverNew/scaleSetData";
    
    PlanDeliverNewWidget.commentDnDStartTopic = "planDeliverNew/commentDnDStart";
    PlanDeliverNewWidget.commentSetDataTopic = "planDeliverNew/commentSetData";    
    
    PlanDeliverNewWidget.documentFromDnDStartTopic = "planDeliverNew/documentFromDnDStart";
    PlanDeliverNewWidget.documentFromSetDataTopic = "planDeliverNew/documentFromSetData";
    
    PlanDeliverNewWidget.documentToDnDStartTopic = "planDeliverNew/documentToDnDStart";
    PlanDeliverNewWidget.documentToSetDataTopic = "planDeliverNew/documentToSetData";
    
    PlanDeliverNewWidget.AsyncOperation = {
    		LOAD_OBJECTS : "LoadObjects",
    		        SAVE : "Save" 
    };
    
    return PlanDeliverNewWidget;
});
