/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

define([ "cdes/widget/ContextBar",
	 "cdes/core/CdesVoc",
	 "clazzes/TinyLog",
         "clazzes/form/MultiWidget",
	 "clazzes/util/DOMHelper",
	 "clazzes/util/ErrorHelper",
	 "clazzes/widgets/layout/ContentWidget",
         "dijit/form/ComboBox",
         "dijit/form/Select",
	 "dojo/dom-class",
	 "dojo/dom-construct",
	 "dojo/dom-style",
	 "dojo/on",
	 "dojo/_base/declare",
	 "dojo/_base/lang",
	 "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
       function(ContextBar,
        CdesVoc,
		TinyLog,
                MultiWidget,
		DOMHelper,
		ErrorHelper,
		ContentWidget,
                ComboBox,
                Select,
		domClass,
		domConstruct,
		domStyle,
		on,
		declare,
		lang,
		i18n) {

    var className = "at.cdes.web.widget.project.ProjectParticipationMultiContentWidget";

    var log = new TinyLog(className);

    var ProjectParticipationMultiContentWidget = declare(className, ContentWidget, {

	constructor : function(params) {
	    lang.mixin(this, params);

	    this.topDiv = this.constructTopDiv();

	    this.changed = true;
	    this.allFieldsValid = true;
	},

	getWidgetId : function() {
	    return "ProjectParticipationMultiContentWidget";
	},

	getDataId : function() {
	    return null;
	},

	getContainer : function() {
	    return this.topDiv;
	},

	constructTopDiv : function() {
	    var topDiv = domConstruct.create("div", null, null);
	    domClass.add(topDiv, "refNodeOfPositionAbsolute participationMultiContentTopDiv");

	    var selectConstructorFct = lang.hitch(this, function() {
                var newOptions = [];
                if (this.options != null) {
                    for (var n = 0; n < this.options.length; n++) {
                        newOptions.push({
                            label : this.options[n].label,
                            orgPersonId : this.options[n].orgPersonId,
                            selected : this.options[n].selected,
                            value : this.options[n].value
                        });
                    }
                }


		return new Select({
		    label : i18n.planningNotificationReportSearchPositionPersonLabel,
		    title : i18n.planningNotificationReportSearchPositionPersonToolTip,
		   options : newOptions
		});
	    });

	    this.multiWidget = new MultiWidget({
			  addButtonLabel : i18n.projectParticipationMultiAddParticipationLabel,
		      addButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton",
		       addButtonCssClass : "participationMultiWidgetAddButton",
		       deleteButtonLabel : i18n.projectParticipationMultiRemoveParticipationLabel,
		   deleteButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton",
		      lineWidgetCssClass : "participationMultiSelectLineWidget",
		lineRemoveButtonCssClass : "multiWidgetLineRemoveButton",
			  constructorFct : selectConstructorFct,
		getterFct : function(widget) {
                    var selectedParticipantId = widget.get("value");
                    return selectedParticipantId;
                    /*
                    if (selectedParticipantId == "Whatever") {
                        return selectedParticipantId;
                    }
                    var options = widget.get("options");
                    for (var n = 0; options != null && n < options.length; n++) {
                        var option = options[n];
                        if (option.value == selectedParticipantId) {
                            return option.orgPersonId;
                        }
                    }
                    return null;
                    */
                },
		setterFct : function(widget, value) {
                    if (value == null) {
                       value = CdesVoc.WHATEVER
                    }
                    widget.set("value", value);


                    /*
                    if (value == "Whatever") {
                        widget.set("value", value);
                    } else {
                        var options = widget.get("options");
                        for (var n = 0; options != null && n < options.length; n++) {
                            var option = options[n];
                            if (option.orgPersonId == value) {
                                widget.set("value", option.value);
                                break;
                            }
                        }
                    }*/
                }
	    });
	    domClass.add(this.multiWidget.domNode, "fixedDialogWidget participationMultiContentMultiWidget");
	    domConstruct.place(this.multiWidget.domNode, topDiv);

	    return topDiv;
	},

	resize : function(newSize) {

	},

	setData : function(params) {
	    this.options = params.options;

	    var projectParticipationIds = params.projectParticipationIds;

	    var items = [];
	    for (var n = 0; n < projectParticipationIds.length; n++) {
		items.push({
			   id : n,
			value : projectParticipationIds[n],
		    removable : true
		});
	    }

	    this.multiWidget.set("value", items);
	},

	reload : function() {
	},

    save : function() {
	    var items = this.multiWidget.get("value");
	    var projectParticipationIds = [];
	    for (var n = 0; n < items.length; n++) {
			var projectParticipationId = items[n].value;
			projectParticipationIds.push(projectParticipationId);
	    }

	    on.emit(this, "participationsChosen", projectParticipationIds);
    },

	updateWidgetState : function() {

	},

	destroy : function() {
	    this.inherited(arguments);
	}
    });

    ProjectParticipationMultiContentWidget.AsyncOperation = {

    };

    return ProjectParticipationMultiContentWidget;
});
