/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/core/CdesVoc",
    "cdes/review/ReviewProtocolCrossCommentListWidget",
    "cdes/review/ReviewProtocolOebbCommentListWidget",
    "cdes/review/ReviewProtocolPositionListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
], function(
    CdesVoc,
    ReviewProtocolCrossCommentListWidget,
    ReviewProtocolOebbCommentListWidget,
    ReviewProtocolPositionListWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    topic,
    DOMHelper,
    ErrorHelper,
    ContentWidget,
    InfoDialog,
    domClass,
    domConstruct,
    domStyle,
    on,    
    string,
    declare,
    lang,
    i18n
) {

    var className = "at.cdes.review.ReviewProtocolNodeWidget";

    var log = new TinyLog(className);

    var ReviewProtocolNodeWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.widgets = [];
            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewProtocolNodeWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            return topDiv;
        },


        setData : function(params) {
            this.nodeResultJoin = params.nodeResultJoin;
            this.reviewContext = params.reviewContext;            
            this.reload();
        },

        reload : function() {
            domConstruct.empty(this.topDiv);
            for (var n = 0; this.widgets != null && n < this.widgets.length; n++) {
                this.widgets[n].destroy();
            }

            this.widgets = [];

            var nodeResultId = this.nodeResultJoin.reviewCycleNodeResultId;

            this.constructIntervalLine();
            this.constructPositionList();

            if (this.reviewContext.hasOebbComments(nodeResultId)) {
                this.constructOebbCommentList();
            }

            var crossCommentNodeResultJoins = this.getCrossCommentNodeResultJoins();
            if (crossCommentNodeResultJoins.length > 0) {
                this.constructCrossCommentList(crossCommentNodeResultJoins);
            }
        },

        constructIntervalLine : function() {
            var intervalLineDiv = domConstruct.create("div", null, null);
            domConstruct.place(intervalLineDiv, this.topDiv);

            var arrivalDate = this.nodeResultJoin.reviewCycleNodeResultArrivalDate;
            var departureDate = this.nodeResultJoin.reviewCycleNodeResultDepartureDate;

            var timeZone = this.applicationContext.getTimeZone();
            var formattedArrivalDate = arrivalDate != null ? DateHelper.formatUtcSecondsWithTimeZone(arrivalDate, timeZone, i18n.dateWithSecondsPattern) : arrivalDate;
            var formattedDepartureDate = departureDate != null
                ? DateHelper.formatUtcSecondsWithTimeZone(departureDate, timeZone, i18n.dateWithSecondsPattern) : departureDate;

            var arrivalDateString = string.substitute(i18n.reviewProtocolNodeArrivalDate, {
                arrivalDate : formattedArrivalDate != null ? formattedArrivalDate : "\u2015"
            });
            var departureDateString = string.substitute(i18n.reviewProtocolNodeDepartureDate, {
                departureDate : formattedDepartureDate != null ? formattedDepartureDate : "\u2015"
            });
            DOMHelper.createTextNode("span", arrivalDateString, intervalLineDiv, "reviewProtocolNodeArrivalLabel");
            DOMHelper.createTextNode("span", departureDateString, intervalLineDiv, "reviewProtocolNodeDepartureLabel");                        

            /* DO NOT USE THESE FUNCTIONS.  THEY ARE POTENTIALLY DANGEROUS!!!
            if (this.reviewContext.hasGlobalAction("superAdminRight")) {
                var deleteNodeResultButton = this.constructDeleteNodeResultButton();
                domConstruct.place(deleteNodeResultButton.domNode, intervalLineDiv);                

                if (this.nodeResultJoin.endNodeId == null) {
                    var moveToNextNodeButton = this.constructMoveToNextNodeButton();
                    domConstruct.place(moveToNextNodeButton.domNode, intervalLineDiv);                    
                }
                
                var generateMissingTasksButton = this.constructGenerateMissingTasksButton();
                domConstruct.place(generateMissingTasksButton.domNode, intervalLineDiv);                
            } */               


        },

        constructPositionList : function() {
            this.positionListWidget = new ReviewProtocolPositionListWidget({
                applicationContext : this.applicationContext
            });
            var positionListTopDiv = this.positionListWidget.getContainer();
            domConstruct.place(positionListTopDiv, this.topDiv);

            this.positionListWidget.setData({
                nodeResultJoin : this.nodeResultJoin,
                 reviewContext : this.reviewContext
            });                

            this.positionListWidget.restoreColumnWidths();
        },

        constructOebbCommentList : function() {
            this.oebbCommentListWidget = new ReviewProtocolOebbCommentListWidget({
                applicationContext : this.applicationContext
            });
            var oebbCommentTopDiv = this.oebbCommentListWidget.getContainer();
            domClass.add(oebbCommentTopDiv, "reviewProtocolNodeOebbCommentDiv");
            domConstruct.place(oebbCommentTopDiv, this.topDiv);

            this.oebbCommentListWidget.setData({
                nodeResultJoin : this.nodeResultJoin,
                 reviewContext : this.reviewContext
            });                            

            this.oebbCommentListWidget.restoreColumnWidths();
        },

        constructCrossCommentList : function(crossCommentNodeResultJoins) {
            this.crossCommentListWidget = new ReviewProtocolCrossCommentListWidget({
                applicationContext : this.applicationContext
            });
            var crossCommentTopDiv = this.crossCommentListWidget.getContainer();
            domClass.add(crossCommentTopDiv, "reviewProtocolNodeOebbCommentDiv");
            domConstruct.place(crossCommentTopDiv, this.topDiv);

            this.crossCommentListWidget.setData({
                             nodeResultJoin : this.nodeResultJoin,
                crossCommentNodeResultJoins : crossCommentNodeResultJoins,
                              reviewContext : this.reviewContext                
            });                            

            this.crossCommentListWidget.restoreColumnWidths();
        },

        getCrossCommentNodeResultJoins : function() {
            var crossCommentNodeResultJoins = [];
            if (log.isDebugEnabled()) {
                log.debug("Called getCrossCommentNodeResultJoins for nodeResultId = [" + this.nodeResultJoin.reviewCycleNodeResultId + "]");
            }                

            var cellResultId = this.nodeResultJoin.reviewCycleCellResultId;
            var nodeResultJoins = this.reviewContext.getNodeResultJoinsByCellResultId(cellResultId);
            nodeResultJoins.sort(function(joinOne, joinTwo) {
                var positionOne = joinOne.reviewCycleNodePosition != null ? joinOne.reviewCycleNodePosition : 0;
                var positionTwo = joinTwo.reviewCycleNodePosition != null ? joinTwo.reviewCycleNodePosition : 0;
                return positionOne - positionTwo;
            });

            if (log.isDebugEnabled()) {
                log.debug("CellResultId = [" + cellResultId + "], found [" + nodeResultJoins.length + "] corresponding nodeResultJoins");
            }                

            var allChosenPositionResultJoins = [];
            for (var n = 0; n < nodeResultJoins.length; n++) {
                var nodeResultJoin = nodeResultJoins[n];
                var nodeResultId = nodeResultJoin.reviewCycleNodeResultId;
                if (log.isDebugEnabled()) {
                    log.debug("... Inspecting nodeResultId = [" + nodeResultId + "]");
                }                    

                if (nodeResultJoin.reviewCycleNodeResultId == this.nodeResultJoin.reviewCycleNodeResultId) {
                    if (log.isDebugEnabled()) {
                        log.debug("... Breaking, since reviewCycleNodeResultIds are equal = [" + nodeResultJoin.reviewCycleNodeResultId + "]");
                    }                        
                    break;
                }
                if (nodeResultJoin.crossCommentNodeId == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("... Continuing, since crossCommentId is null");
                    }                        
                    continue;
                }

                var positionResultJoinsForBaseNodeResult = this.reviewContext.getPositionResultJoinsByNodeResultId(nodeResultJoin.reviewCycleNodeResultId);
                var idToBasePositionResultJoin = new Object();
                for (var u = 0; u < positionResultJoinsForBaseNodeResult.length; u++) {
                    var basePositionResultJoin = positionResultJoinsForBaseNodeResult[u];
                    idToBasePositionResultJoin[basePositionResultJoin.reviewCyclePositionResultId] = basePositionResultJoin;
                }                    

                var positionResultJoins = this.reviewContext.getPositionResultJoinsByNodeResultId(this.nodeResultJoin.reviewCycleNodeResultId);
                if (log.isDebugEnabled()) {
                    log.debug("... Found [" + positionResultJoins.length + "] position result joins");
                }                    
                
                var chooseThisNodeResult = false;
                var chosenPositionResultJoins = [];
                for (var z = 0; z < positionResultJoins.length; z++) {
                    var positionResultJoin = positionResultJoins[z];
                    var positionResultId = positionResultJoin.reviewCyclePositionResultId;
                    var digest = positionResultJoin.reviewCyclePositionResultDigest;
                    var comment = positionResultJoin.reviewCyclePositionResultComment;
                    var commentOptionId = positionResultJoin.reviewCyclePositionResultReviewCycleCommentOptionId;
                    var hasAttachments = this.reviewContext.hasPositionResultAttachments(positionResultId);

                    if (log.isDebugEnabled()) {
                        log.debug("...... Processing position result join [" + positionResultId + "] with "
                            + "(digest != null) [" + (digest != null) + "]; "
                            + "(comment filled) [" + (comment != null && comment.length > 0) + "]; "
                            + "(commentOptionId != null) [" + (commentOptionId != null) + "]; "
                            + "(hasAttachments) [" + hasAttachments + "]");                            
                    }                        

                    // Emulate the condition in at.cdes.db.daohibernate.ReviewCyclePositionResultDAOHibernate.getAll(ReviewCycleNodeResult, ReviewCycleNodeResult)
                    var commentReferenceId = positionResultJoin.reviewCyclePositionResultCommentReferenceId;
                    if (log.isDebugEnabled()) {
                        log.debug("...... commentReferenceId = [" + commentReferenceId + "]");
                    }                        

                    if (commentReferenceId in idToBasePositionResultJoin) {
                        chosenPositionResultJoins.push(positionResultJoin);
                        if (digest != null && ((comment != null && comment.length > 0) || commentOptionId != null || hasAttachments)) {
                            chooseThisNodeResult = true;
                        }                            
                    }
                }

                if (chooseThisNodeResult) {
                    chosenPositionResultJoins.sort(lang.hitch(this, function(joinOne, joinTwo) {
                        var idOne = joinOne.reviewCyclePositionResultId;
                        var commentReferenceIdOne = joinOne.reviewCyclePositionResultCommentReferenceId;
                        var oldPositionJoinOne = commentReferenceIdOne != null ? this.reviewContext.getPositionResultJoin(commentReferenceIdOne) : null;
                        var resultDateOne = oldPositionJoinOne != null && oldPositionJoinOne.reviewCyclePositionResultResultDate != null
                        ? oldPositionJoinOne.reviewCyclePositionResultResultDate : 0;

                        var idTwo = joinTwo.reviewCyclePositionResultId;
                        var commentReferenceIdTwo = joinTwo.reviewCyclePositionResultCommentReferenceId;
                        var oldPositionJoinTwo = commentReferenceIdTwo != null ? this.reviewContext.getPositionResultJoin(commentReferenceIdTwo) : null;
                        var resultDateTwo = oldPositionJoinTwo != null && oldPositionJoinTwo.reviewCyclePositionResultResultDate != null
                        ? oldPositionJoinTwo.reviewCyclePositionResultResultDate : 0;

                        if (log.isDebugEnabled) {
                            log.debug("Comparing for position results [" + idOne + "] vs. [" + idTwo + "]: Result dates ["
                                + resultDateOne + "] with resultDateTwo [" + resultDateTwo + "] for persons ["
                                + oldPositionJoinOne.positionMainPersonSurName + "] vs. [" + oldPositionJoinTwo.positionMainPersonSurName + "]");                            
                        }        

                        return resultDateOne - resultDateTwo;                        
                    }));
                    for (var j = 0; j < chosenPositionResultJoins.length; j++) {
                        allChosenPositionResultJoins.push(chosenPositionResultJoins[j]);
                    }                        
                }                    
            }                

            if (log.isDebugEnabled()) {
                log.debug("Returning [" + crossCommentNodeResultJoins.length + "] cross comment node result joins");
            }                

            var participantIdToJoins = new Object();
            for (var n = 0; n < allChosenPositionResultJoins.length; n++) {
                var join = allChosenPositionResultJoins[n];
                var participantId = join.reviewCyclePositionResultProjectParticipantId;
                if (!(participantId in participantIdToJoins)) {
                    participantIdToJoins[participantId] = [];
                }
                participantIdToJoins[participantId].push(join);                
            }                

            for (var participantId in participantIdToJoins) {
                var joins = participantIdToJoins[participantId];
                log.info("[" + joins.length + "] joins for participantId [" + participantId + "]");                
                var maxLatest = null;
                for (var z = 0; z < joins.length; z++) {
                    var join = joins[z];
                    log.info("resultDate [" + join.reviewCyclePositionResultResultDate + "] for position result [" + join.reviewCyclePositionResultId + "]");
                    if (maxLatest == null || (join.reviewCyclePositionResultResultDate != null && join.reviewCyclePositionResultResultDate > maxLatest)) {
                        maxLatest = join.reviewCyclePositionResultResultDate;
                    }
                }
                log.info("maxLatest = [" + maxLatest + "]");
                for (var z = 0; z < joins.length; z++) {
                    var join = joins[z];
                    join._striked = join.reviewCyclePositionResultResultDate < maxLatest;                    
                }                    
            }                

            return allChosenPositionResultJoins;
        },

        constructDeleteNodeResultButton : function() {
	    var button = new FancyButton({
		    title : i18n.reviewProtocolNodeDeleteNodeResultButtonToolTip,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
	    });

	    domClass.add(button.domNode, "listButton reviewProtocolNodeDeleteButton");

	    on(button, "click", lang.hitch(this, function() {
		InfoDialog.showQuestion({
		      title : i18n.reviewProtocolNodeDeletePositionResultDialogCaption,
		    message : i18n.reviewProtocolNodeDeletePositionResultDialogQuestion,
		    buttons : [
			{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                            this.doDeleteNodeResult();
			})},    			           
			{ type : InfoDialog.Button.NO }
		    ]
		}); 
	    }));

	    return button;            
        },

        doDeleteNodeResult : function() {
	    var documentService = this.applicationContext.getService("documentService");
	    this.registerAsyncOperationStarted(ReviewProtocolNodeWidget.AsyncOperation.DELETE_NODE_RESULT);

	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var nodeResultId = this.nodeResultJoin.reviewCycleNodeResultId;            
	    documentService.deleteNodeResult(organisationPersonId, nodeResultId).then(
		lang.hitch(this, function(result) {
		    this.registerAsyncOperationFinished(ReviewProtocolNodeWidget.AsyncOperation.DELETE_NODE_RESULT);

                    if (result) {
                        var message = string.substitute(i18n.reviewProtocolNodeDeleteNodeResultSuccessful, {
                            name : this.nodeResultJoinReviewCycleNodeName
                        });                        
                        
                        topic.publish("message/ok", message);
		        on.emit(this, "doLeave");
                    } else {
                        var errorMessage = string.substitute(i18n.reviewProtocolNodeDeleteNodeResultNotPossible, {
                            name : this.nodeResultJoinReviewCycleNodeName
                        });
                        topic.publish("message/error", errorMessage, true);                        
                    }                        
		}),
		lang.hitch(this, function(err) {
		    ErrorHelper.processAsyncError({
				   err : err,
				widget : this,
			asyncOperation : ReviewProtocolNodeWidget.AsyncOperation.DELETE_NODE_RESULT,
				opName : "deleteNodeResult",
			       message : i18n.reviewProtocolNodeDeleteNodeResultFailed
		    });
		})).otherwise(
		    lang.hitch(this, function(err) {
			log.error("Error while calling function [deleteNodeResult]", err);
		    }));            
        },

        constructMoveToNextNodeButton : function() {
	    var button = new FancyButton({
		    title : i18n.reviewProtocolNodeMoveToNextNodeButtonToolTip,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 moreIcon"
	    });

	    domClass.add(button.domNode, "listButton reviewProtocolNodeMoveToNextNodeButton");

	    on(button, "click", lang.hitch(this, function() {
		InfoDialog.showQuestion({
		      title : i18n.reviewProtocolNodeMoveToNextNodeDialogCaption,
		    message : i18n.reviewProtocolNodeMoveToNextNodeDialogQuestion,
		    buttons : [
			{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                            this.doMoveToNextNode();
			})},    			           
			{ type : InfoDialog.Button.NO }
		    ]
		}); 
	    }));

	    return button;            
        },

        doMoveToNextNode : function() {
	    var documentService = this.applicationContext.getService("documentService");
	    this.registerAsyncOperationStarted(ReviewProtocolNodeWidget.AsyncOperation.MOVE_TO_NEXT_NODE);

	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    documentService.moveNodeResultToNextNode(organisationPersonId, this.nodeResultJoin.reviewCycleNodeResultId).then(
		lang.hitch(this, function(result) {
		    this.registerAsyncOperationFinished(ReviewProtocolNodeWidget.AsyncOperation.MOVE_TO_NEXT_NODE);

                    if (result) {
                        var message = string.substitute(i18n.reviewProtocolNodeMoveToNextNodeSuccessful, {
                            name : this.reviewCycleNodeName
                        });                        
                        
                        topic.publish("message/ok", message);
		        on.emit(this, "doLeave");
                    } else {
                        var errorMessage = string.substitute(i18n.reviewProtocolNodeMoveToNextNodeNotPossible, {
                            name : this.reviewCycleNodeName
                        });
                        topic.publish("message/error", errorMessage, true);                        
                    }                        
		}),
		lang.hitch(this, function(err) {
		    ErrorHelper.processAsyncError({
				   err : err,
				widget : this,
			asyncOperation : ReviewProtocolNodeWidget.AsyncOperation.MOVE_TO_NEXT_NODE,
				opName : "moveNodeResultToNextNode",
			       message : i18n.reviewProtocolNodeMoveToNextNodeFailed
		    });
		})).otherwise(
		    lang.hitch(this, function(err) {
			log.error("Error while calling function [moveNodeResultToNextNode]", err);
		    }));            
        },

        constructGenerateMissingTasksButton : function() {
            var title;
            if (this.nodeResultJoin.endNodeId != null) {
                title = i18n.reviewProtocolNodeEndNodeGenerateMissingTasksToolTip;
            } else {
                title = i18n.reviewProtocolNodeGenerateMissingTasksToolTip;
            }                

	    var button = new FancyButton({
		    title : title,
		iconClass : "fancyButtonIcon17x18 fancyButton17x18 repairIcon"
	    });

	    domClass.add(button.domNode, "listButton reviewProtocolNodeGenerateMissingTasksButton");

	    on(button, "click", lang.hitch(this, function() {
		InfoDialog.showQuestion({
		      title : i18n.reviewProtocolNodeGenerateMissingTasksDialogCaption,
		    message : i18n.reviewProtocolNodeGenerateMissingTasksDialogQuestion,
		    buttons : [
			{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                            this.doGenerateMissingTasks();
			})},    			           
			{ type : InfoDialog.Button.NO }
		    ]
		}); 
	    }));

	    return button;            
        },

        doGenerateMissingTasks : function() {
	    var documentService = this.applicationContext.getService("documentService");
	    this.registerAsyncOperationStarted(ReviewProtocolNodeWidget.AsyncOperation.GENERATE_MISSING_TASKS);

	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    documentService.insertCreateMissingTasks(organisationPersonId, this.nodeResultJoin.reviewCycleNodeResultId).then(
		lang.hitch(this, function(result) {
		    this.registerAsyncOperationFinished(ReviewProtocolNodeWidget.AsyncOperation.GENERATE_MISSING_TASKS);

                    if (result) {
                        var message = string.substitute(i18n.reviewProtocolNodeGenerateMissingTasksSuccessful, {
                            name : this.nodeResultJoin.reviewCycleNodeName
                        });                        
                        
                        topic.publish("message/ok", message);
		        on.emit(this, "doLeave");
                    } else {
                        var errorMessage = string.substitute(i18n.reviewProtocolNodeGenerateMissingTasksNotPossible, {
                            name : this.nodeResultJoin.reviewCycleNodeName
                        });
                        topic.publish("message/error", errorMessage, true);                        
                    }                        
		}),
		lang.hitch(this, function(err) {
		    ErrorHelper.processAsyncError({
				   err : err,
				widget : this,
			asyncOperation : ReviewProtocolNodeWidget.AsyncOperation.GENERATE_MISSING_TASKS,
				opName : "insertCreateMissingTasks",
			       message : i18n.reviewProtocolNodeGenerateMissingTasksFailed
		    });
		})).otherwise(
		    lang.hitch(this, function(err) {
			log.error("Error while calling function [insertCreateMissingTasks]", err);
		    }));            
        },

        updateWidgetState : function() {

        },

        resize : function(newSize) {
            this.positionListWidget.resize({ w : newSize.w });
            if (this.oebbCommentListWidget != null) {
                this.oebbCommentListWidget.resize({ w : newSize.w });
            }
            if (this.crossCommentListWidget != null) {
                this.crossCommentListWidget.resize({ w : newSize.w });
            }                
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    ReviewProtocolNodeWidget.AsyncOperation = {
    };        

    return ReviewProtocolNodeWidget;
});
