/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
        "cdes/util/I18nHelper",
        "cdes/util/NameHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/util/DOMHelper",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
    "dojo/string"
], function(
            I18nHelper,
            NameHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    DOMHelper,
    domClass,
    domConstruct,
    domStyle,
    ioQuery,
    on,    
    declare,
    lang,
    i18n,
    string
) {

    var className = "at.cdes.review.ReviewProtocolPositionListWidget";

    var log = new TinyLog(className);

    var ReviewProtocolPositionListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewProtocolPositionListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "reviewProtocolPositionList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

	    columns.push({
		     field : "_reviewer",
			id : "reviewer",
                renderCell : lang.hitch(this, this.renderReviewer),
		  sortable : true,
		    label : i18n.reviewProtocolPositionReviewerCaption
	    });

	    columns.push({
		     field : "_realm",
			id : "realm",
                renderCell : lang.hitch(this, this.renderRealm),
		  sortable : true,
		    label : i18n.reviewProtocolPositionRealmCaption
	    });

	    columns.push({
		    field : "_reviewDate",
		       id : "reviewDate",
                formatter : lang.hitch(this, this.formatReviewDate),
		 sortable : true,
		    label : i18n.reviewProtocolPositionDateCaption
	    });

	    columns.push({
		     field : "_review",
			id : "review",
                renderCell : lang.hitch(this, this.renderReview),
		  sortable : true,
		     label : i18n.reviewProtocolPositionReviewCaption
	    });

	    columns.push({
		     field : "_result",
		        id : "result",
                renderCell : lang.hitch(this, this.renderResult),                
		  sortable : true,
		     label : i18n.reviewProtocolPositionResultCaption
	    });

            return columns;            
        },

        getPositionPersonWithOrganisationString : function(positionJoin) {
            var organisationName = positionJoin.positionOrganisationName;
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionPerson");
            var result = string.substitute(i18n.organisationCommonName, {
                organisationName : organisationName,
                personCommonName : personCommonName                
            });
            return result;
        },            

        getPositionMainPersonWithOrganisationDebString : function(positionJoin) {
            var organisationName = positionJoin.positionMainOrganisationName;
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionMainPerson");
            var result = string.substitute(i18n.deputyPersonWithOrganisation, {
                person : personCommonName,
                organisation : organisationName                
            });
            return result;            
        },

        getPositionMainPersonDebString : function(positionJoin) {
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionMainPerson");
            var result = string.substitute(i18n.deputyPerson, {
                      person : personCommonName
            });
            return result;
        },            

        getPositionMainPersonWithOrganisationString : function(positionJoin) {
            var organisationName = positionJoin.positionMainOrganisationName;
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionMainPerson");
            var result = string.substitute(i18n.organisationCommonName, {
                organisationName : organisationName,
                personCommonName : personCommonName                
            });
            return result;
        },            

        renderReviewer : function(positionJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);

            var baseJoin = this.reviewContext.getBaseJoin();
            if (this.isPositionResultJoin(positionJoin)) {
                DOMHelper.createTextNode("div", this.getPositionPersonWithOrganisationString(positionJoin), cellDiv);
              //signed review
                if (positionJoin.reviewCyclePositionResultSignatureId != null && (!positionJoin.positionParticipantMainParticipantFlag || positionJoin.positionParticipantInactiveFlag)) {
                	
                    if (positionJoin.positionOrganisationId != positionJoin.positionMainOrganisationId) {
                        DOMHelper.createTextNode("div", this.getPositionMainPersonWithOrganisationDebString(positionJoin), cellDiv, "reviewProtocolPositionDeputy");
                    } else if (positionJoin.positionPersonId != positionJoin.positionMainPersonId) {
                        DOMHelper.createTextNode("div", this.getPositionMainPersonDebString(positionJoin), cellDiv, "reviewProtocolPositionDeputy");
                    }
                    //                
                }
                if (positionJoin.attachedPositionResultId != null) {
                    DOMHelper.createTextNode("div", i18n.reviewProtocolPositionAttachedReviewLabel, cellDiv, "reviewProtocolPositionAttachedReviewLabel");
                } else if (baseJoin.subProjectWithAdditionalRoleTypes && positionJoin.reviewCycleNodeRoleTypeId != positionJoin.positionRoleTypeId) {
                    DOMHelper.createTextNode("div", "[" + positionJoin.positionRoleName + "]", cellDiv, "reviewProtocolPositionAdditionalRoleTypeLabel");
                }                        
            } else {
                DOMHelper.createTextNode("div", this.getPositionMainPersonWithOrganisationString(positionJoin), cellDiv);
                if (positionJoin.attachedNodePositionId != null) {
                    DOMHelper.createTextNode("div", i18n.reviewProtocolPositionAttachedPositionLabel, cellDiv, "reviewProtocolPositionAttachedPositionLabel");
                } else if (baseJoin.subProjectWithAdditionalRoleTypes && positionJoin.roleTypeId != positionJoin.positionRoleTypeId) {
                    DOMHelper.createTextNode("div", "[" + positionJoin.positionRoleName + "]", cellDiv, "reviewProtocolPositionAdditionalRoleTypeLabel");
                }                    
            }                

            return cellDiv;
        },

        renderRealm : function(positionJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            if (positionJoin.realmCode != null) {
                DOMHelper.createTextNode("span", positionJoin.realmCode, cellDiv, "reviewProtocolPositionRealmCodeLabel");
            }
            if (positionJoin.realmName != null) {
                var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                var realmName = I18nHelper.getCurrentLocaleString(positionJoin.realmName, locale);                
                DOMHelper.createTextNode("span", realmName, cellDiv, "reviewProtocolPositionRealmNameLabel");
            }                
            return cellDiv;            
        },

        formatReviewDate : function(date, positionJoin) {
            if (this.isPositionResultJoin(positionJoin) && positionJoin.reviewCyclePositionResultSignatureId != null) {
                var resultDate = positionJoin.reviewCyclePositionResultResultDate;
    	        if (resultDate != null) {
    		    return DateHelper.formatUtcSecondsWithTimeZone(resultDate, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern); 
    	        } else {
    		    return "";
    	        }
            } else {
                return "";
            }                
        },

        renderReview : function(positionJoin, data, cell) {
            var cellTable = domConstruct.create("table", null, null);
            var row = domConstruct.create("tr", null, cellTable);

            if (positionJoin.reviewCyclePositionResultSignatureId != null) {
                var resultOptionId = positionJoin.reviewCycleNodeResultReviewCycleResultOptionId;
                var resultOption = resultOptionId != null ? this.reviewContext.getResultOption(resultOptionId) : null;

                var commentCell = domConstruct.create("td", null, row);
                if (resultOption != null && resultOption.value == -7) {
                    DOMHelper.createTextNode("div", i18n.reviewProtocolPositionNotReviewedLabel, commentCell, "reviewProtocolPositionNotReviewedLabel");
                }
                if (positionJoin.positionOverridingPersonId != null) {
                    var overridingPersonCommonName = NameHelper.getPersonCommonName(positionJoin, "positionOverridingPerson");
                    var overridingLabel = string.substitute(i18n.reviewProtocolPositionOverridingLabel, {
                        personCommonName : overridingPersonCommonName
                    });                        
                    DOMHelper.createTextNode("div", overridingLabel, commentCell, "reviewProtocolPositionOverridingPersonLabel");
                }

                var comment = positionJoin.reviewCyclePositionResultComment;
                if (comment != null) {
                    // Safe html thanks to server side
	            	var node = domConstruct.create("div", { innerHTML : comment });
                    domClass.add(node, "reviewProtocolPositionComment");                    
                    domConstruct.place(node, commentCell);                
//                    DOMHelper.createTextNode("div", comment, commentCell, "reviewProtocolPositionComment");
                }                

                var positionResultId = positionJoin.reviewCyclePositionResultId;
                var attachments = this.reviewContext.getPositionResultAttachments(positionResultId);
                var attachmentCell = domConstruct.create("td", null, row);
                for (var n = 0; n < attachments.length; n++) {
                    var attachment = attachments[n];
                    var attachmentButton = ReviewProtocolPositionListWidget.constructAttachmentButton({
                                attachment : attachment,
                         documentVersionId : positionJoin.documentVersionId,
                        applicationContext : this.applicationContext
                    });                        
                    domConstruct.place(attachmentButton.domNode, attachmentCell);                    
                }                    
            }            

            return cellTable;
        },

        renderResult : function(positionJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            var resultOptionId = positionJoin.reviewCyclePositionResultReviewCycleResultOptionId;
            var resultOption = resultOptionId != null ? this.reviewContext.getResultOption(resultOptionId) : null;            
            if (resultOption != null && resultOption.value == 0) {
                domClass.add(cell, "reviewProtocolNegativeReview");
            }                

            if (positionJoin.reviewCyclePositionResultSignatureId != null && resultOption != null && resultOption.name != null) {
                var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                var resultOptionName = I18nHelper.getCurrentLocaleString(resultOption.name, locale);
                DOMHelper.createTextNode("span", resultOptionName, cellDiv, "reviewProtocolPositionResultOptionName");
            }
            return cellDiv;            
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

	    var grid = this.constructGrid({
		idProperty : "_id", 
		    gridId : "ReviewProtocolPositionGrid",
                 gridClass : "Grid"
	    });
            /*            
	    on(grid, "dgrid-sort", lang.hitch(this, function(e) {
		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		var networkId = this.applicationContext.getPageContextPnNetworkId();
		this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", e.sort);
	    }));
            */
            domConstruct.place(grid, topDiv);

            this.noEntriesLabel = DOMHelper.createTextNode("div", i18n.reviewProtocolNoPositionsLabel, topDiv, "hidden");

            return topDiv;
        },

        setData : function(params) {
            this.nodeResultJoin = params.nodeResultJoin;
            this.reviewContext = params.reviewContext;

            this.reload();
        },

        reload : function() {
            var nodeResultId = this.nodeResultJoin.reviewCycleNodeResultId;
            var nodeId = this.nodeResultJoin.reviewCycleNodeId;
            var candidates = this.reviewContext.getPositionResultJoinsByNodeResultId(nodeResultId);
            this.positionResultJoins = [];
            this.positionJoins = [];
            for (var n = 0; n < candidates.length; n++) {
                var candidate = candidates[n];
                var signatureId = candidate.reviewCyclePositionResultSignatureId;
                var resultOptionId = candidate.reviewCyclePositionResultReviewCycleResultOptionId;
                var resultOption = resultOptionId != null ? this.reviewContext.getResultOption(resultOptionId) : null;

                if (signatureId != null && resultOption != null && resultOption.value > -9) {
                    // Two different arrays, because the former is used in the addRelevantPositionJoins function - and may not be altered by that function
                    this.positionResultJoins.push(candidate);                    
                    this.positionJoins.push(candidate);
                }
            }

            //get open positions but ignore free nodes
            if (!this.nodeResultJoin.reviewCycleNodeFree){
                var documentVersionId = this.nodeResultJoin.documentVersionId;
                //add non done positions
                var nodePositionJoins = this.reviewContext.getNodePositionJoins(documentVersionId);
                this.addRelevantPositionJoins(nodePositionJoins, false);
                //add non done attached positions
                var attachedNodePositionJoins = this.reviewContext.getAttachedNodePositionJoins(documentVersionId);
                this.addRelevantPositionJoins(attachedNodePositionJoins, true);
            }

            if (this.positionJoins.length > 0) {
                domClass.remove(this.grid.domNode, "hidden");
                domClass.add(this.noEntriesLabel, "hidden");               
            } else {
                domClass.add(this.grid.domNode, "hidden");
                domClass.remove(this.noEntriesLabel, "hidden");
            }                

            this.updateAuxiliaryData();
            this.setStoreData(this.positionJoins);
            this.grid.resize();
        },

        isPositionResultJoin : function(positionJoin) {
            return positionJoin.reviewCyclePositionResultId != null;
        },

        addRelevantPositionJoins : function(nodePositionJoins, attachedNodePositions) {
            // summary:
            //      Implements the decisions from at.cdes.tapestry.pages.review.ReviewProtocoll.fillPositionResults() which
            //      are not part of the join, i.e. the comparison against the node result node, and against position result
            //      realm and participation. Adds all instances that pass that conditions to the this.positionJoins array.
            // nodePositionJoins:
            //      Either the results for join component NODE_POSITIONS, or for join component ATTACHED_NODE_POSITIONS            
            var nodeResultNodeId = this.nodeResultJoin.reviewCycleNodeId;
            var positionTypeId = this.nodeResultJoin.reviewCycleNodeReviewCyclePositionTypeId;
            var nodeResultForEndNode = !this.reviewContext.hasResultOptionWithPositionTypeId(positionTypeId);            

            for (var n = 0; n < nodePositionJoins.length; n++) {
                var nodePositionJoin = nodePositionJoins[n];
                var nodePositionNodeId = nodePositionJoin.reviewCycleNodeId;
                var nodePositionRealmId = attachedNodePositions?nodePositionJoin.attachedNodePositionRealmId:nodePositionJoin.nodePositionRealmId;
                var nodePositionParticipationId = attachedNodePositions?nodePositionJoin.attachedNodePositionProjectParticipationId:nodePositionJoin.nodePositionProjectParticipationId;

                // we have to consider only the positions of the current nodeResult's node 
                if (!nodeResultForEndNode && nodePositionNodeId == nodeResultNodeId) {
                    var positionResultFound = false;
                    for (var z = 0; z < this.positionResultJoins.length; z++) {
                        var positionResultJoin = this.positionResultJoins[z];
                        var positionResultRealmId = positionResultJoin.reviewCyclePositionResultRealmId;
                        var positionResultParticipationId = positionResultJoin.positionParticipantParticipationId;
                        //find already signed positions by realm and ParticipationId
                        positionResultFound |= (nodePositionRealmId == positionResultRealmId && nodePositionParticipationId == positionResultParticipationId);
                    }                        

                    if (!positionResultFound) {
                        this.positionJoins.push(nodePositionJoin);
                    }                        
                }                    
            }                
        },            

	updateAuxiliaryData : function() {
            for (var n = 0; n < this.positionJoins.length; n++) {
                var positionJoin = this.positionJoins[n];
                var baseJoin = this.reviewContext.getBaseJoin();
                positionJoin._reviewer = "";
                if (this.isPositionResultJoin(positionJoin)) {
                    positionJoin._reviewer += this.getPositionPersonWithOrganisationString(positionJoin);
                    if (positionJoin.reviewCyclePositionResultSignatureId != null && (!positionJoin.positionParticipantMainParticipantFlag || positionJoin.positionParticipantInactiveFlag)) {
                        if (positionJoin.positionOrganisationId != positionJoin.positionMainOrganisationId) {
                            positionJoin._reviewer += this.getPositionMainPersonWithOrganisationDebString(positionJoin);
                        } else if (positionJoin.positionPersonId != positionJoin.positionMainPersonId) {
                            positionJoin._reviewer += this.getPositionMainPersonDebString(positionJoin);
                        }
                        if (positionJoin.attachedPositionResultId != null) {
                            positionJoin._reviewer += i18n.reviewProtocolPositionAttachedReviewLabel;
                        } else if (baseJoin.subProjectWithAdditionalRoleTypes && positionJoin.reviewCycleNodeRoleTypeId != positionJoin.positionRoleTypeId) {
                            positionJoin._reviewer += "[" + positionJoin.positionRoleName + "]";
                        }                        
                    }                        
                } else {
                    positionJoin._reviewer += this.getPositionMainPersonWithOrganisationString(positionJoin);
                    if (positionJoin.attachedNodePositionId != null) {
                        positionJoin._reviewer += i18n.reviewProtocolPositionAttachedPositionLabel;
                    } else if (baseJoin.subProjectWithAdditionalRoleTypes && positionJoin.roleTypeId != positionJoin.positionRoleTypeId) {
                        positionJoin._reviewer += "[" + positionJoin.positionRoleName + "]";
                    }                    
                }                    

                positionJoin._realm = "";
                if (positionJoin.realmCode != null) {
                    positionJoin._realm += positionJoin.realmCode;
                }                    
                if (positionJoin.realmName != null) {
                    positionJoin._realm += positionJoin.realmName;
                }                    

                positionJoin._reviewDate = this.formatReviewDate(null, positionJoin);

                positionJoin._review = "";
                var resultOptionId = positionJoin.reviewCyclePositionResultReviewCycleResultOptionId;
                var resultOption = resultOptionId != null ? this.reviewContext.getResultOption(resultOptionId) : null;            
                if (positionJoin.reviewCyclePositionResultSignatureId != null) {
                    if (resultOption != null && resultOption.value == -7) {
                        positionJoin._review += i18n.reviewProtocolPositionNotReviewedLabel;
                    }
                    if (positionJoin.positionOverridingPersonId != null) {
                        var overridingPersonCommonName = NameHelper.getPersonCommonName(positionJoin, "positionOverridingPerson");
                        var overridingLabel = string.substitute(i18n.reviewProtocolPositionOverridingLabel, {
                            personCommonName : overridingPersonCommonName
                        });                        
                        positionJoin._review += overridingLabel;
                    }

                    var comment = positionJoin.reviewCyclePositionResultComment;
                    positionJoin._review += comment != null ? comment : "";                    
                }            

                positionJoin._result = "";
                if (positionJoin.reviewCyclePositionResultSignatureId != null && resultOption != null && resultOption.name != null) {
                    positionJoin._result = resultOption.name;
                }                    
            }                
	},

        updateWidgetState : function() {

        },

        resize : function(newSize) {
            // We need to perform the resize in two steps.
            // First set the desired width, and some arbitrary height.
            var width = newSize.w + 0.01;
            var height = this.getActualHeight();
            this.grid.resize({ w : width, h : height });
        },

        destroy : function() {
            this.inherited(arguments);
            this.grid.destroy();
        }
    });

    ReviewProtocolPositionListWidget.constructAttachmentButton = function(params) {
        var attachment = params.attachment;
        var documentVersionId = params.documentVersionId;
        var applicationContext = params.applicationContext;        
        
        var title;
        var iconClass;
        log.info("Attachment [" + attachment.id + "]");        

        if (attachment.isRedliningDelta) {
            title = i18n.reviewProtocolPositionOpenGraphicalReview;
            iconClass = "previewPdfButton";                
        } else {
            title = string.substitute(i18n.reviewProtocolPositionOpenFile, {
                fileName : attachment.originalName
            });
            iconClass = "attachmentIcon";                
        }          

	var button = new FancyButton({
		title : title,
	    iconClass : "fancyButtonIcon17x18 fancyButton17x18 " + iconClass
	});

	domClass.add(button.domNode, "listButton reviewProtocolPositionAttachmentButton");

	on(button, "click", lang.hitch(this, function() {
            if (attachment.isRedliningDelta) {
                // http://localhost:8081/cdes/app?service=CDESMimeService/6/documentVersionReviewProtocolPdfMimeSource&sp=3838910&ts=Admin
		var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
                var paramString = ioQuery.objectToQuery({
                    service : "CDESMimeService/6/documentVersionReviewProtocolPdfMimeSource",                
                         sp : documentVersionId,
                         ts : dojoConfig.tabSessionId              
                });
		window.open("/cdes/app?" + paramString);
            } else {
                // http://localhost:8081/cdes/app?service=SecureDirectService/1/DocumentList/reviewProtocoll/$SecureDirectLink$4&sp=4815387&ts=Admin#
		var organisationPersonId = applicationContext.getPageContextOrganisationPersonId();
		window.open("/cdes-dojo-impl/repositoryDownload/attachments/" + organisationPersonId + "/" + attachment.id);
            }                
	}));



// javascript:reqAjaxDLwInit("dvPDF1",
//        "/cdes/app?service=CDESMimeService/6/documentVersionPdfMimeSource&sp=3838910&ts=Admin",
//        "/cdes/app?service=CDESMimeService/5/documentVersionPdfMimeSource&sp=3838910&ts=Admin",
//        "dvPDF_img1","/cdes/images/aktionen/bitte_warten.gif","/cdes/images/aktionen/planvorschau_pdf.gif","/cdes/images/error_small.png");
        
/*
<span jwcid="@contrib:When" condition="ognl:attachment.redliningDelta">
   <a jwcid="redliningLink"><img jwcid="@Image" image="ognl:assets.pdf" title="ognl:i18n.tr('Grafische Planprüfung öffnen')"/></a>
</span>
<span jwcid="@contrib:Otherwise">
   <a jwcid="attachmentLink"><img jwcid="@Image" image="ognl:assets.attachment" title="ognl:i18n.tr('Dateianhang öffnen')+': '+attachment.originalName"/></a>
</span>
*/

	return button;            
    };


    ReviewProtocolPositionListWidget.AsyncOperation = {
        DELETE : "Delete"
    };        

    return ReviewProtocolPositionListWidget;
});
