/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/core/CdesVoc",
    "cdes/review/ReviewProtocolInvalidationListWidget",
    "cdes/review/ReviewProtocolNodeWidget",
    "cdes/review/ReviewProtocolResultListWidget",
    "cdes/util/CodeHelper",
        "cdes/util/I18nHelper",
        "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
], function(
    CdesVoc,
    ReviewProtocolInvalidationListWidget,
    ReviewProtocolNodeWidget,
    ReviewProtocolResultListWidget,
    CodeHelper,
            I18nHelper,
            TinyLog,
    DOMHelper,
    ContentWidget,
    domClass,
    domConstruct,
    domStyle,
    on,    
    declare,
    lang,
    i18n,
    string
) {

    var className = "at.cdes.review.ReviewProtocolVersionWidget";

    var log = new TinyLog(className);

    var ReviewProtocolVersionWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.widgets = [];
            this.topDiv = this.constructTopDiv();

            // Compare Mail to Michael, 2018-01-16.
            this.showAll = true;

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewProtocolVersionWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            return topDiv;
        },


        setData : function(params) {
            this.versionJoin = params.versionJoin;
            this.reviewContext = params.context;            
            this.reload();
        },

        reload : function() {
            domConstruct.empty(this.topDiv);
            for (var n = 0; this.widgets != null && n < this.widgets.length; n++) {
                this.widgets[n].destroy();
            }

            this.widgets = [];
            
            var statementResultJoins = this.reviewContext.getStatementResultJoins(this.versionJoin.documentVersionId);
            if (statementResultJoins.length > 0) {
                var resultListWidget = new ReviewProtocolResultListWidget({
                    applicationContext : this.applicationContext
                });
                var resultSectionDiv = this.constructSectionDiv({
                    caption : i18n.reviewProtocolVersionResultCaption,
                     widget : resultListWidget                    
                });
                domConstruct.place(resultSectionDiv, this.topDiv);
                resultListWidget.setData({
                      resultJoins : statementResultJoins,
                    reviewContext : this.reviewContext
                });

                this.widgets.push(resultListWidget);

                resultListWidget.restoreColumnWidths();
            }            

            var invalidationResultJoins = this.getInvalidationResultJoins();            
            if (this.isInvalidated(invalidationResultJoins)) {
                var invalidationWidget = new ReviewProtocolInvalidationListWidget({
                    applicationContext : this.applicationContext
                });
                var sectionDiv = this.constructSectionDiv({
                    caption : this.getInvalidationCaption(),
                     widget : invalidationWidget
                });                    
                domConstruct.place(sectionDiv, this.topDiv);
                invalidationWidget.setData({
                              reviewContext : this.reviewContext,
                    invalidationResultJoins : invalidationResultJoins
                });                    

                this.widgets.push(invalidationWidget);                

                invalidationWidget.restoreColumnWidths();
            }                

            var nodeResultJoins = this.reviewContext.getNodeResultJoinsByDocumentVersionId(this.versionJoin.documentVersionId);
            for (var z = 0; z < nodeResultJoins.length; z++) {
                var nodeResultJoin = nodeResultJoins[z];
                if (this.showNodeResult(nodeResultJoin)) {
                    var nodeWidget = new ReviewProtocolNodeWidget({
                        applicationContext : this.applicationContext
                    });
                    
                    var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                    var reviewCycleNodeName = I18nHelper.getCurrentLocaleString(nodeResultJoin.reviewCycleNodeName, locale);

                    var nodeSectionDiv = this.constructSectionDiv({
                        caption : reviewCycleNodeName,
                         widget : nodeWidget
                    });
                    domConstruct.place(nodeSectionDiv, this.topDiv);
                    nodeWidget.setData({
                         reviewContext : this.reviewContext,
                        nodeResultJoin : nodeResultJoin                        
                    });

                    this.widgets.push(nodeWidget);                    
                }                    
            }                                
        },

        updateWidgetState : function() {

        },

        resize : function(newSize) {
            for (var n = 0; n < this.widgets.length; n++) {
                // Width is passed from outside; height is decided by the inner widgets according to their space requirements
                this.widgets[n].resize({
                    w : newSize.w
                });                    
            }                
        },

        constructSectionDiv : function(params) {
            var caption = params.caption;
            var widget = params.widget;

            var sectionDiv = domConstruct.create("div", null, null);
            domClass.add(sectionDiv, "reviewProtocolSectionDiv");
            DOMHelper.createTextNode("h3", caption, sectionDiv, "reviewProtocolVersionSectionCaption");

            var containerTopDiv = widget.getContainer();
            domConstruct.place(containerTopDiv, sectionDiv);

            return sectionDiv;            
        },

        getCellResultIds : function() {
            var documentVersionId = this.versionJoin.documentVersionId;
            var cellResultIds = documentVersionId in this.documentVersionIdToCellResultIds ? this.documentVersionIdToCellResultIds[documentVersionId] : [];
            return cellResultIds;
        },

        getInvalidationResultJoins : function() {
            var invalidationResultJoins = [];            
            var documentVersionId = this.versionJoin.documentVersionId;
            var positionResultJoins = this.reviewContext.getPositionResultJoinsByDocumentVersionId(documentVersionId);
            for (var n = 0; n < positionResultJoins.length; n++) {
                var positionResultJoin = positionResultJoins[n];
                var resultOptionId = positionResultJoin.reviewCyclePositionResultReviewCycleResultOptionId;
                if (resultOptionId != null) {                    
                    var resultOption = this.reviewContext.getResultOption(resultOptionId);
                    if (resultOption.value < -8) {
                        invalidationResultJoins.push(positionResultJoin);
                    }                            
                }     
            }                
            return invalidationResultJoins;
        },

        isInvalidated : function(invalidationResults) {
            var documentVersionStatus = this.versionJoin.documentVersionStatus;

            return (documentVersionStatus == CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
                 || documentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDALL
                 || documentVersionStatus != CdesVoc.DocumentVersionStatus.DELETED
                 || documentVersionStatus != CdesVoc.DocumentVersionStatus.REPLACED
                 ||  documentVersionStatus != CdesVoc.DocumentVersionStatus.ABORTED
                 || this.reviewContext.doShowAll()) && invalidationResults.length > 0;
        },

        getInvalidationCaption : function() {
            var documentVersionStatus = this.versionJoin.documentVersionStatus;
            if (documentVersionStatus == CdesVoc.DocumentVersionStatus.DELETED) {
                return i18n.reviewProtocolVersionDocumentDeletedCaption;
            } else if (documentVersionStatus == CdesVoc.DocumentVersionStatus.ABORTED) {
                return i18n.reviewProtocolVersionReviewAbortedCaption;
            } else {
                return i18n.reviewProtocolVersionInvalidDocumentCaption;
            }                
        },

/*
    <component id="showThisNode" type="Conditional">
        <binding name="condition" expression="
        		( 
        			nodeResult.reviewCycleResultOption != null 
        			&amp;&amp; nodeResult.reviewCycleResultOption.value != -8 
    			) || (
        			nodeResult.reviewCycleResultOption == null
        			&amp;&amp; nodeResult.reviewCycleNode.id == documentVersionReviewCycleNodeId
    			 	&amp;&amp; documentVersion.inAction &amp;&amp; !documentVersion.deleted
        			&amp;&amp; documentVersion.lastDocumentVersion
    			) || (
        			nodeResult.reviewCycleResultOption == null
        			&amp;&amp; !documentVersion.lastDocumentVersion
    			)
        		  || nodeResult.reviewCycleNode.isFree()
        		  || showAll"/>
	</component>
*/
// nodeResultId 184935
// reviewCycleResultOption = null
// reviewCycleNode 17675 = documentVersionReviewCycleNodeId
// documentVersion 184733; status = INREVIEW = 1
// es ex. genau eine version zu documentId = 21717, d.h. 184733        
        

        showNodeResult : function(nodeResultJoin) {
            var resultOptionId = nodeResultJoin.reviewCycleNodeResultReviewCycleResultOptionId;

            var nodeResultReviewCycleNodeId = nodeResultJoin.reviewCycleNodeId;
            var documentVersionId = nodeResultJoin.documentVersionId;
            var versionJoin = this.reviewContext.getVersionJoin(documentVersionId);
            var versionReviewCycleNodeId = versionJoin.reviewCycleNodeId;
            var equalNodeIds = nodeResultReviewCycleNodeId == versionReviewCycleNodeId;
            
            var documentVersionStatus = versionJoin.documentVersionStatus;
            var documentVersionIsInAction = CodeHelper.isDocumentVersionStatusInAction(documentVersionStatus);
            var documentVersionIsDeleted = documentVersionStatus == CdesVoc.DocumentVersionStatus.DELETED;
            var isLastVersion = this.reviewContext.isLastVersion(documentVersionId);

            return (resultOptionId != null && this.reviewContext.getResultOption(resultOptionId).value != -8)
            || (resultOptionId == null && equalNodeIds && documentVersionIsInAction && !documentVersionIsDeleted && isLastVersion)
            || (resultOptionId == null && !isLastVersion)
            || nodeResultJoin.reviewCycleNodeFree
            || this.reviewContext.doShowAll();
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    ReviewProtocolVersionWidget.AsyncOperation = {
    };        

    return ReviewProtocolVersionWidget;
});
