/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = requestOriginal
////i18n-prefix = requestOriginal

define([ 
    "cdes/widget/ContextBar",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Button",
    "dijit/form/RadioButton",
    "dijit/form/SimpleTextarea",
    "dijit/form/TextBox",    
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    ContextBar,
    ListWidget,
    TinyLog,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    Button,
    RadioButton,
    Textarea,
    TextBox,
    domClass,
    domConstruct,
    domStyle,
    string,    
    declare,
    lang,
    i18n
) {

    var className = "at.cdes.web.document.RequestOriginalDocumentPage";

    var log = new TinyLog(className);

    var RequestOriginalDocumentPage = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;

            var projectId = this.applicationContext.getPageContextProjectId();
    	    this.registerAsyncOperationStarted(RequestOriginalDocumentPage.AsyncOperation.LOAD);

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    	    var documentService = this.applicationContext.getService("documentService");
            documentService.getRequestOriginalDocumentData(organisationPersonId, this.documentVersionId, projectId).then(
                lang.hitch(this, function(requestOriginalDocumentData) {
		    this.registerAsyncOperationFinished(RequestOriginalDocumentPage.AsyncOperation.LOAD);
                    this.initialize(requestOriginalDocumentData);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : RequestOriginalDocumentPage.AsyncOperation.LOAD,
                                opName : "getRequestOriginalDocumentData",
                               message : i18n.requestOriginalDocumentGetDataFailed
                    });
                })
            ).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Error while calling function [getRequestOriginalDocumentData]", err);
                }));
            
        },

        getWidgetId : function() {
            return "RequestOriginalDocumentPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        initialize : function(requestOriginalDocumentData) {
            this.documentVersion = requestOriginalDocumentData.documentVersion;
            this.organisations = requestOriginalDocumentData.organisations;

            this.organisations.sort(function(organisationOne, organisationTwo) {
                return organisationOne.name.localeCompare(organisationTwo.name);
            });

            this.nameTextBox.set("value", this.documentVersion.name);
            this.store.setData(this.organisations);            

            this.grid.set("sort", "name", false);
            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.requestOriginalDocumentPageCaption, captionBarDiv, "cdesGeneralPageCaption");

    	    this.requestButton = new Button({
    		  label : i18n.requestOriginalRequestButtonCaption,
    		  title : i18n.requestOriginalRequestButtonCaption,
    		onClick : lang.hitch(this, this.request) 
    	    });
    	    domClass.add(this.requestButton.domNode, "requestOriginalRequestButton");
    	    domConstruct.place(this.requestButton.domNode, captionBarDiv);

    	    this.backButton = new Button({
    		  label : i18n.back,
    		  title : i18n.back,
    		onClick : lang.hitch(this, this.goBack) 
    	    });
    	    domClass.add(this.backButton.domNode, "requestOriginalBackButton");
    	    domConstruct.place(this.backButton.domNode, captionBarDiv);

            return captionBarDiv;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute requestOriginalDocumentPageContentDiv");

            // NameTextBox
            DOMHelper.createTextNode("div", i18n.requestOriginalNameLabel, contentDiv, "propertyLabel requestOriginalNameLabel");
            this.nameTextBox = new TextBox({
                   label : i18n.requestOriginalNameLabel,
                disabled : true             
            });
            domClass.add(this.nameTextBox.domNode, "fixedDialogWidget requestOriginalNameTextBox");
            domConstruct.place(this.nameTextBox.domNode, contentDiv);
            WidgetHelper.handleTextBoxEvents(this.nameTextBox, lang.hitch(this, this.updateWidgetState));

            // Request for
            DOMHelper.createTextNode("div", i18n.requestOriginalRequestForLabel, contentDiv, "propertyLabel requestOriginalRequestForLabel");

            // ... own person            
            this.personalRadioButton = new RadioButton({
                label : i18n.requestOriginalPersonalLabel,
                title : i18n.requestOriginalPersonalToolTip,
                 name : "requestFor"                
            });
            domClass.add(this.personalRadioButton.domNode, "fixedDialogWidget requestOriginalPersonalRadioButton");
            domConstruct.place(this.personalRadioButton.domNode, contentDiv);
            WidgetHelper.handleRadioButtonEvents(this.personalRadioButton, lang.hitch(this, this.handleRequestForChange));
            DOMHelper.createTextNode("div", i18n.requestOriginalPersonalLabel, contentDiv, "fixedDialogWidget requestOriginalPersonalLabel");

            // ... some organisation(s)            
            this.organisationsRadioButton = new RadioButton({
                label : i18n.requestOriginalOrganisationsLabel,
                title : i18n.requestOriginalOrganisationsToolTip,
                 name : "requestFor"                
            });
            domClass.add(this.organisationsRadioButton.domNode, "fixedDialogWidget requestOriginalOrganisationsRadioButton");
            domConstruct.place(this.organisationsRadioButton.domNode, contentDiv);
            WidgetHelper.handleRadioButtonEvents(this.organisationsRadioButton, lang.hitch(this, this.handleRequestForChange));
            DOMHelper.createTextNode("div", i18n.requestOriginalOrganisationsLabel, contentDiv, "fixedDialogWidget requestOriginalOrganisationsLabel");            

            // CommentTextarea
            DOMHelper.createTextNode("div", i18n.requestOriginalCommentLabel, contentDiv, "propertyLabel requestOriginalCommentLabel");
            this.commentTextArea = new Textarea({
                label : i18n.requestOriginalCommentLabel,
                title : i18n.requestOriginalCommentToolTip
            });
            domClass.add(this.commentTextArea.domNode, "fixedDialogWidget requestOriginalCommentTextArea");
            domConstruct.place(this.commentTextArea.domNode, contentDiv);
            WidgetHelper.handleTextBoxEvents(this.commentTextArea, lang.hitch(this, this.updateWidgetState));

            this.constructOrganisationDiv(contentDiv);

            domClass.add(this.organisationDiv, "invisible");
            this.personalRadioButton.set("checked", "true");
            this.personalMode = true;

            return contentDiv;
        },

        constructOrganisationDiv : function(contentDiv) {
            this.organisationDiv = domConstruct.create("div", null, null);
            domClass.add(this.organisationDiv, "fixedDialogWidget requestOriginalOrganisationDiv");
            domConstruct.place(this.organisationDiv, contentDiv);            

            var organisation = this.applicationContext.getPageContextOrganisation();

            DOMHelper.createTextNode("div", i18n.requestOriginalOwnOrganisationHeader, this.organisationDiv, "fixedDialogWidget requestOriginalOwnOrganisationHeader");
            this.ownOrganisationDiv = DOMHelper.createTextNode("div", organisation.name, this.organisationDiv, "fixedDialogWidget requestOriginalOwnOrganisationLabel");

//            DOMHelper.createTextNode("div", i18n.requestOriginalAdditionalOrganisationsHeader, this.organisationDiv,
//                "fixedDialogWidget requestOriginalAdditionalOrganisationsHeader");

            // See https://github.com/SitePen/dgrid/blob/master/doc/components/mixins/Selection.md for selection modes
            this.constructGrid({
		   idProperty : "id", 
            	       gridId : "requestOriginalOrganisationsGrid",
		selectionMode : "extended"
            });
            domConstruct.place(this.grid.domNode, this.organisationDiv);
        },

	constructColumns : function() {
	    var columns = [];

            // Organisation
            columns.push({
                     field : "name",
                        id : "name",
                  sortable : true,
                     label : i18n.requestOriginalAdditionalOrganisationsHeader
             });     

	    return columns;
	},

        resize : function(newSize) {
            var totalHeight = newSize.h;

            var width = this.captionBarDiv.offsetWidth - 15;
            var contentHeight = totalHeight
                //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                - this.captionBarDiv.offsetHeight
                - 16;

            domStyle.set(this.contentDiv, "height", contentHeight + "px");
            domStyle.set(this.commentTextArea.domNode, "height", (contentHeight - 100 - 9) + "px");  // minus <top> in class .requestOriginalOrganisationsGrid
            domStyle.set(this.grid.domNode, "height", (contentHeight - 100 - 10) + "px");  // minus <top> in class .requestOriginalOrganisationsGrid
        },

        setData : function() {

        },

        reload : function() {
            //this.contextBar.reload();
        },

        handleRequestForChange : function(e) {
            this.personalMode = (e.target == this.personalRadioButton.focusNode);
	    this.updateWidgetState();	    
        },

        updateWidgetState : function() {
            if (this.personalMode) {
                domClass.add(this.organisationDiv, "invisible");
            } else {
                domClass.remove(this.organisationDiv, "invisible");
            }                
        },

        request : function() {
    	    var documentService = this.applicationContext.getService("documentService");
    	    this.registerAsyncOperationStarted(RequestOriginalDocumentPage.AsyncOperation.REQUEST);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var organisationIds = [];
            var selectedOrganisations = this.getSelectedItems();
            for (var n = 0; n < selectedOrganisations.length; n++) {
                organisationIds.push(selectedOrganisations[n].id);
            }                
            var comment = this.commentTextArea.get("value");

            var deferred = null;
            if (this.personalRadioButton.get("checked")) {
                deferred = documentService.requestOriginalDocumentForOwnOrganisationPerson(organisationPersonId, this.documentVersionId, comment);
            } else if (this.organisationsRadioButton.get("checked")) {
                deferred = documentService.requestOriginalDocumentForOrganisations(organisationPersonId, this.documentVersionId, organisationIds, comment);
            } else {
                throw new Error("Neither personalRadioButton, nor organisationsRadioButton is checked.  Something is strange here...");                
            }

            deferred.then(
                lang.hitch(this, function() {
    	            this.registerAsyncOperationFinished(RequestOriginalDocumentPage.AsyncOperation.REQUEST);
                    this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : RequestOriginalDocumentPage.AsyncOperation.REQUEST,
                                opName : "requestOriginalDocumentFor(OwnOrganisationPersons|Organisations)",
                               message : i18n.requestOriginalRequestFailed
                    });
                })
            ).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Error while calling function [x]", err);
                }));
        },

        goBack : function() {
            this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    RequestOriginalDocumentPage.AsyncOperation = {
           LOAD : "Load",
        REQUEST : "Request"        
    };

    return RequestOriginalDocumentPage;
});
