/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = personList
//// i18n-prefix = personList

define(["cdes/core/CdesVoc",
        "cdes/organisation/OrganisationHelper",
        "cdes/util/ActionHelper",
        "cdes/util/DialogHelper",
        "cdes/util/NameHelper",
        "cdes/widget/base/ListWidget",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/StringHelper",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
        "dgrid/OnDemandGrid",
        "dgrid/extensions/ColumnResizer",
        "dgrid/extensions/DijitRegistry",
        "dojo/aspect",
        "dojo/dom-attr",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/on",
        "dojo/query",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
         OrganisationHelper,
         ActionHelper,
         DialogHelper,
         NameHelper,
         ListWidget,
         TinyLog,
         FancyButton,
         topic,
         DOMHelper,
         ErrorHelper,
         StringHelper,
         ContentWidget,
         InfoDialog,
         OnDemandGrid,
         ColumnResizer,
         DijitRegistry,
         aspect,
         domAttr,
         domClass,
         domConstruct,
         domStyle,
         on,
         query,
         string,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.person.PersonListWidget";

    var log = new TinyLog(className);

    var PersonListWidget = declare(className, ListWidget, {

        dataAttributeName : "persons",

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.columnFieldToPdfColumn = {
                _nameString : "name",
                _organisationString : "organisation",
            };

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PersonListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "personList/columnWidths",
        defaultColumnWidth : 130,

        columnIdToDefaultWidth : {
            /* TODO
            task : 130,
            serialNumber : 70,
            text : 350,
            planningNotification : 200,
            baulos : 130,
            project : 120,
            subjectArea : 130,
            authorizedInspector : 160,
            reference : 120,
            statutoryDuty : 130,
            documentPosition : 200,
            documentPage : 80,
            personInCharge : 280,
            dueDate : 120,
            state : 120,
            actions : 110,
            selection : 90
            */
        },

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            return [organisationPersonId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
                    field : "_nameString",
                       id : "name",
               renderCell : lang.hitch(this, this.renderName),
                 sortable : true,
                    label : i18n.nameLabel
            });

            columns.push({
                     field : "_organisationString",
                        id : "organisation",
                renderCell : lang.hitch(this, this.renderOrganisation),
                  sortable : true,
                     label : i18n.personListOrganisationProjectRoleCaption
            });

            columns.push({
                     field : "id",
                        id : "actions",
                renderCell : lang.hitch(this, this.renderActionCell),
                  sortable : false,
                     label : i18n.actionColumnCaption
            });

            return columns;
        },

        getPdfColumnByField : function(field) {
            return this.columnFieldToPdfColumn[field];
        },

        renderName : function(person, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            var personName = NameHelper.getPersonInverseCommonName(person, "");
            var personNameSpan = DOMHelper.createTextNode("div", personName, cellDiv);
            if ("administrateCertificate" in this.globalActions){
            	domClass.add(personNameSpan, "documentListDocumentVersionNameSpan");
				domAttr.set(personNameSpan, "title", i18n.personListPersonLoginCaption);
				on(personNameSpan, "click", lang.hitch(this, function() {
                    this.loadAdditionalPersonInfos(person.id);
	            }));
			}
            return cellDiv;
        },

        loadAdditionalPersonInfos : function(personId) {
            this.registerAsyncOperationStarted(PersonListWidget.AsyncOperation.GET_PERSON_INFO);
            var personService = this.applicationContext.getService("personService");
            personService.getPersonAdditonalInfo(personId).then(
                lang.hitch(this, function(personLogin) {
                    this.registerAsyncOperationFinished(PersonListWidget.AsyncOperation.GET_PERSON_INFO);
                    var login = personLogin;

		            InfoDialog.showWarning({
		                  title : "Info",
		                message : "login: " + login
		            });

                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonListWidget.AsyncOperation.GET_PERSON_INFO,
                                opName : "getPersonAdditonalInfo",
                               message : i18n.error
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPersonAdditonalInfo]", err);
                    }));
        },

        renderOrganisation : function(person, data, cell) {

            var topDiv = domConstruct.create("table", null, null);
            domClass.add(topDiv, "personListOrganisationTable");

            var networkIdsList = this.getPersonNetworkIdsList(person);
            var referenceOrganisationFound = ActionHelper.hasActionsForAnyNetworkInList(this.networkIdToActions, networkIdsList, "referenceOrganisation");

            var organisationJoins = person.organisationJoins;
            for (var n = 0; n < organisationJoins.length; n++) {
                var organisationJoin = organisationJoins[n];
				organisationJoin._notYetReferencedNetworks = [];

                var organisationRow = domConstruct.create("tr", null, null);
                if (organisationJoin.organisationPersonRetiredFlag)
                	domClass.add(organisationRow, "personListOrganisationRowInvalidated");
                else
                	domClass.add(organisationRow, "personListOrganisationRow");

                domConstruct.place(organisationRow, topDiv);
                var addressCell = domConstruct.create("td", null, null);
                domClass.add(addressCell, "personListCellAddressCell");
                domConstruct.place(addressCell, organisationRow);

                var nameDiv = domConstruct.create("div", null, null);
                DOMHelper.createTextNode("span", organisationJoin.organisationName, nameDiv, "personListCellOrganisationCaption");

				//generate allreadyReferencedNetworkNames
                var organisationId = organisationJoin.organisationId;
                var orgJoinsOrgReferencedNetworks = organisationId in this.organisationIdToNetworks ? this.organisationIdToNetworks[organisationId] : [];
                var allreadyReferencedNetworkNames = "";
                var allreadyReferencedNetworkItems = 0;
                var orgJoinsOrgReferencedNetworkIds = new Object();
                for (var z = 0; z < orgJoinsOrgReferencedNetworks.length; z++) {
                    var currOrgJoinsNetwork = orgJoinsOrgReferencedNetworks[z];
                    orgJoinsOrgReferencedNetworkIds[currOrgJoinsNetwork.id] = true;
                	allreadyReferencedNetworkItems ++;
                	allreadyReferencedNetworkNames += (allreadyReferencedNetworkItems > 1?"\n":"") + currOrgJoinsNetwork.name;
                }

                organisationJoin._notAllReferencedToMyNetworks = false;
                if (this.administratedNetworks != null && this.administratedNetworks.length > 0){
                	organisationJoin._notAllReferencedToMyNetworks = !this.contains(this.administratedNetworks, orgJoinsOrgReferencedNetworkIds, true);
                	//a list of not yet by the organisationPerson referenced administratedNetworks
	                for (var j = 0; j < this.administratedNetworks.length; j++) {
	                    if (!(this.administratedNetworks[j].id in orgJoinsOrgReferencedNetworkIds)){
	                    	organisationJoin._notYetReferencedNetworks.push(this.administratedNetworks[j]);
	                    }
	                }
                }

				//generate ReferenceButton
                if (organisationJoin._notAllReferencedToMyNetworks /*&& referenceOrganisationFound*/) {
                    var referenceButton = this.constructReferenceButton(person, organisationJoin, allreadyReferencedNetworkNames);
                    domConstruct.place(referenceButton.domNode, nameDiv);
                }
                domConstruct.place(nameDiv, addressCell);

				//organisation data
                var postalAddress = StringHelper.getNonNullString(organisationJoin.organisationPostalAddress);
                var postalCode = StringHelper.getNonNullString(organisationJoin.organisationPostalCode);
                var localityName = StringHelper.getNonNullString(organisationJoin.organisationLocalityName);
                var countryDescDe = StringHelper.getNonNullString(organisationJoin.countryDescDe);

                var addrDiv = domConstruct.create("div", null, null);
                domConstruct.place(addrDiv, addressCell);
                //DOMHelper.createTextNode("div", postalAddress, addrDiv, null);
    	        if (postalAddress!=null) {
		            var tokens = postalAddress.split("\n");
		            for (var k = 0; k < tokens.length; k++) {
		                var token = tokens[k];
						DOMHelper.createTextNode("div", token, addrDiv, null);
					}
		        }

                DOMHelper.createTextNode("div", postalCode + " " + localityName, addrDiv, null);
                DOMHelper.createTextNode("div", countryDescDe, addrDiv, null);

                var phoneCell = domConstruct.create("td", null, null);
                domClass.add(phoneCell, "personListCellPhoneCell");
                domConstruct.place(phoneCell, organisationRow);

				//organisationPerson data
                var opUnitName = StringHelper.getNonNullString(organisationJoin.organisationPersonOrganisationalUnitName);
                var opPostalAddress = StringHelper.getNonNullString(organisationJoin.organisationPersonPostalAddress);
                var opPostalCode = StringHelper.getNonNullString(organisationJoin.organisationPersonPostalCode);
                var opLocalityName = StringHelper.getNonNullString(organisationJoin.organisationPersonLocalityName);
                var opCountryDescDe = StringHelper.getNonNullString(organisationJoin.opCountryDescDe);
                var opMail = StringHelper.getNonNullString(organisationJoin.organisationPersonEmailAddress);
                var opPhone = StringHelper.getNonNullString(organisationJoin.organisationPersonTelephoneNumber);
                var opMobile = StringHelper.getNonNullString(organisationJoin.organisationPersonMobileTelephoneNumber);
                var opFax = StringHelper.getNonNullString(organisationJoin.organisationPersonFacsimileTelephoneNumber);

                var phoneTable = OrganisationHelper.constructOrganisationPersonTable({
                  unitName : opUnitName,
             postalAddress : opPostalAddress,
                postalCode : opPostalCode,
              localityName : opLocalityName,
             countryDescDe : opCountryDescDe,
                      mail : opMail,
                     phone : opPhone,
                    mobile : opMobile,
                       fax : opFax
                });
                domConstruct.place(phoneTable, phoneCell);

                var projectsCell = domConstruct.create("td", null, null);
                domClass.add(projectsCell, "personListCellProjectsCell");
                domConstruct.place(projectsCell, organisationRow);

                var projectsTable = this.constructProjectsTable(organisationJoin);
                domConstruct.place(projectsTable, projectsCell);

                if (!this.showDetails) {
                    domClass.add(projectsCell, "hidden");
                }
            }

            return topDiv;
        },
		//Projektbeteiligungen
        constructProjectsTable : function(organisationJoin) {
            var topDiv = domConstruct.create("table", null, null);
            domClass.add(topDiv, "personListProjectTable");

            var organisationPersonId = organisationJoin.organisationPersonId;
            var projects = organisationPersonId in this.organisationPersonIdToProjects
                         ? this.organisationPersonIdToProjects[organisationPersonId] : [];
            var projectIdToRoleJoins = this.organisationPersonIdToProjectIdToRoleJoins[organisationPersonId];

            for (var n = 0; n < projects.length; n++) {
                var project = projects[n];
                var projectId = project.id;
                var roleJoins = projectId in projectIdToRoleJoins ? projectIdToRoleJoins[projectId] : [];
                var projectsNetworkName = "";
                if (roleJoins != null && roleJoins.length > 0)
                	projectsNetworkName = " [" + roleJoins[0].networkName + "]";
                var projectRow = domConstruct.create("tr", null, null);
                domConstruct.place(projectRow, topDiv);

                // Project Cell
                var projectCell = domConstruct.create("td", null, null);
                domClass.add(projectCell, "personListCellProjectCell");
                domConstruct.place(projectCell, projectRow);

                var projectDiv = domConstruct.create("div", null, null);
                domConstruct.place(projectDiv, projectCell);

                DOMHelper.createTextNode("span", project.code, projectDiv, null);
                DOMHelper.createTextNode("span", project.name + projectsNetworkName, projectDiv, "personListCellProjectName");
                // TODO
                //DOMHelper.createTextNode("span", " ["+person.networkName+"]", projectDiv, "personListCellProjectName");

                // Roles Cell
                var rolesCell = domConstruct.create("td", null, null);
                domClass.add(rolesCell, "personListCellRolesCell");
                domConstruct.place(rolesCell, projectRow);

                var roleLabels = [];
                for (var z = 0; z < roleJoins.length; z++) {
                    var roleJoin = roleJoins[z];
                    var roleLabel = string.substitute(i18n.personListRoleLabel, {
                             role : roleJoin.cdesRoleName,
                          surName : roleJoin.mainPersonSurName,
                        givenName : roleJoin.mainPersonGivenName
                    });
                    roleLabels.push(roleLabel);
                }
                roleLabels.sort(function(labelOne, labelTwo) {
                    return labelOne.localeCompare(labelTwo);
                });

                for (var z = 0; z < roleLabels.length; z++) {
                    DOMHelper.createTextNode("div", roleLabels[z], rolesCell, null);
                }
            }
            return topDiv;
        },

        getOrganisationString : function(person) {
            var organisationString = "";

            var organisationJoins = person.organisationJoins;
            for (var n = 0; n < organisationJoins.length; n++) {
                var organisationJoin = organisationJoins[n];
                organisationString += organisationJoin.organisationName + " ";
                if (organisationJoin.organisationPersonOrganisationalUnitName != null && organisationJoin.organisationPersonOrganisationalUnitName.length > 0) {
                    organisationString += "(" + organisationJoin.organisationPersonOrganisationalUnitName + ") ";
                }
            }

            return organisationString;
        },

        constructReferenceButton : function(person, organisationJoin, allreadyReferencedNetworkNames) {
        	var allreadyReferencedNetworkNamesString = "";
        	if (allreadyReferencedNetworkNames != null && allreadyReferencedNetworkNames.length>0)
        		 allreadyReferencedNetworkNamesString = "\n" + i18n.organisationListReferenceToolTipExt + ":\n" + allreadyReferencedNetworkNames;
            var button = new FancyButton({
                    title : i18n.organisationListReferenceToolTip + allreadyReferencedNetworkNamesString,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 referenceButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function(event) {
                OrganisationHelper.askAddOrganisationToAdminNetwork({
                       applicationContext : this.applicationContext,
                    administratedNetworks : organisationJoin._notYetReferencedNetworks,
                         organisationJoin : organisationJoin,
                                   widget : this
                });
            }));

            return button;
        },

        resetQuickSearch : function() {
            this.projectRoleFilter = null;
        },

        setProjectRoleFilter : function(projectRoleFilter) {
            if (projectRoleFilter != this.projectRoleFilter) {
                this.projectRoleFilter = projectRoleFilter;
                this.updateProjectRoleVisibility();
            }
        },

        updateProjectRoleVisibility : function() {
            query('td.dgrid-cell.dgrid-column-organisation', this.grid.domNode).forEach(lang.hitch(this, function(cell) {
                var organisationTable = cell.childNodes[0];
                var organisationRows = organisationTable.childNodes;
                for (var v = 0; v < organisationRows.length; v++) {
                    var organisationRow = organisationRows[v];
                    var projectsCell = organisationRow.childNodes[2];
                    if (this.showDetails) {
                        domClass.remove(projectsCell, "hidden");
                    } else {
                        domClass.add(projectsCell, "hidden");
                    }
                    if (this.showDetails) {
                        var projectTable = projectsCell.childNodes[0];
                        this.updateProjectTableVisibility(projectTable);
                    }
                }
            }));
            /*
            query('.dgrid-row', this.grid.domNode).forEach(lang.hitch(this, function(node) {
                var row = this.grid.row(node);
                if (row.element != null) {
                    var rowChildren = row.element.childNodes;
                    for (var n = 0; n < rowChildren.length; n++) {
                        var rowChild = rowChildren[n];
                        log.info("rowChild: [" + rowChild + "]");
                    }
                }
            }));
            */
            /*
            for (var n = 0; n < this[this.dataAttributeName].length; n++) {
                var rowId = this.getRowId(this[this.dataAttributeName][n]);
                var row = this.grid.row(rowId);
            }
            */
        },

        updateProjectTableVisibility : function(projectTable) {
            var lowerCaseFilterString = this.projectRoleFilter != null ? this.projectRoleFilter.toLowerCase() : "";
                for (var z = 0; z < projectTable.childNodes.length; z++) {
                    var projectTableRow = projectTable.childNodes[z];
                    var projectCell = projectTableRow.childNodes[0];
                    var rolesCell = projectTableRow.childNodes[1];

                    var projectContent = projectCell.innerText.toLowerCase();
                    var projectVisible = projectContent.includes(lowerCaseFilterString);

                    var roleLines = rolesCell.childNodes;
                    if (projectVisible) {
                        for (var n = 0; n < roleLines.length; n++) {
                            var roleLine = roleLines[n];
                            domClass.remove(roleLine, "hidden");
                        }
                    } else {
                        for (var n = 0; n < roleLines.length; n++) {
                            var roleLine = roleLines[n];
                            var roleContent = roleLine.innerText.toLowerCase();
                            var roleVisible = roleContent.includes(lowerCaseFilterString);
                            projectVisible |= roleVisible;

                            if (roleVisible) {
                                domClass.remove(roleLine, "hidden");
                            } else {
                                domClass.add(roleLine, "hidden");
                            }
                        }
                    }

                    if (projectVisible) {
                        domClass.remove(projectCell, "hidden");
                    } else {
                        domClass.add(projectCell, "hidden");
                    }
                }
        },

        renderActionCell : function(person, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);

            var networkIdsList = this.getPersonNetworkIdsList(person);

            var showPersonFound = ActionHelper.hasActionsForAnyNetworkInList(this.networkIdToActions, networkIdsList, "showPerson");
            var editPersonFound = ActionHelper.hasActionsForAnyNetworkInList(this.networkIdToActions, networkIdsList, "editPerson");
            var editOrganisationPersonFound = ActionHelper.hasActionsForAnyNetworkInList(this.networkIdToActions, networkIdsList, "editOrganisationPerson");
            var deletePersonFound = ActionHelper.hasActionsForAnyNetworkInList(this.networkIdToActions, networkIdsList, "deletePerson");
            var invalid = person.status == 1 || person.status == 2;

            if (showPersonFound || editPersonFound) {
                var projectParticipationsButton = this.constructProjectParticipationsButton(person);
                domConstruct.place(projectParticipationsButton.domNode, buttonDiv);
            }

            if (editOrganisationPersonFound && !invalid) {
                var editOrganisationPersonButton = this.constructAddOrganisationPersonButton(person);
                domConstruct.place(editOrganisationPersonButton.domNode, buttonDiv);
            }

            if (editPersonFound && !invalid) {
                var editButton = this.constructEditButton(person);
                domConstruct.place(editButton.domNode, buttonDiv);
            } else if (showPersonFound) {
                var showButton = this.constructShowButton(person);
                domConstruct.place(showButton.domNode, buttonDiv);
            }

            if (deletePersonFound) {
                if (person.status == 1) {
                    var undeleteButton = this.constructUndeleteButton(person);
                    domConstruct.place(undeleteButton.domNode, buttonDiv);
                } else if (!invalid){
                    var deleteButton = this.constructDeleteButton(person);
                    domConstruct.place(deleteButton.domNode, buttonDiv);
                }
            }

            return buttonDiv;
        },

        constructProjectParticipationsButton : function(person) {
            var button = new FancyButton({
                    title : i18n.personEditPageShowProjectParticipationsToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 projectParticipationsButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("participationList",
                                                { mode : ContentWidget.Mode.EDIT, personId : person.id },
                                                { },
                                                this.backPage, this.backParams);
            }));
            return button;
        },

        constructAddOrganisationPersonButton : function(person) {
            var button = new FancyButton({
                    title : i18n.personEditPageAddOrganisationPersonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 addObjectPlannerButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("personEdit",
                                                { mode : ContentWidget.Mode.EDIT,
	                                                id : person.id,
	                     	     administratedNetworks : this.getNetworkIdsList(this.administratedNetworks) },
                                                { action : "addOrganisationPerson"},
                                                this.backPage, this.backParams);
            }));
            return button;
        },

        constructEditButton : function(person) {
            var button = new FancyButton({
                    title : i18n.personListEditToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("personEdit",
                                                { mode : ContentWidget.Mode.EDIT,
                                                    id : person.id,
                     	         administratedNetworks : this.getNetworkIdsList(this.administratedNetworks) },
                                                null, this.backPage, this.backParams);
            }));
            return button;
        },

        constructShowButton : function(person) {
            var button = new FancyButton({
                    title : i18n.personListEditToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 showButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("personEdit",
                                                { mode : ContentWidget.Mode.SHOW, id : person.id },
                                                null, this.backPage, this.backParams);
            }));
            return button;
        },

        constructUndeleteButton : function(person) {
            var button = new FancyButton({
                    title : i18n.personListUndeleteToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 undeleteButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function(event) {
                this.askUndeletePerson(person);
            }));

            return button;
        },

        constructDeleteButton : function(person) {
            var button = new FancyButton({
                    title : i18n.personListDeleteToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function(event) {
                this.prepareDeletePerson(person);
            }));

            return button;
        },

        askUndeletePerson : function(person) {
            var message = string.substitute(i18n.personListAskUndeleteDialogText, {
                givenName : person.givenName,
                  surName : person.surName
            });

            InfoDialog.showQuestion({
                  title : i18n.personListAskUndeleteDialogCaption,
                message : message,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doUndeletePerson(person);
                    })},
                    { type : InfoDialog.Button.NO }
                ]
            });
        },

        doUndeletePerson : function(person) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.registerAsyncOperationStarted(PersonListWidget.AsyncOperation.UNDELETE);
            var personService = this.applicationContext.getService("personService");
            personService.undeletePerson(organisationPersonId, person.id).then(
                lang.hitch(this, function() {
                    this.registerAsyncOperationFinished(PersonListWidget.AsyncOperation.UNDELETE);

                    var message = string.substitute(i18n.personListUndeleteSuccessful, {
                        givenName : person.givenName,
                          surName : person.surName
                    });
                    topic.publish("message/ok", message);

                    on.emit(this, "doSearch");
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonListWidget.AsyncOperation.UNDELETE,
                                opName : "undeletePerson",
                               message : i18n.personListWidgetUndeletePersonFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [undeletePerson]", err);
                    }));
        },

        prepareDeletePerson : function(person) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.registerAsyncOperationStarted(PersonListWidget.AsyncOperation.GET_DELETE_INFO);
            var personService = this.applicationContext.getService("personService");
            personService.getPersonDeleteInfo(organisationPersonId, person.id).then(
                lang.hitch(this, function(organisationPersonDeleteInfos) {
                    this.registerAsyncOperationFinished(PersonListWidget.AsyncOperation.GET_DELETE_INFO);

                    var noPermissionJoins = [];
                    var organisationPersonInUseJoins = [];
                    var mainParticipationInUseJoins = [];

                    for (var n = 0; n < organisationPersonDeleteInfos.length; n++) {
                        var organisationPersonDeleteInfo = organisationPersonDeleteInfos[n];
                        if (!organisationPersonDeleteInfo.deletePermission) {
                            noPermissionJoins.push(organisationPersonDeleteInfo.organisationPersonJoin);
                        }
                        if (organisationPersonDeleteInfo.inUse) {
                            organisationPersonInUseJoins.push(organisationPersonDeleteInfo.organisationPersonJoin);
                        }
                        if (organisationPersonDeleteInfo.mainParticipationInUse) {
                            mainParticipationInUseJoins.push(organisationPersonDeleteInfo.organisationPersonJoin);
                        }
                    }

                    if (noPermissionJoins.length > 0) {
                        this.showNotDeletableDialog(person, noPermissionJoins);
                    } else {
                        if (organisationPersonInUseJoins.length == 0) {
                            if (mainParticipationInUseJoins.length == 0) {
                                this.showAskDeleteInvalidateDialog(person);
                            } else {
                                throw new Error("According to [getPersonDeleteInfo], no organisationPersons are in use, but some of the mainParticipations. "
                                                + "This is an impossible case, as 'mainParticipationInUse' triggers automatically 'organisationPerson in use'.");
                            }
                        } else {
                            if (mainParticipationInUseJoins.length == 0) {
                                this.showAskInvalidateDialog(person, organisationPersonInUseJoins);
                            } else {
                                this.showNotDeletableNorInvalidatableDialog(person, organisationPersonDeleteInfos);
                            }
                        }
                    }
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonListWidget.AsyncOperation.GET_DELETE_INFO,
                                opName : "getUndeletableOrganisationPersonJoinsByPerson",
                               message : i18n.personListGetUndeletableOrganisationPersonJoinsByPersonFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getUndeletableOrganisationPersonJoinsByPerson]", err);
                    }));
        },

        showAskDeleteInvalidateDialog : function(person) {
            var content = domConstruct.create("div", null, null);
            domClass.add(content, "dialogContent");
            var topText = string.substitute(i18n.personListAskDeleteInvalidateDialogText, {
                givenName : person.givenName,
                  surName : person.surName
            });
            DOMHelper.createTextNode("div", topText, content);

            /*
            var ulNode = domConstruct.create("ul", null, content);
            DOMHelper.createTextNode("li", i18n.personListAskDeleteInvalidateDeleteItem, ulNode);
            DOMHelper.createTextNode("li", i18n.personListAskDeleteInvalidateInvalidateItem, ulNode);
            */
            var askDeleteInvalidateDialog = new InfoDialog({
                        title : i18n.personListAskDeleteInvalidateDialogCaption,
                      content : content,
                 defaultWidth : 350,
                defaultHeight : 150,
                      buttons : [
                                 {    type : InfoDialog.Button.CUSTOM,
                                      name : "deleteButton",
                                     label : i18n.deleteButtonCaption,
                                     title : i18n.personListDeleteButtonToolTip,
                                       fct : lang.hitch(this, function() {
                                           this.deletePerson(person);
                                       })},
                          /*
                                 {    type : InfoDialog.Button.CUSTOM,
                                      name : "invalidateButton",
                                     label : i18n.personListInvalidateButtonCaption,
                                     title : i18n.personListInvalidateButtonToolTip,
                                       fct : lang.hitch(this, function() {
                                           this.invalidatePerson(person);
                                       })},*/
                                 {    type : InfoDialog.Button.ABORT }
                      ]
            });
            askDeleteInvalidateDialog.show();
        },

        showAskInvalidateDialog : function(person, usedOrganisationPersonJoins) {
            var text = string.substitute(i18n.personListAskDeleteInvalidateDialogText, {
                givenName : person.givenName,
                  surName : person.surName
            });

            var content = domConstruct.create("div", null, null);
            domClass.add(content, "dialogContent");

            DOMHelper.createTextNode("div", text, content);
            DOMHelper.createTextNode("div", "", content);
            /*
            var ulNode = domConstruct.create("ul", null, content);
            for (var n = 0; n < usedOrganisationPersonJoins.length; n++) {
                var usedOrganisationPersonJoin = usedOrganisationPersonJoins[n];
                DOMHelper.createTextNode("li", usedOrganisationPersonJoin.organisationName, ulNode);
            }*/



            DOMHelper.createTextNode("div", i18n.personListInvalidateDialogTextTwo, content, "personListInvalidateDialogTextTwo");

            var askInvalidateDialog = new InfoDialog({
                        title : i18n.personListAskInvalidateDialogCaption,
                      content : content,
                 defaultWidth : 380,
                defaultHeight : 220,
                      buttons : [
                                 {    type : InfoDialog.Button.CUSTOM,
                                      name : "invalidateButton",
                                     label : i18n.personListInvalidateButtonCaption,
                                     title : i18n.personListInvalidateButtonToolTip,
                                       fct : lang.hitch(this, function() {
                                           this.invalidatePerson(person);
                                       })},
                                 {    type : InfoDialog.Button.ABORT }
                      ]
            });
            askInvalidateDialog.show();
        },

        showNotDeletableDialog : function(person, noPermissionOrganisationPersonJoins) {
            var text = string.substitute(i18n.personListDeleteNotPossibleDialogText, {
                givenName : person.givenName,
                  surName : person.surName
            });

            var content = domConstruct.create("div", null, null);
            domClass.add(content, "dialogContent");
            DOMHelper.createTextNode("div", text, content);
            var ulNode = domConstruct.create("ul", null, content);
            for (var n = 0; n < noPermissionOrganisationPersonJoins.length; n++) {
                var noPermissionOrganisationPersonJoin = noPermissionOrganisationPersonJoins[n];
                DOMHelper.createTextNode("li", noPermissionOrganisationPersonJoin.organisationName, ulNode);
            }

            var notDeletableDialog = new InfoDialog({
                        title : i18n.personListDeleteNotPossibleDialogCaption,
                      content : content,
                 defaultWidth : 350,
                defaultHeight : 150,
                      buttons : [ {    type : InfoDialog.Button.CLOSE } ]
            });
            notDeletableDialog.show();
        },

        showNotDeletableNorInvalidatableDialog : function(person, organisationPersonDeleteInfos) {
            var text = string.substitute(i18n.personListDeleteInvalidateNotPossibleDialogText, {
                givenName : person.givenName,
                  surName : person.surName
            });

            var content = domConstruct.create("div", null, null);
            domClass.add(content, "dialogContent");
            DOMHelper.createTextNode("div", text, content);

            var ulNode = domConstruct.create("ul", null, content);
            for (var n = 0; n < organisationPersonDeleteInfos.length; n++) {
                var organisationPersonDeleteInfo = organisationPersonDeleteInfos[n];
                var organisationPersonJoin = organisationPersonDeleteInfo.organisationPersonJoin;
                if (organisationPersonDeleteInfo.mainParticipationInUse) {
                    var hints = organisationPersonDeleteInfo.mainParticipationsInUseHints;
                    for (var v = 0; v < hints.length; v++) {
                        DialogHelper.addHint(ulNode, hints[v]);
                    }
                }
            }

            var notDeletableDialog = new InfoDialog({
                        title : i18n.personListDeleteInvalidateNotPossibleDialogCaption,
                      content : content,
                 defaultWidth : 750,
                defaultHeight : 350,
                      buttons : [ {    type : InfoDialog.Button.CLOSE } ]
            });
            notDeletableDialog.show();
        },

        deletePerson : function(person) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var personService = this.applicationContext.getService("personService");
            this.registerAsyncOperationStarted(PersonListWidget.AsyncOperation.DELETE_PERSON);
            personService.deletePerson(organisationPersonId, person.id).then(
                lang.hitch(this, function(result) {
                    this.registerAsyncOperationFinished(PersonListWidget.AsyncOperation.DELETE_PERSON);

                    var successMessage = string.substitute(i18n.personListDeleteSuccessfulMessage, {
                        givenName : person.givenName,
                          surName : person.surName
                    });
                    topic.publish("message/ok", successMessage);

                    on.emit(this, "doSearch");
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonListWidget.AsyncOperation.DELETE_PERSON,
                                opName : "deletePerson",
                               message : i18n.personListDeletePersonFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [deletePerson]", err);
                    }));

        },

        invalidatePerson : function(person) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var personService = this.applicationContext.getService("personService");
            this.registerAsyncOperationStarted(PersonListWidget.AsyncOperation.INVALIDATE_PERSON);
            personService.invalidatePerson(organisationPersonId, person.id).then(
                lang.hitch(this, function(result) {
                    this.registerAsyncOperationFinished(PersonListWidget.AsyncOperation.INVALIDATE_PERSON);

                    var successMessage = string.substitute(i18n.personListInvalidateSuccessfulMessage, {
                        givenName : person.givenName,
                          surName : person.surName
                    });
                    topic.publish("message/ok", successMessage);

                    on.emit(this, "doSearch");
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonListWidget.AsyncOperation.INVALIDATE_PERSON,
                                opName : "invalidatePerson",
                               message : i18n.personListInvalidatePersonFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [invalidatePerson]", err);
                    }));
        },

        constructTopDiv : function() {
            var grid = this.constructGrid({
                idProperty : "id",
                    gridId : this.gridId != null ? this.gridId : "PersonListGrid",
                 gridClass : "OnDemandGrid"
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                this.applicationContext.storeInLocalStorage([organisationPersonId], "/person/sort", e.sort);
            }));

            aspect.after(this.grid, "renderRow", lang.hitch(this, function(row, args) {
                var joinDto = args[0];
                this.updateRowClass(row, joinDto);
                return row;
            }));

            return grid;
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setShowDetails : function(showDetails) {
            if (showDetails != this.showDetails) {
                this.showDetails = showDetails;

                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                this.applicationContext.storeInLocalStorage([organisationPersonId], "/person/columnSettings",
                                                            { showProject : showDetails });

                this.updateProjectRoleVisibility();
            }
        },

        setData : function(params) {
            var personInfo = params.personInfo;
            this.certificateAdministrationGlobal = params.certificateAdministrationGlobal;
            this.globalActions = params.globalActions;
            this.networkIdToActions = personInfo.networkIdToActions;
            this.persons = personInfo.persons;
            var personIdToOrganisationJoins = personInfo.personIdToOrganisationJoins;
            this.organisationPersonIdToProjects = personInfo.organisationPersonIdToProjects;
            this.organisationPersonIdToProjectIdToRoleJoins = personInfo.organisationPersonIdToProjectIdToRoleJoins;
            this.organisationIdToNetworks = personInfo.organisationIdToNetworks;

            for (var n = 0; n < this.persons.length; n++) {
                var person = this.persons[n];
                person.organisationJoins = person.id in personIdToOrganisationJoins ? personIdToOrganisationJoins[person.id] : [];
//                person.projects = person.id in organisationPersonIdToProjects ? organisationPersonIdToProjects[person.id] : [];
//                person.projectIdToRoleJoins = person.id in personIdToProjectIdToRoleJoins ? personIdToProjectIdToRoleJoins[person.id] : new Object();
                person.networkIds = new Object();
                for (var z = 0; z < person.organisationJoins.length; z++) {
                    var organisationId = person.organisationJoins[z].organisationId;
                    var personOrgsNetworks = this.organisationIdToNetworks[organisationId];
                    if (personOrgsNetworks != null) {
                        for (var v = 0; v < personOrgsNetworks.length; v++) {
                            var networkId = personOrgsNetworks[v].id;
                            person.networkIds[networkId] = true;
                        }
                    }
                }

/*                person.projects.sort(function(projectOne, projectTwo) {
                    var s1 = StringHelper.getNonNullString(projectOne.code) + " " + StringHelper.getNonNullString(projectOne.name);
                    var s2 = StringHelper.getNonNullString(projectTwo.code) + " " + StringHelper.getNonNullString(projectTwo.name);
                    return s1.localeCompare(s2);
                });
*/
            }

            this.updateAuxiliaryData();

            this.reload();
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.persons.length; n++) {
                var person = this.persons[n];
                this.updateAuxiliaryDataForJoinDto(person);
            }
        },

        setAdministratedNetworks : function(administratedNetworks) {
            this.administratedNetworks = administratedNetworks;
        },

        updateAuxiliaryDataForJoinDto : function(person) {
	    	person.id = this.getRowId(person);
            person._nameString = NameHelper.getPersonInverseCommonName(person, "");
            person._organisationString = this.getOrganisationString(person);
            //check whether non administratedNetworks are referenced by organisation
            if (this.administratedNetworks != null && this.administratedNetworks.length > 0)
                person._nonReferencedToMyNetworks = !this.contains(this.administratedNetworks, person.networkIds, false);

        },

        contains : function(array1, array2, all) {
        	//return array1.every(currentValue => (currentValue.id in array2));
        	var containsAll = true;
        	var containsPart = false;
	        for(var i=0; i < array1.length; i++)
                containsAll &= array1[i].id in array2;
	        for(var i=0; i < array1.length; i++)
                containsPart |= array1[i].id in array2;

            if (all)
		    	return containsAll;
	    	else
		    	return containsPart;
        },

        updateRowClass : function(domNode, person) {
            domClass.remove(domNode, "personListForeignNetworkRow");
            domClass.remove(domNode, "personListInvalidatedPerson");

            var personNetworkIds = person.networkIds;
            if (person._nonReferencedToMyNetworks) {
                domClass.add(domNode, "personListForeignNetworkRow");
            }
            if (person.status) {
                domClass.add(domNode, "personListInvalidatedPerson");
            }
        },

        reload : function(params) {
            this.setStoreData(this.persons);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId], "/person/sort");

            if (oldSort == null) {
                // TODO                this.grid.set("sort", "_dueDateString", false);
                this.applicationContext.storeInLocalStorage([organisationPersonId], "/person/sort", this.grid.get("sort"));
            } else {
                this.grid.set("sort", oldSort);
            }

            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
            this.updateProjectRoleVisibility();
        },

        getRowId : function(person) {
            return person.id;
        },

        getQuickSearchTokensForRow : function(person) {
            var tokens = [];
            tokens.push(person._nameString);
            tokens.push(person._organisationString);
            tokens.push(person._projectString);

            return tokens;
        },


        getPersonNetworkIdsList : function(person) {
            var networkIds = person.networkIds;
            var networkIdsList = [];
            if (networkIds != null) {
                for (var networkId in networkIds) {
                    networkIdsList.push(networkId);
                }
            }
            return networkIdsList;
        },

        getNetworkIdsList : function(networks) {
            var networkIdsList = [];
            if (networks != null) {
				for (var n = 0; n < networks.length; n++) {
	                var networkId = networks[n].id;
	                if (!(networkId in networkIdsList))
	                    networkIdsList.push(networkId);
                }
            }
            return networkIdsList;
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    PersonListWidget.AsyncOperation = {
        DELETE_PERSON : "DeletePerson",
        GET_DELETE_INFO : "GetDeleteInfo",
        GET_PERSON_INFO : "GetPersonInfo",
        INVALIDATE_PERSON : "InvalidatePerson",
        UNDELETE : "Undelete"
    };

    return PersonListWidget;
});
