/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = review
////i18n-prefix = review


define([ "cdes/planning/task/PlanningNotificationTaskListWidget",
        "cdes/planning/task/WorkflowReviewResultWidget",
        "cdes/planning/util/PlanningNotificationHelper",
        "cdes/planning/workflow/WorkflowActivityResultListWidget",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/FancyContentPane",
        "dijit/form/CheckBox",
        "dijit/layout/BorderContainer",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(PlanningNotificationTaskListWidget,
         WorkflowReviewResultWidget,
         PlanningNotificationHelper,
         WorkflowActivityResultListWidget,
         TinyLog,
         FancyButton,
         DOMHelper,
         ErrorHelper,
         WidgetHelper,
         ContentWidget,
         FancyContentPane,
         CheckBox,
         BorderContainer,
         domClass,
         domConstruct,
         domStyle,
         on,
         string,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.planning.task.ReviewPage";

    var log = new TinyLog(className);

    var ReviewPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);
            
            this.organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.networkId = this.applicationContext.getPageContextNetworkId();
			this.mode = params.backParams.initialMode;
            this.activeTab = ReviewPage.Tab.HISTORY;
            this.taskColumnSettings = this.getTaskColumnSettings();
            this.topDiv = this.constructTopDiv();
            this.reload();

            this.updateBaulosFilter();
            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            var caption = string.substitute(i18n.reviewPageCaption, {
                serialNumber : ""
            });         

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", caption, captionBarDiv, "cdesGeneralPageCaption");

            return captionBarDiv;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute", "reviewPageContentDiv");

            this.borderContainer = new BorderContainer({
                design  : "headline",
                "class" : "occupyWholeParent"
            });

            this.constructTaskListWidget();
            this.taskListContentPane.set("region", "top");
            this.taskListContentPane.set("splitter", true);
            this.borderContainer.addChild(this.taskListContentPane);        

            var historyListElements = PlanningNotificationHelper.constructHistoryListWidget({
                  applicationContext : this.applicationContext,
                    historyButtonFct : lang.hitch(this,function() {
                        this.activeTab = ReviewPage.Tab.HISTORY;
                        this.updateBaulosFilter();
                        this.updateWidgetState();                
                    }),
                     updateBaulosFct : lang.hitch(this, this.updateBaulosFilter),
                      openReviewsFct : lang.hitch(this,function() {
                          this.activeTab = ReviewPage.Tab.OPEN;
                          this.updateBaulosFilter();
                          this.updateWidgetState();                
                      }),
                historyPostResizeFct : lang.hitch(this, this.historyPostResize),
                  enableBaulosFilter : true
            });
            this.historyDiv = historyListElements.historyDiv;
            this.historyTabDiv = historyListElements.historyTabDiv;
            this.historyButton = historyListElements.historyButton;
            this.openReviewsButton = historyListElements.openReviewsButton;
            this.showAllCheckBox = historyListElements.showAllCheckBox;
            //initialize with LocalStorage
            options = this.applicationContext.getFromLocalStorage([this.organisationPersonId, this.networkId], "/reviewPage/options");
            if (options != null)
            	this.showAllCheckBox.set("checked", !!options.showAllCheckBox);

            this.openTabDiv = historyListElements.openTabDiv;
            this.historyListWidget = historyListElements.historyListWidget;
            this.historyListWidgetDiv = historyListElements.historyListWidgetDiv;
            this.historyContentPane = historyListElements.historyContentPane;

            this.historyContentPane.set("region", "center");
            this.borderContainer.addChild(this.historyContentPane);         

            this.constructResultWidget();
            this.resultContentPane.set("region", "right");
            this.resultContentPane.set("splitter", true);           
            this.borderContainer.addChild(this.resultContentPane);          

            domConstruct.place(this.borderContainer.domNode, contentDiv);
            this.borderContainer.startup();
            this.taskListContentPane.resize({ h : 180 });
            this.resultContentPane.resize({ w : 600 });
            return contentDiv;
        },

        constructTaskListWidget : function() {
            // List Widget
            this.taskListWidget = new PlanningNotificationTaskListWidget({
                applicationContext : this.applicationContext,
                            gridId : "ReviewPlanningNotificationTaskGrid",
                       showActions : false,
                          backPage : "workflowReview",
                        backParams : { id : this.id }
            });
            this.taskListWidgetDiv = this.taskListWidget.getContainer();
            domClass.add(this.taskListWidgetDiv, "workflowReviewTaskListDiv");

            this.taskListContentPane = new FancyContentPane({
                content : this.taskListWidget.getContainer()
            });         
        },          

        updateBaulosFilter : function() {
            var showAll = this.showAllCheckBox.get("checked");
            var showResultJoins = (this.activeTab == ReviewPage.Tab.HISTORY);
            var showOpenTaskJoins = (this.activeTab == ReviewPage.Tab.OPEN);
            if (showAll) {
                this.historyListWidget.setBaulosFilter(null, showResultJoins, showOpenTaskJoins);
            } else {
                var taskInfo = this.taskInfos != null && this.taskInfos.length > 0 ? this.taskInfos[0] : null;
                var baulose = taskInfo != null && taskInfo.workflowNodePositionBaulose != null ? taskInfo.workflowNodePositionBaulose : [];
                this.historyListWidget.setBaulosFilter(baulose, showResultJoins, showOpenTaskJoins);
            }      
            this.applicationContext.storeInLocalStorage([this.organisationPersonId, this.networkId], "/reviewPage/options", {"showAllCheckBox" : showAll});
                          
        },

        historyPostResize : function(newSize) {
            this.historyListWidget.resize({ w : newSize.w - 25, h : newSize.h - 50 });
        },

        constructResultWidget : function() {
            this.resultWidget = new WorkflowReviewResultWidget({
                applicationContext : this.applicationContext,
                          backPage : this.backPage,
                        backParams : this.backParams            
            });
            this.resultWidgetDiv = this.resultWidget.getContainer();

            this.resultContentPane = new FancyContentPane({
                           content : this.resultWidgetDiv,
                postResizeFunction : lang.hitch(this, this.resultPostResize)            
            });                     
        },

        resultPostResize : function(newSize) {
            this.resultWidget.resize({ w : newSize.w - 25, h : newSize.h - 20 });
        },      

        resize : function(newSize) {
            var totalHeight = newSize.h;

            var contentWidth = this.captionBarDiv.offsetWidth - 15;
            var contentHeight = totalHeight
                              - this.captionBarDiv.offsetHeight
                              - 16;

            domStyle.set(this.contentDiv, "height", contentHeight + "px");
            this.borderContainer.resize({ w : contentWidth, h : contentHeight });
        },

        setData : function() {

        },

        reload : function() {
            this.taskListWidget.setData({ planningNotificationTaskInfos : [], columnSettings : this.taskColumnSettings });

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(ReviewPage.AsyncOperation.LOAD_DATA);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.getTaskResultInfoByWorkflowToken(organisationPersonId, this.id, this.mode).then(
                lang.hitch(this, function(workflowActivityResultInfo) {
                    this.taskInfos = (workflowActivityResultInfo.taskInfo != null ? [ workflowActivityResultInfo.taskInfo ] : []);
                    var taskInfo = this.taskInfos != null && this.taskInfos.length > 0 ? this.taskInfos[0] : null;
                    var serialNumber = taskInfo != null ? taskInfo.taskJoin.planningNotificationOrderSerialNumber : "";
                    var caption = string.substitute(i18n.reviewPageCaption, {
                        serialNumber : serialNumber
                    });         
                    DOMHelper.setInnerText(this.captionDiv, caption);

                    var openTaskInfos = workflowActivityResultInfo.openTaskInfos;
                    var openTaskJoins = PlanningNotificationHelper.getOpenTaskJoinsByOpenTaskInfos(openTaskInfos);

                    this.registerAsyncOperationFinished(ReviewPage.AsyncOperation.LOAD_DATA);

                    this.updateBaulosFilter();

                    if (this.taskInfos != null && this.taskInfos.length > 0) {
	                    this.taskListWidget.setData({ 
	                        planningNotificationTaskInfos : this.taskInfos,
	                                       columnSettings : this.taskColumnSettings
	                    });
	
	                    this.historyListWidget.setData({
	                                            resultJoins : workflowActivityResultInfo.resultJoins,
	                                          openTaskJoins : openTaskJoins,
	                            workflowActivityIdToBaulose : workflowActivityResultInfo.workflowActivityIdToBaulose,
	                        workflowActivityIdToAttachments : workflowActivityResultInfo.workflowActivityIdToAttachments                    
	                    });                 

                        this.resultWidget.setData({
                            planningNotificationTaskInfos : this.taskInfos,
                              workflowActivityIdToBaulose : workflowActivityResultInfo.workflowActivityIdToBaulose,
                                            resultOptions : workflowActivityResultInfo.resultOptions,
                                                 backPage : this.backPage,
                                               backParams : this.backParams,
                                                taskJoins : this.taskJoins,
                                                  comment : taskInfo.taskJoin.workflowTokenReviewComment,
                                              attachments : taskInfo.taskJoin.workflowTokenReviewAttachments,
                                           resultOptionId : taskInfo.taskJoin.workflowTokenReviewWorkflowNodePositionResultOptionId
                        });                    	
                    }

                    on.emit(this, "triggerResize");
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : ReviewPage.AsyncOperation.LOAD_DATA,
                                opName : "getTaskResultInfoByWorkflowToken",
                               message : i18n.reviewProtocolGetTaskResultInfoFailed
                    });
                    this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
                    
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getTaskResultInfoByWorkflowToken]", err);
                    }));
        },

        updateWidgetState : function() {
            PlanningNotificationHelper.updateHistoryTabs([{ tabDiv : this.historyTabDiv, tabConstant : ReviewPage.Tab.HISTORY },
                                                          { tabDiv : this.openTabDiv, tabConstant : ReviewPage.Tab.OPEN }],
                                                         this.activeTab);
        },

        getTaskColumnSettings : function(searchModel) {
            return {
                                showTask : true,
                      showTokenInitiator : true,
                        showSerialNumber : false,
                                showText : true,
                showPlanningNotification : true,
                             showProject : true,
                         showSubjectArea : false,
                 showAuthorizedInspector : true,
                       showStatutoryDuty : true,
                        showDocumentPage : false,
                    showDocumentPosition : true,
                      showPersonInCharge : false,
                             showDueDate : true,
                               showState : true,
                           showReference : true         
            };                
        },

        destroy : function() {
            this.inherited(arguments);
            this.historyListWidget.destroy();
            this.taskListWidget.destroy();
            this.resultWidget.destroy();
        }
    });

    ReviewPage.AsyncOperation = {
        LOAD_DATA : "LoadData"
    };

    ReviewPage.Tab = {
        HISTORY : "History",
        OPEN : "Open"        
    };               

    return ReviewPage;
});
