/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/core/CdesVoc",
    "cdes/document/DocumentHelper",
    "cdes/review/ReviewProtocolContext",
    "cdes/review/ReviewProtocolReferenceWidget",
    "cdes/review/ReviewProtocolVersionListWidget",
    "cdes/review/ReviewProtocolVersionWidget",
    "cdes/util/I18nHelper",
    "cdes/util/JobHelper",
    "cdes/widget/ContextBar",
    "cdes/widget/object/ObjectHeaderWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/IconTitlePane",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/TitlePane",
    "dijit/form/Button",
    "dijit/form/CheckBox",
    "dojo/dom-attr",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
    "dojo/topic"
], function(
    CdesVoc,
    DocumentHelper,
    ReviewProtocolContext,
    ReviewProtocolReferenceWidget,
    ReviewProtocolVersionListWidget,
    ReviewProtocolVersionWidget,
    I18nHelper,
    JobHelper,
    ContextBar,
    ObjectHeaderWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    DOMHelper,
    ErrorHelper,
    WidgetHelper,
    IconTitlePane,
    ContentWidget,
    TitlePane,
    Button,
    CheckBox,
    domAttr,
    domClass,
    domConstruct,
    domStyle,
    ioQuery,
    on,
    string,    
    declare,
    lang,
    i18n,
    topic
) {

    var className = "at.cdes.web.review.ReviewProtocol";

    var log = new TinyLog(className);

    var ReviewProtocol = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
            this.reload();
        },

        getWidgetId : function() {
            return "ReviewProtocol";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.reviewProtocolCaption, captionBarDiv, "cdesGeneralPageCaption");

            this.constructExportToPdfButton(captionBarDiv);

            // Back button            
            if (this.backPage != null) {
	    	    this.backButton = new Button({
	    		  label : i18n.back,
	    		  title : i18n.back,
	    		onClick : lang.hitch(this, this.goBack) 
	    	    });
	    	    domClass.add(this.backButton.domNode, "reviewProtocolBackButton");
	    	    domConstruct.place(this.backButton.domNode, captionBarDiv);
            }

            // Show all check box, with superAdminRight
            this.showAllDiv = domConstruct.create("div", null, null);
            domClass.add(this.showAllDiv, "refNodeOfPositionAbsolute reviewProtocolShowAllDiv invisible");
            this.showAllCheckBox = new CheckBox({
                label : i18n.reviewProtocolShowAllLabel,
                title : i18n.reviewProtocolShowAllLabel                
            });                
            domClass.add(this.showAllCheckBox.domNode, "fixedDialogWidget reviewProtocolShowAllCheckBox");
            domConstruct.place(this.showAllCheckBox.domNode, this.showAllDiv);            
            DOMHelper.createTextNode("div", i18n.reviewProtocolShowAllLabel, this.showAllDiv, "fixedDialogWidget reviewProtocolShowAllLabel");

            WidgetHelper.handleCheckBoxEvents(this.showAllCheckBox, lang.hitch(this, this.updateWidgetsFromData));

            domConstruct.place(this.showAllDiv, captionBarDiv);

            return captionBarDiv;
        },

        constructExportToPdfButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.reviewProtocolExportToPdfButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
            });
            
            domClass.add(button.domNode, "listButton");
            
            on(button, "click", lang.hitch(this, this.exportToPdf));

            domConstruct.place(button.domNode, captionBarDiv);
            
            return button;
        },

        exportToPdf : function() {
            var documentService = this.applicationContext.getService("documentService");

//            var columnToWidth = GridHelper.getColumnToWidth(this.listWidget.grid);
//            var sortSpecs = this.listWidget.getSortSpecs();
            
//            var searchModel = this.searchWidget.getSearchModel();

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var prevSeconds = DateHelper.getCurrentTimeSeconds();            
            topic.publish("message/info", i18n.reviewProtocolExportToPdfStarted);

            this.registerAsyncOperationStarted(ReviewProtocol.AsyncOperation.EXPORT_TO_PDF);
            documentService.triggerExportReviewProtocol(organisationPersonId, this.documentVersionId).then(lang.hitch(this, function(jobId) {
                JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
                    var postSeconds = DateHelper.getCurrentTimeSeconds();
		    topic.publish("message/ok", string.substitute(i18n.reviewProtocolExportToPdfFinished, {
                        duration : (postSeconds - prevSeconds).toFixed(2)
                    }));                            

                    var parameterString = ioQuery.objectToQuery({
                        jobId : jobId
                    });
                    return "/cdes-dojo-impl/download?" + parameterString;
                });
                
                this.registerAsyncOperationFinished(ReviewProtocol.AsyncOperation.EXPORT_TO_PDF);
            }), lang.hitch(this, function(err){         
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : ReviewProtocol.AsyncOperation.EXPORT_TO_PDF,
                            opName : "triggerExportReviewProtocol",
                           message : i18n.reviewProtocolExportFailed
                });                             
            })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Handling the results of executing triggerExportReviewProtocol failed", err);
            }));            
        },

        goBack : function() {
            this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute reviewProtocolContentDiv");

            this.objectHeaderTitlePane = this.constructObjectHeaderTitlePane();
            domClass.add(this.objectHeaderTitlePane.domNode, "");            
            domConstruct.place(this.objectHeaderTitlePane.domNode, contentDiv);

            this.versionTitlePane = this.constructVersionTitlePane();
            domClass.add(this.versionTitlePane.domNode, "");            
            domConstruct.place(this.versionTitlePane.domNode, contentDiv);

            this.referenceTitlePane = this.constructReferenceTitlePane();
            domClass.add(this.referenceTitlePane.domNode, "");
            domConstruct.place(this.referenceTitlePane.domNode, contentDiv);            

            this.statusImageTitlePane = this.constructStatusImageTitlePane();
            domConstruct.place(this.statusImageTitlePane.domNode, contentDiv);

            // Initially empty div, which acts as parent for all version-specific TitlePanes.            
            this.versionDiv = domConstruct.create("div", null, null);
            domClass.add(this.versionDiv, "reviewProtocolVersionDiv");
            domConstruct.place(this.versionDiv, contentDiv);            

            return contentDiv;
        },

        constructObjectHeaderTitlePane : function() {
            this.objectHeaderWidget = new ObjectHeaderWidget({
                applicationContext : this.applicationContext
            });                
            var objectHeaderTopDiv = this.objectHeaderWidget.getContainer();

            var titlePane = new TitlePane({
                       title   : "",
                       content : objectHeaderTopDiv,
                    toggleable : true,
                          open : false
            });

            return titlePane;
        },

        constructVersionTitlePane : function() {
            this.versionListWidget = new ReviewProtocolVersionListWidget({
                applicationContext : this.applicationContext
            });
            on(this.versionListWidget, "doReload", lang.hitch(this, this.reload));
            on(this.versionListWidget, "doLeave", lang.hitch(this, function() {
                this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
            }));
            
            var versionListTopDiv = this.versionListWidget.getContainer();

            var titlePane = new IconTitlePane({
                       title   : i18n.reviewProtocolVersionCaption,
                       content : versionListTopDiv,
                    toggleable : false,
                          open : true,
		postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "reviewProtocolVersionTitlePane");

            this.versionListWidget.restoreColumnWidths();

            return titlePane;            
        },

        constructReferenceTitlePane : function() {
            this.referenceWidget = new ReviewProtocolReferenceWidget({
                applicationContext : this.applicationContext
            });

            var referenceTopDiv = this.referenceWidget.getContainer();
            var titlePane = new IconTitlePane({
                       title   : i18n.reviewProtocolReferenceCaption,
                       content : referenceTopDiv,
                    toggleable : true,
                          open : false,
		postTitleClick : lang.hitch(this, this.postTitleClick)
            });

            return titlePane;            
        },

        constructStatusImageTitlePane : function() {
            this.statusImageTopDiv = domConstruct.create("div", null, null);            

            var titlePane = new IconTitlePane({
                       title   : i18n.reviewProtocolSvgStatusCaption,
                       content : this.statusImageTopDiv,
                    toggleable : true,
                          open : true,
		postTitleClick : lang.hitch(this, this.postTitleClick)                
            });            
            return titlePane;
        },

        postTitleClick : function() {
            this.resize();
        },

        resize : function(newSize) {
            var totalHeight;
            if (newSize != null) {
                this.totalHeightFromOutside = newSize.h;
                totalHeight = newSize.h;
            } else {
                totalHeight = this.totalHeightFromOutside;
            }
            if (totalHeight == null) {
                totalHeight = 0;
            }                

            var width = this.captionBarDiv.offsetWidth - 15;

            this.updateGridSizes();

            var contentHeight = totalHeight
                //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                - this.captionBarDiv.offsetHeight
                - 16;

            domStyle.set(this.contentDiv, "height", contentHeight + "px");
        },

        updateGridSizes : function() {
            var width = this.captionBarDiv.offsetWidth - 15;
            this.versionListWidget.resize({ w : width });
            this.referenceWidget.resize({w : width });
            for (var n = 0; this.versionWidgets != null && n < this.versionWidgets.length; n++) {
                this.versionWidgets[n].resize({ w : width });
            }                
        },            

        setData : function() {
        },

        reload : function() {
            //this.contextBar.reload();

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();            

            var documentService = this.applicationContext.getService("documentService");            
    	    this.registerAsyncOperationStarted(ReviewProtocol.AsyncOperation.LOAD);
	    documentService.getReviewProtocolData(organisationPersonId, this.documentVersionId).then(lang.hitch(this, function(reviewProtocolData) {
                this.reviewProtocolData = reviewProtocolData;
                this.updateWidgetsFromData();
                
		this.registerAsyncOperationFinished(ReviewProtocol.AsyncOperation.LOAD);
	    }), lang.hitch(this, function(err){
   		ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : ReviewProtocol.AsyncOperation.LOAD,
                            opName : "getReviewProtocolData",
                           message : i18n.reviewProtocolLoadFailed
   		}); 				
	    })).otherwise(
		lang.hitch(this, function(err) {
		    log.error("Handling the results of executing [getReviewProtocolData] failed", err);
		}));    		
        },

        updateWidgetsFromData : function() {
            var objectPlannerIdToActions = this.reviewProtocolData.objectPlannerIdToActions;
        	var globalActions = new Object();
			for (var n = 0; n < this.reviewProtocolData.globalActions.length; n++) {
				globalActions[this.reviewProtocolData.globalActions[n]] = true;
			}                        

            for (var n = 0; n < this.reviewProtocolData.versionJoins.length; n++) {
                this.reviewProtocolData.versionJoins[n]._objectPlannerIdToActions = objectPlannerIdToActions;
            }                    
            for (var n = 0; n < this.reviewProtocolData.referenceJoins.length; n++) {
                this.reviewProtocolData.referenceJoins[n]._objectPlannerIdToActions = objectPlannerIdToActions;
            }

            // Show showAll checkBox if user has the superAdmin permission
            var showAllDivClass = ("superAdminRight" in globalActions ? "" : "invisible");
            domClass.replace(this.showAllDiv, showAllDivClass, "invisible");
			if ("superAdminRight" in globalActions)
                this.showAll = this.showAllCheckBox.get("checked");

            // Sort document versions by uploaded
            this.reviewProtocolData.versionJoins.sort(function(versionJoinOne, versionJoinTwo) {
                return versionJoinOne.documentVersionUploaded - versionJoinTwo.documentVersionUploaded;
            });                    
            
            this.updateObjectHeaderTitlePaneTitle();

            this.objectHeaderWidget.setData({
                                baseJoin : this.reviewProtocolData.baseJoin,
                objectPlannerIdToActions : objectPlannerIdToActions
            });                    
            this.versionListWidget.setData({
                documentVersionId : this.documentVersionId,
                    globalActions : this.reviewProtocolData.globalActions,
                         baseJoin : this.reviewProtocolData.baseJoin,
                     versionJoins : this.reviewProtocolData.versionJoins                    
            });

            if (this.reviewProtocolData.referenceJoins != null && this.reviewProtocolData.referenceJoins.length > 0) {
                this.referenceTitlePane.set("title", i18n.reviewProtocolReferenceCaption);
            } else {
                this.referenceTitlePane.set("title", i18n.reviewProtocolNoReferencesLabel);
            }                
            this.referenceWidget.setData({
                referenceJoins : this.reviewProtocolData.referenceJoins                    
            });

            var idToVersionJoin = new Object();
            var anyNonDeleted = false;
            for (var n = 0; n < this.reviewProtocolData.versionJoins.length; n++) {
                idToVersionJoin[this.reviewProtocolData.versionJoins[n].documentVersionId] = this.reviewProtocolData.versionJoins[n];
                anyNonDeleted |= this.reviewProtocolData.versionJoins[n].documentVersionStatus != CdesVoc.DocumentVersionStatus.DELETED;
            }

            if (anyNonDeleted) {
                domClass.remove(this.statusImageTitlePane.domNode, "hidden");
            } else {
                domClass.add(this.statusImageTitlePane.domNode, "hidden");
            }                

            var context = new ReviewProtocolContext({
                                               globalActions : this.reviewProtocolData.globalActions,
                                                    baseJoin : this.reviewProtocolData.baseJoin,
                                                versionJoins : this.reviewProtocolData.versionJoins,
                                             idToVersionJoin : idToVersionJoin,
                            documentVersionIdToCellResultIds : this.reviewProtocolData.documentVersionIdToCellResultIds,
                                          idToCellResultJoin : this.reviewProtocolData.cellResultIdToResultJoin,
                                 cellResultIdToNodeResultMap : this.reviewProtocolData.cellResultIdToNodeResultIdToNodeResult,
                             nodeResultIdToPositionResultMap : this.reviewProtocolData.nodeResultIdToPositionResultIdToPositionResult,                    
                                      idToPositionResultJoin : this.reviewProtocolData.idToPositionResultJoin,
                                            idToResultOption : this.reviewProtocolData.idToResultOption,
                        documentVersionIdToNodePositionJoins : this.reviewProtocolData.documentVersionIdToNodePositionJoins,
                documentVersionIdToAttachedNodePositionJoins : this.reviewProtocolData.documentVersionIdToAttachedNodePositionJoins,
                documentVersionIdToCellConnectionResultJoins : this.reviewProtocolData.documentVersionIdToCellConnectionResultJoins,
                         documentVersionIdToEntryResultJoins : this.reviewProtocolData.documentVersionIdToEntryResultJoins,
                               positionResultIdToAttachments : this.reviewProtocolData.positionResultIdToAttachments,
                              nodeResultIdToOebbCommentJoins : this.reviewProtocolData.nodeResultIdToOebbCommentJoins,                
                                                     showAll : this.showAll
            });                    

            this.updateVersionWidgets({
                context : context
            });                    

            this.updateGridSizes();
            
            this.statusImageTopDiv.innerHTML = this.reviewProtocolData.svgImage;
            this.svgImageHeight = this.reviewProtocolData.svgImageHeight;                

            var childNodes = this.statusImageTopDiv.childNodes;
            var svgNode = null;
            for (var n = 0; childNodes != null && n < childNodes.length; n++) {
                if (childNodes[n].tagName != null && childNodes[n].tagName.toLowerCase() == "svg") {
                    svgNode = childNodes[n];
                }                        
            }
            // Calculated at server side.                
            domAttr.set(svgNode, "height", this.svgImageHeight);
            domAttr.set(svgNode, "viewBox", "0.0 " + (250.0 - this.svgImageHeight) + " 1060.0 " + this.svgImageHeight);            
        },

        updateObjectHeaderTitlePaneTitle : function() {
            var baseJoin = this.reviewProtocolData.baseJoin;

            var documentVersionName = baseJoin.documentVersionName;
            var projectName = baseJoin.projectName;
            var objectReleaseName = baseJoin.objectReleaseName;
            var objectPlannerReleaseArea = baseJoin.objectPlannerReleaseArea;            

            var kmFrom = baseJoin.objectReleaseStretchKmFrom;
            var kmTo = baseJoin.objectReleaseStretchKmTo;
            var kmLabel;
            if (kmFrom != null) {
                if (kmTo != null) {
                    kmLabel = kmFrom.toFixed(3) + " \u2015 " + kmTo.toFixed(3);
                } else {
                    kmLabel = kmFrom.toFixed(3);
                }                    
            } else {
                if (kmTo != null) {
                    kmLabel = kmTo.toFixed(3);
                } else {
                    kmLabel = "\u2015";
                }
            }

            var projectLimit = 30;
            var objectLimit = 30;
            var objectPlannerLimit = 30;
            var projectLabel = projectName.length > projectLimit ? projectName.substring(0, projectLimit) + "..." : projectName;
            var objectLabel = objectReleaseName.length > objectLimit ? objectReleaseName.substring(0, objectLimit) + "..." : objectReleaseName;
            var objectPlannerLabel = objectPlannerReleaseArea.length > objectPlannerLimit
            ? objectPlannerReleaseArea.substring(0, objectPlannerLimit) + "..." : objectPlannerReleaseArea;

            var objectHeaderLabel = string.substitute(i18n.reviewProtocolObjectHeaderTitle, {
                documentVersion : documentVersionName,
                        project : projectLabel,
                         object : objectLabel,
                  objectPlanner : objectPlannerLabel,
                             km : kmLabel                
            });
            this.objectHeaderTitlePane.set("title", objectHeaderLabel);            
        },

        updateVersionWidgets : function(params) {
            var context = params.context;

            domConstruct.empty(this.versionDiv);
            for (var n = 0; this.versionWidgets != null && n < this.versionWidgets.length; n++) {
                this.versionWidgets[n].destroy();
            }                

            // Fetch the versionJoins.  They are expected to be sorted correctly at this point.
            var versionJoins = context.getVersionJoins();

            this.versionWidgets = [];
            for (var n = 0; n < versionJoins.length; n++) {
                var versionJoin = versionJoins[n];

                var versionWidget = new ReviewProtocolVersionWidget({
                    applicationContext : this.applicationContext
                });
                var versionWidgetDiv = versionWidget.getContainer();

                var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                var reviewCycleCellName = I18nHelper.getCurrentLocaleString(versionJoin.reviewCycleCellName, locale);
                var suffix = this.getVersionTitlePaneTitleSuffix(versionJoin, versionJoins);
                var title = string.substitute(i18n.reviewProtocolVersionTitlePaneTitle, {
                    reviewCycleCellName : reviewCycleCellName,
                            versionPart : versionJoin.documentVersionVersionParta + versionJoin.documentVersionVersionPartSeperator + versionJoin.documentVersionVersionPartb,
                                 suffix : suffix                    
                });

                var titlePane = new IconTitlePane({
                           title   : title,
                           content : versionWidgetDiv,
                        toggleable : true,
                              open : (n>versionJoins.length-2)?true:false,
		    postTitleClick : lang.hitch(this, this.postTitleClick)
                });
                domConstruct.place(titlePane.domNode, this.versionDiv);                
                
                versionWidget.setData({
                    versionJoin : versionJoin,
                        context : context                    
                });                    

                this.versionWidgets.push(versionWidget);
            }          
        },

        getVersionTitlePaneTitleSuffix : function(versionJoin, versionJoins) {
            var suffix = "";
            var revisedCount = DocumentHelper.getRevisedCount(versionJoins, versionJoin.documentVersionId);
            if (versionJoin.documentVersionRevisedDocumentVersionId != null && versionJoin.documentVersionStatus != CdesVoc.DocumentVersionStatus.RELEASEDPOSITIV) {
                suffix += i18n.reviewProtocolTitleRevisionSuffix;
            } else if (revisedCount > 0 && versionJoin.documentVersionStatus == CdesVoc.DocumentVersionStatus.REPLACED) {
                suffix += i18n.reviewProtocolTitleReplacedSuffix;
            } else if (versionJoin.documentVersionReactivatedDocumentVersionId != null) {
                suffix += i18n.reviewProtocolTitleReactivedSuffix;                
            }
            return suffix;            
        },

        updateWidgetState : function() {

        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    ReviewProtocol.AsyncOperation = {
        EXPORT_TO_PDF : "ExportToPdf",
        LOAD : "Load"
    };

    return ReviewProtocol;
});
