/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/util/ActionHelper",
    "cdes/util/NameHelper",
    "clazzes/TinyLog",
    "clazzes/form/FancyButton",
    "clazzes/util/DOMHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dojo/dom-attr",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
    "dojo/string"
], function(
    ActionHelper,
    NameHelper,
    TinyLog,
    FancyButton,
    DOMHelper,
    ContentWidget,
    domAttr,
    domClass,
    domConstruct,
    domStyle,
    ioQuery,
    on,    
    declare,
    lang,
    i18n,
    string
) {

    var className = "at.cdes.web.widget.object.ObjectHeaderWidget";

    var log = new TinyLog(className);

    var ObjectHeaderWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ObjectHeaderWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            this.constructProjectLine(topDiv);            
            this.constructObjectLine(topDiv);
            this.constructObjectPlannerLine(topDiv);
            this.constructKmLine(topDiv);
            return topDiv;
        },

        constructProjectLine : function(topDiv) {
            this.projectTable = domConstruct.create("table", null, topDiv);

            var row = domConstruct.create("tr", null, this.projectTable);

            DOMHelper.createTextNode("td", i18n.project, row, "objectHeaderLabel");
            this.projectCell = domConstruct.create("td", null, row);
        },

        constructObjectLine : function(topDiv) {
            this.objectTable = domConstruct.create("table", null, topDiv);

            var row = domConstruct.create("tr", null, this.objectTable);

            DOMHelper.createTextNode("td", i18n.object, row, "objectHeaderLabel");            
            this.objectCell = domConstruct.create("td", null, row);
        },

        constructObjectPlannerLine : function(topDiv) {
            this.objectPlannerTable = domConstruct.create("table", null, topDiv);
            domClass.add(this.objectPlannerTable, "objectHeaderObjectPlannerTable");

            var rowOne = domConstruct.create("tr", null, this.objectPlannerTable);

            this.objectPlannerLabel = DOMHelper.createTextNode("td", i18n.objectPlanner, rowOne, "objectHeaderLabel objectHeaderObjectPlannerLabel");
            domAttr.set(this.objectPlannerLabel, "rowspan", "3");
            this.objectPlannerFirstCell = domConstruct.create("td", null, rowOne);
            domClass.add(this.objectPlannerFirstCell, "objectHeaderObjectPlannerFirstCell");

            var rowTwo = domConstruct.create("tr", null, this.objectPlannerTable);
            this.objectPlannerSecondCell = domConstruct.create("td", null, rowTwo);
            domClass.add(this.objectPlannerSecondCell, "objectHeaderObjectPlannerSecondCell");

            var rowThree = domConstruct.create("tr", null, this.objectPlannerTable);            
            this.objectPlannerThirdCell = domConstruct.create("td", null, rowThree);
            domClass.add(this.objectPlannerThirdCell, "objectHeaderObjectPlannerThirdCell");
        },

        constructKmLine : function(topDiv) {
            this.kmTable = domConstruct.create("table", null, topDiv);

            var row = domConstruct.create("tr", null, this.kmTable);

            DOMHelper.createTextNode("td", i18n.objectHeaderKmFromToLabel, row, "objectHeaderLabel");
            this.kmCell = domConstruct.create("td", null, row);
        },

        setData : function(params) {
            this.baseJoin = params.baseJoin;
            this.objectPlannerIdToActions = params.objectPlannerIdToActions;
            this.reload();            
        },

        reload : function() {
            this.updateWidgetsFromData();
        },

        updateWidgetsFromData : function() {
            /*
            this.projectCell
            this.objectdCell
            this.objectPlannerFirstCell
            this.objectPlannerSecondCell
            this.objectPlannerThirdCell
            this.kmCell
            */

            // Project
            domConstruct.empty(this.projectCell);
            DOMHelper.createTextNode("span", this.baseJoin.projectCode, this.projectCell, "objectHeaderBoldData");
            DOMHelper.createTextNode("span", " " + this.baseJoin.projectName, this.projectCell, "objectHeaderData");

            // Object
            domConstruct.empty(this.objectCell);
     		var objectTypeSuffix = (this.baseJoin.objectTypeId != null ? this.baseJoin.objectTypeCode : "");
     		var objectReleaseCode =  this.baseJoin.objectReleaseCode + objectTypeSuffix;
            DOMHelper.createTextNode("span", objectReleaseCode, this.objectCell, "objectHeaderBoldData");
            DOMHelper.createTextNode("span", " " + this.baseJoin.objectReleaseName, this.objectCell, "objectHeaderData");

            // ObjectPlanner
            domConstruct.empty(this.objectPlannerFirstCell);
            DOMHelper.createTextNode("span", this.baseJoin.objectPlannerReleaseCode, this.objectPlannerFirstCell, "objectHeaderData");
            DOMHelper.createTextNode("span", " " + this.baseJoin.objectPlannerReleaseArea, this.objectPlannerFirstCell, "objectHeaderData");

    	    if (this.applicationContext.isActionAllowedForProject("showObjectPlanner")) {
    		var showObjectPlannerButton = this.constructShowObjectPlannerButton(this.baseJoin, "showObjectPlanner");
    		domConstruct.place(showObjectPlannerButton.domNode, this.objectPlannerFirstCell);
    	    } else if (ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, this.baseJoin.objectPlannerId, "showObjectPlannerOPContext")) {
    		var showObjectPlannerButton = this.constructShowObjectPlannerButton(this.baseJoin, "showObjectPlannerOPContext");
    		domConstruct.place(showObjectPlannerButton.domNode, this.objectPlannerFirstCell);
    	    }            

            // ReviewCycleInstance
            domConstruct.empty(this.objectPlannerSecondCell);
            var reviewCycleInstanceLabel = string.substitute(i18n.objectHeaderReviewCycleInstanceLabel, {
                reviewCycleInstanceName : this.baseJoin.reviewCycleInstanceReleasedName
            });
            DOMHelper.createTextNode("span", reviewCycleInstanceLabel, this.objectPlannerSecondCell, "objectHeaderDataSmall");

            // Planner
            domConstruct.empty(this.objectPlannerThirdCell);
            var organisationName = this.baseJoin.plannerOrganisationId != null ? this.baseJoin.plannerOrganisationName : i18n.objectHeaderNoPlannerDefined;
            var personCommonName = NameHelper.getPersonInverseCommonName(this.baseJoin, "plannerPerson");
            var plannerComment = this.baseJoin.plannerParticipationComment != null && this.baseJoin.plannerParticipationComment.trim().length > 0
                 ? " \u2015 " + this.baseJoin.plannerParticipationComment : "";
            var plannerLabel = string.substitute(i18n.objectHeaderPlannerLabel, {
                   organisationName : organisationName,
                   personCommonName : personCommonName,
                     plannerComment : plannerComment                
            });
            DOMHelper.createTextNode("span", plannerLabel, this.objectPlannerThirdCell, "objectHeaderDataSmall");

            // km
            domConstruct.empty(this.kmCell);
            var kmFrom = this.baseJoin.objectReleaseStretchKmFrom;
            var kmTo = this.baseJoin.objectReleaseStretchKmTo;
            var kmLabel;
            if (kmFrom != null) {
                if (kmTo != null) {
                    kmLabel = kmFrom.toFixed(3) + " \u2015 " + kmTo.toFixed(3);
                } else {
                    kmLabel = kmFrom.toFixed(3);
                }                    
            } else {
                if (kmTo != null) {
                    kmLabel = kmTo.toFixed(3);
                } else {
                    kmLabel = "\u2015";
                }
            }
            DOMHelper.createTextNode("span", kmLabel, this.kmCell, "objectHeaderData");
        },

    	constructShowObjectPlannerButton : function(joinDto, actionName) {
            var button = new FancyButton({
                    title : i18n.planDeliverListShowObjectPlannerButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 showObjectPlanner"
            });
            
            domClass.add(button.domNode, "listButton objectHeaderObjectPlannerButton");
            
            on(button, "click", lang.hitch(this, function() {
    	        this.doShowObjectPlanner(joinDto, actionName);
            }));

            return button;
    	},

    	doShowObjectPlanner : function(joinDto, actionName) {
//            window.open("cdes-bs/plan/objekte/" + joinDto.objectId + "/v" + joinDto.objectListReleaseVersion + "/anzeigen");

              var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
              var queryParamsString = ioQuery.objectToQuery({
                locale : locale,
                ts : dojoConfig.tabSessionId
              });

              var hashParamsString = ioQuery.objectToQuery({
                objblatt : joinDto.objectPlannerReleaseId
              });

            var newWindow = window.open("/cdes-bs.html?" + queryParamsString + "#/plan/objekte/anzeigen/plan/" + this.baseJoin.documentVersionId + "?" + hashParamsString);
            setTimeout(lang.hitch(this, function(){
                            newWindow.document.title = this.baseJoin.documentVersionName;
                        }), 500);

//              window.open("/cdes-bs.html?locale=de&ts=Admin#/plan/objekte/5318468/v23/anzeigen?objblatt=7807512");

        /*
            window.parent.postMessage({
                action : "routerPush",
                routerObj : {
                    name : "objectPlannerReleaseShow",
                    params : {
                        objectId : joinDto.objectId,
                        version : "v" + joinDto.objectListReleaseVersion,
                        objectPlannerReleaseId : joinDto.objectPlannerReleaseId
                    }
                }
            });
            */

            /*
    		document.location.href = "/cdes/app?service=SecureDirectService/1/DocumentList/" + actionName + "/$SecureDirectLink&sp=" 
    			+ joinDto.objectPlannerReleaseId + "&ts=" + dojoConfig.tabSessionId;
//http://localhost:8081/cdes/app?service=SecureDirectService/1/DocumentList/showObjectPlanner/$SecureDirectLink&sp=7744788&ts=Admin
*/
    	},

        updateWidgetState : function() {

        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    return ObjectHeaderWidget;
});
