/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationOrderEdit
////i18n-prefix = planningNotificationOrderEdit



define([ "cdes/core/CdesVoc",
	"cdes/planning/order/PlanningNotificationOrderChooseDialog",
	"cdes/planning/order/PlanningNotificationOrderListWidget",
	"cdes/planning/util/PlanningNotificationHelper",
	"cdes/widget/CalendarSpinner",
	"cdes/widget/ContextBar",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateTimeSpinBox",
	"clazzes/form/FancyButton",
	"clazzes/form/MultiWidget",
	"clazzes/form/NumberSpinner",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ChooseDialog",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/InfoDialog",
	"dijit/form/Button",
	"dijit/form/CheckBox",
	"dijit/form/ComboBox",
	"dijit/form/Select",
	"dijit/form/SimpleTextarea",
	"dijit/form/Textarea",
	"dijit/form/ValidationTextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CdesVoc,
			PlanningNotificationOrderChooseDialog,
			PlanningNotificationOrderListWidget,
			PlanningNotificationHelper,
			CalendarSpinner,
			ContextBar,
			TinyLog,
			DateTimeSpinBox,
			FancyButton,
			MultiWidget,
			NumberSpinner,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ChooseDialog,
			ContentWidget,
			InfoDialog,
			Button,
			CheckBox,
			ComboBox,
			Select,
			SimpleTextarea,
			Textarea,
			ValidationTextBox,
			domClass,
			domConstruct,
			domStyle,
			on,
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.order.PlanningNotificationOrderEditWidget";

	var log = new TinyLog(className);

	var PlanningNotificationOrderEditWidget = declare(className, ContentWidget, {

		// Remaining TODOs:
		// - event handling (do the setter-functions trigger events triggering updateWidgetState?)	
		// - hide tags Select depending on project config

		constructor : function(params) {
			lang.mixin(this, params);
			this.siteTypeOptions = [];

			this.topDiv = this.constructTopDiv();
			this.updateWidgetState();
		},

		getWidgetId : function() {
			return "PlanningNotificationOrderEditWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		setEditInfo : function(editInfo) {
			this.projectIdToProject = editInfo.projectIdToProject;            
			this.projectIdToProjectConfig = editInfo.projectIdToProjectConfig;
			this.projectIdToPlanningNotifications = editInfo.projectIdToPlanningNotifications;
			this.idToSubjectArea = editInfo.idToSubjectArea;
			this.idToStatutoryDuty = editInfo.idToStatutoryDuty;
			this.idToPersonInCharge = editInfo.idToPersonInCharge;
			this.idToWorkflowEntityStatus = editInfo.idToWorkflowEntityStatus;		    
			this.idToTag = editInfo.idToTag;
			this.idToSiteType = editInfo.idToSiteType;

			this.initializeFields();
		},	    

		handleProjectSelectChange : function() {
			var projectId = this.projectSelect.get("value");
			if (projectId == null || projectId == "") {
				this.planningNotificationSelect.set("options", []);
				this.planningNotificationSelect.set("value", null);
//				this.planningNotificationSelect._setDisplay("");  // See https://bugs.dojotoolkit.org/ticket/17081; PlanningNotificationHelper
			} else if (this.lastProjectId == null || this.lastProjectId != projectId) {
				var planningNotifications = this.projectIdToPlanningNotifications[projectId];
				if (planningNotifications != null){
		            planningNotifications.sort(function(dataOne, dataTwo) {
		                if (dataOne.title == null) {
		                    return 1;
		                } else if (dataTwo.title == null) {
		                    return -1;
		                } else {
		                    return dataOne.title.localeCompare(dataTwo.title);
		                }                       
		            });                 
				}
				
				var planningNotificationOptions = [];
				if (this.mode == ContentWidget.Mode.CREATE)
					planningNotificationOptions = [{ value : CdesVoc.PLEASE_CHOOSE, label : i18n.pleaseChoose }];
				for (var n = 0; planningNotifications != null && n < planningNotifications.length; n++) {
					planningNotificationOptions.push({ value : planningNotifications[n].id, label : planningNotifications[n].title });		    
				}
				if (planningNotificationOptions.length > 0) {
					this.planningNotificationSelect.set("options", planningNotificationOptions);
					WidgetHelper.setSelectValue(this.planningNotificationSelect, planningNotificationOptions[0].value);
				}		    
				var allowedProjectActions = this.projectIdToAllowedActions ? this.projectIdToAllowedActions[projectId] : null;
				if ((allowedProjectActions && allowedProjectActions.includes("reassignPlanningNotificationToOrder")) || this.mode == ContentWidget.Mode.CREATE)
					this.planningNotificationSelect.set("disabled", false);
				else
					this.planningNotificationSelect.set("disabled", true);
				
				if (!this.workflowHasResults || this.mode == ContentWidget.Mode.CREATE)
					this.textTextArea.set("disabled", false);
				else
					this.textTextArea.set("disabled", true);
			}

			this.lastProjectId = projectId;		
			this.updateWidgetState();
		},	    

		siteTypeEditConstructorFct : function() {
			var siteTypeOptions = [];
			for (var id in this.idToSiteType) {
				siteTypeOptions.push({ value : id, label : this.idToSiteType[id].name });		
			}		

			var select = new Select({
				options : siteTypeOptions
			});

			return select;            
		},

		siteTypeEditGetterFct : function(widget) {
			return widget.get("value");
		},

		siteTypeEditSetterFct : function(widget, value) {
			widget.set("value", value);
		},	    

		initializeFields : function() {
			// SubjectArea	    
            var subjectAreaOptions = PlanningNotificationHelper.getSelectOptionsForMap(this.idToSubjectArea, "name",
                                                                                          { value : CdesVoc.PLEASE_CHOOSE, label : i18n.pleaseChoose });
			WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.subjectAreaSelect, subjectAreaOptions);

			// StatutoryDuty
			var statutoryDutyOptions = PlanningNotificationHelper.getSelectOptionsForMap(this.idToStatutoryDuty, "name", null, "Keine");
			WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.statutoryDutySelect, statutoryDutyOptions);

			// PersonInCharge
            var personInChargeOptions = PlanningNotificationHelper.getSelectOptionsForMap(this.idToPersonInCharge, "name",
                                                                                          { value : CdesVoc.PLEASE_CHOOSE, label : i18n.pleaseChoose });
			WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.personInChargeSelect, personInChargeOptions);

			// SiteType
/*			var lineInfos = this.siteTypeMultiWidget.get("lineInfos");
			for (var n = 0; n < lineInfos.length; n++) {
				WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(lineInfos[n].widget, this.siteTypeOptions);
			}*/		

			/*
	    // Status
	    var statusOptions = [];
	    for (var statusId in this.idToWorkflowEntityStatus) {
		var status = this.idToWorkflowEntityStatus[statusId];
		statusOptions.push({ value : statusId, label : status.name });		
	    }

	    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.stateSelect, statusOptions);
			 */  
		},

		constructTopDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationOrderEditContentDiv");

			// ProjectSelect
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderProjectLabel, contentDiv, "propertyLabel planningNotificationOrderEditProjectLabel");
			this.projectSelect = new Select({
				label : i18n.planningNotificationOrderProjectLabel,
				/*		   title : i18n.planningNotificationOrderEditProjectToolTip, */ // Removed according to ÖBB feedback
				disabled : this.mode != ContentWidget.Mode.CREATE || !this.mayChangePlanningNotification
			});
			domClass.add(this.projectSelect.domNode, "fixedDialogWidget planningNotificationOrderEditProjectSelect");
			domConstruct.place(this.projectSelect.domNode, contentDiv);
			WidgetHelper.handleSelectEvents(this.projectSelect, lang.hitch(this, this.handleProjectSelectChange));

			// SubjectAreaSelect
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderSubjectAreaLabel, contentDiv, "propertyLabel planningNotificationOrderEditSubjectAreaLabel");
			this.subjectAreaSelect = new Select({
				label : i18n.planningNotificationOrderSubjectAreaLabel
				/*		title : i18n.planningNotificationOrderSubjectAreaToolTip */
			});
			domClass.add(this.subjectAreaSelect.domNode, "fixedDialogWidget planningNotificationOrderEditSubjectAreaSelect");
			domConstruct.place(this.subjectAreaSelect.domNode, contentDiv);
			WidgetHelper.handleSelectEvents(this.subjectAreaSelect, lang.hitch(this, this.updateWidgetState));

			// PlanningNotificationCombobox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderEditPlanningNotificationLabel, contentDiv,
			"propertyLabel planningNotificationOrderEditPlanningNotificationLabel");
			this.planningNotificationSelect = new Select({
				label : i18n.planningNotificationOrderPlanningNotificationLabel,
				/*		   title : i18n.planningNotificationOrderPlanningNotificationToolTip, */  // Removed according to ÖBB feedback
				disabled : !this.mayChangePlanningNotification
			});
			domClass.add(this.planningNotificationSelect.domNode, "fixedDialogWidget planningNotificationOrderEditPlanningNotificationSelect");
			domConstruct.place(this.planningNotificationSelect.domNode, contentDiv);
			WidgetHelper.handleSelectEvents(this.planningNotificationSelect, lang.hitch(this, this.updateWidgetState));

			// AuthorizedInspectorTextBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderAuthorizedInspectorLabel, contentDiv,
			"propertyLabel planningNotificationOrderEditAuthorizedInspectorLabel");
			this.authorizedInspectorTextBox = new ValidationTextBox({
				label : i18n.planningNotificationOrderAuthorizedInspectorLabel,
				/*		    title : this.extract ? i18n.planningNotificationOrderExtractAuthorizedInspectorTooltip : i18n.planningNotificationOrderAuthorizedInspectorToolTip,*/ // Removed on ÖBB Request		
				maxLength : 255		
			});
			domClass.add(this.authorizedInspectorTextBox.domNode, "fixedDialogWidget planningNotificationOrderEditAuthorizedInspectorTextBox");
			domConstruct.place(this.authorizedInspectorTextBox.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.authorizedInspectorTextBox, lang.hitch(this, this.updateWidgetState));

			// SerialNumberNumberSpinner
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderSerialNumberLabel, contentDiv, "propertyLabel planningNotificationOrderEditSerialNumberLabel");
			this.serialNumberSpinner = new NumberSpinner({
				label : i18n.planningNotificationOrderSerialNumberLabel,
				title : i18n.planningNotificationOrderSerialNumberToolTip,
				disabled : true,
				omitThousandSeparator : true
			});
			domClass.add(this.serialNumberSpinner.domNode, "fixedDialogWidget planningNotificationOrderEditSerialNumberSpinner");
			domConstruct.place(this.serialNumberSpinner.domNode, contentDiv);
			WidgetHelper.handleSpinnerEvents(this.serialNumberSpinner, lang.hitch(this, this.updateWidgetState));

			/*
	    // StateSelect
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStateLabel, contentDiv, "propertyLabel planningNotificationOrderEditStateLabel");
	    this.stateSelect = new Select({
		   label : i18n.planningNotificationOrderStateLabel,
		   title : i18n.planningNotificationOrderStateToolTip,
		disabled : true		
	    });
	    domClass.add(this.stateSelect.domNode, "fixedDialogWidget planningNotificationOrderEditStateSelect");
	    domConstruct.place(this.stateSelect.domNode, contentDiv);
	    WidgetHelper.handleSelectEvents(this.stateSelect, lang.hitch(this, this.updateWidgetState));
			 */

			// InvalidatedCheckBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderInvalidatedLabel, contentDiv, "fixedDialogWidget planningNotificationOrderEditInvalidatedLabel");
			this.invalidatedCheckBox = new CheckBox({
				label : i18n.planningNotificationOrderInvalidatedLabel
				/*		title : i18n.planningNotificationOrderInvalidatedToolTip */  // Removed according to ÖBB feedback
			});
			domClass.add(this.invalidatedCheckBox.domNode, "fixedDialogWidget planningNotificationOrderEditInvalidatedCheckBox");
			domConstruct.place(this.invalidatedCheckBox.domNode, contentDiv);
			WidgetHelper.handleCheckBoxEvents(this.invalidatedCheckBox, lang.hitch(this, this.updateWidgetState));

			WidgetHelper.handleCheckBoxEvents(this.invalidatedCheckBox, lang.hitch(this, function() {
				var checked = this.invalidatedCheckBox.get("checked");

				if (checked) {
					InfoDialog.showWarning({
						title : i18n.planningNotificationOrderInvalidateWarningCaption,
						message : i18n.planningNotificationOrderInvalidateWarningMessage
					});                        
				}                    

				log.info("Checked: [" + checked + "]");                
			}));                

			// TextTextarea
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderTextLabel, contentDiv, "propertyLabel planningNotificationOrderEditTextLabel");
			this.textTextArea = new SimpleTextarea({
				label : i18n.planningNotificationOrderTextLabel
				/*		title : i18n.planningNotificationOrderTextToolTip */ // Removed according to ÖBB feedback
			});
			domClass.add(this.textTextArea.domNode, "fixedDialogWidget planningNotificationOrderEditTextTextArea");
			domConstruct.place(this.textTextArea.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.textTextArea, lang.hitch(this, this.updateWidgetState));
			WidgetHelper.setMustField(this.textTextArea, true);


			// ReferenceMultiWidget
			var referenceWidgetConstructorFct = lang.hitch(this, function() {

			});		

			DOMHelper.createTextNode("div", i18n.planningNotificationOrderEditReferenceLabel, contentDiv, "propertyLabel planningNotificationOrderEditReferenceLabel");

			var newReferenceButton = new FancyButton({
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton"
			});
			domClass.add(newReferenceButton.domNode, "fixedDialogWidget planningNotificationOrderEditAddReferenceButton");
			on(newReferenceButton, "click", lang.hitch(this, this.addNewReference));

			domConstruct.place(newReferenceButton.domNode, contentDiv);

			this.referenceListWidget = new PlanningNotificationOrderListWidget({
				applicationContext : this.applicationContext,
				showActions : true,
				sortStorageKey : "/planningNotificationOrderReference/sort",
				mode : PlanningNotificationOrderListWidget.Mode.CHOOSE_REFERENCE,		
				gridId : "PlanningNotificationOrderReferenceGrid",
				documentCaption : i18n.planningNotificationOrderEditReferenceDocumentCaption,
				planningNotificationOrderTagsEnabled : false
			});
			this.referenceListWidgetDiv = this.referenceListWidget.getContainer();
			domClass.add(this.referenceListWidgetDiv, "fixedDialogWidget planningNotificationOrderEditReferenceList");	    
			domConstruct.place(this.referenceListWidgetDiv, contentDiv);

			on(this.referenceListWidget, "planningNotificationOrderRemoved", lang.hitch(this, function(workflowEntityId) {
				var referenceInfos = this.orderJoin.referenceInfos;
				for (var n = 0; referenceInfos != null && n < referenceInfos.length; n++) {
					if (referenceInfos[n].planningNotificationOrder.workflowEntityId == workflowEntityId) {
						referenceInfos.splice(n, 1);
						break;			
					}			
				}		    

				this.updateReferenceGrid();
			}));		

			this.referenceListWidget.resize({ w : 1095, h : 150 });
			this.referenceListWidget.setData({ planningNotificationOrderInfos : [], columnSettings : new Object() });

			/* TODO reference
	    this.referenceMultiWidget = new MultiWidget({
			  addButtonLabel : i18n.planningNotificationOrderEditAddTagLabel,
		      addButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton",
		       addButtonCssClass : "multiWidgetAddButton",
		       deleteButtonLabel : i18n.planningNotificationOrderEditRemoveTagLabel,
		   deleteButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton",
		      lineWidgetCssClass : "planningNotificationOrderEditReferenceMultiWidgetLineWidget",
		lineRemoveButtonCssClass : "multiWidgetLineRemoveButton",
			  constructorFct : referenceWidgetConstructorFct,
			       getterFct : function(widget) { return widget.get("value"); },
			       setterFct : function(widget, value) { widget.set("value", value); }
	    });
	    domClass.add(this.referenceMultiWidget.domNode, "fixedDialogWidget planningNotificationOrderEditReferenceMultiWidget");
	    domConstruct.place(this.referenceMultiWidget.domNode, contentDiv);
			 */

			/*	    
	    // ReferenceMultiWidget
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderEditReferenceLabel, contentDiv, "propertyLabel planningNotificationOrderEditReferenceLabel");
	    this.reference = new MultiWidget({
				  addButtonLabel : addLabel,
			      addButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton",
			       addButtonCssClass : addButtonCssClass,
			       deleteButtonLabel : deleteLabel,
			   deleteButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton",
			      lineWidgetCssClass : lineWidgetCssClass,
			lineRemoveButtonCssClass : lineRemoveButtonCssClass,			
				  constructorFct : constructorFct,
				       getterFct : getterFct,
				       setterFct : setterFct
//	       label : i18n.planningNotificationOrderEditReferenceLabel,
//		title : i18n.planningNotificationOrderEditReferenceToolTip
	    });
	    domClass.add(this.reference.domNode, "fixedDialogWidget planningNotificationOrderEditReference");
	    domConstruct.place(this.reference.domNode, contentDiv);
	    WidgetHelper.(this.reference, lang.hitch(this, this.updateWidgetState));
			 */


			// StatutoryDutySelect
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyLabel, contentDiv, "propertyLabel planningNotificationOrderEditStatutoryDutyLabel");
			this.statutoryDutySelect = new Select({
				label : i18n.planningNotificationOrderStatutoryDutyLabel,
				title : i18n.planningNotificationOrderEditStatutoryDutyToolTip
			});
			domClass.add(this.statutoryDutySelect.domNode, "fixedDialogWidget planningNotificationOrderEditStatutoryDutySelect");
			domConstruct.place(this.statutoryDutySelect.domNode, contentDiv);
			WidgetHelper.handleSelectEvents(this.statutoryDutySelect, lang.hitch(this, this.updateWidgetState));

			// StatutoryDutyFromDateTimeSpinBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnStatutoryDutyFromLabel, contentDiv,
			"propertyLabel planningNotificationOrderEditStatutoryDutyFromLabel");
			this.statutoryDutyFromSpinner = new CalendarSpinner({
				label : i18n.planningNotificationOrderColumnStatutoryDutyFromLabel,
				/*			    title : i18n.planningNotificationOrderColumnStatutoryDutyFromToolTip,*/ // Removed because of ÖBB comments
				pattern : i18n.datePattern,
				timeZone : this.applicationContext.getTimeZone(),
				dndEnabled : false,
				rowObjectToString : null		
			});
			domClass.add(this.statutoryDutyFromSpinner.domNode, "fixedDialogWidget planningNotificationOrderEditStatutoryDutyFromSpinner");
			domConstruct.place(this.statutoryDutyFromSpinner.domNode, contentDiv);
			WidgetHelper.handleSpinnerEvents(this.statutoryDutyFromSpinner, lang.hitch(this, this.updateWidgetState));

			// StatutoryDutyToDateTimeSpinBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnStatutoryDutyToLabel, contentDiv,
			"propertyLabel planningNotificationOrderEditStatutoryDutyToLabel");
			this.statutoryDutyToSpinner = new CalendarSpinner({
				label : i18n.planningNotificationOrderColumnStatutoryDutyToLabel,
				/*			    title : i18n.planningNotificationOrderColumnStatutoryDutyToToolTip,*/ // Removed because of ÖBB comments
				pattern : i18n.datePattern,
				timeZone : this.applicationContext.getTimeZone(),
				dndEnabled : false,
				rowObjectToString : null		
			});
			domClass.add(this.statutoryDutyToSpinner.domNode, "fixedDialogWidget planningNotificationOrderEditStatutoryDutyToSpinner");
			domConstruct.place(this.statutoryDutyToSpinner.domNode, contentDiv);
			WidgetHelper.handleSpinnerEvents(this.statutoryDutyToSpinner, lang.hitch(this, this.updateWidgetState));

			// StatutoryDutyIntervalNumberSpinner
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnStatutoryDutyIntervalLabel, contentDiv,
			"propertyLabel planningNotificationOrderEditStatutoryDutyIntervalLabel");
			this.statutoryDutyIntervalSpinner = new NumberSpinner({
				label : i18n.planningNotificationOrderColumnStatutoryDutyIntervalLabel,
				/*		title : i18n.planningNotificationOrderSearchIntervalToolTip*/
				title : i18n.inMonths,
				omitThousandSeparator : true
			});
			domClass.add(this.statutoryDutyIntervalSpinner.domNode, "fixedDialogWidget planningNotificationOrderEditStatutoryDutyIntervalSpinner");
			domConstruct.place(this.statutoryDutyIntervalSpinner.domNode, contentDiv);
			WidgetHelper.handleSpinnerEvents(this.statutoryDutyIntervalSpinner, lang.hitch(this, this.updateWidgetState));

			// LeadTimeNumberSpinner
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderColumnLeadTimeLabel, contentDiv, "propertyLabel planningNotificationOrderEditLeadTimeLabel");
			this.leadTimeSpinner = new NumberSpinner({
				label : i18n.planningNotificationOrderColumnLeadTimeLabel,
				title : i18n.planningNotificationOrderSearchLeadTimeToolTip,
				title : i18n.inMonths,
				omitThousandSeparator : true		
			});
			domClass.add(this.leadTimeSpinner.domNode, "fixedDialogWidget planningNotificationOrderEditLeadTimeSpinner");
			domConstruct.place(this.leadTimeSpinner.domNode, contentDiv);
			WidgetHelper.handleSpinnerEvents(this.leadTimeSpinner, lang.hitch(this, this.updateWidgetState));

			// SiteType	    
/*			DOMHelper.createTextNode("div", i18n.planningNotificationOrderSiteTypeLabel, contentDiv, "propertyLabel planningNotificationOrderEditSiteTypeLabel");

			this.siteTypeMultiWidget = new MultiWidget({
				addButtonLabel : i18n.planningNotificationOrderSiteTypeAddLabel,
				addButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton",
				addButtonCssClass : "planningNotificationOrderEditSiteTypeAddButton",
				deleteButtonLabel : "deleteLabel",
				deleteButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton",
				lineWidgetCssClass : "planningNotificationOrderEditSiteTypeLineWidget",
				lineRemoveButtonCssClass : "planningNotificationOrderEditSiteTypeRemoveButton",			
				constructorFct : lang.hitch(this, this.siteTypeEditConstructorFct),
				getterFct : lang.hitch(this, this.siteTypeEditGetterFct),
				setterFct : lang.hitch(this, this.siteTypeEditSetterFct)
			});

			domClass.add(this.siteTypeMultiWidget.domNode, "fixedDialogWidget planningNotificationOrderSiteTypeMultiWidget");
			domConstruct.place(this.siteTypeMultiWidget.domNode, contentDiv);*/

			// StatutoryDutyExpiredCheckBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyExpiredLabel, contentDiv,
			"fixedDialogWidget planningNotificationOrderEditStatutoryDutyExpiredLabel");
			this.statutoryDutyExpiredCheckBox = new CheckBox({
				label : i18n.planningNotificationOrderStatutoryDutyExpiredLabel,
				title : i18n.planningNotificationOrderStatutoryDutyExpiredToolTip
			});
			domClass.add(this.statutoryDutyExpiredCheckBox.domNode, "fixedDialogWidget planningNotificationOrderEditStatutoryDutyExpiredCheckBox");
			domConstruct.place(this.statutoryDutyExpiredCheckBox.domNode, contentDiv);
			WidgetHelper.handleCheckBoxEvents(this.statutoryDutyExpiredCheckBox, lang.hitch(this, this.updateWidgetState));

			// EnvironmentallyRelevantCheckBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderEnvironmentallyRelevantLabel, contentDiv,
			"fixedDialogWidget planningNotificationOrderEditEnvironmentallyRelevantLabel");
			this.environmentallyRelevantCheckBox = new CheckBox({
				label : i18n.planningNotificationOrderEnvironmentallyRelevantLabel 
				/*		title : i18n.planningNotificationOrderSubmitAuthorityToolTip */ // Removed on ÖBB Request
			});
			domClass.add(this.environmentallyRelevantCheckBox.domNode, "fixedDialogWidget planningNotificationOrderEditEnvironmentallyRelevantCheckBox");
			domConstruct.place(this.environmentallyRelevantCheckBox.domNode, contentDiv);
			WidgetHelper.handleCheckBoxEvents(this.environmentallyRelevantCheckBox, lang.hitch(this, this.updateWidgetState));

			// SubmitAuthorityCheckBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderSubmitAuthorityLabel, contentDiv,
			"fixedDialogWidget planningNotificationOrderEditSubmitAuthorityLabel");
			this.submitAuthorityCheckBox = new CheckBox({
				label : i18n.planningNotificationOrderSubmitAuthorityLabel 
				/*		title : i18n.planningNotificationOrderSubmitAuthorityToolTip */ // Removed on ÖBB Request
			});
			domClass.add(this.submitAuthorityCheckBox.domNode, "fixedDialogWidget planningNotificationOrderEditSubmitAuthorityCheckBox");
			domConstruct.place(this.submitAuthorityCheckBox.domNode, contentDiv);
			WidgetHelper.handleCheckBoxEvents(this.submitAuthorityCheckBox, lang.hitch(this, this.updateWidgetState));

			// PersonInChargeSelect
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderPersonInChargeLabel, contentDiv, "propertyLabel planningNotificationOrderEditPersonInChargeLabel");
			this.personInChargeSelect = new Select({
				label : i18n.planningNotificationOrderPersonInChargeLabel,
				title : i18n.planningNotificationOrderPersonInChargeToolTip
			});
			domClass.add(this.personInChargeSelect.domNode, "fixedDialogWidget planningNotificationOrderEditPersonInChargeSelect");
			domConstruct.place(this.personInChargeSelect.domNode, contentDiv);
			WidgetHelper.handleSelectEvents(this.personInChargeSelect, lang.hitch(this, this.updateWidgetState));

			// DocumentPositionTextBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPositionLabel, contentDiv,
			"propertyLabel planningNotificationOrderEditDocumentPositionLabel");
			this.documentPositionTextBox = new SimpleTextarea({
				label : i18n.planningNotificationOrderDocumentPositionLabel,
				title : this.extract ? i18n.planningNotificationOrderExtractDocumentPositionTooltip : i18n.planningNotificationOrderDocumentPositionToolTip,
				maxLength : 400
			});
			domClass.add(this.documentPositionTextBox.domNode, "fixedDialogWidget planningNotificationOrderEditDocumentPositionTextBox");
			domConstruct.place(this.documentPositionTextBox.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.documentPositionTextBox, lang.hitch(this, this.updateWidgetState));

			// DocumentPageTextBox
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPageLabel, contentDiv, "propertyLabel planningNotificationOrderEditDocumentPageLabel");
			this.documentPageTextBox = new ValidationTextBox({
				label : i18n.planningNotificationOrderDocumentPageLabel,
				title : this.extract ? i18n.planningNotificationOrderExtractDocumentPageToolTip : i18n.planningNotificationOrderDocumentPageToolTip,
				maxLength : 255	
			});
			domClass.add(this.documentPageTextBox.domNode, "fixedDialogWidget planningNotificationOrderEditDocumentPageTextBox");
			domConstruct.place(this.documentPageTextBox.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.documentPageTextBox, lang.hitch(this, this.updateWidgetState));

			// SourceTextarea
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderSourceLabel, contentDiv, "propertyLabel planningNotificationOrderEditSourceLabel");
			this.sourceTextArea = new SimpleTextarea({
				label : i18n.planningNotificationOrderSourceLabel,
				title : i18n.planningNotificationOrderSourceToolTip,
				maxLength : 2047
			});
			domClass.add(this.sourceTextArea.domNode, "fixedDialogWidget planningNotificationOrderEditSourceTextArea");
			domConstruct.place(this.sourceTextArea.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.sourceTextArea, lang.hitch(this, this.updateWidgetState));

			// CommentTextarea
			DOMHelper.createTextNode("div", i18n.planningNotificationOrderCommentLabel, contentDiv, "propertyLabel planningNotificationOrderEditCommentLabel");
			this.commentTextArea = new SimpleTextarea({
				label : i18n.planningNotificationOrderCommentLabel,
				title : i18n.planningNotificationOrderCommentToolTip,
				maxLength : 2047	
			});
			domClass.add(this.commentTextArea.domNode, "fixedDialogWidget planningNotificationOrderEditCommentTextArea");
			domConstruct.place(this.commentTextArea.domNode, contentDiv);
			WidgetHelper.handleTextBoxEvents(this.commentTextArea, lang.hitch(this, this.updateWidgetState));

			var tagWidgetConstructorFct = lang.hitch(this, function() {
				var options = [{ value : CdesVoc.PLEASE_CHOOSE, label : i18n.pleaseChoose }];
				for (var tagId in this.idToTag) {
					options.push({ value : tagId, label : this.idToTag[tagId].label });		     
				}		     

				return new Select({
					options : options
				});
			});		

			// TagMultiWidget (Schlagworte) (only if project_config.planning_notification_order_tags_enabled = true)
			this.tagLabel = DOMHelper.createTextNode("div", i18n.planningNotificationOrderEditTagLabel, contentDiv, "propertyLabel planningNotificationOrderEditTagLabel");
			this.tagMultiWidget = new MultiWidget({
				addButtonLabel : i18n.planningNotificationOrderEditAddTagLabel,
				addButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton",
				addButtonCssClass : "multiWidgetAddButton",
				deleteButtonLabel : i18n.planningNotificationOrderEditRemoveTagLabel,
				deleteButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton",
				lineWidgetCssClass : "planningNotificationOrderEditMultiWidgetLineWidget",
				lineRemoveButtonCssClass : "multiWidgetLineRemoveButton",
				constructorFct : tagWidgetConstructorFct,
				getterFct : function(widget) { return widget.get("value"); },
				setterFct : function(widget, value) { widget.set("value", value); }
			});
			domClass.add(this.tagMultiWidget.domNode, "fixedDialogWidget planningNotificationOrderEditTagMultiWidget");
			domConstruct.place(this.tagMultiWidget.domNode, contentDiv);
//			WidgetHelper.(this.tag, lang.hitch(this, this.updateWidgetState));

			// ExportedToMspCheckBox
			// if true, planningNotificationOrder is already marked as exported to MSP and will be ignored on a further try to export.
//			DOMHelper.createTextNode("div", i18n.planningNotificationOrderEditExportedToMspLabel, contentDiv,
//			"fixedDialogWidget planningNotificationOrderEditExportedToMspLabel");
//			this.exportedToMspCheckBox = new CheckBox({
//			label : i18n.planningNotificationOrderEditExportedToMspLabel,
//			title : i18n.planningNotificationOrderEditExportedToMspToolTip
//			});
//			domClass.add(this.exportedToMspCheckBox.domNode, "fixedDialogWidget planningNotificationOrderEditExportedToMspCheckBox");
//			domConstruct.place(this.exportedToMspCheckBox.domNode, contentDiv);

			return contentDiv;
		},

		addNewReference : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();

			this.registerAsyncOperationStarted(PlanningNotificationOrderEditWidget.AsyncOperation.LOAD_REFERENCE_CANDIDATES);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getPlanningNotificationOrderReferenceCandidates(organisationPersonId, networkId).then(
					lang.hitch(this, function(planningNotificationOrderInfos) {
						this.registerAsyncOperationFinished(PlanningNotificationOrderEditWidget.AsyncOperation.LOAD_REFERENCE_CANDIDATES);

						this.doAddNewReference(planningNotificationOrderInfos);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationOrderEditWidget.AsyncOperation.LOAD_REFERENCE_CANDIDATES,
							opName : "getPlanningNotificationOrderReferenceCandidates",
							message : i18n.planningNotificationOrderEditLoadReferenceCandidatesFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getPlanningNotificationOrderReferenceCandidates]", err);
							}));	    
		},

		doAddNewReference : function(planningNotificationOrderInfos) {
			// Don't offer own planning notification order as possible reference candidate
			for (var n = 0; n < planningNotificationOrderInfos.length; n++) {
				var planningNotificationOrderInfo = planningNotificationOrderInfos[n];
				if (planningNotificationOrderInfo.orderJoin.planningNotificationOrderWorkflowEntityId == this.orderJoin.planningNotificationOrderWorkflowEntityId) {
					planningNotificationOrderInfos.splice(n, 1);
					break;		    
				}		    
			}

			var chooseDialog = new PlanningNotificationOrderChooseDialog({
				applicationContext : this.applicationContext,
				title : i18n.planningNotificationOrderEditAddReferenceCaption,
				buttons : [ 
					{ type : ChooseDialog.Button.CHOOSE,
						name : "selectButton",	
						label : i18n.planningNotificationOrderEditAddReferenceButtonCaption
					},
					{ type : InfoDialog.Button.ABORT,
						noTitle : true }
					],
					defaultWidth : 800,
					defaultHeight : 350,
					planningNotificationOrderInfos : planningNotificationOrderInfos		
			});

			on(chooseDialog, "valueChosen", lang.hitch(this, function(params) {
				var planningNotificationOrderInfos = params != null && params.selectedPlanningNotificationOrderInfo != null
														? params.selectedPlanningNotificationOrderInfo : [];		    
				var referenceInfos = this.orderJoin.referenceInfos;

				for (var z = 0; z < planningNotificationOrderInfos.length; z++) {
					var planningNotificationOrderInfo = planningNotificationOrderInfos[z];
					var alreadyThere = false;
					for (var n = 0; n < referenceInfos.length; n++) {
						alreadyThere |= referenceInfos[n].planningNotificationOrder.workflowEntityId == planningNotificationOrderInfo.orderJoin.planningNotificationOrderWorkflowEntityId;
					}

					if (!alreadyThere) {
						var planningNotificationOrder = {
								workflowEntityId : planningNotificationOrderInfo.orderJoin.planningNotificationOrderWorkflowEntityId,
								serialNumber : planningNotificationOrderInfo.orderJoin.planningNotificationOrderSerialNumber,			    
								text : planningNotificationOrderInfo.orderJoin.planningNotificationOrderText			    
						};
						var planningNotification = {
								id : planningNotificationOrderInfo.orderJoin.planningNotificationId,
								title : planningNotificationOrderInfo.orderJoin.planningNotificationTitle
						};
						var referenceInfo = {
						    planningNotificationOrder : planningNotificationOrder,
							 planningNotification : planningNotification,
								     projects : planningNotificationOrderInfo.projects,
                                                                 projectJoins : planningNotificationOrderInfo.projectJoins,
							       workflowEntity : { invalidated : planningNotificationOrderInfo.orderJoin.workflowEntityInvalidated}
						};			

						this.orderJoin.referenceInfos.push(referenceInfo);
					}	   
				}

				this.updateReferenceGrid();
			}));

			chooseDialog.show(null);	    
		},

		updateReferenceGrid : function() {
			var referenceInfos = [];
			for (var n = 0; this.orderJoin.referenceInfos && n < this.orderJoin.referenceInfos.length; n++) {
				referenceInfos.push(this.orderJoin.referenceInfos[n]);
			}		

			var columnSettings = {
					showSerialNumber : true,
					showText : true,
					showPlanningNotification : true,
					showProject : true		
			};

			var referenceOrderInfos = [];
			for (var n = 0; n < referenceInfos.length; n++) {
				var referenceInfo = referenceInfos[n];
				var referenceOrderJoin = {
						planningNotificationId : referenceInfo.planningNotification.id,
						planningNotificationTitle : referenceInfo.planningNotification.title,
						planningNotificationOrderWorkflowEntityId : referenceInfo.planningNotificationOrder.workflowEntityId,
						planningNotificationOrderSerialNumber : referenceInfo.planningNotificationOrder.serialNumber,
						planningNotificationOrderText : referenceInfo.planningNotificationOrder.text,
						workflowEntityInvalidated : referenceInfo.workflowEntity.invalidated
				};

				var projectJoins = [];
				for (var z = 0; referenceInfo.projectJoins != null && z < referenceInfo.projectJoins.length; z++) {
					projectJoins.push(referenceInfo.projectJoins[z]);
				}		    

				referenceOrderInfos.push({
					allowedProjectActions : new Object(),
					orderJoin : referenceOrderJoin,
					projectJoins : projectJoins
				});		    
			}		

			this.referenceListWidget.setData({
				planningNotificationOrderInfos : referenceOrderInfos,
				columnSettings : columnSettings
			});

			this.orderJoin.referenceInfos = referenceInfos;
		},

		setData : function(params) {
			this.orderJoin = params.orderJoin;
			this.mayChangePlanningNotification = params.mayChangePlanningNotification;
			this.initialProjectId = params.initialProjectId;
			this.initialPlanningNotificationId = params.initialPlanningNotificationId;
			this.initialPlanningNotificationTitle = params.initialPlanningNotificationTitle;
			this.projectIdToAllowedActions = params.projectIdToAllowedActions;
			this.workflowInitialized = params.workflowInitialized;
			this.workflowHasResults = params.workflowHasResults;

			this.reload();	    
		},

		reload : function() {
			this.updateWidgetsFromData();

			this.projectSelect.set("disabled", this.mode != ContentWidget.Mode.CREATE || !this.mayChangePlanningNotification);
			
			var allowedProjectActions = this.projectIdToAllowedActions ? this.projectIdToAllowedActions[projectId] : null;
			if ((allowedProjectActions && allowedProjectActions.includes("reassignPlanningNotificationToOrder") && this.mayChangePlanningNotification) || this.mode == ContentWidget.Mode.CREATE)
				this.planningNotificationSelect.set("disabled", false);
			else
				this.planningNotificationSelect.set("disabled", true);

			if (!this.workflowHasResults || this.mode == ContentWidget.Mode.CREATE)
				this.textTextArea.set("disabled", false);
			else
				this.textTextArea.set("disabled", true);

		},

		getData : function() {
			this.updateDataFromWidgets();
			return this.orderJoin;
		},	    

		appendText : function(text, page) {
			var pageString = string.substitute(i18n.planningNotificationOrderPageNumber, {
				page : (page + 1)
			});		

			var oldText = this.textTextArea.get("value");
			this.textTextArea.set("value", oldText + text);

			var newPage = "";
			var oldPage = this.documentPageTextBox.get("value");
			if (oldPage != null && oldPage.indexOf(pageString) != -1) {
				newPage = oldPage;
			} else {
				newPage = oldPage + " / " + pageString;
			}

			this.documentPageTextBox.set("value", newPage, false);
		},

		replaceText : function(text, page) {
			var pageString = string.substitute(i18n.planningNotificationOrderPageNumber, {
				page : (page + 1)
			});		

			this.textTextArea.set("value", text, false);
			this.documentPageTextBox.set("value", pageString, false);
		},

		updateWidgetState : function() {
			var projectId = WidgetHelper.getSelectValue(this.projectSelect);
			var planningNotificationOrderTagsEnabled = projectId != null
								&& projectId in this.projectIdToProjectConfig && this.projectIdToProjectConfig[projectId].planningNotificationOrderTagsEnabled;

			if (planningNotificationOrderTagsEnabled) {
				domClass.replace(this.tagLabel, "visible", "invisible");
				domClass.replace(this.tagMultiWidget.domNode, "visible", "invisible");
			} else {
				domClass.replace(this.tagLabel, "invisible", "visible");
				domClass.replace(this.tagMultiWidget.domNode, "invisible", "visible");
			}		

			var statutoryDutyId = WidgetHelper.getSelectValue(this.statutoryDutySelect);
			var statutoryDuty = statutoryDutyId != null ? this.idToStatutoryDuty[statutoryDutyId] : null;
			var noStatutoryDuty = statutoryDuty == null || statutoryDuty.name == null || statutoryDuty.name.indexOf("Keine") != -1;
			var oneStatutoryDuty = statutoryDuty != null && statutoryDuty.name != null && statutoryDuty.name.indexOf("Einmalige") != -1;
			var allTimeStatutoryDuty = statutoryDuty != null && statutoryDuty.name != null && statutoryDuty.name.indexOf("Dauerhafte") != -1;
			var periodicalStatutoryDuty = statutoryDuty != null && statutoryDuty.name != null && statutoryDuty.name.indexOf("Wiederkehrend") != -1;

			var disableFrom = noStatutoryDuty || oneStatutoryDuty || allTimeStatutoryDuty;
			var disableTo = noStatutoryDuty || allTimeStatutoryDuty || periodicalStatutoryDuty;
			var disableInterval = noStatutoryDuty || oneStatutoryDuty || allTimeStatutoryDuty;
			var disableLeadTime = noStatutoryDuty || allTimeStatutoryDuty;
			var disableExpired = noStatutoryDuty;
			var disableSiteType = noStatutoryDuty;
			var disablePersonInCharge = noStatutoryDuty;

			this.invalidatedCheckBox.set("disabled", this.invalidatedCheckBoxDisabled);

			this.statutoryDutyFromSpinner.set("disabled", disableFrom);
			if (disableFrom) {
				this.statutoryDutyFromSpinner.setUtcSeconds(null);
			}		

			this.statutoryDutyToSpinner.set("disabled", disableTo);
			if (disableTo) {
				this.statutoryDutyToSpinner.setUtcSeconds(null);
			}

			this.statutoryDutyIntervalSpinner.set("disabled", disableInterval);
			if (disableInterval) {
				this.statutoryDutyIntervalSpinner.set("value", null);
			}		

			this.leadTimeSpinner.set("disabled", disableLeadTime);
			if (disableLeadTime) {
				this.leadTimeSpinner.set("value", null);
			}		

			this.statutoryDutyExpiredCheckBox.set("disabled", disableExpired);
			if (disableExpired) {
				this.statutoryDutyExpiredCheckBox.set("checked", false);
			}		

/*			this.siteTypeMultiWidget.set("disabled", disableSiteType);
			if (disableSiteType) {
				this.siteTypeMultiWidget.set("value", []);
			}*/		

			this.personInChargeSelect.set("disabled", disablePersonInCharge);
			if (disablePersonInCharge) {
				this.personInChargeSelect.set("value", null);
			}		

			var projectId = WidgetHelper.getSelectValue(this.projectSelect);
			var planningNotificationId = WidgetHelper.getSelectValue(this.planningNotificationSelect);

			if (this.initialized) {
				WidgetHelper.setMustField(this.projectSelect, projectId == null);
				WidgetHelper.updateEmptySelectState(this.projectSelect);

				WidgetHelper.setMustField(this.planningNotificationSelect, 
						projectId != null && (planningNotificationId == null || planningNotificationId == CdesVoc.PLEASE_CHOOSE));
				if (planningNotificationId || planningNotificationId == CdesVoc.PLEASE_CHOOSE) {
					domClass.add(this.planningNotificationSelect.domNode, "emptyField");
				} else {
					domClass.remove(this.planningNotificationSelect.domNode, "emptyField");
				}		

				WidgetHelper.updateEmptyTextBoxState(this.textTextArea);
			}

			var allFieldsValid = !!this.initialized && projectId != null 
			&& planningNotificationId != null && planningNotificationId != CdesVoc.PLEASE_CHOOSE && WidgetHelper.isTextBoxValid(this.textTextArea);
			if (allFieldsValid != this.allFieldsValid) {
				this.allFieldsValid = allFieldsValid;
				on.emit(this, "validStateChange");
			}		
		},

		updateWidgetsFromData : function() {

			var projectId = null;
			if (this.initialProjectId != null) {
				projectId = this.initialProjectId;
				this.initialProjectId = null;		
			} else {
                if (this.orderJoin.projects != null) {
					for (var n = 0; this.orderJoin.projects != null && n < this.orderJoin.projects.length; n++) {
						projectId = this.orderJoin.projects[n].id;
						break;		
					}
                } else if (this.orderJoin.projectJoins != null) {
					for (var n = 0; this.orderJoin.projectJoins != null && n < this.orderJoin.projectJoins.length; n++) {
						projectId = this.orderJoin.projectJoins[n].projectId;
						break;		
					}
                }
			}		

			var planningNotificationId = null;
			var planningNotifications = this.projectIdToPlanningNotifications[projectId];
			for (var n = 0; planningNotifications != null && n < planningNotifications.length; n++) {
				if (this.initialPlanningNotificationTitle != null && planningNotifications[n].title == this.initialPlanningNotificationTitle) {
					planningNotificationId = planningNotifications[n].id;
					this.initialPlanningNotificationTitle = null;		    
				}		    
			}		
			//coming from planningNotification page
			if (this.initialPlanningNotificationId != null) {
				var projectId = null;
				for (var projId in this.projectIdToPlanningNotifications) {
					var planningNotifications = this.projectIdToPlanningNotifications[projId];
					for (var v = 0; v < planningNotifications.length; v++) {
						if (planningNotifications[v].id == this.initialPlanningNotificationId) {
							planningNotificationId = this.initialPlanningNotificationId;
							projectId = projId;
							break;			    
						}			    
					}
					if (projectId != null)
						break;
				}	
			}

			if (planningNotificationId == null) {
				planningNotificationId = this.orderJoin.planningNotificationId;
			}	
			
			PlanningNotificationHelper.processProjectChange({
				projectSelect : this.projectSelect, 
				projectIdToProject : this.projectIdToProject, 
				initialProjectId : projectId
			});

			WidgetHelper.setSelectValue(this.projectSelect, projectId);
			this.handleProjectSelectChange();

			WidgetHelper.setSelectValue(this.subjectAreaSelect, this.orderJoin.subjectAreaId != null ? this.orderJoin.subjectAreaId : CdesVoc.PLEASE_CHOOSE);
			if (planningNotificationId == null) {
				this.planningNotificationSelect.set("value", CdesVoc.PLEASE_CHOOSE);
			} else {
				WidgetHelper.setSelectValue(this.planningNotificationSelect, planningNotificationId);
			}	    
			this.serialNumberSpinner.set("value", this.orderJoin.planningNotificationOrderSerialNumber);
//			WidgetHelper.setSelectValue(this.stateSelect, this.orderJoin.workflowEntityStatusId);
			this.invalidatedCheckBox.set("checked", this.orderJoin.workflowEntityInvalidated);
			this.invalidatedCheckBoxDisabled = !!this.orderJoin.workflowEntityInvalidated;
			this.textTextArea.set("value", this.orderJoin.planningNotificationOrderText == null ? "" : this.orderJoin.planningNotificationOrderText);

			WidgetHelper.setSelectValue(this.statutoryDutySelect, this.orderJoin.planningNotificationOrderStatutoryDutyId);
			this.statutoryDutyFromSpinner.setUtcSeconds(this.orderJoin.planningNotificationOrderStatutoryDutyFrom);
			this.statutoryDutyToSpinner.setUtcSeconds(this.orderJoin.planningNotificationOrderStatutoryDutyTo);
			this.statutoryDutyIntervalSpinner.set("value", this.orderJoin.planningNotificationOrderStatutoryDutyInterval);
			this.leadTimeSpinner.set("value", this.orderJoin.planningNotificationOrderStatutoryDutyLeadTime);
			this.statutoryDutyExpiredCheckBox.set("checked", this.orderJoin.planningNotificationOrderStatutoryDutyExpired);
			this.environmentallyRelevantCheckBox.set("checked", this.orderJoin.planningNotificationOrderEnvironmentallyRelevant);
			this.submitAuthorityCheckBox.set("checked", this.orderJoin.planningNotificationOrderSubmitAuthority);

			this.authorizedInspectorTextBox.set("value", this.orderJoin.planningNotificationOrderAuthorizedInspector);
			WidgetHelper.setSelectValue(this.personInChargeSelect, this.orderJoin.personInChargeId != null ? this.orderJoin.personInChargeId : CdesVoc.PLEASE_CHOOSE);
			this.sourceTextArea.set("value", this.orderJoin.planningNotificationOrderSource);
			this.documentPositionTextBox.set("value", this.orderJoin.planningNotificationOrderDocumentPosition);
			this.documentPageTextBox.set("value", this.orderJoin.planningNotificationOrderDocumentPage);
			this.commentTextArea.set("value", this.orderJoin.planningNotificationOrderComment);	    
//			this.exportedToMspCheckBox.set("checked", this.orderJoin.planningNotificationOrderExportedToMsp);

			var tagInfos = [];
			var tags = this.orderJoin.tags;
			for (var n = 0; tags != null && n < tags.length; n++) {
				tagInfos.push({
					value : tags[n].id,
					id : tags[n].id,
					removable : true	    
				});
			}

			this.tagMultiWidget.set("value", tagInfos);	    

			var siteTypeInfos = [];
			var siteTypes = this.orderJoin.siteTypes;
			for (var n = 0; n < siteTypes.length; n++) {
				siteTypeInfos.push({
					value : siteTypes[n].id,
					id : siteTypes[n].id,
					removable : true		    
				});		    
			}		

//			this.siteTypeMultiWidget.set("value", siteTypeInfos);

			this.updateReferenceGrid();
			this.initialized = true;
		},	    

		updateDataFromWidgets : function() {
			//if (this.mode == ContentWidget.Mode.CREATE) {
				this.orderJoin.planningNotificationId = WidgetHelper.getSelectValue(this.planningNotificationSelect);
			//}		

			var subjectAreaSelectValue = WidgetHelper.getSelectValue(this.subjectAreaSelect);
			this.orderJoin.subjectAreaId = subjectAreaSelectValue == CdesVoc.PLEASE_CHOOSE ? null : subjectAreaSelectValue;

			this.orderJoin.planningNotificationOrderSerialNumber = this.serialNumberSpinner.get("value");
			this.orderJoin.workflowEntityInvalidated = !!this.invalidatedCheckBox.get("checked");
			this.orderJoin.planningNotificationOrderText = this.textTextArea.get("value");

			this.orderJoin.planningNotificationOrderStatutoryDutyId = WidgetHelper.getSelectValue(this.statutoryDutySelect);
			this.orderJoin.planningNotificationOrderStatutoryDutyFrom = this.statutoryDutyFromSpinner.getUtcSeconds();
			this.orderJoin.planningNotificationOrderStatutoryDutyTo = this.statutoryDutyToSpinner.getUtcSeconds();
			this.orderJoin.planningNotificationOrderStatutoryDutyInterval = this.statutoryDutyIntervalSpinner.get("value");
			this.orderJoin.planningNotificationOrderStatutoryDutyLeadTime = this.leadTimeSpinner.get("value");
			this.orderJoin.planningNotificationOrderStatutoryDutyExpired = this.statutoryDutyExpiredCheckBox.get("checked");
			this.orderJoin.planningNotificationOrderEnvironmentallyRelevant = this.environmentallyRelevantCheckBox.get("checked");
			this.orderJoin.planningNotificationOrderSubmitAuthority = this.submitAuthorityCheckBox.get("checked");

			this.orderJoin.planningNotificationOrderAuthorizedInspector = this.authorizedInspectorTextBox.get("value");
			var personInChargeSelectValue = WidgetHelper.getSelectValue(this.personInChargeSelect);
			this.orderJoin.personInChargeId = personInChargeSelectValue == CdesVoc.PLEASE_CHOOSE ? null : personInChargeSelectValue;
			this.orderJoin.planningNotificationOrderSource = this.sourceTextArea.get("value");
			this.orderJoin.planningNotificationOrderDocumentPosition = this.documentPositionTextBox.get("value");
			this.orderJoin.planningNotificationOrderDocumentPage = this.documentPageTextBox.get("value");
			this.orderJoin.planningNotificationOrderComment = this.commentTextArea.get("value");
//			this.orderJoin.planningNotificationOrderExportedToMsp = this.exportedToMspCheckBox.get("checked");

			var tagInfos = this.tagMultiWidget.get("value");
			var tags = [];
			var tagsAlreadyExists = [];
			for (var n = 0; n < tagInfos.length; n++) {
				var tagId = tagInfos[n].value == CdesVoc.PLEASE_CHOOSE ? null : tagInfos[n].value;
				if (tagId != null && !tagsAlreadyExists.includes(tagId)){
					tagsAlreadyExists.push(tagId);
					var tag = this.idToTag[tagId];
					tags.push(tag);
				}
			}

			this.orderJoin.tags = tags;	    

/*			var siteTypeInfos = this.siteTypeMultiWidget.get("value");
			var siteTypes = [];
			for (var n = 0; n < siteTypeInfos.length; n++) {
				var siteTypeId = siteTypeInfos[n].value;
				var siteType = this.idToSiteType[siteTypeId];
				siteTypes.push(siteType);
			}

			this.orderJoin.siteTypes = siteTypes;*/
		},

		destroy : function() {
			this.inherited(arguments);
			this.referenceListWidget.destroy();
		}
	});

	PlanningNotificationOrderEditWidget.AsyncOperation = {
			LOAD_REFERENCE_CANDIDATES : "LoadReferenceCandidates"
	};

	return PlanningNotificationOrderEditWidget;
});
