/*
* $Id: ValueEditDialog.js 1321 2013-06-25 16:29:25Z mda $
*
* Copyright (C) 2013 ITEG IT-Engineers GmbH
*/

define(["cdes/util/I18nHelper",
        "clazzes/TinyLog",
        "clazzes/util/DOMHelper",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/json",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"  
],
function(
         I18nHelper,
         TinyLog,
         DOMHelper,
         InfoDialog,
         TextBox,
         domClass,
         domConstruct,
         domStyle,
         json,
         on,
         declare,
         lang,
         i18n
         ) {

    var className = "at.cdes.widget.util.MultiI18nTextAreaDialog";

    var log = new TinyLog(className);

    var MultiI18nTextAreaDialog = declare(className, InfoDialog, {
        
        constructor : function(params) {
            lang.mixin(this, params);
        },
        
        show: function(chosenItem) {
            // summary:
            //     Show the dialog, and populate it with data based on the shape.
            // tags:
            //     public

            this.constructContentWidget();
            this.constructWidgets();
            
            this.dialog.show();
//            this.showItem(chosenItem);
        },

        constructContentWidget : function() {
	    this.content = domConstruct.create("div", null, null);
	    domClass.add(this.content, "refNodeOfPositionAbsolute");

            var localeToTranslation = I18nHelper.getLocaleMap(this.value, this.locale);
            this.localeToTranslationTextBox = new Object();
            for (var n = 0; n < this.contentLocales.length; n++) {
                var contentLocale = this.contentLocales[n];

                var languageLabel = DOMHelper.createTextNode("div", this.getLanguageString(contentLocale), this.content,
                             "propertyLabel multiI18nTextAreaLanguageLabel");
                domStyle.set(languageLabel, "top", ((n * 35) + 3) + "px");
                
                var translationTextBox = new TextBox({
                    label : i18n.multiI18nTextAreaTranslationLabel,
                    title : i18n.multiI18nTextAreaTranslationToolTip
                });
                domStyle.set(translationTextBox.domNode, "top", (n * 35) + "px");
                domClass.add(translationTextBox.domNode, "fixedDialogWidget multiI18nTextAreaLanguageToolTip");
                domConstruct.place(translationTextBox.domNode, this.content);

                if (contentLocale in localeToTranslation) {
                    var translation = localeToTranslation[contentLocale];
                    translationTextBox.set("value", translation);
                }

                this.localeToTranslationTextBox[contentLocale] = translationTextBox;
            }

        },

        getLanguageString : function(contentLocale) {
            if (contentLocale == "de") {
                return i18n.german;
            } else if (contentLocale == "sl") {
                return i18n.slovene;
            } else if (contentLocale == "en") {
                return i18n.english;
            } else if (contentLocale == "it") {
                return i18n.italian;
            } else {
                return contentLocale;
            }
        },

        getUpdatedJsonValue : function() {
            var localeToTranslation = new Object();
            for (var locale in this.localeToTranslationTextBox) {
                var translationTextBox = this.localeToTranslationTextBox[locale];
                var translation = translationTextBox.get("value");
                if (translation != null) {
                    localeToTranslation[locale] = translationTextBox.get("value");
                }
            }

            var jsonValue = json.stringify(localeToTranslation);
            return jsonValue;
        }
    });

    
    MultiI18nTextAreaDialog.open = function(params) {
        var dialog = new MultiI18nTextAreaDialog(params);
        dialog.show();
    };      
    
    return MultiI18nTextAreaDialog;
});
