define([
    "cdes/core/Feature",
    "clazzes/LoginGuardRpcService",
    "clazzes/LogViewer",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Button",
    "dijit/form/Select",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/json",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    //         "dojo/text!/cdes/svc/adminServiceWeb?smd",
    "dojo/text!/cdes-dojo-impl/jobStatus?smd",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
    Feature,
    LoginGuardRpcService,
    LogViewer,
    TinyLog,
    DOMHelper,
    WidgetHelper,
    ContentWidget,
    Button,
    Select,
    domClass,
    domConstruct,
    domStyle,
    ioQuery,
    json,
    on,
    declare,
    lang,
    //    		 adminServiceSmd,
    jobStatusServiceSmd,
    i18n
) {
    
    var className = "at.cdes.web.admin.import.ImportAdminPage";

    var log = new TinyLog(className);
    
    var ImportAdminPage = declare(className, ContentWidget, {
        /* */    	
        /*
	this.applicationContext.loadPlugins(Feature.MULTI_PRINT_WIDGET).then(lang.hitch(this, function() {
	    
	    this.idToScheme = this.applicationContext.getAllPluginDataForFeature(Feature.MULTI_PRINT_WIDGET);
            */
        
    	constructor : function(params) {
    	    lang.mixin(this,params);
    	    this.uuid = null;
    	    
            //		//this.adminService = new LoginGuardRpcService(json.parse(adminServiceSmd));
    	    this.jobStatusService = new LoginGuardRpcService(json.parse(jobStatusServiceSmd));
    	    
    	    this.topDiv = this.constructTopDiv();
    	    
	    this.updateWidgetState();
    	    
    	    this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    	    return "ImportAdminPage";
    	},
    	
    	getDataId : function() {
    	    return null;
    	},
    	
    	getContainer : function() {
    	    return this.topDiv;
    	},
    	
    	constructTopDiv : function() {	
    	    var topDiv = domConstruct.create("div", null, null);
    	    
    	    // Caption Bar
    	    this.captionBarDiv = this.constructCaptionBar();
    	    domClass.add(this.captionBarDiv, "importAdminEditPageCaptionBar");
    	    domConstruct.place(this.captionBarDiv, topDiv);

	    this.constructContentDiv(topDiv);

            //    		this.buttonDiv = this.constructButtonDiv();
            //    		domClass.add(this.buttonDiv, "importAdminPageButtonDiv");
            //    		domConstruct.place(this.buttonDiv, topDiv);
    	    
    	    return topDiv;
    	},
    	
    	constructCaptionBar : function() {
    	    // Caption Bar consisting of caption and context bar right of the caption
    	    var captionBarDiv = domConstruct.create("div", null, null);
    	    
    	    // Caption
    	    this.captionDiv = DOMHelper.createTextNode("h1", i18n.importAdminPageCaption, captionBarDiv, "importAdminEditPageCaption");
     	    
    	    return captionBarDiv;
    	},
    	
	constructContentDiv : function(topDiv) {
	    var contentDiv = domConstruct.create("div", null, null);
	    domClass.add(contentDiv, "fixedDialogWidget importAdminContentDiv");
	    domConstruct.place(contentDiv, topDiv);

	    DOMHelper.createTextNode("div", i18n.importAdminImporterLabel, contentDiv, "propertyLabel importAdminImporterLabel");

	    this.importerSelect = new Select({
		  label : i18n.importAdminImporterLabel,
		  title : i18n.importAdminImporterToolTip,
		options : []
	    });
	    domClass.add(this.importerSelect.domNode, "fixedDialogWidget importAdminImporterSelect");
	    domConstruct.place(this.importerSelect.domNode, contentDiv);

	    this.importerDiv = domConstruct.create("div", null, null);
	    domClass.add(this.importerDiv, "fixedDialogWidget importAdminImporterDiv");
	    domConstruct.place(this.importerDiv, contentDiv);

	    this.lastSelectedImporter = null;
	    WidgetHelper.handleSelectEvents(this.importerSelect, lang.hitch(this, this.updateImporter));

	    this.applicationContext.loadPlugins(Feature.DATA_IMPORTER).then(lang.hitch(this, function() {
		this.idToImporter = this.applicationContext.getAllPluginDataForFeature(Feature.DATA_IMPORTER);

		var options = [];
		for (var id in this.idToImporter) {
		    var importer = this.idToImporter[id];
		    options.push({ label : importer.label, value : id });
		}
		this.importerSelect.set("options", options);

		if (options.length > 0) {
		    this.importerSelect.set("value", options[0].value);
		    this.updateImporter();
		}
	    }), lang.hitch(this, function(err) {
		log.error("Loading plugins for feature DATA_IMPORTER failed.", err);
	    })).otherwise(function(err) {
		log.error("Loading plugins for feature DATA_IMPORTER failed.", err);
	    });
	},

        updateImporter : function() {
            var currentSelectedImporter = this.importerSelect.get("value");
	    if (this.idToImporter != null && currentSelectedImporter != null && currentSelectedImporter != "" && currentSelectedImporter != this.lastSelectedImporter) {
		var importer = this.idToImporter[currentSelectedImporter];
		var importerContentWidget = importer.constructImporter({ applicationContext : this.applicationContext });
		var importerTopDiv = importerContentWidget.getContainer();

		domConstruct.empty(this.importerDiv);
		domConstruct.place(importerTopDiv, this.importerDiv);

		log.info("updateImporter reconstructed importer widget.");
	    }
	    this.lastSelectedImporter = currentSelectedImporter;
        },	

    	constructButtonDiv : function() {
    	    var buttonDiv = domConstruct.create("div", null, null);
    	    domClass.add(buttonDiv, "refNodeOfPositionAbsolute");
    	    
    	    this.constructSBTNImportButton(buttonDiv);
    	    this.constructSBTNLogViewerButton(buttonDiv);
    	    
    	    return buttonDiv;
    	},
    	
    	constructSBTNImportButton : function(buttonDiv) {
    	    this.sbtnImportButton = new Button({
    		label : i18n.importAdminSBTNImportButtonCaption
    	    });
    	    domClass.add(this.sbtnImportButton.domNode, "fixedDialogWidget importAdminSBTNImportButton");
    	    domConstruct.place(this.sbtnImportButton.domNode, buttonDiv);
    	    
    	    on(this.sbtnImportButton, "click", lang.hitch(this, function() {
    		this.importSBTN();
    	    }));
    	},
    	
    	constructSBTNLogViewerButton : function(buttonDiv) {
    	    this.sbtnLogViewerButton = new Button({
    		label : i18n.importAdminSBTNLogViewerButtonCaption
    	    });
    	    domClass.add(this.sbtnLogViewerButton.domNode, "fixedDialogWidget importAdminSBTNLogViewerButton");
    	    domConstruct.place(this.sbtnLogViewerButton.domNode, buttonDiv);
    	    
    	    on(this.sbtnLogViewerButton, "click", lang.hitch(this, function() {
                var logView = new LogViewer({
                               title : i18n.importAdminLogViewerTitle,
                    jobStatusService : this.jobStatusService,
                               jobId : this.uuid
                });
                logView.show();
    	    }));
    	},    	
    	
    	importSBTN : function() {
    	    /* Currently out of use, to reactive add proper privilege checks.
    	    this.adminService.triggerFixCertificateCaForeignKeys().then(lang.hitch(this, function(uuid) {
    		this.uuid = uuid;
    		this.updateWidgetState();
	    }),
		lang.hitch(this, function(err) {
    		    
		})
	    ).otherwise(lang.hitch(this, function(err) {
		log.error("Error while processing the results of a call to triggerFixCertificateCaForeignKeys: ", err);
	    }));  
	    */  		
    	},
    	
    	resize : function(newSize) {
            //	    domStyle.set(this.topDiv, "width", newSize.w + "px");
	    domStyle.set(this.topDiv, "height", (newSize.h - 16) + "px");
    	},
    	
    	setData : function() {
    	    this.reload();
    	},
    	
    	reload : function() {
    	},
    	
    	updateWidgetState : function() {
    	    var operationRunning = this.isAsyncOperationRunning();
    	    
            //    		this.sbtnLogViewerButton.set("disabled", this.uuid == null);    		
    	}
    });
    
    return ImportAdminPage;
});
