/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */
define([
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/dateTime/DateTimeSpinBox",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/ImportHelper",
         "clazzes/widgets/layout/ContentWidget",
         "clazzes/widgets/layout/InfoDialog",
         "dijit/form/Button",
         "dijit/form/TextBox",
         "dijit/form/Form",
         "dojox/form/Uploader",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/Evented",
         "dojo/io-query",
         "dojo/on",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 topic,
    		 DateTimeSpinBox,
    		 DOMHelper,
    		 ErrorHelper,
    		 WidgetHelper,
    		 ImportHelper,
    		 ContentWidget,
    		 InfoDialog,
    		 Button,
    		 TextBox,
             Form,
             Uploader,
    		 domClass,
    		 domConstruct,
    		 Evented,
    		 ioQuery,
    		 on,
    		 declare,
    		 lang,
    		 i18n
    		 ) {

	var className = "at.cdes.web.certificate.SetUserPolicyWidget";

	var log = new TinyLog(className);

    var SetUserPolicyWidget = declare(className, ContentWidget, {

    	constructor : function(params) {
    		lang.mixin(this,params);

            this.uploadUrl = "/cdes/svc/repositoryUpload?" + ioQuery.objectToQuery({
                type: "request",
                certificateRequest: this.certificateJoin.certificateRequestId,
                organisationPerson: this.applicationContext.getPageContextOrganisationPersonId(),
            });

    		this.topDiv = this.constructTopDiv();

    		this.allFieldsValid = true;
    	},

    	getWidgetId : function() {
    		return "CertificateRequestShowWidget";
    	},

    	getDataId : function() {
    		return this.certificateJoin.certificateRequestId;
    	},

    	getContainer : function() {
    		return this.topDiv;
    	},

    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		domClass.add(topDiv, "setUserPolicyTopDiv");

            this.uploadDiv = domConstruct.create("div", null, null);
            domClass.add(this.uploadDiv, "setUserPolicyUploadDiv");
            domConstruct.place(this.uploadDiv, topDiv);

            DOMHelper.createTextNode("div", i18n.setUserPolicyUploadText, this.uploadDiv, "propertyLabel setUserPolicyUploadText");

			if (this.certificateJoin.certificateRequestRequestPdfUploaded)
            	DOMHelper.createTextNode("div", i18n.setUserPolicyReplaceText, this.uploadDiv, "propertyLabel setUserPolicyReplaceText");
            
            DOMHelper.createTextNode("div", i18n.setUserPolicyUploadLabel, this.uploadDiv, "propertyLabel setUserPolicyUploadLabel");

            this.form = new Form({
                method: "post",
                encType: "multipart/form-data",
                action: this.uploadUrl,
            });
            this.uploader = new dojox.form.Uploader({
                name: "uploadedFile",
                multiple: false,
                type: "file",
                label: i18n.chooseFile,
                tabIndex: 2,
                url: this.uploadUrl,
            });
            domClass.add(this.uploader.domNode, "setUserPolicyUploadButton");
            this.form.domNode.appendChild(this.uploader.domNode);

            domConstruct.place(this.form.domNode, this.uploadDiv);

            this.importFrame = this.applicationContext.getFancyIFrame();
            this.form.set("target", this.importFrame.id);

            this.fileInfoSpan = domConstruct.create("span", null, null);
            domClass.add(this.fileInfoSpan, "setUserPolicyUploadFileInfoSpan");
            domConstruct.place(this.fileInfoSpan, this.uploadDiv);

            ImportHelper.installUploaderChangeHandler(this.uploader, this.fileInfoSpan);

    		return topDiv;
    	},

        setUserPolicy: function() {
            if (this.documentLoadHandle != null) {
                this.documentLoadHandle.remove();
            }
            this.documentLoadHandle = on(this.importFrame, "documentLoad", lang.hitch(this, function(e) {
                if (e.document.title != null && e.document.title.indexOf("Error") != -1) {
                    topic.publish("message/error", i18n.uploadFailed, true);
                } else {
                    on.emit(this, "success");
                }
            }));

            this.form.submit();

        },

    	updateDataFromWidgets : function() {
    		// Nothing to do here
    	},

        updateWidgetState: function() {
        },
    });

    return SetUserPolicyWidget;
});
