/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = organisationSearch
//// i18n-prefix = organisationSearch

define(["cdes/core/CdesVoc",
        "cdes/util/NameHelper",
        "cdes/util/SearchPageHelper",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/util/DOMHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/IconTitlePane",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/CheckBox",
        "dijit/form/ComboBox",
        "dijit/form/Select",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/keys",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
        "dojo/store/Memory"
], function(
            CdesVoc,
            NameHelper,
            SearchPageHelper,
            TinyLog,
            FancyButton,
            DOMHelper,
            WidgetHelper,
            IconTitlePane,
            ContentWidget,
            CheckBox,
            ComboBox,
            Select,
            TextBox,
            domClass,    
            domConstruct,
            Keys,    
            on,
            declare,
            lang,
            i18n,
            Memory
            ) {

    var className = "at.cdes.web.organisation.OrganisationSearchWidget";

    var log = new TinyLog(className);

    var OrganisationSearchWidget = declare(className, ContentWidget, {
        constructor : function(params) {
            lang.mixin(this, params);
            this.searchModel = new Object();
            this.topDiv = this.constructTopDiv();
            this.allFieldsValid = true;

            this.loadedNetworkIds = new Object();
            this.networkIdToOrganisationMemoryData = new Object();
            this.prevNetworkId = -1;
        },

        discardSearchData : function() {
            this.loadedNetworkIds = new Object();
            this.networkIdToOrganisationMemoryData = new Object();
        },        

        getWidgetId : function() {
            return "OrganisationSearchWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute organisationSearchTopDivFull organisationSearchTopDiv");

            this.titlePane = this.constructTitlePane();
            domConstruct.place(this.titlePane.domNode, topDiv);

            return topDiv;
        },

        getSelectedNetworkId : function() {
            // The widget is set to initialized in the async handler of the getSearchInfo call.
            // But we query the network id already before, for getting the parameter networkId
            // of that getSearchInfo call.
            // Thus, if not yet initialized, return the default value for the networkSelect,
            // as set in setSearchInfo below.
            if (this.initialized) {
            	//case --all--
	            if (SearchPageHelper.isComboBoxSetToAll(this.networkComboBox)){
	            	networkId = CdesVoc.MagicSelectOption.ALL;
	            } else {
	            	var networkName = this.networkComboBox.get("value");
	            	networkId = networkName != null ? this.networkNameToId[networkName] : null;
				}       
                this.prevNetworkId = networkId;
                return networkId;
            } else {
	        var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId], "/organisationList/search");
                if (oldSearchModel != null) {
                    if (oldSearchModel.networkId != null) {
                    	this.prevNetworkId = oldSearchModel.networkId;
                        return oldSearchModel.networkId;
                    } else if (oldSearchModel.networkName != null) {
                        return this.networkNameToId[oldSearchModel.networkName];
                    } else {
                        var contextNetworkId = this.applicationContext.getPageContextNetworkId();
                    	this.prevNetworkId = contextNetworkId;
                        return contextNetworkId;
                    }
                } else {
                    var contextNetworkId = this.applicationContext.getPageContextNetworkId();
                    this.prevNetworkId = contextNetworkId;
                    return contextNetworkId;
                }
            }
        },

        getNetworkChanged : function() {
            var networkId;
            //case --all--
            if (SearchPageHelper.isComboBoxSetToAll(this.networkComboBox)){
            	networkId = CdesVoc.MagicSelectOption.ALL;
            } else {
            	var networkName = this.networkComboBox.get("value");
            	networkId = networkName != null ? this.networkNameToId[networkName] : null;
			}
            if (this.prevNetworkId == networkId) {
                return false;
            } else { 
                return true;
            }
        },

        setNetworks : function(networks) {
            this.networkMemoryData = this.getNetworkMemoryData(networks);
            this.networkNameStore = new Memory({
                data : this.networkMemoryData
            });                                                 
            this.networkNameToId = this.getNetworkNameToId(networks);
            this.networkComboBox.set("store", this.networkNameStore);
        },

        setSearchInfo : function(searchInfo) {
            var networkId = searchInfo.networkId;

            var key = networkId != null ? networkId : CdesVoc.MagicSelectOption.ALL;
            this.loadedNetworkIds[key] = true;

            var organisationMemoryData = this.getNameMemoryData(searchInfo.organisations);
            this.networkIdToOrganisationMemoryData[key] = organisationMemoryData;

            this.updateComboBoxes(true);
            this.initialize();
        },        

        updateComboBoxes : function(forceUpdate) {
            var chosenNetworkId = this.getSelectedNetworkId();
            var key = chosenNetworkId != null ? chosenNetworkId : CdesVoc.MagicSelectOption.ALL;

            if (forceUpdate || chosenNetworkId != this.chosenNetworkId) {
                if (this.loadedNetworkIds[key]) {
                    var nameMemoryData = key in this.networkIdToOrganisationMemoryData ? this.networkIdToOrganisationMemoryData[key] : [];
                    this.nameMemory.setData(nameMemoryData);
                    this.nameComboBox.set("store", this.nameMemory);

                    if (log.isDebugEnabled()) {
                        log.debug("Set ComboBoxes with data for chosenNetworkId [" + chosenNetworkId + "]");
                    }
                } else {
                    // networkId is fetched in called code in OrganisationPage
                    on.emit(this, "doReloadSearchInfo");
                }
            }
            this.chosenNetworkId = chosenNetworkId;            
        },

        postTitleClick : function() {
            var open = this.titlePane.get("open");

            if (open) {
                this.titlePane.set("title", i18n.searchOpenCaption);
                domClass.replace(this.topDiv, "organisationSearchTopDivFull", "organisationSearchTopDivReduced");
            } else {
                this.titlePane.set("title", i18n.searchClosedCaption);
                domClass.replace(this.topDiv, "organisationSearchTopDivReduced", "organisationSearchTopDivFull");
            }

            on.emit(this, "titlePaneToggled");
        },

        constructTitlePane : function() {
            this.contentDiv = this.constructContentDiv();

            var titlePane = new IconTitlePane({
                       title   : i18n.searchOpenCaption,
                       content : this.contentDiv,
                    toggleable : true,
                          open : true,
                postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "organisationSearchTitlePane");

            return titlePane;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute organisationSearchContentDiv");

            // Name
            this.nameMemory = new Memory({
                data : this.getNameMemoryData()
            });                 

            DOMHelper.createTextNode("div", i18n.organisationLabel, contentDiv, "propertyLabel organisationSearchNameLabel");
            this.nameComboBox = new ComboBox({
                       label : i18n.personSearchOrganisationLabel,
                       title : i18n.personSearchOrganisationToolTip,
                       store : this.nameMemory,
				   queryExpr : "*${0}*", //any search string
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.nameComboBox.domNode, "fixedDialogWidget organisationSearchNameComboBox");
            domConstruct.place(this.nameComboBox.domNode, contentDiv);
            on(this.nameComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // Network
            this.networkMemoryData = this.getNetworkMemoryData(null);
            this.networkNameToId = this.getNetworkNameToId(null);

            DOMHelper.createTextNode("div", i18n.networkLabel, contentDiv, "propertyLabel organisationSearchNetworkLabel");
            this.networkComboBox = new ComboBox({
                        label : i18n.personSearchNetworkLabel,
                       title : i18n.personSearchNetworkToolTip,
                       store : this.networkMemoryData,
				   queryExpr : "*${0}*",
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.networkComboBox.domNode, "fixedDialogWidget organisationSearchNetworkSelect");
            domConstruct.place(this.networkComboBox.domNode, contentDiv);
            on(this.networkComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // Buttons
            this.buttonDiv = domConstruct.create("div", null, null);
            domClass.add(this.buttonDiv, "fixedDialogWidget organisationSearchButtonDiv");
            domConstruct.place(this.buttonDiv, contentDiv);            

            // ClearSearchFieldsButton
            this.clearSearchFieldsButton = new FancyButton({ 
                label : i18n.clearSearchFieldsButtonCaption,
                title : i18n.clearSearchFieldsButtonToolTip
            });
            domClass.add(this.clearSearchFieldsButton.domNode, "textButton organisationSearchClearSearchFieldsButton");
            domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);

            on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));            


            // SearchButton
            this.searchButton = new FancyButton({ 
                label : i18n.searchButtonCaption,
                title : i18n.searchButtonCaption
            });
            domClass.add(this.searchButton.domNode, "textButton organisationSearchDoSearchButton");
            domConstruct.place(this.searchButton.domNode, this.buttonDiv);

            on(this.searchButton, "click", lang.hitch(this, this.doSearch));            

            return contentDiv;          
        },

        recordChanged : function() {
            this.changed = true;
        },

        isAlreadyInitialized : function() {
            return this.initialized;
        },

        setAsyncRunning : function(asyncRunning) {
            var changed = (this.parentAsyncRunning != asyncRunning);
            this.parentAsyncRunning = asyncRunning;
            if (changed) {
                this.updateWidgetState();
            }
        },

        updateWidgetState : function() {
            var asyncRunning = !!(this.parentAsyncRunning || this.asyncOperationRunning);
            this.nameComboBox.set("disabled", asyncRunning);
            this.networkComboBox.set("disabled", asyncRunning);
            this.searchButton.set("disabled", asyncRunning);
            this.clearSearchFieldsButton.set("disabled", asyncRunning);
        },

        initialize : function(searchInfo) {
            if (!this.initialized) {
                this.populateSearchFields();
                this.initialized = true;
            }
        },

        populateSearchFields : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId], "/organisationList/search");
            
            var contextNetworkId = this.applicationContext.getPageContextNetworkId();
            
            if (oldSearchModel != null) {
                this.searchModel = oldSearchModel;                
                if (contextNetworkId != null && this.searchModel.networkId == null && this.searchModel.networkName == null) {
              	    this.searchModel.networkId = contextNetworkId;
                }
            } else {
            	this.searchModel = {
                    organisationPersonId : organisationPersonId,
                               networkId : contextNetworkId
            	};
            }
            this.updateWidgetsFromData();                
        },

        updateWidgetsFromData : function() {
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.nameComboBox, "id", "name");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.networkComboBox, "networkId", "networkName");
        },

        updateDataFromWidgets : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.searchModel = {
                organisationPersonId : organisationPersonId
            };
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.nameComboBox, this.searchModel, "id", "name");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.networkComboBox, this.searchModel, "networkId", "networkName");            
        },

        searchIfEnter : function(e) {
            if (e.keyCode == Keys.ENTER) {
                this.doSearch();
            }
        },

        doSearch : function() {
            this.changed = false;
            on.emit(this, "doSearch");            
        },

        clearSearchFields : function() {
            SearchPageHelper.setComboBoxValue(this.nameComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.networkComboBox, CdesVoc.MagicSelectOption.ALL);
        },

        setChanged : function(changed) {
            this.changed = changed;
        },            

        isChanged : function() {
            return this.changed;
        },            

        setData : function(searchModel) {
            this.searchModel = searchModel != null ? searchModel : new Object();
            this.updateWidgetsFromData();            
        },

        getSearchModel : function() {
            this.updateDataFromWidgets();
            return this.searchModel;            
        },

        getNameMemoryData : function(organisations) {
            var data = [];
            if (organisations) {
                for (var n = 0; n < organisations.length; n++) {
                    data.push({
                        name : NameHelper.getOrganisationName(organisations[n]),
                          id : organisations[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },        

        getNetworkMemoryData : function(networks) {
            var data = [];
            if (networks) {
                for (var n = 0; n < networks.length; n++) {
                    data.push({
                        name : networks[n].name,
                          id : networks[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getNetworkNameToId : function(networks) {
            var networkNameToId = new Object();
            if (networks) {
                for (var n = 0; n < networks.length; n++) {
                    var name = networks[n].name;
                    var id = networks[n].id;
                    networkNameToId[name] = id;
                }
            }
            return networkNameToId;
        },

        getNetworkOptions : function(networks) {
            var options = [{
                value : OrganisationSearchWidget.ALL_KEY,
                label : i18n.allOption
            }];
            if (networks) {
                for (var n = 0; n < networks.length; n++) {
                    options.push({
                        value : networks[n].id,
                        label : networks[n].name
                    });
                }

                options.sort(lang.hitch(this, function(optionOne, optionTwo) {
                    return optionOne.label.localeCompare(optionTwo.label);
                }));
            }
            return options;
        }
    });

    OrganisationSearchWidget.ALL_KEY = "__ALL__";

    return OrganisationSearchWidget;
});
