/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
        "cdes/organisation/OrganisationListWidget",
        "clazzes/TinyLog",
        "clazzes/util/DOMHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/ContentWidget",
        "dojo/_base/declare",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"        
], function(
            OrganisationListWidget,
            TinyLog,
            DOMHelper,
            ChooseDialog,
            ContentWidget,
            declare,
            domClass,
            domConstruct,
            i18n
            ) {

    var className = "at.cdes.web.organisation.SimilarOrganisationChooseDialog";

    var log = new TinyLog(className);

    var SimilarOrganisationChooseDialog = declare(className, [ChooseDialog, ContentWidget], {

        setData : function(params) {
            this.organisationInfos = params.organisationInfos;
        },

        constructChooseWidget : function() {
            this.content = domConstruct.create("div", null, null);
            domClass.add(this.content, "similarOrganisationChooseTopDiv");

            DOMHelper.createTextNode("div", i18n.similarOrganisationChooseHeader, this.content, "similarOrganisationChooseHeader");

            this.listWidget = new OrganisationListWidget({
                     applicationContext : this.applicationContext,
                similarOrganisationMode : true
            });     
            var listWidgetDiv = this.listWidget.getContainer();
            domConstruct.place(listWidgetDiv, this.content);

            DOMHelper.createTextNode("div", i18n.similarOrganisationChooseHintOne, this.content, "similarOrganisationChooseHeaderHintOne");
            DOMHelper.createTextNode("div", i18n.similarOrganisationChooseHintTwo, this.content, "similarOrganisationChooseHeaderHintTwo");

            this.listWidget.setData({
                organisationInfos : this.organisationInfos
            });
            this.listWidget.resize({ w : 700, h : 100 });
        }
    });

    return SimilarOrganisationChooseDialog;
});
