define([ 
        "cdes/core/CdesVoc",
        "cdes/person/OrganisationPersonEditWidget",
        "cdes/person/PersonEditWidget",
        "cdes/person/SimilarPersonChooseDialog",
        "cdes/util/CodeHelper",
        "cdes/util/JoinHelper",
        "cdes/widget/ContextBar",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/DataHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/JoinHelper",
        "clazzes/util/StringHelper",
        "clazzes/widgets/IconTitlePane",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/Button",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         CdesVoc,
         OrganisationPersonEditWidget,
         PersonEditWidget,
         SimilarPersonChooseDialog,
         CodeHelper,
         CdesJoinHelper,
         ContextBar,
         TinyLog,
         DateHelper,
         FancyButton,
         topic,
         DOMHelper,
         DataHelper,
         ErrorHelper,
         JoinHelper,
         StringHelper,
         IconTitlePane,
         ContentWidget,
         InfoDialog,
         Button,
         domClass,
         domConstruct,
         domStyle,
         on,
         string,
         declare,
         lang,
         i18n
         ) {
    

    var className = "at.cdes.web.person.PersonEditPage";

    var log = new TinyLog(className);
    
    var PersonEditPage = declare(className, ContentWidget, {
        
        constructor : function(params) {
            lang.mixin(this, params);

            this.organisationPersonIdToOPInfos = new Object();
            this.networkIdToOrganisations = new Object();

            // On creation, new and not yet saved OrganisationPersons gain negative ids.
            // On saving them, they will be replaced by the correct ones from database.
            // This map contains the mapping "initial --> final", as e.g. in delete button
            // code, for closure reasons only the initial ids are known.
            this.movedOrganisationPersonIds = new Object();

            // Database ids are always positive; for not yet saved instances,
            // we use negative pseudo ids.
            this.nextNewOrganisationPersonId = -1;
            
            this.topDiv = this.constructTopDiv();
            this.updateWidgetState();

            this.allFieldsValid = true;

            this.setData(this.id);
        },
        
        getWidgetId : function() {
            return "PersonEditPage";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {                  
            var topDiv = domConstruct.create("div", null, null);

            // Context Bar
/*            this.contextBar = new ContextBar({
                applicationContext : this.applicationContext,
                              mode : ContextBar.Mode.DEFAULT
            });
            this.contextBar.setData({ depth : ContextBar.Depth.NETWORK });
            this.contextBarDiv = this.contextBar.getContainer();
            domClass.add(this.contextBarDiv, "personEditPageContextBarDiv");
            domConstruct.place(this.contextBarDiv, topDiv); 
*/            
            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "personEditPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);                 
            
            // Person TitlePane
            this.titlePaneDiv = domConstruct.create("div", null, null);
            domClass.add(this.titlePaneDiv, "personEditPageTitlePaneDiv");
            domConstruct.place(this.titlePaneDiv, topDiv);

            this.constructPersonTitlePane(this.titlePaneDiv);

            this.constructAddOrganisationPersonButton(this.titlePaneDiv);

            return topDiv;
        },
        
        constructCaptionBar : function() {
            // Caption Bar consisting of caption and context bar right of the caption
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", "", captionBarDiv, "personEditPageCaption");
            
/*            if (this.mode != ContentWidget.Mode.CREATE)
            	this.constructProjectParticipationsButton(captionBarDiv);*/
            this.constructSaveButton(captionBarDiv);
            this.constructSaveAndExitButton(captionBarDiv);
            this.constructAbortButton(captionBarDiv);
//            this.constructAddOrganisationPersonButton(captionBarDiv);  Button on top

            return captionBarDiv;
        },
        
        constructSaveButton : function(captionBarDiv) {
            this.saveButton = new FancyButton({ 
                label : i18n.saveButtonCaption,
                title : i18n.saveButtonCaption
            });
            domClass.add(this.saveButton.domNode, "textButton captionBarButton personEditPageSaveButton");
            domConstruct.place(this.saveButton.domNode, captionBarDiv);

            on(this.saveButton, "click", lang.hitch(this, function() {
                this.prepareSave(true, null);
            }));
        },

        constructSaveAndExitButton : function(captionBarDiv) {
            this.saveAndExitButton = new FancyButton({ 
                label : i18n.saveAndExitButtonCaption,
                title : i18n.saveAndExitButtonCaption
            });
            domClass.add(this.saveAndExitButton.domNode, "textButton captionBarButton personEditPageSaveAndExitButton");
            domConstruct.place(this.saveAndExitButton.domNode, captionBarDiv);

            on(this.saveAndExitButton, "click", lang.hitch(this, this.saveAndExit));
        },

        constructAbortButton : function(captionBarDiv) {
            var label = this.mode == ContentWidget.Mode.EDIT ? i18n.abortButtonCaption : i18n.closeButtonCaption;

            this.abortButton = new FancyButton({ 
                label : label,
                title : label
            });
            domClass.add(this.abortButton.domNode, "textButton captionBarButton personEditPageAbortButton");
            domConstruct.place(this.abortButton.domNode, captionBarDiv);

            on(this.abortButton, "click", lang.hitch(this, this.abort));
        },

        constructAddOrganisationPersonButton : function(captionBarDiv) {
            var label = this.mode == ContentWidget.Mode.EDIT ? i18n.abortButtonCaption : i18n.closeButtonCaption;

            this.addOrganisationPersonButton = new FancyButton({ 
                label : i18n.personEditPageAddOrganisationPersonLabel,
                title : i18n.personEditPageAddOrganisationPersonToolTip
            });
            domClass.add(this.addOrganisationPersonButton.domNode, "textButton captionBarButton personEditPageAddOrganisationPersonButton");
            domConstruct.place(this.addOrganisationPersonButton.domNode, captionBarDiv);

            on(this.addOrganisationPersonButton, "click", lang.hitch(this, function(event) {
                this.addOrganisationPerson();
                this.updateWidgetState();
            }));
        },        

        constructProjectParticipationsButton : function(captionBarDiv) {
            this.projectParticipationsButton = new FancyButton({
                    title : i18n.personEditPageShowProjectParticipationsToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 projectParticipationsButton"
            });

            domClass.add(this.projectParticipationsButton.domNode, "listButton");
            domConstruct.place(this.projectParticipationsButton.domNode, captionBarDiv);

            on(this.projectParticipationsButton, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("participationList",
                                                {   mode : ContentWidget.Mode.EDIT, 
                                                personId : this.person.id },
                                                { },
                                                "personEdit", { mode : ContentWidget.Mode.EDIT, id : this.person.id });
            }));
        }, 

        prepareSave : function(reloadPersonEditInfo, successCallback) {
            this.editWidget.updateDataFromWidgets();

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(PersonEditPage.AsyncOperation.GET_SIMILAR_PERSONS);

            var personService = this.applicationContext.getService("personService");
            personService.getSimilarPersons(organisationPersonId, this.person).then(
                lang.hitch(this, function(organisationPersonJoins) {
                    this.registerAsyncOperationFinished(PersonEditPage.AsyncOperation.GET_SIMILAR_PERSONS);

                    if (organisationPersonJoins.length > 0) {
                        this.showSimilarPersonChooseDialog(reloadPersonEditInfo, organisationPersonJoins, successCallback);
                    } else {
                        this.save(reloadPersonEditInfo, successCallback);
                    }
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonEditPage.AsyncOperation.GET_SIMILAR_PERSONS,
                                opName : "getSimilarPersons",
                               message : i18n.personEditPageGetSimilarPersonsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getSimilarPersons]", err);
                    }));

            //
        },

        showSimilarPersonChooseDialog : function(reloadPersonInfo, organisationPersonJoins, successCallback) {
            var personIdToJoins = CdesJoinHelper.groupOrganisationPersonJoinsByPerson(organisationPersonJoins);
            var personJoins = [];
            for (var personId in personIdToJoins) {
                var joins = personIdToJoins[personId];
                if (joins.length > 0) {
                    personJoins.push(joins[0]);
                }
            }

            var chooseDialog = new SimilarPersonChooseDialog({
                applicationContext : this.applicationContext,
                             title : i18n.personEditPageSaveSimilarPersonFound,
                           buttons : [ {
			                                type : InfoDialog.Button.CUSTOM,
			                                name : "ignoreButton",
			                               label : i18n.personEditPageSaveIgnoreWarningAndSave,
			                               title : i18n.personEditPageSaveIgnoreWarningAndSave,
			                                 fct : lang.hitch(this, function() {
					                                     this.save(reloadPersonInfo, successCallback);
					                 				})
		                           		},
                                      	{
			                                type : InfoDialog.Button.CUSTOM,
			                                name : "ignoreNewOrgPersonButton",
			                               label : i18n.personEditPageSaveIgnoreWarningAndSaveNewOrgPerson,
			                               title : i18n.personEditPageSaveIgnoreWarningAndSaveNewOrgPerson,
			                      			 fct : lang.hitch(this, function() {
                                                 		var chosenPersonJoin = chooseDialog.getChosenPersonJoin();
					                                    this.save(reloadPersonInfo, successCallback, chosenPersonJoin);
					                                 })
		                           		},
		                           		{   type : InfoDialog.Button.ABORT,
	                                       title : i18n.abortToolTip,
	                                       label : i18n.personEditPageSaveContinueEditingLabel,
	                                       title : i18n.personEditPageSaveContinueEditingToolTip
                                      	}
                           			],
                      defaultWidth : 700,
                     defaultHeight : 300
            });
            chooseDialog.setData({
                      personJoins : personJoins,
                personIdToOPJoins : personIdToJoins
            });
            chooseDialog.show(null);
            chooseDialog.updateWidgetState();
        },

        save : function(reloadPersonEditInfo, successCallback, existingPersonJoin) {
            var organisationPersons = [];
            
            this.editWidget.updateDataFromWidgets();
            for (var n = 0; n < this.organisationPersonJoins.length; n++) {
                var organisationPersonJoin = this.organisationPersonJoins[n];
                var organisationPersonId = organisationPersonJoin.organisationPersonId;
                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];

                var editWidget = opInfo.editWidget;
                editWidget.updateDataFromWidgets();

                var organisationPerson = new Object();

                JoinHelper.copyJoinAttributes(organisationPersonJoin, "organisationPerson", organisationPerson, null,
                                              ["id", "organisationalUnitName", "personId", "organisationId",
                                               "postalAddress", "postalCode", "localityName", "stateOrProvinceName",
                                               "telephoneNumber", "mobileTelephoneNumber", "facsimileTelephoneNumber",
                                               "emailAddress", "retiredFlag", "retiredComment",
                                               "emailSendTime", "emailSendMode",
                                               "countryId"]);
                // no need to transfer "directCertificationRequestIssuer"
                organisationPersons.push(organisationPerson);
            }

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            if (this.mode == ContentWidget.Mode.CREATE) {
                // The following ones are initialized in the old Hibernate PersonVariables() 
                // by some obscure default value magic.  As they are must fields on database,
                // we give them some values here as well.
                this.personVariables.displayedDaysOfDoneTasks = 0;
                this.personVariables.displayedDaysUntilDue = 0;
                this.personVariables.preselectedTab = 0;
                this.personVariables.screenSize = 0;
                this.personVariables.tabViewMode = 0;
            }

            var personToPass = existingPersonJoin != null ? null : this.person;
            var personVariablesToPass = existingPersonJoin != null ? null : this.personVariables;
            var existingPersonIdToPass = existingPersonJoin != null ? existingPersonJoin.personId : null;

            this.registerAsyncOperationStarted(PersonEditPage.AsyncOperation.SAVE);
            var personService = this.applicationContext.getService("personService");
            personService.saveOrUpdatePersonAndOrganisationPersons(organisationPersonId, personToPass,
                                                                   personVariablesToPass, existingPersonIdToPass,
                                                                   organisationPersons,
                                                                   reloadPersonEditInfo).then(
                lang.hitch(this, function(personEditInfo) {
                    topic.publish("message/ok", i18n.personEditSaveSucccessful);

                    if (personEditInfo != null && this.mode == ContentWidget.Mode.CREATE) {
                        for (var n = 0; n < organisationPersons.length; n++) {
                            var organisationPerson = organisationPersons[n];
                            var organisationPersonJoin = personEditInfo.organisationPersonJoins[n];
                            this.moveOrganisationPersonOPInfo(organisationPerson.id, organisationPersonJoin.organisationPersonId);
                        }
                    }

                    // After a save, we are always in EDIT mode.
                    this.mode = ContentWidget.Mode.EDIT;
                    for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
                        var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
                        opInfo.editWidget.setMode(ContentWidget.Mode.EDIT);
                    }

                    // Update the state of all widgets according to the state after 
                    // calling the async save function.
                    if (personEditInfo != null) {
                        this.setPersonEditInfo(personEditInfo);
                        this.updateWidgetsFromData();
                    }                    
                    
                    // Do anythig desired afterwards, e.g. returning to main person list, 
                    // inviting for certificate, etc.
                    if (successCallback) {
                        successCallback();
                    }
                    this.registerAsyncOperationFinished(PersonEditPage.AsyncOperation.SAVE);
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PersonEditPage.AsyncOperation.SAVE,
                                opName : "saveOrUpdatePersonAndOrganisationPersons",
                               message : i18n.personEditPageSaveOrUpdatePersonAndOrganisationPersonsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [saveOrUpdatePersonAndOrganisationPersons]", err);
                    }));
        },

        saveAndExit : function() {
            this.prepareSave(false, lang.hitch(this, this.abort));
        },

        abort : function() {
            this.applicationContext.popLastPageHistoryPage({ cameBack : true});
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;

            var titlePaneHeight = totalHeight
//                                - this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                                - this.captionBarDiv.offsetHeight
                                - 16;

            domStyle.set(this.titlePaneDiv, "height", titlePaneHeight + "px");

            log.info("PersonEditPage.resize with totalHeight [" + totalHeight + "], titlePaneHeight = [" + titlePaneHeight + "]");
        },
        
        setData : function(personId) {
            this.personId = personId;
            if (this.mode == ContentWidget.Mode.CREATE) {
                this.personId = null;
            }
            
            this.reload();
        },
        
        reload : function(successCallback) {
            var personService = this.applicationContext.getService("personService");
            
            this.registerAsyncOperationStarted(PersonEditPage.AsyncOperation.GET_DATA);
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.getDataDeferred = personService.getPersonEditInfo(organisationPersonId, this.personId);
            this.getDataDeferred.then(lang.hitch(this, function(personEditInfo) {
                this.setPersonEditInfo(personEditInfo);
                
                if (this.action == "addOrganisationPerson") {
                    this.addOrganisationPerson();
                    this.action = null;
                } else {
                    this.updateWidgetsFromData();
                }
                
                delete this.getDataDeferred;
                this.registerAsyncOperationFinished(PersonEditPage.AsyncOperation.GET_DATA);

                if (successCallback) {
                    successCallback();
                }
            }), lang.hitch(this, function(err) {                
                delete this.getDataDeferred;
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : PersonEditPage.AsyncOperation.GET_DATA,
                            opName : "getPersonEditInfo",
                           message : i18n.personEditPageFetchPersonsFailedMessage
                });                             
            })).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling getPersonEditInfo: ", err);
            }));                    
            
            //this.editWidget.reload();
        },
        
        setPersonEditInfo : function(personEditInfo) {
            this.editWidget.setPersons(personEditInfo.personNames);
            this.personEditInfo = personEditInfo;
            this.person = this.personEditInfo.person;
            this.personVariables = this.personEditInfo.personVariables;
            this.organisationPersonJoins = this.personEditInfo.organisationPersonJoins;
            this.personId = this.person.id;

            // Initialize new OrganisationPerson with the appropriate negative id we use internally in this widget
            if (this.mode == ContentWidget.Mode.CREATE) {
                for (var n = 0; n < this.organisationPersonJoins.length; n++) {
                    var organisationPersonJoin = this.organisationPersonJoins[n];
                    organisationPersonJoin.organisationPersonId = this.nextNewOrganisationPersonId;
                    this.nextNewOrganisationPersonId--;
                }
            }

            this.oldOrganisationPersonIds = new Object();
            for (var n = 0; n < this.organisationPersonJoins.length; n++) {
                var organisationPersonJoin = this.organisationPersonJoins[n];
                this.oldOrganisationPersonIds[organisationPersonJoin.organisationPersonId] = true;
            }

            var certificateRequestJoins = this.personEditInfo.certificateRequestJoins;
            this.organisationPersonIdToCertificateRequestJoins = new Object();
            if (certificateRequestJoins != null){
	            for (var n = 0; n < certificateRequestJoins.length; n++) {
	                var certificateRequestJoin = certificateRequestJoins[n];
	
	                // Compare UNION ALL in CertificateDAO.getCertificateRequestJoinsWithRequestsByPerson
	                // If certificateId is null here, we assume that we have one of the 'request only' instances.
	                var organisationPersonId = (certificateRequestJoin.certificateId != null
	                                            ? certificateRequestJoin.certificateOrganisationPersonId
	                                            : certificateRequestJoin.certificateRequestCreatedFor);
	                
	                if (organisationPersonId != null && !(organisationPersonId in this.organisationPersonIdToCertificateRequestJoins)) {
	                    this.organisationPersonIdToCertificateRequestJoins[organisationPersonId] = [];
	                }
	                this.organisationPersonIdToCertificateRequestJoins[organisationPersonId].push(certificateRequestJoin);
	            }            
            }
            
            for (var n = 0; n < this.organisationPersonJoins.length; n++) {
                var organisationPersonJoin = this.organisationPersonJoins[n];
                var organisationPersonId = organisationPersonJoin.organisationPersonId;
                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
                if (opInfo != null) {
                    opInfo.join = organisationPersonJoin;
                }
            }
        },

        updateWidgetState : function() {
            var operationRunning = this.isAsyncOperationRunning();

            var changed = this.editWidget.isChanged() || !DataHelper.areMemberNamesEqual(this.oldOrganisationPersonIds, this.organisationPersonIdToOPInfos);
            if (this.mode != ContentWidget.Mode.SHOW){
	            for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
	                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
	                changed |= opInfo.editWidget.isChanged();
	
	                if (this.organisationPersonJoins.length > 1) {
	                    domClass.remove(opInfo.deleteButton.domNode, "hidden");
			            // Open at least one (last) TitlePanes
			            var atLeastOneIsOpen = false;
			            for (var n = 0; n < this.organisationPersonJoins.length; n++) {
                			var organisationPersonJoin = this.organisationPersonJoins[n];
			                var organisationPersonId = organisationPersonJoin.organisationPersonId;
			                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
			                atLeastOneIsOpen |= opInfo.titlePane.get("open")==true;
			            }
			            if (!atLeastOneIsOpen){
                			var organisationPersonJoin = this.organisationPersonJoins[this.organisationPersonJoins.length-1];
			                var organisationPersonId = organisationPersonJoin.organisationPersonId;
			                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
            				opInfo.titlePane.set("open", true);
			            }
	                } else {
	                    domClass.add(opInfo.deleteButton.domNode, "hidden");
						opInfo.titlePane.set("open", true);
	                }
	            }
	        }
			var saveDisabled = true;
			if (this.mode != ContentWidget.Mode.SHOW){
	            var saveDisabled = !changed || !this.editWidget.isValid();
	            for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
	                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
	                var editWidget = opInfo.editWidget;
	                saveDisabled |= !editWidget.isValid();
	            }    
            }

            this.saveButton.set("disabled", !!saveDisabled);
            this.saveAndExitButton.set("disabled", !!saveDisabled);

            if (this.mode == ContentWidget.Mode.CREATE || this.mode == ContentWidget.Mode.SHOW) {
                domClass.add(this.addOrganisationPersonButton.domNode, "hidden");
            	this.addOrganisationPersonButton.set("disabled", true);
            	if (this.mode == ContentWidget.Mode.SHOW) {
	                domClass.add(this.saveButton.domNode, "hidden");
	                domClass.add(this.saveAndExitButton.domNode, "hidden");
                        if (this.omitCloseButton) {
                            domClass.add(this.abortButton.domNode, "hidden");   
                        }
                }else{
	                domClass.remove(this.saveButton.domNode, "hidden");
	                domClass.remove(this.saveAndExitButton.domNode, "hidden");
                }
            } else { 
            	//ContentWidget.Mode.EDIT
                domClass.remove(this.addOrganisationPersonButton.domNode, "hidden");
            	this.addOrganisationPersonButton.set("disabled", false);
            }

            var caption;
            if (this.mode == ContentWidget.Mode.EDIT) {
                caption = i18n.personEditPageEditCaption;
            } else if (this.mode == ContentWidget.Mode.SHOW) {
                caption = i18n.personEditPageShowCaption;
            } else {
                caption = i18n.personEditPageCreateCaption;
            }
            DOMHelper.setInnerText(this.captionDiv, string.substitute(caption, {
                givenName : this.person != null && !StringHelper.isEmpty(this.person.givenName) ? this.person.givenName : "",
                  surName : this.person != null && !StringHelper.isEmpty(this.person.surName) ? this.person.surName : ""
            }));

            var allFieldsValid = this.editWidget.isValid();
            for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
                allFieldsValid &= opInfo.editWidget.isValid();
            }
            if (allFieldsValid != this.allFieldsValid) {
                this.allFieldsValid = allFieldsValid;

                this.editWidget.updateWidgetState();
                for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
                    var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
                    opInfo.editWidget.updateWidgetState(false);
                }
            }
        },
        
        updateWidgetsFromData : function() {
            this.editWidget.setData(this.personEditInfo);

            var organisationPersonIds = new Object();
            for (var n = 0; n < this.organisationPersonJoins.length; n++) {
                var organisationPersonJoin = this.organisationPersonJoins[n];
                var organisationPersonId = organisationPersonJoin.organisationPersonId;
                organisationPersonIds[organisationPersonId] = true;
                if (organisationPersonId in this.organisationPersonIdToOPInfos) {
                    var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];

                    var certificateRequestJoins = (organisationPersonId in this.organisationPersonIdToCertificateRequestJoins)
                                                ? this.organisationPersonIdToCertificateRequestJoins[organisationPersonId] : [];

                    opInfo.editWidget.setData({
                                         person : this.person,
                         organisationPersonJoin : organisationPersonJoin,
                        certificateRequestJoins : certificateRequestJoins
                    });                    
                    opInfo.editWidget.updateWidgetState(true);
                } else {
                    this.constructOrganisationPersonTitlePane(this.titlePaneDiv, organisationPersonJoin);
                }
            }

            for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
                if (!(organisationPersonId in organisationPersonIds)) {
                    var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
                    this.titlePaneDiv.removeChild(opInfo.titlePane.domNode);
                    delete this.organisationPersonIdToOPInfos[organisationPersonId];
                }                
            }
        },

        constructPersonTitlePane : function() {
            // PersonEdit Widget
            this.editWidget = new PersonEditWidget({
                applicationContext : this.applicationContext,
                              mode : this.mode
            });
            this.personDataTitlePane = new IconTitlePane({
                       title   : i18n.personEditPagePersonDataOpenCaption,
                       content : this.editWidget.getContainer(),
                    toggleable : false,
                          open : true,
                postTitleClick : lang.hitch(this, this.personDataPostTitleClick)
            });
            //            domClass.add(titlePane.domNode, "occupyWholeParent");
            domConstruct.place(this.personDataTitlePane.domNode, this.titlePaneDiv);
            on(this.editWidget, "validStateChange", lang.hitch(this, this.updateWidgetState));
            on(this.editWidget, "changedStateChange", lang.hitch(this, this.updateWidgetState));
        },

        constructOrganisationPersonTitlePaneButtonSpan : function(organisationPersonJoin, opInfo) {
        
            var additionalSpan = domConstruct.create("span", null, null);
//            var addOrganisationPersonButton = this.constructAddOrganisationPersonButton();
//            domConstruct.place(addOrganisationPersonButton.domNode, additionalSpan);

            opInfo.deleteButton = this.constructDeleteOrganisationPersonButton(organisationPersonJoin);
            domConstruct.place(opInfo.deleteButton.domNode, additionalSpan);

            return additionalSpan;
        },        
/*
        constructAddOrganisationPersonButton : function() {
            var button = new FancyButton({
                    title : i18n.personEditPageAddOrganisationPersonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 addObjectPlannerButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function(event) {
                this.addOrganisationPerson();
                this.updateWidgetState();

                event.stopPropagation();                
            }));
            return button;
        },        
*/
        addOrganisationPerson : function() {
            var newOrganisationPersonJoin = { organisationPersonRetiredFlag : false };
            JoinHelper.copyJoinAttributes(this.person, null, newOrganisationPersonJoin, "person",
                                          ["givenName", "surName", "title", "roldId",
                                           "ztPermission", "login", "password", "gender", "status" ]);
            newOrganisationPersonJoin.organisationPersonId = this.nextNewOrganisationPersonId;
            this.nextNewOrganisationPersonId--;
            this.organisationPersonJoins.push(newOrganisationPersonJoin);

            newOrganisationPersonJoin.organisationPersonPersonId = this.person.id;
            newOrganisationPersonJoin.organisationPersonEmailSendMode = CodeHelper.getCodeByEmailSendMode(CdesVoc.MailSendMode.BRIEF.value);
            newOrganisationPersonJoin.organisationPersonEmailSendTime = 13 * 60; // 13:00

            this.updateWidgetsFromData();

            // Close other TitlePanes, to make space for the new one.
            for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];

                if (opInfo.join.organisationPersonId != newOrganisationPersonJoin.organisationPersonId) {
                    opInfo.titlePane.set("open", false);
                }
            }            
        },

        constructDeleteOrganisationPersonButton : function(organisationPersonJoin) {
            var organisationPersonIdToDelete = organisationPersonJoin.organisationPersonId;

            var button = new FancyButton({
                    title : i18n.personEditPageDeleteOrganisationPersonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function(event) {
                var effectiveIdToDelete = (organisationPersonIdToDelete in this.movedOrganisationPersonIds
                                           ? this.movedOrganisationPersonIds[organisationPersonIdToDelete]
                                           : organisationPersonIdToDelete);

                for (var n = 0; n < this.organisationPersonJoins.length; n++) {
                    var organisationPersonJoin = this.organisationPersonJoins[n];
                    if (organisationPersonJoin.organisationPersonId == effectiveIdToDelete) {
                        this.organisationPersonJoins.splice(n, 1);
                        break;
                    }
                }

                this.updateWidgetsFromData();
                this.updateWidgetState();

                event.stopPropagation();
            }));

            return button;
        },

        constructOrganisationPersonTitlePane : function(parentDiv, organisationPersonJoin) {
            var organisationPersonId = organisationPersonJoin.organisationPersonId;
            var mode = null;
            if (organisationPersonId >= 0) {
                mode = (this.mode == ContentWidget.Mode.SHOW ? ContentWidget.Mode.SHOW : ContentWidget.Mode.EDIT);
            } else {
                mode = ContentWidget.Mode.CREATE;
            }

            var organisationIdsInUse = this.getOrganisationIdsInUse();

            // OrganisationPersonEdit Widget
            var editWidget = new OrganisationPersonEditWidget({
                      applicationContext : this.applicationContext,
                                    mode : mode,
                            parentWidget : this,
                    mailSendModeDisabled : true,
                networkIdToOrganisations : this.networkIdToOrganisations,
                    organisationIdsInUse : organisationIdsInUse,
                   administratedNetworks : this.administratedNetworks,
            hasCertificateAdministration : this.personEditInfo.hasCertificateAdministration
            });
            on(editWidget, "doReload", lang.hitch(this, this.reload));
            on(editWidget, "validStateChange", lang.hitch(this, this.updateWidgetState));
            on(editWidget, "changedStateChange", lang.hitch(this, this.updateWidgetState));
            on(editWidget, "organisationChanged", lang.hitch(this, function() {
                this.updateOrganisationPersonTitle(organisationPersonJoin);
                this.updateOrganisationSelects();
            }));

            // TODO
            //personEditPageOrganisationPleaseChooseCaption

            var opInfo = {
                      join : organisationPersonJoin,
                editWidget : editWidget
            };
            this.organisationPersonIdToOPInfos[organisationPersonJoin.organisationPersonId] = opInfo;

            var initialTitle = this.getOrganisationPersonTitle(organisationPersonJoin, true);
            if (mode != ContentWidget.Mode.SHOW)
            	var additionalSpan = this.constructOrganisationPersonTitlePaneButtonSpan(organisationPersonJoin, opInfo);
            var titlePane = new IconTitlePane({
                               title   : initialTitle,
                               content : editWidget.getContainer(),
                            toggleable : true,
                                  open : true,
                        additionalSpan : additionalSpan,
                additionalSpanPosition : "left",
                        postTitleClick : lang.hitch(this, function() {
                            var open = titlePane.get("open");
                            var title = this.getOrganisationPersonTitle(organisationPersonJoin, open);
                            titlePane.set("title", title);
                        })
            });
            domClass.add(titlePane.domNode, "personEditPageOPTitlePane");
            domConstruct.place(titlePane.domNode, parentDiv);

            opInfo.titlePane = titlePane;

            var organisationPersonId = organisationPersonJoin.organisationPersonId;
            var certificateRequestJoins = (organisationPersonId in this.organisationPersonIdToCertificateRequestJoins)
                                        ? this.organisationPersonIdToCertificateRequestJoins[organisationPersonId] : [];

            editWidget.setData({
                                 person : this.person,
                 organisationPersonJoin : organisationPersonJoin,
                certificateRequestJoins : certificateRequestJoins
            });
        },

        personDataPostTitleClick : function() {

            var open = this.personDataTitlePane.get("open");

            if (open) {
                this.personDataTitlePane.set("title", i18n.personEditPagePersonDataOpenCaption);
                //                domClass.replace(this.topDiv, "personSearchTopDivFull", "personSearchTopDivReduced");
            } else {
                this.personDataTitlePane.set("title", i18n.personEditPagePersonDataClosedCaption);
                //                domClass.replace(this.topDiv, "personSearchTopDivReduced", "personSearchTopDivFull");
            }


            //            on.emit(this, "titlePaneToggled");
        },

        updateOrganisationPersonTitle : function(organisationPersonJoin) {
            var organisationPersonId = organisationPersonJoin.organisationPersonId;
            var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
            var titlePane = opInfo.titlePane;
            var open = titlePane.get("open");
            var title = this.getOrganisationPersonTitle(organisationPersonJoin, open);
            titlePane.set("title", title);
        },               

        getOrganisationPersonTitle : function(organisationPersonJoin, open) {
            var organisationPersonId = organisationPersonJoin.organisationPersonId;
            var rawTitle;
            if (organisationPersonJoin.organisationName == null) {
                return i18n.personEditPageOrganisationPersonNewPleaseChoose;
            } else {
                if (organisationPersonId < 0) {
                    if (open) {
                        rawTitle = i18n.personEditPageOrganisationPersonNewOpenCaption;
                    } else {
                        rawTitle = i18n.personEditPageOrganisationPersonNewClosedCaption;
                    }
                } else {
                    if (open) {
                        rawTitle = i18n.personEditPageOrganisationPersonOpenCaption;
                    } else {
                        rawTitle = i18n.personEditPageOrganisationPersonClosedCaption;
                    }
                }
                
                var title = string.substitute(rawTitle, {
                    organisationName : organisationPersonJoin.organisationName
                });

                return title;
            }
        },

        getOrganisationIdsInUse : function() {
            var organisationIds = new Object();
            for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
                var editWidget = opInfo.editWidget;
                var organisationId = editWidget.getSelectedOrganisationId();
                if (organisationId != null) {
                    organisationIds[organisationId] = true;
                }
            }
            return organisationIds;
        },        

        updateOrganisationSelects : function() {
            var organisationIds = this.getOrganisationIdsInUse();

            for (var organisationPersonId in this.organisationPersonIdToOPInfos) {
                var opInfo = this.organisationPersonIdToOPInfos[organisationPersonId];
                opInfo.editWidget.updateOrganisationSelect(organisationIds);
            }
        },

        moveOrganisationPersonOPInfo : function(oldId, newId) {
            var oldOPInfo = this.organisationPersonIdToOPInfos[oldId];
            this.organisationPersonIdToOPInfos[newId] = oldOPInfo;
            delete this.organisationPersonIdToOPInfos[oldId];
            this.movedOrganisationPersonIds[oldId] = newId;
        }
    });
    
    PersonEditPage.AsyncOperation = {
        GET_DATA : "GetData",
        GET_SIMILAR_PERSONS : "GetSimilarPersons",
        SAVE : "Save"
    };
    
    return PersonEditPage;
});
