/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = sendEmail
////i18n-prefix = sendEmail

define(["cdes/util/NameHelper",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/StringHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/TextBox",
        "dijit/form/Textarea",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/on",       
        "dojo/string",
        "dojo/topic",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
         NameHelper,
         TinyLog,
         FancyButton,
         DOMHelper,
         ErrorHelper,
         StringHelper,
         WidgetHelper,
         ContentWidget,
         TextBox,
         Textarea,
         domClass,
         domConstruct,
         domStyle,
         on,             
         string,
         topic,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.widget.mail.SendEmailPage";

    var log = new TinyLog(className);

    var SendEmailPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
            this.reload();
        },

        getWidgetId : function() {
            return "SendEmailPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", this.getPageCaption(), captionBarDiv, "cdesGeneralPageCaption");

            this.constructSendButton(captionBarDiv);
            this.constructAbortButton(captionBarDiv);

            return captionBarDiv;
        },

        getPageCaption : function() {
            var nameLabel;
            var senderOrganisationPersonJoin = this.getSenderOrganisationPersonJoin();
            if (senderOrganisationPersonJoin != null) {
                nameLabel = NameHelper.getPersonInverseCommonName(senderOrganisationPersonJoin, "person");
            } else {
                nameLabel = "\u2015";
            }
            return string.substitute(i18n.sendEmailPageCaption, {
                name : nameLabel
            });
        },

        constructSendButton : function(captionBarDiv) {
            this.saveButton = new FancyButton({ 
                label : i18n.sendEmailSendButtonCaption,
                title : i18n.sendEmailSendButtonToolTip
            });
            domClass.add(this.saveButton.domNode, "textButton captionBarButton sendEmailSendButton");
            domConstruct.place(this.saveButton.domNode, captionBarDiv);

            on(this.saveButton, "click", lang.hitch(this, this.send));
        },

        constructAbortButton : function(captionBarDiv) {
            var label = this.mode == ContentWidget.Mode.EDIT ? i18n.abortButtonCaption : i18n.closeButtonCaption;

            this.abortButton = new FancyButton({ 
                label : label,
                title : label
            });
            domClass.add(this.abortButton.domNode, "textButton captionBarButton sendEmailAbortButton");
            domConstruct.place(this.abortButton.domNode, captionBarDiv);

            on(this.abortButton, "click", lang.hitch(this, this.abort));
        },

        send : function() {
            var senderOrganisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var contextNetworkId = this.applicationContext.getPageContextNetworkId();
            var subject = this.subjectTextBox.get("value");
            var body = this.bodyTextArea.get("value");

            var emailService = this.applicationContext.getService("emailService");
            emailService.sendEmail(senderOrganisationPersonId, this.organisationPersonId, contextNetworkId, null, subject, body).then(
                lang.hitch(this, function() {
                    this.registerAsyncOperationFinished(SendEmailPage.AsyncOperation.SEND);

                    var receiverOrganisationPersonJoin = this.getReceiverOrganisationPersonJoin();
                    var receiver = NameHelper.getPersonInverseCommonName(receiverOrganisationPersonJoin, "person");
                    var successMessage = string.substitute(i18n.sendEmailPageSendEmailSuccess, {
                        receiver : receiver
                    });
                    topic.publish("message/ok", successMessage);

                    this.abort();
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : SendEmailPage.AsyncOperation.SEND,
                                opName : "sendEmail",
                               message : i18n.sendEmailPageSendEmailFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [sendEmail]", err);
                    }));
        },

        abort : function() {
            this.applicationContext.popLastPageHistoryPage();
        },        

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute wholeRegion sendEmailPageContentDiv");

            // FromTextBox
            DOMHelper.createTextNode("div", i18n.sendEmailFromLabel, contentDiv, "propertyLabel sendEmailFromLabel");
            this.fromTextBox = new TextBox({
                   label : i18n.sendEmailFromLabel,
                   title : i18n.sendEmailFromLabel,
                disabled : true                
            });
            domClass.add(this.fromTextBox.domNode, "fixedDialogWidget sendEmailFromTextBox");
            domConstruct.place(this.fromTextBox.domNode, contentDiv);

            // ReceiverTextBox
            DOMHelper.createTextNode("div", i18n.sendEmailReceiverLabel, contentDiv, "propertyLabel sendEmailReceiverLabel");
            this.receiverTextBox = new TextBox({
                   label : i18n.sendEmailReceiverLabel,
                   title : i18n.sendEmailReceiverLabel,
                disabled : true
            });
            domClass.add(this.receiverTextBox.domNode, "fixedDialogWidget sendEmailReceiverTextBox");
            domConstruct.place(this.receiverTextBox.domNode, contentDiv);

            // SubjectTextBox
            DOMHelper.createTextNode("div", i18n.sendEmailSubjectLabel, contentDiv, "propertyLabel sendEmailSubjectLabel");
            this.subjectTextBox = new TextBox({
                label : i18n.sendEmailSubjectLabel,
                title : i18n.sendEmailSubjectToolTip
            });
            domClass.add(this.subjectTextBox.domNode, "fixedDialogWidget sendEmailSubjectTextBox");
            domConstruct.place(this.subjectTextBox.domNode, contentDiv);
            WidgetHelper.handleTextBoxEvents(this.subjectTextBox, lang.hitch(this, this.updateWidgetState));
            WidgetHelper.setMustField(this.subjectTextBox, true);

            // BodyTextarea
            DOMHelper.createTextNode("div", i18n.sendEmailBodyLabel, contentDiv, "propertyLabel sendEmailBodyLabel");
            this.bodyTextArea = new Textarea({
                label : i18n.sendEmailBodyLabel,
                title : i18n.sendEmailBodyLabel
            });
            domClass.add(this.bodyTextArea.domNode, "fixedDialogWidget sendEmailBodyTextArea");
            domConstruct.place(this.bodyTextArea.domNode, contentDiv);
            WidgetHelper.handleTextBoxEvents(this.bodyTextArea, lang.hitch(this, this.updateWidgetState));
            WidgetHelper.setMustField(this.bodyTextArea, true);

            return contentDiv;
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h - 16;
            domStyle.set(this.topDiv, "height", totalHeight + "px");
        },

        setData : function(params) {
            this.organisationPersonId = params.opId;
            
            this.reload();
        },

        reload : function() {

            this.registerAsyncOperationStarted(SendEmailPage.AsyncOperation.GET_DATA);

            var pageContextOrganisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var personService = this.applicationContext.getService("personService");
            personService.getOrganisationPersonJoins(pageContextOrganisationPersonId, [ pageContextOrganisationPersonId, this.organisationPersonId ]).then(
                lang.hitch(this, function(organisationPersonJoins) {
                    this.registerAsyncOperationFinished(SendEmailPage.AsyncOperation.GET_DATA);

                    this.opIdToJoin = new Object();
                    for (var n = 0; n < organisationPersonJoins.length; n++) {
                        var organisationPersonJoin = organisationPersonJoins[n];
                        this.opIdToJoin[organisationPersonJoin.organisationPersonId] = organisationPersonJoin;
                    }
                    this.updateWidgetsFromData();
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : SendEmailPage.AsyncOperation.GET_DATA,
                                opName : "getOrganisationPersonJoins",
                               message : i18n.sendEmailPageGetOrganisationPersonJoinsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getOrganisationPersonJoins]", err);
                    }));
        },

        getSenderOrganisationPersonJoin : function() {
            var pageContextOrganisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            if (this.opIdToJoin != null && pageContextOrganisationPersonId in this.opIdToJoin) {
                return this.opIdToJoin[pageContextOrganisationPersonId];
            } else {
                return null;
            }
        },

        getReceiverOrganisationPersonJoin : function() {
            if (this.opIdToJoin != null && this.organisationPersonId in this.opIdToJoin) {
                return this.opIdToJoin[this.organisationPersonId];
            } else {
                return null;
            }
        },

        updateWidgetsFromData : function() {
            var caption = this.getPageCaption();
            DOMHelper.setInnerText(this.captionDiv, caption);

            var senderOrganisationPersonJoin = this.getSenderOrganisationPersonJoin();
            var receiverOrganisationPersonJoin = this.getReceiverOrganisationPersonJoin();

            if (senderOrganisationPersonJoin != null) {
                var sender = NameHelper.getPersonInverseCommonName(senderOrganisationPersonJoin, "person");
                this.fromTextBox.set("value", sender);
            }
            if (receiverOrganisationPersonJoin != null) {
                var receiver = NameHelper.getPersonInverseCommonName(receiverOrganisationPersonJoin, "person");
                var to = string.substitute(i18n.sendEmailToContent, {
                    receiver : receiver,
                       email : receiverOrganisationPersonJoin.organisationPersonEmailAddress
                });
                this.receiverTextBox.set("value", to);
            }
            
        },

        updateWidgetState : function() {
            var operationRunning = this.isAsyncOperationRunning();

            WidgetHelper.updateEmptyTextBoxState(this.subjectTextBox);
            WidgetHelper.updateEmptyTextBoxState(this.bodyTextArea);

            var subject = this.subjectTextBox.get("value");
            var body = this.bodyTextArea.get("value");

            var saveDisabled = operationRunning || StringHelper.isEmpty(subject) || StringHelper.isEmpty(body);
            this.saveButton.set("disabled", saveDisabled);
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    SendEmailPage.AsyncOperation = {
        GET_DATA : "GetData",
        SEND : "Send"
    };

    return SendEmailPage;
});
