/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

define([ "clazzes/TinyLog",
	 "dijit/form/Select",
	 "dojo/dom-class",
	 "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
       function(TinyLog,
		Select,		
		domClass,
		i18n) {

    var className = "at.cdes.web.widget.util.WidgetFactory";

    var log = new TinyLog(className);

    var WidgetFactory = {
	constructBooleanSelect : function() {
	    var options = [ { value : "WHATEVER", label : i18n.whatever },
			    { value : "YES", label : i18n.yes },
			    { value : "NO", label : i18n.no }
			  ];			   
	    var select = new Select({
		options : options
	    });
	    select.set("value", "WHATEVER");
	    domClass.add(select.domNode, "booleanSearchSelect");
	    return select;	    
	},

	 getBooleanSelectValue : function(booleanSelect) {
	     var value = booleanSelect.get("value");
	     if (value == "WHATEVER") {
		 return null;
	     } else if (value == "YES") {
		 return true;
	     } else if (value == "NO") {
		 return false;
	     } else {
		 throw new Error("Illegal boolean select value: [" + value + "]");
	     }		 
	 },

	 setBooleanSelectValue : function(booleanSelect, value) {
	     if (value) {
		 booleanSelect.set("value", "YES");
	     } else if (value == false || value == 0) {
		 booleanSelect.set("value", "NO");
	     } else {
		 booleanSelect.set("value", "WHATEVER");
	     }		 
	 }	     
    };

    return WidgetFactory;
});
