/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = participationSearch
//// i18n-prefix = participationSearch

define([ 
        "cdes/core/CdesVoc",
        "cdes/util/I18nHelper",
        "cdes/util/NameHelper",
        "cdes/util/SearchPageHelper",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/util/DOMHelper",
        "clazzes/util/StringHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/IconTitlePane",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/ComboBox",
        "dijit/form/Select",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/keys",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
        "dojo/store/Memory"
], function(
            CdesVoc,
            I18nHelper,
            NameHelper,
            SearchPageHelper,
            TinyLog,
            FancyButton,
            DOMHelper,
            StringHelper,
            WidgetHelper,
            IconTitlePane,
            ContentWidget,
            ComboBox,
            Select,
            TextBox,
            domClass,    
            domConstruct,
            Keys,    
            on,
            declare,
            lang,
            i18n,
            Memory
            ) {

    var className = "at.cdes.web.project.ProjectParticipationSearchWidget";

    var log = new TinyLog(className);

    var ProjectParticipationSearchWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.searchModel = new Object();
            this.topDiv = this.constructTopDiv();
            this.allFieldsValid = true;

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldColumnSettings = this.applicationContext.getFromLocalStorage([organisationPersonId], "/participation/columnSettings");
            //            this.showDetailsCheckBox.set("checked", oldColumnSettings == null || !!oldColumnSettings.showProject);
            this.populateSearchFields();
        },

        getWidgetId : function() {
            return "ProjectParticipationSearchWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute participationSearchTopDivFull participationSearchTopDiv");

            this.titlePane = this.constructTitlePane();
            domConstruct.place(this.titlePane.domNode, topDiv);

            return topDiv;
        },

        postTitleClick : function() {
            var open = this.titlePane.get("open");

            if (open) {
                this.titlePane.set("title", i18n.searchOpenCaption);
                domClass.replace(this.topDiv, "participationSearchTopDivFull", "participationSearchTopDivReduced");
            } else {
                this.titlePane.set("title", i18n.searchClosedCaption);
                domClass.replace(this.topDiv, "participationSearchTopDivReduced", "participationSearchTopDivFull");
            }

            on.emit(this, "titlePaneToggled");
        },

        constructTitlePane : function() {
            this.contentDiv = this.constructContentDiv();

            var titlePane = new IconTitlePane({
                       title   : i18n.searchOpenCaption,
                       content : this.contentDiv,
                    toggleable : true,
                          open : true,
                      duration : 0,
                postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "participationSearchTitlePane");

            return titlePane;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute participationSearchContentDiv");

            // Main Participant
            DOMHelper.createTextNode("div", i18n.participationSearchMainParticipantLabel, contentDiv,
                                     "propertyLabel participationSearchMainParticipantLabel");
            var mainParticipantOptions = [{ label : i18n.allOption, value : CdesVoc.MagicSelectOption.ALL },
                                          {   label : i18n.participationSearchMainParticipantItem,
                                              value : ProjectParticipationSearchWidget.MAIN_PARTICIPANT_OPTIONS.MAIN },
                                          {   label : i18n.participationSearchDeputyItem,
                                              value : ProjectParticipationSearchWidget.MAIN_PARTICIPANT_OPTIONS.DEPUTY }
            ];

            this.mainParticipantSelect = new Select({
                  label : i18n.participationSearchMainParticipantLabel,
                  title : i18n.participationSearchMainParticipantLabel,
                options : mainParticipantOptions
            });
            domClass.add(this.mainParticipantSelect.domNode, "fixedDialogWidget participationSearchMainParticipantSelect");
            domConstruct.place(this.mainParticipantSelect.domNode, contentDiv);

            // Hauptverantwortlicher
            this.personMemory = new Memory({
                data : this.getPersonMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.participationSearchPersonLabel, contentDiv,
                                     "propertyLabel participationSearchPersonLabel");
            this.personComboBox = new ComboBox({
                       label : i18n.participationSearchPersonLabel,
                       title : i18n.participationSearchPersonToolTip,
                       store : this.personMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.personComboBox.domNode, "fixedDialogWidget participationSearchPersonComboBox");
            domConstruct.place(this.personComboBox.domNode, contentDiv);
            on(this.personComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            
            // participationSearchMainParticipantLabel participationSearchMainParticipantItem participationSearchDeputyItem
            // Organisation
            this.organisationMemory = new Memory({
                data : this.getOrganisationMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.participationSearchOrganisationLabel, contentDiv,
                                     "propertyLabel participationSearchOrganisationLabel");
            this.organisationComboBox = new ComboBox({
                       label : i18n.participationSearchOrganisationLabel,
                       title : i18n.participationSearchOrganisationToolTip,
                       store : this.organisationMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.organisationComboBox.domNode, "fixedDialogWidget participationSearchOrganisationComboBox");
            domConstruct.place(this.organisationComboBox.domNode, contentDiv);
            on(this.organisationComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // Role
            this.roleMemory = new Memory({
                data : this.getRoleMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.participationSearchRoleLabel, contentDiv,
                                     "propertyLabel participationSearchRoleLabel");
            this.roleComboBox = new ComboBox({
                       label : i18n.participationSearchRoleLabel,
                       title : i18n.participationSearchRoleToolTip,
                       store : this.roleMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.roleComboBox.domNode, "fixedDialogWidget participationSearchRoleComboBox");
            domConstruct.place(this.roleComboBox.domNode, contentDiv);
            on(this.roleComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // Network
            this.networkMemory = new Memory({
                data : this.getNetworkMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.networkLabel, contentDiv,
                                     "propertyLabel participationSearchNetworkLabel");
            this.networkComboBox = new ComboBox({
                       label : i18n.networkLabel,
                       title : i18n.networkLabel,
                       store : this.networkMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.networkComboBox.domNode, "fixedDialogWidget participationSearchNetworkComboBox");
            domConstruct.place(this.networkComboBox.domNode, contentDiv);
            on(this.networkComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // Project
            this.projectMemory = new Memory({
                data : this.getProjectMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.project, contentDiv,
                                     "propertyLabel participationSearchProjectLabel");
            this.projectComboBox = new ComboBox({
                       label : i18n.project,
                       title : i18n.project,
                       store : this.projectMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.projectComboBox.domNode, "fixedDialogWidget participationSearchProjectComboBox");
            domConstruct.place(this.projectComboBox.domNode, contentDiv);
            on(this.projectComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // SubProject
            this.subProjectMemory = new Memory({
                data : this.getSubProjectMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.subProject, contentDiv,
                                     "propertyLabel participationSearchSubProjectLabel");
            this.subProjectComboBox = new ComboBox({
                       label : i18n.subProject,
                       title : i18n.subProject,
                       store : this.subProjectMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.subProjectComboBox.domNode, "fixedDialogWidget participationSearchSubProjectComboBox");
            domConstruct.place(this.subProjectComboBox.domNode, contentDiv);
            on(this.subProjectComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));            

            // Object
            this.objectMemory = new Memory({
                data : this.getObjectMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.object, contentDiv,
                                     "propertyLabel participationSearchObjectLabel");
            this.objectComboBox = new ComboBox({
                       label : i18n.object,
                       title : i18n.object,
                       store : this.objectMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.objectComboBox.domNode, "fixedDialogWidget participationSearchObjectComboBox");
            domConstruct.place(this.objectComboBox.domNode, contentDiv);
            on(this.objectComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // ObjectPlanner
            this.objectPlannerMemory = new Memory({
                data : this.getObjectPlannerMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.objectPlanner, contentDiv,
                                     "propertyLabel participationSearchObjectPlannerLabel");
            this.objectPlannerComboBox = new ComboBox({
                       label : i18n.objectPlanner,
                       title : i18n.objectPlanner,
                       store : this.objectPlannerMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.objectPlannerComboBox.domNode, "fixedDialogWidget participationSearchObjectPlannerComboBox");
            domConstruct.place(this.objectPlannerComboBox.domNode, contentDiv);
            on(this.objectPlannerComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // ObjectPlannerPositionDefinition
            this.objectPlannerPositionDefinitionMemory = new Memory({
                data : this.getObjectPlannerPositionDefinitionMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.participationSearchObjectPlannerPositionDefinitionLabel, contentDiv,
                                     "propertyLabel participationSearchObjectPlannerPositionDefinitionLabel");
            this.objectPlannerPositionDefinitionComboBox = new ComboBox({
                       label : i18n.participationSearchObjectPlannerPositionDefinitionLabel,
                       title : i18n.participationSearchObjectPlannerPositionDefinitionToolTip,
                       store : this.objectPlannerPositionDefinitionMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.objectPlannerPositionDefinitionComboBox.domNode,
                         "fixedDialogWidget participationSearchObjectPlannerPositionDefinitionComboBox");
            domConstruct.place(this.objectPlannerPositionDefinitionComboBox.domNode, contentDiv);
            on(this.objectPlannerPositionDefinitionComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // ReviewCycleInstanceReleased
            this.reviewCycleInstanceReleasedMemory = new Memory({
                data : this.getReviewCycleInstanceReleasedMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.participationSearchReviewCycleInstanceReleasedLabel, contentDiv,
                                     "propertyLabel participationSearchReviewCycleInstanceReleasedLabel");
            this.reviewCycleInstanceReleasedComboBox = new ComboBox({
                       label : i18n.participationSearchReviewCycleInstanceReleasedLabel,
                       title : i18n.participationSearchReviewCycleInstanceReleasedToolTip,
                       store : this.reviewCycleInstanceReleasedMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.reviewCycleInstanceReleasedComboBox.domNode,
                         "fixedDialogWidget participationSearchReviewCycleInstanceReleasedComboBox");
            domConstruct.place(this.reviewCycleInstanceReleasedComboBox.domNode, contentDiv);
            on(this.reviewCycleInstanceReleasedComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // ReviewCycle
            this.reviewCycleMemory = new Memory({
                data : this.getReviewCycleMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.participationSearchReviewCycleLabel, contentDiv,
                                     "propertyLabel participationSearchReviewCycleLabel");
            this.reviewCycleComboBox = new ComboBox({
                       label : i18n.participationSearchReviewCycleLabel,
                       title : i18n.participationSearchReviewCycleToolTip,
                       store : this.reviewCycleMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.reviewCycleComboBox.domNode,
                         "fixedDialogWidget participationSearchReviewCycleComboBox");
            domConstruct.place(this.reviewCycleComboBox.domNode, contentDiv);
            on(this.reviewCycleComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // ReviewCycleCell
            this.reviewCycleCellMemory = new Memory({
                data : this.getReviewCycleCellMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.reviewCycleCell, contentDiv,
                                     "propertyLabel participationSearchReviewCycleCellLabel");
            this.reviewCycleCellComboBox = new ComboBox({
                       label : i18n.reviewCycleCell,
                       title : i18n.reviewCycleCell,
                       store : this.reviewCycleCellMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.reviewCycleCellComboBox.domNode,
                         "fixedDialogWidget participationSearchReviewCycleCellComboBox");
            domConstruct.place(this.reviewCycleCellComboBox.domNode, contentDiv);
            on(this.reviewCycleCellComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // ReviewCycleNode
            this.reviewCycleNodeMemory = new Memory({
                data : this.getReviewCycleNodeMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.reviewCycleNode, contentDiv,
                                     "propertyLabel participationSearchReviewCycleNodeLabel");
            this.reviewCycleNodeComboBox = new ComboBox({
                       label : i18n.reviewCycleNode,
                       title : i18n.reviewCycleNode,
                       store : this.reviewCycleNodeMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.reviewCycleNodeComboBox.domNode,
                         "fixedDialogWidget participationSearchReviewCycleNodeComboBox");
            domConstruct.place(this.reviewCycleNodeComboBox.domNode, contentDiv);
            on(this.reviewCycleNodeComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // Realm
            this.realmMemory = new Memory({
                data : this.getRealmMemoryData()
            });                 
            
            DOMHelper.createTextNode("div", i18n.realm, contentDiv,
                                     "propertyLabel participationSearchRealmLabel");
            this.realmComboBox = new ComboBox({
                       label : i18n.realm,
                       title : i18n.realm,
                       store : this.realmMemory,
		   queryExpr : "*${0}*", //any search string
		autoComplete : false
            });
            domClass.add(this.realmComboBox.domNode,
                         "fixedDialogWidget participationSearchRealmComboBox");
            domConstruct.place(this.realmComboBox.domNode, contentDiv);
            on(this.realmComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));                        

            // Buttons
            this.buttonDiv = domConstruct.create("div", null, null);
            domClass.add(this.buttonDiv, "fixedDialogWidget participationSearchButtonDiv");
            domConstruct.place(this.buttonDiv, contentDiv);            

            // ClearSearchFieldsButton
            this.clearSearchFieldsButton = new FancyButton({ 
                label : i18n.clearSearchFieldsButtonCaption,
                title : i18n.clearSearchFieldsButtonToolTip
            });
            domClass.add(this.clearSearchFieldsButton.domNode, "textButton participationSearchClearSearchFieldsButton");
            domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);

            on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));            


            // SearchButton
            this.searchButton = new FancyButton({ 
                label : i18n.searchButtonCaption,
                title : i18n.searchButtonCaption
            });
            domClass.add(this.searchButton.domNode, "textButton participationSearchDoSearchButton");
            domConstruct.place(this.searchButton.domNode, this.buttonDiv);

            on(this.searchButton, "click", lang.hitch(this, this.doSearch));            

            return contentDiv;          
        },

        recordChanged : function() {
            this.changed = true;
        },

        isAlreadyInitialized : function() {
            return this.initialized;
        },

        setAsyncRunning : function(asyncRunning) {
            var changed = (this.parentAsyncRunning != asyncRunning);
            this.parentAsyncRunning = asyncRunning;
            if (changed) {
                this.updateWidgetState();
            }
        },

        updateWidgetState : function() {
            var asyncRunning = this.isAsyncOperationRunning() || this.parentAsyncRunning;

            this.mainParticipantSelect.set("disabled", asyncRunning);
            this.personComboBox.set("disabled", asyncRunning);
            this.organisationComboBox.set("disabled", asyncRunning);
            this.roleComboBox.set("disabled", asyncRunning);

            this.networkComboBox.set("disabled", asyncRunning);
            this.projectComboBox.set("disabled", asyncRunning);
            this.subProjectComboBox.set("disabled", asyncRunning);
            this.objectComboBox.set("disabled", asyncRunning);

            this.objectPlannerComboBox.set("disabled", asyncRunning);
            this.objectPlannerPositionDefinitionComboBox.set("disabled", asyncRunning);
            this.reviewCycleInstanceReleasedComboBox.set("disabled", asyncRunning);
            this.reviewCycleComboBox.set("disabled", asyncRunning);

            this.reviewCycleCellComboBox.set("disabled", asyncRunning);
            this.reviewCycleNodeComboBox.set("disabled", asyncRunning);
            this.realmComboBox.set("disabled", asyncRunning);
        },

        initialize : function(searchInfo) {
            if (!this.initialized) {
                this.populateSearchFields();
                this.initialized = true;
            }
        },

        populateSearchFields : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId], "/participationList/search");

            if (oldSearchModel != null) {
                this.searchModel = oldSearchModel;
            }

            this.updateWidgetsFromData();                
        },

        updateWidgetsFromData : function() {
            var mainParticipantFlag = this.searchModel.mainParticipantFlag;
            if (mainParticipantFlag == true) {
                this.mainParticipantSelect.set("value", ProjectParticipationSearchWidget.MAIN_PARTICIPANT_OPTIONS.MAIN);
            } else if (mainParticipantFlag == false) {
                this.mainParticipantSelect.set("value", ProjectParticipationSearchWidget.MAIN_PARTICIPANT_OPTIONS.DEPUTY);
            } else {
                this.mainParticipantSelect.set("value", CdesVoc.MagicSelectOption.ALL);
            }

            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.personComboBox,
                                                                  "personId", "personName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.organisationComboBox,
                                                                  "organisationId", "organisationName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.roleComboBox,
                                                                  "cdesRoleId", "cdesRoleName");

            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.networkComboBox,
                                                                  "networkId", "networkName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.projectComboBox,
                                                                  "projectId", "projectCodeName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.subProjectComboBox,
                                                                  "subProjectId", "subProjectCodeName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.objectComboBox,
                                                                  "objectReleaseId", "objectReleaseCodeName");

            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.objectPlannerComboBox,
                                                                  "objectPlannerReleaseId", "objectPlannerReleaseCodeArea");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.objectPlannerPositionDefinitionComboBox,
                                                                  "objectPlannerPositionDefinitionId",
                                                                  "objectPlannerPositionDefinitionName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.reviewCycleInstanceReleasedComboBox,
                                                                  "reviewCycleInstanceReleasedId",
                                                                  "reviewCycleInstanceReleasedName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.reviewCycleComboBox,
                                                                  "reviewCycleId", "reviewCycleName");

            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.reviewCycleCellComboBox,
                                                                  "reviewCycleCellId", "reviewCycleCellName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.reviewCycleNodeComboBox,
                                                                  "reviewCycleNodeId", "reviewCycleNodeName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.realmComboBox,
                                                                  "realmId", "realmName");                                    
        },

        updateDataFromWidgets : function() {
            this.searchModel = {
                basePersonId : this.personId
            };

            var mainParticipantSelectValue = WidgetHelper.getSelectValue(this.mainParticipantSelect);
            if (mainParticipantSelectValue == ProjectParticipationSearchWidget.MAIN_PARTICIPANT_OPTIONS.MAIN) {
                this.searchModel.mainParticipantFlag = true;
            } else if (mainParticipantSelectValue == ProjectParticipationSearchWidget.MAIN_PARTICIPANT_OPTIONS.DEPUTY) {
                this.searchModel.mainParticipantFlag = false;
            } else {
                this.searchModel.mainParticipantFlag = null;
            }

            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.personComboBox, this.searchModel,
                                                                  "personId", "personName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.organisationComboBox, this.searchModel,
                                                                  "organisationId", "organisationName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.roleComboBox, this.searchModel,
                                                                  "cdesRoleId", "cdesRoleName");

            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.networkComboBox, this.searchModel,
                                                                  "networkId", "networkName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.projectComboBox, this.searchModel,
                                                                  "projectId", "projectCodeName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.subProjectComboBox, this.searchModel,
                                                                  "subProjectId", "subProjectCodeName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.objectComboBox, this.searchModel,
                                                                  "objectReleaseId", "objectReleaseCodeName");

            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.objectPlannerComboBox, this.searchModel,
                                                                  "objectPlannerReleaseId", "objectPlannerReleaseCodeArea");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.objectPlannerPositionDefinitionComboBox, this.searchModel,
                                                                  "objectPlannerPositionDefinitionId",
                                                                  "objectPlannerPositionDefinitionName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.reviewCycleInstanceReleasedComboBox, this.searchModel,
                                                                  "reviewCycleInstanceReleasedId",
                                                                  "reviewCycleInstanceReleasedName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.reviewCycleComboBox, this.searchModel,
                                                                  "reviewCycleId", "reviewCycleName");

            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.reviewCycleCellComboBox, this.searchModel,
                                                                  "reviewCycleCellId", "reviewCycleCellName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.reviewCycleNodeComboBox, this.searchModel,
                                                                  "reviewCycleNodeId", "reviewCycleNodeName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.realmComboBox, this.searchModel,
                                                                  "realmId", "realmName");                        
        },

        searchIfEnter : function(e) {
            if (e.keyCode == Keys.ENTER) {
                this.doSearch();
            }
        },

        doSearch : function() {
            this.changed = false;
            on.emit(this, "doSearch");            
        },

        clearSearchFields : function() {
            WidgetHelper.setSelectValue(this.mainParticipantSelect, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.personComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.organisationComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.roleComboBox, CdesVoc.MagicSelectOption.ALL);

            SearchPageHelper.setComboBoxValue(this.networkComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.projectComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.subProjectComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.objectComboBox, CdesVoc.MagicSelectOption.ALL);

            SearchPageHelper.setComboBoxValue(this.objectPlannerComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.objectPlannerPositionDefinitionComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.reviewCycleInstanceReleasedComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.reviewCycleComboBox, CdesVoc.MagicSelectOption.ALL);

            SearchPageHelper.setComboBoxValue(this.reviewCycleCellComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.reviewCycleNodeComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.realmComboBox, CdesVoc.MagicSelectOption.ALL);
        },

        setChanged : function(changed) {
            this.changed = changed;
        },            

        isChanged : function() {
            return this.changed;
        },            

        setData : function(searchModel) {
            this.searchModel = searchModel != null ? searchModel : new Object();
            this.updateWidgetsFromData();            
        },

        setSearchInfo : function(searchInfo) {
            var personMemoryData = this.getPersonMemoryData(searchInfo.persons);
            this.personMemory.setData(personMemoryData);
            var organisationMemoryData = this.getOrganisationMemoryData(searchInfo.organisations);
            this.organisationMemory.setData(organisationMemoryData);
            var roleMemoryData = this.getRoleMemoryData(searchInfo.cdesRoles);
            this.roleMemory.setData(roleMemoryData);

            var networkMemoryData = this.getNetworkMemoryData(searchInfo.networks);
            this.networkMemory.setData(networkMemoryData);
            var projectMemoryData = this.getProjectMemoryData(searchInfo.projects);
            this.projectMemory.setData(projectMemoryData);
            var subProjectMemoryData = this.getSubProjectMemoryData(searchInfo.subProjects);
            this.subProjectMemory.setData(subProjectMemoryData);
            var objectMemoryData = this.getObjectMemoryData(searchInfo.idToObjectRelease);
            this.objectMemory.setData(objectMemoryData);
            var objectPlannerMemoryData = this.getObjectPlannerMemoryData(searchInfo.objectPlannerReleases);
            this.objectPlannerMemory.setData(objectPlannerMemoryData);
            var objectPlannerPositionDefinitionMemoryData = this.getObjectPlannerPositionDefinitionMemoryData(searchInfo.idToObjectPlannerPositionDefinition);
            this.objectPlannerPositionDefinitionMemory.setData(objectPlannerPositionDefinitionMemoryData);
            var reviewCycleInstanceReleasedMemoryData = this.getReviewCycleInstanceReleasedMemoryData(searchInfo.reviewCycleInstanceReleaseds);
            this.reviewCycleInstanceReleasedMemory.setData(reviewCycleInstanceReleasedMemoryData);
            var reviewCycleMemoryData = this.getReviewCycleMemoryData(searchInfo.idToReviewCycle);
            this.reviewCycleMemory.setData(reviewCycleMemoryData);

            var reviewCycleCellMemoryData = this.getReviewCycleCellMemoryData(searchInfo.reviewCycleCells);
            this.reviewCycleCellMemory.setData(reviewCycleCellMemoryData);
            var reviewCycleNodeMemoryData = this.getReviewCycleNodeMemoryData(searchInfo.reviewCycleNodes);
            this.reviewCycleNodeMemory.setData(reviewCycleNodeMemoryData);
            var realmMemoryData = this.getRealmMemoryData(searchInfo.realms);
            this.realmMemory.setData(realmMemoryData);

            this.initialize();
        },        

        getSearchModel : function() {
            this.updateDataFromWidgets();
            return this.searchModel;            
        },

        getPersonMemoryData : function(persons) {
            var data = [];

            if (persons) {
                for (var n = 0; n < persons.length; n++) {
                    data.push({
                        name : StringHelper.getNonNullString(NameHelper.getPersonInverseCommonName(persons[n])).trim(),
                          id : persons[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getOrganisationMemoryData : function(organisations) {
            var data = [];

            if (organisations) {
                for (var n = 0; n < organisations.length; n++) {
                    data.push({
                        name : StringHelper.getNonNullString(organisations[n].name).trim(),
                          id : organisations[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getRoleMemoryData : function(cdesRoles) {
            var data = [];

            if (cdesRoles) {
                for (var n = 0; n < cdesRoles.length; n++) {
                    data.push({
                        name : StringHelper.getNonNullString(cdesRoles[n].name).trim(),
                          id : cdesRoles[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getNetworkMemoryData : function(networks) {
            var data = [];

            if (networks) {
                for (var n = 0; n < networks.length; n++) {
                    data.push({
                        name : StringHelper.getNonNullString(networks[n].name).trim(),
                          id : networks[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getProjectMemoryData : function(projects) {
            var data = [];

            if (projects) {
                for (var n = 0; n < projects.length; n++) {
                    data.push({
                        name : StringHelper.getNonNullString(projects[n].code).trim()
                        + " " + StringHelper.getNonNullString(projects[n].name).trim(),
                          id : projects[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getSubProjectMemoryData : function(subProjects) {
            var data = [];

            if (subProjects) {
                for (var n = 0; n < subProjects.length; n++) {
                    data.push({
                        name : StringHelper.getNonNullString(subProjects[n].code).trim()
                        		+ StringHelper.getNonNullString(subProjects[n].number)
                        		+ " " + StringHelper.getNonNullString(subProjects[n].name).trim(),
                          id : subProjects[n].id
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },                                        

        getObjectMemoryData : function(idToObjectRelease) {
            var data = [];

            if (idToObjectRelease) {
                for (var id in idToObjectRelease) {
                    var objectRelease = idToObjectRelease[id];
                    data.push({
                        name : StringHelper.getNonNullString(objectRelease.code).trim()
                        + " " + StringHelper.getNonNullString(objectRelease.name).trim(),
                          id : objectRelease.id
                        
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getObjectPlannerMemoryData : function(objectPlannerReleases) {
            var data = [];

            if (objectPlannerReleases) {
                for (var n = 0; n < objectPlannerReleases.length; n++) {
                    var objectPlannerRelease = objectPlannerReleases[n];
                    data.push({
                        name : StringHelper.getNonNullString(objectPlannerRelease.code).trim()
                        + " " + StringHelper.getNonNullString(objectPlannerRelease.area).trim(),
                          id : objectPlannerRelease.id
                    });                    
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getObjectPlannerPositionDefinitionMemoryData : function(idToObjectPlannerPositionDefinition) {
            var data = [];

            if (idToObjectPlannerPositionDefinition) {
                for (var id in idToObjectPlannerPositionDefinition) {
                    var objectPlannerPositionDefinition = idToObjectPlannerPositionDefinition[id];
                    data.push({
                        name : StringHelper.getNonNullString(objectPlannerPositionDefinition.name).trim(),
                          id : objectPlannerPositionDefinition.id
                        
                    });
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getReviewCycleInstanceReleasedMemoryData : function(reviewCycleInstanceReleaseds) {
            var data = [];

            if (reviewCycleInstanceReleaseds) {
                for (var n = 0; n < reviewCycleInstanceReleaseds.length; n++) {
                    var reviewCycleInstanceReleased = reviewCycleInstanceReleaseds[n];
                    data.push({
                        name : StringHelper.getNonNullString(reviewCycleInstanceReleased.name).trim(),
                          id : reviewCycleInstanceReleased.id
                    });                    
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getReviewCycleMemoryData : function(idToReviewCycle) {
            var data = [];
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();

            if (idToReviewCycle) {
                for (var id in idToReviewCycle) {
                    var reviewCycle = idToReviewCycle[id];
                    var name = StringHelper.getNonNullString(I18nHelper.getCurrentLocaleString(reviewCycle.name, locale)).trim();
                    data.push({
                        name : reviewCycle.name,
                          id : reviewCycle.id
                    });                                        
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getReviewCycleCellMemoryData : function(reviewCycleCells) {
            var data = [];
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();

            if (reviewCycleCells) {
                for (var n = 0; n < reviewCycleCells.length; n++) {
                    var reviewCycleCell = reviewCycleCells[n];
                    var name = I18nHelper.getCurrentLocaleString(reviewCycleCell.name, locale);                    
                    data.push({
                        name : StringHelper.getNonNullString(reviewCycleCell.code).trim()
                        + " " + StringHelper.getNonNullString(name).trim(),
                          id : reviewCycleCell.id
                    });                    
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getReviewCycleNodeMemoryData : function(reviewCycleNodes) {
            var data = [];
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();

            if (reviewCycleNodes) {
                for (var n = 0; n < reviewCycleNodes.length; n++) {
                    var reviewCycleNode = reviewCycleNodes[n];
                    var name = StringHelper.getNonNullString(I18nHelper.getCurrentLocaleString(reviewCycleNode.name, locale)).trim();
                    data.push({
                        name : name,
                          id : reviewCycleNode.id
                    });                    
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getRealmMemoryData : function(realms) {
            var data = [];
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();

            if (realms) {
                for (var n = 0; n < realms.length; n++) {
                    var realm = realms[n];
                    var name = I18nHelper.getCurrentLocaleString(realm.name, locale);
                    data.push({
                        name : StringHelper.getNonNullString(realm.code).trim()
                        + " " + StringHelper.getNonNullString(name).trim(),
                          id : realm.id
                    });                    
                }
            }
            
            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));                            
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        }, 
        

        /*
        getNameMemoryData : function(persons) {
        var data = [];
        if (persons) {
        for (var n = 0; n < persons.length; n++) {
        data.push({
        name : NameHelper.getPersonInverseCommonName(persons[n]),
        id : persons[n].id
    });
    }
    }
        
        data.sort(lang.hitch(this, function(optionOne, optionTwo) {
        return optionOne.name.localeCompare(optionTwo.name);
    }));                            
        return data;
    },*/
    });

    ProjectParticipationSearchWidget.ALL_KEY = "__ALL__";

    ProjectParticipationSearchWidget.MAIN_PARTICIPANT_OPTIONS = {
        MAIN : "Main",
        DEPUTY : "Deputy"
    };

    return ProjectParticipationSearchWidget;
});
