/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = workflowActivityResultList
////i18n-prefix = workflowActivityResultList

define([ "cdes/util/NameHelper",
	"cdes/widget/base/ListWidget",
	"clazzes/TinyLog",
	"clazzes/form/FancyButton",
    "clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
	NameHelper,
	ListWidget,
	TinyLog,
	FancyButton,
    topic,
	DOMHelper,
	ErrorHelper,
	ContentWidget,
	InfoDialog,
	domClass,
	domConstruct,
	domStyle,
	on,
	declare,
	lang,
	i18n) {

	var className = "at.cdes.web.planning.workflow.WorkflowActivityResultListWidget";

	var log = new TinyLog(className);

	var WorkflowActivityResultListWidget = declare(className, ListWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			// Default values for review procotol; set from outside via setBaulosFilter
			this.showResultJoins = true;
			this.showOpenTaskJoins = false;            

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "WorkflowActivityResultListWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		columnWidthKey : "workflowActivityResultList/columnWidths",

		getLocalStorageContextKeys : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			return [organisationPersonId, networkId];
		},

		constructColumns : function() {
			var columns = [];

			// phase
			columns.push({
				field : "workflowActivityWorkflowNodeName",
				id : "workflowNodeName",
				sortable : true,
				label : i18n.workflowActivityResultListWorkflowNodeName
			});

			// baulos
			columns.push({
				field : "_baulos",
				id : "baulos",
				sortable : true,
				label : i18n.workflowActivityResultListBaulos
			});

			// tokenInitiator
			columns.push({
				field : "_tokenInitiator",
				id : "tokenInitiator",
				sortable : true,
				label : i18n.workflowActivityResultListTokenInitiator
			});

			// reviewer
			columns.push({
				field : "_reviewer",
				id : "reviewer",
				sortable : true,
				label : i18n.workflowActivityResultListReviewer
			});

			// issued
			columns.push({
				field : "workflowActivityIssued",
				id : "issued",
				formatter : lang.hitch(this, this.dateTimeFormatter),		 
				sortable : true,
				label : i18n.workflowActivityResultListIssued
			});

			// comment
			columns.push({
				field : "workflowActivityPositionResultComment",
				id : "comment",
				renderCell : lang.hitch(this, this.renderComment),
				sortable : true,
				label : i18n.workflowActivityResultListComment
			});

			// result
			columns.push({
				field : "workflowActivityPositionResultResult",
				id : "result",
				sortable : true,
				label : i18n.workflowActivityResultListResult
			});

			// attachment
			columns.push({
				field : "workflowActivityId",
				id : "attachment",
				renderCell : lang.hitch(this, this.renderAttachmentCell),
				sortable : true,
				label : i18n.workflowActivityResultListAttachment
			});

			return columns;
		},

		baulosFormatter : function(_baulos, resultJoin) {
			var workflowActivityId = resultJoin.workflowActivityId;
			var baulose = workflowActivityId in this.workflowActivityIdToBaulose ? this.workflowActivityIdToBaulose[workflowActivityId]	: [];
			var baulosString = "";
			for (var n = 0; n < baulose.length; n++) {
				baulosString += baulose[n].value;
				if (n < baulose.length - 1) {
					baulosString += ", ";
				}		    
			}

			return baulosString;		
		},

		openTaskBaulosFormatter : function(_baulos, openTaskJoin) {
//			var baulose = openTaskJoin.workflowNodePositionBaulose != null ? openTaskJoin.workflowNodePositionBaulose : [];
			var baulose = openTaskJoin.workflowNodeInitiatorPositionBaulose != null ? openTaskJoin.workflowNodeInitiatorPositionBaulose : [];
			var baulosString = "";
			for (var n = 0; n < baulose.length; n++) {
				baulosString += baulose[n].value;
				if (n < baulose.length - 1) {
					baulosString += ", ";
				}		    
			}
			return baulosString;		
		},

		renderAttachmentCell : function(resultJoin) {
			var buttonDiv = domConstruct.create("div", null, null);

			var workflowActivityId = resultJoin.workflowActivityId;
			var attachments = workflowActivityId in this.workflowActivityIdToAttachments ? this.workflowActivityIdToAttachments[workflowActivityId] : [];

			for (var n = 0; n < attachments.length; n++) {
				var button = this.constructAttachmentButton(attachments[n]);
				domConstruct.place(button.domNode, buttonDiv);		
			}		

			// delete WorkflowActivityResult (deleteTask right only)
			if (this.globalActions && "deleteTask" in this.globalActions) {
				this.deleteWorkflowActivityButton = this.constructDeleteButton(workflowActivityId);
				domConstruct.place(this.deleteWorkflowActivityButton.domNode, buttonDiv);		
			}
			return buttonDiv;
		},

		renderComment : function(resultJoin) {
			// Note: We regard the html here as safe, since the content is passed through UtilService.getSafeHtml (based on Jsoup)
			// at server side before transmitting it to the client
			var html = resultJoin.workflowActivityPositionResultComment != null ? resultJoin.workflowActivityPositionResultComment : "";
			var node = domConstruct.create("div", { innerHTML : html });
			return node;
		},

		constructAttachmentButton : function(attachment) {
			var button = new FancyButton({
				title : attachment.originalName,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 attachmentIcon"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {		    
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				var url = "/cdes-dojo-impl/repositoryDownload/planningAttachment/" + organisationPersonId + "/" + attachment.id;

				var downloadFrame = this.applicationContext.getFancyIFrame();
				downloadFrame.set("src", url);
			}));
			return button;            
		},

        constructDeleteButton : function(workflowActivityId) {
            var button = new FancyButton({
                    title : i18n.workflowActivityResultListDeleteActivityResult,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.askDeleteWorkflowActivityResult(workflowActivityId);
            }));
            return button;
        },

        askDeleteWorkflowActivityResult : function(workflowActivityId) {
            var message = i18n.workflowActivityResultListDeleteActivityResultAskDeleteDialogQuestion;             

            InfoDialog.showQuestion({
                  title : i18n.workflowActivityResultListDeleteActivityResult,
                message : message,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.deleteWorkflowActivityResult(workflowActivityId);
                    })},                                       
                    { type : InfoDialog.Button.NO }
                ]
            });             
        },

        deleteWorkflowActivityResult : function(workflowActivityId) {
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(WorkflowActivityResultListWidget.AsyncOperation.DELETE);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            planningNotificationService.deleteWorkflowActivityResult(workflowActivityId, organisationPersonId).then(
                lang.hitch(this, function() {
                    this.registerAsyncOperationFinished(WorkflowActivityResultListWidget.AsyncOperation.DELETE);

                    topic.publish("message/ok", i18n.workflowActivityResultListDeleteActivityResultSuccess);

                    on.emit(this, "reloadRequested");            
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : WorkflowActivityResultListWidget.AsyncOperation.DELETE,
                                opName : "deleteWorkflowActivityResult",
                               message : i18n.workflowActivityResultListDeleteActivityResultFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [deleteWorkflowActivityResult]", err);
                    }));
        },      

		constructTopDiv : function() {
			var grid = this.constructGrid({
				idProperty : "workflowActivityId", 
				gridId : "WorkflowActivityResultListGrid"
			});

			return grid;
		},

		resize : function(newSize) {
			this.grid.resize(newSize);
		},

		setData : function(params) {
			this.resultJoins = params.resultJoins;
			this.openTaskJoins = params.openTaskJoins;
			this.workflowActivityIdToBaulose = params.workflowActivityIdToBaulose;
			this.workflowActivityIdToAttachments = params.workflowActivityIdToAttachments;
			this.globalActions = params.globalActions;
			this.updateAuxiliaryData();

			this.reload();
		},

		setBaulosFilter : function(baulose, showResultJoins, showOpenTaskJoins) {
			if (baulose == null || baulose.length == 0) {
				this.baulosFilter = null;
			} else {
				this.baulosFilter = new Object();
				for (var n = 0; n < baulose.length; n++) {
					this.baulosFilter[baulose[n].value] = true;
				}                    
			}

			this.showResultJoins = showResultJoins;
			this.showOpenTaskJoins = showOpenTaskJoins;            

			this.reload();
		},        

		updateAuxiliaryData : function() {
			for (var n = 0; this.resultJoins != null && n < this.resultJoins.length; n++) {
				var joinDto = this.resultJoins[n];
				this.updateAuxiliaryDataForJoinDto(joinDto);
				joinDto._tokenInitiator = joinDto.workflowActivityTokenInitiator;
				joinDto._reviewer = joinDto.workflowActivityPositionResultReviewer;
			}

			for (var n = 0; this.openTaskJoins != null && n < this.openTaskJoins.length; n++) {
				var joinDto = this.openTaskJoins[n];
				joinDto._tokenInitiator = joinDto.initiatorOrganisationName + " (" + NameHelper.getPersonInverseCommonName(joinDto, "initiatorPerson") + ")";
				joinDto._reviewer = joinDto.organisationName + " (" + NameHelper.getPersonInverseCommonName(joinDto, "person") + ")";
				this.updateAuxiliaryDataForOpenTaskJoin(joinDto);
			}                
		},

		updateAuxiliaryDataForJoinDto : function(resultJoin) {
			resultJoin._baulos = this.baulosFormatter(null, resultJoin);
		},

		updateAuxiliaryDataForOpenTaskJoin : function(openTaskJoin) {
			openTaskJoin._baulos = this.openTaskBaulosFormatter(null, openTaskJoin);
		},

		reload : function() {
			var joins = [];
			if (this.baulosFilter == null) {
				if (this.showResultJoins) {
					for (var n = 0; this.resultJoins != null && n < this.resultJoins.length; n++) {
						joins.push(this.resultJoins[n]);
					}
				}
				if (this.showOpenTaskJoins) {
					for (var n = 0; this.openTaskJoins != null && n < this.openTaskJoins.length; n++) {
						joins.push(this.openTaskJoins[n]);
					}                        
				}                    
			} else {
				if (this.showResultJoins) {
					for (var n = 0; this.resultJoins != null && n < this.resultJoins.length; n++) {
						var resultJoin = this.resultJoins[n];
						var workflowActivityId = resultJoin.workflowActivityId;
						var baulose = workflowActivityId in this.workflowActivityIdToBaulose ? this.workflowActivityIdToBaulose[workflowActivityId] : [];
						for (var z = 0; baulose != null && z < baulose.length; z++) {
							var baulosString = baulose[z].value;
							if (baulosString in this.baulosFilter) {
								joins.push(resultJoin);
								break;
							}                            
						}                        
					}                    
				}
				if (this.showOpenTaskJoins) {
					for (var n = 0; this.openTaskJoins != null && n < this.openTaskJoins.length; n++) {
						var openTaskJoin = this.openTaskJoins[n];
						var baulose = openTaskJoin.workflowNodeInitiatorPositionBaulose;
						for (var z = 0; baulose != null && z < baulose.length; z++) {
							var baulosString = baulose[z].value;
							if (baulosString in this.baulosFilter) {
								joins.push(openTaskJoin);
								break;
							}                            
						}                        
					}                
				}                    
			}

			this.store.setData(joins);

			this.grid.set("sort", "workflowActivityIssued", false);
			this.grid.updateSortArrow(this.grid.sort);
			this.grid.refresh();

			//this.updateWidgetState();

		},

		updateWidgetState : function() {

		},

		destroy : function() {
			this.inherited(arguments);
			this.grid.destroy();
		}
	});

    WorkflowActivityResultListWidget.AsyncOperation = {
        DELETE : "Delete"
    };

	return WorkflowActivityResultListWidget;
});
