/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ "cdes/core/CdesVoc",
    "cdes/planning/util/PlanningNotificationHelper",
    "cdes/util/CodeHelper",
    "cdes/util/NameHelper",
    "clazzes/ClazzesVoc",
    "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/util/DOMHelper",
        "dojo/dom-construct",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
    PlanningNotificationHelper,
    CodeHelper,
    NameHelper,
    ClazzesVoc,
    TinyLog,
         DateHelper,
         DOMHelper,
         domConstruct,
    lang,           
    i18n) {

    var className = "at.cdes.web.planning.util.PlanningNotificationListHelper";

    var log = new TinyLog(className);

    var PlanningNotificationListHelper = {

        // CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION
        //
        // The sortSpecs delivered by the dgrid table unfortunately doesn't contain the column id, but the column field.
        // As a result, the server code contains translations between those fields, and the server side column names.
        // See at.cdes.impl.export.planning.PlanningReportHelper
        //
        // Thus: Be careful when changing anything related to the fields below.  You might break the server side sort translations.     
        //
        // CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION      


        pushOrderSerialNumberColumn : function(columns) {
            columns.push({
                   field : "planningNotificationOrderSerialNumber",
                      id : "serialNumber",
                sortable : true,
                   label : i18n.planningNotificationOrderListSerialNumberLabel
            });
        },            

        pushOrderTextColumn : function(columns, formatter) {
            columns.push({
                   field : "planningNotificationOrderText",
                      id : "text",
                formatter : formatter,
                renderCell : PlanningNotificationListHelper.renderLineBreak,                
                sortable : true,
                   label : i18n.planningNotificationOrderTextLabel
            });
        },                    

        pushPlanningNotificationTitleColumn : function(columns) {
            columns.push({
                   field : "_planningNotificationTitle",
                      id : "title",
              renderCell : PlanningNotificationListHelper.renderLineBreak,
                sortable : true,
                   label : i18n.planningNotificationColumnTitleLabel
            });
        },            

        pushOrderPlanningNotificationColumn : function(columns, documentCaption) {
            // planningNotification
            columns.push({
                    field : "_planningNotification",
                       id : "planningNotification",
                formatter : PlanningNotificationListHelper.planningNotificationFormatter,
               renderCell : PlanningNotificationListHelper.renderLineBreak,
                 sortable : true,
                    label : documentCaption != null ? documentCaption : i18n.planningNotificationOrderListPlanningNotificationLabel
            });
        },

        pushTaskColumn : function(columns) {
            columns.push({
                    field : "_taskString",
                       id : "task",
                formatter : PlanningNotificationListHelper.taskFormatter,
                 sortable : true,
                    label : i18n.taskListTaskColumnCaption
            });
        },            

        pushTokenInitiatorColumn : function(columns) {
			columns.push({
				field : "_tokenInitiatorString",
				id : "tokenInitiator",
				formatter : PlanningNotificationListHelper.tokenInitiatorFormatter,
				sortable : true,
				label : i18n.workflowActivityResultListTokenInitiator
            });
        },            

        pushProjectColumn : function(columns) {
            // project
            columns.push({
                    field : "_project",
                       id : "project",
                formatter : PlanningNotificationListHelper.projectFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderProjectLabel
            });
        },                              

        pushSubjectAreaColumn : function(columns) {
            // subjectArea
            columns.push({
                   field : "subjectAreaName",
                      id : "subjectArea",
                sortable : true,
                   label : i18n.planningNotificationOrderSubjectAreaLabel
            });
        },                          

        pushAuthorizedInspectorColumn : function(columns) {
            // authorizedInspector
            columns.push({
                   field : "planningNotificationOrderAuthorizedInspector",
                      id : "authorizedInspector",
                sortable : true,
                   label : i18n.planningNotificationOrderAuthorizedInspectorLabel
            });
        },                  

        pushReferenceColumn : function(columns, _this) {
            columns.push({
                     field : "_reference",
                        id : "reference",
                renderCell : lang.hitch(_this, _this.renderReferenceCell),
                  sortable : true,
                     label : i18n.planningNotificationOrderReferenceLabel
            });
        },

        pushStatutoryDutyColumn : function(columns) {
            // statutoryDuty
            columns.push({
                   field : "statutoryDutyName",
                      id : "statutoryDuty",
                sortable : true,
                   label : i18n.planningNotificationOrderListStatutoryDutyLabel
            });
        },

        pushOrderInvalidatedColumn : function(columns) {
            // invalidated
            columns.push({
                    field : "workflowEntityInvalidated",
                       id : "invalidated",
                formatter : PlanningNotificationListHelper.defaultBooleanFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderInvalidatedLabel
            });
        },                          

        pushDocumentPositionColumn : function(columns) {
            // documentPosition
            columns.push({
                   field : "planningNotificationOrderDocumentPosition",
                      id : "documentPosition",
                sortable : true,
                   label : i18n.planningNotificationOrderDocumentPositionLabel
            });
        },

        pushDocumentPageColumn : function(columns) {
            // documentPage
            columns.push({
                   field : "planningNotificationOrderDocumentPage",
                      id : "documentPage",
                sortable : true,
                   label : i18n.planningNotificationOrderDocumentPageLabel
            });
        },                         

        pushSourceColumn : function(columns) {
            // source
            columns.push({
                   field : "planningNotificationOrderSource",
                      id : "source",
                renderCell : PlanningNotificationListHelper.renderLineBreak,
                sortable : true,
                   label : i18n.planningNotificationOrderSourceLabel
            });
        },                               

        pushPersonInChargeColumn : function(columns) {
            // personInCharge
            columns.push({
                   field : "personInChargeName",
                      id : "personInCharge",
                sortable : true,
                   label : i18n.planningNotificationOrderPersonInChargeLabel
            });
        },  

        pushStatutoryDutyFromColumn : function(columns) {
            // statutoryDutyFrom
            columns.push({
                    field : "planningNotificationOrderStatutoryDutyFrom",
                       id : "statutoryDutyFrom",
                formatter : PlanningNotificationListHelper.dateFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderColumnStatutoryDutyFromLabel
            });
        },                    

        pushStatutoryDutyToColumn : function(columns) {
            // statutoryDutyTo
            columns.push({
                    field : "planningNotificationOrderStatutoryDutyTo",
                       id : "statutoryDutyTo",
                formatter : PlanningNotificationListHelper.dateFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderColumnStatutoryDutyToLabel
            });
        },                      

        pushStatutoryDutyIntervalColumn : function(columns) {
            // statutoryDutyInterval
            columns.push({
                   field : "planningNotificationOrderStatutoryDutyInterval",
                      id : "statutoryDutyInterval",
                sortable : true,
                   label : i18n.planningNotificationOrderColumnStatutoryDutyIntervalLabel
            });
        },                

        pushStatutoryDutyLeadTimeColumn : function(columns) {
            // statutoryDutyLeadTime
            columns.push({
                   field : "planningNotificationOrderStatutoryDutyLeadTime",
                      id : "statutoryDutyLeadTime",
                sortable : true,
                   label : i18n.planningNotificationOrderColumnLeadTimeLabel
            });
        },

/*        pushSiteTypeColumn : function(columns) {
            // statutoryDutyLeadTime
            columns.push({
                   field : "_siteTypeString",
                      id : "siteType",
                sortable : true,
                   label : i18n.planningNotificationOrderColumnSiteTypeLabel
            });
        },*/

        pushStatutoryDutyExpiredColumn : function(columns) {
            // statutoryDutyExpired
            columns.push({
                    field : "planningNotificationOrderStatutoryDutyExpired",
                       id : "statutoryDutyExpired",
                formatter : PlanningNotificationListHelper.defaultBooleanFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderStatutoryDutyExpiredLabel
            });
        },                 

        pushSubmitAuthorityColumn : function(columns) {
            // submitAuthority
            columns.push({
                    field : "planningNotificationOrderSubmitAuthority",
                       id : "submitAuthority",
                formatter : PlanningNotificationListHelper.defaultBooleanFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderSubmitAuthorityLabel
            });
        },                      

        pushTagColumn : function(columns) {
            // tag
            columns.push({
                    field : "_tagString",
                       id : "tag",
                formatter : PlanningNotificationListHelper.tagFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderColumnTagLabel
            });
        },                                  

        pushNotificationCommentColumn : function(columns) {
            columns.push({
                   field : "_planningNotificationComment",
                      id : "notificationComment",
              renderCell : PlanningNotificationListHelper.renderLineBreak,
                sortable : true,
                   label : i18n.planningNotificationColumnCommentLabel
            });         
        },                  

        pushOrderCommentColumn : function(columns) {
            // comment
            columns.push({
                     field : "planningNotificationOrderComment",
                        id : "orderComment",
                renderCell : PlanningNotificationListHelper.renderLineBreak,
                  sortable : true,
                     label : i18n.planningNotificationOrderCommentLabel
            });         
        },                         

        renderLineBreak : function(orderJoin, data, cell) {
            /*
        	var comment = orderJoin.planningNotificationOrderComment;
            if (comment == null) {
                return null; 
            } else {
                var node = domConstruct.create("div", null, null);
                var tokens = comment.split("\n");
                for (var n = 0; n < tokens.length; n++) {
                    var token = tokens[n];
                    //var effectiveToken = token != null && token.length > 0 ? token : " ";
                    DOMHelper.createTextNode("div", token, node, "");
                }
                return node;
            }
            */
            if ((typeof data === 'string' || data instanceof String) && data != null && data.length > 0 && data.indexOf("\n") != -1){
            	//data = data.replace("\n/g", "<br>"); doesn't work
			    while (data.indexOf("\n") != -1)
			        data = data.replace("\n", "<br>");
        	}
            var node = domConstruct.create("span", { innerHTML : data!=null?data:"" }, null);
            return node;
        },              

        pushEnvironmentallyRelevantColumn : function(columns) {
            // environmentallyRelevant
            columns.push({
                    field : "planningNotificationOrderEnvironmentallyRelevant",
                       id : "environmentallyRelevant",
                formatter : PlanningNotificationListHelper.defaultBooleanFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderEnvironmentallyRelevantLabel
            });         
        },

        pushWorkflowNodeColumn : function(columns) {
            // workflowNode
            columns.push({
                    field : "_workflowNode",
                       id : "workflowNode",
                formatter : PlanningNotificationListHelper.workflowNodeFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderColumnWorkflowNodeLabel
            });
        },                         

        pushStateColumn : function(columns) {
            // state
            columns.push({
                    field : "_workflowEntityStatusName",
                       id : "state",
                formatter : PlanningNotificationListHelper.workflowEntityStatusFormatter,
                 sortable : true,
                    label : i18n.planningNotificationOrderStateLabel
            });
        },                                

        pushMetaTagColumns : function(columns, metaTags) {
            for (var n = 0; n < metaTags.length; n++) {
                var metaTag = metaTags[n];
    		    //note: metaTag.getName must be defined in resourceBundle (without whitespaces)
                // TODO: direct call eg. by "i18n.planningNotificationMetaTag_"+metaName 
//    		    var metaName = metaTag.name.replace(/\s+/g, '');
    		    var metaLabel = PlanningNotificationHelper.getI18nParameter(metaTag.name);
                columns.push({
                       field : "_metaTag" + metaTag.id,
                          id : metaTag.cssClass,
                    /*                    formatter : metaTag.tagFormat == 1 ? lang.hitch(this, this.maybeMultipleDateFormatter)
                    : lang.hitch(this, this.maybeMultipleTextFormatter),                          */
                    sortable : true,
                       label : metaLabel                 
                });                     
            }                   
        },  
        
        pushAllPlanningNotificationOrderColumns : function(columns, _this, documentCaption) {
            PlanningNotificationListHelper.pushOrderSerialNumberColumn(columns);
            PlanningNotificationListHelper.pushOrderTextColumn(columns);
            PlanningNotificationListHelper.pushOrderPlanningNotificationColumn(columns, documentCaption);
            PlanningNotificationListHelper.pushProjectColumn(columns);
            PlanningNotificationListHelper.pushDocumentPositionColumn(columns);
            PlanningNotificationListHelper.pushDocumentPageColumn(columns);         
            PlanningNotificationListHelper.pushSubjectAreaColumn(columns);
            PlanningNotificationListHelper.pushAuthorizedInspectorColumn(columns);
            PlanningNotificationListHelper.pushReferenceColumn(columns, _this);
            PlanningNotificationListHelper.pushSourceColumn(columns);
            PlanningNotificationListHelper.pushSubmitAuthorityColumn(columns);
            PlanningNotificationListHelper.pushTagColumn(columns);                  
            PlanningNotificationListHelper.pushOrderInvalidatedColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyColumn(columns);
            PlanningNotificationListHelper.pushPersonInChargeColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyFromColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyToColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyIntervalColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyLeadTimeColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyExpiredColumn(columns);
//            PlanningNotificationListHelper.pushSiteTypeColumn(columns);     
            PlanningNotificationListHelper.pushWorkflowNodeColumn(columns);
            PlanningNotificationListHelper.pushStateColumn(columns);
            PlanningNotificationListHelper.pushOrderCommentColumn(columns);
            PlanningNotificationListHelper.pushEnvironmentallyRelevantColumn(columns);    
        },            

        updatePlanningNotificationAuxiliaryData : function(planningNotificationInfo, applicationContext) {
            planningNotificationInfo._applicationContext = applicationContext;
            planningNotificationInfo._planningNotificationId = planningNotificationInfo.planningNotification.id;        
            planningNotificationInfo._planningNotificationTitle = planningNotificationInfo.planningNotification.title;
            planningNotificationInfo._planningNotificationComment = planningNotificationInfo.planningNotification.comment;
            planningNotificationInfo._project = this.projectFormatter(null, planningNotificationInfo);

            PlanningNotificationListHelper.updatePlanningNotificationMetaDataAuxiliaryData(planningNotificationInfo);       
        },

        updatePlanningNotificationMetaDataAuxiliaryData : function(planningNotificationInfo) {
            var metaTagIdToDateMetaInformation = planningNotificationInfo.metaTagIdToDateMetaInformations;
            for (var metaTagId in metaTagIdToDateMetaInformation) {
                var dateMetaInformations = planningNotificationInfo.metaTagIdToDateMetaInformations[metaTagId];
                var formatted = PlanningNotificationListHelper.maybeMultipleDateFormatter(dateMetaInformations, planningNotificationInfo);
                planningNotificationInfo["_metaTag" + metaTagId] = formatted;
            }
            
            var metaTagIdToTextMetaInformation = planningNotificationInfo.metaTagIdToTextMetaInformations;
            for (var metaTagId in metaTagIdToTextMetaInformation) {
                var textMetaInformations = planningNotificationInfo.metaTagIdToTextMetaInformations[metaTagId];
                var formatted = PlanningNotificationListHelper.maybeMultipleTextFormatter(textMetaInformations, planningNotificationInfo);
                planningNotificationInfo["_metaTag" + metaTagId] = formatted;
            }           
        },          

        updatePlanningNotificationColumns : function(listWidget, columnSettings, metaTags) {
            // Update the individual columns
            listWidget.updateColumn("title", columnSettings.showTitle);
            listWidget.updateColumn("notificationComment", columnSettings.showNotificationComment);
            listWidget.updateColumn("project", columnSettings.showProject);
            
            if (metaTags != null) {
                for (var n = 0; n < metaTags.length; n++) {
                    var metaTag = metaTags[n];
                    var show = "metaTagIdToShow" in columnSettings ? columnSettings.metaTagIdToShow[metaTag.id] : null;                             
                    listWidget.updateColumn(metaTag.cssClass, !!show);
                }             
            }             
        },            

        updatePlanningNotificationOrderAuxiliaryData : function(orderJoin, applicationContext) {        
            orderJoin._applicationContext = applicationContext;
            orderJoin._planningNotification = PlanningNotificationListHelper.planningNotificationFormatter(null, orderJoin);
            orderJoin._project = PlanningNotificationListHelper.projectFormatter(null, orderJoin);
            orderJoin._workflowNode = PlanningNotificationListHelper.workflowNodeFormatter(null, orderJoin);     
            orderJoin._tagString = PlanningNotificationListHelper.tagFormatter(null, orderJoin);
            orderJoin._siteTypeString = PlanningNotificationListHelper.siteTypeFormatter(null, orderJoin);
            orderJoin._workflowEntityStatusName = PlanningNotificationListHelper.workflowEntityStatusFormatter(null, orderJoin);
            orderJoin._reference = PlanningNotificationListHelper.referenceFormatter(null, orderJoin);
        },

        updatePlanningNotificationOrderColumns : function(listWidget, columnSettings) {
            listWidget.updateColumn("serialNumber", columnSettings.showSerialNumber);
            listWidget.updateColumn("text", columnSettings.showText);
            listWidget.updateColumn("planningNotification", columnSettings.showPlanningNotification);
            listWidget.updateColumn("project", columnSettings.showProject);
            listWidget.updateColumn("subjectArea", columnSettings.showSubjectArea);
            listWidget.updateColumn("authorizedInspector", columnSettings.showAuthorizedInspector);
            listWidget.updateColumn("reference", columnSettings.showReference);
            listWidget.updateColumn("statutoryDuty", columnSettings.showStatutoryDuty);
            listWidget.updateColumn("invalidated", columnSettings.showInvalidated);
            listWidget.updateColumn("workflowNode", columnSettings.showWorkflowNode);
            listWidget.updateColumn("state", columnSettings.showState);
            listWidget.updateColumn("documentPage", columnSettings.showDocumentPage);
            listWidget.updateColumn("documentPosition", columnSettings.showDocumentPosition);
            listWidget.updateColumn("source", columnSettings.showSource);
            listWidget.updateColumn("personInCharge", columnSettings.showPersonInCharge);
            listWidget.updateColumn("statutoryDutyFrom", columnSettings.showStatutoryDutyFrom);
            listWidget.updateColumn("statutoryDutyTo", columnSettings.showStatutoryDutyTo);
            listWidget.updateColumn("statutoryDutyInterval", columnSettings.showStatutoryDutyInterval);
            listWidget.updateColumn("statutoryDutyLeadTime", columnSettings.showStatutoryDutyLeadTime);
            listWidget.updateColumn("siteType", columnSettings.showSiteType);
            listWidget.updateColumn("statutoryDutyExpired", columnSettings.showStatutoryDutyExpired);
            listWidget.updateColumn("submitAuthority", columnSettings.showSubmitAuthority);
            listWidget.updateColumn("tag", columnSettings.showTag);
            listWidget.updateColumn("orderComment", columnSettings.showOrderComment);
            listWidget.updateColumn("environmentallyRelevant", columnSettings.showEnvironmentallyRelevant);
        },                  

        defaultBooleanFormatter : function(b, instance) {
            return b ? i18n.yes : i18n.no;
        },          

        dateFormatter : function(value, planningNotificationInfo) {
            if (value != null) {
                return DateHelper.formatUtcSecondsWithTimeZone(value, planningNotificationInfo._applicationContext.getTimeZone(), i18n.datePattern); 
            } else {
                return "";
            }
        },

        dateTimeFormatter : function(value, planningNotificationInfo) {
            if (value != null) {
                return DateHelper.formatUtcSecondsWithTimeZone(value, planningNotificationInfo._applicationContext.getTimeZone(), i18n.dateWithSecondsPattern); 
            } else {
                return "";
            }
        },

        maybeMultipleDateFormatter : function(value, planningNotificationInfo, applicationContext) {
            if (value == null) {
                return "";
            } else {
                var s = "";
                for (var n = 0; n < value.length; n++) {
                    //                                      if (this.mode == PlanningNotificationListWidget.Mode.DEFAULT) {
                    s += (value[n].value != null ? PlanningNotificationListHelper.dateFormatter(value[n].value, planningNotificationInfo, applicationContext) : "");                        
                    /*                  } else {
                        // Print the sharepoint dates directly, instead of first parsing, and then formatting them.
                        s += value[n].value != null ? value[n].value : "";                      
                    }                   */

                    if (n < value.length - 1) {
                        s += ", ";                      
                    }                       
                }

                return s;                   
            }               
        },


        maybeMultipleTextFormatter : function(value, planningNotificationInfo) {
            if (value == null) {
                return "";
            } else {
				value.sort(function(optionOne, optionTwo) {
					if (optionOne.value == null) {
						return 1;
					} else if (optionTwo.value == null) {
						return -1;
					} else {
						return optionOne.value.localeCompare(optionTwo.value);
					}			
				});		    
                var s = "";
                for (var n = 0; n < value.length; n++) {
                    s += value[n].value;
                    if (n < value.length - 1) {
                        s += ", ";                      
                    }                       
                }
                return s;                   
            }               
        },

        planningNotificationFormatter : function(planningNotificationId, orderJoin) {
            var baulosString = "";
            var baulosMetaInformations = orderJoin.baulosMetaInformations;
            if (baulosMetaInformations && baulosMetaInformations.length > 0) 
                var baulosString = PlanningNotificationListHelper.maybeMultipleTextFormatter(baulosMetaInformations, null);

            var baulosSuffix;
            if (baulosString.length > 0) {
                baulosSuffix = " / " + baulosString;
            } else {
                baulosSuffix = "";
            }                

            return orderJoin.planningNotificationTitle + baulosSuffix;
        },          

        taskFormatter : function(_taskString, taskJoin, omitMarkup) {
            var taskName = PlanningNotificationListHelper.getTaskName(taskJoin);
            var reviewerName = PlanningNotificationListHelper.getReviewerName(taskJoin);
            var baulosString = PlanningNotificationListHelper.getBaulosString(taskJoin);
            var initiatorName = PlanningNotificationListHelper.getInitiatorName(taskJoin);

            var taskStringWithMarkup = "<b>" + taskName + "</b><br>" + reviewerName + (baulosString.length > 0 ? "<br>[" + baulosString + "]" : "");
			
            return taskStringWithMarkup;
        },

        tokenInitiatorFormatter : function(_taskString, taskJoin, omitMarkup) {
        	//show only when initiatorWorkflowNodePositionId not ownerWorkflowNodePositionId
        	if (taskJoin.initiatorWorkflowNodePositionId != taskJoin.workflowTokenOwnerPositionId){
	            var initiatorName = PlanningNotificationListHelper.getInitiatorName(taskJoin);
	            var initiatorBaulosString = PlanningNotificationListHelper.getInitiatorBaulosString(taskJoin);
	
	            var tokenInitiatorStringWithMarkup = initiatorName + (initiatorBaulosString.length > 0 ? "<br>[" + initiatorBaulosString + "]" : "");
	            
	            return tokenInitiatorStringWithMarkup;
        	}else
        		return "-";
        },

        projectFormatter : function(_unused, taskJoin, omitMarkup) {
            var projectString = "";
            if (taskJoin.projects != null) {
                var projects = taskJoin.projects;
                for (var n = 0; n < projects.length; n++) {
                    if (omitMarkup) {
                        projectString += "(" + projects[n].code + ") " + projects[n].name + (n < projects.length - 1 ? ", " : "");
                    } else {
                        projectString += "<b>(" + projects[n].code + ")</b> " + projects[n].name + (n < projects.length - 1 ? ", " : "");             
                    }                   
                }
            } else if (taskJoin.projectJoins != null) {
                var projectJoins = taskJoin.projectJoins;
                for (var n = 0; n < projectJoins.length; n++) {
                    if (omitMarkup) {
                        projectString += "(" + projectJoins[n].projectCode + ") " + projectJoins[n].projectName + (n < projectJoins.length - 1 ? ", " : "");
                    } else {
                        projectString += "<b>(" + projectJoins[n].projectCode + ")</b> " + projectJoins[n].projectName + (n < projectJoins.length - 1 ? ", " : "");             
                    }                   
                }
            }                


            return projectString;               
        },

        tagFormatter : function(ignored, orderJoin) {
            var tagString = "";
            for (var n = 0; orderJoin.tags && n < orderJoin.tags.length; n++) {
                tagString += orderJoin.tags[n].label;
                if (n < orderJoin.tags.length - 1) {
                    tagString += ", ";
                }                  
            }

            return tagString;
        },         

        siteTypeFormatter : function(ignored, orderJoin) {
            var siteTypeString = "";
            for (var n = 0; orderJoin.siteTypes && n < orderJoin.siteTypes.length; n++) {
                siteTypeString += (orderJoin.siteTypes[n].name ? orderJoin.siteTypes[n].name : "");
                if (n < orderJoin.siteTypes.length - 1) {
                    siteTypeString += ", ";
                }                  
            }

            return siteTypeString;
        },         

        workflowNodeFormatter : function(planningNotificationOrderId, orderJoin) {
            var s = "";

            var workflowNodeJoins = orderJoin.workflowNodeJoins;
            if (workflowNodeJoins != null) {
                workflowNodeJoins.sort(function(joinOne, joinTwo) {
                    return joinOne.workflowNodeTemplatePosition - joinTwo.workflowNodeTemplatePosition;
                });
            }                   

            for (var n = 0; workflowNodeJoins != null && n < workflowNodeJoins.length; n++) {
                var workflowNodeJoin = workflowNodeJoins[n];
                s += "<b>" + workflowNodeJoin.workflowNodeTemplateName + "</b><br>";

                var workflowNodePositionJoins = orderJoin.workflowNodeIdToPositions[workflowNodeJoin.workflowNodeId];
                if (workflowNodePositionJoins == null || workflowNodePositionJoins.length == 0) {
                    s += "<i>" + i18n.planningNotificationOrderListNoPersonsInWorkflow + "</i><br>";
                } else {
                    for (var z = 0; z < workflowNodePositionJoins.length; z++) {
                        var workflowNodePositionJoin = workflowNodePositionJoins[z];
                        var inverseCommonName = NameHelper.getPersonInverseCommonName(workflowNodePositionJoin, "person");
                        var dueDate = workflowNodePositionJoin.workflowNodePositionDueDate;
                        var dueDateRemark = CodeHelper.getI18nDueDateRemark(workflowNodePositionJoin.workflowNodePositionDueDateRemark);
                        var optionalDueDate = workflowNodePositionJoin.workflowNodePositionOptionalDueDate;

                        var dueDateString = dueDate != null
                        ? DateHelper.formatUtcSecondsWithTimeZone(dueDate, orderJoin._applicationContext.getTimeZone(), i18n.datePattern)
                        : i18n.nothing;
                        var optionalDueDateString = optionalDueDate != null
                        ? DateHelper.formatUtcSecondsWithTimeZone(optionalDueDate, orderJoin._applicationContext.getTimeZone(), i18n.datePattern)
                        : i18n.nothing;                         


                        var baulose = orderJoin.workflowNodePositionIdToBaulose[workflowNodePositionJoin.workflowNodePositionId];
                        if (baulose == null || baulose.length == 0) {
                            if (optionalDueDate == null) {
                                s += inverseCommonName + " " + (dueDate != null ? dueDateString : (dueDateRemark ? dueDateRemark : "")) + "<br>";
                            } else {
                                s += inverseCommonName + " <span style='color:red;'>" + optionalDueDateString + "</span><br>";
                            }                               
                        } else {
                            for (var v = 0; v < baulose.length; v++) {
                                var baulosString = baulose[v].value;

                                if (optionalDueDate == null) {
                                    s += inverseCommonName + " [" + baulosString + "] "
                                    + (dueDate != null ? dueDateString : (dueDateRemark != null ? dueDateRemark : "")) + "<br>";
                                } else {
                                    s += inverseCommonName + " [" + baulosString + "] <span style='color:red;'>" + optionalDueDateString + "</span><br>";
                                }                               
                            }                           
                        }                           
                    }
                }                   
            }

            return s;           
        },

        workflowEntityStatusFormatter : function(ignored, orderJoin) {
            if (orderJoin.workflowEntityInvalidated) {
                return i18n.workflowStatusInvalidated;
            } else if (orderJoin.workflowEntityStatusName == null) {
                return i18n.workflowStatusNotInitialized;
            } else {
                return orderJoin.workflowEntityStatusName;
            }               
        },

        referenceFormatter : function(reference, orderJoin) {
            var referenceString = "";
            var referenceNumbers = [];
            
            var referenceInfos = orderJoin.referenceInfos;
            for (var n = 0; n < referenceInfos.length; n++) {
                var referenceInfo = referenceInfos[n];
                referenceNumbers.push(referenceInfo.planningNotificationOrder.serialNumber);
            }

            referenceNumbers.sort();

            for (var n = 0; n < referenceNumbers.length; n++) {
                referenceString += referenceNumbers[n];
                if (n < referenceNumbers.length - 1) {
                    referenceString += ", ";
                }                    
            }                    

            return referenceString;          
        },

        getTaskName : function(taskJoin) {
            return taskJoin.workflowNodeTemplateName != null ? taskJoin.workflowNodeTemplateName : i18n.nothing;
        },          

        getReviewerName : function(taskJoin) {
            var organisationName = taskJoin.organisationName != null ? taskJoin.organisationName : i18n.nothing;
            var personName = NameHelper.getPersonInverseCommonName(taskJoin, "person");
            return organisationName + " (" + personName + ")";
        },

        getBaulosString : function(taskJoin) {
            var baulosString = "";
            var baulose = taskJoin.workflowNodePositionBaulose;     
            for (var n = 0; n < baulose.length; n++) {
                baulosString += baulose[n].value;
                if (n < baulose.length - 1) {
                    baulosString += ", ";
                }
            }   

            return baulosString;
        },        

        getInitiatorName : function(taskJoin) {
            var organisationName = taskJoin.initiatorOrganisationName != null ? taskJoin.initiatorOrganisationName : i18n.nothing;
            var personName = NameHelper.getPersonInverseCommonName(taskJoin, "initiatorPerson");
            return organisationName + " (" + personName + ")";
        },

        getInitiatorBaulosString : function(taskJoin) {
            var baulosString = "";
            var baulose = taskJoin.workflowNodeInitiatorPositionBaulose;
            for (var n = 0; n < baulose.length; n++) {
                baulosString += baulose[n].value;
                if (n < baulose.length - 1) {
                    baulosString += ", ";
                }
            }   
            return baulosString;
        }
    };

    return PlanningNotificationListHelper;    
});
