/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = plotOrderTemplateChoose
//// i18n-prefix = plotOrderTemplateChoose

define([ 
    "cdes/plot/PlotOrderTemplateChooseWidget",
    "cdes/widget/ContextBar",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Button",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    PlotOrderTemplateChooseWidget,
    ContextBar,
    TinyLog,
    DOMHelper,
    ErrorHelper,
    ContentWidget,
    Button,    
    domClass,
    domConstruct,
    domStyle,
    string,    
    declare,
    lang,
    i18n
) {

    var className = "at.cdes.web.plot.PlotOrderTemplateChoosePage";

    var log = new TinyLog(className);

    var PlotOrderTemplateChoosePage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var serviceParams = {
                       projectId : this.applicationContext.getPageContextProjectId(),
                templateResolver : "ManualPlotTemplate"         
            };                

            var plotService = this.applicationContext.getService("plotService");
    	    this.registerAsyncOperationStarted(PlotOrderTemplateChoosePage.AsyncOperation.LOAD);
            plotService.getCreateManualPlotOrderData(organisationPersonId, this.documentVersionId, serviceParams).then(
                lang.hitch(this, function(createPlotOrderData) {
                    this.initialize(createPlotOrderData);
    	            this.registerAsyncOperationFinished(PlotOrderTemplateChoosePage.AsyncOperation.LOAD);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlotOrderTemplateChoosePage.AsyncOperation.LOAD,
                                opName : "getCreateManualPlotOrderData",
                               message : i18n.plotOrderTemplateChooseLoadFailed
                    });
                })
            ).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Error while calling function [getCreateManualPlotOrderData]", err);
                }));
        },

        getWidgetId : function() {
            return "PlotOrderTemplateChoosePage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        initialize : function(createPlotOrderData) {
            this.document = createPlotOrderData.document;
            this.documentRelease = createPlotOrderData.documentRelease;
            this.templateJoins = createPlotOrderData.templateJoins;
            this.templateIdToItemJoins = createPlotOrderData.templateIdToItemJoins;            

            var caption = string.substitute(i18n.plotOrderTemplateChooseCaption, {
                   documentName : this.document.name,
                documentContent : this.documentRelease!=null?this.documentRelease.content:this.document.content                
            });
            DOMHelper.setInnerText(this.captionDiv, caption);

            this.chooseWidgets = [];
            for (var n = 0; n < this.templateJoins.length; n++) {
                var templateJoin = this.templateJoins[n];
                var templateId = templateJoin.plottOrderTemplateId;
                var itemJoins = (templateId in this.templateIdToItemJoins ? this.templateIdToItemJoins[templateId] : []);                
                var chooseWidget = new PlotOrderTemplateChooseWidget({
                    applicationContext : this.applicationContext,
		              backPage : this.backPage,
		            backParams : this.backParams
                });
                var chooseWidgetTopDiv = chooseWidget.getContainer();
                domConstruct.place(chooseWidgetTopDiv, this.contentDiv);
                chooseWidget.setData({
                    documentVersionId : this.documentVersionId,
                         templateJoin : templateJoin,
                            itemJoins : itemJoins
                });
                this.chooseWidgets.push(chooseWidget);                
            }

            this.resize(this.lastResizeParameter);
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesSmallPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h3", "", captionBarDiv, "cdesGeneralPageCaption");

    	    this.backButton = new Button({
    		  label : i18n.back,
    		  title : i18n.back,
    		onClick : lang.hitch(this, this.goBack) 
    	    });
    	    domClass.add(this.backButton.domNode, "plotOrderTemplateChooseBackButton");
    	    domConstruct.place(this.backButton.domNode, captionBarDiv);

            return captionBarDiv;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute plotOrderTemplateChoosePageContentDiv");

            DOMHelper.createTextNode("h4", i18n.plotOrderTemplateChoosePleaseChooseLabel, contentDiv, "plotOrderTemplateChoosePleaseChooseDiv");

            return contentDiv;
        },

        resize : function(newSize) {
            this.lastResizeParameter = newSize;

            var totalHeight = newSize.h;

            var width = this.captionBarDiv.offsetWidth - 15;
            var contentHeight = totalHeight
                //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                - this.captionBarDiv.offsetHeight
                - 16;

            domStyle.set(this.contentDiv, "height", contentHeight + "px");

            if (this.chooseWidgets != null) {
                for (var n = 0; n < this.chooseWidgets.length; n++) {
                    this.chooseWidgets[n].resize({ w : width });
                }
            }
        },

        setData : function() {

        },

        reload : function() {
            //this.contextBar.reload();
        },

        updateWidgetState : function() {

        },

        goBack : function() {
            this.applicationContext.setPage("documentList", new Object(), new Object());
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    PlotOrderTemplateChoosePage.AsyncOperation = {
        LOAD : "Load"
    };

    return PlotOrderTemplateChoosePage;
});
