/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationSearch
////i18n-prefix = planningNotificationSearch



define([ "cdes/core/CdesVoc",
	"cdes/planning/util/PlanningNotificationHelper",         
	"cdes/planning/util/PlanningNotificationTitleMultiSearchWidget",
	"cdes/widget/CalendarSpinner",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateTimeSpinBox",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/IconTitlePane",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/Button",
	"dijit/form/ComboBox",
	"dijit/form/Select",
	"dijit/form/TextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/keys",
	"dojo/on",
	"dojo/store/Memory",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CdesVoc,
			PlanningNotificationHelper,
			PlanningNotificationTitleMultiSearchWidget,
			CalendarSpinner,
			TinyLog,
			DateTimeSpinBox,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			IconTitlePane,
			ContentWidget,
			Button,
			ComboBox,
			Select,
			TextBox,
			domClass,
			domConstruct,
			domStyle,
			Keys,
			on,
			Memory,
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.notification.PlanningNotificationSearchWidget";

	var log = new TinyLog(className);

	var PlanningNotificationSearchWidget = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			this.optionalFieldsVisible = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId],
					"/planningNotification/optionalSearchFieldsVisible");
			if (this.optionalFieldsVisible == null) {
				this.optionalFieldsVisible = false;
			}

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationSearchWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);
			domClass.add(topDiv, "refNodeOfPositionAbsolute planningNotificationSearchFull");

			this.titlePane = this.constructTitlePane();
			domConstruct.place(this.titlePane.domNode, topDiv);

			return topDiv;
		},

		postTitleClick : function() {
			var open = this.titlePane.get("open");

			if (open) {
				var fullClass = this.optionalFieldsVisible ? "planningNotificationSearchFullWithOptional" : "planningNotificationSearchFull";

				this.titlePane.set("title", i18n.searchOpenCaption);
				domClass.replace(this.topDiv, fullClass, "planningNotificationSearchReduced");
			} else {
				this.titlePane.set("title", i18n.searchClosedCaption);
				domClass.replace(this.topDiv, "planningNotificationSearchReduced", "planningNotificationSearchFull planningNotificationSearchFullWithOptional");
			}

			on.emit(this, "titlePaneToggled");
		},

		constructTitlePane : function() {
			this.contentDiv = this.constructEmptyContentDiv();

			var titlePane = new IconTitlePane({
				title   : i18n.searchOpenCaption,
				content : this.contentDiv,
				toggleable : true,
				open : true,
				postTitleClick : lang.hitch(this, this.postTitleClick)
			});
			domClass.add(titlePane.domNode, "occupyWholeParent");

			return titlePane;
		},

		constructEmptyContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationSearchContentDiv");

			return contentDiv;	    
		},

		fillContentDiv : function(metaTags, projectIdToProject) {
			this.propertyDiv = domConstruct.create("div", null, null);
			domClass.add(this.propertyDiv, "refNodeOfPositionAbsolute planningNotificationSearchPropertyDiv");
			domConstruct.place(this.propertyDiv, this.contentDiv);            

			// Title
			DOMHelper.createTextNode("div", i18n.planningNotificationSearchTitleLabel, this.propertyDiv, "propertyLabel planningNotificationSearchTitleLabel");
			this.planningNotificationMultiComboBox = new PlanningNotificationTitleMultiSearchWidget({
						label : i18n.planningNotificationColumnTitleLabel,
//				Use the tooltip of the PlanningNotificationTitleMultiSearchWidget
//				title : i18n.planningNotificationSearchTitleToolTip,
				comboBoxClass : "fixedDialogWidget planningNotificationSearchTitleSearchComboBox",
                selectOnClick : true
			});
			domClass.add(this.planningNotificationMultiComboBox.domNode, "fixedDialogWidget planningNotificationSearchTitleComboBox");
			domConstruct.place(this.planningNotificationMultiComboBox.domNode, this.propertyDiv);
			on(this.planningNotificationMultiComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 

			// Comment
			DOMHelper.createTextNode("div", i18n.planningNotificationColumnCommentLabel, this.propertyDiv, "propertyLabel planningNotificationSearchCommentLabel");
			this.notificationCommentTextBox = new TextBox({
				label : i18n.planningNotificationColumnCommentLabel,
				title : i18n.planningNotificationSearchCommentToolTip,
                selectOnClick : true
			});
			domClass.add(this.notificationCommentTextBox.domNode, "fixedDialogWidget planningNotificationSearchCommentTextBox");
			domConstruct.place(this.notificationCommentTextBox.domNode, this.propertyDiv);
			on(this.notificationCommentTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 

			// Project
			DOMHelper.createTextNode("div", i18n.planningNotificationColumnProjectLabel, this.propertyDiv, "propertyLabel planningNotificationSearchProjectLabel");
			this.projectSelect = new Select({
				label : i18n.planningNotificationColumnProjectLabel,
				title : i18n.planningNotificationColumnProjectToolTip
			});
			domClass.add(this.projectSelect.domNode, "fixedDialogWidget planningNotificationSearchProjectSelect");
			domConstruct.place(this.projectSelect.domNode, this.propertyDiv);
			on(this.projectSelect.domNode, "keyup", lang.hitch(this, this.searchIfEnter)); 
			WidgetHelper.handleSelectEvents(this.projectSelect, lang.hitch(this, this.handleProjectSelectChange));

			this.processProjectChange(projectIdToProject);

			this.idToMetaTagInfo = new Object();

			// Widgets shown always
			this.permanentDiv = domConstruct.create("div", null, null);
			domClass.add(this.permanentDiv, "refNodeOfPositionAbsolute planningNotificationSearchPermanentDiv");
			domConstruct.place(this.permanentDiv, this.contentDiv);

			this.constructSearchWidgets(metaTags, this.permanentDiv, 0);  // 0 = priority "show always"

			// Widgets shown optionally
			this.optionalDiv = domConstruct.create("div", null, null);
			domClass.add(this.optionalDiv, "refNodeOfPositionAbsolute planningNotificationSearchOptionalDiv");
			domConstruct.place(this.optionalDiv, this.contentDiv);

			this.constructSearchWidgets(metaTags, this.optionalDiv, 1); // 1 = priority "show optionally"            

			// Buttons
			this.buttonDiv = domConstruct.create("div", null, null);
			domClass.add(this.buttonDiv, "refNodeOfPositionAbsolute planningNotificationSearchButtonDiv");
			domConstruct.place(this.buttonDiv, this.contentDiv);            

			this.constructButtons();

			this.initialized = true;
		},	    

		constructSearchWidgets : function(metaTags, parentDiv, priorityFilter) {

			for (var n = 0; n < metaTags.length; n++) {
				var metaTag = metaTags[n];
				var priority = metaTag.priority;
				var cssClass = metaTag.cssClass;
				var cssRules = metaTag.cssRules;
				var name = metaTag.name;
				var tagFormat = metaTag.tagFormat;                

				if (cssClass == null) {
					log.error("Cannot place search widget for metaTag [" + name + "] since it has no css class; will ignore it.");
					continue;                    
				}                    

				document.getElementsByTagName("head")[0].appendChild(DOMHelper.createTextNode("style", cssRules)); 

				if (priority == priorityFilter) {
					if (tagFormat == 0) {    // TAG_FORMAT_TEXT
						var labelCssClass = "planningNotificationSearch" + cssClass + "Label";
						DOMHelper.createTextNode("div", name, parentDiv, "propertyLabel " + labelCssClass);

						var textBoxCssClass = "planningNotificationSearch" + cssClass + "TextBox";
						var textBox = new TextBox({
							label : name,
							title : i18n.planningNotificationSearchMetasToolTip,
            		selectOnClick : true                     
						});
						domClass.add(textBox.domNode, "fixedDialogWidget " + textBoxCssClass);
						domConstruct.place(textBox.domNode, parentDiv);
						on(textBox, "keyup", lang.hitch(this, this.searchIfEnter));

						this.idToMetaTagInfo[metaTag.id] = {
								metaTag : metaTag,
								primaryWidget : textBox,
								secondaryWidget : null
						};
					} else if (tagFormat == 1) {  // TAG_FORMAT_DATE
						var fromLabel = string.substitute(i18n.searchFrom, { label : name });

						var fromLabelCssClass = "planningNotificationSearch" + cssClass + "FromLabel";
						DOMHelper.createTextNode("div", fromLabel, parentDiv, "propertyLabel " + fromLabelCssClass);

						var fromSpinnerCssClass = "planningNotificationSearch" + cssClass + "FromSpinner";
						var fromSpinner = new CalendarSpinner({
							label : fromLabel,
							title : name,
							pattern : i18n.datePattern,
							timeZone : this.applicationContext.getTimeZone(),
							dndEnabled : false,
							rowObjectToString : null
						});
						domClass.add(fromSpinner.domNode, "fixedDialogWidget " + fromSpinnerCssClass);
						domConstruct.place(fromSpinner.domNode, parentDiv);
						on(fromSpinner, "keyup", lang.hitch(this, this.searchIfEnter));

						var toLabelCssClass = "planningNotificationSearch" + cssClass + "ToLabel";
						DOMHelper.createTextNode("div", i18n.searchTo, parentDiv, "propertyLabel " + toLabelCssClass);

						var toSpinnerCssClass = "planningNotificationSearch" + cssClass + "ToSpinner";
						var toSpinner = new CalendarSpinner({
							label : i18n.searchTo,
							title : name,
							pattern : i18n.datePattern,
							timeZone : this.applicationContext.getTimeZone(),
							dndEnabled : false,
							rowObjectToString : null                            
						});
						domClass.add(toSpinner.domNode, "fixedDialogWidget " + toSpinnerCssClass);
						domConstruct.place(toSpinner.domNode, parentDiv);
						on(toSpinner, "keyup", lang.hitch(this, this.searchIfEnter));

						this.idToMetaTagInfo[metaTag.id] = {
								metaTag : metaTag,
								primaryWidget : fromSpinner,
								secondaryWidget : toSpinner
						};
					} else {
						throw new Error("TagFormat [" + tagFormat + "] is not yet supported, see at.cdes.oldGwtDto.MetaTagDTO");
					}
				}
			}
		},

		constructButtons : function() {
			// ToggleOptionalFieldsButton
			this.toggleOptionalFieldsButton = new Button({
				label : i18n.hideAdditionalSearchFieldsButtonCaption,
				title : i18n.hideAdditionalSearchFieldsButtonCaption
			});            
			domClass.add(this.toggleOptionalFieldsButton.domNode, "planningNotificationSearchToggleOptionalFieldsButton");
			domConstruct.place(this.toggleOptionalFieldsButton.domNode, this.buttonDiv);
			on(this.toggleOptionalFieldsButton, "click", lang.hitch(this, this.doToggleOptionalFields));

			// ClearSearchFieldsButton
			this.clearSearchFieldsButton = new Button({
				label : i18n.clearSearchFieldsButtonCaption,
				title : i18n.clearSearchFieldsButtonToolTip
			});
			domClass.add(this.clearSearchFieldsButton.domNode, "planningNotificationSearchClearSearchFieldsButton");
			domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);
			on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));	    

			// SearchButton
			this.searchButton = new Button({
				label : i18n.searchButtonCaption,
				title : i18n.planningNotificationSearchSearchButtonToolTip
			});            
			domClass.add(this.searchButton.domNode, "planningNotificationSearchSearchButton");
			domConstruct.place(this.searchButton.domNode, this.buttonDiv);
			on(this.searchButton, "click", lang.hitch(this, this.doSearch));
		},            

		isAlreadyInitialized : function() {
			return this.initialized;
		},

		updateWidgetState : function() {

		},

		handleProjectSelectChange : function() {
			var projectId = WidgetHelper.getSelectValue(this.projectSelect);
			if (this.projectIdFromLocalStorage != null && projectId != this.projectIdFromLocalStorage) {
				this.projectIdFromLocalStorage = null;
			}		

			this.lastProjectId = PlanningNotificationHelper.handleProjectSelectChange(this.projectSelect, this.planningNotificationMultiComboBox,
					this.projectIdToPlanningNotifications, this.lastProjectId,
					this.projectIdFromLocalStorage != null);
		},

		processProjectChange : function(projectIdToProject) {
			PlanningNotificationHelper.processProjectChange({
				projectSelect : this.projectSelect, 
				projectIdToProject : projectIdToProject,
				addWhateverOption : true,
				noWhateverDefault : true                
			});
			this.lastProjectId = PlanningNotificationHelper.handleProjectSelectChange(this.projectSelect, this.planningNotificationMultiComboBox,
					this.projectIdToPlanningNotifications, this.lastProjectId);
		},            

		getSelectedProjectId : function() {
			var projectId = WidgetHelper.getSelectValue(this.projectSelect);
			if (projectId == CdesVoc.WHATEVER) {
				return null;
			} else {
				return projectId;
			}                
		},            

		initialize : function(metaTags, projectIdToProject, projectIdToPlanningNotifications) {
			this.projectIdToPlanningNotifications = projectIdToPlanningNotifications;
			if (metaTags != null) {
				// This case is triggered while setting up the widget.                
				this.fillContentDiv(metaTags, projectIdToProject);
				this.populateSearchFields();
			} else {
				// Lateron, we don't expect any changes regarding the metaTags, just the projects may change if the user chose another network                
				this.processProjectChange(projectIdToProject);
			}

			this.updateOptionalFieldVisibility();            
			this.isInitialized = true;
		},

		searchIfEnter : function(e) {
			if (e.keyCode == Keys.ENTER) {
				this.doSearch();
			}
		},

		updateShowOptionalFieldsButtonCaption : function() {
			var count = 0;

			for (var metaTagId in this.idToMetaTagInfo) {
				var metaTagInfo = this.idToMetaTagInfo[metaTagId];
				var metaTag = metaTagInfo.metaTag;
				var priority = metaTag.priority;
				var tagFormat = metaTag.tagFormat;

				if (priority == 1) {  // optional search fields

					if (tagFormat == CdesVoc.TagFormat.TEXT) {
						if (metaTagInfo.primaryWidget != null) {
							var text = metaTagInfo.primaryWidget.get("value");
							count += text != null && text.trim().length > 0 ? 1 : 0;                            
						}
					} else if (tagFormat == CdesVoc.TagFormat.DATE) {
						if (metaTagInfo.primaryWidget != null) {
							count += metaTagInfo.primaryWidget.getUtcSeconds() != null ? 1 : 0;
						}

						if (metaTagInfo.secondaryWidget != null) {
							count += metaTagInfo.secondaryWidget.getUtcSeconds() != null ? 1 : 0;
						}                        
					} else {
						throw new Error("Unsupported tagFormat [" + tagFormat + "]");
					}                    
				}                    
			}

			if (count == 0) {
				this.toggleOptionalFieldsButton.set("label", i18n.showAdditionalSearchFieldsButtonCaption);
				this.toggleOptionalFieldsButton.set("title", i18n.showAdditionalSearchFieldsButtonCaption);
			} else {
				var showCaption = string.substitute(i18n.showNumberedAdditionalSearchFieldsButtonCaption, {
					countActive : count
				});
				this.toggleOptionalFieldsButton.set("label", showCaption);
				this.toggleOptionalFieldsButton.set("title", showCaption);
			}
		},            

		clearSearchFields : function() {
			this.planningNotificationMultiComboBox.set("value", [], false);
			this.notificationCommentTextBox.set("value", "");
//			Deliberately no reset
			//            this.projectSelect.set("value", CdesVoc.WHATEVER);

			for (var metaTagId in this.idToMetaTagInfo) {
				var metaTagInfo = this.idToMetaTagInfo[metaTagId];
				var metaTag = metaTagInfo.metaTag;
				var tagFormat = metaTag.tagFormat;

				if (tagFormat == CdesVoc.TagFormat.TEXT) {
					if (metaTagInfo.primaryWidget != null) {
						metaTagInfo.primaryWidget.set("value", "");
					}
				} else if (tagFormat == CdesVoc.TagFormat.DATE) {
					if (metaTagInfo.primaryWidget != null) {
						metaTagInfo.primaryWidget.setUtcSeconds(null);
					}

					if (metaTagInfo.secondaryWidget != null) {
						metaTagInfo.secondaryWidget.setUtcSeconds(null);
					}                        
				} else {
					throw new Error("Unsupported tagFormat [" + tagFormat + "]");
				}                    
			}                

			this.updateOptionalFieldVisibility();
		},

		getSearchModel : function() {
			return PlanningNotificationHelper.getPlanningNotificationSearchModel(this);
		},            

		populateSearchFields : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotification/search");

			if (oldSearchModel != null) {
				var projectId = oldSearchModel.projectId == null ? CdesVoc.WHATEVER : oldSearchModel.projectId;

				// Not null until it is changed for the first time; as long as it is not null, the document titles will be kept
				// regardless of calls to handleProjectSelectChange		
				this.projectIdFromLocalStorage = projectId;

                            this.projectSelect.set("value", projectId, false);
                            this.handleProjectSelectChange();

				this.planningNotificationMultiComboBox.set("value", oldSearchModel.planningNotificationEntries);
				this.notificationCommentTextBox.set("value", oldSearchModel.comment);                            

				for (var textMetaTagId in oldSearchModel.textMetaTagIdToValue) {
					if (textMetaTagId in this.idToMetaTagInfo) {
						var metaTagInfo = this.idToMetaTagInfo[textMetaTagId];
						metaTagInfo.primaryWidget.set("value", oldSearchModel.textMetaTagIdToValue[textMetaTagId]);                    
					}
				}                    

				for (var dateMetaTagId in oldSearchModel.dateMetaTagIdToFrom) {
					if (dateMetaTagId in this.idToMetaTagInfo) {
						var metaTagInfoDate = this.idToMetaTagInfo[dateMetaTagId];
						metaTagInfoDate.primaryWidget.setUtcSeconds(oldSearchModel.dateMetaTagIdToFrom[dateMetaTagId]);
					}
				}                    

				for (var dateTwoMetaTagId in oldSearchModel.dateMetaTagIdToTo) {
					if (dateTwoMetaTagId in this.idToMetaTagInfo) {
						var metaTagInfoTwo = this.idToMetaTagInfo[dateTwoMetaTagId];
						metaTagInfoTwo.secondaryWidget.setUtcSeconds(oldSearchModel.dateMetaTagIdToTo[dateTwoMetaTagId]);
					}
				}                    
			}                
		},            

		doToggleOptionalFields : function() {
			this.optionalFieldsVisible = !this.optionalFieldsVisible;

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/optionalSearchFieldsVisible", this.optionalFieldsVisible);

			this.updateOptionalFieldVisibility();
		},            

		updateOptionalFieldVisibility : function() {
			if (this.optionalFieldsVisible) {
				domClass.replace(this.optionalDiv, "visible", "hidden");
				this.toggleOptionalFieldsButton.set("label", i18n.hideAdditionalSearchFieldsButtonCaption);
				this.toggleOptionalFieldsButton.set("title", i18n.hideAdditionalSearchFieldsButtonCaption);
				domClass.replace(this.topDiv, "planningNotificationSearchFullWithOptional", "planningNotificationSearchFull planningNotificationSearchReduced");
			} else {
				domClass.replace(this.optionalDiv, "hidden", "visible");                
				this.updateShowOptionalFieldsButtonCaption();
				domClass.replace(this.topDiv, "planningNotificationSearchFull", "planningNotificationSearchFullWithOptional planningNotificationSearchReduced");
			}
			on.emit(this, "titlePaneToggled");
		},            

		doSearch : function() {
			on.emit(this, "doSearch");
		}        
	});

	PlanningNotificationSearchWidget.AsyncOperation = {

	};

	return PlanningNotificationSearchWidget;
});
