/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationOrderExtract
////i18n-prefix = planningNotificationOrderExtract


define([ "cdes/planning/order/PlanningNotificationOrderEditWidget",
	"cdes/planning/order/PlanningNotificationOrderExtractWidget",
	"cdes/planning/util/PlanningNotificationHelper",
	"cdes/widget/ContextBar",
	"clazzes/TinyLog",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/FancyContentPane",
	"dijit/form/Button",
	"dijit/form/Select",
	"dijit/layout/ContentPane",
	"dijit/layout/BorderContainer",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(PlanningNotificationOrderEditWidget,
			PlanningNotificationOrderExtractWidget,
			PlanningNotificationHelper,
			ContextBar,
			TinyLog,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			FancyContentPane,
			Button,
			Select,
			ContentPane,                
			BorderContainer,
			domClass,
			domConstruct,
			domStyle,
			on,
			string,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.order.PlanningNotificationOrderExtractPage";

	var log = new TinyLog(className);

	var PlanningNotificationOrderExtractPage = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();
			this.loadEditInfo();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationOrderExtractPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		loadEditInfo : function() {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();

			this.registerAsyncOperationStarted(PlanningNotificationOrderExtractPage.AsyncOperation.LOAD_EDIT_INFO);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getPlanningNotificationOrderSearchInfo(organisationPersonId, networkId, true).then(
					lang.hitch(this, function(editInfo) {		    
						this.registerAsyncOperationFinished(PlanningNotificationOrderExtractPage.AsyncOperation.LOAD_EDIT_INFO);
						this.editInfo = editInfo;
						this.editWidget.setEditInfo(editInfo);
						this.reload();
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationOrderExtractPage.AsyncOperation.LOAD_EDIT_INFO,
							opName : "getPlanningNotificationOrderEditInfo",
							message : i18n.planningNotificationOrderEditPageGetEditInfoFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getPlanningNotificationOrderEditInfo]", err);
							}));
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentDiv = this.constructContentDiv();
			domConstruct.place(this.contentDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationOrderExtractPageCaption, captionBarDiv, "cdesGeneralPageCaption");

			return captionBarDiv;
		},

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "planningNotificationOrderExtractPageContentDiv");

			this.topContainer = new BorderContainer({
				design  : "headline",
				"class" : "occupyWholeParent"
			});

			this.extractWidget = new PlanningNotificationOrderExtractWidget({
				applicationContext : this.applicationContext
			});

			var extractWidgetTopDiv = this.extractWidget.getContainer();
			var extractContainer = new FancyContentPane({
				content : extractWidgetTopDiv,
				postResizeFunction : lang.hitch(this, this.postResizeExtractContentPane)		
			});
			domClass.add(extractContainer.domNode, "planningNotificationOrderExtractExtractContentPane");
			extractContainer.set("region", "top");
			extractContainer.set("splitter", true);
			this.topContainer.addChild(extractContainer);	    


			this.editWidget = new PlanningNotificationOrderEditWidget({
				applicationContext : this.applicationContext,
				mode : ContentWidget.Mode.CREATE,
				extract : true		
			});

			var editSectionDiv = domConstruct.create("div", null, null);
			domClass.add(editSectionDiv, "planningNotificationOrderExtractEditSectionDiv");
			on(this.editWidget, "validStateChange", lang.hitch(this, function() {
				this.updateWidgetState();
			}));

			var buttonDiv = this.constructButtonDiv();
			domConstruct.place(buttonDiv, editSectionDiv);	    

			var editWidgetIntermediateDiv = domConstruct.create("div", null, null);
			domClass.add(editWidgetIntermediateDiv, "fixedDialogWidget planningNotificationOrderExtractEditWidgetIntermediateDiv");
			domConstruct.place(editWidgetIntermediateDiv, editSectionDiv);

			var editWidgetTopDiv = this.editWidget.getContainer();
			domConstruct.place(editWidgetTopDiv, editWidgetIntermediateDiv);

			var editContainer = new ContentPane({
				content : editSectionDiv
			});
			editContainer.set("region", "center");
			domClass.add(editContainer.domNode, "planningNotificationOrderExtractEditContentPane");	    
			this.topContainer.addChild(editContainer);	    

			domConstruct.place(this.topContainer.domNode, contentDiv);
			this.topContainer.startup();
//			this.topContainer.resize({ w : 700, h : 500 });	    

			this.extractWidget.initializeEvents();

			return contentDiv;
		},

		postResizeExtractContentPane : function(changeSize, resultSize) {
			this.extractWidget.resize(changeSize);            
		},

		constructButtonDiv : function() {
			var buttonDiv = domConstruct.create("div", null, null);
			domClass.add(buttonDiv, "fixedDialogWidget planningNotificationOrderExtractButtonDiv");

			// Go left button
			this.goLeftButton = new Button({
				label : i18n.goLeftButtonCaption,
				title : i18n.planningNotificationOrderExtractGoLeftToolTip
			});
			domClass.add(this.goLeftButton.domNode, "planningNotificationOrderExtractGoLeftButton");
			domConstruct.place(this.goLeftButton.domNode, buttonDiv);
			on(this.goLeftButton, "click", lang.hitch(this, this.goLeft));

			this.pageNumberSelect = new Select({
				label : i18n.planningNotificationOrderExtractPageLabel,
				title : i18n.planningNotificationOrderExtractPageToolTip
			});
			domClass.add(this.pageNumberSelect.domNode, "planningNotificationOrderExtractPageNumberSpinner");	    
			domConstruct.place(this.pageNumberSelect.domNode, buttonDiv);
			WidgetHelper.handleSelectEvents(this.pageNumberSelect, lang.hitch(this, this.choosePageNumber));	    

			// Go right button
			this.goRightButton = new Button({
				label : i18n.goRightButtonCaption,
				title : i18n.planningNotificationOrderExtractGoRightToolTip
			});
			domClass.add(this.goRightButton.domNode, "planningNotificationOrderExtractGoRightButton");
			domConstruct.place(this.goRightButton.domNode, buttonDiv);
			on(this.goRightButton, "click", lang.hitch(this, this.goRight));

			// Choose and replace button
			this.chooseAndReplaceButton = new Button({
				label : i18n.planningNotificationOrderExtractChooseAndReplaceButtonCaption,
				title : i18n.planningNotificationOrderExtractChooseAndReplaceToolTip
			});
			domClass.add(this.chooseAndReplaceButton.domNode, "planningNotificationOrderExtractChooseAndReplaceButton");
			domConstruct.place(this.chooseAndReplaceButton.domNode, buttonDiv);

			on(this.chooseAndReplaceButton, "click", lang.hitch(this, this.chooseAndReplace));

			// Choose and replace button
			this.chooseAndAppendButton = new Button({
				label : i18n.planningNotificationOrderExtractChooseAndAppendButtonCaption,
				title : i18n.planningNotificationOrderExtractChooseAndAppendToolTip
			});
			domClass.add(this.chooseAndAppendButton.domNode, "planningNotificationOrderExtractChooseAndAppendButton");
			domConstruct.place(this.chooseAndAppendButton.domNode, buttonDiv);

			on(this.chooseAndAppendButton, "click", lang.hitch(this, this.chooseAndAppend));

			// Save button
			this.saveAndNextButton = new Button({
				label : i18n.planningNotificationOrderExtractSaveAndNextButtonCaption
				/*     		title : i18n.planningNotificationOrderExtractSaveAndNextToolTip*/     // ÖBB feedback: no tooltip necessary
			});
			domClass.add(this.saveAndNextButton.domNode, "planningNotificationOrderExtractSaveAndNextButton");
			domConstruct.place(this.saveAndNextButton.domNode, buttonDiv);

			on(this.saveAndNextButton, "click", lang.hitch(this, this.saveAndNext));

			// Save button
			this.saveAndExitButton = new Button({
				label : i18n.planningNotificationOrderExtractSaveAndExitButtonCaption
				/*     		title : i18n.planningNotificationOrderExtractSaveAndExitToolTip*/    // ÖBB feedback: no tooltip necessary
			});
			domClass.add(this.saveAndExitButton.domNode, "planningNotificationOrderExtractSaveAndExitButton");
			domConstruct.place(this.saveAndExitButton.domNode, buttonDiv);

			on(this.saveAndExitButton, "click", lang.hitch(this, this.saveAndExit));

			// Abort button
			this.abortButton = new Button({
				label : i18n.abortButtonCaption
				/*     		 title : i18n.abortToolTip */ // ÖBB feedback: no tooltip necessary
			});
			domClass.add(this.abortButton.domNode, "planningNotificationOrderExtractAbortButton");
			domConstruct.place(this.abortButton.domNode, buttonDiv);
			on(this.abortButton, "click", lang.hitch(this, this.abort));

			return buttonDiv;	    
		},	    

		goLeft : function() {
			this.gotoPage(this.page - 1);            
		},

		choosePageNumber : function() {
			var page = this.pageNumberSelect.get("value");
			if (page != null) {
				this.gotoPage(page);
			}
		},

		goRight : function() {
			this.gotoPage(this.page + 1);            
		},

		chooseAndReplace : function() {
			this.chooseText(lang.hitch(this, function(text) {
				this.editWidget.replaceText(text, this.page);
			}));
		},

		chooseAndAppend : function() {
			this.chooseText(lang.hitch(this, function(text) {
				this.editWidget.appendText(text, this.page);
			}));      
		},

		saveAndNext : function() {
			this.save(lang.hitch(this, function() {
				// Create a new orderJoin instance, populate the editWidget with its (more or less empty)
				// contents.  I.e. the user can now enter a new PlanningNotificationOrder.
				this.reload();
			}));
		},

		saveAndExit : function() {
			this.save(lang.hitch(this, function() {
				if (this.backPage != null) {
					this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
				}
			}));		
		},

		save : function(callbackFct) {
			this.orderJoin = this.editWidget.getData();

			PlanningNotificationHelper.saveOrUpdatePlanningNotificationOrder({
				applicationContext : this.applicationContext,
				widget : this,
				mode : ContentWidget.Mode.CREATE,
				asyncOperation : PlanningNotificationOrderExtractPage.AsyncOperation.SAVE,
				orderJoin : this.orderJoin,
				callbackFct : callbackFct
			});            
		},	    

		abort : function() {
			if (this.backPage != null) {
				this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
			}            
		},

		gotoPage : function(page) {
			if (page >= this.boundingBoxes.length) {
				page = this.boundingBoxes.length - 1;
			}
			if (page < 0) {
				page = 0;
			}

			if (page == this.page) {
				return;
			}		    

			if (this.boundingBoxes.length == 0) {
				this.extractWidget.setData({
					page : null
				});		    
			} else {
				var boundingBox = this.boundingBoxes[page];
				var width = boundingBox.upperRightX - boundingBox.lowerLeftX;
				var angle = boundingBox.angle;
				var height = boundingBox.upperRightY - boundingBox.lowerLeftY;
				this.extractWidget.setData({
					urlPrefix : this.urlPrefix,
					planningNotificationId : this.id,		    
					page : page,
					x0 : boundingBox.lowerLeftX,
					y0 : boundingBox.lowerLeftY,		    
					width : angle == 90 || angle == 270 ? height : width,
							height : angle == 90 || angle == 270 ? width : height,
									angle : angle
				});		    
			}		

			this.page = page;
			this.pageNumberSelect.set("value", this.page, false);
			this.updateWidgetState();
		},	    

		chooseText : function(callbackFct) {
			var page = this.extractWidget.getPage();
			var boundingBox = this.extractWidget.getBoundingBox();
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

			this.registerAsyncOperationStarted(PlanningNotificationOrderExtractPage.AsyncOperation.CHOOSE_TEXT);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.extractTextFromPlanningNotificationDocument(organisationPersonId, this.id, page, boundingBox).then(
					lang.hitch(this, function(text) {
						log.info("Finished extracting for boundingBox, received text [" + text + "]", boundingBox);
						this.registerAsyncOperationFinished(PlanningNotificationOrderExtractPage.AsyncOperation.CHOOSE_TEXT);

						callbackFct(text);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationOrderExtractPage.AsyncOperation.CHOOSE_TEXT,
							opName : "extractTextFromPlanningNotificationDocument",
							message : i18n.planningNotificationOrderExtractTextFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [extractTextFromPlanningNotificationDocument]", err);
							}));
		},	    

		resize : function(newSize) {
			var totalHeight = newSize.h;

			var contentWidth = this.captionBarDiv.offsetWidth - 15;
			var contentHeight = totalHeight
			- this.captionBarDiv.offsetHeight
			- 20;

			domStyle.set(this.contentDiv, "height", contentHeight + "px");
			this.topContainer.resize({ w : contentWidth, h : contentHeight });
		},

		setData : function() {

		},

		reload : function() {
			this.orderJoin = PlanningNotificationHelper.createEmptyPlanningNotificationOrderJoin();

			// Find a matching project for the planning notification at hand; currently
			// our assumption is that there can exist just one, although the datamodel
			// would allow more.	    
			var projectId = null;
			for (var currProjectId in this.editInfo.projectIdToPlanningNotifications) {
				var planningNotifications = this.editInfo.projectIdToPlanningNotifications[currProjectId];
				for (var n = 0; n < planningNotifications.length; n++) {
					if (planningNotifications[n].id == this.id) {
						projectId = currProjectId;
						break;			
					}			
				}		    
			}		

			this.orderJoin.projects = [ this.editInfo.projectIdToProject[projectId] ];
			this.orderJoin.planningNotificationId = this.id;

			this.editWidget.setData({
				orderJoin : this.orderJoin,
				mayChangePlanningNotification : false
			});		    
			this.editWidget.updateWidgetState();

			if (this.boundingBoxes == null) {
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

				this.registerAsyncOperationStarted(PlanningNotificationOrderExtractPage.AsyncOperation.GET_BOUNDING_BOXES);
				var planningNotificationService = this.applicationContext.getService("planningNotificationService");
				planningNotificationService.getBoundingBoxesForPlanningNotificationDocument(organisationPersonId, this.id).then(
						lang.hitch(this, function(extractInfo) {		    
							this.registerAsyncOperationFinished(PlanningNotificationOrderExtractPage.AsyncOperation.GET_BOUNDING_BOXES);
							this.boundingBoxes = extractInfo.boundingBoxes;
							this.urlPrefix = extractInfo.urlPrefix;

							var options = [];
							for (var n = 0; n < this.boundingBoxes.length; n++) {
								var label = string.substitute(i18n.planningNotificationOrderExtractPageSelectLabel, {
									pageNumber : (n + 1),
									numberOfPages : this.boundingBoxes.length
								});
								options.push({
									label : label,
									value : n				
								});
							}			    

							this.pageNumberSelect.set("options", options);
							WidgetHelper.setSelectValue(this.pageNumberSelect, options.length > 0 ? options[0].value : null);

							if (this.boundingBoxes.length > 0) {
								this.gotoPage(0);
							}			
						}),
						lang.hitch(this, function(err) {
							ErrorHelper.processAsyncError({
								err : err,
								widget : this,
								asyncOperation : PlanningNotificationOrderExtractPage.AsyncOperation.GET_BOUNDING_BOXES,
								opName : "getBoundingBoxesForPlanningNotificationDocument",
								message : i18n.planningNotificationOrderExtractPageGetBoundingBoxesFailed
							});
						})).otherwise(
								lang.hitch(this, function(err) {
									log.error("Error while calling function [getBoundingBoxesForPlanningNotificationDocument]", err);
								}));
			}
		},

		updateWidgetState : function() {
			var allFieldsValid = this.editWidget.isValid();

			var asyncOperationRunning = this.isAsyncOperationRunning();
			this.goLeftButton.set("disabled", asyncOperationRunning || this.page <= 0);
			this.goRightButton.set("disabled", asyncOperationRunning || this.page >= (this.boundingBoxes != null ? this.boundingBoxes.length - 1 : 0));
			this.chooseAndReplaceButton.set("disabled", asyncOperationRunning);
			this.chooseAndAppendButton.set("disabled", asyncOperationRunning);
			this.saveAndNextButton.set("disabled", asyncOperationRunning || !allFieldsValid);
			this.saveAndExitButton.set("disabled", asyncOperationRunning || !allFieldsValid);
		},

		destroy : function() {
			this.inherited(arguments);
		}
	});

	PlanningNotificationOrderExtractPage.AsyncOperation = {
			GET_BOUNDING_BOXES : "GetBoundingBoxes",
			CHOOSE_TEXT : "ChooseText",	
			LOAD_EDIT_INFO : "LoadEditInfo",
			SAVE : "Save"	
	};

	return PlanningNotificationOrderExtractPage;
});
