define([ 
        "cdes/core/CdesVoc",
        "cdes/pdc/PlanDeliverHelper",
        "cdes/util/SearchPageHelper",
        "cdes/widget/CalendarSpinner",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/dateTime/DateTimeSpinBox",
        "clazzes/util/DOMHelper",
        "clazzes/util/StringHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/IconTitlePane",
        "dijit/form/Button",
        "dijit/form/ComboBox",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/Evented",
        "dojo/keys",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/store/Memory",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         CdesVoc,
         PlanDeliverHelper,
         SearchPageHelper,
    	 CalendarSpinner,
    	 TinyLog,
    	 DateHelper,
    	 DateTimeSpinBox,
    	 DOMHelper,
    	 StringHelper,
         WidgetHelper,
    	 IconTitlePane,
    	 Button,
    	 ComboBox,
    	 TextBox,
    	 domClass,
    	 domConstruct,
    	 Evented,
    	 Keys,
    	 on,
    	 string,
    	 declare,
    	 lang,
    	 Memory,
    	 i18n
    	 ) {
    
    var className = "at.cdes.web.plan.PlanDeliverSearchWidget";

    var log = new TinyLog(className);
    
    var PlanDeliverSearchWidget = declare(className, Evented, {
    	
    	constructor : function(params) {
    	    lang.mixin(this,params);
    	    
    	    this.searchFieldsInitialized = false;
    	    this.topDiv = this.constructTopDiv();

    	    this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    	    return "PlanDeliverSearchWidget";
    	},
    	
    	getDataId : function() {
    	    return null;
    	},
    	
    	getContainer : function() {
    	    return this.topDiv;
    	},
    	
    	constructTopDiv : function() {
    	    var topDiv = domConstruct.create("div", null, null);
    	    domClass.add(topDiv, "refNodeOfPositionAbsolute planDeliverSearchTopDivFull");
    	    
    	    this.titlePane = this.constructTitlePane();
    	    domConstruct.place(this.titlePane.domNode, topDiv);
    	    
    	    return topDiv;
    	},
    	
    	postTitleClick : function() {
    	    var open = this.titlePane.get("open");
    	    if (open) {
    		this.titlePane.set("title", i18n.searchOpenCaption);
    		domClass.replace(this.topDiv, "planDeliverSearchTopDivFull", "planDeliverSearchTopDivReduced");
    	    } else {
    		this.titlePane.set("title", i18n.searchClosedCaption);
    		domClass.replace(this.topDiv, "planDeliverSearchTopDivReduced", "planDeliverSearchTopDivFull");
    	    }
    	    on.emit(this, "titlePaneToggled");
    	},
    	
     	constructTitlePane : function() {
     	    var searchDiv = this.constructSearchDiv();
     	    
	    var titlePane = new IconTitlePane({
		       title   : i18n.searchOpenCaption,
    		       content : searchDiv,
		    toggleable : true,
			  open : true,
		postTitleClick : lang.hitch(this, this.postTitleClick)
	    });
	    domClass.add(titlePane.domNode, "occupyWholeParent");
	    
	    return titlePane;
     	},
     	
     	getObjectMemoryData : function() {
     	    var data = [];
     	    if (this.objects) {
     		for (var n = 0; n < this.objects.length; n++) {
     		    data.push({
     			name : this.getObjectLine(this.objects[n]),
     			  id : this.objects[n].id
     		    });
     		}
     		
    		data.sort(lang.hitch(this, function(optionOne, optionTwo) {
    		    return optionOne.name.localeCompare(optionTwo.name);
    		}));     			
     	    }
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
     	    return data;
     	},
     	
     	getObjectPlannerMemoryData : function(object) {
     	    var data = [];
     	    
     	    if (this.objectPlanners) {
     		for (var n = 0; n < this.objectPlanners.length; n++) {
     		    if (this.objectPlanners[n].objectId == object.id) {
     			data.push({
     			    name : this.getObjectPlannerLine(this.objectPlanners[n]),
     			      id : this.objectPlanners[n].id
     			});
     		    }
     		}
     		
    		data.sort(lang.hitch(this, function(optionOne, optionTwo) {
    		    return optionOne.name.localeCompare(optionTwo.name);
    		}));     			
     	    }
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
     	    return data;
     	},
     	
     	constructSearchDiv : function() {
     	    var searchDiv = domConstruct.create("div", null, null);
     	    domClass.add(searchDiv, "refNodeOfPositionAbsolute planDeliverSearchDiv");
     	    
     	    // Document number
     	    DOMHelper.createTextNode("div", i18n.planDeliverSearchDocumentNumberLabel, searchDiv, "propertyLabel planDeliverSearchDocumentNumberLabel");
     	    this.documentNumberTextBox = new TextBox({
			     		label : i18n.planDeliverSearchDocumentNumberLabel,
			     		title : i18n.planDeliverSearchDocumentNumberToolTip,
                selectOnClick : true
     	    });
     	    domClass.add(this.documentNumberTextBox.domNode, "fixedDialogWidget planDeliverSearchDocumentNumberTextBox");     		
     	    domConstruct.place(this.documentNumberTextBox.domNode, searchDiv);
     	    on(this.documentNumberTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     	    
     	    // Document title
     	    DOMHelper.createTextNode("div", i18n.planDeliverSearchDocumentNameLabel, searchDiv, "propertyLabel planDeliverSearchDocumentNameLabel");
			     	    this.documentNameTextBox = new TextBox({
			     		label : i18n.planDeliverSearchDocumentNameLabel,
			     		title : i18n.planDeliverSearchDocumentNameToolTip,
                selectOnClick : true
     	    });    
     	    domClass.add(this.documentNameTextBox.domNode, "fixedDialogWidget planDeliverSearchDocumentNameTextBox");     		
     	    domConstruct.place(this.documentNameTextBox.domNode, searchDiv);
     	    on(this.documentNameTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     	    
     	    // Object
    	    this.objectMemory = new Memory({
    		data : this.getObjectMemoryData()
    	    });     		
     	    
     	    DOMHelper.createTextNode("div", i18n.planDeliverSearchObjectLabel, searchDiv, "propertyLabel planDeliverSearchObjectLabel");
     	    this.objectComboBox = new ComboBox({
			     	   label : i18n.planDeliverSearchObjectLabel,
			     	   title : i18n.planDeliverSearchObjectToolTip,
			     	   store : this.objectMemory,
   				   queryExpr : "*${0}*", //any search string
				autoComplete : false,
               selectOnClick : true
     	    });
     	    domClass.add(this.objectComboBox.domNode, "fixedDialogWidget planDeliverSearchObjectComboBox");     		
     	    domConstruct.place(this.objectComboBox.domNode, searchDiv); 
     	    on(this.objectComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     	    WidgetHelper.handleComboBoxEvents(this.objectComboBox, lang.hitch(this, this.objectSelectionChanged));
     	    
     	    // ObjectPlanner
     	    this.objectPlannerMemory = new Memory({
     		data : []
     	    });
     	    
     	    DOMHelper.createTextNode("div", i18n.planDeliverSearchObjectPlannerLabel, searchDiv, "propertyLabel planDeliverSearchObjectPlannerLabel");
     	    this.objectPlannerComboBox = new ComboBox({
			     		label : i18n.planDeliverSearchObjectPlannerLabel,
			     		title : i18n.planDeliverSearchObjectPlannerToolTip,
			     		store : this.objectPlannerMemory,
   				    queryExpr : "*${0}*", //any search string
				 autoComplete : false,
               selectOnClick : true
     	    });
     	    domClass.add(this.objectPlannerComboBox.domNode, "fixedDialogWidget planDeliverSearchObjectPlannerComboBox");     		
     	    domConstruct.place(this.objectPlannerComboBox.domNode, searchDiv); 
     	    on(this.objectPlannerComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));     		
     	    
     	    // From
     	    DOMHelper.createTextNode("div", i18n.planDeliverSearchFromLabel, searchDiv, "propertyLabel planDeliverSearchFromLabel");
     	    this.fromSpinner = new CalendarSpinner({
     			    label : i18n.planDeliverSearchFromLabel,
     			    title : i18n.planDeliverSearchFromToolTip,
        		  pattern : i18n.datePattern,
        	       dndEnabled : false,
                rowObjectToString : null
        	
                //        		        width : 150
        	
     	    });
     	    domClass.add(this.fromSpinner.domNode, "fixedDialogWidget planDeliverSearchFromSpinner");
     	    domConstruct.place(this.fromSpinner.domNode, searchDiv);
     	    on(this.fromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));     		     		     		     		     		
     	    
     	    // To
     	    DOMHelper.createTextNode("div", i18n.planDeliverSearchToLabel, searchDiv, "propertyLabel planDeliverSearchToLabel");
     	    this.toSpinner = new CalendarSpinner({
     			    label : i18n.planDeliverSearchToLabel,
     			    title : i18n.planDeliverSearchToToolTip,
     			  pattern : i18n.datePattern,
     		       dndEnabled : false,
     	        rowObjectToString : null
     	    });
     	    domClass.add(this.toSpinner.domNode, "fixedDialogWidget planDeliverSearchToSpinner");
     	    domConstruct.place(this.toSpinner.domNode, searchDiv);
     	    on(this.toSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     	    
            // Role
            DOMHelper.createTextNode("div", i18n.planDeliverSearchRoleLabel, searchDiv, "propertyLabel planDeliverSearchRoleLabel");
            this.roleMemory = new Memory({
                data : []
            });
            this.roleComboBox = new ComboBox({
		                label : i18n.planDeliverSearchRoleLabel,
		                title : i18n.planDeliverSearchRoleToolTip,
		     			store : this.roleMemory,
   				    queryExpr : "*${0}*", //any search string
				 autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.roleComboBox.domNode, "fixedDialogWidget planDeliverSearchRoleComboBox");
            domConstruct.place(this.roleComboBox.domNode, searchDiv);
            on(this.roleComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            WidgetHelper.handleComboBoxEvents(this.roleComboBox, lang.hitch(this, this.roleComboBoxChanged));

     	    // Planner
    	    this.plannerMemory = new Memory({
    		data : PlanDeliverHelper.getPlannerMemoryData(this.organisationPersonIdToJoins)
    	    });
     	    
     	    DOMHelper.createTextNode("div", i18n.planDeliverSearchPlannerLabel, searchDiv, "propertyLabel planDeliverSearchPlannerLabel");
     	    this.plannerComboBox = new ComboBox({
			     		label : i18n.planDeliverSearchPlannerLabel,
			     		title : i18n.planDeliverSearchPlannerToolTip,
			     		store : this.plannerMemory,
   				    queryExpr : "*${0}*", //any search string
				 autoComplete : false,
               selectOnClick : true
     	    });
     	    domClass.add(this.plannerComboBox.domNode, "fixedDialogWidget planDeliverSearchPlannerComboBox");     		
     	    domConstruct.place(this.plannerComboBox.domNode, searchDiv);
     	    on(this.plannerComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     	    
            SearchPageHelper.setComboBoxValue(this.plannerComboBox, CdesVoc.MagicSelectOption.ALL);

     	    // Search Button     		
     	    this.searchButton = new Button({
     		label : i18n.searchButtonCaption,
     		title : i18n.planDeliverSearchSearchButtonToolTip
     	    });
     	    domClass.add(this.searchButton.domNode, "fixedDialogWidget planDeliverSearchSearchButton");
     	    domConstruct.place(this.searchButton.domNode, searchDiv);            
     	    
     	    on(this.searchButton, "click", lang.hitch(this, this.doSearch));

            // ClearSearchFieldsButton
            this.clearSearchFieldsButton = new Button({
                label : i18n.clearSearchFieldsButtonCaption,
                title : i18n.clearSearchFieldsButtonToolTip
            });
            domClass.add(this.clearSearchFieldsButton.domNode, "fixedDialogWidget planDeliverSearchClearSearchFieldsButton");
            domConstruct.place(this.clearSearchFieldsButton.domNode, searchDiv);
            on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));                        

     	    return searchDiv;
     	},
     	
        roleComboBoxChanged : function() {
            var cdesRoleId = SearchPageHelper.getAllableComboBoxId(this.roleComboBox);
            
            if (cdesRoleId != this.cdesRoleId) {
                var plannerMemoryData = PlanDeliverHelper.getPlannerMemoryData(this.organisationPersonIdToJoins, cdesRoleId);
                this.plannerMemory.setData(plannerMemoryData);
                this.cdesRoleId = cdesRoleId;
            }
        },

     	setPersonJoins : function(personJoins) {
            this.organisationPersonIdToJoins = PlanDeliverHelper.setPersonRoleJoinsForSearchComboBox({
                personRoleJoins : personJoins,
                  plannerMemory : this.plannerMemory                        
            });                        
     	},
     	
     	getPersonLine : function(personJoin, roleString) {
	    var givenName = personJoin.personGivenName ? personJoin.personGivenName : "";
 	    var surName = personJoin.personSurName ? personJoin.personSurName : "";
 	    var organisation = personJoin.organisationName ? personJoin.organisationName : "";
 	    
            // 				return givenName + " " + surName + " (" + organisation + ")";
 	    return organisation + " (" + givenName + " " + surName + ") [" + roleString + "]";
     	},
     	
     	getObjectLine : function(object) {
     	    var objectType = (object.objectTypeId != null ? this.objectTypeIdToObjectType[object.objectTypeId] : null);
     	    var objectTypeSuffix = (objectType != null ? objectType.code : "");
     	    return object.code + objectTypeSuffix + " " + object.name;
     	},
     	
     	getObjectPlannerLine : function(objectPlanner) {
     	    return objectPlanner.code + " " + objectPlanner.area;
     	},
     	
     	setObjects : function(objects, objectTypeIdToObjectType) {
     	    this.objects = objects;
     	    this.objectTypeIdToObjectType = objectTypeIdToObjectType;
     	    this.objectMemory.setData(this.getObjectMemoryData());
     	    
     	},
     	
        setRoles : function(cdesRoles) {
            this.roleMemoryData = PlanDeliverHelper.getRoleMemoryData(cdesRoles);
            this.roleMemory.setData(this.roleMemoryData);
        },        

     	objectSelectionChanged : function() {
     	    if (this.objectComboBox.item != null && this.objectComboBox.item.id != null) {
     		var objectPlannerId = this.objectPlannerComboBox.item != null ? this.objectPlannerComboBox.item.id : null;
     		var objectPlannerItemArray = objectPlannerId != null ? this.objectPlannerComboBox.store.query({ id : objectPlannerId }) : null;
     		var objectPlanner = (objectPlannerItemArray != null && objectPlannerItemArray.length > 0 ? objectPlannerItemArray[0] : null);
     		
     		var itemArray = this.objectComboBox.store.query({ id : this.objectComboBox.item.id });
    		var object = (itemArray.length > 0 ? itemArray[0] : null);    			
    		
    		this.objectPlannerMemory.setData(this.getObjectPlannerMemoryData(object));
    		
    		if (objectPlanner != null) {
    		    if (object == null) {
                        SearchPageHelper.setComboBoxValue(this.objectPlannerComboBox, CdesVoc.MagicSelectOption.ALL);
    		    } else {
    			var fullObjectPlanner = this.objectPlannerIdToObjectPlanner[objectPlanner.id];
    			if (fullObjectPlanner == null || fullObjectPlanner.objectId != object.id) {
                            SearchPageHelper.setComboBoxValue(this.objectPlannerComboBox, CdesVoc.MagicSelectOption.ALL);
    			}
    		    }
    		}    			
     	    }
     	},
     	
     	setObjectPlanners : function(objectPlanners) {
     	    this.objectPlanners = objectPlanners;
     	    
     	    this.objectPlannerIdToObjectPlanner = new Object();
     	    for (var n = 0; n < this.objectPlanners.length; n++) {
     		this.objectPlannerIdToObjectPlanner[this.objectPlanners[n].id] = this.objectPlanners[n];
     	    }
     	},
     	
     	setDocumentListId : function(documentListId) {
     	    this.documentListId = documentListId;
     	},
     	
     	getSearchModel : function() {
 	    var searchModel = {
		     documentNumber : this.documentNumberTextBox.get("value"),
		       documentName : this.documentNameTextBox.get("value"),
		documentVersionFrom : this.fromSpinner.getUtcSeconds(),
		  documentVersionTo : this.toSpinner.getUtcSeconds()
	    };
	    
            // Role
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.roleComboBox, searchModel,
                                                                  "cdesRoleId", "cdesRoleName");

            // The same code can be found in DocumentSearchWidget, might be placed in some helper
            if (SearchPageHelper.isComboBoxSetToAll(this.plannerComboBox)) {
                searchModel.plannerOrgPersonId = null;
                searchModel.plannerName = null;
            } else if (this.plannerComboBox.item && this.plannerComboBox.item.id) {
                searchModel.plannerName = null;
		if (this.plannerComboBox.item.id == CdesVoc.UserCategory.OWN_USER) {
		    searchModel.plannerOrgPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		} else {
		    searchModel.plannerOrgPersonId = this.plannerComboBox.item.id;
		}
	    } else {
                searchModel.plannerOrgPersonId = null;
		searchModel.plannerName = this.plannerComboBox.get("value");
	    }
	    
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.objectComboBox, searchModel,
                                                                  "objectReleaseId", "objectReleaseString");

            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.objectPlannerComboBox, searchModel,
                                                                  "objectPlannerReleaseId", "objectPlannerReleaseString");            

	    return searchModel;
     	},

     	// TODO: Add function to dojo-clazzes
     	setComboBoxItem : function(comboBox, givenId, givenStr) {
     	    // summary:
     	    //     Sets the given comboBox to the item with the given id, if given and such an item exists.
     	    //     If not, the given string is set as ComboBox value.
     	    // comboBox: dijit/form/ComboBox
     	    //     any ComboBox
     	    // givenId: 
     	    //     id of some ComboBox item; may be null
     	    // givenStr: String
     	    //     string value to be set in the ComboBox, if no item can be found; may be null
     	    
    	    var item;
    	    if (givenId != null) {
    		var itemArray = comboBox.store.query({ id : givenId });
    		item = (itemArray.length > 0 ? itemArray[0] : null);
    	    } else {
    		item = null;
    	    }

    	    if (item != null) {
    		comboBox.set("value", item.name);
    		comboBox.item = item; 
    	    } else if (givenStr != null) {
    		comboBox.set("value", givenStr);
    	    }		
     	},
     	
     	populateSearchFields : function() {
    	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    	    var networkId = this.applicationContext.getPageContextNetworkId();
    	    var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planDeliver/search");
    	    
    	    if (oldSearchModel != null) {
        	var from = oldSearchModel.documentVersionFrom != null ? oldSearchModel.documentVersionFrom : null;
        	var to = oldSearchModel.documentVersionTo != null ? oldSearchModel.documentVersionTo : null;
        	
        	this.documentNumberTextBox.set("value", oldSearchModel.documentNumber);
        	this.documentNameTextBox.set("value", oldSearchModel.documentName);        		
        	
        	if (from != null) {
        	    this.fromSpinner.setUtcSeconds(from, false);	
        	}
        	if (to != null) {
        	    this.toSpinner.setUtcSeconds(to, false);	
        	}
        	
                // The same code is placed also in DocumentSearchWidget, and might be placed into some helper function in future.
                var plannerOrgPersonId = oldSearchModel.plannerOrgPersonId;
                var plannerName = oldSearchModel.plannerName;                
                var ownOrganisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

                SearchPageHelper.setSearchModelValueToAllableComboBox(oldSearchModel, this.roleComboBox,
                                                                      "cdesRoleId", "cdesRoleName");

                if (plannerOrgPersonId == ownOrganisationPersonId) {
     	            this.plannerComboBox.set("value", i18n.ownUser);
                    this.plannerComboBox.item = this.plannerComboBox.store.query({ id : CdesVoc.UserCategory.OWN_USER })[0];
                } else if (plannerOrgPersonId != null) {
                    var item = this.plannerComboBox.store.query({ id : plannerOrgPersonId })[0];
                    if (item == null) {
                        // If an organisationPersonId stored previously is no longer available, instead fall back to "me"
     	                this.plannerComboBox.set("value", i18n.ownUser);
                        this.plannerComboBox.item = this.plannerComboBox.store.query({ id : CdesVoc.UserCategory.OWN_USER })[0];
                    } else {
                        this.plannerComboBox.set("value", item != null ? item.name : null);
                        this.plannerComboBox.item = this.plannerComboBox.store.query({ id : plannerOrgPersonId })[0];
                    }
                } else if (plannerName == null) {
                    SearchPageHelper.setComboBoxValue(this.plannerComboBox, CdesVoc.MagicSelectOption.ALL);
                } else {
                    this.plannerComboBox.set("value", plannerName);

                    if (plannerName == i18n.allOption) {
                        SearchPageHelper.setComboBoxValue(this.plannerComboBox, CdesVoc.MagicSelectOption.ALL);
                    }                    
                }

                SearchPageHelper.setSearchModelValueToAllableComboBox(oldSearchModel, this.objectComboBox,
                                                                      "objectReleaseId", "objectReleaseString");
        	//reload objectPlannerComboBox.store
        	this.objectSelectionChanged();

                SearchPageHelper.setSearchModelValueToAllableComboBox(oldSearchModel, this.objectPlannerComboBox,
                                                                      "objectPlannerReleaseId", "objectPlannerReleaseString");
    	    }
     	},
     	
     	searchIfEnter : function(e) {
 	    if (e.keyCode == Keys.ENTER) {
 		this.doSearch();
 	    }
     	},      	
     	
     	doSearch : function(documentListReleaseId) {
	    on.emit(this, "doSearch");
     	},

        clearSearchFields : function() {
            this.documentNameTextBox.set("value", "");
            this.documentNumberTextBox.set("value", "");
            SearchPageHelper.setComboBoxValue(this.objectComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.objectPlannerComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.roleComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.plannerComboBox, CdesVoc.MagicSelectOption.ALL);
            this.fromSpinner.setUtcSeconds(null);
            this.toSpinner.setUtcSeconds(null);
        }
    });
    
    return PlanDeliverSearchWidget;
});
